;***********************************************************************/
;*	clpagset.asm                                                  */
;***********************************************************************/
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC

@BIGMODEL EQU 0
PSEG

ENDIF

;
;******************************************************************************
;
;
;    CLPAGESET SETS THE BIOS ACTIVE_PAGE DATA AREA TO THE PASSED
;    NUMBER. THIS HAS THE EFFECT OF FOOLING THE BIOS TO WRITE TO
;    OR READ FROM A DISPLAY PAGE OTHER THAN THE ACTIVE PAGE --
;    THIS CAN BE CALLED THE REFERENCE PAGE. IN ADDITION TO THE
;    ACTIVE_PAGE, THE PROC ALSO SETS THE CRT_START DATA AREA WHICH
;    POINTS TO THE START OF THE PAGE IN THE REGEN BUFFER. THE
;    COMPLIMENTARY PROC IS CLPAGGET WHICH RETURNS THE VALUES.
;
;
	ASSUME DS:NOTHING
	PUBLIC	CLPAGSET
IF @BIGMODEL+LPROG
	CLPAGSET PROC	FAR
	BIGOFF	EQU	2
ELSE
	CLPAGSET PROC	NEAR
	BIGOFF	EQU	0
ENDIF
	PUSH BP
	MOV BP,SP
	PUSH AX
	PUSH CX
	PUSH DX
        PUSH ES
	MOV AL,[BIGOFF+BP+4]	;MOVE PAGE NO. TO AH

	MOV SI,BIOS_DATA	;MAKE BIOS DATA SEGMENT ADDRESSABLE
	MOV ES,SI
	MOV ES:ACTIVE_PAGE,AL	;MOVE ACTIVE PAGE TO BIOS DATA VARIABLE

	MOV CX,ES:CRT_LEN	;GET REGEN BUFFER LENGTH
	CBW
	MUL CX			;MULTIPLY PAGE BY REGEN LENGTH TO GET
				;CRT_START (POSITION IN DISPLAY BUFFER)

	MOV ES:CRT_START,AX	;LOW PRODUCT IS SUFFICIENT BECAUSE RESULT
				;SHOULD BE 16K OR LESS
	POP ES
	POP DX
	POP CX
	POP AX
	POP BP
	RET
CLPAGSET ENDP
;
;
;
;**************************************************************************
;
IFDEF CI_C86

@CODE	ENDS

ELSE

ENDPS

ENDIF
	END

