+ARCHIVE+ 8087com.asm   1409 10/01/1984 15:02:10
;	common math routines (with or without 8087)

	include	model.h

;	floating point routines

	include	prologue.h

if	@bigmodel
a1	equ	@ab+16
a2	equ	a1+8
else
a1	equ	@ab+14
a2	equ	a1+8
endif

savreg:
if	@bigmodel
	push	es
endif
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	mov	bp,sp
if	@bigmodel
	jmp	word ptr 16[bp]
else
	jmp	word ptr 14[bp]
endif

resreg:
if	@bigmodel
	pop	16[bp]
else
	pop	14[bp]		;get the return address
endif
	mov	sp,bp
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
if	@bigmodel
	pop	es
endif
	ret

;	load a double to the stack

;	entry	address of double on stack
;	exit	double on stack

	public	$dload

if	@bigmodel
$dload	proc	far
	sub	sp,4
	call	savreg
	les	ax,dword ptr a1[bp]
	mov	a1-4[bp],ax
	mov	a1-2[bp],es
	les	si,dword ptr a1+4[bp]
	mov	ax,es:6[si]		;put exponent
	mov	a1+6[bp],ax
	mov	ax,es:4[si]
	mov	a1+4[bp],ax
	mov	ax,es:2[si]
	mov	a1+2[bp],ax
	mov	ax,es:[si]		;least significant word
	mov	a1[bp],ax
else
$dload	proc	near
	sub	sp,6
	call	savreg
	mov	ax,a1+4[bp]		;save the return address
	mov	a1-2[bp],ax
	mov	si,a1+6[bp]
	mov	ax,6[si]		;put exponent
	mov	a1+6[bp],ax
	mov	ax,4[si]
	mov	a1+4[bp],ax
	mov	ax,2[si]
	mov	a1+2[bp],ax
	mov	ax,[si]		;least significant word
	mov	a1[bp],ax
endif
	call	resreg
	ret
$dload	endp

	include	epilogue.h

	end
+ARCHIVE+ atof.c        1190 10/12/1984 14:51:06
/*	ascii to floating point
*/

/*	 NOTE- this routine not fully tested WARNING
*/

double atof(string)
unsigned char *string;
{
  int base;			/* conversion base */
  long val;			/* an integer value */
  double dval;			/* the same for double */
  double power;			/* for exponent conversion */
  int sign;			/* sign flag */
  int fflag;
  int ic;

  dval=0.0;
  while(*string==' '||*string=='\t')++string;	/* skip white */
  if(*string=='-'){
    sign=1;
    ++string;
  } else sign=0;
  fflag=1;
  for(;ic=*string;++string){
    if(isdigit(ic))dval=dval*10.0+(ic-'0');
    else if(ic=='.' && fflag)fflag=base=0;
    else break;
    --base;
  }
  if(fflag)base=0; else ++base;
  if(sign)dval=-dval;
  if(tolower(ic)=='e'){
    ic=*++string;
    if(ic=='-'){fflag=1;ic=*++string;}
    else {fflag=0;if(ic=='+'){ic=*++string;}}
    for(val=0;isdigit(ic=*string);++string)val=val*10+(ic-'0');
    if(fflag)base=base-val;
    else base=base+val;
  }
  sign=1;
  if(base<0)base=-base; else sign=0;
  for(power=10;base;base>>=1){
    if(base&1)
      if(sign)dval=dval/power;
      else dval=dval*power;
    power=power*power;
  }
  return dval;
}
+ARCHIVE+ dtos.c        4250 10/12/1984 14:51:04
/*      convert floating point value to string 
	return length of string converted 

	CAUTION: This is an unpublished function.  We may change it's 
	arguments in the future, etc.  If you use it, beware of future 
	releases. We suggest you use FTOA or SPRINTF, etc to get the 
	job done. 
*/ 

/*

  remove the definition of  EXTENDED if you want
  the exponent of E format to be 2 character places
  instead of 3 (e.g.) 1.0E45 instead of 1.0E045

*/
#define EXTENDED		

dtos(d,sbuff,prec,cc)
double d;               	/* floating point to convert */ 
unsigned char *sbuff;   	/* buffer to store result */
short prec;		 	/* no. fractional places */
unsigned char cc;  	  	/* conversion code (e,f, or g) */
{
short base;			/* the number base */
short efmt;			/* true if E format required */ 
short len;              	/* length of string */ 
unsigned char *cp; 

#ifdef	EXTENDED 
#define PAD 3     	     	/* number of digits in exponent */ 
#else 
#define PAD 2  
#endif 


  base=_dscale(&d,0);
  efmt=((cc=='e')||((cc=='g')&&(base>=5||base<=-5))||(base>=20)); 
  base+=_dscale(&d,efmt?prec+2:prec+base+2); 
  if(base>=20)efmt=1; 
  cp=sbuff+_dtos(d,sbuff,efmt?1:base+1,prec); 
  if(efmt){ 
    *cp++='E'; 
    if(base<0){*cp++='-'; base=-base;} 
    else *cp++='+';
    if((len=ltos((long)base,cp,10))<PAD){     /* left pad */
	movmem(cp,cp+PAD-len,len+1); 
	setmem(cp,PAD-len,'0'); 
    } 
   } 
   else if(cc=='g'){ 
     while(*--cp=='0')*cp=0; 	/* remove trailing zeroes */
     if(*cp=='.')*cp=0;      	/* remove '.' */
   }
   return strlen(sbuff);
}


/*	increased accuracy power of ten table
*/

static unsigned int pgiten[]={
	0X0000,0X0000,0X0000,0X4024,		/* 1e1 */
	0X0000,0X0000,0X0000,0X4059,		/* 1e2 */
	0X0000,0X0000,0X8800,0X40C3,		/* 1e4 */
	0X0000,0X0000,0XD784,0X4197,		/* 1e8 */
	0X8000,0X37E0,0XC379,0X4341,		/* 1e16 */
	0X6E17,0XB505,0XB8B5,0X4693,		/* 1e32 */
	0XF9F6,0XE93F,0X4F03,0X4D38,		/* 1e64 */
	0X1D33,0XF930,0X7748,0X5A82,		/* 1e128 */
	0XBF3F,0X7F73,0X4FDD,0X7515		/* 1e256 */
};
static double *pgten=pgiten;

static unsigned int pliten[]={
	0X999A,0X9999,0X9999,0X3FB9,		/* 1e-1 */
	0X147B,0X47AE,0X7AE1,0X3F84,		/* 1e-2 */
	0X432D,0XEB1C,0X36E2,0X3F1A,		/* 1e-4 */
	0X8C3A,0XE230,0X798E,0X3E45,		/* 1e-8 */
	0X89BC,0X97D8,0XD2B2,0X3C9C,		/* 1e-16 */
	0XA732,0XD5A8,0XF623,0X3949,		/* 1e-32 */
	0XA73C,0X44F4,0X0FFD,0X32A5,		/* 1e-64 */
	0X979A,0XCF8C,0XBA08,0X255B,		/* 1e-128 */
	0X6F40,0X64AC,0X0628,0X0AC8		/* 1e-256 */
};
static double *plten=pliten;

static double ZERO=0.0,ONE=1.0,TEN=10.0;

static _dscale(valp,round)
double *valp;				/* value to scale */
int round;
{
  int pow=0,sign,j,*ps,*pd;
  double val,roundval;

  if((val=*valp)<ZERO){ 
	val=-val; 
	sign=1; 
  } 
  else sign=0; 

  if(val==ZERO || round<0)return 0;
  if(round){
    if(round>16)round=16;		/* the real limit should be 15 ? */
    for(roundval=5.0;--round;)roundval*=1.0e-1;
    val+=roundval;
  }
  if(val>=TEN){
    for(j=9;j--;){
      pow<<=1;
      if(val>=pgten[j]){
	val*=plten[j];
	++pow;
      }
    }
  } else if(val<ONE){
    for(j=9;j--;){
      pow<<=1;
      if(val<plten[j]){
	val*=pgten[j];
	--pow;
      }
    }
    if(val<ONE){
      val*=TEN;
      --pow;
    }
  }
  roundval=0;
  pd=&roundval;
  ps=&val;
  pd[3]=(ps[3]&0x7ff0)-(52<<4);
  val+=roundval;
  if(val>=TEN || val<ONE)pow+=_dscale(&val,0);
  *valp=sign?-val:val;
  return pow;
}

static _dtos(val,string,iplace,fplace)
double val;			/* the value to convert */
unsigned char *string;
int iplace;			/* number of integer places */
int fplace;			/* the number of fractional places */
{
  unsigned char *cp;
  int j;

  cp=string;
  if(val<ZERO){
    val=-val;
    *cp++='-';
  }
  if(iplace<1){
    *cp++='0';
    *cp++='.';
    fplace+=iplace;
    if(fplace<0){iplace-=fplace;fplace=0;}
    while(iplace++<0)*cp++='0';
  } else {
    do {
      j=val;
      *cp++=j+'0';
      val=(val-j)*TEN;
    } while(--iplace);
    if(fplace)*cp++='.';
  }
  while(fplace--){
    j=val;			/* get the integer part */
    *cp++=j+'0';
    val=(val-j)*TEN;
  }
  *cp=0;
  return cp-string;
}

+ARCHIVE+ fabs.asm       447 10/01/1984 15:02:10
; 	fabs.asm, doesn't need 8087

	include model.h
	include prologue.h

	public	fabs

if	@bigmodel
fabs	proc	far
else
fabs	proc	near			; Absolute value function.
endif

	push	bp			; Save BP.
	mov	bp,sp			; Address the stack through BP.
	mov	ax,word ptr @ab[bp]
	mov	dx,word ptr @ab+2[bp]
	mov	bx,word ptr @ab+4[bp]
	mov	cx,word ptr @ab+6[bp] 
	and	ch,7fh			; 0 sign bit
	pop	bp 
	ret 

fabs	endp

	include epilogue.h
	end
+ARCHIVE+ ftoa.c         474 10/12/1984 14:51:06
/*	convert double to ascii
*/

ftoa(d,s,iplace,fplace)
double d;               	/* value to convert */
unsigned char *s;       	/* the string to store result in */ 
unsigned iplace;		/* number of integer places */ 
unsigned fplace;		/* number of fractional places */ 
{
short len,diff;
   
  len=dtos(d,s,fplace,'e');     /* use e format */ 
  if((diff=iplace+fplace+5-len)>0){ 
	movmem(s,s+diff,len+1); 
	setmem(s,diff,' '); 
  } 
  return strlen(s);
}

+ARCHIVE+ yfmtin.c      5645 10/12/1984 14:51:06
/*	format data into memory - used by scanf et al
*/

/*	remove the definition EXTENDED to remove extended features
*/

#define EXTENDED

/*	remove the definition FLOATS to remove floating point options
*/

#define FLOATS

#include "stdio.h"

union ptr_union{
  char *scp;
  unsigned char *ucp;
  int *sip;
  unsigned *uip;
  long *slp;
  unsigned long *ulp;
#ifdef	FLOATS
  float *sfp;
  double *sdp;
#endif 
};

/*	read the next character for _fmtin
*/

static int ic;			/* the current character */
static unsigned char *rnc_arg;
static unsigned rnc_code;

static rnc()
{

  ic=0;
  if(rnc_code){if(!(ic=*rnc_arg++))ic=EOF;}
  else ic=fgetc(rnc_arg);
}

/*	unget the current character
*/

static ugc()
{

  if(rnc_code)--rnc_arg;
  else ungetc(ic,rnc_arg);
}

/*	makes it shorter
*/

static iswhite(cc)
int cc;
{

  return (cc==' ' || cc=='\t' || cc=='\n' || cc=='\r');
}

/*	format a string
*/

_fmtin(code,funarg,format,argp)
int code;			/* function to get a character */
unsigned char *funarg;		/* an argument for the function */
unsigned char *format;		/* the format control string */
union ptr_union *argp;		/* our argument list */
{
  int count=0;			/* number of items done */
  int base;			/* conversion base */
  long val;			/* an integer value */
#ifdef FLOATS
  static double ZERO=0.0,TEN=10.0; 
  double dval;			/* the same for double */
  double power;			/* for exponent conversion */
#endif
  int sign;			/* sign flag */
  int do_assgn;			/* assignment suppression flag */
  unsigned width;		/* width of field */
  int widflag;			/* width was specified */
  int longflag;			/* true if long */
  int sav_ic;
  int sav_arg;
  int sav_cod;
  int fflag;
  int dataflag;			/* true if we have seen some data */

  sav_ic=ic;
  sav_arg=rnc_arg;
  sav_cod=rnc_code;
  rnc_arg=funarg;
  rnc_code=code;
  rnc();			/* read the next character */
  if(ic==EOF){
    count=EOF;
    goto quit;
  }
  while(1){
    while(iswhite(*format))++format;	/* skip whitespace */
    if(!*format)goto all_done;		/* end of format */
    if(ic<0)goto quit;			/* seen an error */
    if(*format!='%'){
litmatch:
      while(iswhite(ic))rnc();
      if(ic!=*format)goto all_done;
      ++format;
      rnc();
      ++count;
      continue;
    }
    ++format;
    do_assgn=1;
    if(*format=='*'){++format;do_assgn=0;}
    if(isdigit(*format)){
      widflag=1;
      for(width=0;isdigit(*format);)width=width*10+*format++-'0';
    } else widflag=0;		/* no width spec */
    if(longflag=(tolower(*format)=='l'))++format;
#ifdef EXTENDED
    else if(*format=='h')++format;
#endif
    if(*format!='c')while(iswhite(ic))rnc();
    dataflag=0;				/* not seen nothing yet */
    switch(*format){
      case 'b': case 'B': 
	base=2;
	goto decimal;
      case 'o': case 'O': 
	base=8;
	goto decimal;
      case 'u': case 'U': 
      case 'd': case 'D': 
	base=10;
	goto decimal;
      case 'x': case 'X': 
	base=16;
	if(((!widflag) || width>=2) && ic=='0'){
	  rnc();
	  if(tolower(ic)=='x'){
	    width-=2;
	    dataflag=1;
	    rnc();
	  } else {
	    ugc();
	    ic='0';
	  }
	}
decimal:
	if(!longflag)longflag=(*format>='A'&&*format<='Z'); 
	val=0;				/* our result value */
	sign=0;				/* assume positive */
	if(!widflag)width=0xffff;	/* very wide */
	if(width && ic=='+')rnc();
	else if(width && ic=='-'){
	  sign=1;
	  rnc();
	}
	while(width--){
	  if(isdigit(ic) && ic-'0'<base)ic-='0';
	  else if(base==16 && tolower(ic)>='a' && tolower(ic)<='f')
	    ic=tolower(ic)-87;
	  else break;
	  val=val*base+ic;
	  rnc();
	  dataflag=1;
	}
	if(do_assgn){
	  if(sign)val=-val;
	  if(longflag)*(argp++)->ulp=val;
	  else *(argp++)->uip=val;
	}
	if(dataflag)++count;
	else goto all_done;
	break;
      case 'c':
	if(!widflag)width=1;
	while(width-- && ic>=0){
	  if(do_assgn)*argp->ucp++=ic;
	  rnc();
	  dataflag=1;
	}
	if(do_assgn)argp++;		/* done with this one */
	if(dataflag)++count;
	break;
      case 's':
	if(!widflag)width=0xffff;
	while(width-- && !iswhite(ic) && ic>0){
	  if(do_assgn)*argp->ucp++=ic;
	  rnc();
	  dataflag=1;
	}
	if(do_assgn)*(argp++)->ucp=0;	/* terminate the string */
	if(dataflag)++count;
	else goto all_done;
	break;
#ifdef	FLOATS
      case 'E':
      case 'F':
	longflag=1;
      case 'e':
      case 'f':
	if(!widflag)width=0xffff;
	dval=ZERO;
	if(width && ic=='-'){
	  --width;
	  sign=1;
	  rnc();
	  dataflag=1;
	} else sign=0;
	if(!width)goto store_fe;
	base=0;
	fflag=1;
	while(width--){
	  if(isdigit(ic))dval=dval*TEN+(ic-'0');
	  else if(ic=='.' && fflag)fflag=base=0;
	  else break;
	  dataflag=1;
	  --base;
	  rnc();
	}
	if(fflag)base=0; else ++base;
	if(sign)dval=-dval;
	if(tolower(ic)=='e' && width){
	  rnc();
	  if(!--width)goto store_fe;
	  if(!width)goto store_fe;
	  if(ic=='-'){fflag=1;--width;rnc();}
	  else {fflag=0;if(ic=='+'){--width;rnc();}}
	  for(val=0;width && isdigit(ic);--width){val=val*10+(ic-'0');rnc();}
	  if(fflag)base=base-val;
	  else base=base+val;
	}
	sign=1;
	if(base<0)base=-base; else sign=0;
	for(power=TEN;base;base>>=1){
	  if(base&1)
	    if(sign)dval=dval/power;
	    else dval=dval*power;
	  power=power*power;
	}
store_fe:
	if(do_assgn)
	  if(longflag)*(argp++)->sdp=dval;
	  else *(argp++)->sfp=dval;
	if(dataflag)++count;
	else goto all_done;
	break;
#endif
    }
    ++format;
  }
all_done:
  if(ic>=0)ugc();			/* restore the character */
quit:
  ic=sav_ic;
  rnc_arg=sav_arg;
  rnc_code=sav_cod;
  return count;
}
+ARCHIVE+ yfmtout.c     3290 10/12/1984 14:51:08
/*	format data under control of a format string
*/

/*	to remove the floating point code, comment out
	the definition of FLOATS
*/

#define FLOATS

/*	to remove the extensions added to K&R, comment out
	the definition of EXTENDED
*/

#define EXTENDED


_fmtout(func,funarg,string,ip)
int (*func)();
unsigned funarg;
unsigned char *string;
int *ip;
{
  unsigned char tbuff[128],*cp,**cpp;
  int base;
  int is_number;
  unsigned leftadj,padchar,width,precflg,precisn,longflg,length;
  long *lp;
  union {long tlong;unsigned long tulong;}lw;
#ifdef	FLOATS 
  double *dp; 
#endif 

  while(*string){
    if(*string!='%'){
      for(cp=string;*++cp && *cp!='%';);
      (*func)(funarg,string,(unsigned)(cp-string));/* print the characters */
      string=cp;
    } else {
#ifdef EXTENDED
      is_number=1;
#endif
      if(leftadj=(*++string=='-'))++string;
      padchar=*string;
      if(padchar=='0')++string; else padchar=' ';
#ifdef EXTENDED
      if(*string=='*'){
	width=*ip++;			/* width is an argument */
	++string;
      } else
#endif
      for(width=0;isdigit(*string);)width=width*10+(*string++-'0');
      if(precflg=(*string=='.')){
	++string;
#ifdef EXTENDED
	if(*string=='*'){
	  precisn=*ip++;		/* precisn is an argument */
	  ++string;
	} else
#endif
	for(precisn=0;isdigit(*string);)precisn=precisn*10+(*string++-'0');
      } else precisn=0;
      if(longflg=(tolower(*string)=='l'))++string;

      switch(*string){
#ifdef FLOATS
	case 'e': case 'f': case 'g': 
	  if(!precflg)precisn=6;
	  dp=ip; 
	  length=dtos(*dp++,cp=tbuff,precisn,*string); 
	  ip=dp; 
	  break; 
#endif
	case 'B':
	case 'b':
	  base=2;
	  goto nosign;
	case 'O':
	case 'o':
	  base=8;
	  goto nosign;
	case 'U':
	case 'u':
	  base=10;
	  goto nosign;
	case 'X':
	case 'x':
	  base=16;
	  goto nosign;
	case 'D':
	case 'd':
	  base=-10;
nosign:
	  if(!longflg)longflg=(*string>='A'&&*string<='Z'); 
	  if(longflg){lp=ip;lw.tlong=*lp++;ip=lp;}
	  else if(base<0)lw.tlong=(long)(*ip++);
	  else lw.tulong=(unsigned)(*ip++);
	  ltos(lw.tlong,tbuff,base);
#ifdef EXTENDED
	  if(precflg){
	    cp=tbuff;
	    if(lw.tlong<0)++cp;
	    length=strlen(cp);
	    if(precisn && length<precisn+1){
	      movmem(cp,cp+precisn+1-length,length+1);
	      setmem(cp,precisn+1-length,'0');
	      length=precisn+1;
	    }
	    movmem(cp+length-precisn,cp+length-precisn+1,precisn+1);
	    cp[length-precisn]='.';
	  }
#endif
	  length=strlen(cp=tbuff);
	  break;
	case 's':
	  cpp=ip; 
	  length=strlen(cp=*cpp++);
	  ip=cpp; 
	  if(precflg && precisn<length)length=precisn;
	  is_number=0;			/* leave minus signs alone */
	  break;
	case 'c':
	  cp=ip++;
	  length=1;
	  is_number=0;
	  break;
	default:
	  cp=string;
	  length=1;
	  is_number=0;
	  break;
      }
      if(!leftadj && width>length){
#ifdef EXTENDED
	if(is_number && *cp=='-' && padchar=='0'){
	  (*func)(funarg,cp++,1);
	  --length;
	  --width;
	}
#endif
	while(width-- >length) (*func)(funarg,&padchar,1);
      }
      if(width>length)width-=length; else width=0;
      (*func)(funarg,cp,length);
      if(leftadj && width)
	while(width--) (*func)(funarg,&padchar,1);
      ++string;
    }
  }
}
