+ARCHIVE+ clearerr.c     236 10/01/1984 15:39:46
/*	reset the error indication for a file
*/

#include "stdio.h"
#include "fileio.h"

clearerr(stream)
FILE *stream;
{
  struct bufstr *buf,*_checkfd();

  buf=_checkfd(fileno(stream));
  if(buf)buf->buf_flag&=~BF_ERROR;
}
+ARCHIVE+ close.c        628 10/01/1984 15:39:44
/*	close a file
*/

#include "stdio.h"
#include "fileio.h"

extern struct bufstr *_checkfd();

close(fd)
unsigned fd;
{
  unsigned status;
  struct bufstr *buf;
  struct regval srv;

#ifdef _C86_BIG
  if(fflush((long)(fd+0x8000L)))return -1;	/* some error */
#else
  if(fflush(fd+0x8000))return -1;		/* some error */
#endif
  buf=_checkfd(fd);
  if(buf->buf_flag&BF_DOS2){
    srv.ax=0x3e00;
    srv.bx=buf->buf_handle;
    sysint21(&srv,&srv);
  }
  if(~((unsigned)buf->buf_flag) & BF_CDEV)free(buf->buf_fcb);
  if(buf->buf_data)free(buf->buf_data);
  free(buf);
  _opentab[fd]=0;
  return 0;
}
+ARCHIVE+ creat.c        189 10/01/1984 15:39:46
/*	create a new file, deleting any existing file
*/

creat(filename,mode)
char *filename;
unsigned mode;
{

  return _open(filename,mode,7);	/* do common open for a new file */
}
+ARCHIVE+ fclose.c       143 10/01/1984 15:39:46
/*	close a buffered file and free storage
*/

#include "stdio.h"

fclose(stream)
FILE *stream;
{

  return close(fileno(stream));
}
+ARCHIVE+ feof.c         193 10/01/1984 15:39:52
#include <stdio.h>
/* return 0 if it's not currently EOF
*/
feof(stream)
FILE *stream;
{
short c;

   if((c=fgetc(stream))==EOF) return EOF;
   ungetc(c,stream);
   return 0;
}


+ARCHIVE+ ferror.c       263 10/01/1984 15:39:48
/*	return non zero if error has occurred on file
*/

#include "stdio.h"
#include "fileio.h"

ferror(stream)
FILE *stream;
{
  struct bufstr *buf,*_checkfd();
  
  buf=_checkfd(fileno(stream));
  if(~buf->buf_flag&BF_ERROR)return 0;
  return EOF;
}
+ARCHIVE+ fflush.c       625 10/01/1984 15:39:48
/*	flush a file, updating all data on disk
*/

#include "stdio.h"
#include "fileio.h"

extern struct bufstr *_checkfd();

fflush(stream)
FILE *stream;
{
  struct bufstr *buf;

  buf=_checkfd(fileno(stream));	/* get the buffer address */
  if(buf->buf_flag&BF_CDEV)goto done;
  if(buf->buf_flag&BF_DIRTY)_oswrite(buf);	/* empty the buffer */
  if(((buf->buf_fcb->fcb_fs=buf->buf_flen)&(SECSIZE-1))
	&& buf->buf_flag&BF_ASCII){
    buf->buf_fcb->fcb_fs++;		/* davids fix for file size */
  }
  if((bdos(0x10,buf->buf_fcb)&0xff)>3)buf->buf_flag|=BF_ERROR;
done:
  return (buf->buf_flag&BF_ERROR?-1:0);
}
+ARCHIVE+ fgetc.c        233 10/01/1984 15:39:48
/*	get a character from the file
*/

#include "stdio.h"

fgetc(stream)
FILE *stream;
{
  unsigned cc;

  cc=0;
  if(read(fileno(stream),&cc,1)!=1)cc=EOF;	/* read 1 character */
  return cc;					/* return character */
}
+ARCHIVE+ fileio.h      1819  5/03/1984 13:45:06
/*	fileio.h
	header file for DOS-ALL i/o library
*/

/*	define the ms-dos file control block
*/

struct fcb_str{
  unsigned char fcb_dr;			/* drive specification */
  unsigned char fcb_fn[8];		/* the file name */
  unsigned char fcb_ft[3];		/* the file type */
  unsigned fcb_cb;			/* current block number */
  unsigned fcb_rs;			/* record size */
  unsigned long fcb_fs;			/* file size */
  unsigned fcb_fd;			/* file date */
  unsigned char fcb_dn[10];		/* ms-dos use */
  unsigned char fcb_cr;			/* current record */
  unsigned long fcb_rr;			/* random record number */
  unsigned char fcb_path[1];		/* path name if under 2.00 */
};

struct bufstr{
  struct cpmfcb *buf_fcb;	/* pointer to cp/m fcb block */
  unsigned char *buf_data;	/* the data buffer */
  unsigned buf_flag;		/* control flags etc */
  unsigned char buf_uget;	/* unget character storage */
  int buf_size;			/* length of the buffer in bytes */
  int buf_next;			/* next character to be read/written */
  int buf_fill;			/* the number of characters in buffer */
  long buf_off;			/* address of first character in buffer */
  long buf_flen;		/* our idea of the file size */
  unsigned buf_hand;		/* the handle for 2.00 files */
};

#define BF_READ 1
#define BF_WRITE 2
#define BF_ASCII 4
#define BF_UNGET 8
#define BF_CDEV 0x10
#define BF_DIRTY 0x20
#define BF_ERROR 0x40
#define BF_DOS2 0x80

#define SECPOWER 9		/* size of sector as power of 2 */
#define SECSIZE (1<<SECPOWER)	/* size of cp/m sector */
#define NUMBSEC 1		/* number of sectors in buffer */

#define MAXFILES 32		/* maximum file number */

extern unsigned char *_opentab[MAXFILES];	/* file table */
extern unsigned _sysvers;	/* version of dos in use */

struct regval{unsigned ax,bx,cx,dx,si,di,ds,es;};

/*	end of fileio.h
*/
+ARCHIVE+ fileno.c       132 10/01/1984 15:39:54
/*	return the fd corresponding to a stream
*/

fileno(stream)
unsigned stream;	/* trust me */
{

  return stream-0x8000;
}
+ARCHIVE+ fopen.c       1119 10/01/1984 15:39:48
/*	open a file
*/

#include "stdio.h"

FILE *fopen(filename,fomode)
unsigned char *filename,*fomode;
{
  int first=0,comode=AREAD-1,rwmode=0,fd;

  while(*fomode){
    switch(*fomode++){
       case '+':
        if(rwmode&1)rwmode|=2;	       /* if read, set write permission */
        else if(rwmode&2)rwmode|=1;    /* if write, set read permission */
	continue;
      case 'b':
	comode=BREAD-1;
	continue;
      case 'r':
	if(!first)first=1;		/* open not create */
	rwmode|=1;
	continue;
      case 'w':
	if(!first)first=2;		/* create the file */
      case 'a':
	if(!first)first=3;		/* open at end, create if reqd */
	rwmode|=2;
	continue;
    }
    goto err;
  }

  switch(first){
    case 1:
    case 3:
      fd=_open(filename,comode+rwmode,0);
      if(fd!=-1 || first==1)break;
    case 2:
      fd=_open(filename,comode+rwmode,7);
      break;
    default:
      goto err;
  }
  if(first==3 && fd!=-1)lseek(fd,0L,2);	/* get to end of file */
#ifdef _C86_BIG
  if(fd!=-1)return 0x8000L|fd;
#else
  if(fd!=-1)return 0x8000|fd;
#endif
err:
  return 0;
}



+ARCHIVE+ fputc.c        167 10/01/1984 15:39:50
/*	put a character to a file
*/

#include "stdio.h"

fputc(c,stream)
unsigned c;
FILE *stream;
{

  if(write(fileno(stream),&c,1)!=1)c=EOF;
  return c;
}
+ARCHIVE+ fseek.c        276 10/01/1984 15:39:50
/*	do a seek on a file
*/

#include "stdio.h"

long fseek(stream,offset,base)
FILE *stream;			/* the file to seek */
long offset;			/* how far to move */
int base;			/* base to move from */
{
  extern long lseek();

  return lseek(fileno(stream),offset,base);
}
+ARCHIVE+ getw.c         175 10/01/1984 15:39:50
/*	get a word from a file
*/

#include "stdio.h"

getw(stream)
FILE *stream;
{
  unsigned cc;

  cc=0;
  if(read(fileno(stream),&cc,2)!=2)cc=EOF;
  return cc;
}
+ARCHIVE+ lseek.c       1246 10/01/1984 15:39:52
/*	do a seek using a long byte address
*/

#include "fileio.h"

extern struct bufstr *_checkfd();

unsigned long
lseek(fd,posn,offset)
unsigned fd;
long posn;
unsigned offset;
{
  long reqdposn;
  struct bufstr *buf;

  buf=_checkfd(fd);
  if(buf->buf_flag&BF_CDEV)return -1;	/* no seek character device */

  buf->buf_flag&=~BF_UNGET;		/* clear push back */

  switch(offset){
    case 1:					/* seek rel to current pos */
      reqdposn=buf->buf_off+posn+buf->buf_next;
      break;
    case 0:					/* absolute seek */
      reqdposn=posn;
      break;
    case 2:
      if(buf->buf_flen<buf->buf_off+buf->buf_fill)	/* fix eof problem */
	buf->buf_flen=buf->buf_off+buf->buf_fill;
      reqdposn=buf->buf_flen+posn;
      break;
    default:
      return -1;				/* not supported */
  }

  if(!buf->buf_fill 
    || reqdposn<buf->buf_off || reqdposn>=buf->buf_off+buf->buf_fill){
    if(buf->buf_flag&BF_DIRTY)_oswrite(buf);
    buf->buf_off=reqdposn&~(NUMBSEC*SECSIZE-1);
    buf->buf_fill=0;				/* say no data in buffer */
    _osread(buf);				/* read the buffer in */
  }
  buf->buf_next=reqdposn-buf->buf_off;
  if(buf->buf_next>buf->buf_fill)buf->buf_fill=buf->buf_next;
  return reqdposn;
}
+ARCHIVE+ putw.c         161 10/01/1984 15:39:52
/*	put a word to a file
*/

#include "stdio.h"

putw(w,stream)
unsigned w;
FILE *stream;
{

  if(write(fileno(stream),&w,2)!=2)w=EOF;
  return w;
}
+ARCHIVE+ read.asm      4112 10/01/1984 15:40:20
;;;;;
; READ.ASM		(alternative to read.c)
; read characters from a character device or from ascii or binary files.
; for use with DOS ALL library ONLY
; (written by LPA, 12/16/83)
;;;;;

;	input	1, file descriptor
;		2, pointer to buffer
;		3, number of chars to read
;
;	returns	# of chars read or error flag

	include	model.h

if	@bigmodel
$$$		not here yet
else

	extrn	EXIT:near
	extrn	_OSWRITE:near
	extrn	_OSREAD:near
	extrn	_OPENTAB:word
	extrn	_SYSVERS:word
	public	READ
	public	_READ

	include	prologue.h


FD		EQU	@ab[BP]		;file descriptor
BUFFER		EQU	@ab+2[BP]	;ptr to buffer to read
COUNT		EQU	@ab+4[BP]	;length of buffer

BUFDATA		EQU	+2[BX]		;these define struct members
BUFFLAG		EQU	+4[BX]		;  (BX holds ptr to struct)
BUFUGET		EQU	+6[BX]		;
BUFSIZE		EQU	+7[BX]		;
BUFNEXT		EQU	+9[BX]		;
BUFFILL		EQU	+11[BX]		;			
BUFOFFSET	EQU	+13[BX]		;
BUFOFFSET2	EQU	+15[BX]		;

RETVAL		EQU	-2[BP]		;local variables

;;;;;
; the following defines all of the user controllable
; parameters with the defaults.
; make sure that they are consistant with what is in
; the include file fileio.h if you change them.
;;;;;

MAXFILES	EQU	32
BF_READ		EQU	1
BF_WRITE	EQU	2
BF_ASCII	EQU	4
BF_UNGET	EQU	8
BF_CDEV		EQU	10H
BF_DIRTY	EQU	20H
BF_ERROR	EQU	40H
BF_DOS2		EQU	80H
NEWLINE		EQU	10
CRETURN		EQU	13
EOF		EQU	26
RETERROR	EQU	-1
NOT_BF_UNGET	EQU	-9

@code	ends
@DATAB	SEGMENT
RMESS	db	'READ$'
@DATAB	ENDS
@CODE	SEGMENT	BYTE PUBLIC 'CODE'

READ	PROC	NEAR
	push	BP
	mov	BP,SP
	sub	SP,2
	mov	SI,FD
	cmp	SI,MAXFILES			;if (fd>MAXFILES) error
	jae 	error
	shl	SI,1
	mov	BX,_OPENTAB [SI]		;BX holds ptr to buffer
	or	BX,BX				;  control structure
	jz	error				;if (NULL) error
	test	WORD PTR BUFFLAG,BF_READ
	jz	noerror
error:
	mov	DX,OFFSET DGROUP:RMESS
	mov	AH,9
	int	21H
	mov	AX,-32754
	push	AX
	call	EXIT
noerror:
	mov	WORD PTR RETVAL,0
forloop:
	mov	AX,RETVAL		;while (retval<count)
	cmp	AX,COUNT
	jnb	wrapup
	call	_READ			;  read the next char
	cmp	AX,-1
	je	wrapup
	mov	SI,BUFFER		;  store char in buffer
	inc	WORD PTR BUFFER
	mov	[SI],AL
	inc	WORD PTR RETVAL
	test	WORD PTR BUFFLAG,BF_ASCII; if (~ASCII) {
	je	forloop
	cmp	AL,EOF			;    if (EOF) save it
	je	prewrap
	cmp	AL,CRETURN		;    if (CRETURN) flush it, get next
	jne	not_CRET
	call	_READ
	cmp	AX,-1
	je	SHORT wrapup
	cmp	AL,NEWLINE		;    don't return past NEWLINE
	jne	not_NL
	mov	SI,BUFFER
	mov	-1[SI],AL
	jmp	SHORT wrapup
not_NL:
	mov	BUFUGET,AL
	or	WORD PTR BUFFLAG,BF_UNGET;   set UNGET flag
	jmp	forloop
not_CRET:
	cmp	AL,NEWLINE		;    if (NEWLINE) done
	je	SHORT wrapup		;  }
	jmp	forloop
prewrap:
	dec	WORD PTR RETVAL
wrapup:					;  FINIS!
	test	WORD PTR BUFFLAG,BF_ERROR
	je	retOK
	mov	AX,RETERROR
	jmp	SHORT done
retOK:
	mov	AX,RETVAL
done:
	mov	SP,BP
	pop	BP
	ret
READ	ENDP


_READ	PROC	NEAR
	push	BP
	mov	BP,SP
	test	WORD PTR BUFFLAG,BF_UNGET	;if (UNGET) {
	je	not_UNGET			;  kill UNGET flag
	and	WORD PTR BUFFLAG,NOT_BF_UNGET
	mov	AL,BUFUGET
	mov	SP,BP
	pop	BP
	ret					;  return unget char }
not_UNGET:
	mov	AX,BUFNEXT
	cmp	AX,BUFFILL			;if (next >= fill) {
	jl	nxt_lt_fill
	test	WORD PTR BUFFLAG,BF_DIRTY	;  if (dirty buff) flush
	je	not_dirty
	push	BX
	push	BX
	call	_OSWRITE
	add	SP,2
	pop	BX
not_dirty:
	test	WORD PTR BUFFLAG,BF_CDEV	;  if (CDEV) goto do_read
	jne	SHORT do_read
	mov	AX,BUFFILL
	cmp	AX,BUFSIZE
	jne	fill_ne_size			;  if (fill==size) {
	mov	AX,BUFSIZE
	add	WORD PTR BUFOFFSET,AX
	adc	WORD PTR BUFOFFSET2,0
	mov	WORD PTR BUFFILL,0		;    }
fill_ne_size:
	mov	AX,BUFFILL			;  if (!fill) {
	or	AX,AX
	jne	SHORT nxt_lt_fill
do_read:
	mov	WORD PTR BUFNEXT,0
	push	BX
	push	BX
	call	_OSREAD				;    read char
	add	SP,2				;    }
	pop	BX
nxt_lt_fill:					;  }
	mov	AX,BUFNEXT
	cmp	AX,BUFFILL			;EOF
	jl	notEOF
	mov	AX,-1
	mov	SP,BP
	pop	BP
	ret
notEOF:
	mov	SI,BUFDATA			;return char
	mov	AX,BUFNEXT
	inc	WORD PTR BUFNEXT
	add	SI,AX
	xor	AH,AH
	mov	AL,[SI]
	mov	SP,BP
	pop	BP
	ret
_READ	ENDP

endif
	include	epilogue.h
	end
+ARCHIVE+ read.c        1594 10/01/1984 15:39:54
/*	read characters from the file
*/

#include "fileio.h"

extern struct bufstr *_checkfd();

read(fd,buffer,count)
unsigned fd;
char *buffer;
unsigned count;
{
  int retval,retcc;
  struct bufstr *buf;

  buf=_checkfd(fd);
  if(buf->buf_flag&BF_READ){
    bdos(9,"READ$");
    exit(0x8002);
  }

  for(retval=0;retval<count;){
    if((retcc=_read(buf))<0)break;
    *buffer++=retcc;
    ++retval;				/* count the character */
    if(buf->buf_flag&BF_ASCII){
      if(retcc==26){
	--buf->buf_next;		/* give it to him again */
	--retval;			/* uncount the character */
	break;
      }
      if(retcc=='\r'){
	if((retcc=_read(buf))<0)break;
	if(retcc=='\n'){
	  *(buffer-1)='\n';
	  break;			/* dont return past new line */
	}
	buf->buf_uget=retcc;
	buf->buf_flag|=BF_UNGET;
      } else if(retcc=='\n')break;
    }
  }
  return ((buf->buf_flag&BF_ERROR)?-1:retval);
}

/*	support routine for read
*/

_read(buf)
struct bufstr *buf;
{

  if(buf->buf_flag&BF_UNGET){
    buf->buf_flag&=~BF_UNGET;
    return buf->buf_uget;
  }

  if(buf->buf_next>=buf->buf_fill){		/* no data in buffer */
    if(buf->buf_flag&BF_DIRTY)_oswrite(buf);	/* get out your dirty buff */
    if(buf->buf_flag&BF_CDEV)goto do_read;
    if(buf->buf_fill==buf->buf_size){
      buf->buf_off+=buf->buf_size;
      buf->buf_fill=0;
    }
    if(!buf->buf_fill){
do_read:
      buf->buf_next=0;
      _osread(buf);				/* fill the buffer */
    }
  }
  if(buf->buf_next>=buf->buf_fill)return -1;	/* end of file */
  return buf->buf_data[buf->buf_next++];
}
+ARCHIVE+ rename.c       911 10/01/1984 15:39:56
/*	rename a file 
*/

#include "fileio.h"

rename(filefrom,fileto)
unsigned char *filefrom,*fileto;
{

   if(_sysvers){	/* dos 2.0+ */
	struct regval srv;
#ifdef _C86_BIG
	srv.ds=((unsigned long)filefrom)>>16;
	srv.es=((unsigned long)fileto)>>16;
#else
	segread(&srv.si);	/* saves use of additional structure */
	srv.es=srv.ds;		/* can't depend on value in es */
#endif
	srv.ax=0x5600;		/* dos 2.0 function to rename file */
  	srv.dx=filefrom;	/* old file name */
  	srv.di=fileto;		/* new file name */
	return (sysint21(&srv,&srv)&1) ? -1 : 0; 
   } else {	/* dos all */
	unsigned char *fcbfrom,*fcbto=0,*makefcb();
	unsigned status; 

	if(!(fcbfrom=makefcb(filefrom)))return -1;
	if(!(fcbto=makefcb(fileto))){
	   free(fcbfrom);
	   return -1;
	}
	movmem(fcbto,fcbfrom+16,16);
	status=bdos(0x17,fcbfrom)&0xff;
	free(fcbfrom); free(fcbto);
	return status?-1:0;
   }

}

+ARCHIVE+ ungetc.c       300 10/01/1984 15:39:54
/*	ungetc a char from an input stream
*/

#include "stdio.h"
#include "fileio.h"

ungetc(cc,stream)
unsigned cc;
FILE *stream;
{
  struct bufstr *buf,*_checkfd();

  if(buf=_checkfd(fileno(stream))){
    buf->buf_flag|=BF_UNGET;
    buf->buf_uget=cc;
  } else cc=-1;
  return cc;
}
+ARCHIVE+ unlink.c       588 10/01/1984 15:39:56
/*	delete a file
	return 0 on success, -1 otherwise 
*/

#include "fileio.h"

unlink(filename)
unsigned char *filename;
{
   if(_sysvers){	/* dos 2.00+ */
	struct regval srv; 
	srv.dx=filename;
	srv.ax=0x4100;
#ifdef _C86_BIG
	srv.ds=((unsigned long)filename)>>16;
#else
	segread(&srv.si);	/* saves use of separate structure */
#endif
	return (sysint21(&srv,&srv)&1)?-1:0;
   } else {	/* dos all  */ 
	unsigned char *fcb,*makefcb();
	unsigned status;
	if(!(fcb=makefcb(filename)))return -1;
	status=bdos(0x13,fcb)&0xff;
	free(fcb);
	return status?-1:0;
  } 
}
+ARCHIVE+ write.asm     6658 10/01/1984 15:40:20
;;;;;
; WRITE.ASM		(alternative to write.c)
; write characters to a character device or to ascii or binary files.
; for use with DOS ALL library only
; (written by LPA, 12/16/83)
;;;;;

;	input	1, file descriptor
;		2, pointer to buffer
;		3, number of chars to write
;
;	returns	# of chars written or error flag

	include	model.h

if	@bigmodel
$$$		not here yet
else

	extrn	_EXIT:near
	extrn	_OSWRITE:near
	extrn	_OSREAD:near
	extrn	_OPENTAB:word
	extrn	_SYSVERS:word
	public	WRITE

	include	prologue.h


FD		EQU	@ab[BP]		;file descriptor
BUFFER		EQU	@ab+2[BP]	;ptr to buffer to write
COUNT		EQU	@ab+4[BP]	;length of buffer

OUTBUFF		EQU	+2[BX]		;these define struct members
BUFFLAG		EQU	+4[BX]		;  (BX holds ptr to struct)
BUFSIZE		EQU	+7[BX]		;
BUFNEXT		EQU	+9[BX]		;
BUFFILL		EQU	+11[BX]		;			
BUFOFFSET	EQU	+13[BX]		;
BUFOFFSET2	EQU	+15[BX]		;
BUFHAND		EQU	+21[BX]		;

MAX		EQU	-6[BP]		;local variables
RETVAL		EQU	-4[BP]		;
BUFSTR		EQU	-2[BP]		;

;;;;;
; the following defines all of the user controllable
; parameters with the defaults.
; make sure that they are consistant with what is in
; the include file fileio.h if you change them.
;;;;;

MAXFILES	EQU	32
SRVCXVAL	EQU	1		;parm for int 21h instruction
SRVAXVAL	EQU	4000H		;same as above
BF_READ		EQU	1
BF_WRITE	EQU	2
BF_ASCII	EQU	4
BF_UNGET	EQU	8
BF_CDEV		EQU	10H
BF_DIRTY	EQU	20H
BF_ERROR	EQU	40H
BF_DOS2		EQU	80H
NEWLINE		EQU	10
CRETURN		EQU	13
RETERROR	EQU	-1
NOT_BF_UNGET	EQU	-9

@code	ends
@DATAB	SEGMENT
WRMESS	db	'WRITE$'
CRET	db	CRETURN
@DATAB	ENDS
@CODE	SEGMENT	BYTE PUBLIC 'CODE'

WRITE	PROC	NEAR
	push	BP
	mov	BP,SP
	sub	SP,6
	mov	SI,FD
	cmp	SI,MAXFILES			;if (fd>maxfiles) error
	jae	error
	shl	SI,1
	mov	BX,_OPENTAB [SI]		;BX holds ptr to buffer
	or	BX,BX				;  control structure
	jz	error				;if (NULL) error
	test	WORD PTR BUFFLAG,BF_WRITE
	jz	noerror
error:
	mov	DX,OFFSET DGROUP:WRMESS
	mov	AH,9
	int	21H
	mov	AX,-32754
	push	AX
	call	_EXIT
noerror:
	and	WORD PTR BUFFLAG,NOT_BF_UNGET 	;kill any unget
	test	WORD PTR BUFFLAG,BF_CDEV	;test character device
	jne	HOP1
	jmp	DISKFILE
HOP1:
	test	WORD PTR BUFFLAG,BF_DOS2
	je	DOS1
	mov	WORD PTR RETVAL,-1
	mov	BUFSTR,BX			;save BX (is bufstr!)
	mov	BX,BUFHAND			;set BX & CX for int 21H
	mov	CX,SRVCXVAL
DOS2loop:
	inc	WORD PTR RETVAL
	mov	AX,RETVAL
	cmp	AX,COUNT
	jae	endDOS2
	mov	SI,BUFFER
	mov	AL,[SI]
	cmp	AL,NEWLINE
	jne	not_nl2
	mov	SI,BUFSTR
	test	WORD PTR +4[SI],BF_ASCII	;BUFFLAG!!
	je	not_nl2
	mov	DX,OFFSET DGROUP:CRET
	mov	AX,SRVAXVAL
	int	21H
	jnb	not_nl2
	mov	SI,BUFSTR
	or	WORD PTR +4[SI],BF_ERROR	;BUFFLAG!!
not_nl2:
	mov	DX,BUFFER
	inc	WORD PTR BUFFER
	mov	AX,SRVAXVAL
	int 	21H
	jnb	DOS2loop
	mov	SI,BUFSTR
	or	WORD PTR +4[SI],BF_ERROR	;BUFFLAG!!
	jmp	DOS2loop
endDOS2:
	mov	BX,BUFSTR
	jmp	wrapup
DOS1:
	mov	WORD PTR RETVAL,0
DOS1loop:
	mov	AX,RETVAL
	cmp	AX,COUNT
	jae	endDOS1
	mov	SI,BUFFER
	mov	AL,[SI]
	cmp	AL,NEWLINE
	jne	not_nl1
	test	WORD PTR BUFFLAG,BF_ASCII
	je	not_nl1
	mov	DL,CRETURN
	mov	AH,[BX]
	int	21H
not_nl1:
	mov	DL,[SI]
	inc	WORD PTR BUFFER
	mov	AH,[BX]
	int	21H
	inc	WORD PTR RETVAL
	jmp	SHORT DOS1loop
endDOS1:
	jmp	wrapup
DISKFILE:
	mov	SI,BUFFER		;
	mov	DX,BUFNEXT		;
	mov	DI,DX			;
	add	DI,OUTBUFF		;
	mov	WORD PTR RETVAL,0	;
	cld				;
bigloop:				;while (retval < count) do
	mov	AX,RETVAL		;
        cmp     AX,COUNT		;
        jb      hop			;
        jmp     endFILE			;  if (retval = count) EXIT
hop:					;
        cmp     DX,BUFSIZE		;  if(bufnext=bufsize)
        jl      stillroom		;    write the buffer
	mov	BUFNEXT,DX		;
	push	SI			;
	mov	AX,BUFSIZE		;*this section of code is the
	mov	WORD PTR BUFFILL,AX	;*old _WRITE code imbedded in
	push	BX			;*line with the WRITE code.
	push	BX			;*
	call	_OSWRITE		;*
	add	SP,2			;*
	pop	BX			;*
	mov	AX,BUFSIZE		;*
	add	WORD PTR BUFOFFSET,AX	;*
	adc	WORD PTR BUFOFFSET2,0	;*
	mov	WORD PTR BUFFILL,0	;*
	mov	WORD PTR BUFNEXT,0	;*
	test	WORD PTR BUFFLAG,BF_READ;*
	jne	setdirty1		;*
	push	BX			;*
	push	BX			;*
	call	_OSREAD			;*
	add	SP,2			;*
	pop	BX			;*
	mov	AX,BUFFILL		;*
	or	AX,AX			;*
	jne	setdirty1		;*
	mov	WORD PTR BUFFILL,1	;*
setdirty1:				;*
	or	WORD PTR BUFFLAG,BF_DIRTY;*			
        pop     SI			;
        mov     DX,BUFNEXT		;
	mov	DI,OUTBUFF		;
	add	DI,DX			;
stillroom:				;
	or	WORD PTR BUFFLAG,BF_DIRTY;  
        mov     CX,BUFSIZE		;  max = size - next
        sub     CX,DX			;
        mov     AX,COUNT		;  if(max>count-retval)
        sub     AX,RETVAL		;    max=count-retval
        cmp     AX,CX			;
        jae     maxOK			;
        mov     CX,AX			;
maxOK:					;
	add	RETVAL,CX		;  retval=retval+max
	test	WORD PTR BUFFLAG,BF_ASCII;  if (ascii file) do
        jz      binloop			;
asciloop:				;    while (max--)
	lodsb				;      mov char to bufstr
	stosb				;
	inc	DX			;
       	cmp  	AL,NEWLINE		;      if (\n) then call
	je	crinsert		;        insert carridge return
	loop    asciloop		;    endwhile
	jmp	bigloop			;
crinsert:				;
	dec	DI			;    insert carrigdge return
       	mov	BYTE PTR [DI],CRETURN	;
	inc	DI			;
	dec	CX			;    if max=0 then unput newline
	jcxz	unputnl			;
	dec  	CX			;
	dec	WORD PTR RETVAL		;
	jmp	justadd			;
unputnl:				;
	cmp	DX,BUFSIZE		;    if next=size then flush buffer
	jl	justadd			;
	mov	BUFNEXT,DX		;
	push	SI			;
	mov	AX,BUFSIZE		;*this section of code is the
	mov	WORD PTR BUFFILL,AX	;*imbedded _WRITE code!!
	push	BX			;*
	push	BX			;*
	call	_OSWRITE		;*
	add	SP,2			;*
	pop	BX			;*
	mov	AX,BUFSIZE		;*
	add	WORD PTR BUFOFFSET,AX	;*
	adc	WORD PTR BUFOFFSET2,0	;*
	mov	WORD PTR BUFFILL,0	;*
	mov	WORD PTR BUFNEXT,0	;*
	test	WORD PTR BUFFLAG,BF_READ;*
	jne	setdirty2		;*
	push	BX			;*
	push	BX			;*
	call	_OSREAD			;*
	add	SP,2			;*
	pop	BX			;*
	mov	AX,BUFFILL		;*
	or	AX,AX			;*
	jne	setdirty2		;*
	mov	WORD PTR BUFFILL,1	;*
setdirty2:				;*
	or	WORD PTR BUFFLAG,BF_DIRTY;*
	pop	SI			;
	mov	DX,BUFNEXT		;
	mov	DI,OUTBUFF		;
	add	DI,DX			;
justadd:				;
	mov	AL,NEWLINE		;    put newline back in the buffer
	stosb				;
	inc	DX			;
	inc	CX			;
	loop	asciloop		;  end if ascii do
	jmp	bigloop			;
binloop:				;  else (binary file) do
	add	DX,CX			;    move input to output buffer
	rep 	movsb			;
        jmp     bigloop			;  endif
endFILE:
	mov	BUFNEXT,DX
	cmp	DX,BUFFILL
	jle	wrapup
	mov	BUFFILL,DX
wrapup:
	test	WORD PTR BUFFLAG,BF_ERROR
	je	retOK
	mov	AX,reterror
	jmp	done
retOK:
	mov	AX,RETVAL
done:
	mov	SP,BP
	pop	BP
	ret
WRITE	ENDP

endif
	include	epilogue.h
	end
+ARCHIVE+ write.c       2423 10/01/1984 15:39:56
/*	write characters to a file
*/

#include "fileio.h"

write(fd,buffer,count)
unsigned fd,count;
unsigned char *buffer;
{
  int max;
  unsigned int retval;
  struct bufstr *buf,*_checkfd();

  buf=_checkfd(fd);
  if(buf->buf_flag&BF_WRITE){		/* not open for writing */
    bdos(9,"WRITE$");
    _exit(0x800e);
  }
  buf->buf_flag&=~BF_UNGET;		/* kill any unget */

/*	do character output in line - its faster
*/
  if(buf->buf_flag&BF_CDEV){
    if(buf->buf_flag&BF_DOS2){
      static char *retchar="\r";
      struct regval srv,rrv;
      srv.ax=0x4000;
      srv.bx=buf->buf_hand;
      srv.cx=1;
#ifndef _C86_BIG
      segread(&srv.si);
#endif
      for(retval=0;retval<count;++retval){
        if(*buffer=='\n' && buf->buf_flag&BF_ASCII){
	  srv.dx=retchar;
#ifdef _C86_BIG
	  srv.ds=((unsigned long)retchar)>>16;
#endif
	  if(sysint21(&srv,&rrv)&1)buf->buf_flag|=BF_ERROR;
	}
#ifdef _C86_BIG
	srv.ds=((unsigned long)buffer)>>16;
#endif
	srv.dx=buffer++;
	if(sysint21(&srv,&rrv)&1)buf->buf_flag|=BF_ERROR;
      }
    } else {
      for(retval=0;retval<count;++retval){
        if(*buffer=='\n' && buf->buf_flag&BF_ASCII)
	  bdos((unsigned)(buf->buf_fcb),'\r');
        bdos((unsigned)(buf->buf_fcb),*buffer++);
      }
    }
    goto done;
  }

/*	disk files only
*/

  for(retval=0;retval<count;){
    if(buf->buf_next>=buf->buf_size)_write(buf);
    buf->buf_flag|=BF_DIRTY;			/* say dirty */
    max=buf->buf_size-buf->buf_next;
    if(max>count-retval)max=count-retval;
    retval+=max;
    if(buf->buf_flag&BF_ASCII){
      while(max--){
	if(*buffer=='\n'){
	  buf->buf_data[buf->buf_next++]='\r';
	  if(max){--max;--retval;}
	  else if(buf->buf_next>=buf->buf_size)_write(buf);
	}
	buf->buf_data[buf->buf_next++]=*buffer++;
      }
    } else while(max--)buf->buf_data[buf->buf_next++]=*buffer++;
  }
  if(buf->buf_next>buf->buf_fill)buf->buf_fill=buf->buf_next;
done:
  return (buf->buf_flag&BF_ERROR?-1:retval);
}

/*	service routine for write
*/

_write(buf)
struct bufstr *buf;
{

  buf->buf_fill=buf->buf_size;
  _oswrite(buf);				/* empty the buffer */
  buf->buf_off+=buf->buf_size;
  buf->buf_fill=buf->buf_next=0;		/* buffer is empty */
  if(~buf->buf_flag&BF_READ){
    _osread(buf);
    if(!buf->buf_fill)buf->buf_fill=1;		/* so we don't read again */
  }
  buf->buf_flag|=BF_DIRTY;			/* say dirty */
}
+ARCHIVE+ ycheckfd.c     274 10/01/1984 15:39:42
/*	check a file descriptor and return control block address
*/

#include "fileio.h"

struct bufstr *_checkfd(fildes)
unsigned fildes;
{
  struct bufstr *buf;

  if(fildes<MAXFILES && (buf=_opentab[fildes]))return buf;
  bdos(9,"BAD FILE$");
  _exit(0x8001);
}
+ARCHIVE+ ymain.c       1714 10/01/1984 15:39:42
/*	C level interface to user programs
*/

#include "stdio.h"
#include "fileio.h"

#define MAXARG 20

extern FILE *fopen();
FILE *stdin=0x8000, *stdout=0x8001, *stderr=0x8002;

_main(cl_ptr)
unsigned char *cl_ptr;
{
  unsigned char *cp,*stdinf,*stdoutf,*stderrf,*argv[MAXARG+1];
  int j,k,argc;

  cp=cl_ptr;			/* get address of command line */

/*	convert the input line to lower case
*/

  for(j=*cp++;j--;++cp){
    if(*cp==' ' || *cp=='\t')*cp=0;	/* set spaces and tabs to null */
  }
  *cp=0;				/* a final terminator */

/*	set up for standard files
*/

  stdinf=stdoutf=stderrf="con:";		/* all have same name */

/*	build the arg lists and do redirection
*/

  cp=cl_ptr;
  argc=1;
  for(j=*cp++ + 1;j--;++cp){
    if(!*cp)continue;			/* skip leading nulls */
    if(*cp=='<')stdinf=cp+1;		/* redirect stdin */
    else if(*cp=='>')stdoutf=cp+1;	/* redirect stdout */
    else argv[argc++]=cp;		/* grab the argument */
    if(argc>=MAXARG){
      bdos(9,"\nTOO MANY ARGS$");
      _exit(0x8002);
    }
    while(*cp){++cp;--j;}		/* and skip the data */
  }
  argv[argc]=NULL;

  k=_sysvers;_sysvers=0;		/* set ver 1.1 for following code */

  cp="w";
  if(*stdoutf=='>'){++stdoutf;cp="a";}	/* set up for append */
  if(fopen(stdinf,"r")!=stdin
	|| fopen(stdoutf,cp)!=stdout
	|| fopen(stderrf,"w")!=stderr){
    bdos(9,"\nREDIRECTION ERROR$");
    _exit(0x8003);
  }

/*	this code for dos 2.00
*/

  if(k){
    for(j=0;j<3;++j){
      _opentab[j]->buf_flag|=BF_DOS2;
      _opentab[j]->buf_hand=j;
    }
    _sysvers=k;
  }

/*	now execute the program
*/

  argv[0]="c";				/* don't know program name */
  exit(main(argc,argv));
}
+ARCHIVE+ yopen.c       3116 10/01/1984 15:39:42
/*	common open routine
*/

#include "fileio.h"

extern unsigned char *calloc(),*malloc();
extern struct fcb_str *makefcb();
unsigned char *_opentab[MAXFILES];

struct cdvent{
  unsigned char cdvnam[4];
  unsigned char cdvmode;
  unsigned char cdvfcb;
};

#define CDVMAX 5

static struct cdvent cdvtab[CDVMAX]={
{"CON",1,1},
{"CON",2,2},
{"AUX",1,3},
{"AUX",2,4},
{"PRN",2,5}
};

_open(filename,mode,new)
unsigned char *filename;
unsigned mode,new;
{
  int j,k,fd;
  unsigned char *curpath=0,*gcdir();
  struct bufstr *buf=0;
  struct regval srv;

  for(fd=0;fd<MAXFILES;++fd)if(!_opentab[fd])break;
  if(fd==MAXFILES)goto err;		/* all possable files open */
  buf=calloc(sizeof(struct bufstr),1);	/* get our fcb */
  if(!buf)goto err;			/* no buffer yet */
  buf->buf_flag=(~++mode)&7;		/* set read/write permissions */

/*	see if a character device */

  if(strlen(filename)>3 && filename[3]==':'){		/* could be */
    for(k=0;k<CDVMAX;++k){
      for(j=0;j<3 && toupper(filename[j])==cdvtab[k].cdvnam[j];++j);
      if(j==3 && cdvtab[k].cdvmode==(mode&3)){
	buf->buf_flag|=BF_CDEV;
	buf->buf_fcb=cdvtab[k].cdvfcb;
	if(k<2 && _sysvers){			/* dos 2.00 console */
	  srv.ax=0x3d00+((mode-1)&3);
#ifdef _C86_BIG
	  srv.ds=((unsigned long)(cdvtab[0].cdvnam))>>16;
#else
	  segread(&srv.si);
#endif
	  srv.dx=cdvtab[0].cdvnam;
	  if(sysint21(&srv,&srv)&1)goto err;
	  buf->buf_hand=srv.ax;
	  buf->buf_flag|=BF_DOS2;
	  if(mode==5){				/* need binary mode ? */
	    srv.ax=0x4400;			/* only for con in */
	    srv.bx=buf->buf_hand;
	    sysint21(&srv,&srv);
	    srv.ax=0x4401;
	    srv.bx=buf->buf_hand;
	    srv.dx=(srv.dx&0xff)|0x20;		/* set raw mode */
	    sysint21(&srv,&srv);
	  }
	}
	if((buf->buf_flag&7)==(BF_ASCII+BF_WRITE)){
	  if(buf->buf_fcb==1)buf->buf_size=136;
	  else buf->buf_size=2;
	} else buf->buf_size=1;
	break;
      }
    }
  }
  if(~buf->buf_flag&BF_CDEV){
    if(!(buf->buf_fcb=makefcb(filename)))goto err;	/* bad file name */
    if(buf->buf_fcb->fcb_path[0]){
      if(!(curpath=gcdir(filename)))goto err;
      if(chdir(buf->buf_fcb->fcb_path))goto err;
    }
    if(new)bdos(0x13,buf->buf_fcb);	/* delete the file if it exists */
    k=bdos(0x0f+new,buf->buf_fcb)&0xff;	/* open/create */
    if(curpath){
      chdir(curpath);
      free(curpath);
    }
    if(k>3)goto err;
    buf->buf_fcb->fcb_rs=SECSIZE;
    buf->buf_size=SECSIZE*NUMBSEC;
  }
  if(buf->buf_data=malloc(buf->buf_size)){	/* get the buffer */
    setmem(buf->buf_data,buf->buf_size,0xff);/* TEMPORARY FIX */
    _opentab[fd]=buf;
    if(~buf->buf_flag&BF_CDEV && !new){
      buf->buf_flen=buf->buf_fcb->fcb_fs;
      if(buf->buf_flag&BF_ASCII && buf->buf_flen){
	k=buf->buf_flen&(SECSIZE-1);
	if(!k)k=SECSIZE;
	buf->buf_fcb->fcb_rr=(buf->buf_flen-k)>>SECPOWER;
	bdos(26,buf->buf_data);
	bdos(33,buf->buf_fcb);
	for(j=0;j<k;++j)if(buf->buf_data[j]==26)break;
	buf->buf_flen+=j-k;
      }
    }
    return fd;
  }
err:
  if(buf){
    if(buf->buf_fcb)free(buf->buf_fcb);
    free(buf);
  }
  return -1;
}
+ARCHIVE+ yosread.c     1929 10/01/1984 15:39:44
/*	read characters from the operating system
*/

#include "fileio.h"

_osread(buf)
struct bufstr *buf;
{
  int j,k,status;

  if(buf->buf_flag&BF_CDEV){
    if(buf->buf_flag&BF_DOS2){		/* must be stdin */
      struct regval srv;

      srv.ax=0x3f00;
      srv.bx=buf->buf_hand;
      srv.cx=buf->buf_size;
      srv.dx=buf->buf_data;
#ifdef _C86_BIG
      srv.ds=((unsigned long)(buf->buf_data))>>16;
#else
      segread(&srv.si);
#endif
      if(sysint21(&srv,&srv)&1)buf->buf_flag|=BF_ERROR;
      buf->buf_next=0;
      buf->buf_fill=srv.ax;
    } else if(buf->buf_flag&BF_ASCII && buf->buf_fcb==1){    /* kbd special */
      buf->buf_data[0]=132;
      bdos(10,buf->buf_data);			/* read the line */
      bdos(2,'\n');
      buf->buf_next=2;				/* first data char */
      buf->buf_fill=buf->buf_data[1]+3;
      buf->buf_data[buf->buf_fill-1]='\n';
    } else {
      buf->buf_data[0]=bdos((unsigned)buf->buf_fcb);	/* get a character */
      if(buf->buf_flag&BF_ASCII && buf->buf_data[0]=='\r'){
        buf->buf_data[1]='\n';		/* add a line feed */
        buf->buf_fill=2;
      } else buf->buf_fill=1;
    }
    return;
  }

/* its a disk read */

  k=buf->buf_off>>SECPOWER;
  for(status=j=0;j<NUMBSEC;++j){
    if(buf->buf_off+(j*SECSIZE)<buf->buf_flen){
      bdos(0x1a,buf->buf_data+(j*SECSIZE));	/* set transfer address */
      buf->buf_fcb->fcb_rr=k+j;		/* set sector number */
      status=bdos(0x21,buf->buf_fcb)&0xff;	/* do the read */
      if(status==1){		/* unwritten data */
	setmem(buf->buf_data+(j*SECSIZE),SECSIZE,0);	/* set it to zero */
	status=0;
      } else if(status==3)status=0;	/* this is bad but what can i do */
	else if(status)break;
    } else break;
  }
  if(status)buf->buf_flag|=BF_ERROR;		/* eof */
  buf->buf_fill=j*SECSIZE;
  if(buf->buf_fill>buf->buf_flen-buf->buf_off)
    buf->buf_fill=buf->buf_flen-buf->buf_off;
}
+ARCHIVE+ yoswrite.c     653 10/01/1984 15:39:44
/*	write characters to a disk file (not used for char devices)
*/

#include "fileio.h"

_oswrite(buf)
struct bufstr *buf;
{
  int j;

  if(buf->buf_flag&BF_DIRTY){
    if(buf->buf_fill<buf->buf_size)buf->buf_data[buf->buf_fill]=26; /*eof*/
    if(buf->buf_flen<buf->buf_off+buf->buf_fill)
      buf->buf_flen=buf->buf_off+buf->buf_fill;
    for(j=0;j*SECSIZE<buf->buf_fill;++j){
      bdos(0x1a,buf->buf_data+(j*SECSIZE));	/* set transfer address */
      buf->buf_fcb->fcb_rr=(buf->buf_off>>SECPOWER)+j;	/* set sector num */
      if(bdos(0x22,buf->buf_fcb)&0xff)buf->buf_flag|=BF_ERROR;
    }
    buf->buf_flag&=~BF_DIRTY;
  }
}
