+ARCHIVE+ chmod.c        322  9/27/1984 10:30:54
/*	change the mode of a file
*/

#include "fileio2.h"

chmod(name,mode)
unsigned char *name;
{
  struct regval srv;

  srv.ax=0x4301;
  srv.cx=mode;
  srv.dx=name;
#ifdef _C86_BIG
  srv.ds=((unsigned long)name)>>16;
#else
  segread(&srv.si);
#endif
  if(sysint21(&srv,&srv)&1)return -1;
  return 0;
}
+ARCHIVE+ clearerr.c     171  9/27/1984 10:30:54
/*	reset the error indication for a file
*/

#include "stdio.h"
#include "fileio2.h"

clearerr(buf)
struct bufstr *buf;
{

  if(buf)buf->bufflag&=~BF_ERROR;
}
+ARCHIVE+ close.c        157  9/27/1984 10:31:02
/*	close a buffered file and free storage
*/

#include "stdio.h"
#include "fileio2.h"

close(fd)
int fd;
{

  return (fclose(_opentab[fd]));

}
+ARCHIVE+ creat.c        203  9/27/1984 10:30:54
/*	create a new file, deleting any existing file
*/

creat(filename,mode)
unsigned char *filename;
unsigned mode;
{

  return _open(filename,mode,-0x100);	/* do common open for a new file */
}
+ARCHIVE+ envfind.c     1054  9/27/1984 10:31:06
/*	return a copy of a string in the environment
	returns zero if not found
*/

#ifdef _C86_BIG

unsigned char *envfind(string)
unsigned char *string;
{
  unsigned char *cp,*rp,*malloc();
  extern int *_PSPSEG;

  for(cp=(*(_PSPSEG+(0x2c/2)))<<16L;*cp;cp+=strlen(cp)+1){
    if(!strncmp(cp,string,strlen(string)) && cp[strlen(string)]=='='){
      cp+=strlen(string)+1;
      rp=malloc(strlen(cp)+1);
      if(rp)strcpy(rp,cp);
      return rp;
    }
  }
  return 0;
}

#else

unsigned char *envfind(string)
unsigned char *string;
{
  unsigned char *sp,*rp,*malloc();
  extern int _PSPSEG[2];
  unsigned int seg,offset;

  seg=peek(0x2c,_PSPSEG[1]);
  for(offset=0;peek(offset,seg)&0xff;){
    for(sp=string;*sp && (peek(offset,seg)&0xff)==*sp;++offset,++sp);
    if(!*sp && (peek(offset++,seg)&0xff)=='='){
      for(sp=offset;peek(sp++,seg)&0xff;);
      if(rp=malloc(sp-offset))for(sp=rp;*sp++=peek(offset++,seg)&0xff;);
      return rp;
    }
    while(peek(offset++,seg)&0xff);
  }
  return 0;
}

#endif
+ARCHIVE+ exitytsr.c     241 10/06/1984 23:54:50
/*
	terminate and stay resident
*/
exit_tsr()
{
extern unsigned int _SYSENDP;		/* length of program */
struct { unsigned ax,bx,cx,dx,si,di,ds,es; }  srv;

   srv.ax = 0x3100;
   srv.dx = _SYSENDP;
   sysint21(&srv,&srv);
}



+ARCHIVE+ fclose.c       379  9/28/1984 17:04:44
/*	close a file
*/

#include "fileio2.h"
#include "errno.h"

fclose(buf)
struct bufstr *buf;
{
  struct regval srv;
  int retcode=0;

  if(buf->bufflag&BF_DIRTY)
    if (_flush(buf)==-1) retcode=-1;
  _opentab[buf->buffild]=0;
  srv.ax=0x3e00;
  srv.bx=buf->bufhand;
  free(buf);
  if(sysint21(&srv,&srv)&1){errno=srv.ax&0xff;return -1;}
  return retcode;
}
+ARCHIVE+ feof.c         487  9/27/1984 10:30:56
/*	returns non-zero on eof of the named input stream, else zero
*/

#include "stdio.h"
#include "fileio2.h"
#include "errno.h"

feof(buf)
struct bufstr *buf;
{

  struct regval srv;

  if((buf->bufflag&BF_ASCII)&&(buf->bufdata[buf->bufnext]==26)) return 1;
  if (buf->bufnext!=buf->buffill) return 0;
  srv.ax=0x4406;
  srv.bx=buf->bufhand;
  if (sysint21(&srv,&srv)&1) {
    buf->bufflag|=BF_ERROR;
    errno=srv.ax&0xff;
  }
  return !(srv.ax&0xff);
}


    
+ARCHIVE+ ferror.c       198  9/27/1984 10:30:56
/*	return non zero if error has occurred on file
*/

#include "stdio.h"
#include "fileio2.h"

ferror(buf)
struct bufstr *buf;
{
  
  if(~buf->bufflag&BF_ERROR)return 0;
  return EOF;
}
+ARCHIVE+ fflush.c       483  9/27/1984 10:30:56
/*	flush a file, updating all data on disk
*/

#include "stdio.h"
#include "fileio2.h"

fflush(buf)
struct bufstr *buf;
{
  struct regval srv;

  if(buf->bufflag&BF_DIRTY)_flush(buf);		/* empty the buffer */
  srv.ax=0x4500;
  srv.bx=buf->bufhand;
  if(sysint21(&srv,&srv)&1)buf->bufflag|=BF_ERROR;	/* it no work */
  else {
    srv.bx=srv.ax;
    srv.ax=0x3e00;
    if(sysint21(&srv,&srv)&1)buf->bufflag|=BF_ERROR;
  }
  return (buf->bufflag&BF_ERROR?-1:0);
}
+ARCHIVE+ fgetc.asm     2655  3/13/1984 13:34:06
;;;;;
;
; FGETC.ASM
;
; The new routine which will be the basis for the new IO
; package.
; By LPA - 1/6/84
;
; Input 1) STREAM - pointer of where to read from.
;
; Returns - CHAR, RETERROR and CF ON if EOF
;                 RETERROR and CF OFF if I/O ERROR
;
; *** WARNING ***
; READ.ASM uses the returned carry flag to determine EOF!!
; DO NOT CHANGE FGETC WITHOUT TAKING READ.ASM INTO ACCOUNT!!!
; *** WARNING ***
;
;;;;;

	include model.h
IF	@BIGMODEL
	extrn _flush:far
ELSE
	extrn _flush:near
ENDIF
	public fgetc

	include prologue.h
	include fileioa.h

IF	@BIGMODEL
STREAM	EQU	@ab+2[BP]

fgetc	proc	far
	push	DS
ELSE
STREAM	EQU	@ab[BP]

fgetc	proc	near
ENDIF
	push	BP
	mov	BP,SP
IF	@BIGMODEL
	lds	BX,DWORD PTR STREAM
ELSE
	mov	BX,STREAM
ENDIF
	test	BYTE PTR BUFFLAG[BX],BF_UNGET
	jne	DO_UNGET
	test	BYTE PTR BUFFLAG[BX],BF_DIRTY
	jnz	BUFDIRTY
FLUSHDONE:
	mov	AX,BUFNEXT[BX]
	cmp	AX,BUFFILL[BX]
	jge	FILLBUF
endFILLBUF:
	mov	SI,BUFNEXT[BX]
	mov	AL,BUFDATA[BX+SI]
	xor	AH,AH
	inc	WORD PTR BUFNEXT[BX]
	cmp	AL,EOF
	je	EOF_RETURN
EOF_OK:
	cmp	AL,CRETURN
	je	CRET_TEST
goodbye:
	clc
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
DO_UNGET:
	and	BYTE PTR BUFFLAG[BX],NOTBF_UGET
	mov	AL,BUFUGET[BX]
	xor	AH,AH
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
BUFDIRTY:
IF	@BIGMODEL
	push	DS
	push	BX
	call	_flush
	add	SP,4
ELSE
	push	BX
	call	_flush
	add	SP,2
ENDIF
	cmp	AX,RETERROR
	je	goodbye
	mov	BX,STREAM
	jmp	SHORT FLUSHDONE
FILLBUF:
	push	BX
	mov	AX,3f00H
	mov	CX,BUFFULL[BX]
	lea	DX,BUFDATA[BX]
	mov	BX,BUFHAND[BX]
	int	21H
	pop	BX
	jb	SET_ERROR			;check CF for error return
	cmp	AX,0
	je	SET_EOF
	mov	WORD PTR BUFFILL[BX],AX
	mov	AX,0
	mov	WORD PTR BUFNEXT[BX],AX
	mov	WORD PTR BUFSYNC[BX],AX
	mov	AX,BUFSIZE[BX]
	mov	BUFFULL[BX],AX
	jmp	SHORT endFILLBUF
EOF_RETURN:
	test	BYTE PTR BUFFLAG[BX],BF_ASCII
	je	EOF_OK
	dec	WORD PTR BUFNEXT[BX]
SET_EOF:
	stc
	jmp	SHORT RETURN
CRET_TEST:
	test	BYTE PTR BUFFLAG[BX],BF_ASCII
	je	goodbye
	test	BYTE PTR BUFFLAG[BX],BF_CRETFLG
	jne	goodbye
	or	BYTE PTR BUFFLAG[BX],BF_CRETFLG
IF	@BIGMODEL
	push	DS
	push	BX
	call	fgetc
	add	SP,4
ELSE
	push	BX
	call	fgetc
	add	SP,2
ENDIF
	cmp	AX,RETERROR
	je	goodbye					;leave if error!
	and	BYTE PTR BUFFLAG[BX],NOTBF_CRETFLG
	cmp	AL,NEWLINE
	je	goodbye
	dec	WORD PTR BUFNEXT[BX]
	mov	AL,CRETURN
	jmp	goodbye
SET_ERROR:
	or	BYTE PTR BUFFLAG[BX],BF_ERROR
	mov	BYTE PTR BUFERET[BX],AL
	clc
RETURN:
	mov	AX,RETERROR
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
fgetc	endp

include epilogue.h
	end
+ARCHIVE+ filedir.c     1085  9/28/1984 17:04:44
#include <stdio.h>

/*	get file directory
*/

unsigned char *realloc(); 

struct ff_str { 
  char dummy[21];		/* reserved for dos */ 
  unsigned char attribute;	/* returned attribute */ 
  unsigned time; 
  unsigned date; 
  long size;			/* size of file */ 
  unsigned char fn[13];		/* string containing the filename */ 
}; 

unsigned char *filedir(filename,mode)
unsigned char *filename;
unsigned mode;
{
  struct {int ax,bx,cx,dx,si,di,ds,es;}srv;
  struct ff_str ff_area;    
  unsigned char *result=0;
  int reslen=0; 

#ifdef _C86_BIG 
  srv.ds=((unsigned long)filename)>>16; 
#else 
  segread(&srv.si);		/* get ds value */
#endif 
  srv.dx=filename;
  srv.cx=mode;			/* set search modes */
  bdos(0x1a,&ff_area);		/* set the transfer address */
  for(srv.ax=0x4e00;!(sysint21(&srv,&srv)&1);srv.ax=0x4f00){
    result=realloc(result,reslen+strlen(ff_area.fn)+1); 
    if(result==NULL)return NULL;	/* no memory left */ 
    strcpy(result+reslen,ff_area.fn); 
    reslen+=strlen(ff_area.fn)+1; 
  } 
  return realloc(result,reslen+1); 
} 

+ARCHIVE+ fileio2.h     1080  4/12/1984 10:35:00
/*	fileio2.h	library i/o function header file for dos 2.00
			NEW VERSION - by LPA 1/4/83
*/

struct bufstr{
  unsigned bufflag;		/* control flags etc */
  unsigned char buferet;	/* error return code */
  unsigned char bufuget;	/* unget character storage */
  int bufsize;			/* length of the buffer in bytes */
  int bufnext;			/* next character to be read/written */
  int buffill;			/* the number of characters in buffer */
  int bufsync;			/* for buffer synchronization */
  int buffull;			/* for buffer synchronization */
  unsigned bufhand;		/* the handle for 2.00 files */
  unsigned buffild;     /* the file descriptor for 2.00 files */
  unsigned char bufdata[1];	/* the data buffer */
};

#define BF_READ 1
#define BF_WRITE 2
#define BF_ASCII 4
#define BF_UNGET 8
#define BF_CDEV 0x10
#define BF_DIRTY 0x20
#define BF_ERROR 0x40
#define BF_CRETFLG 0x80

#define MAXFILES 32		/* maximum file number */

extern unsigned char *_opentab[MAXFILES];	/* file table */

struct regval{unsigned ax,bx,cx,dx,si,di,ds,es;};

/*	end of fileio2.h
*/
+ARCHIVE+ fileioa.h      575  4/12/1984 10:35:00
BUFFLAG	EQU	+0
BUFERET	EQU	+2
BUFUGET	EQU	+3
BUFSIZE	EQU	+4
BUFNEXT	EQU	+6
BUFFILL	EQU	+8
BUFSYNC	EQU	+10
BUFFULL	EQU	+12
BUFHAND	EQU	+14
BUFFILD	EQU	+16
BUFDATA	EQU	+18

BF_READ		EQU	1
BF_WRITE	EQU	2
BF_ASCII	EQU	4
BF_UNGET	EQU	8
BF_CDEV		EQU	10H
BF_DIRTY	EQU	20H
BF_ERROR	EQU	40H
BF_CRETFLG	EQU	80H

NEWLINE		EQU	10
CRETURN		EQU	13
EOF		EQU	26
RETERROR	EQU	-1
NOTBF_UGET	EQU	NOT 8
NOTBF_DIRTY	EQU	NOT 32
NOTBF_ERROR	EQU	NOT 64
NOTBF_CRETFLG	EQU	NOT 128
MAXFILES		EQU	32

;;;;;
;ERROR RETURN CODES
;;;;;

EFULDSK	EQU	119
ESKCDEV	EQU	120
+ARCHIVE+ fileno.c       164  9/27/1984 10:30:58
/*	return file descriptor of stream
*/

#include "stdio.h"
#include "fileio2.h"

fileno(stream)
struct bufstr *stream;
{

  return stream->buffild;
}

+ARCHIVE+ fopen.c       1131  9/28/1984 17:04:44
/*	open a file
*/

#include "stdio.h"
#include "fileio2.h"
#include <errno.h>

FILE *fopen(filename,fomode)
unsigned char *filename,*fomode;
{
  int first=0,comode=AREAD-1,rwmode=0,fd;

  while(*fomode){
    switch(*fomode++){
      case 'b':
	comode=BREAD-1;
	continue;
      case 'r':
	if(!first)first=1;		/* open not create */
	rwmode|=1;
	continue;
      case 'w':				/* w+ equ wr */
	if(!first)first=2;		/* create the file */
      case 'a':				/* a+ equ ar */
	if(!first)first=3;		/* open at end, create if reqd */
	rwmode|=2;
	continue;
     case '+':
        if(rwmode&1)rwmode|=2;	       /* if read, set write permission */
        else if(rwmode&2)rwmode|=1;    /* if write, set read permission */
	continue;
    }
    goto err;
  }

  switch(first){
    case 1:
    case 3:
      fd=_open(filename,comode+rwmode,0);
      if(fd!=-1 || first==1 || errno!=2)break;
    case 2:
      fd=_open(filename,comode+rwmode,-0x100);
      break;
    default:
      goto err;
  }
      if(first==3 && fd!=-1)lseek(fd,0L,2);	
      if(fd!=-1)return _opentab[fd];
err:
  return 0;
}
+ARCHIVE+ fputc.asm     2794 10/01/1984 11:45:52
;;;;;
;
; FPUTC.ASM
;
; The new routine which will be the basis for the new IO
; package.
; By LPA - 1/4/84
;
; Input 1) CC     - character to output
;          STREAM - pointer of where to put it
; Returns - BYTE, RETERROR if error
;
;;;;;

	include model.h

IF	@BIGMODEL
	extrn  _flush:far
	extrn  fseek:far
ELSE
	extrn  _flush:near
	extrn  fseek:near
ENDIF
	public fputc

	include prologue.h
	include fileioa.h

IF	@BIGMODEL
CC	EQU	@ab+4[BP]
STREAM	EQU	@ab+6[BP]

fputc	proc	far
	push	ES
	push	DS
ELSE
CC	EQU	@ab[BP]
STREAM	EQU	@ab+2[BP]

fputc	proc	near
ENDIF
	push	BP
	mov	BP,SP
	mov	byte ptr CC+1,0
IF	@BIGMODEL
	lds	BX,DWORD PTR STREAM
ELSE
	mov	BX,STREAM
ENDIF
	and	BYTE PTR BUFFLAG[BX],NOTBF_UGET
	test	BYTE PTR BUFFLAG[BX],BF_DIRTY
	je	NOT_DIRTY
DIRTY_DONE:
	cmp	BYTE PTR CC,NEWLINE
	je	NL_TEST
NL_DONE:
	mov	SI,BUFNEXT[BX]
	mov	AX,CC
	mov	BUFDATA[BX+SI],AL			;move cc to buffer
	inc	WORD PTR BUFNEXT[BX]
	mov	CX,BUFNEXT[BX]
	cmp	CX,BUFFULL[BX]
	jnl	FULL
FINIS:
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
	pop	ES
ENDIF
	ret
NL_TEST:
	test	BYTE PTR BUFFLAG[BX],BF_ASCII
	je	NL_DONE
IF	@BIGMODEL
	push	DS
ENDIF
	push	BX
	mov	AX,CRETURN
	push	AX
	call	fputc
IF	@BIGMODEL
	add	SP,6
ELSE
	add	SP,4
ENDIF
	cmp	AX,RETERROR
	je	FINIS
	or	BYTE PTR BUFFLAG[BX],BF_DIRTY
	mov	BX,STREAM
	jmp	SHORT NL_DONE
NOT_DIRTY:
	or	BYTE PTR BUFFLAG[BX],BF_DIRTY
	cmp	WORD PTR BUFNEXT[BX],0
	je	DIRTY_DONE
	and	BYTE PTR BUFFLAG[BX],NOTBF_DIRTY    ;set for fseek
	test	BYTE PTR BUFFLAG[BX],BF_CDEV
	jz	HOP
	jmp	SHORT IO_ERROR
HOP:
	push	BX
	mov	AX,1
	push	AX			            ;relative seek
	mov	AX,0
	push	AX
	push	AX
IF	@BIGMODEL
	push	DS
ENDIF
	push	BX
	call	fseek
IF	@BIGMODEL
	add	SP,10
ELSE
	add	SP,8
ENDIF
	cmp	AX,RETERROR
	je	RETURN
	pop	BX
	or	BYTE PTR BUFFLAG[BX],BF_DIRTY
	jmp	DIRTY_DONE
FULL:
	cmp	WORD PTR BUFHAND[BX],1		;is it stdout ?
	jne	notstdout
	lea	SI,BUFDATA[BX]
	mov	DL,[SI]				;get the character
	mov	AH,2
	int	21H
	jmp	short donestdout
notstdout:
	push	BX
	mov	AH,40H				;keep in sync
	mov	CX,BUFNEXT[BX]
	lea	DX,BUFDATA[BX]
	mov	BX,BUFHAND[BX]
	int	21H
	pop	BX
	jb	IO_ERROR
	cmp	AX,CX
	jne	FULL_DISK
donestdout:
	xor	AX,AX
	mov	WORD PTR BUFFILL[BX],AX
	mov	WORD PTR BUFNEXT[BX],AX
	mov	WORD PTR BUFSYNC[BX],AX
	mov	AX,BUFSIZE[BX]
	mov	BUFFULL[BX],AX
	and	BYTE PTR BUFFLAG[BX],NOTBF_DIRTY
	mov	AX,CC
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
	pop	ES
ENDIF
	ret
FULL_DISK:
	mov	BYTE PTR BUFERET[BX],EFULDSK
	jmp	SHORT RETURN
IO_ERROR:
	mov	BYTE PTR BUFERET[BX],AL
RETURN:
	or	BYTE PTR BUFFLAG[BX],BF_ERROR
	mov	AX,RETERROR
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
	pop	ES
ENDIF
	ret
fputc	endp

include epilogue.h
	end
+ARCHIVE+ fseek.asm     1828  4/12/1984 10:34:52
;;;;;
;
; FSEEK.ASM
;
;;;;;

	include model.h

IF	@BIGMODEL
	extrn	_FLUSH:far
ELSE
	extrn	_FLUSH:near
ENDIF
	public	FSEEK

	include	prologue.h
	include fileioa.h

IF	@BIGMODEL
BUF	EQU	@ab+2[BP]
POSN	EQU	@ab+6[BP]
POSN2	EQU	@ab+8[BP]
OFFST	EQU	@ab+10[BP]

FSEEK	PROC	FAR
	push	DS
ELSE
BUF	EQU	@ab[BP]
POSN	EQU	@ab+2[BP]
POSN2	EQU	@ab+4[BP]
OFFST	EQU	@ab+6[BP]

FSEEK	PROC	NEAR
ENDIF
	push	BP
	mov	BP,SP
IF	@BIGMODEL
	lds	SI,DWORD PTR BUF
ELSE
	mov	SI,BUF
ENDIF
	test	BYTE PTR BUFFLAG[SI],BF_CDEV	;if(CHAR DEV) error
	jne	IO_ERROR
	and	BYTE PTR BUFFLAG[SI],NOTBF_UGET
	test	BYTE PTR BUFFLAG[SI],BF_DIRTY
	je	NOT_DIRTY
IF	@BIGMODEL
	push	DS
	push	SI
	call	_FLUSH
	add	SP,4
ELSE
	push	SI
	call	_FLUSH
	add	SP,2
ENDIF
	cmp	AX,RETERROR
	je	RETURN
NOT_DIRTY:
	mov	AX,OFFST
	mov	DX,POSN
	mov	CX,POSN2
	cmp	AL,1
	je	RELATIVE
	cmp	AL,0
	je	DO_SEEK
	cmp	AL,2
	je	DO_SEEK
	jmp	SHORT IO_ERROR
RELATIVE:
	mov	BX,DX
	mov	AX,BUFFILL[SI]
	neg	AX
	add	AX,BUFNEXT[SI]
	cwd
	add	BX,AX
	adc	CX,DX			;know that ((-fill+next)!>2**16)
	mov	DX,BX
	mov	AL,1
DO_SEEK:
	mov	AH,42H
	mov	BX,BUFHAND[SI]
	int	21H
	mov	BX,AX
	xor	CX,CX
	mov	WORD PTR BUFFILL[SI],CX
	mov	WORD PTR BUFNEXT[SI],CX
	mov	CX,BUFSIZE[SI]		;must be power of 2! (for mod op)
	dec	CX
	and	BX,CX			;sync = ret position % bufsize
	mov	WORD PTR BUFSYNC[SI],BX ;
	inc	CX
	sub	CX,BX		       	;BUFFULL=BUFSIZE-BUFSYNC;
	mov	WORD PTR BUFFULL[SI],CX
RETURN:
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
IO_ERROR:
	mov	BYTE PTR BUFERET[SI],ESKCDEV
	jmp	SHORT IO_RETURN
SET_ERROR:
	mov	BYTE PTR BUFERET[SI],AL
IO_RETURN:
	or	BYTE PTR BUFFLAG[SI],BF_ERROR
	mov	AX,RETERROR
	mov	DX,AX
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
FSEEK	ENDP

	include	epilogue.h
	end
+ARCHIVE+ getw.c         215  9/27/1984 10:30:58
/*	get a word from a file
*/

#include "stdio.h"
#include "fileio2.h"

getw(buf)
struct bufstr *buf;
{
  unsigned word;

  word=fgetc(buf);
  if(feof(buf))return EOF;
  return word|(fgetc(buf)<<8);
}
+ARCHIVE+ loadexec.asm  1580  5/03/1984 15:37:40
;	load or execute a program (according to microsoft)

;	WARNING - BUG FIX CODE IN THIS VERSION REQUIRES
;	272 BYTES OF STACK SPACE, AND DOES NOT CHECK THAT IT
;	IS AVAILABLE.  IF IN DOUBT, USE CORELEFT BEFORE
;	CALLING THIS FUNCTION

	include	model.h
	include	prologue.h

;	note all pointers have to be in big model format

;	entry	1, pointer to the file name
;		2, pointer to the control block
;		3, function value for register al
;	exit	zero if ok, else DOS error code

@code	ends
@datai	segment
savess	dw	0
savesp	dw	0
@datai	ends

a1	equ	@ab
a2	equ	@ab+4
a3	equ	@ab+8

@code	segment

	public	loadexec
if	@bigmodel
loadexec	proc	far
else
loadexec	proc	near
endif
	push	bp
	mov	bp,sp			;so we can see stack
	mov	dgroup:savess,ss	;save the stack
	mov	dgroup:savesp,sp	;and the stack pointer
	lds	dx,dword ptr a1[bp]		;get file name string
	les	bx,dword ptr a2[bp]		;parameter block
	mov	al,a3[bp]		;and sub function code
	mov	ah,4bh

;	THIS CODE REQUIRED BY BUG IN V2.00

	PUSHF
	POP	DI
	CLI
	SHR	BP,1
	SHR	BP,1
	SHR	BP,1
	SHR	BP,1
	SUB	BP,17
	MOV	SI,SS
	ADD	SI,BP
	MOV	SS,SI
	MOV	SP,256
	PUSH	DI
	POPF
;	END OF BUG FIX

	int	21h			;away we go....
	jc	fail			;did not make it
	xor	ax,ax			;say successful
fail:
	mov	dx,dgroup		;restore segments
	mov	ds,dx			;data segment
	pushf				;save the flags
	pop	dx			;in dx for now
	cli				;no interrupts please
	mov	ss,dgroup:savess
	mov	sp,dgroup:savesp
	push	dx
	popf				;restore the interrupt status
	pop	bp
	ret
loadexec	endp

	include	epilogue.h
	end
+ARCHIVE+ lseek.c        287  9/27/1984 10:31:00
/*	do a seek on a file
*/

#include "stdio.h"
#include "fileio2.h"

long lseek(fd,offset,base)
int fd;				/* the file to seek */
long offset;			/* how far to move */
int base;			/* base to move from */
{
  extern long fseek();

  return fseek(_opentab[fd],offset,base);
}
+ARCHIVE+ mkdir.c        417  9/27/1984 10:31:00
/*	make a directory  dos 2.00
*/

#include "fileio2.h"

mkdir(dir)
unsigned char *dir;
{
  struct regval srv;

#ifdef _C86_BIG
  srv.ds=((unsigned long)dir)>>16;
#else
  segread(&srv.si);	/* saves additional structure */
#endif
  srv.dx=dir;		/* address of drive and directory path names */
  srv.ax=0x3900; 	/* dos 2.0 MKDIR function call */
  if(sysint21(&srv,&srv)&1)return -1;
  return 0;
} 	
+ARCHIVE+ putw.c         244  9/27/1984 10:31:00
/*	put a word to a file
*/

#include "stdio.h"
#include "fileio2.h"

putw(w,buf)
unsigned w;
struct bufstr *buf;
{

  if(fputc(w,buf)==EOF)return EOF;	/* really error status */
  if(fputc(w>>8,buf)==EOF)return EOF;
  return w;
}
+ARCHIVE+ read.asm      6176  9/21/1984 15:36:44
;;;;;;
; READ.ASM
; read characters to a character device or to ascii or binary files
; for use with DOS 2.0 and above library only
; (written by LPA, 12/19/83)
;
;	input	1, file descriptor
;		2, pointer to buffer
;		3, number of chars to write
;
;	returns # of chars read, 0 if EOF, RETERROR if I/O ERROR
;
; *** WARNING ***
; READ.ASM uses the returns of FGETC.ASM.  If you alter FGETC.ASM
; you must also alter READ.ASM accordingly!  Specifically watch out
; for the Carry Flag returns from FGETC.ASM
; *** WARNING ***
;;;;;

	include model.h

IF	  @BIGMODEL
	  extrn	    _FLUSH:far
          extrn     _EXIT:far
	  extrn	    _dos2err:far
          extrn     FGETC:far
          extrn     _OPENTAB:dword
ELSE
	  extrn	    _FLUSH:near
          extrn     _EXIT:near
	  extrn	    _dos2err:near
          extrn     FGETC:near
          extrn     _OPENTAB:word
ENDIF
          public    READ

	  include   prologue.h
	  include   fileioa.h

IF	@BIGMODEL
FD		EQU	@ab+4[BP]	;file descriptor
BUFFER		EQU	@ab+6[BP]	;ptr to buffer to write
COUNT		EQU	@ab+10[BP]	;length of buffer
ELSE
FD		EQU	@ab[BP]		;file descriptor
BUFFER		EQU	@ab+2[BP]	;ptr to buffer to write
COUNT		EQU	@ab+4[BP]	;length of buffer
ENDIF

;;;;;
;
;user controllable definitions with the system defaults.
;WARNING: DO NOT CHANGE W/O LOOKING AT FILEIO2.H ALSO!!
;they must be consistant.
;
;;;;;

WEXITCODE	EQU	-32626

@CODE     ENDS
@DATAC	  SEGMENT
RMESS	  db	'READ'
@DATAC	  ENDS
 
@CODE	  SEGMENT   BYTE PUBLIC 'CODE'
IF 	  @BIGMODEL
READ      PROC      FAR
	  push	    ES
	  push	    DS
ELSE
READ      PROC      NEAR
ENDIF
          push      BP			;
          mov       BP,SP		;
	  mov	    SI,FD		;
          cmp       SI,MAXFILES		;if (fd>MAXFILES) error 
          jae       error		;
IF	  @BIGMODEL
          shl       SI,1		;
          shl       SI,1		;
          lds       BX,_OPENTAB[SI]	;
ELSE
          shl       SI,1		;
          mov       BX,_OPENTAB[SI]	;
	  push	    ds 			; es <- ds for movsb
	  pop	    es
ENDIF

	  or	    BX,BX 		;test for null
	  je	    error
	  test	    BYTE PTR BUFFLAG[BX],BF_READ
          jnz       error		;
	  mov	    CX,COUNT
	  jcxz	    null_buffer		;test for count=0
	  cld
	  test 	    BYTE PTR BUFFLAG[BX],BF_ASCII
	  jz	    TEST_BINARY
NOT_BIG_ENUF:
IF	  @BIGMODEL
	  les	    DI,DWORD PTR BUFFER
ELSE
	  mov	    DI,BUFFER
ENDIF
	  xor	    AH,AH
bigloop:			
	  push      CX
IF	  @BIGMODEL
	  push	    DS
	  push	    BX
	  call	    fgetc
	  jb	    SET_EOF
	  add	    SP,4
ELSE
	  push	    BX
	  call	    fgetc
	  jb	    SET_EOF
	  add	    SP,2
ENDIF
	  cmp	    AX,RETERROR
	  je	    done
	  stosb
	  cmp	    AX,NEWLINE
	  je	    END_READ
JUST_BINARY:
	  pop	    CX
	  loop	    bigloop
null_buffer:
	  mov	    AX,COUNT
done:					;
          mov       SP,BP		;
          pop       BP			;
IF	  @BIGMODEL
	  pop	    DS
	  pop	    ES
ENDIF
          ret				;
END_READ:
	  test	    BYTE PTR BUFFLAG[BX],BF_ASCII
	  jz	    JUST_BINARY
	  pop	    CX
	  dec	    CX
	  jmp	    SHORT ASCII_NL
SET_EOF:
IF	  @BIGMODEL
	  add	    SP,4
ELSE
	  add	    SP,2
ENDIF
	  pop	    CX
ASCII_NL:
	  mov	    AX,COUNT
	  sub	    AX,CX
	  jmp	    SHORT done
error:					;
	  mov	    AX,4
	  push	    AX
	  mov	    AX,OFFSET DGROUP:RMESS
IF	  @BIGMODEL
	  push	    DS
ENDIF
	  push	    AX
	  call	    _dos2err
          mov       AX,WEXITCODE	;
          push      AX			;
          call      _EXIT		;
TEST_BINARY:
	  mov	    AX,BUFFILL[BX]
	  or	    AX,AX
	  jne	    TEST2
	  cmp	    CX,BUFSIZE[BX]	;bigger than bufsize?
	  jl	    NOT_BIG_ENUF
TEST2:
	  sub	    AX,BUFNEXT[BX]
	  cmp	    AX,CX
	  jge	    NOT_BIG_ENUF
	  test	    BYTE PTR BUFFLAG[BX],BF_DIRTY
	  jz	    NOT_DIRTY
	  push	    BX
	  push	    CX
	  push	    BX
	  call	    _FLUSH
	  add	    SP,2
	  pop	    CX
	  pop	    BX
	  cmp	    AX,RETERROR
	  jne	    NOT_DIRTY
	  jmp	    RETURN
NOT_DIRTY:
IF	  @BIGMODEL
	  les	    DI,DWORD PTR BUFFER
ELSE
	  mov	    DI,BUFFER
ENDIF
	  test	    BYTE PTR BUFFLAG[BX],BF_UNGET
	  jne	    DO_UNGET
UNGET_DONE:
	  cmp	    WORD PTR BUFFILL[BX],0
	  je	    FILL_BUFFER
	  lea	    SI,BUFDATA[BX]
	  add	    SI,BUFNEXT[BX]
	  xchg	    CX,AX
	  sub	    AX,CX
	  rep	    movsb
	  mov	    CX,AX
	  mov	    AX,0
	  mov	    WORD PTR BUFFILL[BX],AX
	  mov	    WORD PTR BUFNEXT[BX],AX
FILL_BUFFER:
	  sub	    COUNT,CX			;hold difference!
	  mov	    AX,CX
	  mov	    DX,BUFSIZE[BX]		;cx-=(cx%BUFSIZE);
	  dec	    DX				;bufsize is power of 2!
	  and	    AX,DX			;
	  sub	    CX,AX
	  jcxz	    NO_BIGREAD
	  push	    AX
	  push	    BX
	  mov	    AH,3FH
	  mov	    BX,BUFHAND[BX]
	  mov	    DX,DI
IF	  @BIGMODEL
	  push	    DS
	  push	    ES
	  pop	    DS
ENDIF
	  int	    21H
IF	  @BIGMODEL
	  pop	    DS
ENDIF
	  pop	    BX
	  pop	    CX
	  jb	    SET_ERROR			;test error return
	  add	    COUNT,AX
	  add	    DI,AX
DO_READ:
IF	  @BIGMODEL
	  mov	    SI,BUFFILD[BX]
	  mov	    AX,DS
	  pop	    DX
	  pop	    DS
	  push	    AX
	  push	    DX
	  push	    CX
	  push	    ES
	  push	    DI
	  push	    SI
	  call	    read			;call to get last set up!
	  add	    SP,8
	  mov	    BX,DS
	  pop	    DX
	  pop	    DS
	  push	    BX
	  push	    DX
ELSE
	  push	    CX
	  push	    DI
	  mov	    AX,BUFFILD[BX]
	  push	    AX
	  call	    read			;call to get last set up!
	  add	    SP,6
ENDIF
	  cmp	    AX,-1
	  je	    SKIP
	  add	    AX,COUNT
SKIP:
	  mov	    SP,BP
	  pop	    BP
IF	  @BIGMODEL
	  pop	    DS
	  pop	    ES
ENDIF
	  ret
DO_UNGET:
	  push	    AX
	  mov	    AL,BUFUGET[BX]
	  stosb
	  dec	    CX
	  pop	    AX
	  and	    BYTE PTR BUFFLAG[BX],NOTBF_UGET
	  jmp	    SHORT UNGET_DONE
NO_BIGREAD:
	  mov	    CX,AX
	  jmp	    SHORT DO_READ
SET_ERROR:
	  or	    BYTE PTR BUFFLAG[BX],BF_ERROR
	  mov	    BYTE PTR BUFERET[BX],AL
	  mov	    AX,RETERROR
RETURN:
	  mov	    SP,BP
	  pop	    BP
IF	  @BIGMODEL
	  pop	    DS
	  pop	    ES
ENDIF
	  ret
READ     ENDP				

          include epilogue.h
          end
+ARCHIVE+ rename.c       564  9/27/1984 10:31:02
/*	rename a file for dos 2.00
*/

#include "fileio2.h"

rename(filefrom,fileto)
unsigned char *filefrom,*fileto;
{ 
  struct regval srv;

#ifdef _C86_BIG
  srv.ds=((unsigned long)filefrom)>>16;
  srv.es=((unsigned long)fileto)>>16;
#else
  segread(&srv.si);	/* saves use of additional structure */
  srv.es=srv.ds;	/* can't depend on value in es */
#endif
  srv.ax=0x5600;	/* dos 2.0 function to rename file */
  srv.dx=filefrom;	/* old file name */
  srv.di=fileto;	/* new file name */
  if(sysint21(&srv,&srv)&1)return -1;
  return 0;
}

+ARCHIVE+ rmdir.c        390  9/27/1984 10:31:02
/*	remove a directory dos 2.00
*/

#include "fileio2.h"

rmdir(dir)
char *dir;
{
  struct regval srv;

#ifdef _C86_BIG
  srv.ds=((unsigned long)dir)>>16;
#else
  segread(&srv.si);	/* saves additional structure */
#endif
  srv.dx=dir;		/* address of directory path */
  srv.ax=0x3A00;	/* dos 2.0 RMDIR function call */
  if(sysint21(&srv,&srv)&1)return -1;
  return 0;
}
+ARCHIVE+ system.c      1880  9/27/1984 10:31:00
/*	run a program under the system function
	returns zero if succesful
*/


static unsigned char switchar()
{
struct { unsigned int ax,bx,cx,dx,si,di,ds,es; } srv;

   srv.ax = 0x3700;
   sysint21(&srv,&srv);
   return srv.dx&0xff;
}

#ifdef _C86_BIG

system(prog)
unsigned char *prog;
{
  struct {unsigned int ax,bx,cx,dx,si,di,ds,es;}srv;
  struct {
    int env_seg;
    char *line;
    char *fcb1;
    char *fcb2;
  } ctrl;
  unsigned char *ep, cline[128],*envfind();
  int status = -1;

  if(strlen(prog)>123)goto all_done;	/* too  long to use */
  srv.ax=0x4800;
  srv.bx=0xfff0;			/* look for a lot of memory */
  if((sysint21(&srv,&srv)&1) && srv.bx<(64*17))goto all_done;
  cline[0]=strlen(prog)+3;
  cline[1]=switchar()&0xff;
  strcpy(cline+2,"C ");
  strcpy(cline+4,prog);
  strcat(cline,"\r");

  ctrl.env_seg=0;
  ctrl.line=cline;
  if(ep=envfind("COMSPEC")){
    status=loadexec(ep,&ctrl,0);
    free(ep);
  } 
all_done:
  return status;
}

#else

system(prog)
unsigned char *prog;
{
  extern int _PSPSEG[2];
  struct {unsigned int ax,bx,cx,dx,si,di,ds,es;}srv;
  struct {
    int env_seg;
    char *line_off,*line_seg;
    char *fcb1_off,*fcb1_seg;
    char *fcb2_off,*fcb2_seg;
  } ctrl;
  unsigned char cline[128],*ep,*envfind();
  int status=-1;

  if(strlen(prog)>123)goto all_done;	/* too  long to use */
  srv.ax=0x4800;
  srv.bx=0xfff0;			/* look for a lot of memory */
  if((sysint21(&srv,&srv)&1) && srv.bx<(64*17))goto all_done;
  cline[0]=strlen(prog)+3;
  cline[1]=switchar()&0xff;
  strcpy(cline+2,"C ");
  strcpy(cline+4,prog);
  strcat(cline,"\r");
  segread(&srv.si);
  ctrl.env_seg=0;
  ctrl.line_off=cline;
  ctrl.line_seg=srv.ds;
  if(ep=envfind("COMSPEC")){
    status=loadexec(ep,srv.ds,&ctrl,srv.ds,0);
    free(ep);
  }
all_done:
  return status;
}

#endif
+ARCHIVE+ ungetc.c       193  9/27/1984 10:31:04
/* unget a char from the input stream
*/

#include "fileio2.h"

ungetc(cc,buf)
unsigned int cc;
struct bufstr *buf;
{
  buf->bufflag|=BF_UNGET;
  buf->bufuget=cc;
  return cc;
}

+ARCHIVE+ unlink.c       373  9/27/1984 10:31:04
/*	delete a file dos2.0 only
*/

#include "fileio2.h"

unlink(filename)
unsigned char *filename;
{
  struct regval srv;

  srv.dx=filename;
  srv.ax=0x4100;
#ifdef _C86_BIG
  srv.ds=((unsigned long)filename)>>16;
#else
  segread(&srv.si);	/* saves use of separate structure */
#endif
  if(sysint21(&srv,&srv)&1)return -1;
  return 0;		/* success */
}

+ARCHIVE+ write.asm     5892  9/21/1984 15:36:10
;;;;;
; WRITE.ASM
; write characters to a character device or to ascii or binary files
; for use with DOS 2.0 (and above) library only
; (written by LPA, 1/17/83)
;;;;;

;	input	1, file descriptor
;		2, pointer to buffer
;		3, number of chars to write
;
;	returns # of chars to write, -1 if EOF

	include model.h

IF	@BIGMODEL
	  extrn	    _FLUSH:far
	  extrn	    fseek:far
	  extrn	    _EXIT:far
	  extrn	    _DOS2ERR:far
	  extrn	    FPUTC:far
	  extrn	    _OPENTAB:dword
ELSE

	  extrn	    _FLUSH:near
	  extrn	    fseek:near
          extrn     _EXIT:near
	  extrn	    _DOS2ERR:near
          extrn     FPUTC:near
          extrn     _OPENTAB:word
ENDIF
          public    WRITE

	  include   prologue.h
	  include   fileioa.h

IF	@BIGMODEL
FD		EQU	@ab+4[BP]	;file descriptor
BUFFER		EQU	@ab+6[BP]	;ptr to buffer to write
COUNT		EQU	@ab+10[BP]	;length of buffer
ELSE
FD		EQU	@ab[BP]		;file descriptor
BUFFER		EQU	@ab+2[BP]	;ptr to buffer to write
COUNT		EQU	@ab+4[BP]	;length of buffer
ENDIF

;;;;;
;
;user controllable definitions with the system defaults.
;WARNING: DO NOT CHANGE W/O LOOKING AT FILEIO2.H ALSO!!
;they must be consistant.
;
;;;;;

WEXITCODE	EQU	-32626

@CODE     ENDS
@DATAC	  SEGMENT
WMESS	  db	    'WRITE'
@DATAC	  ENDS

@CODE	  SEGMENT   BYTE PUBLIC 'CODE'
IF	  @BIGMODEL
WRITE	  PROC	    FAR
	  push	    ES
	  push	    DS
ELSE
WRITE     PROC      NEAR
ENDIF
          push      BP			;
          mov       BP,SP		;
	  mov	    SI,FD		;
          cmp       SI,MAXFILES		;if (fd>MAXFILES) error 
          jae       error		;
IF	  @BIGMODEL
	  shl	    SI,1
	  shl	    SI,1
	  lds	    BX,_OPENTAB[SI]
ELSE
          shl       SI,1		;
          mov       BX,_OPENTAB[SI]	;
	  push	    ds			; es <- ds for movsb
	  pop	    es
ENDIF
	  or	    BX,BX		;test for null fp
	  je	    error
	  test	    BYTE PTR BUFFLAG[BX],BF_WRITE
          jnz       error		;
	  test	    BYTE PTR BUFFLAG[BX],BF_DIRTY
	  jne	    DIRTY_DONE
	  jmp	    NOT_DIRTY
DIRTY_DONE:
	  mov	    CX,COUNT
	  jcxz	    null_count		;test for count=0
IF	  @BIGMODEL
	  les	    SI,DWORD PTR BUFFER
ELSE
	  mov	    SI,BUFFER
ENDIF
	  cld
	  test	    BYTE PTR BUFFLAG[BX],BF_ASCII
	  jz	    TEST_BINARY
NOT_TOO_BIG:
	  xor	    AH,AH
bigloop:			
IF	  @BIGMODEL
	  push	    DS
	  mov	    DX,ES
	  mov	    DS,DX
	  lodsb
	  pop	    DS
ELSE
	  lodsb
ENDIF
	  push	    CX
	  push	    SI
IF	  @BIGMODEL
	  push	    DS
ENDIF
	  push	    BX
	  push	    AX
	  call	    fputc
IF	  @BIGMODEL
	  add	    SP,6
ELSE
	  add	    SP,4
ENDIF
	  cmp	    AX,RETERROR
	  je	    done
	  pop	    SI
	  pop	    CX
	  loop	    bigloop
null_count:
	  mov	    AX,COUNT
done:					;
          mov       SP,BP		;
          pop       BP			;
IF	  @BIGMODEL
	  pop	    DS
	  pop	    ES
ENDIF
          ret				;
error:					;
	  mov	    AX,5
	  push	    AX
IF	  @BIGMODEL
	  push	    DS
ENDIF
	  mov	    AX,OFFSET DGROUP:WMESS
	  push	    AX
	  call	    _dos2err
          mov       AX,WEXITCODE	;
          push      AX			;
          call      _EXIT		;
TEST_BINARY:
	  mov	    AX,BUFFULL[BX]
	  sub	    AX,BUFNEXT[BX]
	  cmp	    AX,CX
	  jg	    NOT_TOO_BIG
	  sub	    CX,AX
	  xchg	    AX,CX
	  lea	    DI,BUFDATA[BX]
	  add	    DI,BUFNEXT[BX]
IF	  @BIGMODEL
	  push	    DS
	  push	    ES
	  pop	    DS
	  pop	    ES
	  rep	    movsb
	  push	    DS
	  push	    ES
	  pop	    DS
	  pop	    ES
ENDIF
	  rep	    movsb
	  push	    AX
	  push	    BX
	  mov	    AH,40H
	  mov	    CX,BUFFULL[BX]
	  lea	    DX,BUFDATA[BX]
	  mov	    BX,BUFHAND[BX]
	  int	    21H
	  pop	    BX
	  jb	    SET_ERROR
	  cmp	    AX,CX
	  jne	    FULL_DISK
	  pop	    CX
	  jcxz	    RESET_BUF
	  mov	    DX,BUFSIZE[BX]
	  cmp	    CX,DX		;
	  jl	    FILL_BUFFER
	  mov	    AX,CX
	  dec	    DX
	  and	    AX,DX 		;ax=cx%bufsize
	  sub	    CX,AX
	  push	    AX
	  push	    BX
	  mov	    AH,40H
	  mov	    BX,BUFHAND[BX]
IF	  @BIGMODEL
	  push	    DS
	  mov	    DX,ES
	  mov	    DS,DX
ENDIF
	  mov	    DX,SI
	  add	    SI,CX
	  int	    21H
IF	  @BIGMODEL
	  pop	    DS
ENDIF
	  pop	    BX
	  jb	    SET_ERROR
	  cmp	    AX,CX
	  jne	    FULL_DISK
	  pop	    CX
	  jcxz	    RESET_BUF
FILL_BUFFER:
	  mov	    WORD PTR BUFNEXT[BX],CX
	  or	    BYTE PTR BUFFLAG[BX],BF_DIRTY
	  lea	    DI,BUFDATA[BX]
IF	  @BIGMODEL
	  push	    DS
	  push	    ES
	  pop	    DS
	  pop	    ES
	  rep	    movsb
	  push	    DS
	  push	    ES
	  pop	    DS
	  pop	    ES
ENDIF
	  rep	    movsb
	  jmp	    SHORT OUTAHERE
RESET_BUF:
	  and	    BYTE PTR BUFFLAG[BX],NOTBF_DIRTY
	  mov	    WORD PTR BUFNEXT[BX],0
OUTAHERE:
	  mov	    AX,0
	  mov	    WORD PTR BUFFILL[BX],AX
	  mov	    WORD PTR BUFSYNC[BX],AX
	  mov	    AX,BUFSIZE[BX]
	  mov	    WORD PTR BUFFULL[BX],AX
	  mov	    AX,COUNT
	  mov	    SP,BP
	  pop	    BP
IF	  @BIGMODEL
	  pop	    DS
	  pop	    ES
ENDIF
	  ret
FULL_DISK:
	  mov	    BYTE PTR BUFERET[BX],EFULDSK
	  jmp	    SHORT RETURN
SET_ERROR:
	  mov	    BYTE PTR BUFERET[BX],AL
	  mov	    AX,RETERROR
RETURN:
	  or	    BYTE PTR BUFFLAG[BX],BF_ERROR
	  mov	    SP,BP
	  pop	    BP
IF	  @BIGMODEL
	  pop	    DS
	  pop	    ES
ENDIF
	  ret
NOT_DIRTY:
	or	BYTE PTR BUFFLAG[BX],BF_DIRTY
	cmp	WORD PTR BUFNEXT[BX],0
	jne	SKIP
	jmp	DIRTY_DONE
SKIP:
	and	BYTE PTR BUFFLAG[BX],NOTBF_DIRTY    ;set for fseek
	test	BYTE PTR BUFFLAG[BX],BF_CDEV
	jz	HOP
	jmp	SHORT RETURN
HOP:
	push	BX
	mov	AX,1
	push	AX			            ;relative seek
	mov	AX,0
	push	AX
	push	AX
IF	@BIGMODEL
	push	DS
ENDIF
	push	BX
	call	fseek
IF	@BIGMODEL
	add	SP,10
ELSE
	add	SP,8
ENDIF
	cmp	AX,RETERROR
	je	RETURN
	pop	BX
	or	BYTE PTR BUFFLAG[BX],BF_DIRTY
	jmp	DIRTY_DONE
WRITE    ENDP				

          include epilogue.h
          end
+ARCHIVE+ ydos2err.asm   911  9/28/1984 14:13:20
;;;;;
;
; _DOS2ERR.ASM
;
; This function will print out a given error message to the
; STDERR file.  It uses DOS 2.0 system interrupts.
; 2/20/84 - By LPA
;
; Input 1) MSG - pointer to the message to print out.
;	2) SIZE- size of the message
;
; Returns # of char's written, or RETERROR if I/O ERROR
;
;;;;;

	include model.h

	public _dos2err

	include prologue.h
	include fileioa.h

IF	@BIGMODEL
MSG	EQU	@ab+2[BP]
_SIZE	EQU	@ab+6[BP]

_DOS2ERR	proc	far
	push	DS
ELSE
MSG	EQU	@ab[BP]
_SIZE	EQU	@ab+2[BP]

_DOS2ERR	proc	near
ENDIF
	push	BP
	mov	BP,SP
	mov	AH,40H
	mov	BX,2		;stderr!!
	mov	CX,_SIZE
IF	@BIGMODEL
	lds	DX,DWORD PTR MSG
ELSE
	mov	DX,MSG
ENDIF
	int	21H
	jb	SET_ERROR
	cmp	AX,CX
	jne	SET_ERROR
RETURN:
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
SET_ERROR:
	mov	AX,RETERROR
	jmp	SHORT RETURN
_DOS2ERR	endp

include	epilogue.h
	end
+ARCHIVE+ yflush.asm    1309  9/28/1984 14:13:20
;;;;;
;
; _FLUSH.ASM
;
; The new routine which will be part of the new IO
; package.
; By LPA - 1/6/84
;
; Input 1) STREAM - pointer of stream to flush
;
; Returns - # of CHARS FLUSHED ,RETERROR if NOT FULL FLUSH OR I/O ERROR
;
;;;;;

	include model.h

	public _flush

	include prologue.h
	include fileioa.h

IF	@BIGMODEL
STREAM	EQU	@ab+2[BP]

_FLUSH	proc	far
	push	DS
ELSE
STREAM	EQU	@ab[BP]

_FLUSH proc	near
ENDIF
	push	BP
	mov	BP,SP
IF	@BIGMODEL
	lds	SI,DWORD PTR STREAM
ELSE
	mov	SI,STREAM
ENDIF
	mov	AH,40H
	mov	BX,BUFHAND[SI]
	mov	CX,BUFNEXT[SI]			;
	lea	DX,BUFDATA[SI]
	int	21H				;  flush buffer
	jb	SET_ERROR			;  check CF for I/O error
	cmp	AX,CX				;
	jne	IO_ERROR			;  test for full disk
	mov	CX,0
	mov	WORD PTR BUFFILL[SI],CX	;  next=fill=0
	mov	WORD PTR BUFNEXT[SI],CX	;
	add	WORD PTR BUFSYNC[SI],AX
	sub	WORD PTR BUFFULL[SI],AX
	and	BYTE PTR BUFFLAG[SI],NOTBF_DIRTY; set flag ~DIRTY
	mov	SP,BP				;return }
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
SET_ERROR:
	mov	BYTE PTR BUFERET[SI],AL
	jmp	SHORT RETURN

IO_ERROR:
	mov	BYTE PTR BUFERET[SI],EFULDSK	;error return code
RETURN:
	or	BYTE PTR BUFFLAG[SI],BF_ERROR
	mov	AX,RETERROR
	mov	SP,BP
	pop	BP
IF	@BIGMODEL
	pop	DS
ENDIF
	ret
_FLUSH	endp

include epilogue.h
	end
+ARCHIVE+ ymain.c       2845  9/28/1984 14:13:20
/*	C level interface to user programs for dos 2.00
*/

#include "stdio.h"
#include "fileio2.h"

#define MAXARG 32

FILE *stdin, *stdout, *stderr;
extern unsigned char *calloc();
extern int _sysvers;
extern unsigned int _BUFSIZE;

_main(cl_ptr)
unsigned char *cl_ptr;
{
  struct regval srv;
  unsigned char *cp,*argv[MAXARG+1];
  int j,argc;
  long ftell();

/*	check that that the OS is DOS 2.0 or better
*/

  if (!_sysvers) {
    bdos(9,"NEEDS DOS 2.0$");
    _exit(0x800f);
  }

  cp=cl_ptr;				/* get address of command line */
  for(j=*cp++;j--;++cp){
    if(*cp==' ' || *cp=='\t')*cp=0;	/* set spaces and tabs to null */
  }
  *cp=0;				/* a final terminator */

/*	build the arg lists
*/

  cp=cl_ptr;
  argc=1;
  for(j=*cp++ + 1;j--;++cp){
    if(!*cp)continue;			/* skip leading nulls */
    argv[argc++]=cp;			/* grab the argument */
    if(argc>=MAXARG)break;
    while(*cp){++cp;--j;}		/* and skip the data */
  }
  argv[argc]=NULL;

/* if _BUFSIZE >0x800 set to 0x8000   */

  if (_BUFSIZE > 0x8000) _BUFSIZE=0x8000;

/*	set up stdin, stdout, & stderr
*/

  /* stdin */ 
  stdin=_opentab[0]=calloc(1,(sizeof(struct bufstr)+136));
  stdin->bufflag=(BF_CDEV|BF_ASCII|BF_WRITE);
  stdin->buffull=stdin->bufsize=136;
  stdin->bufhand=stdin->buffild=0;

   /* stdout */ 
   srv.ax=0x4400;
   srv.bx=1;
   sysint21(&srv,&srv);
   if (srv.dx&128) {	/* console (device) */
      stdout=_opentab[1]=calloc(1,(sizeof(struct bufstr)+1));
      stdout->bufflag=(BF_CDEV|BF_ASCII|BF_READ);
      stdout->buffull=stdout->bufsize=stdout->bufhand=1;
   } else {           /* redirected disk file */
      srv.ax=0x4500;        /* duplicate file handle */
      srv.bx=1;
      sysint21(&srv,&srv);
      stdout=_opentab[1]=calloc(1,(sizeof(struct bufstr)+_BUFSIZE));
      stdout->bufflag=(BF_ASCII|BF_READ);
      stdout->bufsize=_BUFSIZE;
      stdout->bufsync=(ftell(stdout)%_BUFSIZE); /* for append & create */
      stdout->buffull=_BUFSIZE-(stdout->bufsync);
      stdout->bufhand=srv.ax;
    } 
    stdout->buffild=1;

    /* stderr */ 
    stderr=_opentab[2]=calloc(1,(sizeof(struct bufstr)+1));
    stderr->bufflag=(BF_CDEV|BF_ASCII|BF_READ);
    stderr->buffull=stderr->bufsize=1;
    stderr->bufhand=stderr->buffild=2;


#ifdef DEBUG
write(2,"before print in debug for redirection\n\r",39);
fprintf(stderr,"fild = %d,hand=%d, size=%d, flag=%d, sync=%d, full=%d, tell=%ld\n",
   stdout->buffild,stdout->bufhand,stdout->bufsize,stdout->bufflag,stdout->bufsync,
   stdout->buffull,
	ftell(stdout));
#endif

/*	check if too many args
*/
    if(argc>=MAXARG){ 
      write(2,"\nTOO MANY ARGS",14);
      _exit(0x8082);
    }

/*	now execute the program
*/

  argv[0]="c";				/* don't know program name */
  exit(main(argc,argv));
}
+ARCHIVE+ yopen.c       2382  9/28/1984 14:13:22
/*	common open routine
	for NEW IO MODEL - by LPA 1/4/84
	REVISED TO SPECIAL CASE DOS 2.0 BUG 2/10/84
*/

#include "fileio2.h"
#include "errno.h"

extern unsigned char *calloc(),*malloc();
extern unsigned int _BUFSIZE;
unsigned char *_opentab[MAXFILES];

_open(filename,mode,new)
unsigned char *filename;
unsigned mode,new;
{
  int i,j,k,fd;
  int tempsize;
  char *tempfnam;
  char buffer[4];  /* holds CON,PRN or AUX for 2.0 bug */
  unsigned int temphand,temp1,temp2;
  struct bufstr *buf=0;
  struct regval srv;

  /*  special case for PC-DOS 2.0 bug */

  if ((strlen(filename)==4)&&(filename[3]==':')) {
    for (i=0;i<3;i++)
      buffer[i]=toupper(filename[i]);
    buffer[3]='\0';
    tempfnam = buffer;
  } else tempfnam = filename;

  /* check _BUFSIZE to make sure it's a power of 2 and not zero! */

  if ((!_BUFSIZE)||(_BUFSIZE&(_BUFSIZE-1))) {
    for (temp1=1,temp2=1;temp2<_BUFSIZE;temp1=temp2,temp2*=2) ;
    _BUFSIZE=temp1;    /* set _BUFSIZE to power of 2 < _BUFSIZE */
  }

  srv.ax=0x3d00+new+(mode&3);
  srv.cx=0;				/* if its a create */
  srv.dx=tempfnam;
#ifdef _C86_BIG
  srv.ds=((unsigned long)tempfnam)>>16;
#else
  segread(&srv.si);
#endif
  if(sysint21(&srv,&srv)&1)goto err;
  srv.bx=temphand=srv.ax;
  srv.ax=0x4400;
  if (sysint21(&srv,&srv)&1) goto err;
  if(srv.dx&0x80){		/* is a character device */
    if(mode&4){			/* its binary yet */
      srv.ax=0x4401;
      srv.bx=temphand;
      srv.dx=(srv.dx&0xff)|0x20;
      if (sysint21(&srv,&srv)&1) goto err;
      tempsize=1;
    } else if(~mode&1 && srv.dx&1)tempsize=136;
    else tempsize=1;
  } else tempsize=_BUFSIZE;

  for(fd=0;fd<MAXFILES;++fd) if(!_opentab[fd]) break;
  if (fd==MAXFILES) goto exit;
  buf=calloc(sizeof(struct bufstr)+tempsize,1);	/* get our fcb */
  if(!buf) goto exit;					/* no buffer yet */
  buf->bufflag=(~(mode+1)&7);		/* set read/write permissions */
  buf->buffull=buf->bufsize=tempsize;
  buf->bufhand=temphand;
  buf->buffild=fd;
  _opentab[fd]=buf;
  return (fd);
err:
  errno=srv.ax&0xff;
exit:
#ifdef DEBUG
printf("\nerrcode = %d,new=%d",errno,new);
#endif
  if(new)unlink(tempfnam);    /* too many handles - DOS 2.0 bug!! */
  else {
    srv.ax=0x3e00;
    srv.bx=temphand;
    if (sysint21(&srv,&srv)&1) errno=srv.ax&0xff;
  }  
  if(buf)free(buf);
  return -1;
}
