/***********************************************************************/
/*	makdir.c                                                      */
/***********************************************************************/
#ifdef _C86_BIG
#define LPTR 1
#endif

/*  create a new directory */
makdir(pname)
char *pname; /* name for the directory to be created */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

#ifdef LPTR
			/* if big data models => get segment part of */
			/*     ASCII string address pointer          */
  regs.ds= hiword(pname);

#else

  regs.ds=0;		/* else => use default DS */

#endif

  regs.es=0;   /* default value for registers */
			/* put offset address into dx register */
  regs.dh= (unsigned) (pname) >> 8; 
  regs.dl= (unsigned) (pname) - (regs.dh << 8); 

  regs.ah=0x39; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(ret_code);
}
