;Clear Screen Program for H/Z-89 and H/Z-100 terminals
;
;	For CP/M-80 and CP/M-85
;
;	This program uses the Heath ESCAPE E sequence
;	to clear the screen and home the cursor.
;
;Created:	9-30-82 by W. M. Adney
;
;Modification Date	Description
;	N/A
;
BDOS	EQU	0005H	;CP/M system call
ESC	EQU	1BH	;Escape function
;
	ORG	100H
MAIN:
	LXI	D,CLS	;Load Heath clear screen function(line1)
	MVI	C,9	;CP/M print string function(line 2)
;	LXI	E,FORMF ;Substitute for line 1 for printer form feed
;	MVI	C,5	;Substitute for line 2 for printer form feed
	CALL	BDOS	;Call CP/M
	RET		;Return to CP/M
;
;********************************
;				*
;	Heath Escape Codes	*
;				*
;********************************
;
CLS:	DB	ESC,'E','$'	;Clear Screen--Escape E
CRTR:	DB	ESC,'z','$'	;Reset to power up configuration--Escape z
COFF:	DB	ESC,'x','2''$'	;Key click off--Escape x 2
KSFT:	DB	ESC,'x','6''$'	;Keypad shifted--Escape x 6
BCUR:	DB	ESC,'x','4''$'	;Block Cursor--Escape x 4
HOLD:	DB	ESC,'[','$'	;Hold screen mode--Escape [ (H-89 only)
				;Allows use of H-89 scroll key
				;Page 11-14 of H-89 operation manual
NBLK:	DB	ESC,'x',';''$'	;Nonblinking cursor--Escape x (H-100 only)
FORMF:	DB	0CH,'$' 	;Printer form feed (e.g H/Z-25)
;
	DS	014H	;Reserve space for 10 entries
STACK:	DS	001H	;Top of stack is here
BUFFER: 		;Storage begins here
	END	MAIN	;END OF PROGRAM
;
;
;
;	Create program with editor as C.ASM
;	All files must be on drive A
;		ASM.COM
;		LOAD.COM
;		C.ASM
;
;Use the following commands to create C.COM
;	ASM C.AAZ
;	LOAD C
;	ERA C.HEX
rive A
;		ASM.COM
;		LOAD.COM
;		C.ASM
;
;Use the following command