	PAGE	60,132

	TITLE	SPEEDUP.COM - MS-DOS Console Speed-Up Program

;	Version 1.4 (C) 06-Jul-86 by John Stetson

;	This program installs a resident interrupt 21H handler
;	which intercepts all MS-DOS INT 21H function 2 and 6
;	calls and converts them to calls to the smart terminal
;	emulator in the Z-100 MTR-100 ROM or to the IBM-PC
;	ROM BIOS video interrupt 10H handler.

;	This speeds up most console output noticeably, at the
;	cost of the loss of some types of output redirection.

;	Once installed, the program will toggle itself on and
;	off, alternately, each time it is run.	This allows
;	console output to be redirected, when necessary.

;	Note - although this program works well on the Z-100,
;	where console output is normally comparatively slow
;	due to the overhead inherent in the high resolution
;	bit-mapped display, the IBM-PC version is less useful,
;	since its console output speed is normally acceptable
;	and the INT 10H handler does not expand tabs to spaces.
;	Problems can also occur when using the ANSI console
;	device driver.

;	MASM, LINK, and EXE2BIN to make SPEEDUP.COM

;	System Equates

FALSE	EQU	0
TRUE	EQU	NOT FALSE

Z100	EQU	TRUE		;Set TRUE for Z-100, FALSE for IBM-PC
IBMPC	EQU	NOT Z100

;	MS-DOS Interrupt Equates

EXIT	EQU	20H		;Normal termination
MSDOS	EQU	21H		;System functions
EXITR	EQU	27H		;Terminate & stay resident

;	MS-DOS Function Equates

OUTSTR	EQU	09H		;Output string to console
SETINT	EQU	25H		;Set interrupt address

;	ASCII Character Equates

LF	EQU	0AH		;Line feed
CR	EQU	0DH		;Carriage return
EOS	EQU	'$'		;End of string delimiter

;	Z-100 MTR-100 ROM Equates

MTRSEG	SEGMENT AT 0FE01H	;MTR-100 ROM Segment
	ORG	19H		;Offset to output routine
MTRSCRT LABEL	FAR		;Smart Terminal Emulator
MTRSEG	ENDS

;	IBM-PC ROM Bios Equates

VIDEO	EQU	10H		;IBM-PC ROM Bios Video I/O
WTTY	EQU	14		;Write TTY function

;	MS-DOS Interrupt Segment Equates

INTSEG	SEGMENT AT 00H		;Interrupt Segment
	ORG	4*21H		;Offset to INT 21H pointer
INT21	LABEL	FAR		;Pointer to INT 21H handler
DOS21	LABEL	FAR		;Dummy label for jump
INTSEG	ENDS

;	Program Initialization

CODE	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H		;Origin after PSP

;	Start of Program

SPEEDUP:JMP	INIT		;Go do initialization

;	Console Speedup Interrupt Service Routine

CONISR: JMP	FUNCHK		;Jump past data (modified)

ISRLIT	DB	'SPEEDUP'	;"Signature" literal string (At +03)
ISRFLG	DB	1		;Active/inactive flag (1/0) (At +10)

;	Check for INT 21H Function 2 (display character)

FUNCHK: CMP	AH,2		;Request to display character?
	JZ	OUTPUT		;Jump if so

;	Check for INT 21H Function 6 (direct console I/O)

	CMP	AH,6		;Request for direct console I/O?
	JNZ	DOSJMP		;Exit if not

	CMP	DL,0FFH 	;Request for input?
	JNZ	OUTPUT		;Jump if not

;	Exit to the standard DOS INT 21H handler

DOSJMP: JMP	DOS21		;Modified at installation time
        
;	Output character in DL using the ROM routine
;	Set up local stack and save all registers

OUTPUT: MOV	CS:SAVEAX,AX
        MOV     AX,CS
	MOV	CS:SAVESS,SS
	MOV	CS:SAVESP,SP
        MOV     SS,AX
	MOV	SP,OFFSET CS:STACK

	PUSHF
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	BP

	MOV	AL,DL		;AL = character to write

	IF	Z100
	CLD			;Clear direction flag
	CALL	MTRSCRT 	;Write character
	ENDIF

	IF	IBMPC
	STI			;Interrupts on
	MOV	AH,WTTY 	;Write TTY function
	XOR	BX,BX		;Page # and Color = 0
	INT	VIDEO		;Write character
	CLI			;Interrupts off
	ENDIF

	POP	BP
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POPF

	MOV	SP,CS:SAVESP
	MOV	SS,CS:SAVESS
	MOV	AX,CS:SAVEAX
	IRET

;	Resident Data Areas

SAVEAX	DW	0
SAVESS	DW	0
SAVESP	DW	0
	DW	64 DUP (0)
STACK	EQU	$

;	End of resident area

;	Start of initialization code
;	Determine if already installed

INIT:	MOV	AX,SEG INTSEG	;Interrupt segment address
	MOV	ES,AX		;ES = MS-DOS ISR segment
	MOV	BX,OFFSET INT21 ;ES:[BX] -> DOS INT 21H handler

	MOV	DI,ES:[BX]	;DI = offset of INT 21H handler
	MOV	INT21O,DI	;Save for later
	ADD	DI,3		;DI = offset of possible literal
	MOV	ES,ES:[BX+2]	;ES = segment of INT 21H handler
	MOV	INT21S,ES	;Save for later

	MOV	SI,OFFSET ISRLIT ;SI = offset of literal 'SPEEDUP'
	CLD			;Clear direction flag
	MOV	CX,7		;Compare 7 bytes
	REPZ	CMPSB		;Compare DS:[SI] and ES:[DI]
	JZ	TOGGLE		;Jump if already installed

;	Modify JMP instruction to DOS INT 21H ISR

	MOV	AX,SEG INTSEG	;Interrupt segment address
	MOV	ES,AX		;ES = MS-DOS ISR segment
	MOV	BX,OFFSET INT21 ;Pointer to DOS INT 21H handler

	MOV	AX,ES:[BX]	     ;AX = offset of INT 21H ISR
	MOV	WORD PTR DOSJMP+1,AX ;Store offset in JMP instruction

	MOV	AX,ES:[BX+2]	     ;AX = segment of INT 21H ISR
	MOV	WORD PTR DOSJMP+3,AX ;Store segment in JMP instruction

;	Install Console Speedup ISR

	MOV	DX,OFFSET CONISR
	MOV	AX,CS
	MOV	DS,AX		;DS:DX = Console ISR address

	MOV	AH,SETINT
	MOV	AL,21H
	INT	MSDOS		;Set new INT 21H ISR address

;	Print installed message

	MOV	AH,OUTSTR
	MOV	DX,OFFSET INSTMSG
	INT	MSDOS

;	Exit, installing the resident code

	MOV	DX,OFFSET STACK ;DX = address of end of resident code
	INT	EXITR		;Terminate and stay resident

;	Speedup ISR already installed - toggle it on/off

TOGGLE: MOV	ES,INT21S
	MOV	DI,INT21O	;ES:[DI] -> INT 21H handler

	MOV	AL,ES:[DI+10]	;AL = ISRFLG
	CMP	AL,1		;CONISR active?
	JZ	REMOVE		;Jump if so

;	Activate the Speedup ISR

	MOV	ES:[DI+10],BYTE PTR 1 ;Indicate active
	MOV	AX,(OFFSET FUNCHK - OFFSET CONISR - 2)
	MOV	ES:[DI+1],AX	;Modify JMP instruction

;	Print installed message

	MOV	AH,OUTSTR
	MOV	DX,OFFSET INSTMSG
	INT	MSDOS

	INT	EXIT		;Exit to DOS

;	Deactivate the Speedup ISR

REMOVE: MOV	ES:[DI+10],BYTE PTR 0 ;Indicate inactive
	MOV	AX,(OFFSET DOSJMP - OFFSET CONISR - 2)
	MOV	ES:[DI+1],AX	;Modify JMP instruction

;	Print removed message

	MOV	AH,OUTSTR
	MOV	DX,OFFSET REMVMSG
	INT	MSDOS

	INT	EXIT		;Exit to DOS

;	Data Areas

INT21O	DW	0		;INT 21 ISR Offset
INT21S	DW	0		;INT 21 ISR Segment
INSTMSG DB	CR,LF,'Console speedup routine installed',CR,LF,EOS
REMVMSG DB	CR,LF,'Console speedup routine removed',CR,LF,EOS

CODE    ENDS

        END     SPEEDUP
