	PAGE	60,132

	TITLE	RAMLIM.COM - Limit the amount of system RAM

	comment $

	Version 1.2 (C) 06-Jul-86 by John Stetson

	This program reserves the upper portion of system RAM
	so that MS-DOS and well-behaved application programs
	will not attempt to access memory above the specified
	limit.	It can be used with both Z-100 and IBM-PC
	compatible systems using MS-DOS versions 2.X and 3.X.

	This capability can be used for the following purposes:

	1) Protect a RAM or Memory Disk in high memory.

	A desirable feature to have when using a RAM or Memory Disk
	is the ability to easily recover the contents of the disk
	across boot-ups of the operating system.  Assuming the RAM
	disk in use allows the user to specify the desired starting
	address, this program will protect the RAM disk so that the
	operating system will not use the reserved area of memory.
	Locating the RAM disk in mid or high memory also minimizes
	the chance that the operating system will overwrite those
	memory addresses during the boot-up process itself.  The
	Zenith MDISK.DVD RAM disk supplied in source code as part of
	the MS-DOS Programmer's Utility Pack supports a user-specified
	starting address and can be easily modified to allow the user
	to optionally recover the contents of the RAM disk at boot time.

	MDISK.DVD is installed by inserting the following line in
	the CONFIG.SYS file:

	DEVICE=MDISK.DVD SIZE=nnn START=nnnn

	2) Protect the transient portion of COMMAND.COM.

	Under MS-DOS 2.X, the transient portion of COMMAND.COM
	occupies about 12k of RAM at the top of system memory.
	Under MS-DOS 3.X, the transient portion of COMMAND.COM
	occupies about 15k of RAM at the top of system memory.

	By reserving this part of memory, the transient portion of
	COMMAND.COM will no longer ever be overlaid by application
	programs (such as compiled BASIC programs).  This eliminates
	the need to maintain copies of COMMAND.COM on non-bootable
	disks and the use of the SET COMSPEC parameter, which does
	not always function as documented by Zenith or Microsoft.

	3) Control the use of Z-100 S-100 buss memory.

	With 256k RAM chips on the Z-100 motherboard (giving a total
	of 768k RAM) it is possible to address a Zenith Z-205 memory
	card starting at 768k.	This will result in useable system
	RAM up to 992k (the MTR-100 ROM in the top 32k overrides any
	RAM at these addresses).  Although Video RAM occupies memory
	from 768k to 960k (segments C000 through E000), the Z-205 card
	S-100 buss memory can be used, as long as programs running
	in these memory segments do not attempt to directly write to
	Video RAM (such as compiled BASIC programs).  If this occurs,
	the program may "page itself out of existence".  Addressing a
	RAM disk in these segments prevents MS-DOS from loading any
	application programs in these segments which might otherwise
	page themselves out of memory when accessing Video RAM.  The
	RAM disk must be large enough to insure that all of the Video
	RAM segments are accounted for.

	How to use RAMLIM:

	RAMLIM.COM will normally be executed under control of an
	AUTOEXEC.BAT file which is automatically executed when MS-DOS
	is booted.  It should be placed at the beginning of the file,
	so that it executes before any other resident programs can
	be loaded into memory.

	RAMLIM requires that the size and starting address of the
	memory to be reserved be specified as command line paramaters:

	RAMLIM SIZE=nnn START=nnn

	SIZE specifies the amount of memory to be reserved, and may
	range from 16 to 864k bytes.

	START specifies the starting address of the memory to be
	reserved, and may range from 128 to 976k bytes.

	SIZE + START must be less than or equal to 992k.

	Care must be taken when selecting the SIZE and START values
	or system memory may become fragmented.  A gap of 2 paragraphs
	or 32 bytes between the upper end of system RAM and the memory
	area reserved by this program is created so that the FAT of a
	Memory Disk starting at this point is not overlaid by DOS.

	Examples of using RAMLIM:

	Example #1

	In this example, a 512k RAM disk is to be installed in a Z-100
	system having 768k bytes of total RAM.	We will also allow a
	16k byte saftey factor for COMMAND.COM.  The calculations are
	as follows:

	SIZE = 512k (for RAM Disk) + 16k (for COMMAND.COM) = 528k.

	START = 768k - 16k - 512k = 240k.

	So we have: RAMLIM SIZE=528 START=240

	In this case, the MDISK parameters would be:

	SIZE = 512k

	START = 240k = 240*1024 = 245760 = 3C000H = 3C00H paragraphs

	So we have: DEVICE=MDISK.DVD SIZE=512 START=3C00

	Example #2

	In this example, a 512k RAM disk is to be installed in a Z-100
	system having 768k bytes of main RAM and a Z-205 card addressed
	to start at 768k.  Although the Z-205 card has 256k bytes of
	RAM, only the first 224k is available, due to the presence of
	the MTR-100 ROM starting at 992k.  We will also allow a 16k
	byte saftey factor for COMMAND.COM.  The RAM disk must be at
	least 208k bytes in size, to fully overlay the Video RAM.  The
	calculations are as follows:

	SIZE = 512k (for RAM Disk) + 16k (for COMMAND.COM) = 528k.

	START = 992k - 16k - 512k = 464k.

	So we have: RAMLIM SIZE=528 START=464

	In this case, the MDISK parameters would be:

	SIZE = 512k

	START = 464k = 464*1024 = 475136 = 74000H = 7400H paragraphs

	So we have: DEVICE=MDISK.DVD SIZE=512 START=7400

	Example #3

	In this example, a 256k RAM disk is to be installed in a Z-150
	system having 640k bytes of total RAM.	We will also allow a
	16k byte saftey factor for COMMAND.COM.  The calculations are
	as follows:

	SIZE = 256k (for RAM Disk) + 16k (for COMMAND.COM) = 272k.

	START = 640k - 16k - 256k = 368k.

	So we have: RAMLIM SIZE=272 START=368

	In this case, the MDISK parameters would be:

	SIZE = 256k

	START = 368k = 368*1024 = 376832 = 5C000H = 5C00H paragraphs

	So we have: DEVICE=MDISK.DVD SIZE=256 START=5C00

	MASM, LINK, and EXE2BIN to make RAMLIM.COM

	end comment $.

;	MS-DOS Interrupt Equates

MSDOS	EQU	21H		;MS-DOS System Functions
EXIT	EQU	20H		;MS-DOS Program Termination

;	MS-DOS System Function Equates

OUTSTR	EQU	09H		;Output string to console
EXITPR	EQU	31H		;Terminate and keep process
MEMALL	EQU	48H		;Allocate memory block
MEMFRE	EQU	49H		;Release memory block
MEMMOD	EQU	4AH		;Modify allocated memory blocks

DEFIOA	EQU	80H		;Default I/O work area contains cmd
				;line length and text after cmd name

;	ASCII Character Equates

BELL	EQU	07H		;Bell
TAB	EQU	09H		;Horizontal Tab
LF	EQU	0AH		;Line Feed
CR	EQU	0DH		;Carriage Return
SPACE	EQU	20H		;Space
EOS	EQU	'$'		;End of String indicator

;	Program Equates

GAP	EQU	2		;Paragraphs between RAM and MDISK

SZMIN	EQU	16		;Minimum SIZE value (kbytes)
SZMAX	EQU	864		;Maximum SIZE value (kbytes)

STMIN	EQU	128		;Minimum START value (kbytes)
STMAX	EQU	976		;Maximum START value (kbytes)

MAXRAM	EQU	992		;Maximum available RAM (kbytes)

;	Program Initialization

CODE	SEGMENT PUBLIC

	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H		;Origin after program segment prefix

;	Process the command line

RAMLIM: XOR	CH,CH
	MOV	SI,DEFIOA	;SI -> cmd line length
	MOV	CL,[SI] 	;CX = cmd line length
	CMP	CX,0		;Any parameters?
	JZ	NOPARM		;Jump if not

	INC	SI		;SI -> cmd line text
	MOV	DI,OFFSET CMDLIN;DI -> destination

LOOP:	MOV	AL,[SI] 	;Get next character
	CALL	UPPER		;Convert to upper case
	MOV	[DI],AL 	;Store it
	INC	SI		;Increment pointers
	INC	DI
	LOOP	LOOP		;Loop until done

;	Parse the command line operands

	MOV	DI,OFFSET CMDLIN;ES:DI -> cmd line string
	CALL	SKIP		;Skip over white space

	MOV	SI,OFFSET SIZSTR;String to match
	CALL	MATCH		;Try to match string
	JNZ	NOPARM		;Error if not found

	CALL	GETSIZ		;Get SIZE value
	JZ	SIZEOK		;Jump if ok
	JMP	BYE		;Exit if not

SIZEOK: MOV	SI,OFFSET STASTR;String to match
	CALL	MATCH		;Try to match string
	JNZ	NOPARM		;Error if not found

	CALL	GETSTA		;Get START value
	JZ	CHKMAX		;Jump if ok
	JMP	BYE		;Exit if not

;	Tell user about missing parameter(s)

NOPARM: MOV	DX,OFFSET MINMSG
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message
	JMP	BYE

;	Check that SIZE + START <= MAXRAM

CHKMAX: MOV	AX,SIZVAL
	ADD	AX,STAVAL
	CMP	AX,MAXRAM
	JNA	GETSEG

	MOV	DX,OFFSET MAXMSG
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message
	JMP	BYE

;	Compute memory segment addresses

GETSEG: MOV	AX,STAVAL
	MOV	CL,6
	SHL	AX,CL
	SUB	AX,GAP
	MOV	SEGLIM,AX	;SEGLIM = 64 * START - GAP

	MOV	AX,STAVAL
	ADD	AX,SIZVAL
	MOV	CL,6
	SHL	AX,CL
	SUB	AX,GAP
	MOV	SEGTOP,AX	;SEGTOP = 64 * (START+SIZE) - GAP

;	Release all memory allocated past this code

	MOV	BX,OFFSET ENDDATA ;ES = segment, BX = offset
	MOV	CL,4		;paragraphs = bytes / 16
	SHR	BX,CL		;BX = memory size in paragraphs
	MOV	TEMP,BX 	;Save for later

	MOV	AH,MEMMOD	;Modify allocated memory block
	INT	MSDOS
	JNC	RELOK		;Jump if release ok

	ADD	AL,'0'
	MOV	RELERR,AL
	MOV	DX,OFFSET RELMSG

	MOV	AH,OUTSTR
	INT	MSDOS		;Display message
	JMP	BYE

;	Allocate memory up to upper bound

RELOK:	MOV	BX,SEGLIM	;BX = segment of upper bound
	MOV	AX,CS		;AX = code segment
	SUB	BX,AX		;BX = number of paragraphs
	SUB	BX,TEMP 	;BX = total number of paragraphs

	MOV	AH,MEMALL
	INT	MSDOS		;AX:0000 -> allocated memory
	JNC	ALLOK		;Jump if allocate ok

	ADD	AL,'0'
	MOV	ALLERR,AL
	MOV	DX,OFFSET ALLMSG

	MOV	AH,OUTSTR
	INT	MSDOS		;Display message
	JMP	BYE

;	Allocate memory up to physical limit

ALLOK:	MOV	TEMP,AX 	;Save starting segment

	MOV	BX,SEGTOP	;BX = segment of top of memory
	MOV	AX,SEGLIM	;AX = segment of upper bound
	SUB	BX,AX		;BX = number of paragraphs

	MOV	AH,MEMALL
	INT	MSDOS		;AX:0000 -> allocated memory
	JNC	ALLOK2		;Jump if allocate ok

	ADD	AL,'0'
	MOV	ALLERR,AL
	MOV	DX,OFFSET ALLMSG

	MOV	AH,OUTSTR
	INT	MSDOS		;Display message
	JMP	BYE

;	Release memory up to upper bound

ALLOK2: MOV	AX,TEMP
	MOV	ES,AX		;ES = segment to be freed

	MOV	AH,MEMFRE	;Release allocated memory block
	INT	MSDOS
	JNC	RELOK2		;Jump if release ok

	ADD	AL,'0'
	MOV	RELERR,AL
	MOV	DX,OFFSET RELMSG

	MOV	AH,OUTSTR
	INT	MSDOS		;Display message
	JMP	BYE

;	Terminate, keeping the memory allocated from
;	the upper bound to the physical memory limit

RELOK2: MOV	DX,OFFSET SIZMSG
	MOV	AH,OUTSTR
	INT	MSDOS		;Display message

	XOR	AL,AL		;Exit code
	XOR	DX,DX		;DX = initial memory block size
	MOV	AH,EXITPR	;Keep process
	INT	MSDOS

;	Exit to COMMAND.COM

BYE:	INT	EXIT

;	SKIP - Skip white space (tabs and spaces)

;	Entry:	ES:DI string (terminated by CR)

;	Exit:	ES:DI - pointer to first non-white char

SKIP	PROC	NEAR

	CMP	BYTE PTR ES:[DI],SPACE
	JZ	SKIP1
	CMP	BYTE PTR ES:[DI],TAB
	JZ	SKIP1
	RET

SKIP1:	INC	DI
	JMP	SHORT SKIP

SKIP	ENDP

;	MATCH - Scan for matching string

;	Entry:	DS:SI - Pointer to length/string to match
;		ES:DI - Pointer to buffer to scan

;	Exit:	'Z' flag set - string found
;		ES:DI - Points to char. after matched string

;		'Z' flag clear - string not found
;		ES:DI - Unchanged

;		All other registers unchanged

MATCH	PROC	NEAR

	PUSH	AX		;Save registers
	PUSH	ES
	PUSH	DI

	LODSB			;Get string length
	SUB	AH,AH
	MOV	COUNT,AX	;Save for later

	MOV	AL,DS:[SI]	;Get first string char

;	Try to find first char of string

MATCH1: CMP	BYTE PTR ES:[DI],CR ;At end of string?
	JZ	MATCH4		;Yes, exit - no match
	CMP	AL,ES:[DI]	;No, does first char match?
	JZ	MATCH2		;Yes, try to match string
	INC	DI		;No, try next character
	JMP	MATCH1

;	See if rest of string matches

MATCH2: PUSH	SI		;Save pointers in case no match
	PUSH	DI
	MOV	CX,COUNT
	REPZ	CMPSB		;Check if strings match
	JZ	MATCH3		;Yes, exit
	POP	DI		;No, restore pointers
	POP	SI
	INC	DI		;Bump past matching character
	JMP	MATCH1		;Try to match first character again

;	String was matched

MATCH3: ADD	SP,8		;Clear regs from stack
	SUB	AX,AX		;Set zero flag
	POP	AX
	RET

;	String was not matched

MATCH4: SUB	AX,AX
	INC	AX		;Clear zero flag
	POP	DI
	POP	ES
	POP	AX
	RET

MATCH	ENDP

;	GETSIZ - Process the SIZE parameter

;	Entry:	ES:DI - Points past string 'SIZE'

;	Exit:	SIZVAL - Size in kbytes (binary)
;		'Z' flag set - value is good
;		'Z' flag clear - value is bad

GETSIZ	PROC	NEAR

	CALL	SKIP		;Skip white space
	CMP	BYTE PTR ES:[DI],'=' ;Separator?
	JNZ	SIZERR		;Error if not

	INC	DI		;Point past separator
	CALL	SKIP		;Skip white space
	CALL	GETDEC		;Get decimal number

;	See if SIZE is too small

	CMP	AX,SZMIN	;SIZE too small?
	JNB	CHKSIZ		;Jump if not

;	Inform user SIZE is too small

SIZERR: MOV	DX,OFFSET SIZMIN
	MOV	AH,OUTSTR
	INT	MSDOS
	JMP	SIZBAD

;	See if SIZE is too large

CHKSIZ: CMP	AX,SZMAX	;SIZE too large?
	JBE	SIZOK		;Jump if not

;	Inform user SIZE is too large

	MOV	DX,OFFSET SIZMAX
	MOV	AH,OUTSTR
	INT	MSDOS

;	Indicate value is bad

SIZBAD: SUB	AX,AX		;Clear 'Z' flag
	INC	AX
	RET

;	Indicate value is good

SIZOK:	MOV	SIZVAL,AX	;Store value
	SUB	AX,AX		;Set 'Z' flag
	RET

GETSIZ	ENDP

;	GETSTA - Process the START parameter

;	Entry:	ES:DI - Points past string 'START'

;	Exit:	STAVAL - Start in kbytes (binary)
;		'Z' flag set - value is good
;		'Z' flag clear - value is bad

GETSTA	PROC	NEAR

	CALL	SKIP		;Skip white space
	CMP	BYTE PTR ES:[DI],'=' ;Separator?
	JNZ	STAERR		;Error if not

	INC	DI		;Point past separator
	CALL	SKIP		;Skip white space

	MOV	AL,ES:[DI]	;Store value in msg
	MOV	SIZLIT,AL
	MOV	AL,ES:[DI+1]
	MOV	SIZLIT+1,AL
	MOV	AL,ES:[DI+2]
	MOV	SIZLIT+2,AL

	CALL	GETDEC		;Get decimal number

;	See if START is too small

	CMP	AX,STMIN	;START too small?
	JNB	CHKSTA		;Jump if not

;	Inform user START is too small

STAERR: MOV	DX,OFFSET STAMIN
	MOV	AH,OUTSTR
	INT	MSDOS
	JMP	STABAD

;	See if START is too large

CHKSTA: CMP	AX,STMAX	;START too large?
	JBE	STAOK		;Jump if not

;	Inform user START is too large

	MOV	DX,OFFSET STAMAX
	MOV	AH,OUTSTR
	INT	MSDOS

;	Indicate value is bad

STABAD: SUB	AX,AX		;Clear 'Z' flag
	INC	AX
	RET

;	Indicate value is good

STAOK:	MOV	STAVAL,AX	;Store value
	SUB	AX,AX		;Set 'Z' flag
	RET

GETSTA	ENDP

;	GETHEX - Get a hexadecimal number

;	Entry:	ES:DI pointer to string

;	Exit:	AX - Number (errors return zero)

GETHEX	PROC	NEAR

	PUSH	CX
	MOV	CX,16
	JMP	SHORT GETD0

GETHEX	ENDP

;	GETDEC - Get a decimal number

;	Entry:	ES:DI pointer to string

;	Exit:	AX - Number (errors return zero)

GETDEC	PROC	NEAR

	PUSH	CX
	MOV	CX,10

GETD0:	PUSH	BX
	PUSH	DX

	SUB	BX,BX		;BX holds number

;	Get character and turn it into a digit

GETD1:	MOV	AL,ES:[DI]	;Get a character
	CALL	CHKDLM		;Check if delimiter
	JZ	GETD4		;Yes, exit
	CMP	AL,'A'		;Prepare for hex number
	JB	GETD2
	CMP	AL,'F'
	JA	GETD2
	SUB	AL,'A'-(10+'0') ;Make hex digit

GETD2:	SUB	AL,'0'		;Make it a number
	JS	GETD3		;Error if below 0
	CMP	AL,CL		;Check if above maximum digit
	JAE	GETD3		;Error, invalid character
	INC	DI		;Character good, advance pointer

;	Update number

	XCHG	AX,BX		;Prepare for shifting number
	SUB	DX,DX
	MUL	CX
	SUB	BH,BH		;Add new digit to old number
	ADD	BX,AX
	ADC	DX,0		;Check for overflow
	JZ	GETD1		;No, return for more digits

;	Error, not a valid number, return zero

GETD3:	SUB	BX,BX		;Yes, return zero

GETD4:	MOV	AX,BX		;Return value in AX
	POP	DX
	POP	BX
	POP	CX
	RET

GETDEC	ENDP

;	CHKDLM - Check for delimiter character

;	Entry:	ES:DI points to character to check

;	Exit:	'Z' flag set, char was delimiter
;		'Z' flag clear, char was not a delimiter

CHKDLM	PROC	NEAR

	PUSH	CX
	PUSH	DI
	PUSH	ES
	PUSH	CS
	POP	ES

	MOV	DI,OFFSET DELIMS
	MOV	CX,NUMDLM
	REPNZ	SCASB

	POP	ES
	POP	DI
	POP	CX
	RET

CHKDLM	ENDP

;	UPPER - Convert character to upper case

;	Entry:	AL contains character

;	Exit:	AL converted to upper case

UPPER	PROC	NEAR

	CMP	AL,'a'
	JL	UPR
	CMP	AL,'z'
	JG	UPR
	SUB	AL,'a'-'A'
UPR:	RET

UPPER	ENDP

;	Data Areas
 
SIZMIN	DB	CR,LF,'Error - SIZE value too small',BELL,CR,LF,EOS
SIZMAX	DB	CR,LF,'Error - SIZE value too large',BELL,CR,LF,EOS

STAMIN	DB	CR,LF,'Error - START value too small',BELL,CR,LF,EOS
STAMAX	DB	CR,LF,'Error - START value too large',BELL,CR,LF,EOS

MINMSG	DB	CR,LF,'Error - SIZE and START not specified',BELL,CR,LF,EOS
MAXMSG	DB	CR,LF,'Error - SIZE + START too large',BELL,CR,LF,EOS

RELMSG	DB	CR,LF,'Error - unable to release memory, return code = '
RELERR	DB	0,BELL,CR,LF,EOS

ALLMSG	DB	CR,LF,'Error - unable to allocate memory, return code = '
ALLERR	DB	0,BELL,CR,LF,EOS

SIZMSG	DB	CR,LF,'System memory reserved above '
SIZLIT	DB	'000k',CR,LF,EOS

SIZVAL	DW	0		;Size of memory to reserve (kbytes)
STAVAL	DW	0		;Start of memory to reserve (kbytes)

SEGLIM	DW	0		;Segment of memory limit
SEGTOP	DW	0		;Segment of top of memory

TEMP	DW	0		;Temporary storage
COUNT	DW	0		;# of chars in cmd line search string

SIZSTR	DB	SIZLEN,'SIZE'
SIZLEN	=	(OFFSET $ - OFFSET SIZSTR)-1

STASTR	DB	STALEN,'START'
STALEN	=	(OFFSET $ - OFFSET STASTR)-1

DELIMS	DB	SPACE,TAB,CR	;Delimiters for parsing
NUMDLM	=	(OFFSET $ - OFFSET DELIMS)

CMDLIN	DB	80 DUP (' ')	;Copy of DOS command line

;	Align on a paragraph (16 byte) boundary

	IF	($-RAMLIM) MOD 16
	ORG	($+16)-(($-RAMLIM) MOD 16)
	ENDIF

ENDDATA EQU	$		;End of memory area to keep

CODE	ENDS

	END	RAMLIM
