	PAGE	60,132

	TITLE	KEYS.COM - Display Z-100 Function Key Definitions

;	Version 1.4 (C) 06-Jul-86 by John Stetson

;	This program displays the definitions of the Z-100
;	console terminal function keys normally used with
;	COMMAND.COM, DEBUG.COM, and EDLIN.COM.	The key
;	definitions are displayed on the 25th screen line,
;	similar to the BASIC KEY command.  The command line
;	syntax is as follows:

;	KEYS <ON/OFF/LIST> (Default is ON)

;	ON - specifies that the key definitions are to be displayed.

;	OFF - specifies that the key definitions are to be erased.

;	LIST - gives a more detailed description of the function
;	       key definitions and control character functions.

;	MASM, LINK, and EXE2BIN to make KEYS.COM

;	Operating System Equates

EXIT	EQU	20H		;MS-DOS Program Termination
MSDOS	EQU	21H		;MS-DOS System Functions

OUTSTR	EQU	09H		;Output String to Console
DEFIOA	EQU	80H		;Default I/O Work Area

;	ASCII Character Equates

LF	EQU	0AH		;Line Feed Character
CR	EQU	0DH		;Carriage Return Character
ESC	EQU	1BH		;Escape Character

;	Segment Definitions

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	Start of Program

	ORG	100H

KEYS:	MOV	SI,DEFIOA	;Address of default I/O work area
	MOV	AL,[SI] 	;Length of possible command line parm
	CMP	AL,3		;Parm present?
	JB	KEYON		;Jump if not

LOOP:	INC	SI		;Address of parm text
	CMP	[SI],BYTE PTR ' ' ;Space char?
	JZ	LOOP		;Jump if so

	MOV	AL,[SI] 	;Get 1st non-blank char
	AND	AL,0DFH 	;Convert to upper case
	CMP	AL,'O'		;Letter O?
	JZ	GOTO		;Jump if so

	CMP	AL,'L'		;Letter L?
	JZ	KEYLIST 	;Jump if so
	JMP	SHORT BYE	;Jump if not

GOTO:	MOV	AL,[SI+1]	;Get the next char
	AND	AL,0DFH 	;Convert to upper case
	CMP	AL,'N'		;Letter N?
	JZ	KEYON		;Jump if so

	CMP	AL,'F'		;Letter F?
	JNZ	BYE		;Jump if not

KEYOFF: MOV	DX,OFFSET OFFMSG
	JMP	SHORT PRTMSG

KEYON:	MOV	DX,OFFSET ONMSG
	JMP	SHORT PRTMSG

KEYLIST:MOV	DX,OFFSET LISTMSG

PRTMSG: MOV	AH,OUTSTR
	INT	MSDOS		;Print message

BYE:	INT	EXIT

;	Data Areas

OFFMSG	DB	ESC,'j' 	;Save Cursor Position
	DB	ESC,'x1'	;Enable Line 25
	DB	ESC,'Y8 '	;Move Cursor to Row 25 Column 1
	DB	ESC,'K' 	;Erase to end of line
	DB	ESC,'k' 	;Restore Cursor Position
	DB	ESC,'y1'	;Disable Line 25
	DB	'$'		;End of message string

ONMSG	DB	ESC,'j' 	;Save Cursor Position
	DB	ESC,'x1'	;Enable Line 25
	DB	ESC,'Y8 '	;Move Cursor to Row 25 Column 1
	DB	 '0',ESC,'p','Copy NL',ESC,'q'	 ;F0
	DB	' 1',ESC,'p','Copy Char',ESC,'q' ;F1
	DB	' 2',ESC,'p','Copy to C',ESC,'q' ;F2
	DB	' 3',ESC,'p','Copy Rest',ESC,'q' ;F3
	DB	' 4',ESC,'p','Skip Char',ESC,'q' ;F4
	DB	' 5',ESC,'p','Skip to C',ESC,'q' ;F5
	DB	' 6',ESC,'p','Ins On',ESC,'q'	 ;F6
	DB	' 7',ESC,'p','Ins Off',ESC,'q'	 ;F7
	DB	ESC,'k' 	;Restore Cursor Position
	DB	'$'		;End of message string

LISTMSG DB	ESC,'E' 	;Clear Screen
	DB	'       '
	DB	ESC,'p'
	DB	'Z-100 COMMAND, DEBUG, and EDLIN Key Definitions'
	DB	ESC,'q',CR,LF,CR,LF
	DB	'F0   = Copy new input line to template',CR,LF
	DB	'S/F0 = Discard current input line and reprompt',CR,LF
	DB	'F1   = Copy next char from template to input line',CR,LF
	DB	'F2 C = Copy chars from template before C to input line',CR,LF
	DB	'F3   = Copy remaining chars from template to input line',CR,LF
	DB	'F4   = Skip over next character in template',CR,LF
	DB	'F5 C = Skip over chars in template before C',CR,LF
	DB	'F6   = Enter character insert mode',CR,LF
	DB	'F7   = Exit from character insert mode',CR,LF
	DB	CR,LF
	DB	'       '
	DB	ESC,'p'
	DB	'Z-100 Command Line Control Character Functions'
	DB	ESC,'q',CR,LF,CR,LF
	DB	'CTRL-C = Abort the current command',CR,LF
	DB	'CTRL-H = Delete the last input character',CR,LF
	DB	'CTRL-J = Insert LF to enter multiple command lines',CR,LF
	DB	'CTRL-N = Stop echoing console output to printer',CR,LF
	DB	'CTRL-P = Start echoing console output to printer',CR,LF
	DB	'CTRL-S = Pause console output until key is pressed',CR,LF
	DB	'CTRL-X = Discard contents of the current input line',CR,LF
	DB	'$'

CODE	ENDS

	END	KEYS
