;	SETCLK -- SET MS-DOS CLOCK TO REAL TIME CLOCK
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  06-JUL-89

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	AH,2
	INT	1AH			;GET REAL CLOCK TIME
	JNC	CLKOK			;CLOCK IS OK
	MOV	DX,OFFSET NOCLK
	MOV	AH,9			;SAY CLOCK IS BAD
	INT	21H
	INT	20H
CLKOK:	MOV	BH,DH			;SAVE SECOND
WFSEC:	MOV	AH,2
	INT	1AH			;GET TIME AGAIN
	CMP	BH,DH			;SAME SECOND?
	JZ	WFSEC			;WAIT FOR A NEW ONE
	MOV	AL,CH			;GET HOUR
	CALL	CONBIN			;CONVERT TO BINARY
	MOV	CH,AL
	MOV	AL,CL
	CALL	CONBIN			;CONVERT MINUTE
	MOV	CL,AL
	MOV	AL,DH
	CALL	CONBIN			;CONVERT SECOND
	MOV	DH,AL
	XOR	DL,DL			;NO HUNDREDTHS
	MOV	AH,2DH
	INT	21H			;SET DOS TIME
	MOV	AH,4
	INT	1AH			;GET REAL TIME CLOCK DATE
	MOV	AL,CH
	CALL	CONBIN			;CONVERT CENTURY
	MOV	CH,AL
	MOV	AL,CL
	CALL	CONBIN			;CONVERT YEAR
	MOV	CL,AL
	MOV	AL,DH
	CALL	CONBIN			;CONVERT MONTH
	MOV	DH,AL
	MOV	AL,DL
	CALL	CONBIN			;CONVERT DAY
	MOV	DL,AL
	MOV	AL,100
	MUL	CH			;MULTIPLY CENTURY BY 100
	XOR	CH,CH
	ADD	AX,CX			;AX = YEAR IN BINARY
	MOV	CX,AX			;YEAR TO CX
	MOV	AH,2BH
	INT	21H			;SET DOS DATE
	MOV	DX,OFFSET SETMSG
	MOV	AH,9
	INT	21H			;SAY CLOCK SET
	INT	20H			;EXIT

;	CONVERT BCD NUMBERS TO BINARY

CONBIN:	MOV	AH,AL			;COPY NUMBER TO AH
	SHR	AH,1			;MOVE HIGH NIBBLE DOWN
	SHR	AH,1
	SHR	AH,1
	SHR	AH,1
	AND	AL,0FH			;ISOLATE LOW NIBBLE
	AAD				;CONVERT TO BINARY
	RET

NOCLK	DB	13,10,'The real time clock is not functioning.',13,10,'$'
SETMSG	DB	13,10,'MS-DOS date and time now set to real time clock '
	DB	'date and time.',13,10,'$'

CODE	ENDS
	END	START
