	PAGE	,132
;	THIS PROGRAM PRODUCES A NON-BLINKING BLOCK
;	CURSOR ON A H/Z PC COMPUTER.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER 08-AUG-86
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1986

BLACK	EQU	0			;DEFINE BLACK
DKGRY	EQU	8			;AND DARK GRAY
CHCOL	EQU	DKGRY			;CHARACTER COLOR IN CURSOR

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	STORAGE LOCATIONS IN RAM (MOST IN BIOS RAM)

	ORG	49H
MODE	LABEL	BYTE			;VIDEO MODE
	ORG	50H
CURPOS	LABEL	WORD			;CURSOR POSITION
	ORG	5CH
FCB	LABEL	WORD			;FCB LOCATION
	ORG	60H
CURTYP	LABEL	WORD			;CURSOR TYPE
	ORG	62H
VPAGE	LABEL	BYTE			;VIDEO PAGE

	ORG	100H

START:	JMP	SETUP			;SET UP THE PROGRAM

INT10V	DD	0			;SCREEN INTERRUPT VECTOR
INT1CV	DD	0			;TIMER INTERRUPT VECTOR
BLFLG	DB	0			;BLINK ON/OFF FLAG
OLDCP	DW	0			;OLD CURSOR POSITION FLAG
OLDAT	DB	0			;OLD ATTRIBUTE
EGAFLG	DB	0			;EGA CARD FLAG

;	TIMER INTERRUPT PROCESSOR.  DURING TIMER
;	INTERRUPTS, WE TURN OFF THE REAL CURSOR, AND
;	SET THE ATTRIBUTE OF THE CURSOR POSITION TO
;	GRAY ON WHITE, SO THAT A WHITE BLOCK APPEARS
;	THERE.

TIMER:	CALL	CURSOR			;MAKE CURSOR
	JMP	CS:DWORD PTR INT1CV	;GO TO OTHER PROCESSES

;	CURSOR UPDATE PROCESSOR

CURSOR:	CMP	CS:BLFLG,0		;BLINK OFF?
	JZ	BLNKOFF			;YES
	RET				;ELSE, EXIT
BLNKOFF:PUSH	AX			;SAVE SOME REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	MOV	CH,MODE			;GET VIDEO MODE
	MOV	DX,3B4H			;MONOCHROME CRT ADDRESS PORT
	CMP	CH,7			;MONOCHROME CARD MODE?
	JZ	MODEOK			;THAT'S OK
	MOV	DL,0D4H			;ELSE, GET COLOR PORT
	CMP	CH,4			;IN A GRAPHIC MODE?
	JB	MODEOK
	JMP	CUREX			;IF SO, EXIT
MODEOK:	CMP	CS:EGAFLG,1		;EGA CARD?
	JZ	GOTEGA			;YES
	MOV	AL,10			;CURSOR START REGISTER
	OUT	DX,AL			;SELECT IT
	INC	DX			;MOVE TO DATA PORT
	MOV	AL,20H
	OUT	DX,AL			;TURN OFF REAL CURSOR
	JMP	SHORT DOBCUR		;DO BLOCK CURSOR
GOTEGA:	MOV	AH,1
	MOV	CX,2007H
	MOV	BX,CURTYP		;SAVE CURRENT CURSOR TYPE
	PUSHF
	CALL	CS:DWORD PTR INT10V	;EGA, LET BIOS TURN CURSOR OFF
	MOV	CURTYP,BX		;RESTORE CURSOR TYPE
DOBCUR:	MOV	CL,BYTE PTR CURTYP+1	;GET CURSOR TYPE HIGH
	MOV	AL,VPAGE		;GET VIDEO PAGE
	CBW				;MAKE IT A WORD
	MOV	BX,OFFSET CURPOS
	ADD	BX,AX			;POINT TO CURSOR POSITION
	MOV	AX,[BX]			;GET IT
	MOV	DL,AL			;SAVE COLUMN
	MOV	AL,AH			;ROW TO AL
	MOV	DH,80			;80 COLUMNS/ROW
	MUL	DH			;GET ROW ADDRESS
	XOR	DH,DH			;DX = COLUMN
	ADD	DX,AX			;DX = ABS. CURSOR POSITION
	SHL	DX,1			;DX = CURSOR ADDRESS
	INC	DX			;MOVE TO ATTRIBUTE BYTE
	MOV	AX,0B800H		;ASSUME CGA
	CMP	CH,7			;MONOCHROME CARD?
	JNZ	CGA			;NO, CGA
	MOV	AX,0B000H		;ELSE USE MONOCHROME ADDRESS
CGA:	MOV	DS,AX			;POINT TO VIDEO RAM
	MOV	BX,CS:OLDCP		;GET OLD CURSOR POSITION
	MOV	AL,70H+CHCOL		;GET CURSOR ATTRIBUTE
	CMP	AL,[BX]			;CURSOR ON?
	JZ	TCOFF			;YES, TURN OFF
	SUB	BX,160			;TRY LINE ABOVE
	JB	LINE1			;ON LINE 1
	CMP	AL,[BX]			;CHECK CHARACTER
	JZ	TCOFF			;CURSOR WAS ON
LINE1:	ADD	BX,160*2		;MOVE TO LINE BELOW
	CMP	AL,[BX]			;CURSOR ON?
	JNZ	NOCUR			;NO
TCOFF:	MOV	AL,CS:OLDAT		;GET OLD ATTRIBUTE
	MOV	[BX],AL			;TURN OFF CURSOR
NOCUR:	TEST	CL,20H			;CURSOR OFF?
	JNZ	CUREX			;IF SO, EXIT
	MOV	BX,DX			;GET NEW CURSOR POSITION
	MOV	AL,[BX]			;GET ATTRIBUTE
	MOV	CS:OLDAT,AL		;SAVE IT
	MOV	CS:OLDCP,BX		;AND OLD POSITION
	MOV	BYTE PTR [BX],70H+CHCOL	;TURN CURSOR ON
CUREX:	POP	DS			;RESTORE REGISTERS
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;	SCREEN INTERRUPT PROCESSOR.  UPDATE CURSOR AFTER
;	ANY SCREEN CALL.

	DB	'NB'
SCREEN:	CMP	AH,110			;BLINK CONTROL?
	JZ	SETBLNK			;IF SO, DO IT
SETCUR:	PUSHF				;PREPARE FOR IRET
	CALL	CS:DWORD PTR INT10V	;PERFORM SCREEN FUNCTION
	CLI
	CALL	CURSOR			;UPDATE CURSOR
	STI
SCREX:	IRET
SETBLNK:MOV	CX,40H
	MOV	DS,CX			;POINT TO BIOS RAM
	MOV	CX,CURTYP		;GET CURSOR TYPE
	MOV	CURTYP,2007H		;ENSURE BLOCK CURSOR IS OFF
	CALL	CURSOR
	MOV	CS:BLFLG,AL		;SET CONDITION
	MOV	AH,1
	JMP	SETCUR			;TURN SELECTED CURSOR ON

ENDRES:					;END OF RESIDENT CODE

;	SET UP TIMER VECTOR AND SCREEN VECTOR, AND LEAVE
;	PROGRAM RESIDENT

SETUP:	MOV	AX,FCB+1		;GET COMMAND ARGUMENT
	CMP	AL,' '			;ANY GIVEN?
	JNZ	CHKARG			;IF SO, CHECK IT
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INTERRUPT PAGE
	MOV	SI,OFFSET 10H*4		;POINT TO SCREEN VECTOR
	LES	DI,DWORD PTR [SI]	;GET OLD VECTOR
	CMP	ES:WORD PTR -2[DI],'BN'	;NOBLINK INSTALLED?
	JZ	ITSIN			;YES
	PUSH	CS
	POP	ES			;ELSE, FIX ES
	PUSH	SI
	MOV	DI,OFFSET INT10V	;SAVE VECTOR HERE
	CLD
	MOVSW				;COPY VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET SCREEN	;VECTOR TO HERE
	MOV	2[SI],CS
	MOV	SI,OFFSET 1CH*4		;POINT TO TIMER VECTOR
	PUSH	SI
	MOV	DI,OFFSET INT1CV	;SAVE VECTOR HERE
	MOVSW				;COPY VECTOR
	MOVSW
	POP	SI
	CLI
	MOV	WORD PTR [SI],OFFSET TIMER	;VECTOR TO HERE
	MOV	2[SI],CS
	STI
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	BL,10H
	MOV	AH,12H
	INT	10H			;TEST FOR EGA
	CMP	BL,10H			;IS IT?
	JZ	NOTEGA			;NO
	MOV	EGAFLG,1		;ELSE, MARK IT
NOTEGA:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGNON
	MOV	DX,OFFSET ENDRES
	INT	27H			;LEAVE PROGRAM RESIDENT
CHKARG:	XOR	BL,BL			;ASSUME ON
	CMP	AX,'NO'			;TURN NOBLINK ON?
	JZ	SETCND			;SET CONDITION
	CMP	AX,'FO'			;TURN NOBLINK OFF?
	JNZ	EXIT			;BAD ENTRY
	INC	BL			;NOBLINK OFF CODE
SETCND:	MOV	AL,BL
	MOV	AH,110			;SET NOBLINK CODE
	INT	10H			;SET IT
EXIT:	INT	20H			;EXIT TO DOS
ITSIN:	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	DX,OFFSET INMSG
	MOV	AH,9
	INT	21H			;SAY NOBLINK IS IN
	INT	20H

SIGNON	DB	13,10,'NOBLINK solid cursor generator is '
	DB	'now installed.',13,10,'$'
INMSG	DB	13,10,'NOBLINK is already installed.$'

CODE	ENDS
	END	START
