	PAGE	,132
;	THIS PROGRAM IS A SHELL THAT RUNS A PROGRAM AND
;	MAPS ALL PRINTER OUTPUT TO A FILE.
;	TO USE THIS PROGRAM, ENTER
;
;	REPRINT <OUTPUT FILE> <PROGRAM> [<ARGUMENTS>]
;
;	WHERE <OUTPUT FILE> IS THE FILE PRINTER OUTPUT
;	IS TO GO TO, <PROGRAM> IS THE PROGRAM THAT PRINTS,
;	AND <ARGUMENTS> ARE ANY ARGUMENTS REQUIRED BY THE
;	PROGRAM.
;
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1988.  ALL RIGHTS RESERVED.
;
;	BY PATRICK SWAYNE, HUG SOFTWARE ENGINEER  29-MAR-88

RETF	MACRO	DISP			;DEFINE FAR RET W/DISP.
	LOCAL	DUMMY
DUMMY	PROC	FAR
	RET	DISP
DUMMY	ENDP
	ENDM

BIOS	SEGMENT AT 40H
	ORG	0
JMPTBL	LABEL	BYTE			;DEFINE Z-100 BIOS JUMP TABLE
	ORG	0CH
BPRINT	LABEL	WORD			;Z-100 BIOS PRINT ROUTINE
	ORG	4BH
BPFUNC	LABEL	WORD			;Z-100 BIOS PRINT FUNCTION
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	5CH
FCB1	LABEL	BYTE			;FIRST FCB
	ORG	6CH
FCB2	LABEL	BYTE			;SECOND FCB
	ORG	80H
ARG	LABEL	BYTE			;ARGUMENT AREA
	ORG	100H

;	SET UP FOR EXECUTION OF PROGRAM

START:	MOV	AH,30H
	INT	21H			;GET DOS VERSION
	CMP	AL,2			;TEST IT
	JNB	VERSOK			;VERSION OK
	MOV	DX,OFFSET BADVER
	CALL	PMSG			;SAY "BAD VERSION"
	INT	20H
VERSOK:	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	CMP	JMPTBL,0E9H		;CHECK FOR A JUMP TABLE
	PUSH	CS
	POP	DS			;FIX DS
	ASSUME	DS:CODE
	JNZ	GOTPC			;IT'S A PC
	MOV	ZFLG,1			;ELSE, FLAG A Z-100
GOTPC:	MOV	FCB1,0			;ZERO FCB1 DRIVE
	MOV	FCB2,0			;AND FCB2 DRIVE
	CLD
	MOV	DI,OFFSET FCB1+1
	MOV	AL,' '
	MOV	CX,11
	REP	STOSB			;CLEAR FCB1
	MOV	DI,OFFSET FCB2+1
	MOV	CX,11
	REP	STOSB			;CLEAR FCB2
	MOV	SI,OFFSET ARG		;POINT TO USER ARGUMENT
	LODSB				;GET COUNT
	OR	AL,AL			;ANY COUNT?
	JNZ	GOTINP			;YES, WE HAVE USER INPUT
NOINP:	MOV	DX,OFFSET NPMSG
	CALL	PMSG			;ELSE, SAY "NO PROGRAM"
	INT	20H

;	GET THE OUTPUT FILE FROM THE COMMAND LINE

GOTINP:	XOR	AH,AH			;MAKE COUNT A WORD
	MOV	CX,AX			;COUNT TO CX
	CALL	SOS			;SKIP SPACES
	JZ	NOINP			;NO USER INPUT
	MOV	DI,OFFSET PRNNAM	;PUT PRINT OUTPUT NAME HERE
MOVPRN:	LODSB				;GET A CHARACTER
	CMP	AL,' '			;END OF NAME?
	JZ	GOTPN			;YES
	STOSB				;ELSE, STORE CHARACTER
	LOOP	MOVPRN
	JMP	NOINP			;SHOULDN'T GET HERE
GOTPN:	MOV	BYTE PTR [DI],0		;NULL END OF OUTPUT NAME
	DEC	CX			;COUNT THE SEPARATING SPACE
	CALL	SOS			;SKIP ADDITIONAL SPACES
	JZ	NOINP

;	GET THE PROGRAM NAME

	MOV	DI,OFFSET PRGNAM	;PUT PROGRAM NAME HERE
MOVPGM:	LODSB				;GET A CHARACTER
	CMP	AL,' '			;END OF PROGRAM NAME?
	JZ	GOTEND			;YES
	CMP	AL,13			;COULD END IN CR
	JZ	GOTEND
	CMP	AL,'/'			;COULD END IN SWITCH
	JZ	GOTSW
	STOSB				;STORE IT
	LOOP	MOVPGM			;ELSE, LOOP
	JMP	NOARG			;RAN OUT OF CHARACTERS, NO ARGUMENT
GOTSW:	DEC	SI			;BACK UP TO SWITCH
	INC	CX			;CANCEL NEXT DEC
GOTEND:	DEC	CX			;COUNT THE SEPARATOR
	MOV	BYTE PTR [DI],0		;NULL END OF PROGRAM NAME
	JZ	NOARG			;NO ARGUMENT SPECIFIED

;	SET UP THE COMMAND ARGUMENT AND THE FCB'S

	PUSH	CX			;SAVE COUNT
	PUSH	SI			;AND LOCATION
	MOV	ARG,CL			;SAVE ARGUMENT LENGTH
	MOV	DI,OFFSET ARG+1		;PUT PROGRAM ARGUMENT HERE
	REP	MOVSB			;MOVE ARGUMENT
	POP	SI			;RESTORE POINTER
	POP	CX			;AND COUNT
	CALL	SOS			;SKIP SPACES
	JZ	NOARG
	MOV	DI,OFFSET FCB1		;POINT TO FIRST FCB
	MOV	AX,2900H
	INT	21H			;PARSE FIRST NAME
FNDTRM:	MOV	AL,[SI]			;GET NEXT CHARACTER
	CMP	AL,' '			;SPACE?
	JZ	GOTTRM
	CMP	AL,','			;COMMA?
	JZ	GOTTRM
	CMP	AL,';'			;SEMI?
	JZ	GOTTRM
	CMP	AL,'='
	JZ	GOTTRM
	INC	SI
	LOOP	FNDTRM			;LOOK FOR TERMINATOR
	JMP	SHORT GOTARG		;NONE FOUND, NO 2ND ARG
GOTTRM:	INC	SI			;PASS OVER TERMINATOR
	DEC	CX			;COUNT IT
	JZ	NOARG			;THAT WAS THE END
	CALL	SOS			;SKIP ANY SPACES
	JZ	NOARG			;ONLY SPACES LEFT
	MOV	DI,OFFSET FCB2		;POINT TO SECOND FCB
	MOV	AX,2900H
	INT	21H			;PARSE SECOND NAME
	JMP	SHORT GOTARG
NOARG:	MOV	WORD PTR ARG,0D00H	;INSERT NULL COUNT, CR
GOTARG:	CLI
	MOV	SP,OFFSET ENDADR	;PUT STACK HERE
	STI

;	PROCESS PROGRAM NAME

	MOV	DX,OFFSET FNDBUF
	MOV	AH,1AH
	INT	21H			;SET DTA TO FIND BUFFER
	XOR	BP,BP			;CLEAR EXTENSION FLAG
	MOV	DI,OFFSET PRGNAM	;POINT TO PROGRAM NAME
	MOV	AL,'.'
	MOV	CX,80
	REPNZ	SCASB			;LOOK FOR "."
	JNZ	NOEXT			;NO EXTENSION SPECIFIED
	CMP	WORD PTR [DI],'OC'	;LOOK FOR "COM"
	JNZ	NOTCOM			;NOT "COM"
	CMP	BYTE PTR 2[DI],'M'
	JZ	LOOK2			;WE HAVE COM
NOINPJ:	JMP	NOINP			;EXPLAIN PROGRAM
NOTCOM:	CMP	WORD PTR [DI],'XE'	;LOOK FOR "EXE"
	JNZ	NOINPJ			;NOT "EXE"
	CMP	BYTE PTR 2[DI],'E'
	JZ	LOOK2			;EXTENSION SPECIFIED, LOOK FOR FILE
	JMP	NOINPJ
NOEXT:	INC	BP			;FLAG EXTENSION SUPPLIED
	MOV	DI,OFFSET PRGNAM
	XOR	AL,AL
	MOV	CX,80
	REPNZ	SCASB			;ELSE, LOOK FOR END
	DEC	DI			;POINT TO IT
	MOV	WORD PTR [DI],'C.'	;MOVE IN .COM
	MOV	WORD PTR 2[DI],'MO'
	MOV	DX,OFFSET PRGNAM
	MOV	CX,0
	MOV	AH,4EH
	INT	21H			;LOOK FOR PROGRAM
	JNC	GOTPRG			;GOT IT
	MOV	BYTE PTR 1[DI],'E'	;ELSE, MAKE PROGRAM .EXE
	MOV	WORD PTR 2[DI],'EX'
LOOK2:	MOV	CX,0
	MOV	AH,4EH
	MOV	DX,OFFSET PRGNAM
	INT	21H			;LOOK FOR PROGRAM
	JNC	GOTPRG			;GOT IT
	MOV	DX,OFFSET NOFIND
	CALL	PMSG			;ELSE, SAY "CAN'T FIND"
	OR	BP,BP			;EXTENSION SUPPLIED?
	JZ	NOEXS			;NO
	MOV	WORD PTR [DI],0A0DH	;ELSE, INSERT CR,LF
	MOV	BYTE PTR 2[DI],'$'
NOEXS:	MOV	DX,OFFSET PRGNAM
	CALL	PMSG			;PRINT FILE NAME
	INT	20H

;	OPEN OUTPUT FILE

GOTPRG:	MOV	DX,OFFSET ARG
	MOV	AH,1AH
	INT	21H			;FIX DTA ADDRESS
	MOV	DX,OFFSET PRNNAM	;POINT TO OUTPUT FILE NAME
	MOV	AH,3CH
	XOR	CX,CX
	INT	21H			;TRY TO OPEN OUTPUT FILE
	JNC	OPENOK
BADWRT:	MOV	DX,OFFSET PRFERR
	CALL	PMSG			;SHOW ERROR
	INT	20H
OPENOK:	MOV	HANDLE,AX		;SAVE FILE HANDLE

;	SET UP INTERRUPT VECTORS THAT WE WILL USE

	MOV	AX,0
	MOV	DS,AX			;POINT TO INT SEGMENT
	MOV	SI,21H*4		;POINT TO SYSTEM VECTOR
	MOV	DI,OFFSET INT21V	;PUT VECTOR HERE
	PUSH	SI
	MOVSW				;COPY VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYSYS	;VECTOR TO HERE
	MOV	2[SI],CS
	MOV	SI,17H*4		;POINT TO PC PRINT VECTOR
	CMP	CS:BYTE PTR ZFLG,1	;Z-100?
	JZ	SETZV			;SET Z-100 VECTORS
	MOV	DI,OFFSET INT17V	;PUT VECTOR HERE
	PUSH	SI
	MOVSW				;COPY VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET PCPRN	;VECTOR TO HERE
	MOV	2[SI],CS
	JMP	SHORT PRPRUN
SETZV:	MOV	SI,0B1H*4		;POINT TO 0B1H INTERRUPT
	MOV	WORD PTR [SI],OFFSET ZPRINT	;PUT Z-100 PRINT ADDR HERE
	MOV	2[SI],CS
	MOV	SI,0B2H*4		;POINT TO 0B2H INTERRUPT
	MOV	WORD PTR [SI],OFFSET ZPFUNC	;PUT Z-100 PRINT FUNC ADDR HERE
	MOV	2[SI],CS
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	MOV	AX,BPRINT+1		;GET BIOS PRINT ADDRESS
	MOV	CS:PRINTV,AX		;SAVE IT
	MOV	BPRINT,0B1CDH		;INSERT "INT 0B1H"
	MOV	BYTE PTR BPRINT+2,0CBH	;AND FAR RETURN
	MOV	AX,BPFUNC+1		;BET BIOS PRINT FUNC ADDRESS
	MOV	CS:PFUNCV,AX		;SAVE IT
	MOV	BPFUNC,0B2CDH		;INSERT "INT 0B2H"
	MOV	BYTE PTR BPFUNC+2,0CBH	;AND FAR RETURN
	ASSUME	DS:CODE

;	PREPARE TO RUN THE PROGRAM

PRPRUN:	PUSH	CS
	POP	DS			;FIX DS
	MOV	BX,OFFSET ENDADR+15	;POINT TO END OF THIS PROGRAM
	MOV	CL,4
	SHR	BX,CL			;MAKE IT A PARAGRAPH
	MOV	AH,4AH
	INT	21H			;FREE UP MEMORY FOR PROGRAM TO RUN
	JC	CNTEX			;SOMETHING'S WRONG
	MOV	AX,ENVSEG
	MOV	PBENV,AX		;SET UP ENV. SEGMENT ADDRESS
	MOV	PBCMD+2,CS		;SET UP SEGMENT FOR CMD LINE
	MOV	PBFCB1+2,CS		;SET UP FCB1 SEGMENT
	MOV	PBFCB2+2,CS		;SET UP FCB2 SEGMENT

;	RUN THE PROGRAM

	MOV	DX,OFFSET PRGNAM	;POINT TO PROGRAM NAME
	MOV	BX,OFFSET PBLOCK	;AND TO PARAMETER BLOCK
	MOV	AX,4B00H		;PROGRAM EXEC FUNCTION
	INT	21H			;TRY TO EXECUTE PROGRAM
	JNC	EXECOK			;IT WAS OK
CNTEX:	MOV	DX,OFFSET NOEXEC
	CALL	PMSG			;SAY "CAN'T RUN"

;	ALL DONE, RESTORE INTERRUPT VECTORS

EXECOK:	CLI
	MOV	AX,0
	MOV	ES,AX			;POINT TO INT PAGE
	MOV	AX,CS
	MOV	DS,AX			;AND TO HERE
	MOV	SS,AX			;FIX SS
	MOV	SP,OFFSET ENDADR	;FIX STACK
	MOV	SI,OFFSET INT21V	;POINT TO SYSTEM VECTOR
	MOV	DI,21H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	CMP	BYTE PTR ZFLG,1		;Z100?
	JZ	RSTZV			;RESTORE Z-100 VECTORS
	MOV	SI,OFFSET INT17V	;POINT TO PC PRINT VECTOR
	MOV	DI,17H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	JMP	SHORT VDONE
RSTZV:	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	MOV	AX,CS:PRINTV		;GET PRINT VECTOR
	MOV	BPRINT+1,AX		;RESTORE IT
	MOV	BYTE PTR BPRINT,0E9H	;AND THE JUMP
	MOV	AX,CS:PFUNCV		;GET PFUNC VECTOR
	MOV	BPFUNC+1,AX		;RESTORE IT
	MOV	BYTE PTR BPFUNC,0E9H	;AND THE JUMP
	PUSH	CS
	POP	DS			;FIX DS
	ASSUME	DS:CODE
VDONE:	STI				;ENABLE INTERRUPTS

;	CLOSE OUTPUT FILE

	MOV	BX,HANDLE
	MOV	AH,3EH
	INT	21H			;CLOSE OUTPUT FILE
	JNC	EXIT
	JMP	BADWRT			;ERROR IN CLOSING
EXIT:	INT	20H			;AND EXIT

;	SUBROUTINES
;	SKIP OVER SPACES

SOS:	CMP	BYTE PTR [SI],' '	;SPACE?
	JNZ	NOTSP			;NO
	INC	SI			;ELSE, SKIP IT
	LOOP	SOS
NOTSP:	OR	CX,CX			;SET FLAG ON COUNT
	RET

;	SYSTEM INTERRUPT PROCESSOR

MYSYS:	CMP	AH,5			;PRINT OUTPUT?
	JNZ	NOTPO			;NO
	PUSH	AX			;ELSE, SAVE REGISTERS
	MOV	AL,DL			;CHARACTER TO AL
PRCH1:	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	CHRBUF,AL		;PUT CHARACTER IN BUFFER
	MOV	DX,OFFSET CHRBUF	;POINT TO BUFFER
	MOV	BX,HANDLE		;GET OUTPUT FILE HANDLE
	MOV	CX,1			;WRITE 1 CHARACTER
	MOV	AH,40H
	PUSHF
	CALL	DWORD PTR INT21V	;WRITE CHARACTER
	POP	DS
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET
SYSX:	JMP	CS:DWORD PTR INT21V	;GOTO SYSTEM
NOTPO:	CMP	AH,40H			;DEVICE OUTPUT?
	JNZ	NOTDO			;NO
	CMP	BX,4			;STD PRN OUTPUT?
	JZ	GOTSTP			;YES
	MOV	CS:SYSFLG,1		;ELSE, FLAG SYSTEM CALL
	PUSHF
	CALL	CS:DWORD PTR INT21V	;CALL THE SYSTEM
	MOV	CS:SYSFLG,0
	RETF	2			;RETURN, FLAGS INTACT
GOTSTP:	MOV	BX,CS:HANDLE		;ELSE, FIX HANDLE
	PUSHF
	CALL	CS:DWORD PTR INT21V	;WRITE TO FILE
	MOV	BX,4			;RESTORE HANDLE
	RETF	2			;RETURN, FLAGS INTACT
NOTDO:	CMP	AH,3DH			;OPEN?
	JNZ	NOTOW			;NO
CHKPRN:	PUSH	AX			;ELSE, SAVE REGISTERS
	PUSH	BX
	PUSH	SI
	MOV	SI,DX			;POINT TO FILE NAME
	MOV	AX,[SI]			;GET FIRST TWO CHARACTERS
	MOV	BX,2[SI]		;AND NEXT TWO
	AND	AX,5F5FH		;CAPITALIZE
	AND	BL,5FH
	CMP	AX,'RP'			;CHECK FOR "PRN"
	JNZ	CHKLP			;NOT PRN, CHECK FOR LPT
	CMP	BX,'N'
	JZ	GOTPRN			;IT'S "PRN"
CHKLP:	CMP	AX,'PL'			;CHECK FOR "LPTn"
	JZ	GOTLP
NOTPRN:	POP	SI			;NOT A PRINTER DEVICE, EXIT
	POP	BX
	POP	AX
SYSXJ:	JMP	SYSX
GOTLP:	CMP	BX,'1T'			;CHECK FOR LPT1
	JZ	GOTLPT
	CMP	BX,'2T'			;AND LPT2
	JNZ	NOTPRN
GOTLPT:	CMP	BYTE PTR 4[SI],0	;CHECK FOR ZERO TERMINATOR
	JNZ	NOTPRN
GOTPRN:	POP	SI
	POP	BX
	POP	AX
	MOV	AX,4			;ELSE, JUST RETURN STD PRN HANDLE
	OR	AL,AL			;CLEAR CARRY
	RETF	2
NOTOW:	CMP	AH,3CH			;CREATE?
	JZ	CHKPRN			;IF SO, CHECK FOR "PRN"
	CMP	AH,3EH			;CLOSE?
	JNZ	SYSXJ			;NO
	CMP	BX,4			;CLOSE STD PRN?
	JNZ	SYSXJ			;NO
	OR	BL,BL			;ELSE, JUST CLEAR CARRY
	RETF	2			;AND RETURN

;	PC PRINTER INTERRUPT PROCESSOR

PCPRN:	CMP	BYTE PTR CS:SYSFLG,1	;SYSTEM CALL IN PROGRESS?
	JZ	PCPRX			;YES, JUST EXIT
	OR	AH,AH			;PRINT CHARACTER?
	JZ	PRCH			;YES
PCPRX:	MOV	AH,0D0H			;ELSE, RETURN OK CODE
	IRET
PRCH:	MOV	AH,0D0H			;SET OK STATUS
	PUSH	AX			;SAVE AX
	JMP	PRCH1			;PRINT CHARACTER TO FILE

;	Z-100 BIOS PRINTER ROUTINE PROCESSOR

ZPRINT:	PUSH	AX
	JMP	PRCH1			;PRINT CHARACTER TO FILE
ZPFUNC:	OR	AH,AH			;WRITE CHARACTER?
	JZ	PFUNC1			;YES
	CMP	AH,2			;GET STATUS?
	JNZ	PFUNC2			;NO
	CMP	AL,0			;GET STATUS?
	JNZ	PFUNC2			;NO
	MOV	AX,8080H		;ELSE, RETURN XMIT READY
	OR	AL,AL			;CLEAR CARRY
	RETF	2
PFUNC2:	STC				;ALL OTHER FUNCTIONS ILLEGAL
	RETF	2
PFUNC1:	PUSH	AX			;ELSE, SAVE REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	CHRBUF,AL		;PUT CHARACTER IN BUFFER
	MOV	DX,OFFSET CHRBUF	;POINT TO BUFFER
	MOV	BX,HANDLE		;GET OUTPUT FILE HANDLE
	MOV	CX,1			;WRITE 1 CHARACTER
	MOV	AH,40H
	PUSHF
	CALL	DWORD PTR INT21V	;WRITE CHARACTER
	POP	DS
	POP	DX
	POP	CX
	POP	BX
	MOV	AL,1
	OR	AL,AL			;CLEAR FLAGS
	POP	AX
	RETF	2

;	PRINT MESSAGES

PMSG:	PUSH	SI
	MOV	SI,DX			;POINT TO MESSAGE
	CLD
PMSGLP:	LODSB				;GET A CHARACTER
	OR	AL,AL			;ZERO
	JZ	PMSGLP			;SKIP IT
	CMP	AL,'$'			;END?
	JZ	PMSGX
	MOV	DL,AL
	MOV	AH,2
	INT	21H			;PRINT CHARACTER
	JMP	PMSGLP
PMSGX:	POP	SI
	RET

;	DATA AREA

ZFLG	DB	0			;Z-100 FLAG
SYSFLG	DB	0			;SYSTEM CALL FLAG
CHRBUF	DB	0			;CHARACTER BUFFER
HANDLE	DW	0			;OUTPUT FILE HANDLE

;	PARAMETER BLOCK USED TO EXECUTE PROGRAM

PBLOCK	LABEL	NEAR
PBENV	DW	0			;ENVIRONMENT SEGMENT
PBCMD	DW	80H,0			;COMMAND LINE ADDRESS
PBFCB1	DW	5CH,0			;FCB1 ADDRESS
PBFCB2	DW	6CH,0			;FCB2 ADDRESS

INT17V	DW	0,0			;INT 17 VECTOR
INT21V	DW	0,0			;INT 21 VECTOR
PRINTV	DW	0			;Z-100 PRINT VECTOR
PFUNCV	DW	0			;Z-100 PRINT FUNC VECTOR

FNDBUF	DB	43 DUP (0)		;FIND BUFFER

BADVER	DB	13,10,7,'This program requires MS-DOS version 2 or '
	DB	'above.',13,10,'$'
NOFIND	DB	13,10,"Can't find $"
NOEXEC	DB	13,10,"Can't execute "
PRGNAM	DB	80 DUP (0)		;NAME OF PROGRAM TO RUN
	DB	13,10,'$'

PRFERR	DB	13,10,'Unable to write '
PRNNAM	DB	80 DUP (0)		;PRINT FILE NAME
	DB	13,10,'$'

NPMSG	DB	13,10,'To use this program, enter',13,10,10
	DB	'  REPRINT <output file> <program> [<arguments>]',13,10,10
	DB	'where <output file> is the file you want printer',13,10
	DB	'output to go to, <program> is the program you want',13,10
	DB	'to run, and <arguments> are any command line arg-',13,10
	DB	'uments required by the program.',13,10,'$'

ENDADR	EQU	$+256			;END OF THIS PROGRAM

CODE	ENDS
	END	START
