	PAGE	,132
;	INTERRUPT 14 SERIAL PORT DRIVER FOR ZPC
;
;	THIS PROGRAM PROVIDES AN EMULATION OF THE PC BIOS
;	INTERRUPT 14 ROUTINE, TO DRIVE ACTUAL PC-STYLE
;	SERIAL PORTS ADDED TO A Z-100.  IT ALSO MAPS THE
;	INTERRUPTS GENERATED BY THE SERIAL CARD TO THE
;	ACTUAL PC INTERRUPTS.
;
;	TO USE THIS PROGRAM, ENTER
;
;	INT14 1			TO LOAD THE PROGRAM FOR COM1
;	INT14 2			TO LOAD THE PROGRAM FOR COM1 AND COM2
;	INT14 O			TO TURN OFF INT14 PROCESSING
;				(AND ALLOW ZPC TO DO IT)
;	INT14 H0		TO TURN ON INT 14 (NO HANDSHAKING)
;	INT14 H1		TO TURN ON INT 14 (CTS HANDSHAKING)
;	INT14 H2		TO TURN ON INT 14 (DSR HANDSHAKING)
;	INT14 H3		TO TURN ON INT 14 (BOTH - ACTUAL PC MODE)
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  22-NOV-86
;
;	COPYRIGHT (C) 1986 BY HEATH/ZENITH USERS' GROUP

TIMOUT	EQU	10			;TIME OUT COUNTER (* 1 SEC)
;					;(CHANGE IF YOU WISH)
L3PA	EQU	16DH			;LEVEL 3 ZPC PORT ADDRESS
L2PA	EQU	153H			;LEVEL 2 ZPC PORT ADDRESS
MASTER	EQU	0F2H			;MASTER PIC PORT NO.
SLAVE	EQU	0F0H			;SLAVE PIC PORT NO.
COM1P	EQU	3F8H			;COM1 BASE PORT NO.
COM2P	EQU	2F8H			;COM2 BASE PORT NO.
VI5	EQU	4DH			;VI5 INT. LEVEL
VI4	EQU	4CH			;VI4 INT. LEVEL
VI3	EQU	4BH			;VI3 INT. LEVEL
VI2	EQU	4AH			;VI2 INT. LEVEL
VI1	EQU	49H			;VI1 INT. LEVEL
VI0	EQU	48H			;VI0 INT. LEVEL

;	NOTE: CHANGE THE FOLLOWING TWO LINES IF YOUR CARD USES
;	DIFFERENT S-100 INTERRUPTS

IVCOM1	EQU	VI5			;INTERRUPT VECTOR FOR COM1
IVCOM2	EQU	VI4			;INTERRUPT VECTOR FOR COM2

;	PIC INTERRUPT MASKS

MASKC1	EQU	0FFH-(1 SHL (IVCOM1-48H))
MASKC2	EQU	0FFH-(1 SHL (IVCOM2-48H))

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	0BH*4
COM2V	LABEL	DWORD			;COM2 INT. VECTOR
	ORG	0CH*4
COM1V	LABEL	DWORD			;COM1 INT. VECTOR
	ORG	5CH
FCB	LABEL	BYTE			;DEFINE FCB ADDRESS
	ORG	100H

START:	JMP	SETUP			;GO SETUP PROGRAM

;	FLAGS, DATA

I14FLG	DB	1			;INT 14 FLAG
COM2FLG	DB	0			;COM2 ON FLAG
OLDI14	DW	0,0			;OLD INT 14 ADDRESS
HAND1	DB	10000B			;HANDSHAKING FLAG 1
HAND2	DB	100000B			;HANDSHAKING FLAG 2
TCOUNT	DB	TIMOUT			;TIME-OUT COUNTER

;	BAUD RATE TABLE

BAUDTBL	DW	417H			;110 BAUD
	DW	300H			;150
	DW	180H			;300
	DW	0C0H			;600
	DW	060H			;1200
	DW	030H			;2400
	DW	018H			;4800
	DW	00CH			;9600

;	INTERRUPT 14 DRIVER
;	THIS DRIVER SERVICES THESE FUNCTIONS:
;	0	INITIALIZE SERIAL PORT
;	1	SEND A CHARACTER
;	2	RECEIVE A CHARACTER
;	3	READ COM STATUS
;	4	PROGRAM INT 14 DRIVER
;	THE FUNCTION NUMBER IS PASSED IN AH, REQUIRED ARGUMENT
;	IN AL, PORT NUMBER IN DX (0 = COM1, 1 = COM2).

INT14:	STI				;ENABLE OTHER INTERRUPTS
	CMP	AH,4			;PROGRAM DRIVER?
	JNZ	INT14A			;NO
	PUSH	AX			;SAVE ARGUMENT
	AND	AL,1			;STRIP FLAG
	MOV	CS:I14FLG,AL		;SAVE IT
	POP	AX
	PUSH	AX
	AND	AL,10000B		;STRIP HANDSHAKING FLAG 1
	MOV	CS:HAND1,AL		;SAVE IT
	POP	AX
	AND	AL,100000B		;STRIP HANDSHAKING FLAG 2
	MOV	CS:HAND2,AL		;SAVE IT
	IRET
INT14A:	CMP	CS:I14FLG,0		;INT 14 ON?
	JNZ	INT14B			;YES
INT14X:	JMP	CS:DWORD PTR OLDI14	;ELSE, EXIT
INT14B:	CMP	DX,1			;USING COM2?
	JNZ	INT14C			;NO
	CMP	CS:COM2FLG,1		;IS IT ALLOWED?
	JNZ	INT14X			;IF NOT, LET ZPC DO IT
INT14C:	MOV	CS:TCOUNT,TIMOUT	;SET TIMEOUT COUNTER
	PUSH	DX			;SAVE PORT NO.
	OR	DX,DX			;TEST FOR FIRST PORT
	JZ	INT14D			;GET IT
	DEC	DX			;TEST FOR SECOND PORT
	JNZ	BADCODE			;BAD PORT
	MOV	DX,2F8H			;GET SECOND PORT ADDRESS
	JMP	SHORT INT14E
INT14D:	MOV 	DX,3F8H			;GET FIRST PORT ADDRESS
INT14E:	OR	AH,AH			;INITIALIZE?
	JZ	INIT			;YES
	DEC	AH			;SEND CHARACTER?
	JNZ	NSEND			;NO
	JMP	SEND
NSEND:	DEC	AH			;RECEIVE CHARACTER?
	JNZ	NRECV			;NO
	JMP	RECEIVE
NRECV:	DEC	AH			;READ STATUS?
	JNZ	BADCODE			;NO, BAD CODE
	JMP	STATUS
BADCODE:POP	DX
	IRET				;ELSE, EXIT

;	INITIALIZE SERIAL PORT

INIT:	PUSH	CX			;SAVE THESE
	PUSH	BX
	PUSH	AX			;SAVE PROGRAMMING CODE
	MOV	CL,4
	SHR	AL,CL			;MOVE BAUD CODE DOWN
	AND	AX,1110B		;ISOLATE BAUD CODE
	MOV	BX,AX			;CODE TO BX
	MOV	BX,CS:BAUDTBL[BX]	;GET BAUD DIVISOR VALUES
	INC	DX			;MOVE TO INT. ENABLE REGISTER
	XOR	AL,AL
	OUT	DX,AL			;CLEAR IT
	INC	DX
	INC	DX			;MOVE TO LINE CONT. REGISTER
	MOV	AL,80H
	OUT	DX,AL			;SET DIVISOR LATCH
	SUB	DX,3			;BACK TO BASE PORT
	MOV	AL,BL
	OUT	DX,AL			;SET BAUD RATE LOW
	INC	DX
	MOV	AL,BH
	OUT	DX,AL			;SET BAUD RATE HIGH
	INC	DX
	INC	DX			;BACK TO LINE CONT. REGISTER
	POP	AX			;GET PROGRAMMING CODE
	AND	AL,00011111B		;STRIP BAUD RATE CODE
	OUT	DX,AL			;PROGRAM LINE CONTROL
	POP	BX
	POP	CX
	POP	DX
	IRET

;	SEND A CHARACTER TO A SERIAL PORT

SEND:	PUSH	BX
	PUSH	CX
	PUSH	AX			;SAVE OUTPUT VALUE
	MOV 	BH,CS:HAND1		;GET HANDSHAKE 1 FLAG
	OR	BH,CS:HAND2		;ADD IN FLAG 2
	ADD	DX,6			;POINT TO MODEM STATUS REG.
WFRDY:	MOV	CX,0FFFFH		;SET SHORT TIMEOUT COUNT
WFRDY0:	IN	AL,DX			;READ STATUS
	TEST	BH,10000B		;TEST FOR CTS REQUIRED
	JZ	NOCTS			;IT'S NOT
	TEST	AL,10000B		;ELSE, TEST FOR IT
	JZ	WFRDY1			;WAIT FOR IT
NOCTS:	TEST	BH,100000B		;TEST FOR DSR REQUIRED
	JZ	SEND1			;IT'S NOT
	TEST	AL,100000B		;ELSE, TEST FOR IT
	JNZ	SEND1			;READY TO SEND CHARACTER
WFRDY1:	LOOP	WFRDY0			;ELSE, WAIT
	DEC	CS:TCOUNT		;DECREMENT TIME OUT COUNTER
	JNZ	WFRDY			;TRY AGAIN
	POP	AX			;DISCARD CHARACTER
	DEC	DX			;POINT TO LINE STATUS REG.
	IN	AL,DX			;GET IT
	MOV	AH,AL			;IN AH
	INC	DX			;POINT TO MODEM STATUS REG.
	IN	AL,DX			;GET IT
	OR	AH,80H			;SET TIMEOUT
SENDX:	POP	CX
	POP	BX
	POP	DX
	IRET
SEND1:	DEC	DX			;POINT TO LINE STATUS
WFRDY2:	IN	AL,DX			;READ IT
	TEST	AL,100000B		;READY TO TRANSMIT?
	JZ	WFRDY2			;IF NOT, LOOP
	MOV	BH,AL			;STATUS TO BH
	INC	DX
	IN	AL,DX			;GET MODEM STATUS
	MOV	BL,AL			;IN BL
	POP	AX			;GET CHARACTER
	SUB	DX,6			;BACK UP TO BASE PORT
	OUT	DX,AL			;SEND CHARACTER
	MOV	AX,BX			;STATUS TO AX
	JMP	SENDX			;AND EXIT

;	RECEIVE A CHARACTER

RECEIVE:PUSH	CX
	ADD	DX,5			;POINT TO LINE STATUS REG.
WFRDY3:	MOV	CX,0FFFFH		;GET TIMEOUT VALUE
WFRDY4:	IN	AL,DX			;READ STATUS
	TEST	AL,1			;CHARACTER THERE?
	JNZ	GOTCHR			;GOT ONE
	LOOP	WFRDY4			;ELSE, WAIT
	DEC	CS:TCOUNT		;DECREMENT TIME OUT COUNTER
	JNZ	WFRDY3
	OR	AL,80H			;SET TIMEOUT
RCERX:	MOV	AH,AL			;STATUS TO AH
	INC	DX
	IN	AL,DX			;GET MODEM STATUS
RECX:	POP	CX
	POP	DX
	IRET
GOTCHR:	AND	AL,11110B		;ISOLATE READ STATUS
	JNZ	RCERX			;ERROR FOUND
	SUB	DX,5			;BACK UP TO BASE PORT
	MOV	AH,AL			;STATUS TO AH
	IN	AL,DX			;CHARACTER TO AL
	JMP	RECX

;	READ COM STATUS

STATUS:	ADD	DX,5			;MOVE TO LINE STATUS
	IN	AL,DX			;GET IT
	MOV	AH,AL			;IN AH
	INC	DX			;MOVE TO MODEM STATUS
	IN	AL,DX			;GET IT
	POP	DX
	IRET

;	MAP INTERRUPTS GENERATED BY S-100 PORT CARD
;	TO COM1 AND COM2 INTERRUPTS.

COM1I:	PUSH	AX
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INTERRUPT PAGE
	PUSHF				;PREPARE TO FAKE INTERRUPT
	CALL	COM1V			;DO IT
	MOV	AL,20H
	OUT	MASTER,AL		;RESET MASTER PIC
	OUT	SLAVE,AL		;RESET SLAVE PIC
	POP	DS
	POP	AX
	IRET

COM2I:	PUSH	AX
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INTERRUPT PAGE
	PUSHF				;PREPARE TO FAKE INTERRUPT
	CALL	COM2V			;DO IT
	MOV	AL,20H
	OUT	MASTER,AL		;RESET MASTER PIC
	OUT	SLAVE,AL		;RESET SLAVE PIC
	POP	DS
	POP	AX
	IRET
ENDRES:

;	SET UP INT 14 PROCESSOR

SETUP:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON MESSAGE
	MOV	AL,FCB+1		;GET FIRST ARGUMENT CHARACTER
	CMP	AL,'1'			;SET COM1?
	JZ	SETCOM			;YES
	CMP	AL,'2'			;SET COM1 AND COM2?
	JZ	SETCOM			;YES
	JMP	OTHER			;ELSE, OTHER RESPONSE
SETCOM:	MOV	CL,AL			;SAVE RESPONSE
	AND	AL,1
	MOV	COM2FLG,AL		;SAVE COM2 SELECTION
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INT. PAGE
	MOV	SI,14H*4		;POINT TO INT 14 VECTOR
	MOV	AX,2[SI]		;GET THE SEGMENT
	MOV	DS,AX			;IN DS
	MOV	BX,L3PA			;ASSUME LEVEL 3
	CMP	WORD PTR [BX],310H	;TEST FOR DUMMY COM1 VALUE
	JNZ	NOTL3			;MUST NOT BE LEVEL 3
	CMP	WORD PTR 2[BX],210H	;TEST FOR DUMMY COM2 VALUE
	JZ	GOTZPC			;WE FOUND IT
NOTL3:	MOV	BX,L2PA			;TEST FOR LEVEL 2
	CMP	WORD PTR [BX],310H	;TEST FOR DUMMY COM VALUES
	JNZ	NOZPC			;ZPC NOT INSTALLED
	CMP	WORD PTR 2[BX],210H
	JZ	GOTZPC			;IT'S LEVEL 2
NOZPC:	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	DX,OFFSET NOZMSG
	MOV	AH,9
	INT	21H			;SAY "ZPC NOT FOUND"
	INT	20H			;AND EXIT
GOTZPC:	MOV	WORD PTR [BX],3F8H	;PUT IN REAL COM1 ADDRESS
	CMP	CL,'2'			;DOING COM2?
	JNZ	NOC2			;NO
	MOV	WORD PTR 2[BX],2F8H	;ELSE, PUT IN ITS ADDRESS
NOC2:	XOR	AX,AX
	MOV	DS,AX			;POINT TO INT. SEGMENT
	MOV	DI,OFFSET OLDI14	;STORE INT 14 VECTOR HERE
	PUSH	SI			;SAVE VECTOR ADDRESS
	CLD
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET INT14	;INSTALL NEW VECTOR
	MOV	2[SI],CS
	MOV	SI,OFFSET IVCOM1*4		;POINT TO COM1 VECTOR
	MOV	WORD PTR [SI],OFFSET COM1I	;INSTALL PROPER ADDRESS
	MOV	2[SI],CS
	MOV	BL,MASKC1			;GET PIC MASK FOR COM1
	CMP	CL,'2'				;INSTALLING COM2?
	JNZ	NOC2A				;NO
	AND	BL,MASKC2			;PIC MASK FOR COM2
	MOV	SI,OFFSET IVCOM2*4		;POINT TO COM2 VECTOR
	MOV	WORD PTR [SI],OFFSET COM2I	;INSTALL PROPER ADDRESS
	MOV	2[SI],CS
NOC2A:	PUSH	CS
	POP	DS			;PUT DS HERE
	IN	AL,SLAVE+1		;GET PIC INTERRUPT MASK
	AND	AL,BL			;ENABLE COM INTERRUPT(S)
	OUT	SLAVE+1,AL
	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;SAY "INT14 INSTALLED"
	MOV	DX,OFFSET ENDRES	;POINT TO END OF RESIDENT CODE
	INT	27H			;EXIT, CODE RESIDENT
OTHER:	CMP	AL,'O'			;TURN INT14 OFF?
	JNZ	NOTOFF			;NO
	MOV	AX,400H			;SET UP OFF CODE
	INT	14H			;TURN INT14 OFF
	MOV	DX,OFFSET OFFMSG
	JMP	SHORT PMSG		;SAY "INT14 OFF"
NOTOFF:	CMP	AL,'H'			;HANDSHAKE SET CODE?
	JNZ	EXPL			;BAD ENTRY, EXPLAIN PROGRAM
	MOV	AL,FCB+2		;GET HANDSHAKE NUMBER
	SUB	AL,'0'			;REMOVE ASCII
	JB	EXPL			;BAD ENTRY
	CMP	AL,4
	JNB	EXPL			;TOO HIGH
	MOV	CL,4
	SHL	AL,CL			;SHIFT NUMBER TO PROPER POSITION
	OR	AL,1			;SET "ON" BIT
	MOV	AH,4			;GET SET UP CODE
	INT	14H			;SET UP INT14 AS REQUESTED
	MOV	DX,OFFSET ONMSG
PMSG:	MOV	AH,9
	INT	21H			;SAY "INT14 ON"
	INT	20H			;AND EXIT
EXPL:	MOV	DX,OFFSET EXPMSG
	JMP	PMSG			;EXPLAIN INT14 USE

SIGNON	DB	13,10,'Interrupt 14H Driver for Hardware Serial '
	DB	'Ports, v. 1.0',13,10
	DB	"Copyright (C) 1986 by Heath/Zenith Users' Group"
	DB	13,10,10,'$'
NOZMSG	DB	'ZPC not found -- INT14 not installed.',13,10,'$'
INSMSG	DB	'INT14 driver is now installed.',13,10,'$'
OFFMSG	DB	'INT14 is turned off.',13,10,'$'
ONMSG	DB	'INT14 is turned on -- your handshake type selected.'
	DB	13,10,'$'
EXPMSG	DB	'To use this program, enter',13,10,10
	DB     'INT14 1		To install INT14 with support for COM1.'
	DB	13,10
	DB     'INT14 2		To install INT14 with support for COM1 '
	DB	'and COM2.',13,10
	DB     'INT14 O		To turn installed INT14 off.',13,10
	DB     'INT14 H0	To turn installed INT14 on with no '
	DB	'handshaking.',13,10
	DB     'INT14 H1	To turn installed INT14 on with CTS '
	DB	'handshaking.',13,10
	DB     'INT14 H2	To turn installed INT14 on with DSR '
	DB	'handshaking.',13,10
	DB     'INT14 H3	To turn installed INT14 on with CTS, '
	DB	'DSR handshaking.',13,10,'$'

CODE	ENDS
	END	START
