	PAGE	,132
	TITLE	Z-100 PC EMULATOR (VERSION 2)
;	THIS PROGRAM EMULATES THE Z-100 PC ENVIRONMENT ON A Z-100.
;	THE COLOR/GRAPHICS CARD, MONOCHROME CARD, KEYBOARD, DISK
;	INTERFACE, AND PRINTER INTERFACE ARE EMULATED.
;
;	BY P. SWAYNE, HUG  23-SEP-85  20-MAR-86
;
;	COPYRIGHT (C) 1985, 1986 BY HEATH USERS' GROUP

;	NOTE:  THE IDEA OF USING A TABLE TO GET THE ADDRESS OF A
;	SCAN LINE IN VIDEO RAM (A TECHNIQUE USED IN THIS PROGRAM)
;	WAS SUGGESTED BY HUG MEMBER BOB DISCOUNT.

;	DEFINITIONS

	INCLUDE	COND.ACM		;INCLUDE ASSEMBLY CONDITIONS

M	EQU	BYTE PTR 0[BX]		;MEMORY POINTER

WHITE	EQU	0			;VRAM COLOR CONTROL BITS
CYAN	EQU	00010000B
MAGENTA	EQU	00100000B
BLUE	EQU	00110000B
YELLOW	EQU	01000000B
GREEN	EQU	01010000B
RED	EQU	01100000B
BLACK	EQU	01110000B

HTIMINT	EQU	8			;PC HARDWARE TIMER INTERRUPT
KEYINT	EQU	9			;PC KEYBOARD INTERRUPT
PTIMINT	EQU	1CH			;PC SOFTWARE TIMER INTERRUPT
CHRINT	EQU	1FH*4			;CHARACTER DEFINITION VECTOR
SYSINT	EQU	21H*4			;SYSTEM INTERRUPT VECTOR
ETJINT	EQU	41H			;ET-100 "JIMINY" INTERRUPT
ZJINT	EQU	4FH			;Z-100 "JIMINY" INTERRUPT
ZKEYINT	EQU	50H*4			;Z-100 KEYBOARD INT. VECTOR
ZTIMINT	EQU	51H*4			;Z-100 TIMER INTERRUPT VECTOR

VRPORT	EQU	0D8H			;VIDEO RAM CONTROL PORT
MASTER	EQU	0F2H			;MASTER PIC BASE PORT
SLAVE	EQU	0F0H			;SLAVE PIC BASE PORT

BIOS	SEGMENT AT 40H
	ORG	3
BCONST	LABEL	FAR			;BIOS CONSOLE STATUS
	ORG	6
BCONIN	LABEL	FAR			;BIOS CONSOLE INPUT
	ORG	0CH
BLSTOUT	LABEL	FAR			;BIOS LIST OUTPUT
	ORG	0FH
BAUXIN	LABEL	FAR			;BIOS AUX INPUT
	ORG	12H
BAUXOUT	LABEL	FAR			;BIOS AUX OUTPUT
	ORG	48H
BDSKFNC	LABEL	FAR			;BIOS DISK FUNCTION
	ORG	4BH
BPRNFNC	LABEL	FAR			;BIOS PRINT FUNCTION
	ORG	4EH
BAUXFNC	LABEL	FAR			;BIOS AUX FUNCTION
BIOS	ENDS

ROM	SEGMENT AT 0FE01H
	ORG	19H
ROMOUT	LABEL	FAR			;DEFINE ROM OUTPUT
ROM	ENDS


SEGES	MACRO
	DB	26H			;DEFINE SEG ES: INST.
	ENDM
CALLF	MACRO
	DB	09AH			;DEFINE FAR CALL
	ENDM
JMPF	MACRO
	DB	0EAH			;DEFINE FAR JUMP
	ENDM
RETF	MACRO
	DB	0CBH			;DEFINE FAR RETURN
	ENDM
RETFD	MACRO
	DB	0CAH			;FAR RETURN WITH DISPLACEMENT
	ENDM

;	PROGRAM STARTS HERE

DUMMY	SEGMENT	STACK			;PREVENT LINK ERR. MSG.
	DUMMY	ENDS
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	0
ZERO	LABEL	NEAR			;DEFINE CS:0
	ORG	2
MEMLIM	LABEL	WORD			;MEMORY LIMIT

	IF	LEVEL2 OR LEVEL3
;	THESE CELLS ARE DEFINED HERE, BUT ARE ACTUALLY IN
;	THE BIOS SEGMENT (EXCEPT PCKEY)

	ORG	10H
EQFLG	LABEL	WORD			;EQUIPMENT FLAG
	ORG	13H
MEMSIZ	LABEL	WORD			;MEMORY SIZE
	ORG	17H
KBFLG	LABEL	WORD			;KEYBOARD FLAG
	ORG	1CH
TAILPTR	LABEL	WORD			;KEYBOARD TAIL POINTER
	ORG	1EH
CHRBUF	LABEL	WORD			;FAKE TYPE-AHEAD
	ENDIF
	ORG	24H
PCKEY	LABEL	DWORD			;DEFINE PC KEYBOARD INT. VECTOR
	IF	LEVEL2 OR LEVEL3
	ORG	49H
BMODE	LABEL	BYTE			;VIDEO MODE
	ORG	4AH
BCPL	LABEL	BYTE			;CHARS/LINE
	ORG	50H
CURPOS	LABEL	WORD			;CURSOR POSITION
	ORG	60H
BCURTYP	LABEL	WORD			;CURSOR TYPE
	ORG	6CH
TIMERL	LABEL	WORD			;TIMER WORD LOW
	ORG	6EH
TIMERH	LABEL	WORD			;TIMER WORD HIGH
	ENDIF

	ORG	100H

START:	JMP	SETUP			;SET UP PROGRAM

	INCLUDE	DATA.ACM		;INCLUDE ZPC VARIABLES

;	INT 10H PROCESSOR
;	ALL VIDEO OUTPUT MUST GO THROUGH THIS INTERRUPT

	DB	'PC'			;IDENTIFIER
INT10:	
	IF	LEVEL3
	POP	CS:USERIP		;SAVE USER'S IP
	POP	CS:USERCS		;SAVE USER'S CS
	PUSH	CS:USERCS		;FIX STACK
	PUSH	CS:USERIP
	ENDIF
	PUSH	BP
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES			;SAVE THESE OFF THE BAT
	PUSH	CS
	POP	DS			;PUT DS HERE
	STI				;ENABLE OTHER INTERRUPTS
	PUSH	AX			;SAVE AX
	XCHG	AL,AH			;CALL TO AL
	XOR	AH,AH			;AX = CALL CODE
	CMP	AL,16			;OUT OF RANGE?
	JNC	EXIT10			;IF SO, EXIT
	SHL	AX,1			;MPY BY 2
	MOV	SI,AX			;RESULT TO SI
	POP	AX
	CALL	TBL10[SI]		;CALL APPROPRIATE ROUTINE
EXIT10A:CLI
	POP	ES			;RESTORE REGISTERS
	POP	DS
	POP	DI
	POP	SI
	POP	BP
	IRET
EXIT10:	POP	AX
	JMP	EXIT10A
TBL10	DW	OFFSET SETMODE
	DW	OFFSET SETCURT
	DW	OFFSET SETCUR
	DW	OFFSET GETCUR
	DW	OFFSET READPEN
	DW	OFFSET SELPAGE
	DW	OFFSET SCRLUP
	DW	OFFSET SCRLDN
	DW	OFFSET READCHR
	DW	OFFSET WRTCHR
	DW	OFFSET WROCHR
	DW	OFFSET SETPAL
	DW	OFFSET WRTDOT
	DW	OFFSET READDOT
	DW	OFFSET TTYOUT
	DW	OFFSET GETVS

;	SET VIDEO MODE

SETMODE:CLD				;CLEAR DIRECTION FLAG
	CMP	AL,100			;TOGGLE PC MODE?
	JC	SETMOD1			;NO
	JMP	TOGMODE			;ELSE, DO IT
SETMOD1:PUSH	BX
	PUSH	CX
	IF	LEVEL3
	CMP	AL,4			;LESS THAN MODE 4?
	JB	SETNGM			;YES
	CMP	AL,6			;MORE THAN MODE 6?
	JA	SETNGM			;YES
	PUSH	AX			;SAVE MODE
	MOV	ES,USERCS		;POINT TO USER'S CODE SEGMENT
	MOV	DI,0
	MOV	CX,0FFFBH		;SEARCH THIS MUCH
	MOV	AL,6EH			;LOW BYTE OF CHAR TABLE ADDRESS
	MOV	AH,0FAH			;HIGH BYTE
	PUSH	DX
	MOV	DX,0F000H		;CHAR TABLE SEGMENT
SCTALP:	REPNZ	SCASB			;SEARCH FOR IT
	JNZ	CTANF			;NOT FOUND
	CMP	ES:BYTE PTR [DI],AH	;IS THIS IT?
	JNZ	SCTALP
	CMP	ES:WORD PTR 2[DI],DX	;LOOK FOR CHR TABLE SEGMENT
	JZ	CTSFWD			;FOUND IT FORWARD
	CMP	ES:WORD PTR -4[DI],DX
	JZ	CTSBAK			;FOUND IT BACKWARD
	CMP	ES:WORD PTR -6[DI],DX
	JZ	CTSBAK1			;FOUND IT FARTHER BACK
	JMP	SCTALP			;ELSE, KEEP LOOKING
CTSFWD:	MOV	ES:WORD PTR 2[DI],0B000H ;INSERT OUR TABLE SEGMENT
	JMP	SHORT SETCTA
CTSBAK:	MOV	ES:WORD PTR -4[DI],0B000H ;INSERT OUR TABLE SEGMENT
	JMP	SHORT SETCTA
CTSBAK1:MOV	ES:WORD PTR -6[DI],0B000H ;DITTO
SETCTA:	MOV	ES:WORD PTR -1[DI],0	;INSERT OUR TABLE ADDRESS
CTANF:	POP	DX
	POP	AX			;RESTORE MODE
SETNGM:
	ENDIF
	CALL	CUROFF			;TURN CURSOR OFF
	MOV	XORFLG,0		;KILL XOR FLAG
	MOV	APAGE,0			;SET ACTIVE PAGE TO 0
	IF	LEVEL3
	MOV	CHKCNT,0		;CLEAR CHECK COUNT
	ENDIF
	CMP	MODE,7			;IS OLD MODE 7?
	JNZ	OLDN7			;NO
	CMP	AL,2			;IS NEW MODE 2?
	JNZ	OLDN7			;NO
	MOV	AL,7			;ELSE, CONTINUE MODE 7
OLDN7:	MOV	MODE,AL			;STORE NEW MODE
	IF	LEVEL2 OR LEVEL3
	MOV	DS,BIOSRAM		;POINT TO BIOS RAM
	AND	BYTE PTR EQFLG,11101111B ;SET DEFAULT CARD TO COLOR/GRAPHICS
	CMP	AL,7			;MODE 7?
	JNZ	TMN7			;NO
	OR	BYTE PTR EQFLG,00010000B ;ELSE, SET CARD TO MONOCHROME
TMN7:	PUSH	CS
	POP	DS
	ENDIF
	MOV	LINES,9			;ASSUME TEXT MODE
	MOV	LFACTOR,18
	MOV	CHRTBLA,OFFSET CHRTBL
	IF	LEVEL3
	MOV	PCRAM,0B800H		;ASSUME MODES 0-6
	ENDIF
	CMP	AL,7			;MODE 7?
	IF	LEVEL3
	JNZ	NOTM7			;NOT MODE 7
	MOV	PCRAM,0B000H		;ELSE, VIDEO RAM STARTS HERE
	JMP	SHORT TMODE
NOTM7:
	ELSE
	JZ	TMODE			;TEXT
	ENDIF
	CMP	AL,4			;LESS THAN 4?
	JC	TMODE			;YES
	MOV	LINES,8			;ELSE, 8 LINES FOR GRAPHIC MODE
	MOV	LFACTOR,16
	MOV	CHRTBLA,OFFSET CHRTBL1
TMODE:
	IF	LEVEL1
	MOV	CURPOS,0		;CLEAR CURSOR POSITION
	ENDIF
	IF	LEVEL2 OR LEVEL3
	MOV	ES,BIOSRAM
	MOV	DI,OFFSET CURPOS
	PUSH	AX
	MOV	CX,8
	XOR	AX,AX
	REP	STOSW			;CLEAR ALL CURSOR POSITIONS
	POP	AX
	ENDIF
	PUSH	AX
	MOV	BX,OFFSET LWTBL		;POINT TO LINE WIDTH TABLE
	XLAT				;TRANSLATE MODE TO 1 OR 0
	MOV	CPL,AL			;SET COLUMNS PER LINE
	MOV	BL,25
	MUL	BL			;CALCULATE CHARS/SCREEN
	MOV	CPS,AX			;SAVE IT
	POP	AX			;GET MODE AGAIN
	PUSH	AX
	MOV	BX,OFFSET COLTBL	;POINT TO COLOR TABLE
	XLAT				;GET COLOR FLAG
	MOV	COLFLG,AL		;SAVE IT
	POP	AX
	PUSH	AX
	MOV	BX,OFFSET GRMTBL	;POINT TO GRAPHIC MODE TABLE
	XLAT				;GET MODE (GRAPHIC/TEXT)
	MOV	GRFLG,AL		;SAVE IT
	IF	LEVEL2 OR LEVEL3
	MOV	AL,MODE			;GET MODE
	MOV	AH,CPL			;AND CHARS/LINE
	MOV	DS,BIOSRAM
	MOV	BMODE,AL		;PUT MODE IN BIOS RAM
	MOV	BCPL,AH			;AND CHARS/LINE
	PUSH	CS
	POP	DS
	ENDIF
	CALL	TYPTX
	DB	27,'x1',27,'x5'		;ENSURE LINE 25 ON, CURSOR OFF
	DB	27,'y?'			;DISABLE KEY EXPANSION
	DB	27,'Y8 ',27,'m70'	;SET WHITE ON BLACK
	DB	27,'E'			;CLEAR 25TH LINE
	DB	27,'Y7 ',27,'m70'
	DB	27,'E'+80H		;CLEAR SCREEN
	IF	LEVEL3
	MOV	AX,PVIDRAM		;GET PERMANENT VIDEO RAM ADDRES
	MOV	VIDRAM,AX		;FIX TEMPORARY ADDRESS
	ENDIF
	MOV	ES,VIDRAM		;GET VIDEO RAM SEGMENT
	XOR	DI,DI			;START AT BEGINNING
	MOV	CX,2000H		;CLEAR THIS MUCH
	MOV	AX,720H			;ATTR 07, SPACE CHAR
	REP	STOSW			;CLEAR VIDEO PAGE RAM
	CMP	GRFLG,0			;GRAPHIC MODE?
	JZ	NCLRGR			;NO
	MOV	DI,1000H		;ELSE, CLEAR GRAPHIC RAM
	MOV	CX,2000H
	XOR	AX,AX
	REP	STOSW
	MOV	PALETTE,1		;SET DEFAULT PALETTE
	MOV	GBCOL,0			;AND DEFAULT BACKGROUND COLOR
	MOV	OGBCOL,0
	IF	LEVEL3
	MOV	SI,OFFSET CHRTBL1	;POINT TO 2ND CHAR TABLE
	MOV	AX,0B000H
	MOV	ES,AX			;PUT ES HERE
	XOR	DI,DI
	MOV	CX,1024			;MOVE THIS MUCH
	REP	MOVSB			;MOVE CHAR TABLE TO HI RAM
	ENDIF
NCLRGR:
	IF	LEVEL3
	MOV	ES,PCRAM		;GET PC VIDEO RAM SEGMENT
	XOR	DI,DI
	MOV	CHKMAX,6		;ASSUME TEXT MODE
	MOV	AX,720H			;ATTRIBUTE 7, SPACE
	MOV	CX,2000H		;SET COUNTER FOR CLEARING RAM
	CMP	GRFLG,0			;GRAPHIC MODE?
	JZ	CLRPC			;IF NOT, CLEAR RAM NOW
	MOV	CHKMAX,12		;SET GRAPHIC MAX CHECK COUNT
	XOR	AX,AX			;FILL RAM WITH ZERO
CLRPC:	REP	STOSW			;CLEAR PC VIDEO RAM
	ENDIF
	MOV	CX,607H
	CMP	GRFLG,1			;GRAPHIC MODE?
	JNZ	SMCUR			;NO
	CMP	GCURV,1			;CURSOR IN GRAPHIC MODE?
	JZ	SMCUR			;YES
	MOV	CX,2020H		;ELSE, SET INVISIBLE CURSOR
SMCUR:	CALL	SETCURT			;SET CURSOR TO STANDARD TYPE
	POP	AX
	POP	CX
	POP	BX
	RET

;	TOGGLE PC EMULATION ON OR OFF

TOGMODE:AND	AL,1			;ISOLATE STATE BIT
	MOV	PCFLG,AL		;SAVE AS PC MODE FLAG
	OR	AL,AL			;TEST STATE
	JZ	OFFMODE			;OFF
	IF	LEVEL2 OR LEVEL3
	MOV	BYTE PTR DSVFLG,0	;CLEAR DISK SAVED FLAG
	MOV	DS,BIOSRAM		;POINT TO BIOS RAM SEGMENT
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	SI,0
	MOV	DI,OFFSET JMPSAV	;PUT BIOS JUMPS HERE
	MOV	CX,80H			;SAVE THIS MUCH
	REP	MOVSB			;SAVE BIOS JUMPS
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	ES,BIOSRAM		;POINT ES TO BIOS RAM
	MOV	SI,OFFSET PCDATA	;POINT TO PC DATA
	MOV	DI,0			;PUT IT HERE
	MOV	CX,0CH			;MOVE THIS MUCH
	REP	MOVSB
	ADD	DI,3			;SKIP BIOS_PRINT VECTOR
	MOV	CX,24H-0FH		;MOVE THIS MUCH
	REP	MOVSB
	ADD	DI,3			;SKIP GETDATE VECTOR
	MOV	CX,4BH-27H		;MOVE THIS MUCH
	REP	MOVSB			;MOVE IN DATA
	ADD	DI,3			;SKIP PRNFUNC VECTOR
	MOV	CX,80H-4EH		;MOVE THIS MUCH
	REP	MOVSB
	ENDIF
	IF	LEVEL3
	MOV	DI,SIZCOD		;GET SIZE CODE ADDRESS
	OR	DI,DI			;ANY ADDRESS?
	JZ	NSZCHK			;NO
	MOV	ES,BIOSRAM		;ELSE, POINT TO BIOS SEGMENT
	MOV	AL,9AH
	STOSB				;STORE FAR CALL
	MOV	AX,OFFSET SIZCHK
	STOSW				;TO SIZE CHECK
	MOV	AX,CS
	STOSW
	CMP	DOSVER,3		;DOS VERSION 3?
	JNZ	ND3A			;NO
	MOV	AL,90H
	STOSB
ND3A:
	ENDIF
NSZCHK:	MOV	AL,DEFMODE		;GET DEFAULT MODE
	CBW
	CALL	SETMODE			;SET DEFAULT VIDEO MODE
	RET
OFFMODE:CALL	TYPTX
	DB	27,'m70'
	DB	27,'H',27,'E',27,'y1'
	DB	27,'y5',27,'x','?'+80H	;SET Z-100 STUFF
	IF	LEVEL2 OR LEVEL3
	MOV	ES,BIOSRAM		;POINT TO BIOS RAM
	MOV	SI,OFFSET JMPSAV	;POINT TO SAVED JUMPS
	MOV	DI,0			;PUT THEM HERE
	MOV	CX,80H			;MOVE THIS MUCH
	REP	MOVSB			;MOVE IN THE JUMPS
	ENDIF
	IF	LEVEL3
	MOV	DI,SIZCOD		;GET SIZE CODE ADDRESS
	OR	DI,DI			;ANY SIZE CODE?
	JZ	NSZCHK1			;NO
	MOV	ES,BIOSRAM		;ELSE, POINT TO BIOS RAM
	MOV	AX,CODE1
	STOSW				;RESTORE OLD SIZE CODE
	MOV	AX,CODE2
	STOSW
	CMP	DOSVER,3		;DOS 3?
	JNZ	ND3B			;NO
	MOV	AX,CODE3
	STOSW
	JMP	SHORT NSZCHK1
ND3B:	MOV	AL,BYTE PTR CODE3
	STOSB
	ENDIF
NSZCHK1:MOV	AL,VPVAL
	OUT	VRPORT,AL		;SET OLD VR PORT VALUE
	RET

;	SET CURSOR TYPE

SETCURT:PUSH	AX
	PUSH	BX
	PUSH	CX
	TEST	CH,20H			;CHECK FOR CURSOR OFF CODE
	JNZ	CTOK
	CMP	CH,8			;CHECK CURSOR TOP
	JC	CTOK			;OK
	CMP	MODE,7			;MODE 7?
	JNZ	SETCN7			;NO
	CMP	CH,14			;MORE THAN 14?
	JNC	SETCN7			;YES
	MOV	CH,6			;ELSE, REDUCE TO 6
	JMP	SHORT CTOK
SETCN7:	MOV	CH,20H			;TOO HI, TURN CURSOR OFF
CTOK:	CMP	CH,20H			;TURN CURSOR OFF?
	JNZ	CNOFF			;NO
	CALL	CUROFF			;ELSE, TURN IT OFF
CNOFF:	CMP	CL,8			;CHECK BOTTOM
	JC	CBOK
	MOV	CL,7
CBOK:	MOV	CURTYP,CX		;STORE NEW CURSOR TYPE
	IF	LEVEL2 OR LEVEL3
	MOV	DS,BIOSRAM
	MOV	BCURTYP,CX		;SAVE CURSOR TYPE IN BIOS
	PUSH	CS
	POP	DS
	ENDIF
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	DI,OFFSET CURTBL	;POINT TO CURSOR TABLE
	MOV	CX,4
	XOR	AX,AX
	CLD
	REP	STOSW			;CLEAR TABLE
	MOV	CX,CURTYP		;GET CURSOR TYPE
	MOV	VCURFLG,0		;ASSUME INVISIBLE CURSOR
	TEST	CH,20H			;TEST FOR CURSOR OFF
	JNZ	FCP2			;OFF, NO PATTERN
	MOV	VCURFLG,1		;VISIBLE CURSOR
	MOV	BX,OFFSET CURTBL	;POINT TO CURSOR TABLE
FCPLP:	DEC	CH			;LOOK FOR CURSOR START
	JS	FCP1			;FOUND IT
	INC	BX			;ELSE, INCREMENT BX
	JMP	FCPLP
FCP1:	MOV	CX,CURTYP		;GET CURSOR TYPE AGAIN
FCPLP1:	MOV	BYTE PTR [BX],0FFH	;SET A CURSOR LINE
	CMP	CH,CL			;AT CURSOR END?
	JZ	FCP2			;YES
	INC	CH			;ELSE, INCREMENT START POINTER
	AND	CH,7			;WRAP IF MORE THAN 7
	INC	BX			;INCREMENT TABLE POINTER
	CMP	BX,(OFFSET CURTBL)+8	;END OF TABLE?
	JNZ	FCPLP1			;NO
	MOV	BX,OFFSET CURTBL	;ELSE, WRAP
	JMP	FCPLP1
FCP2:	MOV	CSFLG,1			;RESTORE CURSOR
FCPX:	POP	CX
	POP	BX
	POP	AX
	RET

;	SET CURSOR POSITION

SETCUR:	CMP	DX,BCURPOS		;POSTIION SAME AS OLD?
	JZ	SETCUR1			;YES
	CALL	CUROFF			;ELSE, TURN CURSOR OFF
SETCUR1:MOV	BCURPOS,DX		;UPDATE BLINKING CURSOR POSITION
	CALL	STOCUR			;STORE NEW CURSOR POSITION
	MOV	CSFLG,1			;RESTORE CURSOR
	RET

;	GET CURSOR TYPE, POSITION

GETCUR:	MOV	CX,CURTYP		;AND CURSOR TYPE
	CALL	LDCUR			;GET CURSOR POSITION
	RET

;	READ LIGHT PEN

READPEN:RET				;NOT IMPLEMENTED

;	SELECT ACTIVE PAGE

	IF	LEVEL1 OR LEVEL2
SELPAGE:RET				;NOT IMPLEMENTED
	ENDIF
	IF	LEVEL3
SELPAGE:CMP	MODE,4			;MODE < 4?
	JB	SELMOK			;IF SO, OK
	RET
SELMOK:	PUSH	AX
	PUSH	CX
	PUSH	DX			;WE'LL NEED THESE REGISTERS
	XOR	DX,DX			;CLEAR UPPER HALF OF DWORD ACC.
	XOR	AH,AH			;AX = PAGE NUMBER
	CMP	CPL,40			;40 COLUMN MODE?
	JZ	SELP40			;IF SO, SELECT 40 COLUMN PAGE
	CMP	AL,4			;PAGE LESS THAN 4?
	JNB	SELPX			;IF NOT, EXIT
	MOV	APAGE,AL		;SAVE NEW PAGE NUMBER
	MOV	CX,100H			;SIZE OF ONE PAGE IN PARAGRAPHS
	MUL	CX			;CALCULATE PAGE OFFSET
	MOV	CX,25*80		;SIZE OF PAGE
	JMP	SHORT SELPG1
SELP40:	CMP	AL,8			;PAGE LESS THAN 8?
	JNB	SELPX			;IF NOT, EXIT
	MOV	APAGE,AL		;SAVE NEW PAGE NUMBER
	MOV	CL,80H			;SIZE OF ONE PAGE IN PARAGRAPHS
	MUL	CL			;CALCULATE PAGE OFFSET
	MOV	CX,25*40		;SIZE OF PAGE
SELPG1:	MOV	DX,AX			;SAVE CALCULATION IN DX
	ADD	AX,PVIDRAM		;ADD PERMANENT VIDEO RAM ADDRESS
	CMP	AX,VIDRAM		;SAME AS OLD PAGE
	JZ	SELPX			;IF SO, DON'T CONTINUE
	MOV	CSFLG,0			;STOP SCREEN UPDATING
	MOV	VIDRAM,AX		;SAVE NEW PAGE ADDRESS
	ADD	DX,0B800H
	MOV	PCRAM,DX		;FIX PC RAM ALSO
	MOV	ES,AX			;POINT TO NEW PAGE
	MOV	DI,0
	MOV	DL,CPL			;GET CHARS/LINE
	DEC	DL
	MOV	DH,24			;DX = LAST POSITION ON PAGE
	MOV	AL,DH			;GET ROW NUMBER
	MUL	CPL			;MULTIPLY BY CHARS/LINE
	XOR	DH,DH
	ADD	AX,DX			;ADD IN COLUMN NO.
	SHL	AX,1			;MPY BY 2
	MOV	SI,AX			;RESULT TO SI
	MOV	DS,VIDRAM
	PUSH	BX
	MOV	BH,1[SI]		;GET ATTR. OF LAST CHAR
	PUSH	CS
	POP	DS			;FIX DS
	CALL	CVTZCOL			;CONVERT TO Z-100 COLORS
	MOV	AH,BH			;ATTRIBUTE TO AH
	POP	BX
	MOV	AL,' '			;AX = ATTRIBUTE, SPACE
	CLD
	REP	STOSW			;CLEAR NEW PAGE
	CALL	TYPTX
	DB	27,'Y8 ',27,'E'		;CLEAR 25TH LINE
	DB	27,'Y7 ',27,'E'+80H	;CLEAR REST OF SCREEN
	CALL	CHKSCRN			;UPDATE SCREEN
	MOV	CSFLG,1			;RESTORE SCREEN UPDATING
SELPX:	POP	DX			;RESTORE REGISTERS
	POP	CX
	POP	AX
	RET
	ENDIF

	INCLUDE	SCROLL.ACM		;INCLUDE TEXT SCROLLING CODE

;	READ CHARACTER AND ATTRIBUTE

READCHR:CALL	GPADR			;GET ADDRESS IN VIDEO PAGE
	MOV	DS,VIDRAM		;POINT TO VIDEO RAM
	MOV	AX,[SI]			;GET CHAR, ATTRIBUTE
	CMP	CS:GRFLG,0		;GRAPHIC MODE?
	JZ	READNG			;NO
	XOR	AH,AH			;ELSE, RETURN NO ATTRIBUTE
READNG:	RET

;	WRITE CHARACTER WITH ATTRIBUTE

WRTCHR:	PUSH	BX
	CMP	GRFLG,0			;GRAPHIC MODE
	JZ	WRTNG			;NO
	CALL	CVTGT			;ELSE, CONVERT COLORS TO TEXT
WRTNG:	CALL	GPADR			;GET ADDRESS IN VIDEO PAGE
	MOV	AH,BL			;ATTRIBUTE TO AH
	JMP	SHORT WROCH0

;	WRITE CHARACTER ONLY

WROCHR:	PUSH	BX
	CALL	GPADR			;GET ADDRESS IN VIDEO PAGE
	MOV	DS,VIDRAM		;POINT TO VIDEO RAM
	MOV	AH,1[SI]		;GET ATTRIBUTE
	PUSH	CS
	POP	DS
WROCH0:	CALL	CUROFF			;TURN CURSOR OFF
	PUSH	DX
	CALL	LDCUR			;GET CURSOR POSITION
	PUSH	CX			;SAVE COUNT
	CLD				;CLEAR DIR. FLAG
WROLP:	PUSH	AX
	PUSH	SI
	CALL	PUTCHR			;WRITE CHARACTER
	POP	SI
	POP	AX			;RESTORE CHARACTER
	INC	SI
	INC	SI			;INCREMENT POINTER
	DEC	CX			;COUNT CHARACTER
	JNZ	INCUR			;NOT END, INCREMENT CURSOR
	MOV	CSFLG,1			;TURN CURSOR ON
	POP	CX
	POP	DX
	POP	BX
	RET				;RETURN
INCUR:	INC	DL			;INCREMENT COLUMN
	CMP	DL,CPL			;AT END OF LINE?
	JNZ	WROLP			;NO
	MOV	DL,0			;ELSE, SET COLUMN TO 0
	INC	DH			;INCREMENT LINE
	CMP	DH,25			;AT BOTTOM LINE?
	JNZ	WROLP			;NO
	MOV	DH,0			;ELSE, SET LINE TO 0
	JMP	WROLP			;AND LOOP

;	SET COLOR PALATE

SETPAL:	CMP	GRFLG,0			;IN GRAPHIC MODE
	JZ	SETPX			;IF NOT, EXIT (NO BORDER COLORS)
	AND	BH,1			;SET BACKGROUND OR PALETTE?
	JZ	SETBACK			;SET BACKGROUND
	AND	BL,1			;ISOLATE PALETTE NUMBER
	MOV	PALETTE,BL		;SET IT
	IF	LEVEL3
	CMP	BL,OLDPAL		;NEW PALETTE SAME AS OLD?
	JZ	SETPX			;IF SO, EXIT
	MOV	ES,VIDRAM		;POINT TO VIDEO RAM
	MOV	CX,2000H		;CLEAR THIS MUCH
	MOV	DI,1000H		;START HERE
	XOR	AX,AX
	CLD
	REP	STOSW
	MOV	OLDPAL,BL		;UPDATE OLD PALETTE
	ENDIF
SETPX:	RET
SETBACK:AND	BL,7			;NO INTENSE COLORS, PLEASE
	MOV	GBCOL,BL		;SET GRAPHICS BACKGROUND
	CMP	BL,OGBCOL		;SAME AS OLD COLOR?
	JZ	SETPX			;IF SO, DONE
	PUSH	BX
	PUSH	CX
	MOV	BL,3
	CALL	CVTGT			;CONVERT COLORS TO TEXT MODE
	MOV	BH,BL
	CALL	CVTZCOL			;CONVERT TO Z-100 COLORS
	CALL	TYPTX
	DB	27,'Y  ',27,'E'+80H	;SET NEW COLORS
	IF	LEVEL3
	MOV	ES,VIDRAM		;POINT TO VIDEO RAM
	MOV	CX,2000H		;CLEAR THIS MUCH
	MOV	DI,1000H		;START HERE
	XOR	AX,AX
	CLD
	REP	STOSW			;CLEAR VIDEO RAM
	ENDIF
	MOV	AL,GBCOL
	MOV	OGBCOL,AL		;UPDATE OLD BACKGROUND COLOR
	POP	CX
	POP	BX
	RET

	INCLUDE	PIXEL.ACM		;INCLUDE PIXEL GRAPHICS CODE

;	DUMB TERMINAL (TTY) SIMULATOR

TTYOUT:	PUSH	BX
	PUSH	CX
	PUSH	DX
	CALL	LDCUR			;GET CURSOR POSITION
	MOV	BH,APAGE		;GET ACTIVE PAGE
	CMP	AL,0DH			;CR?
	JNZ	NOTCR			;NO
	XOR	DL,DL
	CALL	SETCUR			;ELSE, SET COL. TO 0
	JMP	TTYEX			;EXIT
NOTCR:	CMP	AL,0AH			;LF?
	JNZ	NOTLF
	INC	DH			;ADD 1 TO ROW NO.
	CMP	DH,25			;AT BOTTOM?
	JNZ	NOTBOT			;NO
	JMP	SCROLL			;ELSE, SCROLL
NOTBOT:	CALL	SETCUR			;SET ROW NO.
	CALL	SETZCUR			;SET Z-100 POSITION
	JMP	TTYEX			;EXIT
NOTLF:	CMP	AL,7			;BELL?
	JNZ	NOTBEL
	CALL	CHROUT			;RING BELL
	JMP	TTYEX
NOTBEL:	CMP	AL,8			;BACK SPACE?
	JNZ	NOTBS
	DEC	DL			;BACK UP CURSOR
	JNS	TTBS			;NOT PAST ZERO
	INC	DL			;ELSE, CORRECT
TTBS:	CALL	SETCUR
	JMP	SHORT TTYEX
NOTBS:	MOV	CX,1
	CMP	GRFLG,0			;GRAPHIC MODE
	JZ	WRTXT			;NO, TEXT
	PUSH	BX
	CALL	WRTCHR			;ELSE, WRITE CHAR WITH ATTRIBUTE
	POP	BX
	JMP	SHORT WRGR
WRTXT:	CALL	WROCHR			;WRITE CHARACTER
WRGR:	INC	DL			;INCREMENT COLUMN
	CMP	DL,CPL			;AT END OF LINE?
	JNZ	SETCP1			;NO
	MOV	DL,0			;ELSE, SET COLUMN TO 0
	INC	DH			;INCREMENT LINE
	CMP	DH,25			;AT BOTTOM LINE?
	JNZ	SETCP1			;NO
SCROLL:	DEC	DH			;ELSE, BACK UP TO BOTTOM LINE
	MOV	CX,0
	PUSH	DX
	PUSH	AX
	CMP	GRFLG,0			;GRAPHIC MODE?
	JZ	MTEXT			;NO
	CALL	CVTGT			;ELSE, CONVERT COLORS
	MOV	BH,BL			;PUT RESULT IN BH
	JMP	SHORT NTEXT
MTEXT:	MOV	AL,CPL			;GET CHARS/LINE
	DEC	AL
	CALL	LDCUR			;GET CURSOR POSITION
	MOV	DL,AL			;POINT TO LAST POSITION
	MOV	AL,DH			;GET ROW NUMBER
	MUL	CPL			;MULTIPLY BY CHARS/LINE
	XOR	DH,DH
	ADD	AX,DX			;ADD IN COLUMN NO.
	SHL	AX,1			;MPY BY 2
	MOV	SI,AX			;RESULT TO SI
	MOV	DS,VIDRAM
	MOV	BH,1[SI]		;GET ATTR. OF LAST CHAR
	MOV	AX,CS
	MOV	DS,AX
NTEXT:	MOV	DX,24*256+39		;ASSUME 40 COL. LINE
	CMP	CPL,40
	JZ	TTY40A
	MOV	DX,24*256+79		;IT'S 80 COL.
TTY40A:	MOV	AL,1
	CALL	SCRLUP			;SCROLL UP
	POP	AX
	POP	DX
SETCP1:	CALL	SETCUR
TTYEX:	POP	DX
	POP	CX
	POP	BX
	RET

;	GET VIDEO STATE

GETVS:	MOV	AL,MODE			;GET MODE
	MOV	AH,CPL			;GET COLUMNS
	MOV	BH,APAGE		;GET ACTIVE PAGE
	RET

;	INT 11H PROCESSOR -- RETURNS I/O STATE

INT11:
	IF	LEVEL1
	MOV	AX,446DH		;DEFAULT Z-150 VALUE
	ENDIF
	IF	LEVEL2 OR LEVEL3
	PUSH	DS
	MOV	DS,CS:BIOSRAM
	MOV	AX,EQFLG		;GET EQUIPMENT FLAG
	POP	DS
	ENDIF
	IRET

;	INT 12H PROCESSOR -- RETURNS MEMORY SIZE

INT12:
	IF	LEVEL1
	MOV	AX,CS:MEMSIZ		;GET MEMORY SIZE
	ENDIF
	IF	LEVEL2 OR LEVEL3
	PUSH	DS
	MOV	DS,CS:BIOSRAM
	MOV	AX,MEMSIZ
	POP	DS
	ENDIF
	IRET

	INCLUDE	DISK.ACM		;INCLUDE DISK I/O CODE

	INCLUDE	PRINT.ACM		;INCLUDE PRINT PROCESSOR

	INCLUDE	KEY.ACM			;INCLUDE KEYBOARD PROCESSOR

	IF	LEVEL2 OR LEVEL3
;	INT 1AH PROCESSOR
;	GET/SET TIME OF DAY

INT1A:	PUSH	DS
	MOV	DS,CS:BIOSRAM		;POINT TO BIOS RAM
	OR	AH,AH			;READ?
	JNZ	SETTOD			;NO, SET
	MOV	DX,TIMERL		;GET TIMER LOW WORD
	MOV	CX,TIMERH		;AND HIGH WORD
	XOR	AL,AL
	POP	DS
	IRET
SETTOD:	MOV	TIMERL,DX		;SET TIMER LOW WORD
	MOV	TIMERH,CX		;AND HIGH WORD
	POP	DS
	IRET
	ENDIF

	INCLUDE	DOS.ACM			;PUT DOS I/O PROCESSOR HERE
	
;	TIMER PROCESSING ROUTINE
;	THIS CODE PROCESSES Z-100 TIMER INTERRUPTS TO
;	BLINK THE PC CURSOR, AND TO SIMULATE THE PC TIMER INTERRUPT

TIMER:	PUSH	AX
	PUSH	DS
	PUSH	CS
	POP	DS			;PUT DS HERE
	CMP	PCFLG,0			;PC MODE ON?
	JNZ	PCON
	JMP	TIMEX
PCON:
	MOV	AH,TICCNT		;GET TICK COUNTER
	ADD	AH,AL			;ADD TICKS
	CMP	AH,TMAX			;MAX TICKS?
	JNAE	NOTMAX			;NO
	STI
	PUSH	AX
	INT	HTIMINT			;ISSUE PC HARDWARE TIMER INTERRUPT
	INT	PTIMINT			;ISSUE PC SOFTWARE TIMER INTERRUPT
	POP	AX
	CLI
	IF	LEVEL2 OR LEVEL3
	PUSH	DS
	PUSH	AX
	MOV	AX,40H
	MOV	DS,AX			;PUT DS AT BIOS SEGMENT
	INC	TIMERL			;INCREMENT TIMER WORD LOW
	JNZ	NOTHI			;NOT TIMED OUT
	INC	TIMERH			;ELSE, INCREMENT HIGH WORD
NOTHI:	POP	AX
	POP	DS
	ENDIF
	XOR	TMAX,3			;CHANGE STATE OF TMAX
	XOR	AH,AH			;RESET TICK COUNTER
NOTMAX:	MOV	TICCNT,AH		;UPDATE TICK COUNTER
	PUSH	BX
	PUSH	AX
	MOV	AX,SS			;GET STACK SEGMENT
	MOV	BX,CS			;AND CODE SEGMENT
	CMP	AX,BX			;COMPARE THEM
	POP	AX
	POP	BX
	JB	TIMEX			;STACK LOWER, WE'ER IN THE DOS
	CMP	CSFLG,0			;CURSOR/CHECK ENABLED?
	JZ	TIMEX			;NO
	IF	LEVEL3
	MOV	AH,CHKCNT		;GET SCREEN CHECK COUNTER
	ADD	AH,AL			;ADD TICKS
	CMP	AH,CHKMAX		;MAX TICKS GONE?
	JNAE	TIMER1			;NO
	MOV	CSFLG,0			;KILL CHECK WHILE WE DO THIS
	CALL	CHKSCRN			;CHECK SCREEN
	MOV	CSFLG,1			;RE-ENABLE CHECKS
	XOR	AH,AH			;CLEAR CHECKSUM COUNTER
TIMER1:	MOV	CHKCNT,AH		;UPDATE CHECKSUM COUNTER
	ENDIF
	CMP	VCURFLG,0		;VISIBLE CURSOR?
	JZ	TIMER2			;IF NOT, MOVE ON
	MOV	AH,CURCNT		;ELSE, GET CURSOR COUNTER
	ADD	AH,AL			;ADD TICKS
	CMP	AH,14			;14 TICKS?
	JNAE	NOT14			;NO
	MOV	CSFLG,0			;PREVENT DOUBLE JEOPARDY
	XOR	CURSTAT,1		;CHANGE CURSOR STATE FLAG
	STI
	CALL	TGLCUR			;TOGGLE CURSOR STATE
	CLI
	MOV	CSFLG,1
	XOR	AH,AH			;ELSE, RESET COUNT
NOT14:	MOV	CURCNT,AH		;UPDATE CURSOR COUNT
TIMER2:	MOV	AH,NUMCNT		;GET NUM LOCK COUNTER
	ADD	AH,AL			;ADD TICKS
	CMP	AH,50			;ONE HALF SECOND GONE?
	JNAE	NOT50			;NO
	CALL	CHKNUM			;ELSE, CHECK NUM LOCK KEY
	XOR	AH,AH			;CLEAR COUNTER
NOT50:	MOV	NUMCNT,AH		;UPDATE NUM LOCK COUNTER
TIMEX:	POP	DS
	POP	AX
	JMPF
OLDTIME	DW	0,0			;OLD TIMER VECTOR HERE

	IF	LEVEL3
;	CODE TO ALTER SIZE ALLOTTED TO PROGRAM, SO THAT
;	VIDEO RAM IS NOT OVER-WRITTEN

SIZCHK:	CMP	CS:DOSVER,3		;DOS 3?
	JNZ	ND3C			;NO
	CMP	AX,CS:MEMSV		;CHECK SIZE
	JBE	SIZOK			;IT'S OK
	MOV	AX,CS:MEMSV		;ELSE, LIMIT IT
SIZOK:	MOV	ES:MEMLIM,AX		;SAVE NEW SIZE
	SUB	AX,DX
	RETF
ND3C:	CMP	SI,CS:MEMSV		;CHECK SIZE
	JBE	SIZOK			;IT'S OK
	MOV	SI,CS:MEMSV		;ELSE, LIMIT IT
SIZOK1:	MOV	ES:MEMLIM,SI		;SAVE NEW SIZE
	RETF
	ENDIF

;	RETURN FOR PC TIMER AND OTHER INTERRUPTS

INTRET:	IRET

;	SUBROUTINES

;	CVTZCOL -- CONVERT PC COLOR TO ESCAPE SEQUENCE,
;	AND EXECUTE IT (FOR SCROLL ROUTINES)
;	ENTER:	BH = PC COLOR VALUES
;	EXIT:	Z-100 COLORS SET

CVTZCOL	PROC	NEAR
	PUSH	BX
	PUSH	AX
	CMP	MODE,0			;MODE 0?
	JZ	CVTBW			;YES, BLACK AND WHITE MODE
	CMP	MODE,2			;MODE 2?
	JZ	CVTBW
	CMP	MODE,7			;MODE 7?
	JNZ	CVTNBW			;NO
CVTBW:	MOV	AL,BH			;GET COLORS
	AND	AL,070H			;ISOLATE BACKGROUND
	CMP	AL,70H			;WHITE BACKGROUND?
	MOV	BH,7			;ASSUME IT ISN'T
	JNZ	CVTNBW
	MOV	BH,20H			;ASSUME GREEN MONOCHROME
	CMP	REDSEL,11101111B	;GREEN MONOCHROME?
	JZ	CVTNBW
	MOV	BH,60H			;ELSE, USE YELLOW
CVTNBW:	MOV	AL,BH			;GET COLORS
	AND	AL,07H			;ISOLATE FOREGROUND COLOR
	PUSH	BX
	MOV	BX,OFFSET CESTBL
	XLAT				;CONVERT TO ESC-m COLOR
	POP	BX
	MOV	FZCOL,AL		;SET UP ESC TEXT
	MOV	AL,BH			;GET COLORS AGAIN
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1			;MOVE BACKGROUND COLOR DOWN
	MOV	BX,OFFSET CESTBL
	XLAT				;CONVERT IT
	OR	AL,80H			;SET 8TH BIT
	MOV	BZCOL,AL		;SET UP TEXT
	CALL	TYPTX
	DB	27,'m'
FZCOL	DB	'7'
BZCOL	DB	'0'+80H
	POP	AX
	POP	BX
	RET
CVTZCOL	ENDP

;	CVTGT -- CONVERT GRAPHIC COLORS TO TEXT COLORS
;	ENTER:	FOREGROUND COLOR IN BL
;		PALETTE NO. IN PALETTE
;		BACKGROUND COLOR IN GBCOL
;	EXIT:	TEXT MODE COLORS IN BL

CVTGT	PROC	NEAR
	MOV	XORFLG,0		;CLEAR XOR FLAG
	TEST	BL,80H			;XOR MODE?
	JZ	CVTGT1			;NO
	MOV	XORFLG,1		;ELSE, SET XOR FLAG
CVTGT1:	CMP	MODE,6			;HI-RES MODE?
	JNZ	CVTMR			;NO
	MOV	BL,7			;ELSE, ATTRIBUTE IS 7
	RET
CVTMR:	PUSH	AX
	MOV	AL,BL			;COLOR TO AL
	AND	AL,3			;MAX COLOR NO. IS 3
	IF	LEVEL3
	XOR	AH,AH			;AX = COLOR
	MOV	BX,AX			;IN BX
	SHL	BX,1			;* 2
	MOV	BX,GBMSTBL[BX]		;GET GRAPHIC BIT MASK
	MOV	GBMSK,BX		;STORE IT
	ENDIF
	MOV	BX,OFFSET PAL0TBL	;ASSUME PALETTE 0
	CMP	PALETTE,0		;IS IT?
	JZ	PAL0			;YES
	MOV	BX,OFFSET PAL1TBL	;ELSE, OTHER TABLE
PAL0:	XLAT				;CONVERT TO TEXT COLOR
	MOV	BL,GBCOL		;GET BACKGROUND COLOR
	SHL	BL,1			;SHIFT IT TO HIGH NIBBLE
	SHL	BL,1
	SHL	BL,1
	SHL	BL,1
	OR	AL,AL			;TEST FOREGROUND COLOR
	JZ	USEBK			;ZERO, USE BACKGROUND
	OR	BL,AL			;ADD IN FOREGROUND COLOR
	POP	AX
	RET
USEBK:	OR	BL,GBCOL		;USE BACKGROUND FOR FOREGROUND
	POP	AX
	RET
CVTGT	ENDP

;	SETZCUR -- SET Z-100 CURSOR FROM PC VALUES
;	ENTER:	CURSOR IN VARIABLE CURPOS
;	EXIT:	Z-100 CURSOR SET THERE

SETZCUR	PROC	NEAR
	PUSH	AX
	PUSH	DX
	CALL	LDCUR			;GET CURSOR POSITION
	MOV	AX,DX			;IN AX
	POP	DX
	CMP	CPL,80			;80 CHARS/LINE?
	JZ	SETZ80			;YES
	SHL	AL,1			;ELSE, DOUBLE COLUMN
	OR	AL,AL			;COLUMN ZERO?
	JZ	SETZ80			;IF SO, LEAVE IT THERE
	ADD	AL,1			;ADD 1 (2ND HALF OF POS)
SETZ80:	ADD	AX,2020H		;CONVERT TO Z-100 VALUES
	XCHG	AL,AH			;FIX ORDER
	OR	AH,80H			;SET HIGH BIT
	MOV	ZPOS,AX			;PUT IT IN TEXT
	CALL	TYPTX
	DB	27,'Y'
ZPOS	DW	0A020H
	POP	AX
	RET
SETZCUR	ENDP

;	GPADR -- GET VIDEO PAGE ADDRESS
;	ENTER:	CURSOR ADDRESS AND PAGE NO. IN VARIABLES
;	EXIT:	ADDRESS IN SI

GPADR	PROC	NEAR
	PUSH	AX
	PUSH	DX
	CALL	LDCUR			;GET CURSOR POSITION
	MOV	AL,DH			;GET ROW NUMBER
	MUL	CPL			;MULTIPLY BY CHARS/LINE
	XOR	DH,DH
	ADD	AX,DX			;ADD IN COLUMN NO.
	SHL	AX,1			;MPY BY 2
	MOV	SI,AX			;RESULT TO SI
	POP	DX
	POP	AX
	RET
GPADR	ENDP

;	LOAD CURSOR POSITION

LDCUR	PROC	NEAR
	IF	LEVEL1
	MOV	DX,CURPOS
	RET
	ENDIF
	IF	LEVEL2
	MOV	DS,BIOSRAM
	MOV	DX,CURPOS
	PUSH	CS
	POP	DS
	RET
	ENDIF
	IF	LEVEL3
	PUSH	AX
	PUSH	SI
	MOV	AL,APAGE		;GET ACTIVE PAGE
	CBW				;MAKE IT A WORD
	SHL	AX,1			;MPY BY 2
	MOV	DS,BIOSRAM
	MOV	SI,OFFSET CURPOS
	ADD	SI,AX			;POINT TO CURSOR FOR THIS PAGE
	MOV	DX,[SI]			;GET POSITION
	PUSH	CS
	POP	DS			;FIX DS
	POP	SI
	POP	AX
	RET
	ENDIF
LDCUR	ENDP

;	STORE CURSOR POSITION

STOCUR	PROC	NEAR
	IF	LEVEL1
	MOV	CURPOS,DX
	RET
	ENDIF
	IF	LEVEL2
	MOV	DS,BIOSRAM
	MOV	CURPOS,DX
	PUSH	CS
	POP	DS
	RET
	ENDIF
	IF	LEVEL3
	PUSH	AX
	PUSH	SI
	MOV	AL,APAGE		;GET ACTIVE PAGE
	CBW				;MAKE IT A WORD
	SHL	AX,1			;MPY BY 2
	MOV	DS,BIOSRAM
	MOV	SI,OFFSET CURPOS
	ADD	SI,AX			;POINT TO CURSOR FOR THIS PAGE
	MOV	[SI],DX			;SET POSITION
	PUSH	CS
	POP	DS			;FIX DS
	POP	SI
	POP	AX
	RET
	ENDIF
STOCUR	ENDP

	INCLUDE	PUTCHR.ACM		;INCLUDE PUT CHARACTER ROUTINE

;	CUROFF - TURN CURSOR OFF (DISABLE IT)

CUROFF	PROC	NEAR
	CLI				;KILL INTERRUPTS
	CMP	CSFLG,0			;CURSOR ENABLED?
	JZ	CUROFFX			;NO
	MOV	CSFLG,0			;TURN OFF CURSOR BLINKING
CUROFF1:CMP	CURSTAT,0		;CURSOR ON?
	JZ	CUROFFX			;NO
	STI
	MOV	CURSTAT,0		;ELSE, FLAG CURSOR OFF
	CALL	TGLCUR			;TURN IT OFF
CUROFFX:STI
	RET
CUROFF	ENDP

;	TGLCUR - TOGGLE CURSOR (OFF OR ON)

TGLCUR	PROC	NEAR
	PUSH	AX
	PUSH	BX			;SAVE REGISTERS
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	IN	AL,VRPORT		;READ VRAM PORT
	PUSH	AX			;SAVE VALUE
	CLD
	MOV	SI,OFFSET CURTBL1	;POINT TO CURSOR LINE TABLE
	MOV	AX,BCURPOS		;GET CURSOR POSITION
	CMP	CURSTAT,0		;TURNING CURSOR OFF?
	JNZ	TGLON			;NO
	CALL	LDCUR			;ELSE, GET REAL CURSOR POSITION
	MOV	BCURPOS,DX		;UPDATE BLINKING CURSOR POSITION
TGLON:	MOV	DX,AX
	MOV	AL,DH			;GET ROW
	MUL	LFACTOR			;CHANGE TO TABLE POINTER
	MOV	BX,AX			;POINTER TO BX
	XOR	DH,DH			;ISOLATE COLUNN NO.
	CMP	CPL,40			;40 COLUMNS?
	JNZ	TGL80
	JMP	TGL40
TGL80:	MOV	CX,LINES		;SET A COUNTER
	CMP	CL,9			;TEXT MODE?
	JNZ	TGLLP			;NO
	DEC	CX			;ELSE, FIRST LINE NOT USED
	INC	BX			;SO POINT TO NEXT ONE
	INC	BX
TGLLP:	MOV	DI,LOCTBL[BX]		;GET ROW ADDRESS FROM TABLE
	ADD	DI,DX			;DI POINTS TO CHARACTER POSITION
	MOV	AH,[SI]			;GET CURSOR BIT PATTERN
	INC	SI
	MOV	ES,GRAM
	MOV	AL,GREENB
	OUT	VRPORT,AL		;SET GREEN
	XOR	ES:[DI],AH		;TOGGLE GREEN BITS
	MOV	ES,RRAM
	MOV	AL,REDB
	OUT	VRPORT,AL		;SET RED
	XOR	ES:[DI],AH		;TOGGLE RED BITS
	MOV	ES,BRAM
	MOV	AL,BLUEB
	OUT	VRPORT,AL		;SET BLUE
	XOR	ES:[DI],AH		;TOGGLE BLUE BITS
	INC	BX			;POINT TO NEXT LOCATION
	INC	BX
	LOOP	TGLLP			;LOOP UNTIL CHAR PRINTED
TGLEX:	POP	AX
	OUT	VRPORT,AL		;RESTORE VRAM PORT
	CMP	CURSTAT,0		;CURSOR OFF?
	JNZ	TGLON1			;NO
	MOV	AX,DS
	MOV	ES,AX			;ELSE, PUT ES HERE
	MOV	SI,OFFSET CURTBL
	MOV	DI,OFFSET CURTBL1	;POINT TO THE CURSOR TABLES
	MOV	CX,4
	REP	MOVSW			;UPDATE THE ACTIVE ONE
TGLON1:	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
TGL40:	SHL	DX,1			;MPY BY 2
	MOV	CX,LINES		;SET A COUNTER
	CMP	CL,9			;TEXT MODE?
	JNZ	TGLLP1			;NO
	DEC	CX			;ELSE, FIRST LINE NOT USED
	INC	BX			;SO POINT TO NEXT ONE
	INC	BX
TGLLP1:	MOV	DI,LOCTBL[BX]		;GET ROW ADDRESS FROM TABLE
	ADD	DI,DX			;DI POINTS TO CHARACTER POSITION
	MOV	AH,[SI]			;GET CURSOR BIT PATTERN
	INC	SI
	MOV	ES,GRAM
	MOV	AL,GREENB
	OUT	VRPORT,AL		;SET GREEN
	MOV	AL,AH
	XOR	ES:[DI],AX		;TOGGLE GREEN BITS
	MOV	ES,RRAM
	MOV	AL,REDB
	OUT	VRPORT,AL		;SET RED
	MOV	AL,AH
	XOR	ES:[DI],AX		;TOGGLE RED BITS
	MOV	ES,BRAM
	MOV	AL,BLUEB
	OUT	VRPORT,AL		;SET BLUE
	MOV	AL,AH
	XOR	ES:[DI],AX		;TOGGLE BLUE BITS
	INC	BX			;POINT TO NEXT LOCATION
	INC	BX
	LOOP	TGLLP1			;LOOP UNTIL CHAR PRINTED
	JMP	TGLEX
TGLCUR	ENDP

	IF	LEVEL3
;	CHECK VIDEO MEMORY FOR CHARACTER CHANGES
;	REPAINT REAL VIDEO IF CHANGES FOUND

CHKSCRN	PROC	NEAR
	MOV	STK1,SP			;SAVE STACK
	MOV	STKS1,SS		;AND STACK SEGMENT
	PUSH	CS
	POP	SS			;PUT STACK HERE
	MOV	SP,80H			;AT 80H
	STI
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	CLD				;SCAN FORWARD
	MOV	DS,PCRAM		;POINT TO PC RAM
	XOR	SI,SI
	MOV	DI,SI			;START AT BEGINNING (CHANGE IF PAGES)
	CMP	CS:GRFLG,0		;GRAPHIC MODE?
	JNZ	CHKGM			;IF SO, USE GRAPHIC CHECK
	MOV	ES,CS:VIDRAM		;POINT TO VIDEO RAM
	MOV	CX,CS:CPS		;GET CHARS/SCREEN
CHKLP:	REPZ	CMPSW			;COMPARE VIDEO
	JNZ	UPDSCRN			;UPDATE SCREEN IF NO MATCH
CHKEX:	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	CLI
	MOV	SS,CS:STKS1		;GET OLD STACK SEGMENT
	MOV	SP,CS:STK1		;AND OLD STACK POINTER
	RET
UPDSCRN:PUSH	SI
	PUSH	DI			;SAVE POINTERS
	PUSH	DS
	PUSH	ES			;SAVE SEGMENTS
	CLI
	DEC	SI			;BACK UP TO MISMACHED CHAR
	DEC	SI
	MOV	AX,[SI]			;GET NEW CHAR
	PUSH	CS
	POP	DS			;PUT DS HERE
	CALL	CUROFF1			;TURN CURSOR OFF
	PUSH	AX
	MOV	BL,CPL
	XOR	BH,BH			;BX = CHARS/LINE
	MOV 	AX,SI			;GET CHARACTER POSITION
	SHR	AX,1			;DIVIDE BY 2
	XOR	DX,DX
	DIV	BX			;CONVERT ABS LOC TO CUR. POS
	MOV	DH,AL			;DX = CURSOR POS.
	POP	AX
	CALL	PUTCHR			;PUT CHAR ON THE SCREEN
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	CMP	CX,0			;ALL DONE?
	JNZ	CHKLP			;IF NOT, TRY FOR MORE
	JMP	CHKEX			;ELSE, EXIT

CHKGM:	MOV	AX,CS:VIDRAM		;GET VIDEO RAM
	ADD	AX,100H			;MOVE TO GRAPHIC PART
	MOV	ES,AX			;PUT ES HERE
	MOV	CX,8000			;CHECK THIS MUCH
CHKLP1:	REPZ	CMPSB			;COMPARE VIDEO
	JNZ	UPDSCR1			;UPDATE SCREEN IF NO MATCH
	CMP	DI,2000H		;SECOND PAGE?
	JNC	CHKEXJ			;IF SO, DONE
	MOV	DI,2000H		;ELSE, SET UP FOR SECOND PAGE
	MOV	SI,2000H
	MOV 	CX,8000
	JMP	CHKLP1			;CHECK SECOND PAGE
CHKEXJ:	JMP	CHKEX
UPDSCR1:PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	CLI
	DEC	DI
	DEC	SI			;BACK UP TO MIS-MATCHED BYTE
	MOV	AX,DI
	CMP	DI,2000H		;SECOND PAGE?
	JC	GPAGE1			;NO
	SUB	AX,2000H		;ELSE, REMOVE THIS OFFSET
GPAGE1:	XOR	DX,DX
	MOV	BX,80
	DIV	BX			;GET ROW NO. OF BYTE
	SHL	AX,1			;MPY BY 2 (EVERY OTHER ROW)
	CMP	DI,2000H		;ON SECOND PAGE?
	JC	GPAGE2			;NO
	ADD	AX,1			;ELSE, DOING ODD ROWS
GPAGE2:	SHL	AX,1			;MPY BY 2 AGAIN
	MOV	BX,AX			;BX = ROW * 2
	XOR	DH,DH			;DX = COLUMN
	MOV	AH,ES:[DI]		;GET OLD BYTE
	LODSB				;GET NEW BYTE
	STOSB				;UPDATE LOCAL VIDEO RAM
	PUSH	CS
	POP	DS			;PUT DS HERE
	CALL	CUROFF1			;TURN CURSOR OFF
	MOV	BX,LOCTBL[BX]		;GET LOCATION OF ROW
	ADD	BX,DX			;MOVE TO BYTE
	CMP	MODE,6			;HI-RES MODE?
	JNZ	CHKMED			;NO
	MOV	ES,GRAM			;ELSE, POINT TO GREEN RAM
	PUSH	AX			;SAVE PIXEL PATTERN
	MOV	AL,WHITEB
	OUT	VRPORT,AL		;SELECT WHITE
	POP	AX
	MOV	ES:[BX],AL		;UPDATE SCREEN
UPDX:	POP	ES
	POP	DS
	POP	DI
	POP	SI
	CMP	CX,0			;DONE
	JNZ	CHKLP1			;IF NOT, LOOK FOR MORE CHANGES
	JMP	CHKEX			;ELSE, EXIT
CHKMED:	PUSH	CX			;SAVE COUNT
	MOV	SI,BX			;POINT SI TO BYTE LOCATION
	MOV	DL,11000000B		;SET UP PIXEL MASK
	MOV	CL,6			;SET UP SHIFT FACTOR
CHKMLP:	PUSH	AX			;SAVE OLD, NEW BYTES
	AND	AH,DL
	AND	AL,DL			;MASK PIXEL
	CMP	AH,AL			;COMPARE PIXELS
	JZ	SAMEP			;THESE ARE THE SAME, NO UPDATE
	MOV	BL,AL			;ELSE, PUT COLORS IN BL
	SHR	BL,CL			;SHIFT THEM DOWN
	CALL	CVTGT			;CONVERT TO TEXT COLORS
	CALL	PUTDOT			;PUT DOT ON SCREEN
SAMEP:	POP	AX			;RESTORE BYTES
	SHR	DL,1			;MOVE MASK DOWN
	SHR	DL,1
	SUB	CL,2			;REDUCE SHIFT FACTOR
	JNS	CHKMLP			;TRY NEXT PIXEL
	POP	CX			;ELSE, RESTORE COUNT
	JMP	UPDX			;TRY NEXT BYTE
CHKSCRN	ENDP
	ENDIF

;	CHECK STATUS OF NUM LOCK.  INDICATE ON SCREEN IF ON

CHKNUM	PROC	NEAR
	PUSH	AX
	PUSH	SI
	PUSH	DS
	IN	AL,VRPORT		;GET VRPORT VALUE
	PUSH	AX			;SAVE IT
	MOV	AL,WHITEB
	OUT	VRPORT,AL		;ENABLE WHITE VIDEO
	IF	LEVEL1
	MOV	AL,KBFLG		;GET KEYBOARD STATUS FLAG
	ENDIF
	IF	LEVEL2 OR LEVEL3
	MOV	DS,BIOSRAM
	MOV	AL,BYTE PTR KBFLG	;GET KEYBOARD STATUS FLAG
	PUSH	CS
	POP	DS
	ENDIF
	MOV	DS,GRAM			;POINT TO GREEN RAM
	XOR	SI,SI			;INITIALIZE POINTER
	TEST	AL,20H			;TEST FOR NUM LOCK KEY
	JZ	NUMOFF			;IT'S OFF
	MOV	BYTE PTR [SI],0FCH	;ELSE, MARK IT ON
	MOV	BYTE PTR 80H[SI],0	;CLEAR LINE BELOW MARK
	JMP	SHORT NUMDN		;AND CLEAR LINE 2
NUMOFF:	MOV	BYTE PTR [SI],0		;CLEAR NUM LOCK MARK
NUMDN:	POP	AX
	OUT	VRPORT,AL		;RESTORE VRPORT VALUE
	POP	DS
	POP	SI
	POP	AX
	RET
CHKNUM	ENDP

;	TYPTX - TYPE TEXT UNTIL PARITY BIT SET

TYPTX	PROC	NEAR
	MOV	BP,SP			;GET TEXT ADDR
	XCHG	BX,[BP]
TYPTX1:	MOV	AL,[BX]
	AND	AL,7FH
	CALL	CHROUT			;OUTPUT CHARACTER
	CMP	AL,[BX]
	LAHF
	INC	BX
	SAHF
	JZ	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPTX	ENDP

;	CHARACTER OUTPUT ROUTINE, VIA ROM

CHROUT	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	CLD
	CALL	ROMOUT			;PRINT CHARACTER VIA ROM
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
CHROUT	ENDP

	DB	(($-ZERO)/256*256)+256-($-ZERO) DUP (?)	;SPACE TO EVEN PAGE
BA:
BUFF	STRUC
TEXT	DB	1000H DUP (?)		;VIDEO MEMORY FOR TEXT
GRAPHIC	DB	4000H DUP (?)		;VIDEO MEMORY FOR GRAPHICS
SCRLM	DB	1000H DUP (?)		;SCROLL ROUTINE MEMORY
ENDRES	DB	?
BUFF	ENDS

;	SET UP PROGRAM
;	INSTALL PC-TYPE INTERRUPT VECTORS

SETUP:	IN	AL,VRPORT		;GET VIDEO PORT VALUE
	MOV	VPVAL,AL		;SAVE IT
	PUSH	ES
	MOV 	AX,0FBFFH
	MOV	ES,AX			;POINT TO ROM
	MOV	SI,0AH			;SPECIAL PLACE
	CMP	ES:WORD PTR [SI],4550H	;TEST FOR ET-100 CODE
	POP	ES
	JNZ	NOTET			;NOT AN ET-100
	DEC	BYTE PTR ETFLG		;ELSE, MARK IT
NOTET:	MOV	AX,0C00H
	INT	21H			;CLEAR CONSOLE
	MOV	DX,OFFSET TSTMSG
	MOV	AH,9
	INT	21H			;TEST FOR Z-100 MODE
	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			;LOOK FOR INPUT
	JNZ	Z100M			;Z-100 MODE
	MOV	AX,600H
	MOV	CX,0
	MOV	DX,24*256+79
	MOV	BH,7			;PREPARE TO CLEAR SCREEN
	INT	10H			;CLEAR IT
	MOV	DX,12*256		;PUT CURSOR HERE
	MOV	BH,0
	MOV	AH,2
	INT	10H			;SET CURSOR
	MOV	BYTE PTR IBMFLG,1	;FLAG IBM MODE ON
	JMP	SHORT IBM
Z100M:	MOV	AX,0C00H
	INT	21H			;CLEAR TYPE-AHEAD
	IN	AL,VRPORT		;GET VIDEO PORT VALUE
	AND	AL,0FH			;ISOLATE VDP BITS
	MOV	AH,WHITE
	OR	AH,AL
	MOV	WHITEB,AH		;SET WHITE BITS
	MOV	AH,RED
	OR	AH,AL
	MOV	REDB,AH			;SET RED BITS
	MOV	AH,GREEN
	OR	AH,AL
	MOV	GREENB,AH		;SET GREEN BITS
	MOV	AH,BLUE
	OR	AH,AL
	MOV	BLUEB,AH		;SET BLUE BITS
	MOV	AL,REDB
	MOV	DS,RRAM			;GET RED RAM PLANE
	OUT	VRPORT,AL		;ENABLE IT
	XOR	SI,SI
	MOV	BYTE PTR [SI],1		;WRITE A 1 TO RED RAM
	CMP	BYTE PTR [SI],1		;TEST IT
	PUSH	CS
	POP	DS			;FIX DS
	JNZ	NOTCM			;NOT COLOR MEMORY
	MOV	CMFLG,1			;ELSE, FLAG IT
NOTCM:	CALL	TYPTX
	DB	27,'m70',27,'E'+80H	;CLEAR SCREEN TO BLACK
IBM:	IN	AL,VRPORT		;GET VIDEO PORT VALUE
	AND	AL,0FH			;ISOLATE VDP CONTROL BITS
	OR	AL,BLUE
	OUT	VRPORT,AL		;ENABLE WRITE TO BLUE
	CLD
	MOV	ES,BRAM			;POINT TO BLUE RAM
	MOV	BX,14			;INITIALIZE A POINTER
	MOV	CX,19			;SET A COUNTER (19 LINES)
	MOV	AL,0FFH			;PATTERN FOR LINES
BLULP:	MOV	DI,LOCTBL[BX]		;GET ADDRESS OF LINE
	ADD	DI,33			;CENTER MESSAGE
	PUSH	BX			;SAVE POINTER
	PUSH	CX			;SAVE LINE COUNT
	MOV	CX,14			;GET BYTE COUNT
	REP	STOSB			;PAINT A BLUE LINE
	POP	CX
	POP	BX
	INC	BX
	INC	BX			;MOVE TO NEXT LINE (ONE SKIPPED)
	LOOP	BLULP			;FINISH PAINTING
	IN	AL,VRPORT		;GET VIDEO PORT VALUE
	AND	AL,0FH			;ISOLATE VDP CONTROL BITS
	OR	AL,01000000B		;MASK OUT BLUE
	OUT	VRPORT,AL		;ENABLE WRITE TO RED AND GREEN
	MOV	ES,GRAM			;POINT TO GREEN RAM
	MOV	BX,18			;INITIALIZE A POINTER
	MOV	SI,OFFSET ZPC		;POINT TO "ZPC" BITS
	MOV	CX,8			;SET A COUNTER (8 LINES)
ZPCLP:	MOV	DI,LOCTBL[BX]		;GET ADDRESS OF LINE
	ADD	DI,34			;CENTER MESSAGE
	PUSH	BX			;SAVE POINTER
	PUSH	CX			;SAVE LINE COUNT
	MOV	CX,12			;GET BYTE COUNT
	REP	MOVSB			;MOVE LINE TO VIDEO RAM
	POP	CX
	POP	BX
	ADD	BX,4			;MOVE TO NEXT LINE (ONE SKIPPED)
	LOOP	ZPCLP			;FINISH MESSAGE
	CALL	TYPTX
	DB	27,'Y$;Z-100 PC Emulator, V 2.0.'
	IF	LEVEL1
	DB	'1'
	ENDIF
	IF	LEVEL2
	DB	'2'
	ENDIF
	IF	LEVEL3
	DB	'3'
	ENDIF
	DB	27,'Y&4By Patrick Swayne, HUG Software Engineer'
	DB	27,'Y(0Copyright (C) 1986 by Heath/Zenith '
	DB	"Users' Group",27,'Y,','='+80H
	CMP	BYTE PTR IBMFLG,0	;IBM MODE ON?
	JNZ	ZPCIN			;IF SO, ZPC MUST BE ALREADY LOADED
	MOV	AL,VPVAL
	OUT	VRPORT,AL		;FIX VR PORT
	IF	LEVEL2 OR LEVEL3
	MOV	AX,3000H
	INT	21H			;GET DOS VERSION
	CMP	AL,2
	JNB	VEROK			;VERSION OK
	MOV	DX,OFFSET VERMSG
	MOV	AH,9
	INT	21H			;SAY "BAD VERSION"
	INT	20H
VEROK:
	ENDIF
	IF	LEVEL3
	MOV	DOSVER,AL		;SAVE DOS VERSION
	CMP	AL,3			;DOS 3?
	JNZ	ND3D			;NO
	MOV	CODE1,0A326H		;ELSE, SET UP DOS 3 CODE
	MOV	CODE2,2
	MOV	CODE3,0C22BH
	JMP	SHORT CODEDN
ND3D:	MOV	CODE1,8926H		;SET UP DOS 2 CODE
	MOV	CODE2,236H
	MOV	CODE3,0
CODEDN:
	ENDIF
	PUSH	DS			;SAVE DS
	MOV	AX,MEMLIM		;GET MEMORY LIMIT
	IF	LEVEL3
	CMP	AX,0C000H		;ENOUGH MEMORY?
	JAE	MEMGD			;YES
	POP	DS
	MOV	DX,OFFSET NEMMSG
	MOV	AH,9
	INT	21H			;SAY "NOT ENOUGH MEMORY"
	INT	20H
MEMGD:
	ENDIF
	MOV	CL,6
	SHR	AX,CL			;CONVERT TO K'S
	IF	LEVEL3
	MOV	BX,MEMSV		;GET MEMORY SIZE VARIABLE
	SHR	BX,CL			;CONVERT TO K'S
	CMP	AX,BX			;MEMORY SIZE IN PC RANGE?
	JBE	MEMOK			;YES
	MOV	AX,BX			;ELSE, USE MAX PC VALUE
MEMOK:
	ENDIF
	IF	LEVEL1
	MOV	MEMSIZ,AX		;SAVE IT
	ENDIF
	IF	LEVEL2 OR LEVEL3
	MOV	WORD PTR PCDATA+10H,AX	;SAVE MEMORY SIZE
	ENDIF
	XOR	AX,AX
	MOV	DS,AX			;PUT DS AT 0
	MOV	SI,10H*4		;POINT TO INT 10 VECTOR
	LES	DI,DWORD PTR [SI]	;GET INT. 10 ADDRESS
	CMP	ES:WORD PTR -2[DI],'CP'	;ZPC ALREADY IN?
	JNZ	NOTIN
	POP	DS
ZPCIN:	MOV	DX,OFFSET INMSG
	MOV	AH,9
	INT	21H			;SAY "ALREADY INSTALLED"
	INT	20H			;ELSE, EXIT
NOTIN:	MOV	[SI],OFFSET INT10	;SET UP VECTOR FOR INT 10
	MOV	2[SI],CS
	MOV	SI,5*4
	MOV	[SI],OFFSET INT5
	MOV	2[SI],CS		;INSTALL INT 5
	MOV	SI,11H*4
	MOV	[SI],OFFSET INT11
	MOV	2[SI],CS		;INSTALL INT 11
	MOV	SI,12H*4
	MOV	[SI],OFFSET INT12
	MOV	2[SI],CS		;INSTALL INT 12
	MOV	SI,13H*4
	MOV	[SI],OFFSET INT13
	MOV	2[SI],CS		;INSTALL INT 13
	MOV	SI,14H*4
	MOV	[SI],OFFSET INT14
	MOV	2[SI],CS		;INSTALL INT 14
	MOV	SI,16H*4
	MOV	[SI],OFFSET INT16
	MOV	2[SI],CS		;INSTALL INT 16
	MOV	SI,17H*4
	MOV	[SI],OFFSET INT17
	MOV	2[SI],CS		;INSTALL INT 17
	IF	LEVEL2 OR LEVEL3
	MOV	SI,1AH*4
	MOV	[SI],OFFSET INT1A
	MOV	2[SI],CS		;INSTALL INT 1A
	ENDIF
	MOV	SI,1BH*4
	MOV	[SI],OFFSET KBBRK
	MOV	2[SI],CS		;INSTALL KEYBOARD BREAK INTERRUPT
	IF	LEVEL2 OR LEVEL3
	MOV	SI,OFFSET 1EH*4
	MOV	[SI],OFFSET DPBLK
	MOV	2[SI],CS		;INSTALL DISK BLOCK POINTER
	ENDIF
	MOV	SI,90H*4
	MOV	[SI],OFFSET INT90
	MOV	2[SI],CS		;INSTALL INT 90
	MOV	SI,91H*4
	MOV	[SI],OFFSET INT91
	MOV	2[SI],CS		;INSTALL INT 91
	MOV	SI,KEYINT*4
	MOV	[SI],OFFSET INTRET
	MOV	2[SI],CS		;INSTALL KEYBOARD INT. RETURN
	MOV	SI,OFFSET HTIMINT*4
	MOV	[SI],OFFSET INTRET
	MOV	2[SI],CS		;INSTALL PC HDWE. TIMER INT. RETURN
	MOV	SI,OFFSET PTIMINT*4
	MOV	[SI],OFFSET INTRET
	MOV	2[SI],CS		;INSTALL PC SFWE. TIMER INT. RETURN
	MOV	SI,OFFSET ZJINT*4	;POINT TO "JIMINY" INT. VECTOR
	CMP	CS:BYTE PTR ETFLG,0	;ET-100?
	JZ	SJZ100			;NO
	MOV	SI,OFFSET ETJINT*4	;ELSE, USE ET-100 VECTOR
SJZ100:	MOV	WORD PTR [SI],OFFSET JKINT	;SET NEW VECTOR
	MOV	2[SI],CS
	CMP	SI,OFFSET ZJINT*4	;ET-100?
	JNZ	UMET			;YES
	IN	AL,MASTER+1		;READ MASTER PIC MASK
	AND	AL,0FFH-8		;UNMASK SLAVE PIC INPUT
	OUT	MASTER+1,AL
	IN	AL,SLAVE+1		;READ SLAVE PIC MASK
	AND	AL,7FH			;UNMASK VECTOR INTERRUPT 7
	OUT	SLAVE+1,AL
	JMP	SHORT ZUM
UMET:	IN	AL,MASTER+1		;READ MASTER PIC MASK
	AND	AL,0FFH-2		;UNMASK USER INTERRUPT
	OUT	MASTER+1,AL
ZUM:	MOV	SI,OFFSET CHRINT
	MOV	WORD PTR [SI],0		;CLEAR CHARACTER INTERRUPT
	MOV	WORD PTR 2[SI],0
	MOV	SI,OFFSET SYSINT
	LES	DI,DWORD PTR [SI]	;GET SYS INT. ADDRESS
	MOV	[SI],OFFSET MYSYS	;REPLACE IT WITH MY ADDR
	MOV	2[SI],CS		;AND THIS SEGMENT
	POP	DS			;RESTORE DS
	PUSH	DS
	MOV	WORD PTR SYSADR,DI	;PUT IN JUMP TO SYSTEM
	MOV	WORD PTR SYSADR+2,ES
	MOV	SI,6
	LES	DI,DWORD PTR [SI]	;GET "CALL 5" ADDRESS
	INC	DI			;POINT TO ADDRESS
	MOV	AX,OFFSET CALL5
	CLD
	STOSW				;MOVE IN NEW ONE
	MOV	AX,CS
	STOSW
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INT. PAGE AGAIN
	MOV	SI,OFFSET ZTIMINT	;POINT TO TIMER VECTOR
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	CLI
	MOV	[SI],OFFSET TIMER	;PUT IN NEW VECTOR
	MOV	2[SI],CS
	POP	DS			;RESTORE DS
	MOV	OLDTIME,DI		;PUT IN JUMP TO OLD TIMER
	MOV	OLDTIME+2,ES
	STI
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	SI,OFFSET ZKEYINT	;POINT TO Z-100 KEYBOARD INT. VECTOR
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	CLI
	MOV	[SI],OFFSET ZKEY	;PUT IN NEW VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	ZKEYADR,DI		;PUT IN JUMP TO OLD VECTOR
	MOV	ZKEYADR+2,ES
	STI
	PUSH	DS
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS PAGE
	MOV	SI,OFFSET BCONST+1
	MOV	AX,[SI]			;GET BCONST ADDRESS
	ADD	AX,6			;MAKE IT ABSOLUTE
	MOV	CS:CONSTV,AX		;SET UP CALL
	MOV	SI,OFFSET BCONIN+1
	MOV	AX,[SI]			;GET BCONIN ADDRESS
	ADD	AX,9			;MAKE IT ABSOLUTE
	MOV	CS:CONINV,AX		;SET UP CALL
	MOV	SI,OFFSET BLSTOUT+1
	MOV	AX,[SI]			;GET BLSTOUT ADDRESS
	ADD	AX,0FH			;MAKE IT ABSOLUTE
	MOV	CS:LSTOUTV,AX		;SET UP CALL
	MOV	SI,OFFSET BAUXIN+1
	MOV 	AX,[SI]			;GET BAUXIN ADDRESS
	ADD	AX,12H			;MAKE IT ABSOLUTE
	MOV	CS:AUXINV,AX		;SET UP CALL
	MOV	SI,OFFSET BAUXOUT+1
	MOV 	AX,[SI]			;GET BAUXOUT ADDRESS
	ADD	AX,15H			;MAKE IT ABSOLUTE
	MOV	CS:AUXOUTV,AX		;SET UP CALL
	MOV	SI,OFFSET BDSKFNC+1
	MOV	AX,[SI]			;GET BPRNFNC ADDRESS
	ADD	AX,4BH			;MAKE IT ABSOLUTE
	MOV	CS:DSKFNCV,AX		;SET UP CALL
	MOV	SI,OFFSET BPRNFNC+1
	MOV	AX,[SI]			;GET BPRNFNC ADDRESS
	ADD	AX,4EH			;MAKE IT ABSOLUTE
	MOV	CS:PRNFNCV,AX		;SET UP CALL
	MOV	SI,OFFSET BAUXFNC+1
	MOV	AX,[SI]			;GET BAUXFNC ADDRESS
	ADD	AX,51H			;MAKE IT ABSOLUTE
	MOV	CS:AUXFNCV,AX		;SET UP CALL
	IF	LEVEL1 OR LEVEL2
	POP	DS			;RESTORE DS
	ENDIF
	IF	LEVEL3
	PUSH	DS
	POP	ES			;PUT ES IN BIOS SEGMENT
	POP	DS			;RESTORE DS
	MOV	DI,4000H		;SET UP FOR SIZE CODE SEARCH
	MOV	CX,4000H		;SEARCH THIS MUCH
	MOV	AX,CODE1		;SEARCH FOR THIS
	MOV	BX,CODE2		;AND THIS
	MOV	DL,BYTE PTR CODE3	;AND THIS
SSRCH:	REPNZ	SCASW			;DO THE SEARCH
	JNZ	SHSRCH			;NOT FOUND, SHIFT SEARCH
	CMP	ES:WORD PTR [DI],BX	;IS THIS IT?
	JNZ	SSRCH			;NO
	CMP	ES:BYTE PTR 2[DI],DL	;CHECK LAST BYTE
	JNZ	SSRCH			;NO
	JMP	SHORT SCFND		;FOUND SIZE CODE
SHSRCH:	MOV	DI,4001H		;START SEARCH HERE, NOW
	MOV	CX,4000H
SSRCH1:	REPNZ	SCASW			;DO THE SEARCH
	JNZ	SCNFND			;CODE NOT FOUND
	CMP	ES:WORD PTR [DI],BX	;IS THIS IT?
	JNZ	SSRCH1			;NO
	CMP	ES:BYTE PTR 2[DI],DL	;CHECK LAST BYTE
	JNZ	SSRCH1			;NOT IT
SCFND:	DEC	DI			;BACK UP TO CODE START
	DEC	DI
	MOV	SIZCOD,DI		;SAVE THIS ADDRESS
	JMP	SHORT SIZGD
SCNFND:	MOV	DX,OFFSET SIZMSG
	MOV	AH,9
	INT	21H			;SAY "SIZE CODE NOT FOUND"
SIZGD:
	ENDIF
	IF	LEVEL2 OR LEVEL3
	MOV	DI,0
	MOV	CX,2000H
	MOV	AL,0F6H			;PREPARE TO SEARCH FOR DIV CL
SDIVLP:	REPNZ	SCASB			;SEARCH FOR IT
	JNZ	DIVNF			;NOT FOUND
	CMP	ES:BYTE PTR [DI],0F1H	;IS THIS IT?
	JNZ	SDIVLP
	CMP	ES:WORD PTR 1[DI],0C4FEH
	JNZ	SDIVLP
	DEC	DI			;BACK UP TO CODE
	MOV	DIVCL,DI		;SAVE ADDRESS OF IT
	JMP	SHORT DIVFND
DIVNF:	MOV	DX,OFFSET DSKMSG
	MOV	AH,9
	INT	21H			;SAY "DISK CODE NOT FOUND"
DIVFND:
	ENDIF
	MOV	AX,OFFSET BA		;GET BUFFER AREA ADDRESS
	MOV	CL,4
	SHR	AX,CL			;CONVERT TO PARAGRAPH
	MOV	BX,CS			;GET THIS SEGMENT
	ADD	BX,AX			;CALCULATE BUFFER SEGMENT
	MOV	VIDRAM,BX		;SAVE AS VIDEO RAM SEGMENT
	IF	LEVEL3
	MOV	PVIDRAM,BX		;ALSO AS PERMANENT VIDEO RAM
	ENDIF

	IF	LEVEL2 OR LEVEL3
;	TEST FOR 8087.  8087 INSTRUCTIONS ARE IN THE FORM OF
;	DB'S SO THAT THE ASSEMBLER WILL NOT PUT A WAIT BEFORE THEM.

	DB	0DBH,0E3H		;INITIALIZE 8087	
	XOR	CX,CX			;CLEAR A COUNTER
	LOOP	$			;WAIT
	DB	0DDH,3EH		;STORE 8087 STATUS WORD
	DW	OFFSET MDATA		;STORE IT HERE
	LOOP	$			;WAIT
	MOV 	AX,MDATA		;GET STATUS WORD
	AND	AL,0FH
	OR	AL,AL			;TEST IT
	JNZ	NO8087			;NO 8087
	DB	0D9H,3EH		;STORE 8087 COMMAND WORD
	DW	OFFSET MDATA		;STORE IT HERE
	LOOP	$			;WAIT
	MOV 	AX,MDATA		;GET COMMAND WORD
	AND	AL,0FH
	CMP	AL,0FH			;TEST IT
	JNZ	NO8087			;NO 8087
	OR	X10H,10B		;FLAG 8087 PRESENT
NO8087:
	ENDIF
	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;SAY "ZPC INSTALLED"
	MOV	DX,OFFSET BA.ENDRES	;POINT TO END OF RES. CODE
	INT	27H			;LEAVE, CODE RESIDENT

ZPC	DB	0FFH,0FFH,0FFH,0F0H,01FH,0FFH,0FFH,0,0,07FH,0FFH,0E0H
	DB	0FFH,0FFH,0FFH,0F0H,01FH,0FFH,0FFH,0F0H,7,0FFH,0FFH,0FEH
	DB	0F0H,0,0FFH,0,1,0FEH,7,0F8H,0FH,0F0H,0,0FFH
	DB	0,0FH,0F0H,0,1,0FFH,0FFH,0F0H,0FH,0F0H,0,0
	DB	0,0FFH,0,0,1,0FFH,0FFH,0,0FH,0F0H,0,0
	DB	0FH,0F0H,0,0F0H,1,0FEH,0,0,0FH,0F0H,0,0FFH
	DB	0FFH,0FFH,0FFH,0F0H,01FH,0FFH,0E0H,0,7,0FFH,0FFH,0FEH
	DB	0FFH,0FFH,0FFH,0F0H,01FH,0FFH,0E0H,0,0,03FH,0FFH,0E0H

TSTMSG	DB	13,27,'Z',13,'  $'	;Z-100 TEST MSG
	IF	LEVEL2 OR LEVEL3
VERMSG	DB	7,13,'Wrong version of MS-DOS for this level.',13,10,'$'
	ENDIF
	IF	LEVEL3
NEMMSG	DB	7,13,'Not enough memory for ZPC3.',13,10,'$'
SIZMSG	DB	7,8,8,'Memory size code not found.'
	DB	27,'Y.=$'
	ENDIF
	IF	LEVEL2 OR LEVEL3
DSKMSG	DB	7,8,'BIOS disk code not found.'
	DB	27,'Y.=$'
MDATA	DW	0			;DATA AREA FOR 8087 TEST
	ENDIF
INMSG	DB	7,13,'ZPC is already installed.',13,10,'$'
INSMSG	DB	'ZPC is now installed.',13,10,'$'

IBMFLG	DB	0			;IBM MODE FLAG

CODE	ENDS
	END	START
