	PAGE	,132
;	Z-100 PC EMULATOR CONTROL PROGRAM
;
;	TO RUN THIS PROGRAM, ENTER
;
;	PC		TO TURN ON PC DEFAULT MODE
;
;	PC n		TO TURN ON PC WITH SPECIFIED MODE
;
;	BY P. SWAYNE, HUG  13-JUL-85  13-FEB-86
;
;	COPYRIGHT (C) 1985, 1986 BY HEATH/ZENITH USERS' GROUP

FCB	EQU	5CH			;DEFAULT FCB

DUMMY	SEGMENT	STACK
DUMMY	ENDS
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	AX,0C00H
	INT	21H			;CLEAR CONSOLE BUFFER
	MOV	SI,OFFSET FCB+1		;POINT TO FCB
	MOV	DI,0FFH			;SET NO MODE CONDITION
	CLD
	LODSB				;GET FIRST CHARACTER
	CMP	AL,'?'
	JZ	EXPL			;USER WANTS HELP
	CMP	AL,' '			;SPACE?
	JZ	SETMODE			;ENTER PC EMULATION
	SUB	AL,'0'			;REMOVE ASCII BIAS
	JC	EXPL			;BAD ENTRY, EXPLAIN
	CMP	AL,8			;ALLOW MODES 0-7
	JNC	EXPL
	XOR	AH,AH
	MOV	DI,AX			;SAVE MODE IN DI
SETMODE:MOV	DX,OFFSET TSTMSG
	MOV	AH,9
	INT	21H			;SEND TEST MESSAGE
	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			;GOT A RESPONSE?
	JZ	PCMODE			;IF NOT, WE'RE IN THE PC MODE
	MOV	AX,0C00H
	INT	21H			;ELSE, CLEAR CONSOLE BUFFER
	MOV	AX,101
	INT	10H			;TURN ON PC MODE
	CMP	DI,0FFH			;DEFAULT MODE?
	JNZ	PCMODE			;NO, SET IT
	INT	20H
PCMODE:	CMP	DI,0FFH			;MODE NOT SPECIFIED?
	JZ	SHOMODE			;IF SO, SHOW CURRENT MODE
	MOV	AX,DI			;GET USER'S MODE
	CMP	AX,2			;MODE 2?
	JNZ	NOTM2			;NO
	MOV	AX,3			;ELSE, SET MODE 3 FIRST
	INT	10H
	MOV	AX,2			;THEN, MODE 2
NOTM2:	INT	10H			;SET IT
	PUSH	CS
	POP	DS			;PUT DS HERE
	INT	20H			;EXIT
EXPL:	MOV	DX,OFFSET EXPMSG
	MOV	AH,9
	INT	21H			;PRINT EXPLAINATION
	INT	20H
SHOMODE:MOV	DX,OFFSET CURMODE
	MOV	AH,9
	INT	21H			;PRINT "CURRENT MODE IS"
	MOV	AH,15
	INT	10H			;GET CURRENT VIDEO MODE
	PUSH	AX			;SAVE IT
	ADD	AL,'0'			;MAKE IT ASCII
	MOV	DL,AL
	MOV	AH,2
	INT	21H			;PRINT CURRENT MODE
	POP	AX
	CBW				;CONVERT MODE TO WORD
	MOV	CL,MODSIZ
	MUL	CL			;MULTIPLY BY SIZE OF MODE TABLE
	MOV	DX,OFFSET MODES
	ADD	DX,AX			;POINT TO MODE DESCRIPTION
	MOV	AH,9
	INT	21H			;PRINT MODE DESCRIPTION
	INT	20H

TSTMSG	DB	13,27,'Z',13,'  $'

EXPMSG	DB	13,10,'Z-100 PC Emulator Mode Setting Program'
	DB	13,10,10
	DB	'To use this program, enter',13,10,10
	DB	'  PC		To enter PC emulation'
	DB	13,10
	DB	'		or show video mode'
	DB	13,10,10
	DB	'  PC n		To set video mode n',13,10,10
	DB	'Modes 0 - 7 are allowed.',13,10,'$'
CURMODE	DB	13,10,'Video mode $'

MODES	DB	' -- 40 column b&w.  $'
MODES1	DB	' -- 40 column color.$'
	DB	' -- 80 column b&w.  $'
	DB	' -- 80 column color.$'
	DB	' -- Med. res. color.$'
	DB	' -- Med. res. b&w.  $'
	DB	' -- Hi. res. b&w.   $'
	DB	' -- Monochrome card.$'
MODSIZ	EQU	MODES1-MODES

CODE	ENDS
	END	START
