	PAGE	,132
	TITLE	PRINT UTILITY FOR MS-DOS 2
;	THIS PROGRAM PRINTS FILES VIA THE STANDARD PRINTER
;	OUTPUT, SO THAT THE HUG SPOOLER WILL BE USED.
;
;	BY P. SWAYNE, HUG  04-APR-85

PR	SEGMENT
	ASSUME	CS:PR,DS:PR,ES:PR,SS:PR
	ORG	6
MEMTOP	LABEL	WORD		;MEMORY TOP
	ORG	5CH
FCB	LABEL	BYTE		;DEFAULT FCB
	ORG	100H

START:	MOV	SI,OFFSET 80H	;POINT TO CMD BUFFER
	CLD
	LODSB			;GET CHAR COUNT
	OR	AL,AL		;ANY ARGUMENT?
	JZ	ERROR		;NO
	PUSH	AX
	MOV	AH,30H
	INT	21H		;GET DOS VERSION
	CMP	AL,2		;VERSION 2?
	POP	AX
	JC	PRJR		;NO, USE JUNIOR PRINT
	MOV	DI,SI
	XOR	AH,AH
	ADD	SI,AX
	MOV	BYTE PTR [SI],0	;TERMINATE ENTRY
	MOV	CX,AX		;COUNT TO CX
	MOV	AL,' '
	CLD
	REPZ	SCASB		;LOOK FOR NON-SPACE
	DEC	DI		;POINT TO IT
	MOV	DX,DI
	MOV	AX,3D00H
	MOV	CX,0
	INT	21H		;OPEN THE FILE
	MOV	BX,AX		;HANDLE NUMBER TO BX
	JNC	READLP		;OPEN OK
ERROR:	MOV	DX,OFFSET ERRMSG
	MOV	AH,9
	INT	21H		;SAY "ERROR"
	INT	20H
READLP:	MOV	SI,0 		;CLEAR EOF FLAG
	MOV	CX,MEMTOP	;GET MEMORY TOP
	MOV	AX,OFFSET BUFFER
	SUB	CX,AX		;GET BUFFER SIZE
	MOV	DX,OFFSET BUFFER ;PUT FILE HERE
	PUSH	CX		;SAVE COUNT
	MOV	AH,3FH		;READ THE FILE
	INT	21H
	POP	CX
	JC	ERROR		;BAD READ
	CMP	CX,AX		;BUFFER FILLED?
	JZ	READDN		;YES
	MOV	SI,1 		;ELSE, MARK END OF FILE
	MOV	CX,AX		;CX = BYTES READ
READDN:	OR	CX,CX		;NULL FILE?
	JZ	PRDN
	MOV	DX,OFFSET BUFFER
	PUSH	BX		;SAVE HANDLE
	MOV	BX,4		;USE STD PRN
	MOV	AH,40H		;WRITE TO PRINTER
	INT	21H
	POP	BX
	JC	ERROR
	CMP	SI,0		;END OF FILE?
	JZ	READLP		;IF NOT, LOOP
PRDN:	MOV	AH,3EH		;ELSE, CLOSE FILE
	INT	21H
	INT	20H		;EXIT

PRJR:	MOV	DX,OFFSET FCB
	MOV	AH,0FH
	INT	21H			; OPEN FILE
	INC	AL			; SET FLAGS ON RESULT
	JNZ	OPOK			; OPEN OK
	MOV	DX,OFFSET ERRMSG
	MOV	AH,9
	INT	21H
	INT	20H
OPOK:	MOV	WORD PTR FCB+14,1	; SET RECORD SIZE TO 1 BYTE
	MOV	DI,OFFSET FCB+32
	MOV	CX,6
	XOR	AL,AL
	CLD
	REP	STOSB			; CLEAR FCB RECORDS
DOPRT1:	MOV	DX,OFFSET BUFFER
	MOV	AH,1AH
	INT	21H			; SET DTA TO READ BUFFER
	MOV	DX,OFFSET FCB
	MOV	CX,MEMTOP
	SUB	CX,(OFFSET BUFFER)+100H	; GET BUFFER SIZE
	MOV	AH,27H
	INT	21H			; READ FILE
	MOV	FCB-1,AL		; SAVE RESULT
	OR	CX,CX
	JZ	DOPRTX
	MOV	SI,OFFSET BUFFER
	CLD
PRTLP:	LODSB				; GET A CHARACTER
	CMP	AL,1AH			; EOF?
	JZ	DOPRTX			; IF SO, EXIT
	MOV	DL,AL
	MOV	AH,5
	INT	21H			; PRINT CHARACTER
	LOOP	PRTLP
	CMP	FCB-1,0			; END?
	JZ	DOPRT1			; IF NOT, LOOP
DOPRTX:	INT	20H

ERRMSG	DB	13,10,'No file, or file error.$'
BUFFER	LABEL	BYTE		;BUFFER STARTS HERE
PR	ENDS
	END	START
                                      