	PAGE	,132
M	EQU	BYTE PTR 0[BX]
;	WSCON
;
;	THIS PROGRAM CONVERTS ASCII TEXT FILES
;	TO THE FORMAT USED BY WORDSTAR FOR
;	DOCUMENT FILES
;
;	REPLACES CR'S WITH PHANTOM CR'S EXCEPT
;	AT PARAGRAPH BREAKS SEPARATED WITH AT
;	LEAST ONE BLANK LINE.  REPLACES MULTIPLE
;	SPACES WITH PHANTOM SPACES EXCEPT FOR THE
;	FIRST SPACE.  TWO SPACES ARE ALLOWED
;	AFTER A PERIOD.

;
;	BY P. SWAYNE, HUG  3-FEB-82
;	MS-DOS VERSION  23-APR-85
;
	
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5
MDOS	LABEL	NEAR
	ORG	5CH
FCB	LABEL	BYTE			;DEFAULT FCB LOCATION
	ORG	80H
DTA	LABEL	NEAR
	ORG	100H

;	CONSTANTS

CONIN	EQU	1			;BDOS CONSOLE INPUT
CONOUT	EQU	2			;OUTPUT
PRINT	EQU	9			;PRINT FUNCTION
READ	EQU	10			;READ CONSOLE BUFFER
OPEN	EQU	15			;OPEN FILE
CLOSE	EQU	16			;CLOSE FILE
DELETE	EQU	19			;DELETE FILE
DREAD	EQU	27H			;DISK READ
DWRITE	EQU	28H			;DISK WRITE
MAKE	EQU	22			;MAKE FILE
SETDMA	EQU	26			;SET DMA ADDR
FLAGS	EQU	30			;SET FILE ATTRIBUTES
BDOS	EQU	5			;CALL BDOS HERE

;	MAIN PROGRAM

WSCON:	MOV	SP,OFFSET (STACK)	;SET NEW STACK
	MOV	BX,WORD PTR MDOS+1	;GET BDOS ADDRESS
	MOV	WORD PTR MEMTOP,BX	;STORE AS MEMORY TOP
	MOV	AL,BYTE PTR DTA
	OR	AL,AL			;ANY FILE ENTERED?
	JNZ	GOTFIL			;YES
	MOV	DX,OFFSET (NOFILE)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "NO FILE"
	INT	20H
GOTFIL:	MOV	SI,OFFSET (FCB)
	MOV	DI,OFFSET (FCB2)	;PREPARE SECOND FCB
	MOV	CX,9			;MOVE 9 CHARACTERS
	CLD
	REP	MOVSB			;MOVE FILE NAME TO FCB2
	MOV	DX,OFFSET (FCB)
	MOV	CL,OPEN
	CALL	MDOS			;TRY TO OPEN SOURCE FILE
	INC	AL
	JNZ	OPENED			;OPENED OK
	MOV	DX,OFFSET (NOOPEN)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "CAN'T OPEN"
	INT	20H
OPENED:	MOV	WORD PTR FCB+14,1	;SET RECORD SIZE TO 1
	MOV	DI,(OFFSET FCB)+32
	XOR	AL,AL
	MOV	CX,6
	CLD
	REP	STOSB			;CLEAR RECORD BYTES
	MOV	DX,OFFSET (FCB2)
	MOV	CL,DELETE
	CALL	MDOS			;DELETE OLD OUTPUT IF THERE
	MOV	DX,OFFSET (FCB2)
	MOV	CL,MAKE
	CALL	MDOS			;OPEN OUTPUT FILE
	OR	AL,AL
	JZ	SETREC
	JMP	WRTER			;WRITE ERROR
SETREC:	MOV	WORD PTR FCB2+14,1	;SET RECORD SIZE TO 1
	MOV	DX,OFFSET (WORKING)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "WORKING"
LOOP:	MOV	DX,OFFSET BUFFER
	MOV	CL,SETDMA
	CALL	MDOS			;SET DMA ADDRESS
RLOOP:	MOV	CX,WORD PTR MEMTOP	;GET TOP OF MEMORY
	MOV	AX,OFFSET BUFFER
	SUB	CX,AX			;GET SIZE OF BUFFER
	MOV	DX,OFFSET FCB
	MOV	AH,DREAD
	INT	21H			;READ FROM FILE
	MOV	BYTE PTR EOFFLG,AL	;SAVE RESULT OF READ
	MOV	BX,OFFSET BUFFER
	ADD	BX,CX			;MOVE TO FILE END
	MOV	M,1AH			;MARK IT
	MOV	WORD PTR SECCNT,CX	;SAVE COUNT OF BYTES READ
	MOV	BX,OFFSET (BUFFER)	;FILE IS HERE
CONLP:	MOV	AL,M			;GET A CHARACTER
	CMP	AL,1AH			;DONE?
	JZ	DONE			;IF SO, EXIT
	CMP	AL,0DH			;CR?
	JNZ	NOTCR			;IF NOT, KEEP LOOKING
	PUSH	BX			;SAVE POINTER
	INC	BX
	INC	BX			;MOVE OVER TWO CHARACTERS
	MOV	CH,M			;GET CHARACTER
	POP	BX			;RESTORE POINTER
	CMP	AL,CH			;TWO CR'S?
	JNZ	FIXCR			;NO, FIX CR
	INC	BX
	INC	BX			;LEAVE TWO CR'S ALONE
	JMP	SHORT NOTSP		;TRY ANOTHER CHARACTER
FIXCR:	MOV	M,8DH			;REPLACE CR WITH CR + 80H
	JMP	SHORT NOTSP		;CHECK NEXT CHARACTER
NOTCR:	CMP	AL,' '			;SPACE
	JNZ	NOTSP			;NO
	PUSH	BX			;SAVE POINTER
	DEC	BX			;CHECK LAST CHARACTER
	MOV	AL,M
	CMP	AL,'.'			;PERIOD?
	POP	BX			;RESTORE POINTER
	JZ	NOTSP			;ALLOW TWO SPACES AFTER PERIOD
	PUSH	BX			;SAVE POINTER
SPCON:	INC	BX			;MOVE TO NEXT CHARACTER
	MOV	AL,M			;GET IT
	CMP	AL,' '			;ANOTHER SPACE?
	JNZ	SPDONE			;NO, DONE
	MOV	M,' '+80H		;REPLACE SPACE WITH SPACE + 80H
	JMP	SHORT SPCON		;TRY NEXT CHARACTER
SPDONE:	POP	BX			;RESTORE POINTER
NOTSP:	INC	BX			;MOVE TO NEXT CHARACTER
	JMP	SHORT CONLP		;CHECK IT
DONE:	MOV	CX,WORD PTR SECCNT	;GET SECTOR COUNT
	MOV	AH,DWRITE
	MOV	DX,OFFSET (FCB2)
	INT	21H			;WRITE BUFFER
	OR	AL,AL			;GOOD WRITE
	JZ	GOODW			;YES
WRTER:	MOV	DX,OFFSET (WRERR)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "WRITE ERROR"
	INT	20H			;EXIT
GOODW:	MOV	AL,BYTE PTR EOFFLG	;END OF FILE?
	OR	AL,AL
	JNZ	SHORT L_1		;IF NOT, LOOP
	JMP	LOOP
L_1:
	MOV	DX,OFFSET (FCB)
	MOV	CL,CLOSE
	CALL	MDOS			;CLOSE INPUT FILE
	MOV	DX,OFFSET (FCB2)
	MOV	CL,CLOSE
	CALL	MDOS			;CLOSE OUTPUT FILE
	MOV	DX,OFFSET (DIDIT)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "DONE"
	INT	20H			;RETURN TO CP/M

;	MESSAGES

NOFILE	DB	0DH,0AH,'THE CORRECT USE OF THIS PROGRAM IS'
	DB	0DH,0AH,0DH,0AH
	DB	'd>WSCON d:FILENAME.TYP',0DH,0AH,0DH,0AH
	DB	'WHERE d IS A DRIVE NAME (A - F), AND',0DH,0AH
	DB	'FILENAME.TYP IS THE FILE TO BE CONVERTED',0DH,0AH,'$'
NOOPEN	DB	0DH,0AH,"CAN'T OPEN SOURCE FILE",0DH,0AH,'$'
WORKING	DB	0DH,0AH,'WORKING...',0DH,0AH,'$'
WRERR:	DB	0DH,0AH,'WRITE ERROR',0DH,0AH,'$'
DIDIT:	DB	0DH,0AH,'CONVERSION COMPLETE.',0DH,0AH,'$'

;	STORAGE

CURDMA	DW	OFFSET (BUFFER)		;DMA ADDRESS
MEMTOP	DW	OFFSET (0)		;MEMORY TOP
SECCNT	DW	OFFSET (0)		;SECTOR COUNT
EOFFLG	DB	0			;END OF FILE FLAG
FCB2	DB	0,'        WS ',0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0
STACK	EQU	$+100H
BUFFER	EQU	STACK

	
CODE	ENDS
	END	WSCON
                                                                                                                             