	title	HUG File Manager
	page	,132
;
;	HUG File Manager for MS-DOS 1.25
;
;			Z-100/Z-150 version
;
;	BY P. SWAYNE, HUG  27-MAR-85  03-APR-85
;	MADE FROM THE ORIGINAL HUG FILE MANAGER BY
;		R. A. METZ AND P. SWAYNE
;
;	This program operates in a manner similar to the Microsoft
;	Multiplan spreadsheet program in that a command line is
;	displayed at the bottom of the screen.  Operation of that 
;	command line parallels that of Multiplan's command 
;	line.  The main screen area is used for directory
;	display and display of requested file data.
;
;	Commands currently implemented are:
;
;	Copy	Copy selected file.  The user is prompted to
;		enter the name of the destination file/device.
;		COMMAND.COM is used to execute its 'COPY' command.
;	Erase	Erase file.  The user is asked for confirmation
;		before actually erasing the selected file.
;	Flag	Mark file with a flag.  If Copy or Delete are then
;		used, the marked files will be acted upon, instead
;		of the highlighted file.
;	Help	Use of this utility is explained.
;	Listhex	The selected file is displayed in Hex and ASCII.
;	Moredir	If there are more files than fit on the screen, this
;		command will show the next screen.  If used while the
;		last screen of files are showing, the first files are
;		re-displayed.
;	Newdisk	The user is prompted for a disk id to become the
;		new default.
;	Print	The selected file is sent to the printer.
;	Quit	Quit this program.
;	Rename	Rename file.  The user is prompted for a new
;		file name and the selected file is renamed.
;	Sort	The directory is sorted alphabetically and displayed
;		in that form.  This is the normal condition at startup.
;	Type	The selected file is displayed on the screen.
;	Unsort	The directory is unsorted and the files are displayed
;		in their natural order.
;	Wildcrd.Wildcard Specification.  The user is prompted for a
;		wildcard specification that determines which files
;		are shown on the screen.
;
	page
HICODE	EQU	0FH			; HIGHLIGHTING CODE WHEN USED ON
;					; A Z-150.  USE 0FH FOR INTENSE WHITE,
;					; OR 70H FOR REVERSE VIDEO.
HFMJR	SEGMENT
	ASSUME	CS:HFMJR,DS:HFMJR,ES:HFMJR,SS:HFMJR
	ORG	6
MEMTOP	LABEL	WORD
	ORG	5CH
FCB1	LABEL	NEAR
	ORG	6CH
FCB2	LABEL	NEAR
	ORG	80H
BUF	LABEL	NEAR
	ORG	100H
START:	MOV	SP,OFFSET BA.STACK
	PUSH	AX
	JMP	BEGIN
;
VERSION	DB	0			; DOS VERSION
CUR_CMD	DW	3
CUR_ENT	DW	0
MAX_ENT	DW	0
FILECNT	DW	0			; FILE COUNT
PAGECNT	DW	0			; PAGE FILE COUNT
CURTYPE	DW	0			; CURSOR TYPE (Z-150)
DISTYPE	DB	0			; DISPLAY TYPE (Z-150)
TTYPE	DB	1			; TERMINAL TYPE (Z-100 OR Z-150)
MOREFLG	DB	0			; MORE FILES FLAG
VARI	DW	0			; SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
SORTFLG	DB	1			; SORT FLAG
FLAGCNT	DB	0			; COUNT OF FILES FLAGGED
FLG2FLG	DB	0			; FILES FLAGGED INDICATOR
TFCNT	DW	0			; TEMP. FILE COUNT
CUR_ADR	DW	0			; CURRENT FILE ADDRESS
FREE_L	DW	0			; DISK FREE SPACE LOW
FREE_H	DW	0			; DISK FREE SPACE HIGH
FLAG_L	DW	0			; FLAGGED FILE BYTES LOW
FLAG_H	DW	0			; FLAGGED FILE BYTES HIGH
LINECNT	DB	0			; LINE COUNT FOR TYPE
EOFFLG	DB	0			; ENF OF FILE FLAG
DATSAVE	DW	0			; SAVED FILE DATE
TIMSAVE	DW	0			; SAVED FILE TIME
CURDSK	DB	'A'
OLDDSK	DB	0
;
CMD_LINE_TBL:
	DW	OFFSET CCMD
	DW 	OFFSET ECMD
	DW	OFFSET FCMD
	DW	OFFSET HCMD
	DW	OFFSET LCMD
	DW	OFFSET MCMD
	DW	OFFSET NCMD
	DW	OFFSET PCMD
	DW	OFFSET QCMD
	DW	OFFSET RCMD
	DW	OFFSET SCMD
	DW	OFFSET TCMD
	DW	OFFSET UCMD
	DW	OFFSET WCMD
;
NCMDS	EQU	14
MAX_CMD	EQU	13
;
CCMD	DB	27,'Y',23+31,10+31
	DB	'Copy$'
ECMD	DB	27,'Y',23+31,15+31
	DB	'Erase$'
FCMD	DB	27,'Y',23+31,21+31
	DB	'Flag$'
HCMD	DB	27,'Y',23+31,26+31
	DB	'Help$'
LCMD	DB	27,'Y',23+31,31+31
	DB	'Listhex$'
MCMD	DB	27,'Y',23+31,39+31
	DB	'Morefiles$'
NCMD	DB	27,'Y',23+31,49+31
	DB	'Newdisk$'
PCMD	DB	27,'Y',23+31,57+31
	DB	'Print$'
QCMD	DB	27,'Y',23+31,63+31
	DB	'Quit$'
RCMD	DB	27,'Y',24+31,10+31
	DB	'Rename$'
SCMD	DB	27,'Y',24+31,17+31
	DB	'Sort$'
TCMD	DB	27,'Y',24+31,22+31
	DB	'Type$'
UCMD	DB	27,'Y',24+31,27+31
	DB	'Unsort$'
WCMD	DB	27,'Y',24+31,34+31
	DB	'Wildcard$'
;
;	messages
;
cr	EQU	0dh
lf	EQU	0ah
esc	EQU	1bh
;
IDMSG		DB	27,'Z',13,'  ',13,'$'	; VT-52 IDENTIFY
;
INIT_MSG	DB	27,'E'		; clear screen
		DB	27,'x1'	; enable 25th line
		DB	'$'
;
REV_MSG	DB	27,'p$'
NRM_MSG	DB	27,'q$'
;
FLG_MSG	DB	8,'*$'
;
XIT_MSG	DB	27,'Y',25+31,1+31
	DB	27,'K'
	DB	27,'Y',1+31,1+31
	DB	27,'E'
CUR_ON	DB	27,'y5'
	DB	'$'
;
INIT_PROMPT	DB	27,'Y',24+31,1+31
		DB	27,'K'
		DB	27,'Y',23+31,1+31
		DB	27,'K'
		DB	27,'y5'
		DB	'$'
;
MSG_PROMPT	DB	27,'Y',24+31,1+31
		DB	27,'K'
		DB	27,'Y',23+31,1+31
		DB	27,'K$'

INIT_CMD_LINE	DB	27,'Y',24+31,1+31
		DB	27,'K'
		DB	27,'Y',23+31,1+31
		DB	27,'K'
		DB	27,'x5'
		DB	'Command: '
		DB	'$'
;
DIR_HDR		DB	27,'Y',1+31,1+31
		DB	27,'pHUG File Manager Jr.',ESC,'q'
		DB	' Version 1.0'
		DB	27,'Y',3+31,1+31
		DB	'Contents of Drive $'

FSPC_MSG	DB	27,'Y',1+31,44+31
		DB	'Flagged file bytes:           '
		DB	27,'Y',1+31,64+31
		DB	'$'

FREE_MSG	DB	27,'Y',25+31,59+31
		DB	'Free space:           '
		DB	27,'Y',25+31,71+31
		DB	'$'

SIZ_MSG		DB	27,'Y',25+31,38+31
		DB	'File size:        '
		DB	27,'Y',25+31,49+31
		DB	'$'

MORE_DIR	DB	27,'Y',21+31,71+31
		DB	'MORE'
		DB	27,'Y',22+31,71+31
		DB	'FILES..$'
;
SEL_DISP	DB	27,'x1'
		DB	27,'Y',25+31,1+31
		DB	'Current selection:             '
		DB	27,'Y',25+31,20+31
		DB	'$'
;
NO_FIL_MSG	DB	27,'Y',6+31,1+31
		DB	'No files in directory!!$'
;
DEL_ERR_MSG	DB	'Sorry - cannot erase file $'
;
REN_ERR_MSG	DB	'File rename error!$'
;
READ_ERR_MSG	DB	7,'  Error - cannot read file.$'

WRIT_ERR_MSG	DB	7,'  Error - cannot write file.$'

FILE_ERR_MSG	DB	'Error - no file selected!$'
;
DEST_FILE_REQ	DB	'Enter destination file name: $'
;
FILE_EX		DB	7,'  File exists, delete? (Y/N) $'
;
CONFIRM_REQ	DB	'OK to erase current file? (Y/N) $'
;
CONFIRM_REQ1	DB	'OK to erase flagged file(s)? (Y/N) $'
;
ERASING		DB	27,'Y',24+31,1+31
		DB	'Erasing selected file(s)...$'
;
NEW_NAME_REQ	DB	'Enter new file name: $'
;
NEW_DISK_REQ	DB	'New default drive: $'
;
WILD_CARD_REQ	DB	'Enter wildcard specification: $'

COPYING		DB	'Copying...',13,10,'$'
;
CLR_SCREEN	DB	27,'Y',1+31,1+31
		DB	27,'E'		; erase all
		DB	27,'Y',25+31,1+31
		DB	27,'K'		; ERASE 25TH LINE
		DB	27,'Y',1+31,1+31
		DB	'$'
;
HLP_VCT		DW	CHLP
		DW	EHLP
		DW	FHLP
		DW	HHLP
		DW	LHLP
		DW	MHLP
		DW	NHLP
		DW	PHLP
		DW	QHLP
		DW	RHLP
		DW	SHLP
		DW	THLP
		DW	UHLP
		DW	WHLP
;
;	help message text
;
CHLP	DB 9,'Copy File',CR,LF,LF
 DB 9,'When  you  are prompted for a destination file name,  type  in  a',CR,LF
 DB 9,'normal  MS-DOS/Z-DOS destination (drive designation and/or  file-',CR,LF
 DB 9,'name).   The  selected file will then be copied to the  specified',CR,LF
 DB 9,'destination.  If any files have been Flagged, those files will be',CR,LF
 DB 9,'copied instead of the currently selected (high-lighted) file.',CR,LF,LF
 DB 9,'If  you  leave  off any of the three elements  of  a  destination',CR,LF
 DB 9,'(drive code,  file name, extension), that element from the source',CR,LF
 DB 9,'will be used.  The following table explains this.  The source for',CR,LF
 DB 9,'this example is NAME.EXT on drive A:',CR,LF,LF
 DB 9,'You type:      The result is:',CR,LF,LF
 DB 9,'B:             B:NAME.EXT',CR,LF
 DB 9,'B:FILE         B:FILE.EXT',CR,LF
 DB 9,'B:FILE.        B:FILE',CR,LF
 DB 9,'B:FILE.DOC     B:FILE.DOC',CR,LF
 DB 9,'FILE           A:FILE.EXT',CR,LF
 DB 9,'B:.DOC         B:NAME.DOC$'

EHLP	DB 9,'Erase File',CR,LF,LF
 DB 9,'You will be asked for  confirmation  to erase the selected (high-',CR,LF
 DB 9,'lighted) or Flagged file(s).  If you type Y, the selected file(s)',CR,LF
 DB 9,'will be erased.$'

FHLP	DB 9,'Flag File',CR,LF,LF
 DB 9,'The selected file is marked with a flag.  An asterisk (*) is dis-',CR,LF
 DB 9,'played on the screen before the file name to  indicate  that  the',CR,LF
 DB 9,'file has been flagged.   After you have used this command to mark',CR,LF
 DB 9,'file(s),  the Copy and Erase  commands will operate on the marked',CR,LF
 DB 9,'file(s) instead of the currently selected (highlighted) file.  If',CR,LF
 DB 9,'the selected file already has a flag set when you use  this  com-',CR,LF
 DB 9,'mand,  it will be removed.   The  file sizes of all flagged files',CR,LF
 DB 9,'are added together and displayed at the top of the screen.',CR,LF,LF
 DB 9,'To  remove the flags from all flagged files at once,  use the Un-',CR,LF
 DB 9,'sort command,  followed  by the Sort command if you want the dir-',CR,LF
 DB 9,'ectory sorted.$'

HHLP	DB 9,'HUG File Manager',CR,LF,LF
 DB 9,'The HUG File Manager supports the following operations: copy, re-',CR,LF
 DB 9,'name, erase, type (on the screen), list in hex, print, change the',CR,LF
 DB 9,'default disk,  sort or unsort the directory display,  and specify',CR,LF
 DB 9,'the displayed directory via wildcards.   HFM displays the default',CR,LF
 DB 9,'directory  from the default disk on the screen,  with one of  the',CR,LF
 DB 9,'entries  highlighted.   The indicator (highlighted entry) may  be',CR,LF
 DB 9,'moved using the four arrow keys on the keyboard.   If the indica-',CR,LF
 DB 9,'tor  is  at the last entry in a column,  the down arrow key  will',CR,LF
 DB 9,'move  it to the top of the next column.   If the indicator is  at',CR,LF
 DB 9,'the  last entry on the page,  the down arrow will move it to  the',CR,LF
 DB 9,'first  entry.   The up arrow key works similarly.   The HOME  key',CR,LF
 DB 9,'moves the indicator directly to the first entry.',CR,LF,LF
 DB 9,'Near the bottom of the screen is a command line containing a list',CR,LF
 DB 9,'of  available  commands, with one of them highlighted.  A command',CR,LF
 DB 9,'may selected by typing the first character of the command, or  by',CR,LF
 DB 9,'moving  the highlighted command with the SPACE, TAB, or BACKSPACE',CR,LF
 DB 9,'keys and selecting it with the RETURN or  ENTER  key.    Specific',CR,LF
 DB 9,'information  about  each  command may be obtained by pressing the',CR,LF
 DB 9,'HELP key (Z-100) or F1  key  (Z-150)  with  the  desired  command',CR,LF
 DB 9,'highlighted.$'

LHLP	DB 9,'List File in Hex',CR,LF,LF
 DB 9,'The file you have selected is displayed on  the  screen  in  both',CR,LF
 DB 9,'hexadecimal (hex) and ASCII, with 16 bytes per line.  The listing',CR,LF
 DB 9,'will  pause  every 16 lines (256 bytes).   Type Control-C to exit',CR,LF
 DB 9,'before the end is reached, or any other key to continue.$'

MHLP	DB 9,'More Files',CR,LF,LF
 DB 9,'If  there  are more files in a directory than can be displayed on',CR,LF
 DB 9,'the screen,  the words MORE FILES will appear in the lower  right',CR,LF
 DB 9,'corner.   This command can then be used to display the additional',CR,LF
 DB 9,'files.   If you use this command when the screen shows the end of',CR,LF
 DB 9,'the directory, the beginning will be re-displayed.',CR,LF,LF
 DB 9,'If all the files can be displayed at once,  this  command  is not',CR,LF
 DB 9,'active.$'

NHLP	DB 9,'New Disk/Directory',CR,LF,LF
 DB 9,'You will be prompted to enter a letter (A-P) to designate the new',CR,LF
 DB 9,'default  drive.    You  can specify the current drive by pressing',CR,LF
 DB 9,'RETURN.$'

PHLP	DB 9,'Print File',CR,LF,LF
 DB 9,'The currently selected file is copied to your printer.$'

QHLP	DB 9,'Quit File Manager',CR,LF,LF
 DB 9,'The HUG File Manager returns control to the operating system.$'

RHLP	DB 9,'Rename File',CR,LF,LF
 DB 9,'You will be prompted for a new name for the selected file.    The',CR,LF
 DB 9,'file will then be renamed.$'

SHLP	DB 9,'Sort Directory',CR,LF,LF
 DB 9,'The directory is sorted alphabetically and displayed in that form',CR,LF
 DB 9,'on the screen.   This is the normal condition when the program is',CR,LF
 DB 9,'started.$'

THLP	DB 9,'Type File',CR,LF,LF
 DB 9,'The contents of the text file you have selected are displayed  on',CR,LF
 DB 9,'the screen.  The display will pause each time 23 lines have  been',CR,LF
 DB 9,'printed.   Type  Control-C  to exit before the file has been com-',CR,LF
 DB 9,'pletely printed, or any other key to continue.$'

UHLP	DB 9,'Unsort/Unflag Directory',CR,LF,LF
 DB 9,'The directory is unsorted and the file names are displayed on the',CR,LF
 DB 9,'screen  in  the  order  in  which  they  are  stored  in the disk',CR,LF
 DB 9,'directory.   Any  flags  that  were placed on files with the Flag',CR,LF
 DB 9,'command are removed.$'

WHLP	DB 9,'Wildcard Specification',CR,LF,LF
 DB 9,'You will be prompted for a wild card specification that will  de-',CR,LF
 DB 9,'termine  which  files from the current directory are shown on the',CR,LF
 DB 9,'screen.   For example,  if  you  want to see only files ending in',CR,LF
 DB 9,'.ASM, you can enter *.ASM as the wildcard specification.  To show',CR,LF
 DB 9,'show all files in the current directory again,  use  this command',CR,LF
 DB 9,'and enter *.* as the specification.  Note:  The wildcard specifi-',CR,LF
 DB 9,'cation  is  cleared to show all files when the Newdisk command is',CR,LF
 DB 9,'used.$'

.list
;
WAITKEY	DB	27,'Y',25+31,1+31
	DB	27,'K'
	DB	'Type any character to return to directory menu..$'
WAITKEY1:
	DB	27,'Y',25+31,1+31
	DB	27,'K',7
WAITKEY2:
	DB	'Type any character..$'

CRLF	DB	13,10,'$'
;
TOMSG	DB	' to $'
BEGLIN	DB	':  $'
SEPMSG	DB	'  ',27,'F`',27,'G$'

WILDCARD	DB	0,'???????????',0,0,0,0
	DB	20 DUP (0)
;
DIR_ENT_ADDR:
	DB	27,'Y',5+31,2+31
	DB	27,'Y',6+31,2+31
	DB	27,'Y',7+31,2+31
	DB	27,'Y',8+31,2+31
	DB	27,'Y',9+31,2+31
	DB	27,'Y',10+31,2+31
	DB	27,'Y',11+31,2+31
	DB	27,'Y',12+31,2+31
	DB	27,'Y',13+31,2+31
	DB	27,'Y',14+31,2+31
	DB	27,'Y',15+31,2+31
	DB	27,'Y',16+31,2+31
	DB	27,'Y',17+31,2+31
	DB	27,'Y',18+31,2+31
	DB	27,'Y',19+31,2+31
	DB	27,'Y',20+31,2+31
	DB	27,'Y',21+31,2+31
	DB	27,'Y',5+31,16+31
	DB	27,'Y',6+31,16+31
	DB	27,'Y',7+31,16+31
	DB	27,'Y',8+31,16+31
	DB	27,'Y',9+31,16+31
	DB	27,'Y',10+31,16+31
	DB	27,'Y',11+31,16+31
	DB	27,'Y',12+31,16+31
	DB	27,'Y',13+31,16+31
	DB	27,'Y',14+31,16+31
	DB	27,'Y',15+31,16+31
	DB	27,'Y',16+31,16+31
	DB	27,'Y',17+31,16+31
	DB	27,'Y',18+31,16+31
	DB	27,'Y',19+31,16+31
	DB	27,'Y',20+31,16+31
	DB	27,'Y',21+31,16+31
	DB	27,'Y',5+31,30+31
	DB	27,'Y',6+31,30+31
	DB	27,'Y',7+31,30+31
	DB	27,'Y',8+31,30+31
	DB	27,'Y',9+31,30+31
	DB	27,'Y',10+31,30+31
	DB	27,'Y',11+31,30+31
	DB	27,'Y',12+31,30+31
	DB	27,'Y',13+31,30+31
	DB	27,'Y',14+31,30+31
	DB	27,'Y',15+31,30+31
	DB	27,'Y',16+31,30+31
	DB	27,'Y',17+31,30+31
	DB	27,'Y',18+31,30+31
	DB	27,'Y',19+31,30+31
	DB	27,'Y',20+31,30+31
	DB	27,'Y',21+31,30+31
	DB	27,'Y',5+31,44+31
	DB	27,'Y',6+31,44+31
	DB	27,'Y',7+31,44+31
	DB	27,'Y',8+31,44+31
	DB	27,'Y',9+31,44+31
	DB	27,'Y',10+31,44+31
	DB	27,'Y',11+31,44+31
	DB	27,'Y',12+31,44+31
	DB	27,'Y',13+31,44+31
	DB	27,'Y',14+31,44+31
	DB	27,'Y',15+31,44+31
	DB	27,'Y',16+31,44+31
	DB	27,'Y',17+31,44+31
	DB	27,'Y',18+31,44+31
	DB	27,'Y',19+31,44+31
	DB	27,'Y',20+31,44+31
	DB	27,'Y',21+31,44+31
	DB	27,'Y',5+31,58+31
	DB	27,'Y',6+31,58+31
	DB	27,'Y',7+31,58+31
	DB	27,'Y',8+31,58+31
	DB	27,'Y',9+31,58+31
	DB	27,'Y',10+31,58+31
	DB	27,'Y',11+31,58+31
	DB	27,'Y',12+31,58+31
	DB	27,'Y',13+31,58+31
	DB	27,'Y',14+31,58+31
	DB	27,'Y',15+31,58+31
	DB	27,'Y',16+31,58+31
	DB	27,'Y',17+31,58+31
	DB	27,'Y',18+31,58+31
	DB	27,'Y',19+31,58+31
	DB	27,'Y',20+31,58+31
	DB	27,'Y',21+31,58+31
.list

;	MAIN PROGRAM

;	PERFORM SETUP CHORES

BEGIN:	MOV	AH,30H
	INT	21H			; get DOS version
	MOV	BYTE PTR VERSION,AL	; SAVE VERSION NO.
	MOV	AX,0C00H
	INT	21H			; CLEAR TYPE-AHEAD
	MOV	DX,OFFSET IDMSG		; ASK TERMINAL TYPE
	MOV	AH,9
	INT	21H
	MOV	CX,50			; SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			; TEST FOR REPLY
	OR	AL,AL
	JNZ	GOTCHR			; GOT REPLY
	LOOP	WFCHR			; ELSE, TRY AGAIN
	PUSH	CX
	MOV	AX,100*256
	INT	10H			; SET NORMAL SCROLL
	MOV	AX,500H
	INT	10H			; SET PAGE 0
	MOV	AH,3
	INT	10H			; GET CURSOR TYPE
	MOV	CURTYPE,CX		; SAVE IT
	MOV	AH,15
	INT	10H			; READ DISPLAY TYPE
	MOV	DISTYPE,AL		; SAVE DISPLAY TYPE
	CMP	AL,7			; MONOCHROME CARD?
	JZ	MONCRD			; YES
	MOV	AX,3			; ELSE, FORCE MODE 3 FOR NOW
	INT	10H
MONCRD:	POP	CX
GOTCHR:	MOV	TTYPE,CL		; SAVE TERMINAL TYPE (0 = Z-150)
	MOV	AX,0C00H
	INT	21H			; FLUSH TYPE-AHEAD
	MOV	AH,19H
	INT	21H			; GET CURRENT DISK
	MOV	OLDDSK,AL		; SAVE DISK FOR EXIT
	ADD	AL,'A'			; ADD ASCII
	MOV	CURDSK,AL		; SAVE IT
	MOV	DX,OFFSET INIT_MSG	; initialize the terminal
	CALL	DSPMSG
	CALL	GET_DIRECT		; GET DIRECTORY

;	MAIN COMMAND LOOP

;	REPAINT ENTIRE SCREEN

REPAINT:MOV	SP,OFFSET BA.STACK	; FIX STACK
	MOV	DX,OFFSET REPAINT
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C ADDRESS
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	CALL	DISP_CMD_LINE
	CALL 	DIRECTORY_DISPLAY

;	GET SINGLE KEY PRESS, PROCESS IT

GET_KEY:MOV	AH,7
	INT	21H			; GET CHARACTER
	OR	AL,AL			; NULL?
	JZ	GOTNULL			; YES
	CMP	AL,1BH			; ESC?
	JZ	GOTESC			; YES
	MOV	BX,OFFSET KEY_TABLE	; ELSE, USE REGULAR TABLE
	CALL	MUC			; MAKE CHAR UPPER CASE
	JMP	SHORT KEY_CHK
GOTNULL:MOV	BX,OFFSET Z150TBL	; USE Z-150 TABLE
	JMP	SHORT WFKEY		; AND WAIT FOR KEY SEQUENCE
GOTESC:	MOV	BX,OFFSET Z100TBL	; USE Z-100 TABLE
WFKEY:	MOV	CX,50			; SET A COUNTER
WFKEY1:	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			; CHECK FOR KEY SEQUENCE
	OR	AL,AL
	JNZ	KEY_CHK			; GOT SEQUENCE CHAR
	LOOP	WFKEY1			; ELSE, TRY AGAIN
	JMP	GET_KEY			; TIMED OUT, NO KEY SEQUENCE
KEY_CHK:
	CMP	BYTE PTR [BX],0
	JE	GET_KEY			; ignore if not in table
	CMP	AL,[BX]
	JE	GOT_KEY
	ADD	BX,3
	JMP	KEY_CHK
GOT_KEY:
	INC	BX
	JMP	WORD PTR [BX]
;
KEY_TABLE:
	DB	08h
	DW	OFFSET	DOBS
	DB	09h
	DW	OFFSET	DOTAB
	DB	0dh
	DW	OFFSET	DOCR
	DB	20h
	DW	OFFSET DOSPC
	DB	'C'
	DW	OFFSET DOCOPY
	DB	'E'
	DW	OFFSET DOERA
	DB	'F'
	DW	OFFSET DOFLAG
	DB	'H'
	DW	OFFSET DOHLP
	DB	'L'
	DW	OFFSET DOHEX
	DB	'M'
	DW	OFFSET DOMORE
	DB	'N'
	DW	OFFSET DONEW
	DB	'P'
	DW	OFFSET DOPRT
	DB	'Q'
	DW	OFFSET DOQUIT
	DB	'R'
	DW	OFFSET DOREN
	DB	'S'
	DW	OFFSET DOSORT
	DB	'T'
	DW	OFFSET DOTYPE
	DB	'U'
	DW	OFFSET DOUNSRT
	DB	'W'
	DW	OFFSET DOWILD
	DB	0
Z100TBL:
	DB	'~'
	DW	OFFSET DOHELP
	DB	'A'
	DW	OFFSET DOUP
	DB	'B'
	DW	OFFSET DODWN
	DB	'C'
	DW	OFFSET DORT
	DB	'D'
	DW	OFFSET DOLFT
	DB	'H'
	DW	OFFSET DOHOM
	DB	'S'
	DW	OFFSET DOHELP
	DB	0
Z150TBL:
	DB	';'
	DW	OFFSET DOHELP
	DB	'H'
	DW	OFFSET DOUP
	DB	'P'
	DW	OFFSET DODWN
	DB	'M'
	DW	OFFSET DORT
	DB	'K'
	DW	OFFSET DOLFT
	DB	'G'
	DW	OFFSET DOHOM
	DB	0

;	EXECUTE COMMANDS

;	MOVE COMMAND INDICATOR LEFT

DOBS:	CALL	NRM_CURC
	DEC	CUR_CMD
	CMP	CUR_CMD,0
	JGE	NO_WRP
	MOV	CUR_CMD,MAX_CMD
NO_WRP:
	CALL	REV_CURC
	JMP	GET_KEY

;	MOVE COMMAND INDICATOR RIGHT

DOSPC:
DOTAB:	CALL	NRM_CURC
	INC	CUR_CMD
	CMP	CUR_CMD,MAX_CMD
	JBE	NO_WRP
	MOV	CUR_CMD,0
	JMP	NO_WRP

;	RETURN PRESSED, EXECUTE SELECTED COMMAND

DOCR:	MOV	SI,CUR_CMD
	SHL	SI,1
	JMP	WORD PTR CMD_JMP_TBL[SI]
;
CMD_JMP_TBL:
	DW	OFFSET	DOCOPY
	DW	OFFSET	DOERA
	DW	OFFSET	DOFLAG
	DW	OFFSET  DOHLP
	DW	OFFSET	DOHEX
	DW	OFFSET	DOMORE
	DW	OFFSET	DONEW
	DW	OFFSET	DOPRT
	DW	OFFSET	DOQUIT
	DW	OFFSET	DOREN
	DW	OFFSET	DOSORT
	DW	OFFSET	DOTYPE
	DW	OFFSET	DOUNSRT
	DW	OFFSET	DOWILD

;	MOVE FILE INDICATOR RIGHT

DORT:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	ADD	CUR_ENT,17
	MOV	AX,MAX_ENT
	CMP	AX,CUR_ENT
	JA 	DORT_DISP
	SUB	CUR_ENT,17		; no wrap on right
DORT_DISP:
	CALL	CUR_ENT_REV
	MOV	DX,OFFSET SEL_DISP
	CALL	DSPMSG
	CALL	CUR_ENT_DIS
	CALL	CUR_ENT_SIZE
GET_KEYJ:
	JMP	GET_KEY

;	MOVE FILE INDICATOR LEFT

DOLFT:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	SUB	CUR_ENT,17
	CMP	CUR_ENT,0
	JGE	DORT_DISP
	ADD	CUR_ENT,17		; no wrap on left
	JMP	DORT_DISP

;	MOVE FILE INDICATOR UP

DOUP:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	DEC	CUR_ENT
	CMP	CUR_ENT,0
	JGE	DORT_DISP
	MOV	AX,MAX_ENT
	DEC	AX
	MOV	CUR_ENT,AX
	JMP	DORT_DISP

;	MOVE FILE INDICATOR DOWN

DODWN:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	INC	CUR_ENT
	MOV	AX,CUR_ENT
	CMP	AX,MAX_ENT
	JB 	DORT_DISP
	MOV	CUR_ENT,0
	JMP	DORT_DISP

;	HOME THE FILE INDICATOR

dohom:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	MOV	CUR_ENT,0
	JMP	DORT_DISP

;	SHOW HELP ON SELECTED COMMAND

DOHLP:	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	MOV	DX,OFFSET HHLP
	JMP	DOHELP_DIS

;	SHOW MAIN HELP SCREEN

DOHELP:	MOV	DX,OFFSET CLR_SCREEN	; clear screen
	CALL	DSPMSG
	MOV	SI,CUR_CMD
	SHL	SI,1
	MOV	DX,HLP_VCT[SI]
DOHELP_DIS:
	CALL	DSPMSG
WAIT_KEYIN:
	MOV	DX,OFFSET WAITKEY
	CALL	DSPMSG
	MOV	AH,7
	INT	21H
	JMP	REPAINT

;	COPY FILE(S)

DOCOPY:	CMP	FILECNT,0
	JNZ 	DOCOPY_OK
	JMP	FILES_ERR
DOCOPY_OK:
	MOV	DX,OFFSET INIT_PROMPT		
	CALL	DSPMSG
	MOV	DX,OFFSET DEST_FILE_REQ	; get destination file name
	CALL	DSPMSG
	MOV	AL,15
	CALL	GETSTR			; GET INPUT
	CMP	BYTE PTR BA.LINEBUF+1,0	; no action if null entry
	JNE	DOCOPY1
	JMP	RECMDJ
DOCOPY1:CMP	FLAGCNT,0		; ANY FLAGS?
	JZ	DOCOPY2			; NO
	MOV	AX,FILECNT
	MOV	TFCNT,AX		; ELSE, SET TEMP. COUNT
	MOV	AX,OFFSET BA.DIRPTR
	MOV	CUR_ADR,AX		; SET CURRENT FILE ADDRESS
	MOV	FLG2FLG,1		; AND SET TEMP. FLAG
DOCOPY2:
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG			; CLEAR SCREEN
	MOV	DX,OFFSET COPYING
	CALL	DSPMSG
COPYLP:
	CALL	GET_CURRENT		; GET CURRENT FILE NAME
	JNC	NCEND
	JMP	COPYX			; END OF COPYING
NCEND:	CALL	PNAME			; PRINT FILE NAME
	MOV	DX,OFFSET TOMSG
	CALL	DSPMSG			; PRINT "TO"
	MOV	SI,OFFSET BA.LINEBUF+2
	MOV	DI,OFFSET BA.FCBB
	MOV	AX,2900H+1110B
	INT	21H			; PARSE DESTINATION NAME
	MOV	SI,OFFSET BA.FCBB
	MOV	AL,[SI]
	OR	AL,AL			; DEFAULT DRIVE?
	JZ	NPNAM			; IF SO, DON'T PRINT IT
	ADD	AL,'@'
	CALL	SCOUT			; PRINT DEST. DRIVE
	MOV	AL,':'
	CALL	SCOUT			; PRINT COLON
NPNAM:	INC	SI
	CALL	PNAME			; PRINT DEST. NAME
	CALL	OPENFIL			; OPEN INPUT FILE
	JNZ	DOCOPY3			; OPEN OK
	MOV	DX,OFFSET READ_ERR_MSG
	CALL	DSPMSG			; INDICATE ERROR
	JMP	SHORT COPYR
DOCOPY3:MOV	AX,WORD PTR BA.FCBA+20
	MOV	DATSAVE,AX		; SAVE FILE DATE
	MOV	AX,WORD PTR BA.FCBA+22
	MOV	TIMSAVE,AX		; SAVE FILE TIME
	MOV	DX,OFFSET BA.FCBB
	CALL	OPENFL1			; TRY TO OPEN DESTINATION
	JZ	NODEST			; NOT THERE
	PUSH	DX
	MOV	DX,OFFSET FILE_EX
	CALL	DSPMSG			; SAY "FILE EXISTS"
	POP	DX
	MOV	AH,1
	INT	21H			; GET REPLY
	CALL	MUC
	CMP	AL,'Y'			; OK TO DELETE?
	JZ	NODEST			; YES
	JMP	COPYR
NODEST:	MOV	AH,16H
	INT	21H			; OPEN DESTINATION
	MOV	WORD PTR BA.FCBB+14,1	; SET RECORD SIZE TO 1 BYTE
	INC	AL
	JNZ	COPYLP1			; OPEN OK
	MOV	DX,OFFSET WRIT_ERR_MSG
	CALL	DSPMSG
	JMP	SHORT COPYR
COPYLP1:CALL	READFIL			; READ FROM SOURCE
	MOV	AH,28H
	MOV	DX,OFFSET BA.FCBB
	INT	21H			; WRITE TO DESTINATION
	OR	AL,AL
	JZ	DOCOPY4			; WRITE OK
COPYER:	MOV	DX,OFFSET WRIT_ERR_MSG
	CALL	DSPMSG
	JMP	SHORT COPYR
DOCOPY4:CMP	BYTE PTR EOFFLG,0	; END OF FILE?
	JZ	COPYLP1			; IF NOT, LOOP
	MOV	AX,DATSAVE
	MOV	WORD PTR BA.FCBB+20,AX	; FIX FILE DATE
	MOV	AX,TIMSAVE
	MOV	WORD PTR BA.FCBB+22,AX	; FIX FILE TIME
	MOV	DX,OFFSET BA.FCBB
	MOV	AH,10H
	INT	21H			; CLOSE FILE
	OR	AL,AL			; OK?
	JNZ	COPYER			; NO
COPYR:	MOV	DX,OFFSET CRLF
	CALL	DSPMSG			; PRINT CR, LF
	CMP	FLAGCNT,0		; COPYING FLAGGED FILES?
	JZ	COPYX			; IF NOT, DONE
	JMP	COPYLP			; ELSE, LOOP
COPYX:	MOV	FLG2FLG,0
	JMP	WAIT_KEYIN
;
FILES_ERR:
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET FILE_ERR_MSG
err_xit:
	CALL	DSPMSG
	JMP	WAITJ

;	ERASE FILE(S)

DOERA:	CMP	FILECNT,0
	JNZ	DOERA0
	JMP	FILES_ERR
DOERA0:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET CONFIRM_REQ	; ask for confirmation
	CMP	FLAGCNT,0		; ANY FLAGS?
	JZ	DOERA1			; NO
	MOV	AX,FILECNT
	MOV	TFCNT,AX		; ELSE, SET TEMP. COUNT
	MOV	AX,OFFSET BA.DIRPTR
	MOV	CUR_ADR,AX		; SET CURRENT ADDRESS
	MOV	FLG2FLG,1		; AND SET TEMP. FLAG
	MOV	DX,OFFSET CONFIRM_REQ1	; USE SPECIAL CONFIRM MSG.
DOERA1:	CALL	DSPMSG
	MOV	AH,1
	INT	21H			; GET REPLY
	CALL	MUC
	CMP	AL,"Y"
	JE	DEL_OK			; must be Y or y
RECMDJ:
	MOV	FLG2FLG,0		; CLEAR TEMP. FLAG
	CALL	DISP_CMD_LINE
	JMP	GET_KEY
DEL_OK:
	CALL 	GET_CURRENT
	JC	DELX			; END OF DELETIONS
	MOV	DX,OFFSET ERASING
	CALL	DSPMSG			; SAY "ERASING"
	MOV	DX,OFFSET BA.FCBA
	MOV	AH,13H			; delete file
	INT	21H
	INC	AL
	JZ	DEL_ERR
	CMP	FLAGCNT,0		; DOING FLAGS?
	JNZ	DEL_OK			; IF SO, LOOP
DELX:	MOV	CUR_ENT,0
	CALL	GET_DIR0		; RE-GET DIRECTORY
REPAINTJ:
	MOV	FLG2FLG,0
	JMP	REPAINT			; RE-SHOW DIRECTORY
DEL_ERR:
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET DEL_ERR_MSG
	CALL	DSPMSG
	CALL	PNAME			; PRINT FILE NAME
CFFLG:	CMP	FLAGCNT,0		; DOING FLAGS?
	JZ	WAITJ			; IF NOT, EXIT
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	MOV	AH,7
	INT	21H			; WAIT FOR KEY
	JMP	DEL_OK			; AND LOOP
WAITJ:	MOV	FLG2FLG,0
	JMP	WAIT_KEYIN

;	FLAG/UNFLAG FILE

DOFLAG:	MOV	SI,CUR_ENT		; GET CURRENT FILE NO.
	PUSH	SI
	SHL	SI,1
	SHL	SI,1			; MPY BY 4
	MOV	CX,4
FLAGLP:
	MOV	AL,BYTE PTR DIR_ENT_ADDR[SI]	; address cursor to entry position
	CALL	SCOUT
	INC	SI
	LOOP	FLAGLP
	POP	SI			; GET CURRENT NO. AGAIN
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	TEST	WORD PTR BA.DIRPTR[SI],8000H	; TEST FOR FLAG BIT
	JNZ	UNFLAG			; SET, SO REMOVE FLAG
	OR	WORD PTR BA.DIRPTR[SI],8000H	; SET FLAG BIT
	INC	FLAGCNT			; COUNT FLAG
	MOV	DX,OFFSET FLG_MSG
	CALL	DSPMSG			; MARK FILE ON SCREEN
	CALL	GET_SIZE		; GET FILE SIZE
	ADD	FLAG_L,BX		; ADD TO TOTAL
	ADC	FLAG_H,AX
	JMP	SHORT FLAGX
UNFLAG:	AND	WORD PTR BA.DIRPTR[SI],7FFFH	; KILL FLAG BIT
	DEC	FLAGCNT			; DECREMENT COUNTER
	MOV	AL,8
	CALL	SCOUT			; REMOVE FLAG FROM DISPLAY
	MOV	AL,' '
	CALL	SCOUT
	CALL	GET_SIZE		; GET FILE SIZE
	SUB	FLAG_L,BX		; SUB FROM TOTAL
	SBB	FLAG_H,AX
FLAGX:	MOV	DX,OFFSET FSPC_MSG
	CALL	DSPMSG
	MOV	BX,FLAG_L		; GET TOTAL BYTES FLAGGED
	MOV	AX,FLAG_H
	CALL	DDECOUT			; SHOW FLAG BYTES
	JMP	GET_KEY

;	LIST FILE IN HEX

DOHEX:	CMP	FILECNT,0
	JNZ	DOHEX1
	JMP	FILES_ERR
DOHEX1:	MOV	LINECNT,16		; SET LINE COUNTER
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	CALL	GET_CURRENT
	CALL	OPENFIL
	JNZ	DOHEX2
	MOV	DX,OFFSET READ_ERR_MSG
	CALL	DSPMSG
	JMP	WAIT_KEYIN
DOHEX2:	MOV	DI,0			; ASSUME START AT 0
	CMP	WORD PTR BA.FCBA+9,'OC'	; COM FILE?
	JNZ	HEXLP			; NO
	CMP	BYTE PTR BA.FCBA+11,'M'
	JNZ	HEXLP
	MOV	DI,100H			; ELSE, START AT 100H
HEXLP:	CALL	READFIL			; READ IN FILE
	OR	CX,CX			; NULL FILE?
	JNZ	NOTNUL
	JMP	DONE
NOTNUL:	PUSH	CX
	SHR	CX,1
	SHR	CX,1
	SHR	CX,1
	SHR	CX,1
	POP	AX
	AND	AX,15
	MOV	BX,16			; ASSUME FULL LAST LINE
	JE	NOXTRA
	INC	CX   			; # 16-byte display lines in au
	MOV	BX,AX			; SAVE LAST LINE SIZE
NOXTRA:	MOV	SI,OFFSET BA.RDBUF	; buffer address
LINLP:	PUSH	CX
	PUSH	BX
	MOV	BX,DI
	MOV	AL,BH
	CALL	CVTBYTE			; PRINT ADDRESS HIGH
	MOV	AL,BL
	CALL	CVTBYTE			; PRINT ADDRESS LOW
	POP	BX
	MOV	DX,OFFSET BEGLIN
	CALL	DSPMSG			; DISPLAY LINE BEGINNING
	CMP	CX,1			; LAST LINE?
	MOV	CX,16			; ASSUME NOT, 16 bytes/line
	JNZ	NOTLST
	MOV	CX,BX			; ELSE, GET LAST LINE SIZE
NOTLST:	PUSH	CX			; SAVE COUNT
CHRLP:	LODSB
	CALL	CVTBYTE
	MOV	AL,' '
	CMP	CX,9			; SEP = '-' on 8th byte
	JNE	SEP
	MOV	AL,'-'
SEP:	CALL	SCOUT
	LOOP	CHRLP
	POP	CX			; GET BYTE COUNT FOR LINE
	SUB	SI,CX			; BACK UP TO LINE START
	MOV	DX,OFFSET SEPMSG
	CALL	DSPMSG
ASCLP:	XOR	AH,AH
	LODSB
	CMP	AL,' '
	JAE	HICHK
ASCLP1:	MOV	AL,'.'
HICHK:	CMP	AL,7FH			; CHAR > DELETE?
	JB	PRTIT
	AND	AL,7FH
	CMP	AL,7FH
	JZ	ASCLP1			; DONT'T PRINT DELETE CHAR
	CMP	AL,' '
	JC	ASCLP1
	PUSH	AX
	MOV	DX,OFFSET REV_MSG
	CALL	DSPMSG			; CHARS > 7FH ARE REVERSE VID.
	POP	AX
	MOV	AH,1
PRTIT:	CALL	SCOUT
	CMP	AH,0
	JZ	PRTIT1
	MOV	DX,OFFSET NRM_MSG
	CALL	DSPMSG
PRTIT1:	LOOP	ASCLP
	MOV	DX,OFFSET SEPMSG+2
	CALL	DSPMSG
	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	ADD	DI,16
	DEC	LINECNT			; COUNT THIS LINE
	JNZ	NOT16			; NOT 16 LINES
	MOV	DX,OFFSET WAITKEY2
	CALL	DSPMSG
	MOV	AH,7
	INT	21H			; WAIT FOR KEY
	CMP	AL,3			; CONTROL-C?
	JNZ	NOTCC			; NO
	JMP	REPAINT			; ELSE, QUIT
NOTCC:	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	MOV	LINECNT,16		; RESET LINE COUNTER
NOT16:	POP	CX
	LOOP	LINLPJ
	JMP	ENDLN
LINLPJ:	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			; LOOK FOR KEY
	CMP	AL,3			; CONTROL-C?
	JZ	DONE
	JMP	LINLP
ENDLN:	CMP	BYTE PTR EOFFLG,0	; END?
	JNZ	DONE
	JMP	HEXLP
DONE:	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	JMP	WAIT_KEYIN

;	SHOW MORE OF LARGE DIRECTORY

DOMORE:	CMP	BYTE PTR MOREFLG,0	; MORE FILES?
	JNZ	DOMORE1			; YES
	JMP	GET_KEY			; ELSE, IGNORE
DOMORE1:MOV	CUR_ENT,0
	ADD	PAGECNT,85		; SKIP 85 FILES
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	CALL	DISP_CMD_LINE
	CALL 	DIRECTORY_DISPLAY
	JMP	GET_KEY

;	GET NEW DISK/DIRECTORY

DONEW:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET NEW_DISK_REQ	; request new drive ID
	CALL	DSPMSG
	MOV	AH,1
	INT	21H
	CALL	MUC
	CMP	AL,'A'
	JB	NO_NEW_DISK		; ignore invalid entries
	CMP	AL,'P'+1
	JNC	NO_NEW_DISK
	MOV	CURDSK,al
	SUB	AL,'A'
	MOV	DL,al			; set new default drive
	MOV	AH,14
	INT	21H
	MOV	CUR_ENT,0
NO_NEW_DISK:
	CALL	GET_DIRECT		; GET NEW DIRECTORY
	JMP	REPAINT

;	PRINT FILE

DOPRT:	CMP	FILECNT,0
	JNZ	DOPRT_OK
FILES_ERRJ:
	JMP	FILES_ERR
DOPRT_OK:
	CALL	GET_CURRENT
	CALL	OPENFIL			; OPEN FILE TO PRINT
	JNZ	DOPRT1			; OPEN OK
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET READ_ERR_MSG
	CALL	DSPMSG
DOPRT1:	CALL	READFIL			; READ IN FILE
	OR	CX,CX
	JZ	DOPRTX
	MOV	SI,OFFSET BA.RDBUF
PRTLP:	LODSB				; GET A CHARACTER
	MOV	DL,AL
	MOV	AH,5
	INT	21H			; PRINT CHARACTER
	LOOP	PRTLP
	CMP	EOFFLG,0		; END?
	JZ	DOPRT1			; IF NOT, LOOP
DOPRTX:	MOV	AL,7
	CALL	SCOUT			; BEEP
	JMP	GET_KEY

;	QUIT -- EXIT TO DOS

DOQUIT:	MOV	DX,OFFSET XIT_MSG
	CALL	DSPMSG
	CMP	Byte Ptr TTYPE,0	; H150?
	JNZ	EXIT1			; NO
	MOV	AL,DISTYPE		; ELSE, GET OLD DISPLAY TYPE
	XOR	AH,AH
	INT	10H			; SET IT
	MOV	CX,CURTYPE		; GET CURSOR TYPE
	MOV	AH,1
	INT	10H			; SET IT
EXIT1:	MOV	DL,OLDDSK		; GET OLD DISK
	MOV	AH,0EH
	INT	21H			; SET OLD CURRENT DISK
	INT	20H

;	RENAME FILE

DOREN:	CMP	FILECNT,0
	JZ	FILES_ERRJ
	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET NEW_NAME_REQ
	CALL	DSPMSG
	MOV	AL,15
	CALL	GETSTR			; GET NEW NAME
	CMP	BYTE PTR BA.LINEBUF+1,0	; ignore if null entry
	JNE	DOREN_CONT
	JMP	RECMDJ
DOREN_CONT:
	CALL	GET_CURRENT
	MOV	SI,OFFSET BA.LINEBUF+2
	MOV	DI,OFFSET BA.FCBB
	MOV	AX,2900H
	INT	21H			; PARSE NEW NAME
	MOV	DX,OFFSET BA.FCBB
	CALL	OPENFL1			; TRY TO OPEN NEW NAME
	JNZ	REN_ERR			; IT'S THERE, ERROR
	MOV	DI,OFFSET BA.FCBA+11H
	MOV	SI,OFFSET BA.FCBB+1	; POINT TO NEW NAME
	MOV	CX,11
	CLD
	REP	MOVSB			; MOVE IT TO OLD FCB
	MOV	DX,OFFSET BA.FCBA
	MOV	AH,17H			; rename file
	INT	21H
	INC	AL
	JZ	REN_ERR
	MOV	FILECNT,0
	CALL	GET_DIR1		; GET NEW NAME IN DIRECTORY
	JMP	REPAINT
REN_ERR:
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET REN_ERR_MSG
	CALL	DSPMSG
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	MOV	AH,7
	INT	21H			; WAIT FOR KEY
	CALL	SHOWBOT
	JMP	RECMDJ

;	SORT DIRECTORY

DOSORT:	MOV	SORTFLG,1		; MARK FILES SORTED
	CMP	FILECNT,0		; ANY FILES
	JNZ	SRTFLS			; YES, SORT THEM
	JMP	GET_KEY			; ELSE, EXIT
SRTFLS:	CALL	SORT			; SORT THE DIRECTORY
	JMP	REPAINT			; RE-DISPLAY FILES

;	TYPE FILES ON SCREEN

DOTYPE:	CMP	FILECNT,0
	JNZ	DOTYP1
	JMP	FILES_ERR
DOTYP1:	MOV	LINECNT,22		; SET LINE COUNT
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	CALL	GET_CURRENT
	CALL	OPENFIL			; OPEN FILE TO TYPE
	JNZ	TYPLP			; NO ERROR
	JMP	DOTYPR			; ELSE, EXIT
TYPLP:	CALL	READFIL			; READ IN FILE
	OR	CX,CX
	JZ	DOTYPX
	MOV	SI,OFFSET BA.RDBUF	; POINT TO BUFFER
	CLD
TYPLP1:	LODSB				; GET A CHARACTER
	CMP	AL,1AH			; EOF?
	JZ	DOTYPX			; YES
	PUSH	AX
	CALL	SCOUT			; PRINT TO SCREEN
	POP	AX
	AND	AL,7FH			; STRIP PARITY
	CMP	AL,LF			; LINE FEED?
	JNZ	TYPLP2			; NO
	DEC	LINECNT			; ELSE INCREMENT LINE COUNT
	JNZ	TYPLP2			; NOT ENOUGH LINES
	MOV	LINECNT,22		; RESET LINE COUNT
TWAIT:	MOV	AH,7
	INT	21H			; GET IT
	CMP	AL,3			; CONTROL-C?
	JNZ	TYPLP2			; NO
	JMP	REPAINT
TYPLP2: MOV	DL,0FFH
	MOV	AH,6			; CHECK KEYBOARD
	INT	21H
	CMP	AL,3			; CONTROL-C?
	JZ	DOTYPX			; IF SO, EXIT
	CMP	AL,'S'-'@'		; CONTROL-S?
	JZ	TWAIT			; IF SO, WAIT
	LOOP	TYPLP1			; FINISH BUFFER
	CMP	EOFFLG,0		; END?
	JZ	TYPLP			; IF NOT, LOOP
DOTYPX:	JMP	WAIT_KEYIN
DOTYPR:	MOV	DX,OFFSET READ_ERR_MSG
	CALL	DSPMSG
	JMP	WAIT_KEYIN

;	UNSORT/UNFLAG DIRECTORY

DOUNSRT:XOR	AX,AX
	MOV	FLAG_L,AX		; ZERO FLAG BYTE COUNT
	MOV	FLAG_H,AX
	MOV	SORTFLG,AL		; MARK FILES UNSORTED
	MOV	FLAGCNT,AL		; MARK THEM UNFLAGGED
	CMP	FILECNT,0		; ANY FILES
	JNZ	USFLS			; IF SO, UNSORT THEM
	JMP	GET_KEY			; ELSE, IGNORE
USFLS:	CALL	UNSORT			; UNSORT FILES
	JMP	REPAINT			; RE-DISPLAY THEM

;	ALTER WILDCARD SPECIFICATION

DOWILD:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET WILD_CARD_REQ
	CALL	DSPMSG
	MOV	AL,13
	CALL	GETSTR			; GET INPUT
	CMP	BYTE PTR BA.LINEBUF+1,0	; IGNORE IF NULL ENTRY
	JNE	DOWILD1
	JMP	RECMDJ
DOWILD1:
	MOV	SI,OFFSET BA.LINEBUF+2	; POINT TO NEW SPEC.
	MOV	DI,OFFSET WILDCARD	; PUT IT HERE
	MOV	AX,2900H
	INT	21H			; PARSE WILD CARD ENTRY
	CALL	GET_DIR0		; GET NEW RESTRICTED DIRECTORY
	JMP	REPAINT

;	PROCEDURES

;	OPEN FILE FOR READ

OPENFIL:
	MOV	DX,OFFSET BA.FCBA
OPENFL1:MOV	AH,0FH
	INT	21H			; OPEN FILE
	MOV	WORD PTR BA.FCBA+14,1	; SET RECORD SIZE TO 1 BYTE
	INC	AL			; SET FLAGS ON RESULT
	RET

;	READ FROM FILE

READFIL:
	MOV	DX,OFFSET BA.RDBUF
	MOV	AH,1AH
	INT	21H			; SET DTA TO READ BUFFER
	MOV	DX,OFFSET BA.FCBA
	MOV	CX,MEMTOP
	MOV	AX,OFFSET BA.RDBUF
	SUB	CX,AX			; GET BUFFER SIZE
	AND	CX,0FFF0H		; MAKE MULTIPLE OF 16 BYTES
	MOV	AH,27H
	INT	21H			; READ FILE
	MOV	EOFFLG,AL		; SAVE RESULT
	RET

;	PRINT NAME OF CURRENT FILE (SI POINTS TO NAME)

PNAME:
	MOV	CX,8
	CLD
PNAMLP:	LODSB				; GET A CHARACTER
	CMP	AL,' '
	JZ	SKSPC			; SKIP SPACES
	CALL	SCOUT			; PRINT FILE NAME
SKSPC:	LOOP	PNAMLP
	MOV	AL,'.'
	CALL	SCOUT
	MOV	CX,3
PEXTLP:	LODSB
	CMP	AL,' '
	JZ	SKSPC1			; SKIP SPACES
	CALL	SCOUT			; PRINT EXTENSION
SKSPC1:	LOOP	PEXTLP
	RET

;	GET INPUT STRING (DX = BUFFER, AL = LIMIT)

GETSTR:
	PUSH	SI
	MOV	SI,OFFSET BA.LINEBUF
	MOV	[SI],AL
	MOV	DX,SI
	MOV	AH,0AH
	INT	21H
	LODSB				; GET CHAR COUNT
	XOR	AH,AH
	MOV	DI,SI
	MOV	CX,AX			; COUNT TO CX
	INC	CX			; COUNT TERMINATOR
	INC	CX
	MOV	AL,' '
	REPZ	SCASB			; LOOK FOR NON-SPACE
	DEC	DI			; POINT TO FIRST NON-SPACE
	CMP	DI,SI			; ANY SPACES?
	JZ	GETSX			; IF NOT, EXIT
	XCHG	SI,DI
	REP	MOVSB			; MOVE STRING DOWN
GETSX:	POP	SI
	RET

;	MAP LOWER TO UPPER CASE

MUC:
	CMP	AL,'a'
	JC	MUCX
	CMP	AL,'z'+1
	JNC	MUCX
	AND	AL,5FH			; CAPITALIZE
MUCX:	RET

;	DISPLAY COMMAND LINE

DISP_CMD_LINE:
	MOV	DX,OFFSET INIT_CMD_LINE
	CALL	DSPMSG
	CMP	BYTE PTR TTYPE,0	; Z-150?
	JNZ	NOT150
	MOV	AH,1
	MOV	CX,2020H
	INT	10H			; TURN OFF CURSOR
NOT150:	MOV	CX,NCMDS
	PUSH	CUR_CMD
	MOV	CUR_CMD,0
DISPC_LP:
	CALL	NRM_CURC
	INC	CUR_CMD
	LOOP	DISPC_LP
	POP	CUR_CMD
	CALL 	REV_CURC
	RET

;	DISPLAY CURRENT COMMAND

REV_CURC:
	MOV	DX,OFFSET REV_MSG
	CALL	DSPMSG
NRM_CURC:
	MOV	SI,CUR_CMD
	SHL	SI,1
	MOV	DX,WORD PTR CMD_LINE_TBL[SI]
	CALL	DSPMSG
	MOV	DX,OFFSET NRM_MSG
	CALL	DSPMSG
	RET

;	DISPLAY DIRECTORY ON SCREEN

DIRECTORY_DISPLAY:
	MOV	DX,OFFSET DIR_HDR
	CALL	DSPMSG
	MOV	AL,CURDSK
	CALL	SCOUT
	MOV	AL,':'
	CALL	SCOUT
disents:
	PUSH	CUR_ENT			; save current entry pointer
	MOV	CUR_ENT,0		; reset for display
DISENT0:CMP	FILECNT,0		; ANY FILES?
	JNZ	DISPENTS		; YES
DISENT1:MOV	DX,OFFSET NO_FIL_MSG
	CALL	DSPMSG
	POP	CUR_ENT
	MOV	CUR_ENT,0
	JMP	DIR_FREE		; SHOW DISK FREE SPACE
DISPENTS:
	MOV	BX,OFFSET BA.DIRPTR	; POINT TO DIRECTORY POINTER
	MOV	AX,PAGECNT		; GET CURRENT COUNT
	CMP	AX,FILECNT		; REACHED FILE COUNT?
	JB	OKCNT			; NO
	MOV	AX,0			; ELSE, START OVER
	MOV	PAGECNT,0
OKCNT:	SHL	AX,1			; DOUBLE COUNT
	ADD	BX,AX			; ADD TO POINTER POS.
	CLD
DIS_LOOP:
	MOV	SI,CUR_ENT
	SHL	SI,1
	SHL	SI,1
	MOV	CX,4
ADR_LUP:
	MOV	AL,BYTE PTR DIR_ENT_ADDR[SI]	; address cursor to entry position
	CALL	SCOUT
	INC	SI
	LOOP	ADR_LUP
	MOV	SI,[BX]			; GET FILE NAME ADDRESS
	TEST	SI,8000H		; TEST FOR FLAG
	JZ	NOFLG			; NO FLAG
	AND	SI,7FFFH		; REMOVE FLAG
	MOV	DX,OFFSET FLG_MSG
	CALL	DSPMSG			; SHOW FLAG ON FILE
NOFLG:	CALL	PNAME			; PRINT FILE NAME
ENT_FIN:
	ADD	BX,2			; MOVE TABLE POINTER
	INC	CUR_ENT			; COUNT SCREEN FILE
	MOV	AX,PAGECNT
	ADD	AX,CUR_ENT
	CMP	AX,FILECNT		; DONE ALL FILES?
	JZ	ALLIN
	CMP	CUR_ENT,84
	JBE	DIS_LOOP
	MOV	BYTE PTR MOREFLG,1	; INDICATE MORE AVAILABLE
ALLIN:
	CMP	BYTE PTR MOREFLG,0	; MORE FILES?
	JZ	ALLIN1			; NO
	MOV	DX,OFFSET MORE_DIR
	CALL	DSPMSG			; ELSE, SHOW "MORE.."
ALLIN1:	MOV	AX,CUR_ENT
	MOV	MAX_ENT,AX
	POP	CUR_ENT
	CALL	CUR_ENT_REV
	MOV	DX,OFFSET FSPC_MSG
	CALL	DSPMSG			; SAY "FLAG BYTES"
	MOV	BX,FLAG_L		; GET FLAG BYTES
	MOV	AX,FLAG_H
	CALL	DDECOUT			; SHOW THEM
SHOWBOT:
	MOV	DX,OFFSET SEL_DISP
	CALL	DSPMSG
	CALL	CUR_ENT_DIS
	CALL	CUR_ENT_SIZE
DIR_FREE:
	MOV	DX,OFFSET FREE_MSG
	CALL	DSPMSG			; SAY "FREE SPACE"
	MOV	BX,FREE_L		; GET FREE SPACE
	MOV	AX,FREE_H
	CALL	DDECOUT			; SHOW IT
	RET

;	GET DIRECTORY FILES, STORE IN BUFFER

GET_DIRECT:
	MOV	DI,OFFSET WILDCARD+1
	MOV	CX,11
	MOV	AL,'?'
	CLD
	REP	STOSB			; RESET WILDCARD SPEC.
GET_DIR0:
	XOR	AX,AX
	MOV	FILECNT,AX		; CLEAR FILE COUNT
	MOV	PAGECNT,AX		; AND PAGE COUNT
	MOV	CUR_ENT,AX		; AND CURRENT ENTRY
	MOV	MOREFLG,AL		; AND MORE FLAG
	MOV	FLAGCNT,AL		; AND FLAG COUNT
	MOV	FLAG_L,AX		; AND FLAG BYTES
	MOV	FLAG_H,AX
GET_DIR1:
	MOV	WILDCARD,0
	MOV	DX,OFFSET BUF
	MOV	AH,26
	INT	21H			; SET DTA ADDRESS
	MOV	DI,OFFSET BA.DIR_ENT_BUF ; POINT TO DIR BUFFER
	MOV	DX,OFFSET WILDCARD
	MOV	AH,17			; CHECK FOR ENTRY
	INT	21H
	INC 	AL
	JZ	GETFREE			; NO FILES, GET FREE SPACE
GOTFILES:
	MOV	SI,OFFSET BUF+1
	MOV	CX,11
	CLD
	REP	MOVSB			; MOVE FILE NAME TO BUFFER
	MOV	SI,OFFSET BUF+29
	MOVSW
	MOVSW				; MOVE IN FILE SIZE
	INC	FILECNT			; COUNT THIS FILE
	MOV	AH,18			; CHECK FOR ANOTHER FILE
	INT	21H
	INC	AL
	JNZ	GOTFILES		; MOVE IT
	CALL	UNSORT			; SET POINTER TABLE
	CMP	SORTFLG,0		; SORT FILES?
	JZ	GETFREE			; NO
	CALL	SORT			; SORT THE DIRECTORY
GETFREE:CMP	BYTE PTR VERSION,2	; CHECK VERSION
	JAE	NEWVER			; NEW VERSION
	PUSH	DS
	MOV	AH,1BH
	INT	21H			; GET ALLOCATION TABLE ADDRESS
	MOV	AH,0
	PUSH	DX			; SAVE NO. OF BLOCKS
	XCHG	CX,DX			; PUT BLOCKS IN CX, BYTES IN DX
	MUL	DX			; COMPUTE MIN. BLOCK SIZE
	PUSH	AX			; SAVE RESULT
	XOR	AX,AX			; CLEAR FREE COUNTER
	MOV	SI,2			; START WITH FAT ENTRY 2
SLOOP:	MOV	DI,SI			; PUT ENTRY NO. IN DI
	SHR	DI,1			; DIVIDE BY 2
	ADD	DI,SI			; CALCULATE FAT OFFSET
	MOV	DI,[BX+DI]		; GET ENTRY
	TEST	SI,1			; ODD ENTRY NO.?
	JZ	SIZE1			; NO, EVEN
	SHR	DI,1			; ELSE, MOVE DOWN 4 BITS
	SHR	DI,1
	SHR	DI,1
	SHR	DI,1
SIZE1:	AND	DI,0FFFH		; ISOLATE 12 BITS
	JNZ	SIZE2			; NOT AN EMPTY ENTRY
	INC	AX			; COUNT EMPTY ENTRY
SIZE2:	INC	SI			; DO NEXT FAT ENTRY
	LOOP	SLOOP			; UNTIL DONE
	POP	CX			; GET BLOCK SIZE
	POP	DX			; AND NO. OF BLOCKS
	POP	DS
	JMP	SHORT CSIZE		; COMPUTE SIZE
NEWVER:	MOV	AH,36H
	XOR	DL,DL
	INT	21H			; GET FREE SPACE FROM SYSTEM
	MUL	CX			; COMPUTE BYTES/CLUSTER
	MOV	CX,AX
	MOV	AX,BX			; AX = FREE CLUSTERS
CSIZE:	MUL	CX			; COMPUTE BYTES FREE
	MOV	FREE_L,AX		; SAVE RESULT
	MOV	FREE_H,DX
	RET

;	UNSORT DIRECTORY (SET POINTERS FOR SORT)

UNSORT:
	MOV	AX,OFFSET BA.DIR_ENT_BUF ; POINT TO DIR BUFFER
	MOV	DI,OFFSET BA.DIRPTR	; AND POINTER
	MOV	CX,FILECNT		; GET FILE COUNT
	CLD
UNSLP:	STOSW				; STORE ENTRY ADDRESS
	ADD	AX,15			; MOVE TO NEXT ONE
	LOOP	UNSLP			; CONTINUE TILL DONE
	RET

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'FILECNT' = NUMBER OF STRINGS TO BE SORTED
;		'DIRPTR'  = START OF POINTER TABLE
;		POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN
;		ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.

SORT:
	MOV	BX,FILECNT
	CMP	BX,2			;2 OR MORE FILES?
	JNB	SORT1			;YES
	RET				;ELSE NO SORT NEEDED!
SORT1:	MOV	VARM,BX
SETM:	MOV	BX,VARM
	SHR	BX,1
	MOV	VARM,BX			;VARM = VARM / 2 
	CMP	BX,0
	JNZ	NOTEND	
	RET				;IF END OF SORT
NOTEND:	MOV	BX,1
	MOV	VARJ,BX			;VARJ = 1
	MOV	BX,FILECNT
	MOV	DX,VARM
	SUB	BX,DX
	MOV	VARK,BX			;VARK = FILECNT - VARM
SETI:	MOV	BX,VARJ
	MOV	VARI,BX			;VARI = VARJ
SETL:	MOV	BX,VARI
	MOV	DX,VARM
	ADD	BX,DX
	MOV	VARL,BX			;VARL = VARI + VARM
	CALL	SYMVAL			;BX = START OF DATA POINTED BY VARL
	PUSH	BX
	MOV	BX,VARI
	CALL	SYMVAL
	POP	SI
	MOV	CX,11			;*GET STRING LENGTH
	MOV	DI,BX			;SI AND DI POINT TO START OF STRINGS
	CLD
	REPZ	CMPSB			;COMPARE THE STRINGS
NOMACH:	JNB	SETJ			;IF NO REARRANGEMENT REQUIRED

; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	MOV	BX,VARI
	CALL	TABADD
	PUSH	BX			;STACK = POINTER DATA FOR (VARI)
	MOV	BX,VARL
	CALL	TABADD			;BX = POINTER DATA FOR (VARL)
	POP	SI
	MOV	AX,[SI]
	MOV	DX,[BX]
	MOV	[SI],DX
	MOV	[BX],AX

; SWITCH COMPLETED

	MOV	BX,VARI
	MOV	DX,VARM
	SUB	BX,DX
	MOV	VARI,BX			;VARI = VARI - VARM
	DEC	BX
	JS	SETJ	
	JMP	SETL			;IF VARI >= 1
SETJ:	MOV	BX,VARJ
	INC	BX
	MOV	VARJ,BX			;VARJ = VARJ + 1
	MOV	DX,VARK
	SUB	DX,BX
	JNB	SETJ0	
	JMP	SETM			;IF VARJ > VARK
SETJ0:	JMP	SETI

; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: BX = INTEGER VALUE ( 1 -> N )
;	EXIT:  BX = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DEC	BX			;START AT ZERO
	SHL	BX,1			;BX = [(ORIGINAL BX) - 1] * 2
	MOV	DX,OFFSET BA.DIRPTR
	ADD	BX,DX
	RET

; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: BX = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  BX = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	BX,[BX]
	AND	BX,7FFFH		; REMOVE FLAG BIT
	RET

;	DDECOUT - PRINT 32 BIT NO. IN AX,BX IN DECIMAL
;	AX = HIGH WORD, BX = LOW WORD

DDECOUT:
	MOV	SI,0			;CLEAR ZERO SUPPRESS FLAG
	MOV	CX,3B9AH
	MOV	DX,0CA00H		;CX,DX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	CALL	COMMA			;PRINT A COMMA (IF NO. PRINTED)
	MOV	CX,5F5H
	MOV	DX,0E100H		;CX,DX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	DX,9680H		;CX,DX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	DX,4240H		;CX,DX = 1,000,000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,1
	MOV	DX,86A0H		;CX,DX = 100,000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10000		;CX,DX = 10000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,1000			;CX,DX = 1000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,0
	MOV	DX,100			;CX,DX = 100
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10			;CX,DX = 10
	CALL	DIVPR
	MOV	AL,BL			;GET ONES DIGIT
	ADD	AL,'0'			;ADD ASCII
	JMP	SCOUT			;PRINT IT AND RETURN
DIVPR:	MOV	DI,-1			;SET A COUNTER
DIVPR1:	INC	DI			;INCREMENT COUNTER
	SUB	BX,DX			;SUBTRACT DIVISOR
	SBB	AX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	BX,DX			;ADD DIVISOR BACK IN ONCE
	ADC	AX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,DI			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	CMP	SI,0			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	INC	SI			;ELSE, FLAG ZEROS PASSED
DIVPR2:	CALL	SCOUT			;PRINT NO.
DIVPR3:	POP	AX			;RESTORE AX
	RET
COMMA:	CMP	SI,0			;ANY NUMBERS PRINTED?
	JZ	COMMA1			;NO
	PUSH	AX
	MOV	AL,','			;ELSE, PRINT COMMA
	CALL	SCOUT
	POP	AX
COMMA1:	RET

;	DISPLAY CURRENT ENTRY

CUR_ENT_REV:
	MOV	DX,OFFSET REV_MSG
	CALL	DSPMSG
CUR_ENT_NRM:
	MOV	BX,CUR_ENT
	SHL	BX,1
	SHL	BX,1
	MOV	CX,4
ent_adr_LOOP:
	MOV	AL,BYTE PTR DIR_ENT_ADDR[BX]
	CALL	SCOUT
	INC	BX
	LOOP	ent_adr_loop
CUR_ENT_DIS:
	MOV	BX,CUR_ENT		; GET CURRENT ENTRY NO.
	ADD	BX,PAGECNT		; ADD PAGE COUNT
	SHL	BX,1			; MPY BY 2
	PUSH	SI
	MOV	SI,WORD PTR BA.DIRPTR[BX] ; GET ENTRY ADDRESS
	AND	SI,7FFFH		; REMOVE FLAG BIT
	CALL	PNAME			; PRINT FILE NAME
	POP	SI
NRM_NOW:
	MOV	DX,OFFSET NRM_MSG
	CALL	DSPMSG
	RET
;
;	SHOW SIZE OF CURRENT FILE
;
CUR_ENT_SIZE:
	MOV	DX,OFFSET SIZ_MSG
	CALL	DSPMSG			; SAY "FILE SIZE"
	CALL	GET_SIZE		; GET SIZE OF FILE
	CALL	DDECOUT			; PRINT FILE SIZE

GET_SIZE:
	MOV	SI,CUR_ENT		; GET CURRENT ENTRY NO.
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	MOV	SI,WORD PTR BA.DIRPTR[SI] ; GET ENTRY ADDRESS
	AND	SI,7FFFH		; REMOVE FLAG BIT
	MOV	BX,11[SI]		; GET SIZE LOW
	MOV	AX,13[SI]		; GET SIZE HIGH
	RET

;	Get address of current selection

GET_CURRENT:
	CMP	FLG2FLG,0		; DOING FLAGS?
	JZ	GET1			; NO
	MOV	SI,CUR_ADR		; ELSE, GET FILE ADDRESS PTR.
	PUSH	CX
	MOV	CX,TFCNT		; AND TEMP. COUNT
	OR	CX,CX			; FILES USED UP?
	JZ	GOTEND			; YES
GETLP:	LODSW				; GET ADDRESS
	TEST	AX,8000H		; TEST FOR FLAGGED FILE
	JNZ	GOTFLG			; GOT ONE
	LOOP	GETLP			; LOOP UNTIL END OR ONE FOUND
GOTEND:	POP	CX
	STC				; NONE FOUND, FLAG END OF FILES
	RET
GOTFLG:	DEC	CX			; COUNT THIS FILE
	MOV	TFCNT,CX		; SAVE COUNT
	POP	CX
	MOV	CUR_ADR,SI		; SAVE FILE PTR ADDRESS
	MOV	SI,AX			; FILE ADDR TO SI
	JMP	SHORT GETX	
GET1:	MOV	SI,CUR_ENT		; GET CURRENT NO.
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	MOV	SI,WORD PTR BA.DIRPTR[SI]
GETX:	AND	SI,7FFFH		; REMOVE FLAG BIT
	PUSH	SI			; SAVE CURRENT NAME ADDRESS
	MOV	DI,OFFSET BA.FCBA
	PUSH	DI
	MOV	CX,37
	XOR	AL,AL
	CLD
	REP	STOSB			; CLEAR FCB
	POP	DI			; GET FCB ADDRESS
	PUSH	DI
	INC	DI			; MOVE TO NAME AREA
	MOV	CX,11
	REP	MOVSB			; MOVE NAME INTO FCB
	POP	SI
	MOV	DI,OFFSET BA.FCBB
	MOV	CX,37
	REP	MOVSB			; COPY FCBA TO FCBB
	POP	SI
	OR	AL,AL			; CLEAR CARRY
	RET

;	CONVERT BINARY BYTE TO HEX ASCII

CVTBYTE:
	PUSH	AX
	AND	AL,0F0H
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1			; MOVE HIGH NIBBLE DOWN
	CALL	CVTNIB			; PRINT IT
	POP	AX
	AND	AL,0FH
CVTNIB:	ADD	AL,90H			; CONVERT TO HEX ASCII
	DAA
	ADC	AL,40H
	DAA
;	JMP	SCOUT

;	SCOUT - SINGLE CHARACTER OUTPUT

SCOUT:	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	DX
	CMP	Byte Ptr TTYPE,0	; H150?
	JNZ	SCOUT1
	CALL	IBMOUT
	JMP	SCOUT2
SCOUT1:	MOV	DL,AL
	MOV	AH,6
	INT	21H
SCOUT2:	POP	DX
	POP	BX
	POP	CX
	POP	AX
	RET

;	DISPLAY MESSAGE ON SCREEN

DSPMSG:	PUSH	SI
	CLD
	MOV	SI,DX			; SI POINTS TO MSG
DSPMLP:	LODSB				; GET A CHARACTER
	CMP	AL,'$'			; END?
	JZ	DSPMX			; YES
	CALL	SCOUT			; ELSE, DISPLAY CHARACTER
	JMP	DSPMLP
DSPMX:	POP	SI
	RET

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:AND	AL,7FH
	CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT
SCREEN_OUT:
	MOV	AH,9
	MOV	BL,ATTRI
	MOV	BH,0			;WRITE CHR W/ ATTRIIBUTE
	MOV	CX,1
	INT	10H
	JMP	CURRT			;MOVE CURSOR OVER
WRT_TTY:CMP	AL,10			;LF?
	JNE	WRT_TTY1
	MOV	AH,3			; YES, GET CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	AL,10
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JL	WRT_TTY1
	JE	SCROL_24		;IF LINE = 24 THEN SCROLL 1-24
	RET				;IF LINE = 25 THEN IGNORE LF
SCROL_24:
	MOV	AX,601H
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTRI
	INT	10H
	RET
WRT_TTY1:MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,ATTRI 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	RET				; YES - IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	BYTE PTR ATTRI,7	;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,ATTRI		;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	HOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

REVIND:	MOV	AH,3			;REVERSE INDEX
	MOV	BH,0
	INT	10H			;GET CURSOR LOCATION
	CMP	DH,0			;LINE 1?
	JNZ	CURUP			;NO
	MOV	AX,701H			;ELSE, SCROLL DOWN
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTRI
	INT	10H
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR POSITION CALL
	RET
;
CURUP:	MOV	AH,3			;CURSOR UP
	MOV	BH,0
	INT	10H			;GET CURRENT POS
CURUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP SHORT SETCURS
;
CURDWN:	MOV	AH,3			;CURSOR DOWN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
CURDWN1:CMP	DH,24			;AT BOTTOM LINE?
	JZ	CURDWN2			;IF SO, NO SCROLL
	INC	DH
	CMP	DH,23
	JLE	SETCURS
CURDWN2:RET
;
TAB:	MOV	AH,3			;PROCESS TABS
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	ADD	DL,8
	AND	DL,0F8H			;MOV TO NEXT TAB STOP
	JMP SHORT CURRT1
;
CURRT:	MOV	AH,3			;CURSOR RIGHT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	INC	DL
CURRT1:	CMP	DL,79
	JBE	SETCURS
	RET				;CURSOR IN LAST COLUMN
;
CURLFT:	MOV	AH,3			;CURSOR LEFT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	DEC	DL
	CMP	DL,0
	JAE	SETCURS
	RET				;CURSOR IN FIRST COLUMN

HOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,ATTRI
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP SHORT HOME
;
ERSEOL:	MOV	AH,3			;ERASE TO END OF LINE
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTRI
	MOV	CX,DX
	MOV	DL,79
	INT	10H
	RET
;
ERSEOS:	MOV	AH,3			;ERASE TO END OF SCREEN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTRI		;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,ATTRI
	INT	10H
ERS_RET:RET

ERSLIN:	MOV	AH,3			;ERASE LINE
	MOV	BH,0
	INT	10H			;GET CURRENT LOCATION
	MOV	CX,DX
	MOV	CL,0
	MOV	DL,79
	MOV	AX,0600H		;SCROLL REGION (SINGLE LINE) CLEAR
	MOV	BH,ATTRI
	INT	10H
	RET
;
SAVCRS:	MOV	AH,3			;SAVE CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	CURSAV,DX
	RET
;
RSTCRS:	MOV	DX,CURSAV		;RESTORE CURSOR POSITION
	JMP	SETCURS
;
DOREV:	MOV	BYTE PTR ATTRI,HICODE 	;REV. VIDEO
	RET
;
DONRM:	MOV	BYTE PTR ATTRI,7	;NOR. VIDEO
	RET

RESMOD:	MOV	WORD PTR IBMJMP,OFFSET RESMOD1	; GET NEXT CHAR
	RET
RESMOD1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	; RESET JUMP
	CMP	AL,'5'			; RESTORE CURSOR?
	JZ	CURON			; YES
	RET				; ELSE, IGNORE
CURON:	MOV	AH,1
	MOV	CX,CURTYPE
	INT	10H			; RESTORE CURSOR
	RET

IGNORE:	MOV	WORD PTR IBMJMP,OFFSET IGNORE1	;IGNORE NEXT CHAR
	RET
IGNORE1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	RET

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
GRAFLG	DB	0			;GRAPHICS MODE FLAG
ATTRI	DB	7  			;DEFAULT ATTRIBUTE (WHITE ON BLACK)
SAV_ROW	DB	0			;SAVED ROW POSITION
CURSAV	DW	0			;SAVED CURSOR POSITION
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'K'
	DW	OFFSET ERSEOL
	DB	'A'
	DW	OFFSET CURUP
	DB	'B'
	DW	OFFSET CURDWN
	DB	'C'
	DW	OFFSET CURRT
	DB	'D'
	DW	OFFSET CURLFT
	DB	'H'
	DW	OFFSET HOME
	DB	'I'
	DW	OFFSET REVIND
	DB	'l'
	DW	ERSLIN
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'j'
	DW	OFFSET SAVCRS
	DB	'k'
	DW	OFFSET RSTCRS
	DB	'x'
	DW	OFFSET IGNORE
	DB	'y'
	DW	OFFSET RESMOD
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH:
	DB	0f9h	; ^
	DB	0dbh	; _
	DB	0b3h	; `
	DB	0c4h	; a
	DB	0c5h	; b
	DB	0bfh	; c
	DB	0d9h	; d
	DB	0c0h	; e
	DB	0dah	; f
	DB	0f1h	; g
	DB	01ah	; h
	DB	0b0h	; i
	DB	0f6h	; j
	DB	019h	; k
	DB	0dah	; l
	DB	0bfh	; m
	DB	0d9h	; n
	DB	0c0h	; o
	DB	0dfh	; p
	DB	0deh	; q
	DB	0dbh	; r
	DB	0c2h	; s
	DB	0b4h	; t
	DB	0c1h	; u
	DB	0c3h	; v
	DB	058h	; w
	DB	02fh	; x
	DB	05ch	; y
	DB	0dfh	; z
	DB	0dch	; {
	DB	0ddh	; |
	DB	0deh	; }
	DB	014h	; ~
	DB	0dbh	; del
;
BA:					; BUFFER AREA
BUFF		STRUC
		DB	256 DUP (?)
stack		DB	?
FCBA		DB	37 DUP (?)
FCBB		DB	37 DUP (?)
LINEBUF		DB	128 DUP (?)
DIRPTR		DB	2*512 DUP (?)	; DIRECTORY ENTRY POINTER
DIR_ENT_BUF	DB	15*512 DUP (?)  ; ROOM FOR 512 ENTRIES
RDBUF		DB	?
BUFF		ENDS
HFMJR		ENDS
	end	start
                                                   