	TITLE	DATETIME - SET DATE AND TIME TO NEWEST FILE
	PAGE	,132
;	DATETIME.COM - SET DATE AND TIME
;
;	COPYRIGHT MARCH 20, 1982 BY FRANK T. CLARK
;
;	THIS PROGRAM IS DESIGNED TO BE RUN FROM AN AUTOEXEC.BAT
;	FILE.  IT WILL AUTOMATICALLY SCAN THE ENTIRE DIRECTORY
;	SELECTING THE DATE FROM THE NEWEST FILE.  IF THIS IS MORE
;	RECENT THAN THE CURRENT DATE IT WILL SET THE DATE AND TIME.
;	IN ANY EVENT IT WILL CREATE A FILE DATETIME.TMP WHICH WILL
;	HAVE THE DATE AND TIME JUST SET.
;
	.XLIST
	INCLUDE	DEFMS.ASM
	.LIST
PGMSEG	SEGMENT
	ASSUME	CS:PGMSEG,DS:PGMSEG,SS:PGMSEG,ES:PGMSEG
	ORG	100H

;	START WITH ????????.??? AND SEARCH FOR FIRST DIR ENTRY

START:	CLD				;ENSURE FORWARD STRING MOVEMENT
	MOV	DI,PHD_FCB1+1		;POINT TO NAME AREA
	MOV	CX,11
	MOV	AL,'?'
	REP	STOSB			;FILL NAME WITH "?"'S
	MOV	DX,PHD_FCB1
	MOV	AH,DOSF_SRHFI
	INT	DOSI_FUNC		;SEARCH DIRECTORY

;	GET THE DATE AND TIME FROM THIS AND SUCCESSIVE FILES

DTLOOP:	MOV	DX,DS:[PHD_DIOA+25]	;FETCH DATE BITS
	MOV	DI,OFFSET BUFFER	;POINT TO BUFFER
	MOV	CL,7
	ROL	DX,CL			;MOVE YEAR AROUND
	MOV	AX,DX
	AND	AX,01111111B		;ISOLATE YEAR
	ADD	AX,1980			;ADD OFFSET
	XCHG	AL,AH			;SWAP LOW, HI
	STOSW				;STORE IT
	MOV	CL,4
	ROL	DX,CL			;MOVE MONTH AROUND
	MOV	AX,DX
	AND	AX,01111B		;ISOLATE MONTH
	STOSB				;SAVE IT
	MOV	CL,5
	ROL	DX,CL			;MOVE DAY AROUND
	MOV	AX,DX
	AND	AX,011111B		;ISOLATE DAY
	STOSB				;SAVE IT
	MOV	DX,DS:[PHD_DIOA+23]	;GET TIME BITS
	MOV	CL,5
	ROL	DX,CL			;MOVE HOUR AROUND
	MOV	AX,DX
	AND	AX,011111B		;ISOLATE HOUR
	STOSB				;SAVE IT
	MOV	CL,6
	ROL	DX,CL			;MOVE MINUTE AROUND
	MOV	AX,DX
	AND	AX,0111111B		;ISOLATE MINUTE
	STOSB				;SAVE IT
	MOV	SI,OFFSET BUFFER2	;POINT TO BUFFER 2
	MOV	DI,OFFSET BUFFER	;AND FIRST BUFFER
	MOV	CX,6			;COMPARE 6 BYTES
	REPE	CMPSB			;COMPARE
	JAE	OLDER			;NEW DATE IS OLDER

;	REMEMBER THE DATE OF THIS MOST RECENT FILE

	MOV	SI,OFFSET BUFFER
	MOV	DI,OFFSET BUFFER2
	MOV	CX,6
	REP	MOVSB			;STORE CHARS

;	IGNORE OLD FILE AND SEARCH FOR NEXT

OLDER:	MOV	DX,PHD_FCB1		;POINT TO FCB
	MOV	AH,DOSF_SRHNX
	INT	DOSI_FUNC		;SEARCH FOR NEXT FILE
	CMP	AL,0FFH			;TEST FOR ENTRY
	JNE	DTLOOP			;GOT ONE

;	IS THE CURRENT DATE GREATER?

	MOV	AH,DOSF_GDATE
	INT	DOSI_FUNC		;GET CURRENT DATE
	XCHG	CH,CL
	MOV	WORD PTR BUFFER,CX	;PUT YEAR IN BUFFER
	XCHG	DH,DL
	MOV	WORD PTR BUFFER+2,DX	;PUT MO., DAY IN BUFFER
	MOV	AH,DOSF_GTIME
	INT	DOSI_FUNC		;GET TIME
	XCHG	CH,CL
	MOV	WORD PTR BUFFER+4,CX	;PUT TIME IN BUFFER
	MOV	SI,OFFSET BUFFER2
	MOV	DI,OFFSET BUFFER
	MOV	CX,6
	REPE	CMPSB			;COMPARE DATES/TIMES
	JBE	CREATE			;CURRENT GREATER, USE IT

;	SET DATE AND TIME TO MOST RECENT

	MOV	CX,WORD PTR BUFFER2	;GET YEAR
	XCHG	CH,CL			;FIX IT
	MOV	DX,WORD PTR BUFFER2+2	;GET DAY,MO
	XCHG	DH,DL			;FIX IT
	MOV	AH,DOSF_SDATE
	INT	DOSI_FUNC		;SET DATE
	MOV	CX,WORD PTR BUFFER2+4	;GET HOUR,MIN
	XCHG	CH,CL			;FIX
	MOV	DX,WORD PTR BUFFER2+6	;GET SECOND,FRACTION
	MOV	AH,DOSF_STIME
	INT	DOSI_FUNC		;SET TIME

;	CREATE DATETIME.TMP FILE WITH NEWEST TIME

CREATE:	MOV	SI,OFFSET FILENAME	;POINT TO FILE NAME
	MOV	DI,PHD_FCB1+1		;POINT TO FCB
	MOV	CX,11
	REP	MOVSB			;MOVE IN FILE NAME
	MOV	DX,PHD_FCB1		;POINT TO FCB
	PUSH	DX			;SAVE ADDR
	MOV	AH,DOSF_CRFILE
	INT	DOSI_FUNC		;CREATE DIR. ENTRY
	POP	DX
	MOV	AH,DOSF_CLFILE
	INT	DOSI_FUNC		;CLOSE FILE
	INT	DOSI_TERM		;EXIT TO Z-DOS

;	DATA AND BUFFER AREA

BUFFER	DB	6 DUP (0)
BUFFER2	DB	6 DUP (0)
	DB	99,59			;START AT NEXT MINUTE
FILENAME DB	'DATETIMETMP'

PGMSEG	ENDS
	END	START
                                 