;	PROGRAM TO SET MX80 PRINTER OPTIONS
;
;	ENTER
;
;	A>PSETMX x
;
;	WHERE x IS ONE OF THE FOLLOWING
;
;	C	SET COMPRESSED PRINTING
;	E	SET EMPHASIZED PRINTING
;	D	SET DOUBLE STRIKE
;	N	SET NORMAL PRINTING (CANCEL ABOVE SETTINGS)
;	6	SET 6 LINES/INCH
;	7	SET 7/72" LINE SPACING
;	8	SET 8 LINES/INCH

M	EQU	Byte Ptr 0[BX]

PSETMX	SEGMENT
	ASSUME CS:PSETMX,DS:PSETMX,ES:PSETMX,SS:PSETMX

	ORG	100H
START:	MOV	BX,80H			;POINT TO ARGUMENT
	MOV	AL,M			;GET COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GETARG			;YES
	MOV	DX,(Offset INST)
	MOV	AH,9
	INT	21H			;PRINT INSTRUCTIONS
	JMP	SHORT EXIT
GETARG:	INC	BX			;MOVE TO HEXT CHAR
	MOV	AL,M			;GET IT
	CMP	AL,' '			;SPACE?
	JZ	GETARG			;SKIP SPACES
	MOV	BX,(Offset STRING)	;POINT TO SETUP STRING
	CMP	AL,'8'			;8?
	MOV	CH,'0'			;ASSUME YES
	JZ	PSET
	INC	CH
	CMP	AL,'7'
	JZ	PSET
	INC	CH
	CMP	AL,'6'
	JZ	PSET
	CMP	AL,'E'			;EMPHASIZED?
	MOV	CH,AL			;ASSUME YES
	JZ	PSET
	CMP	AL,'D'			;DOUBLE?
	MOV	CH,'G'
	JZ	PSET
	INC	BX			;SKIP ESCAPE
	CMP	AL,'C'			;COMPRESSED?
	MOV	CH,15
	JZ	PSET
	MOV	BX,(Offset NORMAL)	;ONLY NORMAL IS LEFT
	CMP	AL,'N'			;TEST FOR IT
	JZ	PLOOP
EXIT:
	INT	20H			;RETURN TO Z-DOS
PSET:	MOV	AL,CH
	MOV	Byte Ptr ARG,AL		;SET UP PRINTER SETUP STRING
PLOOP:	MOV	AL,M			;GET CHARACTER
	OR	AL,AL			;END OF STRING?
	JZ	EXIT			;IF SO, EXIT
	MOV	DL,AL			;PUT CHAR IN E
	MOV	AH,5			;PRINT FUNCTION
	PUSH	BX			;SAVE POINTER
	INT	21H			;CALL BDOS TO PRINT
	POP	BX			;RESTORE POINTER
	INC	BX			;INCREMENT IT
	JMP	SHORT PLOOP		;CONTINUE PRINTING

INST	DB	0DH,0AH
	DB	'PSET for the MX80.',0DH,0AH,0DH,0AH
	DB	'Enter PSETMX [arg], where [arg] ='
	DB	0DH,0AH,0DH,0AH
	DB	'C -- set Compressed printing.',0DH,0AH
	DB	'D -- set Double strike.',0DH,0AH
	DB	'E -- set Emphasized printing.',0DH,0AH
	DB	'N -- set Normal printing (cancel the above).',0DH,0AH
	DB	'6 -- set 6 Lines Per Inch.',0DH,0AH
	DB	'7 -- set 7/72" line spacing.',0DH,0AH
	DB	'8 -- set 8 LPI.',0DH,0AH,'$'
STRING	DB	1BH
ARG	DB	' ',0
NORMAL	DB	18,27,'F',27,'H',0
PSETMX	ENDS
	END	START
