;	title	'HUG File Manager'
;
;	HUG File Manager for CP/M
;
;	BY P. SWAYNE, HUG  02-APR-85
;	MADE FROM THE ORIGINAL HUG FILE MANAGER BY
;		R. A. METZ AND P. SWAYNE
;
;	This program operates in a manner similar to the Microsoft
;	Multiplan spreadsheet program in that a command line is
;	displayed at the bottom of the screen.  Operation of that 
;	command line parallels that of Multiplan's command 
;	line.  The main screen area is used for directory
;	display and display of requested file data.
;
;	Commands currently implemented are:
;
;	Copy	Copy selected file.  The user is prompted to
;		enter the name of the destination file/device.
;	Erase	Erase file.  The user is asked for confirmation
;		before actually erasing the selected file.
;	Flag	Mark file with a flag.  If Copy or Delete are then
;		used, the marked files will be acted upon, instead
;		of the highlighted file.
;	Help	Use of this utility is explained.
;	Listhex	The selected file is displayed in Hex and ASCII.
;		The sub-utility program 'HEXLIST' performs this task.
;	Moredir	If there are more files than fit on the screen, this
;		command will show the next screen.  If used while the
;		last screen of files are showing, the first files are
;		re-displayed.
;	Newdisk	The user is prompted for a disk id to become the
;		new default.
;	Print	The selected file is sent to the printer.
;	Quit	Quit this program.
;	Rename	Rename file.  The user is prompted for a new
;		file name and the selected file is renamed.
;	Sort	The directory is sorted alphabetically and displayed
;		in that form.  This is the normal condition at startup.
;	Type	The selected file is displayed on the screen.
;	Unsort	The directory is unsorted and the files are displayed
;		in their natural order.
;	Wildcrd.Wildcard Specification.  The user is prompted for a
;		wildcard specification that determines which files
;		are shown on the screen.
;
BDOS	EQU	5			; BDOS ADDRESS
MEMTOP	EQU	6			; MEMORY TOP ADDRESS
BUF	EQU	80H			; DEFAULT BUFFER ADDRESS
	ORG	100H

;	PERFORM SETUP CHORES

START:	LXI	SP,STACK
	MVI	C,20H
	MVI	E,0FFH
	CALL	CBDOS			; GET CURRENT USER NO.
	STA	OLDUSR			; SAVE IT
	STA	CURUSR			; HERE, TOO
	MVI	C,19H
	CALL	CBDOS			; GET CURRENT DISK
	STA	OLDDSK			; SAVE DISK FOR EXIT
	ADI	'A'			; ADD ASCII
	STA	CURDSK			; SAVE IT
	LXI	D,INIT$MSG		; initialize the terminal
	CALL	DSPMSG
	CALL	GET$DIRECT		; GET DIRECTORY

;	MAIN COMMAND LOOP

;	REPAINT ENTIRE SCREEN

REPAINT:LXI	SP,STACK		; FIX STACK
	LXI	D,CLR$SCREEN
	CALL	DSPMSG
	CALL	DISP$CMD$LINE
	CALL 	DIRECTORY$DISPLAY

;	GET SINGLE KEY PRESS, PROCESS IT

GET$KEY:CALL	GETCHR			; GET A KEY
	CPI	1BH			; ESC?
	JZ	GOTESC			; YES
	LXI	H,KEY$TABLE		; ELSE, USE REGULAR TABLE
	CALL	MUC			; MAKE CHAR UPPER CASE
	JMP	KEY$CHK
GOTESC:	LXI	H,Z100TBL		; USE Z-100 TABLE
WFKEY:	MVI	B,50			; SET A COUNTER
WFKEY1:	MVI	C,6
	MVI	E,0FFH
	CALL	CBDOS			; CHECK FOR KEY SEQUENCE
	ORA	A
	JNZ	KEY$CHK			; GOT SEQUENCE CHAR
	DCR	B
	JNZ	WFKEY1			; ELSE, TRY AGAIN
	JMP	GET$KEY			; TIMED OUT, NO KEY SEQUENCE
KEY$CHK:
	MOV	B,A
	MOV	A,M
	ORA	A
	MOV	A,B
	JZ	GET$KEY			; ignore if not in table
	CMP	M
	JZ	GOT$KEY
	INX	H
	INX	H
	INX	H
	JMP	KEY$CHK
GOT$KEY:
	INX	H
	MOV	A,M			; GET ADDRESS OF ROUTINE
	INX	H
	MOV	H,M
	MOV	L,A
	PCHL
;
;	EXECUTE COMMANDS

;	MOVE COMMAND INDICATOR LEFT

DOBS:	CALL	NRM$CURC
	LHLD	CUR$CMD
	DCX	H
	SHLD	CUR$CMD
	MOV	A,H
	ORA	A			; NEG. NUMBER?
	JP	NO$WRP			; IF NOT, OK
	LXI	H,MAX$CMD
	SHLD	CUR$CMD			; ELSE, SET MAX COMMAND
NO$WRP:
	CALL	REV$CURC
	JMP	GET$KEY

;	MOVE COMMAND INDICATOR RIGHT

DOSPC:
DOTAB:	CALL	NRM$CURC
	LHLD	CUR$CMD
	INX	H
	SHLD	CUR$CMD
	MOV	A,L
	CPI	MAX$CMD+1		; AT MAX COMMAND
	JC	NO$WRP			; YES
	LXI	H,0			; ELSE, MOVE TO 0
	SHLD	CUR$CMD
	JMP	NO$WRP

;	RETURN PRESSED, EXECUTE SELECTED COMMAND

DOCR:	LHLD	CUR$CMD
	DAD	H
	LXI	D,CMD$JMP$TBL
	DAD	D
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A			; HL = COMMAND ADDRESS
	PCHL				; GO TO IT
;
;	MOVE FILE INDICATOR RIGHT

DORT:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	GET$KEY
	CALL	CUR$ENT$NRM
	LHLD	CUR$ENT
	LXI	D,17			; ENTRIES/COLUMN
	DAD	D			; MOVE TO NEXT COLUMN
	SHLD	CUR$ENT
	LDA	MAX$ENT
	DCR	A
	CMP	L			; AT MAX ENTRY?
	JNC	DORT$DISP		; NOT YET
	LHLD	CUR$ENT
	LXI	D,-17
	DAD	D
	SHLD	CUR$ENT			; ELSE, STOP HERE
DORT$DISP:
	CALL	CUR$ENT$REV
	LXI	D,SEL$DISP
	CALL	DSPMSG
	CALL	CUR$ENT$DIS
	CALL	CUR$ENT$SIZE
	JMP	GET$KEY

;	MOVE FILE INDICATOR LEFT

DOLFT:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	GET$KEY
	CALL	CUR$ENT$NRM
	LHLD	CUR$ENT
	LXI	D,-17
	DAD	D			; BACK UP ONE COLUMN
	SHLD	CUR$ENT
	MOV	A,H
	ORA	A			; PASSED ZERO
	JP	DORT$DISP		; IF NOT, MOVE
	LHLD	CUR$ENT
	LXI	D,17
	DAD	D			; ELSE, STAY THERE
	SHLD	CUR$ENT
	JMP	DORT$DISP

;	MOVE FILE INDICATOR UP

DOUP:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	GET$KEY
	CALL	CUR$ENT$NRM
	LHLD	CUR$ENT
	DCX	H
	SHLD	CUR$ENT
	MOV	A,H
	ORA	A
	JP	DORT$DISP
	LHLD	MAX$ENT
	DCX	H
	SHLD	CUR$ENT
	JMP	DORT$DISP

;	MOVE FILE INDICATOR DOWN

DODWN:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	GET$KEY
	CALL	CUR$ENT$NRM
	LHLD	CUR$ENT
	INX	H
	SHLD	CUR$ENT
	MOV	A,L
	LHLD	MAX$ENT
	CMP	L
	JC 	DORT$DISP
	LXI	H,0
	SHLD	CUR$ENT
	JMP	DORT$DISP

;	HOME THE FILE INDICATOR

DOHOM:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	GET$KEY
	CALL	CUR$ENT$NRM
	LXI	H,0
	SHLD	CUR$ENT
	JMP	DORT$DISP

;	SHOW HELP ON SELECTED COMMAND

DOHLP:	LXI	D,CLR$SCREEN
	CALL	DSPMSG
	LXI	D,HHLP
	JMP	DOHELP$DIS

;	SHOW MAIN HELP SCREEN

DOHELP:	LXI	D,CLR$SCREEN		; clear screen
	CALL	DSPMSG
	LHLD	CUR$CMD
	DAD	H
	LXI	D,HLP$VCT
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M			; DE = MESSAGE
DOHELP$DIS:
	CALL	DSPMSG
WAIT$KEYIN:
	LXI	D,WAITKEY
	CALL	DSPMSG
	CALL	GETCHR			; WAIT FOR A KEY
	JMP	REPAINT

;	COPY FILE(S)

DOCOPY:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	FILES$ERR
	LDA	CURUSR
	STA	TMPUSR			; SET TEMP. USER
	LXI	D,INIT$PROMPT		
	CALL	DSPMSG
	LXI	D,DEST$FILE$REQ		; get destination file name
	CALL	DSPMSG
	MVI	A,20
	CALL	GETSTR			; GET INPUT
	JZ	RECMDJ
DOCOPY1:LDA	FLAGCNT
	ORA	A			; ANY FLAGS?
	JZ	DOCOPY2			; NO
	LHLD	FILECNT
	SHLD	TFCNT			; ELSE, SET TEMP. COUNT
	LXI	H,DIRPTR
	SHLD	CUR$ADR			; SET CURRENT FILE ADDRESS
	MVI	A,1
	STA	FLG2FLG			; AND SET TEMP. FLAG
DOCOPY2:
	LXI	D,CLR$SCREEN
	CALL	DSPMSG			; CLEAR SCREEN
	LXI	D,COPYING
	CALL	DSPMSG
COPYLP:
	CALL	GET$CURRENT		; GET CURRENT FILE NAME
	JC	COPYX			; END OF COPYING
NCEND:	CALL	PNAME			; PRINT FILE NAME
	LXI	D,TOMSG
	CALL	DSPMSG			; PRINT "TO"
	LXI	H,LINEBUF
	CALL	GETUSR			; GET USER NO, IF ANY
	JC	NOUSER
	MOV	A,C
	STA	TMPUSR			; SET TEMP. USER
NOUSER:	LXI	D,FCBB
	CALL	PARSE1			; PARSE DEST. NAME
	LDA	TMPUSR
	MOV	L,A
	MVI	H,0
	CALL	DEC0			; PRINT USER NUMBER
	MVI	A,' '
	CALL	SCOUT
	LXI	H,FCBB
	MOV	A,M
	ORA	A
	JZ	NPDRV			; DON'T PRINT NUL DRIVE
	ADI	'@'
	CALL	SCOUT			; PRINT DEST. DRIVE
	MVI	A,':'
	CALL	SCOUT			; PRINT COLON
NPDRV:	INX	H
	CALL	PNAME			; PRINT DEST. NAME
	CALL	OPENFIL			; OPEN INPUT FILE
	JNZ	DOCOPY3			; OPEN OK
	LXI	D,READ$ERR$MSG
	CALL	DSPMSG			; INDICATE ERROR
	JMP	COPYR
DOCOPY3:LDA	TMPUSR
	MOV	E,A
	MVI	C,20H
	CALL	CBDOS			; SET DEST. USER NO.
	LXI	H,FCBB+9
	MOV	A,M
	ANI	7FH			; REMOVE R/O FLAG
	MOV	M,A
	LXI	D,FCBB
	CALL	OPENFL1			; TRY TO OPEN DESTINATION
	JZ	NODST
	MOV	A,M			; GET FT1 BYTE
	ORA	A			; TEST FOR R/O
	JM	COPYER			; FILE IS R/O
	PUSH	D
	LXI	D,FILE$EX
	CALL	DSPMSG			; SAY "FILE EXISTS"
	CALL	GETCHR
	POP	D
	CALL	SCOUT
	CALL	MUC
	CPI	'Y'			; DELETE OLD FILE?
	JNZ	COPYR			; NO
	MVI	C,13H
	CALL	CBDOS			; DELETE OLD FILE
	INR	A
	JZ	COPYER			; CAN'T DO IT
NODST:	MVI	C,16H
	CALL	CBDOS			; MAKE DESTINATION
	INR	A
	JZ	COPYER			; WRITE ERROR
COPYLP1:LDA	CURUSR
	MOV	E,A
	MVI	C,20H
	CALL	CBDOS			; SET CURRENT USER
	CALL	READFIL			; READ FROM SOURCE
	LDA	TMPUSR
	MOV	E,A
	PUSH	B			; SAVE RECORD COUNT
	MVI	C,20H
	CALL	CBDOS			; SET TEMP. USER
	POP	B
	MOV	A,B
	ORA	C			; NULL FILE?
	JZ	DOCOPY4
	LXI	D,RDBUF			; POINT TO BUFFER
	LXI	H,FCBB			; AND DEST. FCB
WRITLP:	PUSH	B
	MVI	C,1AH
	CALL	CBDOS			; SET DMA ADDRESS
	XCHG
	MVI	C,15H
	CALL	CBDOS			; WRITE A RECORD
	ORA	A			; TEST RESULT
	JNZ	COPYER			; WRITE ERROR
	LXI	B,80H
	DAD	B			; UPDATE DMA ADDRESS
	POP	B
	XCHG
	DCX	B			; COUNT RECORD
	MOV	A,B
	ORA	C
	JNZ	WRITLP			; AND WRITE UNTIL DONE
	JMP	DOCOPY4
COPYER:	LXI	D,WRIT$ERR$MSG
	CALL	DSPMSG
	JMP	COPYR
DOCOPY4:LDA	EOFFLG
	ORA	A			; END OF FILE?
	JZ	COPYLP1			; IF NOT, LOOP
	LXI	D,FCBB
	MVI	C,10H
	CALL	CBDOS			; CLOSE FILE
	INR	A			; OK?
	JZ	COPYER			; NO
COPYR:	LXI	D,CRLF
	CALL	DSPMSG			; PRINT CR, LF
	LDA	CURUSR
	MOV	E,A
	MVI	C,20H
	CALL	CBDOS			; SET CURRENT USER
	LDA	FLAGCNT
	ORA	A			; COPYING FLAGGED FILES?
	JNZ	COPYLP			; IF SO, LOOP
COPYX:	XRA	A
	STA	FLG2FLG	
	JMP	WAIT$KEYIN
;
FILES$ERR:
	LXI	D,MSG$PROMPT
	CALL	DSPMSG
	LXI	D,FILE$ERR$MSG
err$xit:
	CALL	DSPMSG
	JMP	COPYX

;	ERASE FILE(S)

DOERA:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JNZ	DOERA0
	JMP	FILES$ERR
DOERA0:	LXI	D,INIT$PROMPT
	CALL	DSPMSG
	LXI	D,CONFIRM$REQ		; ask for confirmation
	LDA	FLAGCNT
	ORA	A			; ANY FLAGS?
	JZ	DOERA1			; NO
	LHLD	FILECNT
	SHLD	TFCNT			; ELSE, SET TEMP. COUNT
	LXI	H,DIRPTR
	SHLD	CUR$ADR			; SET CURRENT ADDRESS
	MVI	A,1
	STA	FLG2FLG			; AND SET TEMP. FLAG
	LXI	D,CONFIRM$REQ1		; USE SPECIAL CONFIRM MSG.
DOERA1:	CALL	DSPMSG
	CALL	GETCHR			; GET REPLY
	CALL	SCOUT
	CALL	MUC
	CPI	'Y'
	JZ	DEL$OK			; must be Y or y
RECMDJ:
	XRA	A
	STA	FLG2FLG			; CLEAR TEMP. FLAG
	CALL	DISP$CMD$LINE
	JMP	GET$KEY
DEL$OK:
	CALL 	GET$CURRENT
	JC	DELX			; END OF DELETIONS
	LXI	D,FCBA
	CALL	OPENFIL			; TRY TO OPEN FILE
	JZ	DEL$ERR			; NOT THERE (?)
	PUSH	D
	POP	H
	LXI	B,9
	DAD	B
	MOV	A,M			; GET FT1 BYTE
	ORA	A			; TEST FOR R/O
	JM	DEL$ERR			; FILE IS R/O
	PUSH	D
	LXI	D,ERASING
	CALL	DSPMSG
	POP	D
	MVI	C,13H			; delete file
	CALL	CBDOS
	INR	A
	JZ	DEL$ERR
	LDA	FLAGCNT
	ORA	A			; DOING FLAGS?
	JNZ	DEL$OK			; IF SO, LOOP
DELX:	LXI	H,0
	SHLD	CUR$ENT	
	CALL	GET$DIR0		; RE-GET DIRECTORY
REPAINTJ:
	XRA	A
	STA	FLG2FLG	
	JMP	REPAINT			; RE-SHOW DIRECTORY
DEL$ERR:
	LXI	D,MSG$PROMPT
	CALL	DSPMSG
	LXI	D,DEL$ERR$MSG
	CALL	DSPMSG
	LXI	H,FCBA+1
	CALL	PNAME			; PRINT FILE NAME
CFFLG:	LDA	FLAGCNT
	ORA	A			; DOING FLAGS?
	JZ	COPYX			; IF NOT, EXIT
	LXI	D,WAITKEY1
	CALL	DSPMSG
	CALL	GETCHR			; WAIT FOR KEY
	JMP	DEL$OK			; AND LOOP

;	FLAG/UNFLAG FILE

DOFLAG:	LHLD	CUR$ENT			; GET CURRENT FILE NO.
	PUSH	H
	DAD	H
	DAD	H			; MPY BY 4
	LXI	B,DIR$ENT$ADDR
	DAD	B
	MVI	B,4
FLAGLP:
	MOV	A,M			; address cursor to entry position
	CALL	SCOUT
	INX	H
	DCR	B
	JNZ	FLAGLP
	POP	D			; GET CURRENT NO. AGAIN
	LHLD	PAGECNT
	DAD	D			; ADD PAGE COUNT
	DAD	H			; MPY BY 2
	XCHG
	LXI	H,DIRPTR
	DAD	D			; ADD DIRECTORY POINTER
	INX	H			; POINT TO HIGH BYTE
	MOV	A,M
	ANI	80H			; TEST FOR FLAG BIT
	JNZ	UNFLAG			; SET, SO REMOVE FLAG
	MOV	A,M
	ORI	80H			; ELSE, SET BIT
	MOV	M,A
	LXI	H,FLAGCNT
	INR	M			; COUNT FLAG
	LXI	D,FLG$MSG
	CALL	DSPMSG			; MARK FILE ON SCREEN
	CALL	GET$SIZE		; GET FILE SIZE
	XCHG
	LHLD	FLAG
	DAD	D			; ADD TO TOTAL
	SHLD	FLAG
	JMP	FLAGX
UNFLAG:	MOV	A,M
	ANI	7FH			; KILL FLAG BIT
	MOV	M,A
	LXI	H,FLAGCNT
	DCR	M			; DECREMENT COUNTER
	MVI	A,8
	CALL	SCOUT			; REMOVE FLAG FROM DISPLAY
	MVI	A,' '
	CALL	SCOUT
	CALL	GET$SIZE		; GET FILE SIZE
	XCHG
	MOV	A,E
	CMA
	MOV	E,A
	MOV	A,D
	CMA
	MOV	D,A
	INX	D
	LHLD	FLAG
	DAD	D			; SUB FROM TOTAL
	SHLD	FLAG
FLAGX:	LXI	D,FSPC$MSG
	CALL	DSPMSG
	LHLD	FLAG			; GET TOTAL BYTES FLAGGED
	CALL	DECOUT			; SHOW FLAG BYTES
	JMP	GET$KEY

;	LIST FILE IN HEX

DOHEX:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	FILES$ERR
	MVI	A,16
	STA	LINECNT			; SET LINE COUNTER
	LXI	D,CLR$SCREEN
	CALL	DSPMSG
	LXI	D,CRLF
	CALL	DSPMSG
	CALL	GET$CURRENT
	CALL	OPENFIL
	JNZ	DOHEX2
	LXI	D,MSG$PROMPT
	CALL	DSPMSG
	LXI	D,READ$ERR$MSG
	CALL	DSPMSG
	JMP	REPAINT
DOHEX2:	LXI	H,0
	SHLD	ADDRESS			; ASSUME START AT 0
	LHLD	FCBA+9
	MOV	A,L
	CPI	'C'			; CHECK FOR .COM FILE
	JNZ	HEXLP
	MOV	A,H
	CPI	'O'
	JNZ	HEXLP
	LDA	FCBA+11
	CPI	'M'
	JNZ	HEXLP			; NOT .COM
	LXI	H,100H
	SHLD	ADDRESS			; ELSE, START AT 100H
HEXLP:	CALL	READFIL			; READ IN FILE
	MOV	A,B
	ORA	C
	JZ	DONE			; NULL FILE
	CALL	REC2BYT			; CONVERT AMOUNT READ TO BYTES
	MVI	D,4
HDIVLP:	MOV	A,B			; DIVIDE BY 16
	ORA	A
	RAR
	MOV	B,A
	MOV	A,C
	RAR
	MOV	C,A
	DCR	D
	JNZ	HDIVLP
	POP	D
	MOV	A,E
	ANI	15
	MVI	A,16			; ASSUME FULL LAST LINE
	JZ	NOXTRA
	INX	B   			; # 16-byte display lines
	MOV	A,E
NOXTRA:	STA	LASTLIN			; SAVE LAST LINE SIZE
	LXI	H,RDBUF			; buffer address
LINLP:	PUSH	B
	PUSH	H
	LHLD	ADDRESS
	MOV	A,H
	CALL	CVTBYTE			; PRINT ADDRESS HIGH
	MOV	A,L
	CALL	CVTBYTE			; PRINT ADDRESS LOW
	LXI	D,BEGLIN
	CALL	DSPMSG			; DISPLAY LINE BEGINNING
	MVI	E,16			; ASSUME LAST LINE
	MOV	A,B
	ORA	A
	JNZ	NOTLST
	MOV	A,C
	CPI	1			; LAST LINE?
	JNZ	NOTLST			; NO
	LDA	LASTLIN			; ELSE, GET LAST LINE SIZE
	MOV	E,A
NOTLST:	POP	H			; GET BUFFER ADDRESS
	MOV	B,E
	PUSH	B			; SAVE COUNT
CHRLP:	MOV	A,M
	INX	H
	CALL	CVTBYTE
	MOV	A,B
	CPI	9
	MVI	A,' '			; ASSUME NORMAL SEPARATER
	JNZ	SEP
	MVI	A,'-'
SEP:	CALL	SCOUT
	DCR	B
	JNZ	CHRLP
	POP	B			; GET BYTE COUNT FOR LINE
	MOV	A,L
	SUB	B
	MOV	L,A
	MOV	A,H
	SBI	0
	MOV	H,A			; BACK UP TO LINE START
	LXI	D,SEPMSG
	CALL	DSPMSG
ASCLP:	MVI	C,0
	MOV	A,M
	INX	H
	CPI	' '
	JNC	HICHK
ASCLP1:	MVI	A,'.'
HICHK:	CPI	7FH			; DELETE?
	JC	PRTIT
	ANI	7FH			; REMOVE HIGH BIT
	CPI	7FH
	JZ	ASCLP1			; DON'T PRINT DELETE CHAR
	CPI	' '
	JC	ASCLP1
	PUSH	PSW
	LXI	D,REV$MSG
	CALL	DSPMSG			; CHARS WITH HIGH BIT ARE REV.
	POP	PSW
	MVI	C,1
PRTIT:	CALL	SCOUT
	MOV	A,C
	ORA	A
	JZ	PRTIT1
	LXI	D,NRM$MSG
	CALL	DSPMSG
PRTIT1:	DCR	B
	JNZ	ASCLP
	LXI	D,SEPMSG+2
	CALL	DSPMSG
	LXI	D,CRLF
	CALL	DSPMSG
	PUSH	H			; SAVE POINTER
	LHLD	ADDRESS
	LXI	D,16
	DAD	D
	SHLD	ADDRESS
	POP	H
	LDA	LINECNT
	DCR	A			; COUNT THIS LINE
	STA	LINECNT
	JNZ	NOT16			; NOT 16 LINES
	LXI	D,WAITKEY2
	CALL	DSPMSG
	PUSH	B
	CALL	GETCHR			; WAIT FOR KEY
	POP	B
	CPI	3			; CONTROL-C?
	JZ	REPAINT			; IF SO, QUIT
NOTCC:	LXI	D,CRLF
	CALL	DSPMSG
	MVI	A,16
	STA	LINECNT			; RESET LINE COUNTER
NOT16:	POP	B
	DCX	B
	MOV	A,B
	ORA	C
	JZ	ENDLN
	PUSH	B
	MVI	C,6
	MVI	E,0FFH
	CALL	CBDOS			; CHECK KEYBOARD
	POP	B
	CPI	3			; CONTROL-C?
	JNZ	LINLP
ENDLN:	LDA	EOFFLG
	ORA	A			; END?
	JNZ	DONE
	JMP	HEXLP
DONE:	LXI	D,CRLF
	CALL	DSPMSG
	JMP	WAIT$KEYIN

;	SHOW MORE OF LARGE DIRECTORY

DOMORE:	LDA	MOREFLG
	ORA	A			; MORE FILES?
	JNZ	DOMORE1			; YES
	JMP	GET$KEY			; ELSE, IGNORE
DOMORE1:LXI	H,0
	SHLD	CUR$ENT
	LHLD	PAGECNT
	LXI	D,85
	DAD	D			; SKIP 85 ENTRIES
	SHLD	PAGECNT
	LXI	D,CLR$SCREEN
	CALL	DSPMSG
	CALL	DISP$CMD$LINE
	CALL 	DIRECTORY$DISPLAY
	JMP	GET$KEY

;	GET NEW DISK/DIRECTORY

DONEW:	LXI	D,INIT$PROMPT
	CALL	DSPMSG
	LXI	D,NEW$DISK$REQ		; request new drive ID
	CALL	DSPMSG
	MVI	A,5
	CALL	GETSTR			; GET NEW NO, ID
	JZ	RECMDJ
	LXI	H,LINEBUF		; POINT TO ENTRY
	CALL	GETUSR			; GET USER NO, IF ANY
	JC	NOUSR			; NONE ENTERED
	MOV	A,C
	STA	CURUSR			; SAVE NEW USER
	MOV	E,C
	MVI	C,20H
	CALL	CBDOS			; SET NEW USER
NOUSR:	MOV	A,M			; GET DRIVE CODE
	CALL	MUC
	CPI	'A'
	JC	NO$NEW$DISK		; ignore invalid entries
	CPI	'P'+1
	JNC	NO$NEW$DISK
	STA	CURDSK
	SUI	'A'
	MOV	E,A			; set new default drive
	MVI	C,0DH
	CALL	CBDOS			; RESET DISK SYSTEM
	MVI	C,14
	CALL	CBDOS			; SELECT NEW DISK
	LXI	H,0
	SHLD	CUR$ENT	
NO$NEW$DISK:
	CALL	GET$DIRECT		; GET NEW DIRECTORY
	JMP	REPAINT

;	PRINT FILE

DOPRT:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	FILES$ERR
	CALL	GET$CURRENT
	CALL	OPENFIL			; OPEN FILE TO PRINT
	JNZ	DOPRT1			; OPEN OK
	LXI	D,MSG$PROMPT
	CALL	DSPMSG
	LXI	D,READ$ERR$MSG
	CALL	DSPMSG
DOPRT1:	CALL	READFIL			; READ IN FILE
	MOV	A,B
	ORA	C
	JZ	DOPRTX			; NULL FILE
	CALL	REC2BYT			; CONVERT RECORDS TO BYTES
	LXI	H,RDBUF
PRTLP:	MOV	A,M			; GET A CHARACTER
	INX	H
	MOV	E,A
	PUSH	B
	MVI	C,5
	CALL	CBDOS			; PRINT CHARACTER
	POP	B
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	PRTLP
	LDA	EOFFLG
	ORA	A			; END?
	JZ	DOPRT1			; IF NOT, LOOP
DOPRTX:	MVI	A,7
	CALL	SCOUT			; BEEP
	JMP	GET$KEY

;	QUIT -- EXIT TO DOS

DOQUIT:	MVI	C,11
	CALL	CBDOS			; ANY CHARACTERS PENDING?
	ORA	A
	JZ	DOQUI1
	MVI	C,1
	CALL	CBDOS			; ABSORB CHARACTER
	JMP	DOQUIT			; TRY AGAIN
DOQUI1:	LXI	D,XIT$MSG
	CALL	DSPMSG
	LDA	OLDDSK			; GET OLD DISK
	MOV	E,A
	MVI	C,0EH
	CALL	BDOS			; SET OLD CURRENT DISK
	LDA	OLDUSR
	MOV	E,A
	MVI	C,20H
	CALL	BDOS			; SET OLD USER NO.
	MVI	C,0
	CALL	BDOS

;	RENAME FILE

DOREN:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JZ	FILES$ERR
	LXI	D,INIT$PROMPT
	CALL	DSPMSG
	LXI	D,NEW$NAME$REQ
	CALL	DSPMSG
	MVI	A,16
	CALL	GETSTR			; GET NEW NAME
	JZ	RECMDJ
	CALL	GET$CURRENT
	LXI	H,LINEBUF
	LXI	D,FCBB
	CALL	PARSE			; PARSE NEW NAME
	LXI	D,FCBB
	CALL	OPENFL1			; TRY TO OPEN NEW NAME
	JNZ	REN$ERR			; IT'S THERE, ERROR
	LXI	D,FCBA+11H
	LXI	H,FCBB+1		; POINT TO NEW NAME
	MVI	B,11
	CALL	MOVE			; MOVE IT TO OLD FCB
	LXI	D,FCBA
	MVI	C,17H			; rename file
	CALL	CBDOS
	INR	A
	JZ	REN$ERR
	LXI	H,0
	SHLD	FILECNT	
	CALL	GET$DIR1		; GET NEW NAME IN DIRECTORY
	JMP	REPAINT
REN$ERR:
	LXI	D,MSG$PROMPT
	CALL	DSPMSG
	LXI	D,REN$ERR$MSG
	CALL	DSPMSG
	LXI	D,WAITKEY1
	CALL	DSPMSG
	CALL	GETCHR			; WAIT FOR KEY
	CALL	SHOWBOT
	JMP	RECMDJ

;	SORT DIRECTORY

DOSORT:	MVI	A,1
	STA	SORTFLG			; MARK FILES SORTED
	LHLD	FILECNT
	MOV	A,H
	ORA	L			; ANY FILES
	JNZ	SRTFLS			; YES, SORT THEM
	JMP	GET$KEY			; ELSE, EXIT
SRTFLS:	CALL	SORT			; SORT THE DIRECTORY
	JMP	REPAINT			; RE-DISPLAY FILES

;	TYPE FILES ON SCREEN

DOTYPE:	LHLD	FILECNT
	MOV	A,H
	ORA	L
	JNZ	DOTYP1
	JMP	FILES$ERR
DOTYP1:	MVI	A,22
	STA	LINECNT			; SET LINE COUNT
	LXI	D,CLR$SCREEN
	CALL	DSPMSG
	CALL	GET$CURRENT
	CALL	OPENFIL			; OPEN FILE TO TYPE
	JNZ	TYPLP			; NO ERROR
	JMP	DOTYPR			; ELSE, EXIT
TYPLP:	CALL	READFIL			; READ IN FILE
	MOV	A,B
	ORA	C
	JZ	DOTYPX			; NUL FILE
	CALL	REC2BYT			; GET BYTES READ
	LXI	H,RDBUF			; POINT TO BUFFER
TYPLP1:	MOV	A,M			; GET A CHARACTER
	INX 	H
	CPI	1AH			; EOF?
	JZ	DOTYPX			; YES
	PUSH	PSW
	CALL	SCOUT			; PRINT TO SCREEN
	POP	PSW
	ANI	7FH			; STRIP PARITY
	CPI	LF			; LINE FEED?
	JNZ	TYPLP2			; NO
	LDA	LINECNT
	DCR	A			; ELSE COUNT LINE
	STA	LINECNT
	JNZ	TYPLP2			; NOT ENOUGH LINES
	MVI	A,22
	STA	LINECNT			; RESET LINE COUNT
TWAIT:	PUSH	B
	CALL	GETCHR			; GET KEY
	POP	B
	CPI	3			; CONTROL-C?
	JZ	REPAINT			; IF SO, QUIT
TYPLP2: MVI	E,0FFH
	PUSH	B
	MVI	C,6			; CHECK KEYBOARD
	CALL	CBDOS
	POP	B
	CPI	3			; CONTROL-C?
	JZ	DOTYPX			; IF SO, EXIT
	CPI	'S'-'@'			; CONTROL-S?
	JZ	TWAIT			; IF SO, WAIT
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	TYPLP1			; FINISH BUFFER
	LDA	EOFFLG
	ORA	A			; END?
	JZ	TYPLP			; IF NOT, LOOP
DOTYPX:	JMP	WAIT$KEYIN
DOTYPR:	LXI	D,MSG$PROMPT
	CALL	DSPMSG
	LXI	D,READ$ERR$MSG
	CALL	DSPMSG
	JMP	WAIT$KEYIN

;	UNSORT/UNFLAG DIRECTORY

DOUNSRT:LXI	H,0
	MOV	A,L
	SHLD	FLAG			; ZERO FLAG BYTE COUNT
	STA	SORTFLG			; MARK FILES UNSORTED
	STA	FLAGCNT			; MARK THEM UNFLAGGED
	LHLD	FILECNT
	MOV	A,H
	ORA	L			; ANY FILES
	JZ	GET$KEY			; NO, IGNORE
	CALL	UNSORT			; UNSORT FILES
	JMP	REPAINT			; RE-DISPLAY THEM

;	ALTER WILDCARD SPECIFICATION

DOWILD:	LXI	D,INIT$PROMPT
	CALL	DSPMSG
	LXI	D,WILD$CARD$REQ
	CALL	DSPMSG
	MVI	A,14
	CALL	GETSTR			; GET INPUT
	JZ	RECMDJ
	LXI	H,LINEBUF		; POINT TO NEW SPEC.
	LXI	D,WILDCARD		; PUT IT HERE
	CALL	PARSE			; PARSE WILD CARD ENTRY
	CALL	GET$DIR0		; GET NEW RESTRICTED DIRECTORY
	JMP	REPAINT

;	PROCEDURES

;	PARSE FILE NAME, FILLING FCB
;	HL = NAME, DE = FCB

PARSE:	PUSH	D			; SAVE FCB ADDRESS
	INX	D			; MOVE TO NAME AREA
	MVI	B,11
	MVI	A,' '
	CALL	FILL			; CLEAR FCB
	POP	D
PARSE1:	XRA	A
	STAX	D			; CLEAR DRIVE CODE
	PUSH	D
	XCHG
	LXI	B,12
	DAD	B
	XCHG
	XRA	A
	MVI	B,36-12
	CALL	FILL			; CLEAR REST OF FCB
	POP	D
	PUSH	D
	INX	H			; SKIP TO POSSIBLE ":"
	MOV	A,M
	CPI	':'			; ONE THERE?
	JNZ	NOCOL			; NO
	DCX	H			; ELSE BACK UP TO DRIVE
	MOV	A,M			; GET IT
	CALL	MUC			; CAPITALIZE
	SUI	'@'			; REMOVE ASCII
	STAX	D			; PUT IT IN FCB
	INX	H			; SKIP TO NAME
	INX	H
	INX	H			; CANCEL NEXT DCX
NOCOL:	DCX	H			; BACK UP TO NAME START
	INX	D			; POINT TO FCB NAME AREA
	MVI	B,8			; MAX 8 CHARS IN NAME
	MOV	A,M
	INX	H
	CPI	'.'			; NO NAME?
	JZ	PARSE5			; IF SO, SKIP THIS SECTION
	JMP	PARSE2+2
PARSE2:	MOV	A,M			; MOVE NAME TO FCB
	INX	H
	ORA	A			; END?
	JNZ	PARSE3
	POP	D
	RET				; RETURN IF END
PARSE3:	CPI	'.'			; EXTENSION?
	JZ	PARSE4
	CPI	'*'			; WILD CARD?
	JNZ	NOTWLD			; NO
	MVI	A,'?'
	JMP	FILLNM			; ELSE, FILL REST OF NAME
NOTWLD:	CALL	MUC			; MAP TO UPPER CASE
	STAX	D			; STORE CHARACTER
	INX	D
	DCR	B
	JNZ	PARSE2
PARSE4:	MOV	A,B
	ORA	A			; ALL NAME AREA USED?
	JZ	PARSE5			; YES
	MVI	A,' '
FILLNM:	CALL	FILL			; ELSE, CLEAR REST
PARSE5:	POP	D			; GET FCB ADDRESS AGAIN
	DCX	H
FPER:	MOV	A,M			; GET LAST CHAR
	INX	H
	ORA	A			; END?
	RZ
	CPI	'.'			; MUST BE PERIOD HERE
	JNZ	FPER			; SO, LOOK FOR IT
	XCHG
	LXI	B,9
	DAD	B			; MOVE TO EXTENSION AREA
	XCHG
	MVI	B,3			; SET A COUNTER
PARSE6:	MOV	A,M
	INX	H
	CALL	MUC
	ORA	A
	JZ	PARSE7
	CPI	'*'
	JNZ	NOTWLD1
	MVI	A,'?'
	JMP	FILLEX
NOTWLD1:STAX	D
	INX	D
	DCR	B
	JNZ	PARSE6
	RET				; ALL CHARACTERS USED
PARSE7:	MOV	A,B
	ORA	A
	RZ				; ALL SPACES USED
	MVI	A,' '			; SPACES TO END OF EXT.
FILLEX:	CALL	FILL
PARSE8:	RET

;	GET USER NUMBER

GETUSR:	MVI	C,0			; ZERO NUMBER REGISTER
	PUSH	H			; SAVE PLACE
GETULP:	MOV	A,M			; GET A CHARACTER
	INX	H
	SUI	'0'			; REMOVE ASCII
	JC	GOTUSR			; WE HAVE A USER NO.
	CPI	10			; MORE THAN 9
	JNC	GOTUSR			; YES, END OF NUMBER
	MOV	D,A			; SAVE ENTRY
	MOV	A,C			; GET LAST ENTRY
	ADD	A			; * 2
	MOV	B,A			; SAVE IT
	ADD	A			; * 4
	ADD	A			; * 8
	ADD	B			; PLUS N*2 = N*10
	ADD	D			; ADD CURRENT ENTRY
	MOV	C,A			; STORE RESULT
	JMP	GETULP			; GET ANOTHER DIGIT
GOTUSR:	DCX	H			; POINT TO LAST CHARACTER
	POP	D
	XCHG
	CALL	CPHD			; ANY NUMBER ENTERED?
	JNZ	GETUX			; YES
	STC				; ELSE, MARK NO NUMBER
	RET
GETUX:	MOV	A,C
	CPI	32			; A LEGAL NUMBER WILL SET CARRY
	CMC				; SO REVERSE THIS RESULT
	RET

; 	OPEN FILE FOR READ

OPENFIL:
	LXI	D,FCBA
OPENFL1:MVI	C,0FH
	CALL	CBDOS			; OPEN FILE
	INR	A			; SET FLAGS ON RESULT
	RET

;	READ FROM FILE

READFIL:
	XRA	A
	STA	EOFFLG			; CLEAR EOF FLAG
	LXI	H,0
	SHLD	RECCNT			; CLEAR RECORD COUNT
	LHLD	MEMTOP			; GET MEMORY TOP
	LXI	D,-RDBUF
	DAD	D			; GET BUFFER SIZE
	MOV	L,H
	MVI	H,0
	DAD	H			; CONVERT SIZE TO RECORDS
	MOV	B,H
	MOV	C,L			; BC = RECORDS
	LXI	D,RDBUF
	LXI	H,FCBA			; POINT TO READ FCB
READLP:	PUSH	B			; SAVE BUFFER SIZE
	MVI	C,1AH
	CALL	CBDOS			; SET DMA ADDRESS
	XCHG
	MVI	C,14H
	CALL	CBDOS			; READ A RECORD
	ORA	A			; TEST RESULT
	JNZ	READND			; END OF FILE
	PUSH	H
	LHLD	RECCNT
	INX	H			; ELSE, COUNT RECORD
	SHLD	RECCNT
	POP	H
	LXI	B,80H
	DAD	B			; UPDATE DMA ADDRESS
	POP	B
	XCHG
	DCX	B
	MOV	A,B			; TEST IF DONE
	ORA	C
	JNZ	READLP			; READ ANOTHER RECORD
	JMP	READDN
READND:	POP	B
	STA	EOFFLG			; MARK END
READDN:	LHLD	RECCNT			; GET RECORD COUNT
	MOV	B,H
	MOV	C,L			; IN BC
	RET

;	CONVERT RECORDS TO BYTES

REC2BYT:PUSH	H
	MOV	H,B
	MOV	L,C			; HL = RECORDS
	MVI	B,7
RECLP:	DAD	H			; MUL BY 128
	DCR	B
	JNZ	RECLP
	MOV	B,H
	MOV	C,L			; BC = RESULT
	POP	H
	RET

;	PRINT NAME OF CURRENT FILE (HL POINTS TO NAME)

PNAME:
	MVI	B,8
PNAMLP:	MOV	A,M			; GET A CHARACTER
	INX	H
	CPI	' '
	JZ	SKSPC			; SKIP SPACES
	CALL	SCOUT			; PRINT FILE NAME
SKSPC:	DCR	B
	JNZ	PNAMLP
	MVI	A,'.'
	CALL	SCOUT
	MVI	B,3
PEXTLP:	MOV	A,M
	INX	H
	CPI	' '
	JZ	SKSPC1			; SKIP SPACES
	CALL	SCOUT			; PRINT EXTENSION
SKSPC1:	DCR	B
	JNZ	PEXTLP
	RET

;	GET INPUT STRING (AL = LIMIT)

GETSTR:
	STA	MAXCHR			; SET MAX CHARACTERS ALLOWED
	LXI	H,LINEBUF		; PUT INPUT HERE
	MVI	B,0			; SET A COUNTER
GETST1	CALL	GETCHR			; GET A CHARACTER
	CPI	13
	JZ	LINEND			; YES, END
	CPI	8			; BACK SPACE?
	JZ	BACKUP
	CPI	7FH			; DELETE?
	JZ	BACKUP
	CPI	3			; CONTROL-C?
	RZ				; YES, ABORT
	CPI	9			; TAB?
	JZ	LINTAB			; YES, INPUT TAB
	CPI	' '			; OTHER CONTROL CHARACTER?
	JC	GETST1			; IF SO, DON'T TAKE IT
LINTAB	MOV	M,A			; ELSE, STORE CHARACTER
	CALL	SCOUT			; PRINT IT
	INX	H			; INCREMENT POINTER
	INR	B			; INCREMENT COUNTER
	MOV	A,B
	CPI	40			; MAX CHARACTERS
MAXCHR	EQU	$-1
	JZ	LINEND			; YES
	JMP	GETST1			; GET ANOTHER CHARACTER
BACKUP	INR	B
	DCR	B			; SET FLAGS
	JZ	GETST1			; TAKE NO ACTION
	LXI	D,BACKMSG
	CALL	DSPMSG			; BACK UP
	DCR	B			; DECREMENT COUNTER
	DCX	H			; AND POINTER
	JMP	GETST1
LINEND	MVI	M,0			; TERMINATE STRING
	MOV	A,B			; GET COUNT
	ORA	A			; IS IT ZERO?
	RZ				; RETURN IF SO
	LXI	H,LINEBUF		; POINT TO BUFFER AGAIN
	MOV	E,L
	MOV	D,H			; POINTER TO DE
	INR	B			; COUNT TRAILING ZERO
SOS:	MOV	A,M
	INX	H
	CPI	' '			; SPACE?
	JNZ	NOTSP			; NO
	DCR	B			; ELSE, DECREMENT COUNTER
	JNZ	SOS			; LOOK FOR NON-SPACE
NOTSP:	DCX	H			; POINT TO FIRST NON-SPACE
	CALL	CPHD			; ANY SPACES?
	JZ	GETSX			; IF NOT, EXIT
	CALL	MOVE			; MOVE STRING DOWN
GETSX:	XRA	A
	INR	A			; SET NZ
	RET

;	MAP LOWER TO UPPER CASE

MUC:
	CPI	'a'
	JC	MUCX
	CPI	'z'+1
	JNC	MUCX
	ANI	5FH			; CAPITALIZE
MUCX:	RET

;	DISPLAY COMMAND LINE

DISP$CMD$LINE:
	LXI	D,INIT$CMD$LINE
	CALL	DSPMSG
	MVI	B,NCMDS
	LHLD	CUR$CMD
	PUSH	H			; SAVE CURRENT COMMAND
	LXI	H,0
	SHLD	CUR$CMD	
DISPC$LP:
	CALL	NRM$CURC
	LHLD	CUR$CMD
	INX	H
	SHLD	CUR$CMD
	DCR	B
	JNZ	DISPC$LP
	POP	H
	SHLD	CUR$CMD
	CALL 	REV$CURC
	RET

;	DISPLAY CURRENT COMMAND

REV$CURC:
	LXI	D,REV$MSG
	CALL	DSPMSG
NRM$CURC:
	LHLD	CUR$CMD
	DAD	H
	LXI	D,CMD$LINE$TBL
	DAD	D			; POINT TO PLACE IN TABLE
	MOV	E,M
	INX	H
	MOV	D,M			; DE POINTS TO COMMAND
	CALL	DSPMSG
	LXI	D,NRM$MSG
	CALL	DSPMSG
	RET

;	DISPLAY DIRECTORY ON SCREEN

DIRECTORY$DISPLAY:
	LXI	D,DIR$HDR
	CALL	DSPMSG
	LDA	CURUSR
	MOV	L,A
	MVI	H,0
	CALL	DEC0			; DISPLAY CURRENT USER NO.
	LXI	D,DRV$MSG
	CALL	DSPMSG
	LDA	CURDSK
	CALL	SCOUT
	MVI	A,':'
	CALL	SCOUT
DISENTS:
	LHLD	CUR$ENT
	PUSH	H			; save current entry pointer
	LXI	H,0
	SHLD	CUR$ENT			; reset for display
DISENT0:LHLD	FILECNT
	MOV	A,H
	ORA	L			; ANY FILES?
	JNZ	DISPENTS		; YES
DISENT1:LXI	D,NO$FIL$MSG
	CALL	DSPMSG
	POP	H
	LXI	H,0
	SHLD	CUR$ENT	
	JMP	DIR$FREE		; SHOW DISK FREE SPACE
DISPENTS:
	LXI	H,DIRPTR		; POINT TO DIRECTORY POINTER
	PUSH	H
	LHLD	PAGECNT			; GET CURRENT COUNT
	MOV	B,H
	MOV	C,L			; IN BC
	LHLD	FILECNT
	MOV	A,C			; CMP BC,HL
	SUB	L
	MOV	A,B
	SBB	H			; REACHED FILE COUNT?
	JC	OKCNT			; NO
	LXI	B,0			; ELSE, START OVER
	LXI	H,0
	SHLD	PAGECNT	
OKCNT:	MOV	H,B
	MOV	L,C
	DAD	H			; DOUBLE COUNT
	MOV	C,L
	MOV	B,H
	POP	H
	DAD	B			; ADD TO POINTER POS.
DIS$LOOP:
	PUSH	H			; SAVE DIRECTORY POINTER
	LHLD	CUR$ENT
	DAD	H
	DAD	H
	LXI	D,DIR$ENT$ADDR
	DAD	D			; POINT TO CURSOR ADDRESS
	MVI	B,4
ADR$LUP:
	MOV	A,M			; address cursor to entry position
	CALL	SCOUT
	INX	H
	DCR	B
	JNZ	ADR$LUP
	POP	H			; GET DIRECTORY POINTER
	MOV	E,M
	INX	H
	MOV	D,M			; GET FILE NAME ADDRESS
	MOV	A,D
	ANI	80H			; TEST FOR FLAG
	JZ	NOFLG			; NO FLAG
	MOV	A,D
	ANI	7FH			; REMOVE FLAG
	MOV	D,A
	PUSH	D
	LXI	D,FLG$MSG
	CALL	DSPMSG			; SHOW FLAG ON FILE
	POP	D
NOFLG:	XCHG
	CALL	PNAME			; PRINT FILE NAME
	XCHG
ENT$FIN:
	INX	H			; MOVE TABLE POINTER
	PUSH	H
	LHLD	CUR$ENT
	INX	H			; COUNT SCREEN FILE
	SHLD	CUR$ENT
	XCHG
	LHLD	PAGECNT
	DAD	D
	XCHG
	LHLD	FILECNT
	CALL	CPHD			; ALL FILES DONE?
	POP	H
	JZ	ALLIN
	LDA	CUR$ENT
	CPI	85			; SCREEN FULL?
	JC	DIS$LOOP
	MVI	A,1
	STA	MOREFLG			; INDICATE MORE AVAILABLE
ALLIN:
	LDA	MOREFLG
	ORA	A			; MORE FILES?
	JZ	ALLIN1			; NO
	LXI	D,MORE$DIR
	CALL	DSPMSG			; ELSE, SHOW "MORE.."
ALLIN1:	LHLD	CUR$ENT
	SHLD	MAX$ENT
	POP	H
	SHLD	CUR$ENT			; RESTORE CURRENT ENTRY
	CALL	CUR$ENT$REV
	LXI	D,FSPC$MSG
	CALL	DSPMSG			; SAY "FLAG BYTES"
	LHLD	FLAG			; GET FLAG BYTES
	CALL	DECOUT			; SHOW THEM
SHOWBOT:
	LXI	D,SEL$DISP
	CALL	DSPMSG
	CALL	CUR$ENT$DIS
	CALL	CUR$ENT$SIZE
DIR$FREE:
	LXI	D,FREE$MSG
	CALL	DSPMSG			; SAY "FREE SPACE"
	LHLD	FREE			; GET FREE SPACE
	CALL	DECOUT			; SHOW IT
	RET

;	GET DIRECTORY FILES, STORE IN BUFFER

GET$DIRECT:
	LXI	D,WILDCARD+1
	MVI	B,11
	MVI	A,'?'
	CALL	FILL			; RESET WILDCARD SPEC.
GET$DIR0:
	LXI	H,0
	SHLD	FILECNT			; CLEAR FILE COUNT
	SHLD	PAGECNT			; AND PAGE COUNT
	SHLD	CUR$ENT			; AND CURRENT ENTRY
	SHLD	FLAG			; AND FLAG BYTES
	MOV	A,L
	STA	MOREFLG			; AND MORE FLAG
	STA	FLAGCNT			; AND FLAG COUNT
GET$DIR1:
	LXI	H,0
	SHLD	FREE			; CLEAR FREE SPACE
	LXI	H,DIR$ENT$BUF
	SHLD	BDPTR
	MVI	C,26
	LXI	D,BUF
	CALL	CBDOS			; SET DEFAULT DMA
	MVI	C,17	 		; GET 'SEARCH FIRST' FNC
	LXI	D,WILDCARD		; GET FCB ADDRESS
	CALL	CBDOS			; READ FIRST
	INR	A			; WERE THERE ANY?
	JNZ	SOME			; GOT SOME
	JMP	GETFREE
MORDIR:
	MVI	C,18			; SEARCH NEXT
	LXI	D,WILDCARD
	CALL	CBDOS			; READ DIR ENTRY
	INR	A			; CHECK FOR END (0FFH)
	JZ	NFILES			; NO MORE
SOME:	DCR	A			; UNDO PREV 'INR A'
	ANI	3			; MAKE MODULUS 4
	ADD	A			; MULTIPLY...
	ADD	A			; ..BY 32 BECAUSE
	ADD	A			; ..EACH DIRECTORY
	ADD	A			; ..ENTRY IS 32
	ADD	A			; ..BYTES LONG
	LXI	H,81H			; POINT TO BUFFER
;					; (SKIP TO FN/FT)
	ADD	L			; POINT TO ENTRY
	MOV	L,A			; SAVE (CAN'T CARRY TO H)
;	LXI	D,11
;	DAD	D			; SKIP TO EXTENT NO.
;	MOV	A,M			; GET IT
;	POP	H			; RESTORE ADDRESS
;	ORA	A			; ZERO EXTENT?
;	JZ	MOVEN			; YES, MOVE FILE NAME
	PUSH	H
	LHLD	FILECNT			; ELSE, GET FILE COUNT
	MOV	A,H
	ORA	L			; FIRST FILE?
	POP	H
	JZ	MOVEN			; YES
	MOV	B,A			; COUNT IN B
	MVI	C,11			; GET COMPARE COUNT
	LXI	D,DIR$ENT$BUF		; POINT TO BUFFER
FIND:	PUSH	B			; SAVE REGISTERS
	PUSH	D
	PUSH	H
COMP:	LDAX	D
	CMP	M			; COMPARE ENTRIES
	JNZ	NOCOMP
	INX	D
	INX	H
	DCR	C
	JNZ	COMP			; CONTINUE FOR CHAR COUNT
NOCOMP:	POP	H			; RESTORE REGISTERS
	POP	D
	POP	B
	JZ	REPLACE			; FOUND MATCH, REPLACE ENTRY
	PUSH	H
	XCHG				; HL = TABLE ADDRESS
	LXI	D,15
	DAD	D			; MOVE TO NEXT ENTRY
	XCHG
	POP	H
	DCR	B			; DECREMENT COUNT
	JNZ	FIND			; TRY AGAIN
	JMP	MOVEN			; NO MATCH, NEW ENTRY
REPLACE:PUSH	H			; SAVE NEW ENTRY ADDR
	PUSH	D			; AND OLD ONE
	LXI	B,11
	DAD	B			; MOVE TO NEW EXTENT NO.
	MOV	A,M			; GET IT
	POP	H			; GET OLD ENTRY
	PUSH	H			; SAVE AGAIN
	DAD	B			; MOVE TO ITS EXTENT NO.
	CMP	M			; COMPARE
	POP	D			; RESTORE REGISTERS
	POP	H
	JC	SKIPRP			; OLD BIGGER, SKIP REPLACEMENT
	MVI	B,15			; MOVE 15 CHARACTERS
REP1:	MOV	A,M			; GET A CHARACTER
	STAX	D			; MOVE IT TO TABLE
	INX	H
	INX	D			; INCREMENT POINTERS
	DCR	B			; DECREMENT COUNTER
	JNZ	REP1			; CONTINUE UNTIL DONE
SKIPRP:	JMP	MORDIR			; GET ANOTHER ENTRY

;	MOVE ENTRY TO BUFFER

MOVEN:	XCHG				; ENTRY TO DE
	LHLD	BDPTR			; NEXT ENTRY TO HL
	MVI	B,15			; ENTRY LENGTH
MOVEN1:	LDAX	D			; GET ENTRY CHAR
	MOV	M,A			; STORE IN BUFFER
	INX	D
	INX	H
	DCR	B			; MORE?
	JNZ	MOVEN1
	SHLD	BDPTR			; SAVE UPDATED ADDR
	LHLD	FILECNT			; GET PREV COUNT
	INX	H
	SHLD	FILECNT
	JMP	MORDIR
NFILES:	CALL	UNSORT			; SET POINTER TABLE
	LDA	SORTFLG
	ORA	A			; SORT FILES?
	JZ	GETFREE			; NO
	CALL	SORT			; SORT THE DIRECTORY
GETFREE:
	MVI	C,31
	CALL	BDOS
	INX	H
	INX	H			; MOVE TO BLOCK SHIFT
	MOV	A,M			; GET IT
	DCR	A
	DCR	A
	DCR	A			; MAKE IT START AT ZERO
	PUSH	PSW			; SAVE IT
	INX	H			; MOVE TO DISK SIZE
	INX	H
	INX	H
	MOV	E,M			; PUT IT IN DE
	INX	H
	MOV	D,M
	INX	D			; ADD 1
	XCHG
	SHLD	DSIZE			; SAVE DISK SIZE
;	XCHG
;	INX	H			; MOVE TO ALLOCATION
;	INX	H
;	INX	H
;	MOV	A,M			; GET IT
;	STA	ALLOC			; SAVE IT
	POP	PSW			; GET BLOCK SHIFT (-3)
	LXI	H,1			; HL = 1 K
	ORA	A			; SET FLAGS
	JZ	SIZE1			; GOT BLOCK SIZE
BLKLP	DAD	H			; DOUBLE BLOCK SIZE
	DCR	A			; IS THIS IT
	JNZ	BLKLP			; NO, DOUBLE AGAIN
SIZE1	;MOV	A,L
;	STA	BSIZE			; SAVE BLOCK SIZE FOR LATER
	PUSH	H			; SAVE BLOCK SIZE
	MVI	C,27
	CALL	BDOS			; GET ALLOCATION MAP
	POP	D			; DE = BLOCK SIZE
SIZE2	MVI	B,8			; 8 BITS PER BYTE
	MOV	A,M			; GET A BYTE
	PUSH	H			; SAVE MAP ADDRESS
SIZE3	RAL				; TEST FOR A BIT
	JC	SIZE4			; IT IS SET
	LHLD	FREE			; INCREMENT FREE SPACE
	DAD	D
	SHLD	FREE
	JMP	SIZE5
SIZE4	;LHLD	USED			; INCREMENT USED SPACE
;	DAD	D
;	SHLD	USED
SIZE5	LHLD	DSIZE			; GET DISK SIZE
	DCX	H			; SUBTRACT THIS GROUP
	SHLD	DSIZE
	PUSH	PSW			; SAVE MAP BYTE
	MOV	A,H
	ORA	L			; DONE WITH DISK?
	JZ	SIZE6			; IF SO, LEAVE
	POP	PSW			; ELSE RESTORE MAP BYTE
	DCR	B			; DONE WITH BYTE?
	JNZ	SIZE3			; NO, TEST ANOTHER BIT
	POP	H			; ELSE, GET MAP ADDRESS
	INX	H			; INCREMENT IT
	JMP	SIZE2			; GET NEXT BYTE
SIZE6	POP	PSW			; RESTORE PSW
	POP	H			; AND HL
;	XCHG				; HL = BLOCK SIZE
;	CALL	CHL			; COMPLEMENT IT
;	XCHG				; PUT RESULT IN DE
;	LHLD	USED			; GET USED SPACE
;	LDA	ALLOC			; AND ALLOCATION VECTOR
;	RAL				; TEST FOR A BIT
;	JNC	SIZE8			; NONE SET, NO ALLOCATED SPACE
SIZE7	;DAD	D			; SUBTRACK A BLOCK
;	RAL				; TEST FOR A BIT
;	JC	SIZE7			; IT WAS SET, SUBTRACT BLOCK
SIZE8	;SHLD	USED			; SAVE UPDATED USED SPACE
	RET

;	UNSORT DIRECTORY (SET POINTERS FOR SORT)

UNSORT:
	LHLD	FILECNT			; GET FILE COUNT
	MOV	B,H
	MOV	C,L			; IN BC
	LXI	D,DIR$ENT$BUF		; POINT TO DIR BUFFER
	LXI	H,DIRPTR		; AND POINTER
UNSLP:	MOV	M,E			; STORE ENTRY ADDRESS
	INX	H
	MOV	M,D
	INX	H
	XCHG
	PUSH	B
	LXI	B,15
	DAD	B			; MOVE TO NEXT ONE
	POP	B
	XCHG
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	UNSLP			; CONTINUE TILL DONE
	RET

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'FILECNT' = NUMBER OF STRINGS TO BE SORTED
;		'DIRPTR'  = START OF POINTER TABLE
;		POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN
;		ALPHABETICAL ORDER.
; 		STRING DATA TABLE IS UNCHANGED.

SORT:
	LHLD	FILECNT
	MOV	A,H
	ORA	A
	JNZ	SORT1
	MOV	A,L
	CPI	2			; 2 OR MORE FILES?
	RC				; NO SORT NEEDED
SORT1:	SHLD	VARM
SETM:	LHLD	VARM
	MOV	A,H
	ORA	A
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	SHLD	VARM			; VARM = VARM / 2 
	MOV	A,H
	ORA	L
	JNZ	NOTEND	
	RET				; IF END OF SORT
NOTEND:	LXI	H,1
	SHLD	VARJ			; VARJ = 1
	LHLD	VARM
	XCHG
	LHLD	FILECNT
	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	SHLD	VARK			; VARK = FILECNT - VARM
SETI:	LHLD	VARJ
	SHLD	VARI			; VARI = VARJ
SETL:	LHLD	VARM
	XCHG
	LHLD	VARI
	DAD	D
	SHLD	VARL			; VARL = VARI + VARM
	CALL	SYMVAL			; HL = START OF DATA POINTED BY VARL
	PUSH	H
	LHLD	VARI
	CALL	SYMVAL
	POP	D			; HL AND DE POINT TO START OF STRINGS
	MVI	B,11			; *GET STRING LENGTH
CMPLP:	LDAX	D
	CMP	M			; COMPARE THE STRINGS
	JNZ	NOMACH
	INX	H
	INX	D
	DCR	B
	JNZ	CMPLP
NOMACH:	JNC	SETJ			; IF NO REARRANGEMENT REQUIRED

;  SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	LHLD	VARI
	CALL	TABADD
	PUSH	H			; STACK = POINTER DATA FOR (VARI)
	LHLD	VARL
	CALL	TABADD			; HL = POINTER DATA FOR (VARL)
	POP	D
	MOV	C,M
	INX	H
	MOV	B,M
	PUSH	B
	XCHG
	MOV	C,M
	INX	H
	MOV	B,M
	XCHG
	MOV	M,B
	DCX	H
	MOV	M,C
	XCHG
	POP	B
	MOV	M,B
	DCX	H
	MOV	M,C

;  SWITCH COMPLETED

	LHLD	VARM
	XCHG
	LHLD	VARI
	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	SHLD	VARI			; VARI = VARI - VARM
	DCX	H
	MOV	A,H
	ORA	A
	JP	SETL			; IF VARI >= 1
SETJ:	LHLD	VARJ
	INX	H
	SHLD	VARJ			; VARJ = VARJ + 1
	XCHG
	LHLD	VARK
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JNC	SETI
	JMP	SETM			; IF VARJ > VARK

;  TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
; 	ENTRY: HL = INTEGER VALUE ( 1 -> N )
; 	EXIT:  HL = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DCX	H			; START AT ZERO
	DAD	H			; HL = [(ORIGINAL BX) - 1] * 2
	LXI	D,DIRPTR
	DAD	D
	RET

;  SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
; 	ENTRY: HL = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
; 	EXIT:  HL = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	MOV	A,H
	ANI	7FH			; REMOVE FLAG BIT
	MOV	H,A
	RET

;	DECOUT - PRINT HL IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT: CALL	DEC0
	MVI	A,'K'			; PRINT "K" AFTER NUMBER
	CALL	SCOUT
	RET
DEC0:	PUSH	B
	PUSH	D
	PUSH	H		;SAVE REGISTERS
	LXI	B,-10		;RADIX FOR CONVERSION
	LXI	D,-1
DX:	DAD	B		;DIVIDE BY 10
	INX	D
	JC	DX
	LXI	B,10
	DAD	B
	XCHG			;DE = DIGIT, HL = NUMBER/10
	MOV	A,H
	ORA	L		;DONE?
	CNZ	DEC0		;CALL RECURSIVELY UNTIL DONE
	MOV	A,E		;GET CHARACTER TO PRINT
	ADI	'0'		;ADD ASCII BIAS
	CALL	SCOUT		;PRINT IT
	POP	H		;RESTORE REGISTERS
	POP	D
	POP	B
	RET

;	DISPLAY CURRENT ENTRY

CUR$ENT$REV:
	LXI	D,REV$MSG
	CALL	DSPMSG
CUR$ENT$NRM:
	LHLD	CUR$ENT
	DAD	H
	DAD	H
	LXI	D,DIR$ENT$ADDR
	DAD	D
	MVI	B,4
ENT$ADR$LOOP:
	MOV	A,M
	CALL	SCOUT
	INX	H
	DCR	B
	JNZ	ENT$ADR$LOOP
CUR$ENT$DIS:
	LHLD	PAGECNT			; GET PAGE COUNT
	XCHG
	LHLD	CUR$ENT			; GET CURRENT ENTRY NO.
	DAD	D			; ADD PAGE COUNT
	DAD	H			; MPY BY 2
	LXI	D,DIRPTR
	DAD	D			; FIND PLACE IN DIR PTR
	MOV	A,M
	INX	H
	MOV	H,M			; GET ENTRY ADDRESS
	MOV	L,A
	MOV	A,H
	ANI	7FH			; REMOVE FLAG BIT
	MOV	H,A
	CALL	PNAME			; PRINT FILE NAME
NRM$NOW:
	LXI	D,NRM$MSG
	CALL	DSPMSG
	RET
;
;	SHOW SIZE OF CURRENT FILE
;
CUR$ENT$SIZE:
	LXI	D,SIZ$MSG
	CALL	DSPMSG			; SAY "FILE SIZE"
	CALL	GET$SIZE		; GET SIZE OF FILE
	CALL	DECOUT			; PRINT FILE SIZE

GET$SIZE:
	LHLD	PAGECNT			; GET PAGE COUNT
	XCHG
	LHLD	CUR$ENT			; GET CURRENT ENTRY NO.
	DAD	D			; ADD PAGE COUNT
	DAD	H			; MPY BY 2
	LXI	D,DIRPTR
	DAD	D			; FIND PLACE IN DIR PTR
	MOV	A,M
	INX	H
	MOV	H,M			; GET ENTRY ADDRESS
	MOV	L,A
	MOV	A,H
	ANI	7FH			; REMOVE FLAG BIT
	MOV	H,A
	LXI	D,11
	DAD	D			; MOVE TO EXTENT NO.
	MOV	A,M			; GET IT
	PUSH	H			; SAVE EXTENT ADDRESS
	MOV	L,A
	MVI	H,0			; HL = EXTENT NO.
	DAD	H			; MULTIPLY BY 16
	DAD	H
	DAD	H
	DAD	H
	POP	D			; GET EXTENT ADDRESS
	INX	D			; MOVE TO RECORD COUNT
	INX	D
	INX	D
	LDAX	D			; GET IT
	ADI	7			; ADD 7
	RRC				; DIVIDE BY 8
	RRC
	RRC
	ANI	00011111B		; NOW, IT EQUALS K'S
;	PUSH	PSW			; SAVE IT
;	LDA	BSIZE			; GET BLOCK SIZE
;	DCR	A			; SUBTRACT 1
;	MOV	B,A			; RESULT IN B
;	POP	PSW			; GET RECORD COUNT (IN K'S)
;	ADD	B			; ADD (BSIZE-1)
;	PUSH	PSW			; SAVE RESULT
;	MOV	A,B			; GET BSIZE-1
;	CMA				; COMPLEMENT IT
;	MOV	B,A			; RESULT IN B
;	POP	PSW			; GET COUNT-(BSIZE-1)
;	ANA	B			; ROUND OFF TO GROUP SIZE
	ADD	L			; ADD TO HL
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	RET

;	Get address of current selection

GET$CURRENT:
	LDA	FLG2FLG
	ORA	A			; DOING FLAGS?
	JZ	GET1			; NO
	LHLD	CUR$ADR			; ELSE, GET FILE ADDRESS PTR.
	PUSH	B
	PUSH	H
	LHLD	TFCNT			; AND TEMP. COUNT
	MOV	B,H
	MOV	C,L
	POP	H
	MOV	A,B
	ORA	C			; FILES USED UP?
	JZ	GOTEND			; YES
GETLP:	MOV	E,M
	INX	H
	MOV	D,M			; GET ADDRESS
	INX	H
	MOV	A,D
	ANI	80H			; TEST FOR FLAGGED FILE
	JNZ	GOTFLG			; GOT ONE
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	GETLP			; LOOP UNTIL END OR ONE FOUND
GOTEND:	POP	B
	STC				; NONE FOUND, FLAG END OF FILES
	RET
GOTFLG:	DCX	B			; COUNT THIS FILE
	PUSH	H
	MOV	H,B
	MOV	L,C
	SHLD	TFCNT			; SAVE COUNT
	POP	H
	POP	B
	SHLD	CUR$ADR			; SAVE FILE PTR ADDRESS
	XCHG				; ENTRY ADDRESS TO HL
	JMP	GETX	
GET1:	LHLD	PAGECNT			; GET PAGE COUNT
	XCHG
	LHLD	CUR$ENT			; GET CURRENT NO.
	DAD	D			; ADD PAGE COUNT
	DAD	H			; MPY BY 2
	LXI	D,DIRPTR
	DAD	D			; FIND PLACE IN DIR PTR
	MOV	A,M
	INX	H
	MOV	H,M			; GET ENTRY ADDRESS
	MOV	L,A
GETX:	MOV	A,H
	ANI	7FH			; REMOVE FLAG BIT
	MOV	H,A
	PUSH	H			; SAVE CURRENT NAME ADDRESS
	LXI	D,FCBA
	PUSH	D
	MVI	B,36
	XRA	A
	CALL	FILL			; CLEAR FCB
	POP	D			; GET FCB ADDRESS
	PUSH	D
	INX	D			; MOVE TO NAME AREA
	MVI	B,11
	CALL	MOVE			; MOVE NAME INTO FCB
	POP	H
	LXI	D,FCBB
	MVI	B,36
	CALL	MOVE			; COPY FCBA TO FCBB
	POP	H
	ORA	A			; CLEAR CARRY
	RET

;	CONVERT BINARY BYTE TO HEX ASCII

CVTBYTE:
	PUSH	PSW
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC				; MOVE HIGH NIBBLE DOWN
	CALL	CVTNIB			; PRINT IT
	POP	PSW
	ANI	0FH
CVTNIB:	ADI	90H			; CONVERT TO HEX ASCII
	DAA
	ACI	40H
	DAA
;	JMP	SCOUT

;	SCOUT - SINGLE CHARACTER OUTPUT

SCOUT:	PUSH	PSW
	PUSH	B
	PUSH	H
	PUSH	D
	MOV	E,A
	MVI	C,6
	CALL	BDOS
	POP	D
	POP	H
	POP	B
	POP	PSW
	RET

;	CALL BDOS, REGISTERS SAVED

CBDOS:	PUSH	H
	PUSH	B
	PUSH	D
	CALL	BDOS
	POP	D
	POP	B
	POP	H
	RET

;	DISPLAY MESSAGE ON SCREEN

DSPMSG:	LDAX	D
	CPI	'$'			; END OF STRING?
	RZ
	CALL	SCOUT
	INX	D
	JMP	DSPMSG

;	GET A CHARACTER FROM THE CONSOLE

GETCHR:	PUSH	D
	MVI	C,6
	MVI	E,0FFH
GETCH1:	CALL	CBDOS
	ORA	A
	JZ	GETCH1			; WAIT FOR CHARACTER
	POP	D
	RET

;	MOVE B BYTES FROM (HL) TO (DE)

MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET

;	FILL (DE) WITH B BYTES OF A

FILL:	STAX	D
	INX	D
	DCR	B
	JNZ	FILL
	RET

;	COMPARE HL TO DE

CPHD:	MOV	A,L
	XRA	E
	RNZ
	MOV	A,H
	XRA	D
	RET
;
KEY$TABLE:
	DB	08h
	DW	DOBS
	DB	09h
	DW	DOTAB
	DB	0dh
	DW	DOCR
	DB	20h
	DW	DOSPC
	DB	'C'
	DW	DOCOPY
	DB	'E'
	DW	DOERA
	DB	'F'
	DW	DOFLAG
	DB	'H'
	DW	DOHLP
	DB	'L'
	DW	DOHEX
	DB	'M'
	DW	DOMORE
	DB	'N'
	DW	DONEW
	DB	'P'
	DW	DOPRT
	DB	'Q'
	DW	DOQUIT
	DB	'R'
	DW	DOREN
	DB	'S'
	DW	DOSORT
	DB	'T'
	DW	DOTYPE
	DB	'U'
	DW	DOUNSRT
	DB	'W'
	DW	DOWILD
	DB	0
Z100TBL:
	DB	'~'
	DW	DOHELP
	DB	'A'
	DW	DOUP
	DB	'B'
	DW	DODWN
	DB	'C'
	DW	DORT
	DB	'D'
	DW	DOLFT
	DB	'H'
	DW	DOHOM
	DB	'S'
	DW	DOHELP
	DB	0

CMD$JMP$TBL:
	DW	DOCOPY
	DW	DOERA
	DW	DOFLAG
	DW	DOHLP
	DW	DOHEX
	DW	DOMORE
	DW	DONEW
	DW	DOPRT
	DW	DOQUIT
	DW	DOREN
	DW	DOSORT
	DW	DOTYPE
	DW	DOUNSRT
	DW	DOWILD

CUR$CMD	DW	3
CUR$ENT	DW	0
MAX$ENT	DW	0
FILECNT	DW	0			; FILE COUNT
PAGECNT	DW	0			; PAGE FILE COUNT
MOREFLG	DB	0			; MORE FILES FLAG
BDPTR	DW	0			; POINTER FOR BUILDING DIRECTORY
VARI	DW	0			; SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
SORTFLG	DB	1			; SORT FLAG
FLAGCNT	DB	0			; COUNT OF FILES FLAGGED
FLG2FLG	DB	0			; FILES FLAGGED INDICATOR
TFCNT	DW	0			; TEMP. FILE COUNT
CUR$ADR	DW	0			; CURRENT FILE ADDRESS
DSIZE	DW	0			; DISK SIZE
FREE	DW	0			; DISK FREE SPACE
FLAG	DW	0			; FLAGGED FILE BYTES
LINECNT	DB	0			; LINE COUNT FOR TYPE
ADDRESS	DW	0			; ADDRESS FOR HEX LIST
LASTLIN	DB	0			; LAST LINE SIZE (HEXLIST)
RECCNT	DW	0			; FILE RECORD COUNT
EOFFLG	DB	0			; ENF OF FILE FLAG
CURUSR	DB	0
OLDUSR	DB	0
TMPUSR	DB	0
CURDSK	DB	'A'
OLDDSK	DB	0
;
CMD$LINE$TBL:
	DW	CCMD
	DW 	ECMD
	DW	FCMD
	DW	HCMD
	DW	LCMD
	DW	MCMD
	DW	NCMD
	DW	PCMD
	DW	QCMD
	DW	RCMD
	DW	SCMD
	DW	TCMD
	DW	UCMD
	DW	WCMD
;
NCMDS	EQU	14
MAX$CMD	EQU	13
;
CCMD	DB	27,'Y',23+31,10+31
	DB	'Copy$'
ECMD	DB	27,'Y',23+31,15+31
	DB	'Erase$'
FCMD	DB	27,'Y',23+31,21+31
	DB	'Flag$'
HCMD	DB	27,'Y',23+31,26+31
	DB	'Help$'
LCMD	DB	27,'Y',23+31,31+31
	DB	'Listhex$'
MCMD	DB	27,'Y',23+31,39+31
	DB	'Morefiles$'
NCMD	DB	27,'Y',23+31,49+31
	DB	'Newdisk$'
PCMD	DB	27,'Y',23+31,57+31
	DB	'Print$'
QCMD	DB	27,'Y',23+31,63+31
	DB	'Quit$'
RCMD	DB	27,'Y',24+31,10+31
	DB	'Rename$'
SCMD	DB	27,'Y',24+31,17+31
	DB	'Sort$'
TCMD	DB	27,'Y',24+31,22+31
	DB	'Type$'
UCMD	DB	27,'Y',24+31,27+31
	DB	'Unsort$'
WCMD	DB	27,'Y',24+31,34+31
	DB	'Wildcard$'
;
;	messages
;
cr	EQU	0dh
lf	EQU	0ah
esc	EQU	1bh
;
INIT$MSG	DB	27,'E'		; clear screen
		DB	27,'x1'		; enable 25th line
		DB	27,'t'		; shift keypad
		DB	'$'
;
REV$MSG	DB	27,'p$'
NRM$MSG	DB	27,'q$'
;
FLG$MSG	DB	8,'*$'
;
XIT$MSG	DB	27,'Y',25+31,1+31
	DB	27,'K'
	DB	27,'Y',1+31,1+31
	DB	27,'u'
	DB	27,'E'
CUR$ON	DB	27,'y5'
	DB	'$'
;
INIT$PROMPT	DB	27,'Y',24+31,1+31
		DB	27,'K'
		DB	27,'Y',23+31,1+31
		DB	27,'K'
		DB	27,'y5'
		DB	'$'
;
MSG$PROMPT	DB	27,'Y',24+31,1+31
		DB	27,'K'
		DB	27,'Y',23+31,1+31
		DB	27,'K$'

INIT$CMD$LINE	DB	27,'Y',24+31,1+31
		DB	27,'K'
		DB	27,'Y',23+31,1+31
		DB	27,'K'
		DB	27,'x5'
		DB	'Command: '
		DB	'$'
;
DIR$HDR		DB	27,'Y',1+31,1+31
		DB	27,'pHUG File Manager',ESC,'q'
		DB	' Version 1.0.CPM'
		DB	27,'Y',3+31,1+31
		DB	'Contents of User $'
DRV$MSG		DB	', Drive $'

FSPC$MSG	DB	27,'Y',1+31,44+31
		DB	'Flagged file bytes:           '
		DB	27,'Y',1+31,64+31
		DB	'$'

FREE$MSG	DB	27,'Y',25+31,59+31
		DB	'Free space:           '
		DB	27,'Y',25+31,71+31
		DB	'$'

SIZ$MSG		DB	27,'Y',25+31,38+31
		DB	'File size:        '
		DB	27,'Y',25+31,49+31
		DB	'$'

MORE$DIR	DB	27,'Y',21+31,71+31
		DB	'MORE'
		DB	27,'Y',22+31,71+31
		DB	'FILES..$'
;
SEL$DISP	DB	27,'x1'
		DB	27,'Y',25+31,1+31
		DB	'Current selection:             '
		DB	27,'Y',25+31,20+31
		DB	'$'
;
NO$FIL$MSG	DB	27,'Y',6+31,1+31
		DB	'No files in directory!!$'
;
DEL$ERR$MSG	DB	'Sorry - cannot erase file $'
;
REN$ERR$MSG	DB	'File rename error!$'
;
READ$ERR$MSG	DB	7,'  Error - cannot read file.$'

WRIT$ERR$MSG	DB	7,'  Error - cannot write file.$'

FILE$ERR$MSG	DB	'Error - no file selected!$'
;
DEST$FILE$REQ	DB	'Enter destination file name: $'
;
FILE$EX		DB	7,'  File exists, delete? (Y/N) $'
;
CONFIRM$REQ	DB	'OK to erase current file? (Y/N) $'
;
CONFIRM$REQ1	DB	'OK to erase flagged file(s)? (Y/N) $'
;
ERASING		DB	27,'Y',24+31,1+31
		DB	'Erasing selected file(s)...$'
;
NEW$NAME$REQ	DB	'Enter new file name: $'
;
NEW$DISK$REQ	DB	'New default user number and/or drive: $'
;
WILD$CARD$REQ	DB	'Enter wildcard specification: $'

COPYING		DB	'Copying...',13,10,'$'
;
CLR$SCREEN	DB	27,'Y',1+31,1+31
		DB	27,'E'		; erase all
		DB	27,'Y',25+31,1+31
		DB	27,'K'		; ERASE 25TH LINE
		DB	27,'Y',1+31,1+31
		DB	'$'
;
HLP$VCT		DW	CHLP
		DW	EHLP
		DW	FHLP
		DW	HHLP
		DW	LHLP
		DW	MHLP
		DW	NHLP
		DW	PHLP
		DW	QHLP
		DW	RHLP
		DW	SHLP
		DW	THLP
		DW	UHLP
		DW	WHLP
;
;	help message text
;
CHLP	DB 9,'Copy File',CR,LF,LF
 DB 9,'When  you are prompted for a dest'
 DB 'ination file name,  enter it  in',CR,LF
 DB 9,'the form',CR,LF,LF
 DB 9,'<user no.><drive>:<file name>.<file type>',CR,LF,LF
 DB 9,'The  selected file will then be c'
 DB 'opied to the specified  destina-',CR,LF
 DB 9,'tion.  If any files have been Fla'
 DB 'gged, those files will be copied',CR,LF
 DB 9,'instead of the currently selected'
 DB ' (highlighted) file.',CR,LF
 DB 9,'If you leave off any of the four '
 DB 'elements of a destination  (user',CR,LF
 DB 9,'number,  drive code, file name, f'
 DB 'ile type), that element from the',CR,LF
 DB 9,'source  will be used.   The follo'
 DB 'wing table explains  this.   The',CR,LF
 DB 9,'source for this example is NAME.T'
 DB 'YP on drive A:',CR,LF,LF
 DB 9,'You type:      The result is:',CR,LF,LF
 DB 9,'B:             B:NAME.TYP',CR,LF
 DB 9,'2B:            B:NAME.TYP (on user no. 2)',CR,LF
 DB 9,'B:FILE         B:FILE.TYP',CR,LF
 DB 9,'B:FILE.        B:FILE',CR,LF
 DB 9,'B:FILE.DOC     B:FILE.DOC',CR,LF
 DB 9,'FILE           A:FILE.TYP',CR,LF
 DB 9,'B:.DOC         B:NAME.DOC$'

EHLP	DB 9,'Erase File',CR,LF,LF
 DB 9,'You will be asked for  confirmati'
 DB 'on  to erase the selected (high-',CR,LF
 DB 9,'lighted) or Flagged file(s).  If '
 DB 'you type Y, the selected file(s)',CR,LF
 DB 9,'will be erased.$'

FHLP	DB 9,'Flag File',CR,LF,LF
 DB 9,'The selected file is marked with '
 DB 'a flag.  An asterisk (*) is dis-',CR,LF
 DB 9,'played on the screen before the f'
 DB 'ile name to  indicate  that  the',CR,LF
 DB 9,'file has been flagged.   After yo'
 DB 'u have used this command to mark',CR,LF
 DB 9,'file(s),  the Copy and Erase  com'
 DB 'mands will operate on the marked',CR,LF
 DB 9,'file(s) instead of the currently '
 DB 'selected (highlighted) file.  If',CR,LF
 DB 9,'the selected file already has a f'
 DB 'lag set when you use  this  com-',CR,LF
 DB 9,'mand,  it will be removed.   The '
 DB ' file sizes of all flagged files',CR,LF
 DB 9,'are added together and displayed '
 DB 'at the top of the screen.',CR,LF,LF
 DB 9,'To  remove the flags from all fla'
 DB 'gged files at once,  use the Un-',CR,LF
 DB 9,'sort command,  followed  by the S'
 DB 'ort command if you want the dir-',CR,LF
 DB 9,'ectory sorted.$'

HHLP	DB 9,'HUG File Manager',CR,LF,LF
 DB 9,'The HUG File Manager supports the'
 DB ' following operations: copy, re-',CR,LF
 DB 9,'name, erase, type (on the screen)'
 DB ', list in hex, print, change the',CR,LF
 DB 9,'default  user number or disk,  so'
 DB 'rt or unsort the directory  dis-',CR,LF
 DB 9,'play,  and  specify the displayed'
 DB ' directory via  wildcards.   HFM',CR,LF
 DB 9,'displays the directory from the d'
 DB 'efault disk on the screen,  with',CR,LF
 DB 9,'one  of the entries highlighted. '
 DB '  The indicator (highlighted en-',CR,LF
 DB 9,'try) may be moved using the four '
 DB 'arrow keys on the keyboard.   If',CR,LF
 DB 9,'the  indicator is at the last ent'
 DB 'ry in a column,  the down  arrow',CR,LF
 DB 9,'key will move it to the top of th'
 DB 'e next column.  If the indicator',CR,LF
 DB 9,'is at the last entry on the page,'
 DB '  the down arrow will move it to',CR,LF
 DB 9,'the first entry.  The up arrow ke'
 DB 'y works similarly.  The HOME key',CR,LF
 DB 9,'moves the indicator directly to t'
 DB 'he first entry.',CR,LF,LF
 DB 9,'Near the bottom of the screen is '
 DB 'a command line containing a list',CR,LF
 DB 9,'of  available  commands, with one'
 DB ' of them highlighted.  A command',CR,LF
 DB 9,'may selected by typing the first '
 DB 'character of the command, or  by',CR,LF
 DB 9,'moving  the highlighted command w'
 DB 'ith the SPACE, TAB, or BACKSPACE',CR,LF
 DB 9,'keys  and  selecting it with the '
 DB 'RETURN or ENTER  key.   Specific',CR,LF
 DB 9,'information  about each command m'
 DB 'ay be obtained by  pressing  the',CR,LF
 DB 9,'F1 key with the desired command h'
 DB 'ighlighted.$'

LHLP	DB 9,'List File in Hex',CR,LF,LF
 DB 9,'The file you have selected is dis'
 DB 'played on  the  screen  in  both',CR,LF
 DB 9,'hexadecimal (hex) and ASCII, with'
 DB ' 16 bytes per line.  The listing',CR,LF
 DB 9,'will  pause  every 16 lines (256 '
 DB 'bytes).   Type Control-C to exit',CR,LF
 DB 9,'before the end is reached, or any'
 DB ' other key to continue.$'

MHLP	DB 9,'More Files',CR,LF,LF
 DB 9,'If  there  are more files in a di'
 DB 'rectory than can be displayed on',CR,LF
 DB 9,'the screen,  the words MORE FILES'
 DB ' will appear in the lower  right',CR,LF
 DB 9,'corner.   This command can then b'
 DB 'e used to display the additional',CR,LF
 DB 9,'files.   If you use this command '
 DB 'when the screen shows the end of',CR,LF
 DB 9,'the directory, the beginning will'
 DB ' be re-displayed.',CR,LF,LF
 DB 9,'If all the files can be displayed'
 DB ' at once,  this  command  is not',CR,LF
 DB 9,'active.$'

NHLP	DB 9,'New User number/Disk',CR,LF,LF
 DB 9,'You will be prompted to enter a n'
 DB 'umber  (0-31)  to  designate the',CR,LF
 DB 9,'new active user number,  and a le'
 DB 'tter (A-P)  to designate the new',CR,LF
 DB 9,'active  drive.   Do  not leave an'
 DB 'y spaces between the user number',CR,LF
 DB 9,'and the drive letter.   You can o'
 DB 'mit either the  user  number  or',CR,LF
 DB 9,'drive letter to leave the setting'
 DB ' intact.  Note that HFM supports',CR,LF
 DB 9,'user numbers 0-31, but the system'
 DB ' command processor only supports',CR,LF
 DB 9,'numbers  0-15.   User numbers 16-'
 DB '31 will not be accessable at the',CR,LF
 DB 9,'command level.$'

PHLP	DB 9,'Print File',CR,LF,LF
 DB 9,'The currently selected file is co'
 DB 'pied to your printer.$'

QHLP	DB 9,'Quit File Manager',CR,LF,LF
 DB 9,'The HUG File Manager returns cont'
 DB 'rol to the operating system.$'

RHLP	DB 9,'Rename File',CR,LF,LF
 DB 9,'You will be prompted for a new na'
 DB 'me for the selected file.    The',CR,LF
 DB 9,'file will then be renamed.$'

SHLP	DB 9,'Sort Directory',CR,LF,LF
 DB 9,'The directory is sorted alphabeti'
 DB 'cally and displayed in that form',CR,LF
 DB 9,'on the screen.   This is the norm'
 DB 'al condition when the program is',CR,LF
 DB 9,'started.$'

THLP	DB 9,'Type File',CR,LF,LF
 DB 9,'The contents of the text file you'
 DB ' have selected are displayed  on',CR,LF
 DB 9,'the screen.  The display will pau'
 DB 'se each time 23 lines have  been',CR,LF
 DB 9,'printed.   Type  Control-C  to ex'
 DB 'it before the file has been com-',CR,LF
 DB 9,'pletely printed, or any other key'
 DB ' to continue.$'

UHLP	DB 9,'Unsort/Unflag Directory',CR,LF,LF
 DB 9,'The directory is unsorted and the'
 DB ' file names are displayed on the',CR,LF
 DB 9,'screen  in  the  order  in  which'
 DB '  they  are  stored  in the disk',CR,LF
 DB 9,'directory.   Any  flags  that  we'
 DB 're placed on files with the Flag',CR,LF
 DB 9,'command are removed.$'

WHLP	DB 9,'Wildcard Specification',CR,LF,LF
 DB 9,'You will be prompted for a wild c'
 DB 'ard specification that will  de-',CR,LF
 DB 9,'termine  which  files from the cu'
 DB 'rrent directory are shown on the',CR,LF
 DB 9,'screen.   For example,  if  you  '
 DB 'want to see only files ending in',CR,LF
 DB 9,'.ASM, you can enter *.ASM as the '
 DB 'wildcard specification.  To show',CR,LF
 DB 9,'show all files in the current dir'
 DB 'ectory again,  use  this command',CR,LF
 DB 9,'and enter *.* as the specificatio'
 DB 'n.  Note:  The wildcard specifi-',CR,LF
 DB 9,'cation  is  cleared to show all f'
 DB 'iles when the Newdisk command is',CR,LF
 DB 9,'used.$'

;
WAITKEY	DB	27,'Y',25+31,1+31
	DB	27,'K'
	DB	'Type any character to return to directory menu..$'
WAITKEY1:
	DB	27,'Y',25+31,1+31
	DB	27,'K',7
WAITKEY2:
	DB	'Type any character..$'

CRLF	DB	13,10,'$'
BACKMSG	DB	8,' ',8,'$'
;
TOMSG	DB	' to $'
BEGLIN	DB	':  $'
SEPMSG	DB	'  ',27,'F`',27,'G$'

WILDCARD	DB	0,'????????????',0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
;
DIR$ENT$ADDR:
	DB	27,'Y',5+31,2+31
	DB	27,'Y',6+31,2+31
	DB	27,'Y',7+31,2+31
	DB	27,'Y',8+31,2+31
	DB	27,'Y',9+31,2+31
	DB	27,'Y',10+31,2+31
	DB	27,'Y',11+31,2+31
	DB	27,'Y',12+31,2+31
	DB	27,'Y',13+31,2+31
	DB	27,'Y',14+31,2+31
	DB	27,'Y',15+31,2+31
	DB	27,'Y',16+31,2+31
	DB	27,'Y',17+31,2+31
	DB	27,'Y',18+31,2+31
	DB	27,'Y',19+31,2+31
	DB	27,'Y',20+31,2+31
	DB	27,'Y',21+31,2+31
	DB	27,'Y',5+31,16+31
	DB	27,'Y',6+31,16+31
	DB	27,'Y',7+31,16+31
	DB	27,'Y',8+31,16+31
	DB	27,'Y',9+31,16+31
	DB	27,'Y',10+31,16+31
	DB	27,'Y',11+31,16+31
	DB	27,'Y',12+31,16+31
	DB	27,'Y',13+31,16+31
	DB	27,'Y',14+31,16+31
	DB	27,'Y',15+31,16+31
	DB	27,'Y',16+31,16+31
	DB	27,'Y',17+31,16+31
	DB	27,'Y',18+31,16+31
	DB	27,'Y',19+31,16+31
	DB	27,'Y',20+31,16+31
	DB	27,'Y',21+31,16+31
	DB	27,'Y',5+31,30+31
	DB	27,'Y',6+31,30+31
	DB	27,'Y',7+31,30+31
	DB	27,'Y',8+31,30+31
	DB	27,'Y',9+31,30+31
	DB	27,'Y',10+31,30+31
	DB	27,'Y',11+31,30+31
	DB	27,'Y',12+31,30+31
	DB	27,'Y',13+31,30+31
	DB	27,'Y',14+31,30+31
	DB	27,'Y',15+31,30+31
	DB	27,'Y',16+31,30+31
	DB	27,'Y',17+31,30+31
	DB	27,'Y',18+31,30+31
	DB	27,'Y',19+31,30+31
	DB	27,'Y',20+31,30+31
	DB	27,'Y',21+31,30+31
	DB	27,'Y',5+31,44+31
	DB	27,'Y',6+31,44+31
	DB	27,'Y',7+31,44+31
	DB	27,'Y',8+31,44+31
	DB	27,'Y',9+31,44+31
	DB	27,'Y',10+31,44+31
	DB	27,'Y',11+31,44+31
	DB	27,'Y',12+31,44+31
	DB	27,'Y',13+31,44+31
	DB	27,'Y',14+31,44+31
	DB	27,'Y',15+31,44+31
	DB	27,'Y',16+31,44+31
	DB	27,'Y',17+31,44+31
	DB	27,'Y',18+31,44+31
	DB	27,'Y',19+31,44+31
	DB	27,'Y',20+31,44+31
	DB	27,'Y',21+31,44+31
	DB	27,'Y',5+31,58+31
	DB	27,'Y',6+31,58+31
	DB	27,'Y',7+31,58+31
	DB	27,'Y',8+31,58+31
	DB	27,'Y',9+31,58+31
	DB	27,'Y',10+31,58+31
	DB	27,'Y',11+31,58+31
	DB	27,'Y',12+31,58+31
	DB	27,'Y',13+31,58+31
	DB	27,'Y',14+31,58+31
	DB	27,'Y',15+31,58+31
	DB	27,'Y',16+31,58+31
	DB	27,'Y',17+31,58+31
	DB	27,'Y',18+31,58+31
	DB	27,'Y',19+31,58+31
	DB	27,'Y',20+31,58+31
	DB	27,'Y',21+31,58+31

		DS	256
STACK		DS	0
FCBA		DS	36
FCBB		DS	36
LINEBUF		DS	128
DIRPTR		DS	2*512		; DIRECTORY ENTRY POINTER
DIR$ENT$BUF	DS	15*512  	; ROOM FOR 512 ENTRIES
RDBUF		DS	0
	END
