*	SEE - A PROGRAM TO LOOK AT TEXT FILES

*	THIS PROGRAM PROVIDES AN EASY WAY TO LOOK AT
*	TEXT FILES, AND INCLUDES THE ABILITY TO SCROLL
*	FORWARD OR BACKWARD BY LINES OR PAGES, TO SEARCH
*	FOR CHARACTER STRINGS, AND TO PRINT SCREENS OF
*	THE FILE.  THIS PROGRAM WAS INSPIRED BY "SC" BY
*	JOHN STETSON, BUT WAS DEVELOPED INDEPENDENTLY.

*	TO USE THIS PROGRAM, ENTER

*		SEE d:FILENAME.EXT

*	WHERE d: IS AN APPROPRIATE DRIVE DESIGNATION, AND
*	FILENAME.EXT IS THE NAME OF THE TEXT FILE TO SEE.

*	THIS PROGRAM ASSEMBLES CORRECTLY UNDER EITHER THE
*	HDOS OR CP/M ASSEMBLER, WITHOUT MODIFICATION.

*	BY P. SWAYNE, HUG  25-FEB-83  01-MAY-84

HDOS	EQU	0		;ASSEMBLE FOR HDOS
CPM	EQU	1		;ASSEMBLE FOR CP/M

*	DEFINITIONS

	IF	HDOS
.EXIT	EQU	0		;EXIT TO HDOS
.SCIN	EQU	1		;SINGLE CHARACTER INPUT
.SCOUT	EQU	2		;SINGLE CHARACTER OUTPUT
.READ	EQU	4		;READ FROM DEVICE
.WRITE	EQU	5		;WRITE TO DEVICE
.CONSL	EQU	6		;SET CONSOLE OPERATIONS
.CLRCO	EQU	7		;CLEAR CONSOLE BUFFER
.CTLC	EQU	41Q		;SET CONTROL-C VECTOR
.OPENR	EQU	42Q		;OPEN FOR READ
.OPENW	EQU	43Q		;OPEN FOR WRITE
.CLOSE	EQU	46Q		;CLOSE
.SETTP	EQU	52Q		;SET MEMORY TOP
.ERROR	EQU	57Q		;REPORT ERROR
.LOADD	EQU	62Q		;LOAD DEVICE DRIVER
CPHD	EQU	188EH		;COMPARE HL AND DE
CHL	EQU	1894H		;COMPLEMENT HL
TYPTX	EQU	195EH		;TYPE TEXT AFTER CALL
S.OMAX	EQU	20D4H		;MAX OVERLAY SIZE
	ORG	2280H
	ENDIF
	IF	CPM
BDOS	EQU	5		;BDOS JUMP VECTOR
FCB	EQU	5CH		;FILE CONTROL BLOCK
FCB2	EQU	6CH		;SECOND FILE CONTROL BLOCK
CONIN	EQU	1		;CONSOLE INPUT
CONOUT	EQU	2		;CONSOLE OUTPUT
LSTOUT	EQU	5		;LST OUTPUT
DCIO	EQU	6		;DIRECT CONSOLE I/O
OPENF	EQU	15		;OPEN FILE
CLOSEF	EQU	16		;CLOSE FILE
READF	EQU	20		;READ FILE (SEQUENTIAL)
SETDMA	EQU	26		;SET DMA ADDRESS
	ORG	100H
	ENDIF

*	MAIN PROGRAM

START	LXI	H,BUFFER-1	;POINT TO BUFFER-1
	MVI	B,0		;SET A COUNTER
	MVI	C,1		;NON-NULL, NON-ASCII DATA
CLBBUF	MOV	M,C		;CLEAR BEHIND BUFFER
	DCX	H
	DCR	B
	JNZ	CLBBUF
	IF	HDOS
	XRA	A
	LXI	B,8181H
	SCALL	.CONSL		;SET CONSOLE CHAR MODE
	MVI	A,3
	MVI	C,0		;AFFECT NO BITS
	SCALL	.CONSL		;GET USER'S CONSOLE WIDTH
	STA	CONWI		;SAVE IT
	MVI	A,3
	LXI	B,0FFFFH	;SET MAX WIDTH
	SCALL	.CONSL		;FOR CONSOLE
	LXI	H,0
	DAD	SP		;FIND STACK LOCATION
	MOV	A,L		;GET LOW BYTE
	CPI	80H		;AT NORMAL LOCATION?
	JZ	NOFILE		;YES, NO FILE GIVEN
SOB	MOV	A,M		;GET A CHARACTER
	CPI	' '		;SPACE?
	INX	H
	JZ	SOB		;SKIP SPACES
	DCX	H		;REMOVE LAST INX
	PUSH	H		;SAVE FILE NAME ADDRESS
CKPSW	MOV	A,M		;GET A CHARACTER
	ORA	A		;END OF NAME?
	JZ	NOLP		;IF SO, NO PRINTER WANTED
	CPI	' '		;PARAMETER ENTERED?
	JZ	GETLP		;YES, CHECK FOR "P"
	INX	H		;ELSE, INCREMENT POINTER
	JMP	CKPSW		;CHECK NEXT CHARACTER
GETLP	MVI	M,0		;NULL OUT SPACE
	INX	H		;MOVE TO NEXT CHARACTER
	MOV	A,M		;GET IT
	CPI	'P'		;P SWITCH?
	JNZ	NOLP		;NO, NO PRINTER WANTED
	LXI	H,LPNAME	;POINT TO PRINTER NAME
	SCALL	.LOADD		;LOAD PRINTER DRIVER
	JC	NOLP		;NO LP: DEVICE
	LXI	H,LPNAME
	LXI	D,DEFALT
	MVI	A,1		;USE CHANNEL 1
	SCALL	.OPENW		;OPEN PRINTER DRIVER
	JC	ERROR		;COULDN'T DO IT
	XRA	A
	STA	PRON		;FLAG PRINTER OPERATIONAL
NOLP	LXI	H,-1
	SCALL	.SETTP		;FIND MEMORY TOP
	XCHG			;RESULT IN DE
	LHLD	S.OMAX		;GET MAX OVERLAY SIZE
	CALL	CHL		;GET NEGATIVE
	XCHG			;HL = MEMORY TOP
	DAD	D		;SUBTRACT OVERLAY SIZE
	SHLD	MEMTOP		;MARK MEMORY TOP
	SCALL	.SETTP		;AND SET IT
	JC	ERROR		;SHOULD NOT HAPPEN
	LXI	H,EXIT
	MVI	A,3
	SCALL	.CTLC		;SET UP CONTROL-C EXIT
	POP	H		;GET FILE NAME ADDRESS
	SHLD	FNAME		;SAVE IT
	LXI	D,DEFALT	;ELSE, POINT TO DEFAULTS
	XRA	A		;USE CHANNEL 0
	SCALL	.OPENR		;OPEN FOR READ
	JC	ERROR		;COULDN'T FIND FILE
	JMP	READ		;READ THE FILE
	ENDIF
	IF	CPM
	LXI	H,0
	DAD	SP		;FIND STACK
	LXI	SP,STACK	;SET NEW STACK
	PUSH	H		;SAVE OLD ONE
	LHLD	BDOS+1		;GET BDOS VECTOR
	SHLD	MEMTOP		;SAVE AS MEMORY TOP
	LXI	D,FCB+1		;POINT TO FCB FILE NAME POS.
	LDAX	D		;GET CHARACTER THERE
	CPI	' '		;ANY FILE ENTERED?
	JZ	NOFILE		;NO
	LDA	FCB2+1		;ELSE, CHECK SECOND FCB
	CPI	'P'		;"P" ENTERED?
	JNZ	NOLP		;NO, PRINTER NOT WANTED
	XRA	A
	STA	PRON		;ELSE, FLAG PRINTER ON
NOLP	DCX	D		;POINT TO FCB
	XCHG
	SHLD	FNAME		;SAVE FILE NAME
	XCHG
	MVI	C,OPENF
	CALL	BDOS		;TRY TO OPEN FILE
	INR	A		;GOOD OPEN?
	JNZ	READ		;YES, READ FILE
	CALL	TYPTX
	DB	13,10,'ERROR - File cannot be found.',13,10+80H
	POP	H		;GET OLD STACK
	SPHL			;SET IT
	RET			;RETURN TO CP/M
	ENDIF
NOFILE	CALL	TYPTX
	DB	13,10,'SEE Version 1.1 by PS:',13,10,10
	DB	'The correct use of this program is',13,10,10
	IF	CPM
	DB	'A'
	ENDIF
	DB	'>SEE d'
	IF	HDOS
	DB	'ev'
	ENDIF
	DB	':FILENAME.EXT',13,10,10
	DB	'where d'
	IF	HDOS
	DB	'ev'
	ENDIF
	DB	': is a drive designation, and',13,10
	DB	'FILENAME.EXT is the file you want to SEE.',13,10+80H
	IF	HDOS
	XRA	A
	SCALL	.EXIT		;RETURN TO HDOS
	ENDIF
	IF	CPM
	POP	H		;GET OLD STACK
	SPHL			;SET IT
	RET			;RETURN TO CP/M
	ENDIF
READ	DS	0
	IF	HDOS
	SCALL	.CLRCO		;CLEAR CONSOLE BUFFER
	ENDIF
	CALL	TYPTX
	DB	27,'i','0'+80H	;REQUEST TERMINAL TYPE
	MVI	C,0		;PRESET TERMINAL TYPE CODE (H19)
	CALL	SCINWT		;TEST FOR RESPONSE
	JZ	H19		;NO CHARACTER, MUST BE H19-TYPE
GOTRES	CPI	27		;ESCAPE?
	JNZ	H19		;NO, IT'S H19
	CALL	SCINWT		;GET NEXT CHARACTER
	JZ	H19		;NONE, H19
	CPI	'i'		;LITTLE I?
	JNZ	H19		;NO, H19
	CALL	SCINWT		;GET NEXT CHARACTER
	JZ	H19		;NONE, H19
	CPI	'B'		;"B"?
	JZ	H29		;IF SO, IT'S AN H29
	CPI	'C'		;H49?
	JZ	H29		;USE AS H29
	CPI	'E'		;"E"?
	JZ	H100		;IF SO, IT'S AN H100
	JMP	H19		;ELSE, IT'S AN H19
H100	INR	C		;ADD 1 FOR H100
H29	INR	C		;ADD 1 FOR H29
H19	MOV	A,C		;GET TERMINAL TYPE CODE
	STA	TTYPE		;MARK TERMINAL TYPE
	CALL	SCIN		;DUMP EXTRA CHARACTER
	LHLD	MEMTOP		;GET MEMORY TOP
	LXI	D,-BUFFER
	DAD	D		;SUBTRACT BUFFER SIZE
	MOV	B,H
	MOV	C,L		;BC = FILE MEMORY SPACE
	LXI	H,BUFFER	;PUT FILE HERE
	SHLD	TXTSTRT		;SET UP TEXT START

READLP	CALL	READFIL		;READ THE FILE
	IF	HDOS
	JNC	READ1		;DID NOT GET ALL OF IT
	CPI	1		;END OF FILE?
	JNZ	ERROR		;NO, ERROR
	JMP	READ2
	ENDIF
	IF	CPM
	JC	READ2		;GOT ALL OF IT
	ENDIF
READ1	XRA	A
	STA	NEXTFLG		;CLEAR "NEXT" INHIBIT FLAG
READ2	MVI	B,0		;SET A COUNTER
	DCR	H		;SUBTRACT 256 FROM ADDR
READ3	MOV	A,M		;GET A BYTE
	IF	HDOS
	ORA	A		;NULL?
	ENDIF
	IF	CPM
	CPI	'Z'-40H		;CONTROL-Z?
	ENDIF
	JZ	READ4		;YES, FOUND END OF TEXT
	INX	H		;INCREMENT POINTER
	DCR	B		;DECREMENT COUNTER
	JNZ	READ3		;KEEP LOOKING
READ4	SHLD	RDEND		;SAVE END OF READING
	SHLD	TXTEND		;SAVE END OF TEXT
	INR	B
	DCR	B		;SET FLAGS
	MVI	A,0
	JNZ	FNDEND
READ5	DCX	H		;BACK UP
	INR	B		;COUNT THE BACK-UP
	MOV	A,M		;GET CHARACRER
	ANI	7FH		;STRIP PARITY
	CPI	10		;LINE FEED?
	JNZ	READ5		;NOPE
	DCR	B		;DON'T COUNT THE LINE FEED
	INX	H		;MOVE PAST IT
	SHLD	TXTEND		;MARK REAL END OF TEXT
	MOV	A,B		;GET END COUNT
FNDEND	STA	ENDCNT		;SAVE IT
	LXI	D,-BUFFER
	DAD	D		;FIND SIZE OF FILE IN BYTES
	XCHG			;DE = FILE SIZE
	LHLD	LINCNT		;GET LINE COUNT
	SHLD	LINSTRT		;UPDATE FIRST LINE
	LXI	B,0		;CLEAR A COUNTER
	LHLD	TXTSTRT		;POINT TO START OF TEXT
CNTLNS	MOV	A,M		;GET A CHARACTER
	ANI	7FH		;STRIP PARITY
	INX	H		;INCREMENT POINTER
	CPI	10		;LINE FEED?
	JNZ	CNTLN1		;NO
	INX	B		;COUNT THIS LINE
CNTLN1	DCX	D		;DECREMENT SIZE COUNTER
	MOV	A,D
	ORA	E		;DONE?
	JNZ	CNTLNS		;LOOP UNTIL DONE
	LHLD	LINSTRT		;GET LINE START
	DAD	B		;ADD LINE COUNT
	SHLD	LINCNT		;UPDATE LINE COUNT
	MOV	A,B
	ORA	A		;MORE THAN 256 LINES?
	JNZ	FNDLP		;YES, FIND LAST PAGE
	MOV	A,C
	CPI	25		;LESS THAN 25 LINES?
	JNC	FNDLP		;NO, FIND LAST PAGE
	LXI	H,BUFFER
	SHLD	LASTPG		;ELSE, LAST PAGE = BUFFER START
	JMP	PFN		;PRINT FILE NAME
FNDLP	LHLD	TXTEND		;GET END OF TEXT
	DCX	H		;SKIP LAST LINE FEED
	MVI	B,24		;24 LINES/PAGE
FLP	DCX	H		;BACK UP ONE CHARACTER
	MOV	A,M		;GET CHARACTER
	ANI	7FH		;REMOVE PARITY
	CPI	10		;LINE FEED?
	JNZ	FLP		;NO, KEEP LOOKING
	DCR	B		;BACK 24 LINES?
	JNZ	FLP
	INX	H		;MOVE TO FIRST CHAR IN PAGE
	SHLD	LASTPG		;SAVE LAST PAGE ADDRESS
PFN	CALL	PBMSG		;PRINT BOTTOM MESSAGE
	LXI	H,BUFFER	;POINT TO BUFFER
	JMP	TOP0		;DISPLAY TOP OF FILE

*	MAIN COMMAND LOOP

CMDLP	CALL	TYPTX
	DB	27,'Y8',' '+80H
	LDA	TTYPE		;GET TERMINAL TYPE
	DCR	A		;H29?
	JZ	CMDLP01		;YES
	DCR	A		;H100?
	JZ	CMDLP02		;YES
	CALL	TYPTX		;ELSE, PRINT H19 MESSAGE
	DB	27,'x6',27,'p',27,'Fiiii','i'+80H
	JMP	CMDLP03
CMDLP01	CALL	TYPTX		;PRINT H29 MESSAGE
	DB	27,'p',27,'Fiii',27,'s5F1',27,'s','1'+80H
	JMP	CMDLP03
CMDLP02	CALL	TYPTX		;PRINT H100 MESSAGE
	DB	27,'Fiii',27,'pF0',27,'q'+80H
CMDLP03	CALL	TYPTX
	DB	8,8,8,8,8+80H
	LHLD	CURLIN		;GET CURRENT LINE NO.
	CALL	DECOUT		;PRINT IT
	CALL	TYPTX
	DB	27,'G',27,'q',27,'Y7',' '+80H
CMDLP0	CALL	SCIN		;GET A CHARACTER
	JZ	CMDLP0
	IF	HDOS
	CPI	10		;NEW-LINE?
	ENDIF
	IF	CPM
	CPI	13		;CR?
	ENDIF
	JZ	PLINE		;IF SO, MOVE DOWN ONE LINE
	CPI	27		;ESCAPE?
	JNZ	BEEP		;WAIT FOR ESCAPE
	CALL	SCINWT		;LOOK FOR SECOND CHARACTER
	JZ	BEEP		;DIDN'T GET ONE
GOTCHAR	CPI	'C'		;RIGHT WINDOW?
	JZ	RWINDOW		;YES
	CPI	'D'		;LEFT WINDOW?
	JZ	LWINDOW		;YES
	MOV	C,A		;ELSE, SAVE CHARACTER IN C
	LXI	H,CHRTBL	;POINT TO CHARACTER TABLE
	LXI	D,9		;9 CHARACTERS/TABLE
	LDA	TTYPE		;GET TERMINAL TYPE
	ORA	A		;TEST FOR H19
	JZ	GOTTBL		;IT'S IT
	DAD	D		;MOVE TO 29 TABLE
	DCR	A		;TEST
	JZ	GOTTBL		;IT'S H29
	DAD	D		;ELSE, IT'S H100
GOTTBL	MVI	B,9		;SET A COUNTER
	LXI	D,CMDTBL	;POINT TO COMMAND TABLE
FCHAR	MOV	A,M		;GET A CHARACTER
	CMP	C		;IS THIS THE ONE ENTERED?
	JZ	EXECUT		;YES, EXECUTE THE COMMAND
	INX	D		;ELSE, INCREMENT COMMAND POINTER
	INX	D
	INX	H		;INCREMENT CHARACTER POINTER
	DCR	B		;DONE WITH LIST?
	JNZ	FCHAR		;NO, KEEP LOOKING
BEEP	MVI	A,7
	CALL	SCOUT		;BEEP
	JMP	CMDLP
EXECUT	CPI	'0'		;H29 F9 KEY?
	JNZ	EXECUT1		;NO
	CALL	SCIN		;ELSE, DUMP EXTRA CHARACTER
EXECUT1	XCHG			;HL POINTS TO COMMAND ADDRESS
	MOV	A,M		;GET LOW BYTE
	INX	H
	MOV	H,M		;GET HIGH BYTE
	MOV	L,A		;HL = COMMAND ADDRESS
	PCHL			;EXECUTE THE COMMAND

*	THE COMMANDS

PPAGE	LDA	TTYPE		;GET TERMINAL TYPE
	DCR	A		;H29?
	JZ	PPAGE0		;IF SO, LEAVE 25TH LINE ON
	CALL	TYPTX
	DB	27,'y','1'+80H	;TURN OFF 25TH LINE
PPAGE0	MVI	B,24		;SET A COUNTER
PPAGE1	CALL	PLINE1		;PLUS ONE LINE
	DCR	B		;DONE?
	JNZ	PPAGE1		;LOOP UNTIL DONE
	LDA	TTYPE		;GET TERMINAL TYPE
	DCR	A		;H29?
	JZ	CMDLP		;IF SO, DONE
	CALL	PBMSG0		;PRINT BOTTOM LINE MSG
	JMP	CMDLP		;GET ANOTHER COMMAND

PLINE	CALL	PLINE1		;PLUS ONE LINE
	JMP	CMDLP		;GET ANOTHER COMMAND
PLINE1	LHLD	LASTPG		;GET LAST PAGE ADDRESS
	XCHG			;IN DE
	LHLD	TPADR		;GET TOP PAGE ADDRESS
	CALL	CPHD		;COMPARE
	RZ			;SAME, DO NOT INCREMENT
PLINE2	MOV	A,M		;GET A CHARACTER
	ANI	7FH		;STRIP PARITY
	CPI	10		;LINE FEED?
	INX	H		;MOVE TO NEXT CHAR
	JNZ	PLINE2		;FIND LINE FEED
	SHLD	TPADR		;SAVE TOP PAGE ADDRESS
	CALL	TYPTX
	DB	27,'Y7 ',10+80H	;MOVE TEXT UP
	LHLD	BPADR		;GET BOTTOM PAGE ADDRESS
	CALL	PRLINE		;PRINT NEXT LINE
	INX	H		;SKIP LINE FEED
	SHLD	BPADR		;UPDATE BOTTOM ADDR
	LHLD	CURLIN
	INX	H		;INCREMENT CURRENT LINE
	SHLD	CURLIN
	RET

TOP	LHLD	TPADR		;GET TOP PAGE ADDRESS
	XCHG			;IN DE
	LXI	H,BUFFER
	CALL	CPHD		;COMPARE
	JZ	CMDLP		;ALREADY AT TOP
TOP0	SHLD	TPADR		;UPDATE TOP PAGE ADDRESS
	CALL	DISPPG		;DISPLAY PAGE
	LHLD	LINSTRT		;GET FIRST LINE NUMBER
	SHLD	CURLIN		;UPDATE CURRENT LINE
	JMP	CMDLP		;GET NEXT COMMAND

MLINE	CALL	MLINE1		;MINUS ONE LINE
	JMP	CMDLP		;GET NEXT COMMAND
MLINE1	LXI	H,BUFFER	;GET BUFFER ADDR
	XCHG			;IN DE
	LHLD	TPADR		;GET TOP PAGE ADDR
	CALL	CPHD		;COMPARE
	RZ			;SAME, DO NOT DECREMENT
	DCX	H		;BACK UP OVER LINE FEED
	CALL	CPHD
	JZ	MLINE2A		;FOUND TOP
	DCX	H
MLINE2	CALL	CPHD		;AT TOP OF PAGE?
	JZ	MLINE2A		;YES, QUIT BACKING UP
	MOV	A,M		;GET A CHARACTER
	ANI	7FH		;STRIP PARITY
	CPI	10		;LINE FEED?
	DCX	H		;MOVE TO PREVIOUS CHARACTER
	JNZ	MLINE2		;FIND LINE FEED
	INX	H		;SKIP OVER LINE FEED
	INX	H
MLINE2A	SHLD	TPADR		;SAVE TOP PAGE ADDESS
	LHLD	BPADR		;GET BOTTOM PAGE ADDR
	DCX	H		;BACK UP OVER LINE FEED
	DCX	H
MLINE3	MOV	A,M		;FIND PREVIOUS LINE FEED
	ANI	7FH
	CPI	10
	DCX	H
	JNZ	MLINE3
	INX	H
	INX	H
	SHLD	BPADR		;UPDATE BOTTOM PAGE ADDR
	LHLD	CURLIN
	DCX	H		;DECREMENT CURRENT LINE
	SHLD	CURLIN
	CALL	TYPTX
	DB	27,'H',27,'I'+80H ;BACK UP ONE LINE
	LHLD	TPADR		;GET TOP PAGE ADDR
	CALL	PRLINE		;PRINT THE LINE THERE
	RET

MPAGE	LHLD	TPADR		;GET TOP PAGE ADDRESS
	LXI	D,BUFFER	;POINT TO BUFFER
	CALL	CPHD		;COMPARE
	JZ	CMDLP		;ALREADY AT TOP
	LDA	TTYPE		;GET TERMINAL TYPE
	DCR	A		;H29?
	JZ	MPAGE1		;YES
MPAGE0	CALL	TYPTX
	DB	27,'y','1'+80H	;TURN OFF 25TH LINE
MPAGE1	MVI	B,24		;SET A COUNTER
MPAGE2	CALL	MLINE1		;MINUS ONE LINE
	DCR	B
	JNZ	MPAGE2		;LOOP UNTIL DONE
	LDA	TTYPE		;GET TERMINAL TYPE
	DCR	A		;H29
	JZ	CMDLP		;IF SO, DONE
	CALL	PBMSG0		;ELSE, PRINT BOTTOM LINE MESSAGE
	JMP	CMDLP

BOTTOM	LHLD	TPADR		;GET TOP PAGE ADDR
	XCHG			;IN DE
	LHLD	LASTPG		;GET LAST PAGE ADDR
	CALL	CPHD		;COMPARE
	JZ	CMDLP		;ALREADY AT BOTTOM
	SHLD	TPADR		;SET TOP PAGE ADDRESS
	LHLD	LINCNT		;GET LINE COUNT
	LXI	D,-24
	DAD	D		;SUBTRACT 24
	SHLD	CURLIN		;UPDATE CURRENT LINE
	LHLD	TPADR
	CALL	DISPPG		;DISPLAY PAGE
	JMP	CMDLP		;GET NEXT COMMAND

PRPAGE	LDA	PRON
	ORA	A		;IS PRINTER ON?
	JNZ	BEEP		;NO, DON'T EVEN TRY
	LXI	H,POUT		;PUT POUT ADDRESS
	SHLD	PRFUNC		;IN PRLINE ROUTINE
	MVI	A,1
	STA	PFLAG		;SET PRINT FLAG
	LHLD	TPADR		;GET TOP PAGE ADDRESS
	CALL	DISP0		;DISPLAY PAGE (ON PRINTER THIS TIME)
	LXI	H,SCOUT
	SHLD	PRFUNC		;FIX PRLINE ROUTINE
	XRA	A
	STA	PFLAG		;CLEAR PRINT FLAG
	JMP	CMDLP

FIND	CALL	LINPUT		;INPUT SEARCH LINE
	JZ	FIND4		;ESC
	CALL	TYPTX		;PRINT "SEARCHING..."
	DB	27,'x5',27,'Y8 ',27,'K',27,'p'
	DB	'Searching for: ',' '+80H
	PUSH	D		;SAVE SEARCH ARG ADDR
	LDA	LINLEN		;GET STRING LENGTH
	MOV	B,A		;IN B
PSMSG	LDAX	D		;GET A CHARACTER
	CALL	SCOUT		;PRINT IT
	INX	D
	DCR	B
	JNZ	PSMSG		;LOOP UNTIL DONE
	POP	D		;RESTORE SEARCH ARG ADDR
	CALL	TYPTX
	DB	27,'q',27,'Y7',' '+80H
	LHLD	CURLIN		;GET CURRENT LINE
	PUSH	H		;SAVE IT
	INX	H		;START WITH NEXT LINE
	SHLD	CURLIN		;SAVE NEW LINE NO.
	LHLD	TPADR		;GET TOP PAGE ADDRESS
	PUSH	H		;SAVE IT
FIND1	MOV	A,M		;FIND NEXT LINE
	ANI	7FH
	CPI	10
	INX	H
	JNZ	FIND1
	PUSH	D		;SAVE SUBSTRING
	PUSH	H		;SAVE STRING
	CALL	CHL		;GET -STRING ADDR
	XCHG			;IN DE
	LHLD	TXTEND		;GET TEXT END
	DAD	D		;COMPUTE STRING LENGTH
	MOV	B,H
	MOV	C,L		;IN BC
	POP	H
	POP	D		;RESTORE ADDRESSES
	LDA	LINLEN		;GET INPUT LENGTH
	CALL	INSTR		;LOOK FOR STRING
	JNZ	NOFIND		;COULD NOT FIND IT
FIND2	DCX	H		;BACK UP TO BEGINNING OF STRING
	MOV	A,M
	ANI	7FH
	CPI	10
	JNZ	FIND2
	INX	H		;SKIP LINE FEED
	SHLD	TPADR		;UPDATE TOP PAGE ADDRESS
	CALL	DISPPG		;DISPLAY PAGE WITH MATCH
	LHLD	LASTPG		;GET LAST PAGE
	XCHG			;IN DE
	LHLD	TPADR		;AND TOP PAGE ADDR
	CALL	CPHD		;ON LAST PAGE?
	JNZ	FIND3		;NO
	LHLD	LINCNT		;ELSE, GET LINE COUNTER
	LXI	D,-24
	DAD	D		;SUBTRACT 24
	MOV	A,H		;GET LINE NUMBER HIGH
	CPI	0FFH		;IMPOSSIBLY HIGH?
	JNZ	GDLNO		;NO, GOOD NO.
	POP	D
	POP	H		;ELSE, GET ORIGINAL LINE NUMBER
	PUSH	H		;FIX STACK
	PUSH	D
GDLNO	SHLD	CURLIN		;UPDATE CURRENT LINE
	CALL	TYPTX
	DB	7+80H		;BEEP
	LXI	H,0
BPDLY	DCX	H		;WAIT A WHILE
	MOV	A,H
	ORA	L
	JNZ	BPDLY
	CALL	TYPTX
	DB	7+80H		;BEEP AGAIN
FIND3	POP	H		;FIX STACK
	POP	H
FIND4	CALL	PBMSG0		;RESTORE BOTTOM LINE
	JMP	CMDLP
NOFIND	POP	H		;RESTORE OLD TOP ADDR
	SHLD	TPADR
	POP	H		;RESTORE OLD LINE NUMBER
	SHLD	CURLIN
	CALL	PBMSG0		;RESTORE BOTTOM LINE
	JMP	BEEP

NEXT	LDA	NEXTFLG		;GET "NEXT" INHIBIT FLAG
	ORA	A		;IS IT SET?
	JNZ	BEEP		;YES, IGNORE NEXT COMMAND
	INR	A		;A = 1
	STA	NEXTFLG		;SET FLAG
	LHLD	TXTEND		;POINT TO TEXT END
	LDA	ENDCNT		;GET END TEXT COUNT
	MOV	B,A
	LXI	D,BUFFER	;PUT TEXT HERE
	ORA	A		;ANY END TEXT
	JZ	NETXT		;NO
NEXTLP	MOV	A,M		;MOVE THE TEXT
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	NEXTLP
NETXT	XCHG			;HL = NEXT TEXT AREA
	SHLD	TXTSTRT		;UPDATE TEXT START
	CALL	CHL		;GET THE COMPLEMENT
	XCHG			;IN DE
	LHLD	MEMTOP		;GET MEMORY TOP
	DAD	D		;FIND FREE SPACE
	MOV	B,H
	MOV	C,L		;BC = FREE PAGES
	LHLD	TXTSTRT		;START READING HERE
	JMP	READLP		;READ THE TEXT

RWINDOW	MVI	A,56		;SKIP 56 CHARACTERS
	STA	WFLAG		;TO SHOW RIGHT WINDOW
	CALL	DISPPG		;DISPLAY PAGE
	JMP	CMDLP

LWINDOW	XRA	A
	STA	WFLAG		;ZERO WINDOW FLAG
	CALL	DISPPG		;DISPLAY PAGE
	JMP	CMDLP

EXIT	CALL	TYPTX
	DB	27,'z'+80H	;RESET TO POWER-UP CONFIG.
	LXI	H,4000H
EWAIT	DCX	H
	MOV	A,H
	ORA	L
	JNZ	EWAIT
	IF	HDOS
EXIT0	LDA	CONWI		;GET USER'S CONSOLE WIDTH
	MOV	B,A
	MVI	C,0FFH
	MVI	A,3
	SCALL	.CONSL		;RESET IT
	XRA	A
	SCALL	.CLOSE		;CLOSE FILES
	MVI	A,1
	SCALL	.CLOSE
	XRA	A
	SCALL	.EXIT		;RETURN TO HDOS
	ENDIF
	IF	CPM
	MVI	C,0
	CALL	BDOS		;RETURN TO CP/M
	ENDIF

*	SUBROUTINES

*	READFIL - READ DISK FILE

*	ENTRY:
*	HL = ADDRESS TO READ INTO
*	BC = NUMBER OF BYTES TO READ

*	EXIT:
*	CY = 1 IF END OR ERROR, AND
*	HL = NEXT FREE BYTE
*	BC = UNUSED BYTES (OR RECORDS)
	IF	CPM
READFIL	MOV	A,B		;CONVERT BYTES TO CP/M RECORDS
	ADD	A
	MOV	C,A
	MVI	A,0		;GET A ZERO
	RAL			;ADD CARRY FROM ABOVE
	MOV	B,A		;BC = CP/M RECORDS
	LXI	D,FCB		;(LEAVE OUT IF EXTERNAL FCB)
RFIL1	PUSH	B		;SAVE COUNT
	XCHG			;DE = ADDRESS
	MVI	C,SETDMA
	CALL	CBDOS		;SET DMA ADDRESS
	XCHG			;DE = FCB
	MVI	C,READF
	CALL	CBDOS		;READ A RECORD
	ORA	A		;OPERATION OK?
	JNZ	RFIL2		;NO, EXIT
	LXI	B,80H
	DAD	B		;UPDATE ADDRESS
	POP	B		;GET RECORED COUNT
	DCX	B		;DECREMENT IT
	MOV	A,B
	ORA	C		;TEST
	JNZ	RFIL1		;CONTINUE IF NOT DONE
	RET			;ELSE, RETURN
RFIL2	POP	B		;RESTORE COUNT
	STC			;MARK END
	RET
	ENDIF
	IF	HDOS
READFIL	PUSH	H		;SAVE ADDR
	MVI	C,0		;MAKE COUNT EVEN PAGES
	PUSH	B		;SAVE COUNT
	XCHG			;DE = ADDRESS TO READ OR WRITE
	XRA	A		;USE CHANNEL 0
	SCALL	.READ		;READ THE FILE
	XCHG			;HL = NEXT UNUSED ADDRESS
	JC	GOTALL		;GOT ALL OF THE FILE
	POP	B		;ELSE, GET COUNT
	POP	H		;GET START
	DAD	B		;MOVE TO END
	ORA	A		;CLEAR CARRY
	RET			;AND RETURN
GOTALL	POP	B		;GET COUNT
	POP	D		;DISCARD BUFFER ADDRESS
	RET			;AND RETURN WITH HL = END OF TEXT
	ENDIF

	IF	CPM
*	TYPTX - TYPE TEXT UNTIL PARITY BIT SET

TYPTX	XTHL			;GET TEXT ADDR
TYPTX1	MOV	A,M
	ANI	7FH
	CALL	SCOUT
	CMP	M
	INX	H
	JZ	TYPTX1
	XTHL
	RET
	ENDIF

*	SCIN - SINGLE CHARACTER INPUT

SCIN	DS	0
	IF	CPM
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	E,0FFH		;SIGNAL INPUT
	MVI	C,DCIO
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	CPI	'C'-40H		;CONTROL-C?
	JZ	EXIT		;IF SO, QUIT
	ORA	A		;SET CONDITION
	RET
	ENDIF
	IF	HDOS
	SCALL	.SCIN		;GET CHARACTER
	JNC	SCIN1
	XRA	A		;NO CHARACTER
	RET
SCIN1	ORA	A
	RET
	ENDIF

*	SCINWT - CHECK FOR CHARACTER WITHIN SHORT TIME

SCINWT	MVI	B,150		;SET A COUNTER
SCINWLP	CALL	SCIN		;TEST FOR CHARACTER
	RNZ			;GOT ONE
	DCR	B		;DECREMENT COUNTER
	JNZ	SCINWLP		;TRY AGAIN
	RET			;RETURN WITH Z FLAG SET

*	SCOUT - OUTPUT CHARACTER

SCOUT	DS	0
	IF	CPM
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,DCIO
	MOV	E,A
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
	ENDIF
	IF	HDOS
	SCALL	.SCOUT
	RET
	ENDIF

*	POUT - OUTPUT CHARACTER TO PRINTER

POUT	DS	0
	IF	CPM
	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A		;CHARACTER TO E
	MVI	C,LSTOUT
	CALL	BDOS		;PRINT CHARACTER
	POP	H
	POP	D
	POP	B
	RET
	ENDIF
	IF	HDOS
	STA	PBUF		;PUT CHAR IN PRINT BUFFER
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,PBUF
	LXI	B,1		;PRINT 1 CHARACTER
	MVI	A,1
	SCALL	.WRITE		;PRINT THE CHARACTER
	POP	H
	POP	D
	POP	B
	RET
PBUF	DB	0
	ENDIF

*	PRLINE - PRINT LINE AT (HL)

PRLINE	LDA	PFLAG		;GET PRINT FLAG
	ORA	A		;PRINTING?
	JNZ	PRLINE3		;YES, NO WINDOW CHECK
	LDA	WFLAG		;GET WINDOW FLAG
	ORA	A		;ZERO?
	JZ	PRLINE3		;YES, SHOW LEFT WINDOW
	PUSH	B		;ELSE, SAVE BC
	MVI	C,0		;ZERO A COUNTER
	MOV	B,A		;PUT FLAG IN B
PRLINE1	MOV	A,M		;GET A CHARACTER
	ANI	7FH		;STRIP PARITY
	CPI	10		;END OF LINE?
	JZ	PRLINE2		;YES
	INX	H		;MOVE TO NEXT CHARACTER
	CPI	9		;TAB?
	JZ	PRTAB		;YES, PROCESS IT
	CPI	27		;ESCAPE?
	JNZ	NOTESC		;NOT AN ESCAPE
	INX	H		;ELSE, SKIP NEXT CHARACTER
	MOV	A,M		;GET NEXT CHARACTER
	CPI	's'		;H29 ATTRIBUTE?
	JZ	SKIP1		;IF SO, SKIP ONE MORE CHAR
	CPI	'm'		;H100 COLOR SETTING?
	JNZ	PRLINE1		;NO
	INX	H		;ELSE, SKIP TWO MORE CHARS
SKIP1	INX	H
	JMP	PRLINE1		;AND CHECK FOLLOWING ONE
NOTESC	CPI	' '		;ANY OTHER CONTROL CHARACTER?
	JC	PRLINE1		;IF SO, DON'T COUNT IT
	INR	C		;ELSE, COUNT CHARACTER
	DCR	B		;DONE?
	JNZ	PRLINE1
	JMP	PRLINE2		;PRINT REST OF LINE NORMALLY
PRTAB	DCR	B		;DECREMENT WINDOW COUNTER
	JZ	PRLINE2		;DONE, PRINT NORMALLY
	INR	C		;INCREMENT PLACE COUNTER
	MOV	A,C		;GET IT
	ANI	7 		;AT TAB STOP?
	JNZ	PRTAB		;IF NOT, KEEP COUNTING
	JMP	PRLINE1		;ELSE, CHECK NEXT CHARACTER
PRLINE2	POP	B		;RESTORE BC
PRLINE3	MOV	A,M		;GET A CHARACTER
	ANI	7FH		;STRIP PARITY
	CPI	' '		;SPACE OR MORE
	JNC	PRL1		;IF SO, PRINT CHAR
	CPI	27		;ESCAPE?
	JZ	PRL1		;OK
	CPI	7		;LESS THAN 7
	JC	PRL2		;DON'T PRINT
	CPI	10		;10 OR LESS
	JZ	PREND		;LINE FEED, RETURN
	JNC	PRL2		;DON'T PRINT MORE THAN 10
PRL1	DB	0CDH		;CALL INSTRUCTION
PRFUNC	DW	SCOUT		;NORMALLY, CALL SCOUT
PRL2	INX	H		;MOVE TO NEXT CHARACTER
	JMP	PRLINE3		;PRINT IT
PREND	LDA	PFLAG		;GET PRINT FLAG
	ORA	A		;USING PRINTER?
	RNZ			;IF SO, RETURN
	CALL	TYPTX		;ELSE, PRINT SPACE AFTER LINE
	DB	' '+80H		;TO CLEAR >80 CHAR PILEUP
	RET

*	DISPPG - DISPLAY PAGE AT (TPADR)

DISPPG	CALL	TYPTX
	DB	27,'w',27,'E'+80H ;CLEAR WRAP AND SCREEN
DISP0	LHLD	LASTPG		;GET LAST PAGE ADDRESS
	XCHG			;IN DE
	LHLD	TPADR		;GET TOP PAGE ADDRESS
	MOV	A,L		;SUBTRACT LASTPG FROM TPADR
	SUB	E		;TO SEE IF SHORT PAGE
	MOV	A,H
	SBB	D
	JC	DISP1		;LASTPG BIGGER, IT'S OK
	XCHG			;ELSE, USE LASTPG FOR START
	SHLD	TPADR		;UPDATE TOP PAGE ADDRESS
DISP1	XCHG			;SAVE TOP ADDR
	LHLD	TXTEND		;GET END OF TEXT
	XCHG			;IN DE
	MVI	B,24		;SET A COUNTER
DISP2	CALL	PRLINE		;PRINT A LINE
	LDA	PFLAG		;GET PRINT FLAG
	ORA	A		;PRINTING?
	JZ	DISPNP		;NO
	IF	CPM
	MVI	A,13
	CALL	POUT		;PRINT CR
	ENDIF
	MVI	A,10
	CALL	POUT		;PRINT LF
DISPNP	INX	H		;SKIP LINE FEED
	CALL	CPHD		;END OF TEXT?
	JZ	DISP3		;YES, END EARLY
	DCR	B		;DONE?
	JZ	DISP3		;DONE
	LDA	PFLAG
	ORA	A		;PRINTING
	JNZ	DISP2		;YES, NO CRLF ON SCREEN
	CALL	TYPTX
	DB	13,10+80H	;MOVE TO NEXT LINE
	JMP	DISP2		;PRINT IT
DISP3	SHLD	BPADR		;SET BOTTOM PAGE ADDR
	RET

*	PRINT NUMBER IN (HL) IN DECIMAL

DECOUT	PUSH	B
	PUSH	D
	PUSH	H		;SAVE REGISTERS
	LXI	B,-10		;RADIX FOR CONVERSION
	LXI	D,-1		;NO. DIVIDED BY RADIX
DX	DAD	B		;SUBTRACT RADIX
	INX	D
	JC	DX		;UNTIL CARRY SET (DIVIDE BY RADIX)
	LXI	B,10
	DAD	B		;ADD RADIX BACK IN ONCE
	XCHG
	MOV	A,H
	ORA	L		;DONE?
	CNZ	DECOUT		;CALL RECURSIVELY UNTIL DONE
	MOV	A,E
	ADI	'0'		;ADD ASCII BIAS
	CALL	SCOUT		;PRINT DIGIT
	POP	H
	POP	D
	POP	B		;RESTORE REGISTERS
	RET

	IF	CPM
*	CBDOS - CALL BDOS WITH REGISTERS SAVED

CBDOS	PUSH	B
	PUSH	D
	PUSH	H
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET

*	CPHD - CPMPARE HL TO DE

CPHD	MOV	A,E
	XRA	L
	RNZ		;DIFFERENT
	MOV	A,D
	XRA	H
	RET

*	CHL - COMPLEMENT HL

CHL	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	RET
	ENDIF

*	INSTR - SEARCH STRING FOR SUBSTRING

*	HL = STRING
*	DE = SUBSTRING
*	BC = STRING LENGTH
*	A  = SUBSTRING LENGTH

*	RETURNS Z FLAG IF FOUND, WITH HL = END OF SUBSTRING

INSTR	STA	SL		;SAVE SUBSTRING LENGTH
	PUSH	D		;SAVE DE
	MOV	E,A		;E = SL
	MOV	A,C
	SUB	E		;SUBTRACT SL FROM STRING LENGTH
	MOV	C,A
	MOV	A,B
	SBI	0
	MOV	B,A
	POP	D
INSTR0	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	LDA	SL
	MOV	C,A
	CALL	COMP		;COMPARE STRINGS
	POP	B
	POP	D
	POP	H
	JZ	INSTR1		;FOUND IT
	DCX	B		;DECREMENT COUNT
	MOV	A,B
	ORA	C		;SEARCHED ENTIRE STRING?
	JZ	INSTR2		;YES, NO MATCH
	INX	H		;INCREMENT STRING POINTER
	JMP	INSTR0		;TRY AGAIN
INSTR1	LDA	SL
	MOV	C,A
	MVI	B,0		;BC = SUB LENGTH
	DAD	B		;MOVE TO END OF STRING
	XRA	A		;SET ZERO
	RET
INSTR2	INR	A		;SET NZ
	RET
SL	DB	0

*	COMP - COMPARE 2 STRINGS

COMP	MOV	A,M		;GET FIRST CHARACTER
	ANI	7FH		;STRIP PARITY
	CPI	10		;LINE FEED?
	JNZ	COMP1		;NO
	PUSH	H		;SAVE POINTER
	LHLD	CURLIN
	INX	H		;INCREMENT LINE COUNTER
	SHLD	CURLIN
	POP	H
COMP1	XCHG			;DE = STRING
COMP2	LDAX	D
	ANI	7FH		;STRIP PARITY
	CMP	M		;COMPARE
	RNZ			;NO MATCH
	INX	D
	INX	H
	DCR	C
	JNZ	COMP2		;TRY SOME MORE
	RET			;HAVE MATCH

*	LINPUT - LINE INPUT (FOR SEARCH STRING)

LINPUT	CALL	TYPTX
	DB	27,'Y8 ',27,'l',27,'p',27,'y5'
	DB	' Enter string (RET = last, ESC = exit): '
	DB	27,'q'+80H
	LXI	H,LINBUF	;POINT TO LINE BUFFER
	MVI	B,0		;SET A COUNTER
LINPUT1	CALL	SCIN		;GET A CHARACTER
	JZ	LINPUT1
	IF	HDOS
	CPI	10		;END OF ENTRY?
	ENDIF
	IF	CPM
	CPI	13
	ENDIF
	JZ	LINEND		;YES, END
	CPI	8		;BACK SPACE?
	JZ	BACKUP
	CPI	7FH		;DELETE?
	JZ	BACKUP
	CPI	27		;ESCAPE?
	RZ			;YES, ABORT
	CPI	9		;TAB?
	JZ	LINTAB		;YES, INPUT TAB
	CPI	' '		;OTHER CONTROL CHARACTER?
	JC	LINPUT1		;IF SO, DON'T TAKE IT
LINTAB	MOV	M,A		;ELSE, STORE CHARACTER
	CALL	SCOUT		;PRINT IT
	INX	H		;INCREMENT POINTER
	INR	B		;INCREMENT COUNTER
	MOV	A,B
	CPI	40		;40 CHARACTERS?
	JZ	LINEND		;YES
	JMP	LINPUT1		;GET ANOTHER CHARACTER
BACKUP	INR	B
	DCR	B		;SET FLAGS
	JZ	LINPUT1		;TAKE NO ACTION
	CALL	TYPTX
	DB	8,' ',8+80H	;WIPE OUT CHARACTER
	DCR	B		;DECREMENT COUNTER
	DCX	H		;AND POINTER
	JMP	LINPUT1
LINEND	MOV	A,B		;GET COUNT
	ORA	A		;IS IT ZERO?
	JNZ	LINPUT2		;NO, USE THIS STRING
	LXI	D,PRVSTR	;ELSE, USE PREVIOUS STRING
	LDA	LINLEN		;GET OLD LINE LENGTH
	ORA	A		;SET FLAGS
	RET
LINPUT2	LXI	H,LINBUF	;POINT TO BUFFER
	LXI	D,PRVSTR	;AND PREVIOUS STRING SPACE
	STA	LINLEN		;SET LENGTH
LINPUT3	MOV	A,M
	STAX	D		;UPDATE PREV. STRING
	INX	H
	INX	D
	DCR	B
	JNZ	LINPUT3
	LXI	D,LINBUF	;GET BUFFER
	INR	B		;SET FLAGS
	RET

*	PBMSG - PRINT BOTTOM LINE MESSAGE

PBMSG	CALL	TYPTX
	DB	27,'E'+80H
PBMSG0	LDA	TTYPE		;GET TERMINAL TYPE
	DCR	A		;H29?
	JZ	PBMSG29		;YES
	DCR	A		;H100?
	JZ	PBMS100		;YES
	CALL	TYPTX		;ELSE, PRINT H19 MSG.
	DB	27,'x5',27,'x1',27,'Y8 ',27,'K',27,'p',27,'F'
	DB	'iiiii',27,'G+Page',27,'Fii',27,'G+Line'
	DB	27,'Fii',27,'G-Line',27,'Fii',27,'G-Page'
	DB	27,'Fii',27,'GTop',27,'Fii',27,'GBottom'
	DB	27,'Fii',27,'GPrint',27,'Fii',27,'GFind'
	DB	27,'Fii',27,'GNext',27,'Fi',27,'G'+80H
	JMP	PFNAM		;GO PRINT FILE NAME
PBMSG29	CALL	TYPTX		;PRINT H29 MESSAGE
	DB	27,'x5',27,'x1',27,'Y8 ',27,'K',27,'p',27,'Fiii'
	DB	27,'G',27,'s5F1',27,'s1+Page',27,'s5F2',27,'s1+Line'
	DB	27,'s5F3',27,'s1-Line',27,'s5F4',27,'s1-Page'
	DB	27,'s5F5',27,'s1Top',27,'s5F6',27,'s1Bottom'
	DB	27,'s5F7',27,'s1Print',27,'s5F8',27,'s1Find'
	DB	27,'s5F9',27,'s1Next',27,'Fi',27,'G'+80H
	JMP	PFNAM
PBMS100	CALL	TYPTX		;PRINT H100 MESSAGE
	DB	27,'x5',27,'x1',27,'Y8 ',27,'K',27,'Fiii'
	DB	27,'G',27,'pF0',27,'q+Page',27,'pF1',27,'q+Line'
	DB	27,'pF2',27,'q-Line',27,'pF3',27,'q-Page'
	DB	27,'pF4',27,'qTop',27,'pF5',27,'qBottom'
	DB	27,'pF6',27,'qPrint',27,'pF7',27,'qFind'
	DB	27,'pF8',27,'qNext',27,'Fi',27,'G'+80H
PFNAM	LHLD	FNAME		;GET FILE NAME
	IF	CPM
	MOV	A,M		;GET DRIVE CODE
	ORA	A		;ANY THERE
	JZ	FNAA		;NO
	ADI	'@'		;ADD ASCII
	CALL	SCOUT		;PRINT IT
	MVI	A,':'
	CALL	SCOUT		;PRINT COLON
FNAA	INX	H		;SKIP TO NAME
	MVI	B,8
	ENDIF
	IF	HDOS
	MVI	B,16		;SET A COUNTER
	ENDIF
FNAMLP	MOV	A,M		;GET A CHARACTER
	INX	H		;MOVE TO NEXT
	ORA	A		;END OF NAME?
	JZ	FNEND		;YES
	CPI	' '		;SPACE?
	JZ	FNAM1		;YES, DON'T PRINT
	CALL	SCOUT		;PRINT NAME CHARACTER
FNAM1	DCR	B
	JNZ	FNAMLP		;LOOP UNTIL DONE
	IF	HDOS
	JMP	FNEND0
	ENDIF
	IF	CPM
	MVI	A,'.'
	CALL	SCOUT		;PRINT PERIOD
	MVI	B,3
FNAMLP1	MOV	A,M		;GET CHARACTER
	INX	H		;MOVE TO HEXT
	CALL	SCOUT		;PRINT CHARACTER
	DCR	B
	JNZ	FNAMLP1		;LOOP UNTIL DONE
	ENDIF
FNEND	CALL	TYPTX
	DB	' '+80H
FNEND0	CALL	TYPTX
	DB	27,'q',27,'Y7',' '+80H
	RET

	IF	HDOS
*	HDOS ERROR MESSAGE PROCESSOR

ERROR	PUSH	PSW		;SAVE ERROR CODE
	CALL	TYPTX
	DB	7,27,'z'+80H
	LXI	H,4000
ERDLY	DCX	H
	MOV	A,H
	ORA	L
	JNZ	ERDLY		;WAIT FOR TERMINAL TO CLEAR
	CALL	TYPTX
	DB	'ERROR -',' '+80H
	POP	PSW		;GET ERROR CODE
	MVI	H,10		;TRAILING CHARACTER
	SCALL	.ERROR		;PRINT ERROR MSG
	JMP	EXIT0		;AND EXIT
	ENDIF

*	VARIABLES AND BUFFER

MEMTOP	DW	0		;MEMORY TOP
FNAME	DW	0		;FILE NAME ADDRESS
TTYPE	DB	0		;TERMINAL TYPE FLAG
TXTSTRT	DW	0		;START OF TEXT
TXTEND	DW	0		;END OF TEXT
RDEND	DW	0		;END OF READING
ENDCNT	DB	0		;COUNT BETWEEN RDEND AND TXTEND
LINCNT	DW	1		;LINE COUNTER (PRESET TO 1)
LINSTRT	DW	0		;FIRST LINE NUMBER
CURLIN	DW	0		;CURRENT LINE NUMBER
TPADR	DW	0		;TOP PAGE ADDRESS IN FILE
BPADR	DW	0		;BOTTOM PAGE ADDRESS IN FILE
LASTPG	DW	0		;LAST PAGE POINTER
NEXTFLG	DB	1		;"NEXT" FLAG
PRON	DB	1		;PRINTER ON FLAG
PFLAG	DB	0		;PRINT FLAG
WFLAG	DB	0		;WINDOW FLAG
MPFLG	DB	0		;MINUS PAGE FLAG
LINLEN	DB	0		;LINE INPUT LENGTH
	IF	HDOS
CONWI	DB	0		;USER'S CONSOLE WIDTH
LPNAME	DB	'LP:',0		;LINE PRINTER DRIVER NAME
DEFALT	DB	'SY0',0,0,0	;I/O DEFAULTS
	ENDIF
CHRTBL	DB	'STUVWJPQR'	;H19 FUNCTION KEYS
	DB	'STUVWPQR0'	;H29 FUNCTION KEYS
	DB	'JSTUVWPQR'	;H100 FUNCTION KEYS
CMDTBL	DW	PPAGE
	DW	PLINE
	DW	MLINE
	DW	MPAGE
	DW	TOP
	DW	BOTTOM
	DW	PRPAGE
	DW	FIND
	DW	NEXT
PRVSTR	DS	0		;PREVIOUS LINE INPUT
LINBUF	EQU	PRVSTR+40	;INPUT BUFFER
DATEND	EQU	LINBUF+40	;DATA END
	IF	HDOS
BUFFER	EQU	DATEND+257	;BUFFER STARTS HERE
	ENDIF
	IF	CPM
	ORG	DATEND
	DS	64
STACK	DS	0
SCINBUF	DB	0		;INPUT BUFFER
BUFFER	EQU	SCINBUF+257+80	;BUFFER STARTS HERE
	ENDIF
	END	START
