;	SCR -- SCREEN DUMP FOR CP/M
;
;	THIS PROGRAM DUMPS THE CONTENTS OF THE SCREEN
;	TO A PRINTER WHEN A USER DESIGNATED CONTROL
;	CHARACTER IS PRESSED.
;
;	BY P. SWAYNE, HUG  28-MAY-83  17-JUN-84
;
;	THE SCREEN DUMP SECTION OF THIS CODE IS BORROWED
;	FROM THE HUG HDOS SCREEN DUMP PROGRAM "HC" BY
;	BURTON HULLAND (EXCEPT FOR THE H100 PORTIONS)

CNTRL	EQU	'D'		;CONTROL CHARACTER TO DUMP SCREEN
TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
H100	EQU	FALSE		;FALSE = H8/H89, TRUE = H100

;	DEFINITIONS

BIOS	EQU	0		;BIOS JUMP VECTOR
CURDSK	EQU	4		;CURRENT DISK CELL
BDOS	EQU	5		;BDOS JUMP VECTOR
BCONST	EQU	3		;BIOS CONST VECTOR
BCONIN	EQU	6		;BIOS CONIN VECTOR
DPORT	EQU	350Q		;CONSOLE DATA PORT (372Q FOR H8-5)
SPORT	EQU	355Q		;CONSOLE STATUS PORT (373Q FOR H8-5)
IPORT	EQU	351Q		;CONSOLE INT. PORT (373Q FOR H8-5)
INBIT	EQU	1		;INPUT STATUS BIT (2 FOR H8-5)
OUTBIT	EQU	40Q		;OUTPUT STATUS BIT (1 FOR H8-5)
IOFF	EQU	0		;INTERRUPT OFF BYTE (25Q FOR H8-5)
ION	EQU	1		;INTERRUPT ON BYTE (27Q FOR H8-5)
CCPSIZ	EQU	800H		;SIZE OF CCP
PRINTF	EQU	9		;BDOS PRINT FUNCTION

	ORG	100H

;	TEST IF SCR ALREADY IN

START:	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT
	CALL	CPHD		;TEST IF SCR ALREADY IN
	JC	LDED		;SOMETHING'S IN, EXIT
	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	LXI	D,5
	DAD	D		;MOVE TO SIGNATURE
	MOV	A,M		;GET FIRST CHARACTER
	CPI	'P'		;IS IT "P"?
	JNZ	NTLDED		;IF NOT, SCR NOT LOADED
	INX	H
	MOV	A,M		;GET SECOND CHARACTER
	CPI	'S'		;IS IT "S"?
	JNZ	NTLDED		;NO, OK TO LOAD
LDED:	LXI	D,ITSIN
	MVI	C,PRINTF
	CALL	BDOS		;ELSE, SAY "IT'S IN"
	JMP	BIOS		;RETURN TO CP/M

;	PREPARE TO RELOCATE CODE

NTLDED:	LHLD	BIOS+1		;GET BIOS TABLE ADDRESS
	INX	H		;SKIP JUMP INST.
	MOV	E,M		;GET ADDRESS
	INX	H
	MOV	D,M		;DE = WARM BOOT ADDRESS
	XCHG
	SHLD	OLDWB		;SAVE OLD WARM BOOT ADDRESS
	XCHG
	CALL	CPHD+1		;TEST IF EXTENSION ALREADY LOADED
	RC			;IF SO, EXIT, NOTHING DONE
	LHLD	BDOS+1		;GET BDOS ADDRESS
	LXI	D,-(JBDOS+CCPSIZ+400H)	;CODE START + SPACE ALLOWED
	DAD	D		;CALCULATE OFFSET FOR MOVED CODE
	SHLD	BIAS		;STORE IT
	LXI	H,MYCONIN	;HL = ORG ADDR
	LXI	D,CODEND 	;END OF CODE TO FIX
LOCAT0	MOV	A,M		;GET OPCODE
	MOV	B,A		;SAVE IT
	PUSH	H		;SAVE ADDRESS

; LOCATE TWO AND THREE BYTE OPCODES

	LXI	H,THBYT		;THREE BYTE TABLE
LOCAT1	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCAT5		;YES, PROCESS IT
	CPI	0F7H		;END OF TABLE?
	INX	H
	JNZ	LOCAT1		;IF NOT, CONTINUE
	LXI	H,TWBYT		;TWO BYTE TABLE
LOCAT2	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCAT3		;YES, SKIP DATA BYTE
	CPI	0F7H		;END OF TABLE?
	INX	H		;MOVE POINTER
	JNZ	LOCAT2		;IF NOT, CONTINUE
	JMP	LOCAT4		;ONE BYTE INSTRUCTION
LOCAT3	POP	H		;RESTORE ADDRESS POINTER
	INX	H		;SKIP DATA BYTE
	PUSH	H		;SAVE ADDRESS
LOCAT4	POP	H		;RESTORE ADDRESS
	CALL	CPHD		;END OF PROGRAM?
	JNC	LOCAT0		;IF NOT, CONTINUE
	JMP	LOCAT8		;CODE FIXED, MOVE IT

; FIX THREE BYTE INSTRUCTIONS

LOCAT5	POP	H		;RESTORE ADDRESS
	INX	H		;POINT TO CODE ARGUMENT
	PUSH	D		;SAVE END POINTER
	MOV	E,M
	INX	H
	MOV	D,M		;DE = ADDR TO CHECK
	PUSH	H		;SAVE ADDRESS POINTER
	LXI	H,JBDOS-1 	;CHECK IF ADDRESS IS
	CALL	CPHD		;BELOW PROGRAM?
	JC	LOCAT6		;IF SO, DO NOT ADJUST
	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
	DCX	H		;ADDR LOW BYTE
	LDA	BIAS		;FIX CODE
	ADD	M
	MOV	M,A
	INX	H
	LDA	BIAS+1
	ADC	M
	MOV	M,A		;ADDR = ADDR + BIAS
	JMP	LOCAT7
LOCAT6	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
LOCAT7	CALL	CPHD		;END OF FIXABLE CODE?
	JNC	LOCAT0		;IF NOT, CONTINUE
LOCAT8:

;	CODE IS FIXED, NOW ALTER BIOS TABLE

	LHLD	BIAS		;GET RELOCATION OFFSET
	MOV	B,H
	MOV	C,L		;PUT IT IN BC
	LHLD	BIOS+1		;GET BIOS TABLE ADDRESS
	INX	H		;SKIP JUMP INSTRUCTION
	LXI	D,MYWBOOT	;GET MY WARM BOOT ADDRESS
	XCHG
	DAD	B		;ADD OFFSET
	XCHG
	MOV	M,E		;INSERT IT IN BIOS TABLE
	INX	H
	MOV	M,D
	LXI	D,5		;DISTANCE TO CONIN ADDRESS
	DAD	D		;FIND CONIN ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;DE = CONIN ADDRESS
	XCHG
	SHLD	CONINV		;SET UP CONIN CALL
	XCHG
	LXI	D,MYCONIN	;GET MY CONIN VECTOR
	XCHG
	DAD	B		;ADD OFFSET
	XCHG
	MOV	M,D
	DCX	H
	MOV	M,E		;STICK IT IN BIOS
	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	SHLD	JBDOS+1		;SAVE IT HERE, TOO
	LXI	D,-(CCPSIZ+3)
	DAD	D		;CALCULATE CCP CLEAR START ADDR
	SHLD	JCCP		;SET UP WARM BOOT EXIT
	LXI	H,JBDOS
	DAD	B		;ADD OFFSET
	SHLD	BDOS+1		;UPDATE BDOS VECTOR
	POP	H		;GET OLD BDOS ADDRESS
	LXI	D,-(CCPSIZ+400H)
	DAD	D		;SUBTRACT CCP AND PROGRAM SIZE
	LXI	D,JBDOS		;DUMP CODE STARTS HERE
	LXI	B,CODEND-JBDOS	;SIZE OF CODE
MOVE	LDAX	D		;GET A BYTE
	MOV	M,A		;MOVE IT
	INX	H		;INCREMENT POINTERS
	INX	D
	DCX	B		;DECREMENT COUNTER
	MOV	A,B
	ORA	C		;DONE?
	JNZ	MOVE		;LOOP UNTIL DONE
	LXI	D,LMSG
	MVI	C,PRINTF
	CALL	BDOS		;PRINT SIGN ON MSG
	JMP	BIOS		;RETURN TO CP/M

; COMPARE HL TO DE

CPHD	INX	H		;INCREMENT HL
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET

; TABLE OF THREE BYTE INSTRUCTIONS
; THAT REQUIRE FIXING

THBYT	DB	01H		;LXI B
	DB	11H		;LXI D
	DB	21H		;LXI H
	DB	31H		;LXI SP
	DB	22H		;SHLD
	DB	2AH		;LHLD
	DB	32H		;STA
	DB	3AH		;LDA
	DB	0CDH		;CALL
	DB	0CCH		;CZ
	DB	0C3H		;JMP
	DB	0C2H		;JNZ
	DB	0CAH		;JZ
	DB	0D2H		;JNC
	DB	0DAH		;JC
	DB	0F2H		;JP
	DB	0FAH		;JM
	DB	0F7H		;END OF TABLE

; TWO BYTE OPCODES

TWBYT	DB	3EH		;MVI A
	DB	6		;MVI B
	DB	0EH		;MVI C
	DB	16H		;MVI D
	DB	1EH		;MVI E
	DB	26H		;MVI H
	DB	2EH		;MVI L
	DB	36H		;MVI M
	DB	0C6H		;ADI
	DB	0CEH		;ACI
	DB	0D6H		;SUI
	DB	0E6H		;ANI
	DB	0EEH		;XRI
	DB	0FEH		;CPI
	DB	0D3H		;OUT
	DB	0DBH		;IN
	DB	0F7H		;END OF TABLE

BIAS	DW	0		;RELOCATION BIAS
LMSG	DB	13,10,'CP/M Screen Dump Version 1.0 (by PS:) is '
	DB	'now installed.',13,10
	DB	'Type Control-',CNTRL,' to print screen.$'
ITSIN	DB	'ERROR -- SCR or other extension '
	DB	'already loaded.$'

;	SCREEN DUMP CODE STARTS HERE

JBDOS	JMP	0		;BDOS JUMP VECTOR
OLDWB	DW	0		;OLD WARM BOOT ADDR
	DB	'PS'		;INDICATION THAT SCR IS LOADED

;	NOW, WE CAN INTERCEPT BIOS CONIN CALLS

MYCONIN	CALL	0		;ELSE, GET NEXT REGULAR CHARACTER
CONINV	EQU	$-2		;(PUT CONIN VECTOR HERE)
	CPI	CNTRL-40H	;USER'S CONTROL CHARACTER?
	RNZ			;NO, RETURN
	LXI	H,0
	DAD	SP		;FIND CURRENT STACK
	LXI	SP,STACK	;SET NEW ONE
	PUSH	H		;SAVE OLD ONE
	CALL	TYPTX
	DB	27,'}'+80H	;TURN OFF KEYBOARD
	IF	NOT H100
	MVI	A,IOFF
	OUT	IPORT		;KILL CONSOLE INTERRUPTS
	LXI	B,0
	CALL	XMIT		;TRANSMIT FIRST QUARTER PAGE
	MVI	B,486/256
	MVI	C,486 AND 0FFH
	CALL	XMIT		;AND SECOND QUARTER PAGE
	MVI	B,(2*486)/256
	MVI	C,(2*486) AND 0FFH
	CALL	XMIT		;THIRD QUARTER PAGE
	MVI	B,(3*486)/256
	MVI	C,(3*486) AND 0FFH
	CALL	XMIT		;FOURTH QUARTER PAGE
	MVI	A,ION
	OUT	IPORT		;RESTORE CONSOLE INTERRUPTS
	ENDIF
	IF	H100
	CALL	XMIT		;TRANSMIT PAGE
	ENDIF
	CALL	TYPTX
	DB	27,'{'+80H	;TURN ON KEYBOARD
	POP	H		;GET OLD STACK
	SPHL			;SET IT
	JMP	MYCONIN		;USER IS STILL WAITING FOR INPUT

MYWBOOT	LHLD	JBDOS+1		;GET BDOS ADDRESS
	LXI	D,JBDOS		;AND START OF KEYMAP
	MVI	B,6		;SET A COUNTER
MVSER	DCX	H		;DECREMENT POINTERS
	DCX	D
	MOV	A,M		;MOVE CP/M SERIAL NO.
	STAX	D		;TO BEFORE KEYMAP
	DCR	B
	JNZ	MVSER
	LDA	CURDSK		;GET CURRENT DISK
	MOV	C,A		;IN C
	JMP	0		;JUMP TO CCP
JCCP	EQU	$-2

	IF	NOT H100
XMIT	XRA	A
	STA	CCOUNT		;CLEAR CHARACTER COUNT
	CALL	TYPTX
	DB	27,'#'+80H	;SEND TRANSMIT PAGE SEQUENCE
XMITSKP	MOV	A,B		;SKIP CHARACTERS ALREADY SENT
	ORA	C
	JZ	XMIT1
	CALL	READ		;READ A CHARACTER
	DCX	B		;COUNT IT
	JMP	XMITSKP
XMIT1	LXI	B,486		;COUNT FOR 1/4 PAGE
	LXI	H,BUFFER	;POINT TO CHARACTER BUFFER
XMIT2	CALL	READ		;GET A CHARACTER
	MOV	M,A		;STORE IT
	INX	H		;INCREMENT POINTER
	DCX	B		;DECREMENT COUNTER
	MOV	A,B
	ORA	C		;DONE?
	JNZ	XMIT2		;IF NOT, LOOP
XMIT3	CALL	READ		;DUMP REST OF SCREEN
	CPI	0DH		;CR = END OF TRANSMISSION
	JNZ	XMIT3
	ENDIF
	IF	H100
XMIT	CALL	TYPTX
	DB	27,'j',27,'H'+80H	;SAVE CURSOR, HOME
	MVI	D,24		;SET A COUNTER (24 LINES)
XMIT1	PUSH	D		;SAVE LINE COUNTER
	CALL	TYPTX
	DB	27,'^'+80H	;TRANSMIT LINE
	LXI	H,BUFFER	;POINT TO BUFFER
	MVI	B,81		;SET A COUNTER
XMIT2	CALL	READ		;GET A CHARACTER
	MOV	M,A		;STORE IT
	INX	H		;INCREMENT POINTER
	DCR	B		;DECREMENT COUNTER
	JNZ	XMIT2		;LOOP UNTIL DONE
	CALL	PBUF		;PRINT LINE
	CALL	TYPTX
	DB	27,'B',80H	;MOVE DOWN ONE LINE
	POP	D
	DCR	D		;DONE WITH PAGE?
	JNZ	XMIT1		;IF NOT, LOOP
	CALL	TYPTX
	DB	27,'k'+80H	;RESTORE CURSOR
	RET
	ENDIF

;	PRINT BUFFER TO LST:

	IF	NOT H100
	LXI	B,486
	ENDIF
	IF	H100
PBUF	LXI	B,81
	ENDIF
	LXI	H,BUFFER
XMIT4	MVI	A,0AH		;END OF LINE CHARACTER
	CMP	M		;END FOUND?
	JNZ	XMIT5		;NO
	MVI	A,0DH		;ELSE, PRINT CR
	CALL	PRINT
XMIT5	MOV	A,M		;GET CHARACTER
	CALL	PRINT		;PRINT IT
	INX	H		;MOVE TO NEXT CHARACTER
	DCX	B		;DECREMENT COUNTER
	MOV	A,B
	ORA	C		;DONE?
	JNZ	XMIT4		;IF NOT, LOOP
	RET			;ELSE, RETURN

;	READ INCOMING DUMPED CHARACTERS

READ	MVI	A,0		;GET CHAR COUNT
CCOUNT	EQU	$-1
	INR	A		;INCREMENT IT
	STA	CCOUNT		;UPDATE IT
	CPI	81		;LINE DONE?
	JC	READ1		;IF NOT, CONTINUE
	XRA	A		;ELSE, ZERO COUNT
	STA	CCOUNT
	IF	H100
	CALL	READ1		;READ CR AT END OF LINE
	ENDIF
	MVI	A,0AH		;SIGNAL END OF LINE
	RET
READ1
	IF	H100
	CALL	MYCONIN		;LET COMPUTER HANDLE CHARACTERS
	ENDIF
	IF	NOT H100
	IN	SPORT		;READ STATUS PORT
	ANI	INBIT		;CHARACTER THERE
	JZ	READ1		;WAIT FOR ONE
	IN	DPORT		;READ DATA PORT
	ENDIF
	CPI	27		;ESCAPE?
	RNZ			;IF NOT, RETURN
	CALL	READ1		;ELSE, DUMP FOLLOWING CHARACTER(S)
	CPI	'm'		;H100 COLOR SETTING?
	JZ	READ2		;IF SO, DUMP NEXT 2 CHARACTERS
	CPI	's'		;H29 ATTRIBUTE CODE?
	CZ	READ1		;IF SO, DUMP EXTRA CHARACTER
	JMP	READ1		;GET NEXT USABLE CHARACTER
READ2	CALL	READ1		;DUMP TWO CHARACTERS
	CALL	READ1
	JMP	READ1		;GET NEXT USABLE CHARACTER

PRINT	PUSH	H		;SAVE POINTER
	LHLD	BIOS+1		;GET BIOS ADDRESS
	LXI	D,12		;OFFSET TO LIST FUNCTION
	DAD	D
	PUSH	B		;SAVE BC
	MOV	C,A		;PUT CHARACTER IN C
	CALL	JBIOS		;PRINT THE CHARACTER
	POP	B
	POP	H
	RET
JBIOS	PCHL			;JUMP TO ADDRESS IN HL

COUT
	IF	H100
	PUSH	H		;SAVE HL
	LHLD	BIOS+1		;GET BIOS ADDRESS
	LXI	D,9		;OFFSET TO CONOUT FUNCTION
	DAD	D
	MOV	C,A		;CHARACTER TO C
	PUSH	PSW		;SAVE CHARACTER
	CALL	JBIOS		;OUTPUT THE CHARACTER
	POP	PSW		;GET CHARACTER
	POP	H
	RET
	ENDIF
	IF	NOT H100
	PUSH	PSW		;SAVE CHARACTER TO SEND
COUT1	IN	SPORT		;READ STATUS PORT
	ANI	OUTBIT		;READY TO TRANSMIT
	JZ	COUT1		;LOOP UNTIL READY
	POP	PSW		;GET CHARACTER
	OUT	DPORT		;SEND IT
	RET
	ENDIF

TYPTX	XTHL			;GET ADDRESS OF MESSAGE
TYPTX1	MOV	A,M		;GET A CHARACTER
	ANI	7FH		;STRIP PARITY BIT
	CALL	COUT		;TRANSMIT IT
	CMP	M		;TEST IF END
	INX	H		;MOVE TO NEXT CHARACTER
	JZ	TYPTX1		;NOT AT END, LOOP
	XTHL			;ELSE, FIX STACK
	RET			;AND RETURN

CODEND	EQU	$		;CODE ENDS HERE
	DS	32		;ALLOW SOME STACK SPACE
STACK	DS	0		;PUT LOCAL STACK HERE
BUFFER	DS	486		;1/4 PAGE BUFFER

	END
