;
;	COLOR Command
;
;	Author  R. A. Metz 		Date: 2/15/83
;
;	CP/M VERSION BY P. SWAYNE, HUG  15-MAY-84
;
;	This command acts just like the ZBASIC COLOR command
;	except that it is accessible from CP/M.
;
;	For information on its use, enter the color command
;	with no parameters and an explaination will be displayed
;	on the CRT.
;
CR	EQU	0DH
LF	EQU	0AH
BFR	EQU	80H
;
	ORG	100H
BEGIN:
	LXI	H,BFR
	MOV	A,M
	MOV	C,A		; COUNT TO C
	INX	H
	CPI	0		; Check for parameter entry
	JNZ	DOCOLOR
	LXI	D,MENU		; Display instructions on no
	MVI	C,9		;  parameter entry
	JMP	5
DOCOLOR:
	LXI	D,FGR
GTLUP:
	MOV	A,E
	CPI	SELECT AND 0FFH	; Done after 2 colors
	JZ	SETCOLOR
	MOV	A,M
	INX	H		; Get entered character
	CPI	'0'		
	JC	LUP		; Ignore chrs lt '0'
	CPI	'7'+1
	JNC	LUP		; Ignore chrs gt '7'
	XCHG
	MOV	M,A
	XCHG
	INX	D
LUP:
	DCR	C
	JNZ	GTLUP
SETCOLOR:
	LXI	D,SELECT
	MVI	C,9		; Set color command
	CALL	5
	LDA	FGR
	MOV	E,A
	MVI	C,2		; Foreground color
	CALL	5
	LDA	BGR
	MOV	E,A
	MVI	C,2		; Background color
	JMP	5

FGR	DB	'7'		; Default foreground color=white
BGR	DB	'0'		; Default background color=black
;
SELECT	DB	1BH,'m$'	; Color select sequence
;
MENU	DB	CR,LF
	DB	'This command acts just like the BASIC "COLOR"'
	DB	CR,LF
	DB	'command.  It is invoked by: "COLOR fgr[,bgr]"'
	DB	CR,LF
	DB	'Where fgr and bgr are color specifications for'
	DB	CR,LF
	DB	'foreground and background colors respectively.'
	DB	CR,LF
	DB	'If bgr is ommitted, it defaults to 0.  Colors '
	DB	CR,LF
	DB	'are as follows:'
	DB	CR,LF,LF
	DB	'  0 - black      4 - green'
	DB	CR,LF
	DB	'  1 - blue       5 - cyan'
	DB	CR,LF
	DB	'  2 - red        6 - yellow'
	DB	CR,LF
	DB	'  3 - magenta    7 - white'
	DB	CR,LF,'$'
	END
    5 - cyan'
	DB	CR