	TITLE Color Screen Dump to IDS Printer
	SUBTTL	Initialization Section
	PAGE 	,132
;
;	Color Screen Dump to IDS PRISM Printer
;
;	Author: R. A. Metz		Date: 12/29/82
;
;	SDUMP  -  Program containing a BASIC callable subroutine
;		  which will perform a color screen dump to an
;		  IDS Prism printer.  When executed, this program
;		  will first verify that it is not already in memory
;		  then, if not, will exit remaining in memory.  It
;		  will then be available for use by BASIC programs
;		  to do color screen copies.  Calling format from a
;		  BASIC program is as follows:
;
;	DEF SEG =&H663   'segment containing subroutine
;	SDUMP = &H1000   'address of subroutine within segment
;	SDA$="06325417"  'Prism printer color map (standard)
;	SDMX%=1	         'dot multiplier - horizontal (standard)
;	SDMY%=2	         'dot multiplier - vertical (standard)
;	CALL SDUMP (SDMX%,SDMY%,SDA$)
;
;	The dump may be aborted at any time by merely pressing
;	any key on the keyboard.
;
;	Note: Until a better method is devised through the 
;	      study of as yet unreceived technical documentation
;	      on the Z-100, the segment address (DEF SEG) must be
;	      tied to a given release of ZDOS.  This address is
;	      dependant on the size of ZDOS which is variable 
;	      between releases.  For our current release of Z-DOS,
;	      the required segment address is 0663H.
;	      Other options such as forms control, centering, number
;	      of copies, windowing (printing only portions of the
;	      screen), etc. may be added later.
;
;
;	Color scheme is as follows:
;
;  Value      BASIC Color       Printer Color
;
;    0		Black		White (No printing)
;    1		Blue		Yellow
;    2		Green		Cyan
;    3		Cyan		Green
;    4		Red		Magenta
;    5		Magenta		Red (Orange)
;    6		Yellow		Blue (Violet)
;    7		White		Black
;
;
	PAGE
SDUMPS	SEGMENT
	ASSUME CS:SDUMPS,DS:SDUMPS,SS:SDUMPS,ES:NOTHING
	ORG	100H		; Origin of COM program
START:
	JMP	BEGIN		; Skip around data
;
MESG	DB	1BH
	DB	'E BASIC Print Screen Utility Loaded at: $'
CBUF	DB	0,0,0,0
	DB	0DH,0AH
	DB	'$'
;
BEGIN:
	MOV	AX,DS
	CMP	AX,671H		; See if already in memory
	JL	OK		; (My modified Z-DOS yields a 670H addr)
	INT	20H		; Just return and do nothing if so
;
OK:
	MOV	DX,OFFSET MESG
	MOV	AH,9		; Display header
	INT	21H
	MOV	BX,OFFSET CBUF
	MOV	CX,4		; Convert DS address to hex
	MOV	DX,DS
LP:
	PUSH	CX
	MOV	CL,12
	ROR	DX,CL
	POP	CX
	MOV	AX,DX
	AND	AL,15
	OR	AL,30H
	CMP	AL,39H
	JLE	LP1
	ADD	AL,7
LP1:
	MOV	[BX],AL
	INC	BX
	LOOP	LP
	MOV	DX,OFFSET CBUF
	MOV	AH,9		; Display load address
	INT	21H
;
	MOV	DX,OFFSET ENDPGM
	INC	DX
	INT	27H		; Exit and remain in memory
;
	ASSUME 	CS:SDUMPS,DS:NOTHING,SS:NOTHING,ES:NOTHING
	SUBTTL  Subroutine Data
	PAGE
;
;	Data:
;
SELY	DB	3,2		; Out of Graphic Mode
	DB	1BH,'Q,1,$'	; Select Yellow Ribbon
	DB	3		; Return to Graphic Mode
	DB	3,13		; Graphic CR (no LF)
	DB	0FFH
;
SELM	DB	3,2
	DB	1BH,'Q,2,$'	; Select Magenta Ribbon
	DB	3,3,13,0FFH
;
SELC	DB	3,2
	DB	1BH,'Q,3,$'	; Select Cyan Ribbon
	DB	3,3,13,0FFH
;
SELB	DB	3,2
	DB	1BH,'Q,4,$'	; Select Black Ribbon
	DB	3,3,13,0FFH
;
DONS	DB	3,2		; End Print 
	DB	1BH,'Q,4,$'	; Ensure Black Ribbon Selected
	DB	0AH,0AH,0AH	; Line feeds
	DB	0FFH
;
INITPRT	DB	12		; Initialize Printer
	DB	10,10,10,10	; TOF, 4-LF
	DB	3		; Graphic Mode
	DB	0FFH
;
GLF	DB	3,14,0FFH	; Graphic line feed
;
YLINE	DB	640 DUP (0)	; Yellow line buffer
CLINE	DB	640 DUP (0)	; Cyan line buffer
MLINE	DB	640 DUP (0)	; Magenta line buffer
BLINE	DB	640 DUP (0)	; Black line buffer
;
EIGHT	DB	8		; 8
NINE	DB	9		; 9
;
X	DW	0		; Current X
Y	DW	0		; Current Y
XS	DW	0		; Saved X
YS	DW	0		; Saved Y (TOL)
YSS	DW	0		; Saved Y (BOL)
YSDX	DW	0		; Saved Y Multiplier (TOL)
YSSDX	DW	0		; Saved Y Multiplier (BOL)
;
YC	DB	0		; Yellow  Character Accumulator
CC	DB	0		; Cyan    Character Accumulator
MC	DB	0		; Magenta Character Accumulator
BC	DB	0		; Black   Character Accumulator
;
YF	DB	0		; Yellow  Line Flag
CF	DB	0		; Cyan    Line Flag
MF	DB	0		; Magenta Line Flag
BF	DB	0		; Black   Line Flag
;
MX	EQU	8		; BASIC Argument 1 - X Multiplier
MY	EQU	6		; BASIC Argument 2 - Y Multiplier
MAP	EQU	4		; BASIC Argument 3 - Color Map
;
IX	DW	0		; Local X Multiplier
IY	DW	0		; Local Y Multiplier
MAPTAB  DB	8 DUP (0)	; Local Color Map Table
;
	SUBTTL 	Subroutine SDUMP Code Section
	PAGE
	ORG 	1000H		; Fixed Subroutine entry point
SDUMP	PROC	FAR
	MOV	BP,SP
	MOV	SI,MX[BP]	; Get 1st argument
	MOV	AX,[SI]
	MOV	CS:IX,AX	; Place in local storage
	MOV	SI,MY[BP]
	MOV	AX,[SI]		; Get 2nd argument
	MOV	CS:IY,AX
	MOV	SI,MAP[BP]
	MOV	SI,WORD PTR 1[SI]	; 3rd arg is 8 elmnt string
	MOV	CX,8
	MOV	BX,OFFSET MAPTAB	; Copy to local storage
CPYLP:
	MOV	AL,BYTE PTR [SI]
	MOV	BYTE PTR CS:[BX],AL
	INC	SI
	INC	BX
	LOOP	CPYLP
;
	PUSH	ES
	PUSH	DS
	MOV	AX,CS		; Save and set seg regs
	MOV	DS,AX
	ASSUME  DS:SDUMPS
;
	MOV	DX,OFFSET INITPRT
	CALL	PRTSTR		; Initialize Printer
;
	MOV	Y,0
	MOV	YS,0
	MOV	DX,IY		; Init Y for first line
	MOV	YSDX,DX
LINLP:
	MOV	AH,11
	INT	21H		; Check for keyboard entry
	CMP	AL,0
	JE	LINLP0		; Continue if no char
	JMP	DONE		; Else abort print
LINLP0:
	MOV	YF,0
	MOV	CF,0		; Clear line print flags
	MOV	MF,0
	MOV	BF,0
	MOV	CX,640		; 640 Characters per line
	MOV	X,0		; Init X
XLP:
	PUSH	CX		
	MOV	YC,0
	MOV	CC,0		; Clear character accumulators
	MOV	MC,0
	MOV	BC,0
	MOV	CX,7		; 7 Bits vertically per pass
CHRLP:
	CMP	Y,225		; No Extraction if Y=225
	JE	NOPRINT
	CALL	XTRCT		; Return color (X,Y) in BX
	MOV	AL,BYTE PTR MAPTAB[BX]	; Convert to printer color
	AND	AL,7
	CLC
	CMP	AL,7		; All 3 bits on is black
	JNE	NOTBLK
	STC
	RCR	BC,1		; Set Bit in Black Chr
	SHR	YC,1
	SHR	CC,1		; Shift over color bits
	SHR	MC,1		
	JMP	SHORT SKPCLR
NOTBLK:
	RCR	AL,1		; Get yellow bit
	RCR	YC,1
	RCR	AL,1		; Get cyan bit
	RCR	CC,1
	RCR	AL,1		; Get Magenta bit
	RCR	MC,1
	SHR	BC,1
SKPCLR:
	DEC	DX
	JNE	LPIT		; Loop Y Multiplier
	MOV	DX,IY
	INC	Y
	JMP	SHORT LPIT
NOPRINT:
	SHR	YC,1		; Account for non-printing bits
	SHR	CC,1
	SHR	MC,1
	SHR	BC,1
LPIT:
	LOOP	CHRLP
	MOV	AX,Y		; Save max Y
	MOV	YSS,AX
	MOV	YSSDX,DX
;
	MOV	AX,YS		; Restore Y for next chr
	MOV	Y,AX
	MOV	DX,YSDX
	SHR	YC,1
	SHR	CC,1		; Shift over 8th bit
	SHR	MC,1
	SHR	BC,1
	CMP	YC,0		; Now set flag if chr non-zero
	JE	NOY
	MOV	YF,1
NOY:
	CMP	CC,0
	JE	NOC
	MOV	CF,1
NOC:
	CMP	MC,0
	JE	NOM
	MOV	MF,1
NOM:
	CMP	BC,0
	JE	NOB
	MOV	BF,1
NOB:
	MOV	BX,X		; Put chrs in respective line buffers
	MOV	AL,YC
	MOV	BYTE PTR YLINE[BX],AL
	MOV	AL,CC
	MOV	BYTE PTR CLINE[BX],AL
	MOV	AL,MC
	MOV	BYTE PTR MLINE[BX],AL
	MOV	AL,BC
	MOV	BYTE PTR BLINE[BX],AL
;
	INC	X		; Next X
	POP	CX
	LOOP	XLPJ
	JMP	SHORT PRTNOW
XLPJ:
	JMP	XLP
;
;	Now Print a Line (4 color passes)
;
PRTNOW:
	CMP	YF,0		; Print Yellow Line?
	JE	SKPY		;  No
	MOV	BX,OFFSET YLINE	; Yellow Line Buffer
	MOV	DX,OFFSET SELY	; Select Yellow Ribbon
	CALL	PRTSTR
	CALL	PRTLIN
SKPY:
	CMP	MF,0		; Print Magenta line?
	JE	SKPM
	MOV	BX,OFFSET MLINE	; Magenta Line Buffer
	MOV	DX,OFFSET SELM	; Select Magenta Ribbon
	CALL 	PRTSTR
	CALL	PRTLIN
SKPM:
	CMP	CF,0		; Print Cyan Line?
	JE	SKPC
	MOV	BX,OFFSET CLINE	; Cyan Line Buffer
	MOV	DX,OFFSET SELC	; Select Cyan Ribbon
	CALL	PRTSTR
	CALL	PRTLIN
SKPC:
	CMP	BF,0		; Print Black Line?
	JE	SKPB
	MOV	BX,OFFSET BLINE	; Black Line Buffer
	MOV	DX,OFFSET SELB	; Select Black Ribbon
	CALL	PRTSTR
	CALL	PRTLIN
SKPB:
	MOV	DX,OFFSET GLF
	CALL	PRTSTR		; Do graphic line feed
;
	CMP	YSS,225		; Are we done?
	JE	DONE
	MOV	AX,YSS		; No - reset Y and do nxt line
	MOV	Y,AX
	MOV	YS,AX
	MOV	DX,YSSDX
	MOV	YSDX,DX
	JMP	LINLP
;
DONE:
	MOV	DX,OFFSET DONS	; Take printer out of graphic mode
	CALL	PRTSTR
	POP	DS
	POP	ES		; Restore segment regs and return
	RET	6
SDUMP	ENDP
	SUBTTL	Extract Color From (X,Y) Pixel
	PAGE
;
;	SUBROUTINE XTRCT
;
;	This subroutine will return in the BX register
;	the color of the point at screen location (X,Y).
;	The color is specified on the low order 3 bits of
;	the register with 1=blue, 2=green, and 4=red.
;
XTRCT	PROC	NEAR
	PUSH	CX
	PUSH	DX
	MOV	AX,Y
	DIV	NINE		; Y/9
	MOV	BL,AH	
	MOV	BH,0		; Remainder to BX
	MOV	AH,0		; Quotient in AX
	MOV	CL,11
	SHL	AX,CL		; Quotient * 800H
	MOV	CL,7
	SHL	BX,CL		; Remainder * 80H
	ADD	BX,AX
	MOV	AX,X
	DIV	EIGHT		; X/8
	MOV	CL,AH		; Remainder is Shift Count
	INC	CL
	MOV	AH,0		; Quotient to AX
	ADD	BX,AX
	MOV	DX,0D000H	; Red plane
	MOV	ES,DX
	MOV	AL,ES:[BX]
	RCL	AL,CL		; Rotate addressed bit to carry
	RCL	AH,1		; Now shift into acc (AH)
	MOV	DX,0E000H	; Green plane
	MOV	ES,DX
	MOV	AL,ES:[BX]
	RCL	AL,CL
	RCL	AH,1
	MOV	DX,0C000H	; Blue plane
	MOV	ES,DX
	MOV	AL,ES:[BX]
	RCL	AL,CL
	RCL	AH,1
	MOV	BL,AH		; Return in BX
	MOV	BH,0
	POP	DX
	POP	CX		; Restore regs and return
	RET
XTRCT	ENDP
	SUBTTL	PRINT LINE SUBROUTINE
	PAGE
;
;  	SUBROUTINE PRTLIN
;
;	This subroutine will print the 640 character line
;	buffer addressed by the BX register.
;
PRTLIN	PROC	NEAR
	PUSH 	CX
	MOV	CX,640
PRTLUP:
	PUSH	CX
	MOV	DL,BYTE PTR [BX]	; Character to print
	INC	BX
	MOV	CX,IX
DOT1:				; Loop using X multiplier
	MOV	AH,5
	INT	21H		; Print character
	LOOP	DOT1
	CMP	DL,3		; If ETX - must repeat
	JNE	DOPRTLP
	MOV	CX,IX
DOT2:
	MOV	AH,5
	INT	21H		; Repeat for ETX
	LOOP	DOT2
DOPRTLP:
	POP	CX
	LOOP	PRTLUP		; Do 640 times
	POP	CX
	RET
PRTLIN	ENDP
	SUBTTL 	SUBROUTINE TO PRINT A STRING
	PAGE
;
;	SUBROUTINE PRTSTR
;
;	This subroutine will print the string addressed
;	by DX.  The string is terminated by 0FFH.
;
PRTSTR	PROC	NEAR
	PUSH	BX
	MOV	BX,DX
PRTSLP:
	MOV	DL,BYTE PTR [BX]
	INC	BX
	CMP	DL,0FFH
	JE	PRTFIN		; Check for end of string
	MOV	AH,5
	INT	21H		; Print a character
	JMP	PRTSLP
PRTFIN:
	POP	BX
	RET
PRTSTR	ENDP
;
ENDPGM:
SDUMPS	ENDS
	END	START
