	TITLE 	COLOR Command
	PAGE	,132
;
;	COLOR Command
;
;	Author  R. A. Metz 		Date: 2/15/83
;
;	This command acts just like the BASIC COLOR command
;	except that it is accessible from Z-DOS.
;
;	For information on its use, enter the color command
;	with no parameters and an explaination will be displayed
;	on the CRT.
;
COLOR	SEGMENT
	ASSUME	DS:COLOR,CS:COLOR,SS:COLOR,ES:COLOR
	ORG	80H
BFR:
	ORG	100H
START:
	JMP	BEGIN
;
FGR	DB	'7'		; Default foreground color=white
BGR	DB	'0'		; Default background color=black
;
SELECT	DB	1BH,'m$'	; Color select sequence
;
CR	EQU	0DH
LF	EQU	0AH
;
MENU	DB	CR,LF
	DB	'This command acts just like the BASIC "COLOR"'
	DB	CR,LF
	DB	'command.  It is invoked by: "COLOR fgr[,bgr]"'
	DB	CR,LF
	DB	'Where fgr and bgr are color specifications for'
	DB	CR,LF
	DB	'foreground and background colors respectively.'
	DB	CR,LF
	DB	'If bgr is ommitted, it defaults to 0.  Colors '
	DB	CR,LF
	DB	'are as follows:'
	DB	CR,LF,LF
	DB	'  0 - black      4 - green'
	DB	CR,LF
	DB	'  1 - blue       5 - cyan'
	DB	CR,LF
	DB	'  2 - red        6 - yellow'
	DB	CR,LF
	DB	'  3 - magenta    7 - white'
	DB	CR,LF,'$'
;
BEGIN:
	MOV	BX,OFFSET BFR
	MOV	CH,0
	MOV	CL,[BX]
	INC	BX
	CMP	CL,0		; Check for parameter entry
	JNE	DOCOLOR
	MOV	DX,OFFSET MENU	; Display instructions on no
	MOV	AH,9		;  parameter entry
	INT	21H
	INT	20H
DOCOLOR:
	MOV	DI,OFFSET FGR
GTLUP:
	CMP	DI,OFFSET SELECT	; Done after 2 colors
	MOV	DL,[BX]
	INC	BX		; Get entered character
	CMP	DL,'0'		
	JL	LUP		; Ignore chrs lt '0'
	CMP	DL,'7'
	JG	LUP		; Ignore chrs gt '7'
	MOV	[DI],DL
	INC	DI
LUP:
	LOOP	GTLUP
SET_COLOR:
	MOV	DX,OFFSET SELECT
	MOV	AH,9		; Set color command
	INT	21H
	MOV	DL,FGR
	MOV	AH,2		; Foreground color
	INT	21H
	MOV	DL,BGR
	MOV	AH,2		; Background color
	INT	21H
;
	INT	20H		; Return to Z-DOS
;
COLOR	ENDS
	END	START
