;***********************************************************************/
;*	memtoscr.asm                                                  */
;***********************************************************************/
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC
PSEG

ENDIF

;
;**********************************************************************
;
;  This PROC is the converse of the SCRTOMEM PROC. MEMTOSCR places data from
;  an array or memory address into video ram at a specific offset.
;  It is called as follows:
;		MEMTOSCR(words,screen_offset,address);
;		where:
;		     int words; /* number of words to move - 16k max */
;		     int screen_offset; /* starting location on video memory*/
;		     unsigned address; /* pointer to array in either small  */
;				       /* or large models, or segment and   */
;				       /* offset combination for large data */
;				       /* models.                           */

;
	 ASSUME DS:NOTHING
         PUBLIC MEMTOSCR

IF @BIGMODEL+LPROG	;LARGE CODE MODELS
	MEMTOSCR  PROC	FAR
	WORDS	EQU	BP+6
	SCROFF	EQU	BP+8
	ARRAY	EQU	BP+10
ELSE
	MEMTOSCR  PROC	NEAR
	WORDS	EQU	BP+4
	SCROFF	EQU	BP+6
	ARRAY	EQU	BP+8
ENDIF

        PUSH BP             ;SAVE BP
        MOV BP,SP           ;SET BASE POINTER FOR PARAMETER LIST
	PUSH ES		    ;SAVE ES 	
        PUSH DS             ;SAVE DS
        MOV CX,[WORDS]  ;MOVE ACTUAL NUMBER OF WORDS TO MOVE INTO CX
        MOV DI,[SCROFF] ;MOVE OFFSET INTO DESTINATION REGISTER

IF @BIGMODEL+LDATA  ;LARGE DATA MODELS
	LDS SI,DWORD PTR [ARRAY]  ;SEGMENT AND OFFSET PASSED FOR LARGE MODEL
ELSE
	MOV SI,WORD PTR [ARRAY] ;OFFSET INTO SOURCE REG
ENDIF

        COLOR_MONO          ;MACRO TO DETERMINE VIDEO TYPE AND PUT STATUS
                            ;PORT ADDRESS INTO DX AND VIDEO ADDRESS IN AX
        MOV ES,AX           ;POINT ES TO VIDEO CARD
        CLD                 ;SET UP AUTO INCREMENT OF SI AND DI
MEMTOSCR1:
        CHK_RETRACE         ;WAIT FOR HORIZONTAL RETRACE TO READ FROM SCREEN
        MOVSW
        LOOP MEMTOSCR1        ;LOOP TILL END OF COUNT (CX)
        STI                 ;TURN INTERRUPTS BACK ON
        POP DS              ;RESTORE DS
	POP ES 		    ;RESTORE ES     
        POP BP              ;RESTORE BP
        RET  
MEMTOSCR   ENDP

;**********************************************************************
;
IFDEF CI_C86
@CODE	ENDS

ELSE
ENDPS

ENDIF
	END
