;***********************************************************************/
;*	hgrline.asm                                                   */
;***********************************************************************/
         PAGE ,132
         .SALL
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFNDEF CI_C86      ; DEFINED IN CI-C86.INC
@BIGMODEL EQU 0    ; required for Lattice to define flag below	
PSEG               ; macro defined in Lattice xM8086.MAC file

ENDIF

;***********************************************************************
;
;	FUNCTION TO DRAW A LINE IN COLOR. CALLED AS FOLLOWS:
;		GRLINE(X1,Y1,X2,Y2,COLOR);
;	WHERE:
;		INT X1,Y1; /* STARTING COORDINATES */
;		INT X2,Y2; /* ENDING COORDINATES */
;		INT COLOR; /* COLOR VALUE FROM 0 TO 4 */


	PUBLIC	GRLINE

IF @BIGMODEL+LPROG    ;LARGE CODE MODELS
GRLINE PROC FAR
FIRST EQU 6		;OFFSET FROM BP OF FIRST VARIABLE

ELSE			; SMALL CODE MODELS
GRLINE	PROC	NEAR
FIRST EQU 4		;OFFSET FROM BP OF FIRST VARIABLE
ENDIF

;
;	WE WILL USE STACK FOR LOCAL STORAGE
;
DELTAX	EQU 	-2	; STORE DIFFERENCE OF X2 - X1
DELTAY	EQU     -4	; STORE DIFFERENCE OF Y2 - Y1
HALFX	EQU     -6	; STORE EITHER DELTAX OR DELTA Y DIVIDED BY 2
HALFY	EQU	-6
COUNT	EQU 	-8	;NUMBER OF DOTS DRAWN ON LINE
SAVECNT	EQU	-10	;SAVE COUNT OF DOTS WRITTEN FOR RETURN

	PUSH BP
	MOV BP,SP
;	GET ABSOLUTE VALUE OF DELTAX
	MOV AX,[BP+FIRST+4]	;GET X2
	SUB AX,[BP+FIRST]	;SUBTRACT X1 FROM IT
	MOV DI,1		;ASSUME DELTAX IS POSITIVE AND SAVE
				; X INCREMENT VALUE IN DI
	JGE PROCEED1		; CONTINUE IF POSITIVE
	MOV DI,-1		; X DECREMENT VALUE IN DI
	NEG AX			; GET ABSOLUTE VALUE
PROCEED1:
	PUSH AX			; STORE DELTAX ON STACK
;	GET ABSOLUTE VALUE OF DELTAY
	MOV AX,[BP+FIRST+6]	;GET Y2
	SUB AX,[BP+FIRST+2]	;SUBTRACT Y1 FROM IT
	MOV SI,1		;ASSUME POSITIVE DELTAY
	JGE PROCEED2		;CONTINUE IF POSITIVE
	MOV SI,-1		;DECREMENT VALUE FOR Y IN SI
	NEG AX			;GET ABSOLUTE VALUE
PROCEED2:
	PUSH AX			;SAVE DELTAY ON STACK
; SEE IF SLOPE IS GREATER THAN ONE
	CMP [BP+DELTAX],AX
	JGE  LT1			; SLOPE < 1
	JMP  GT1
; CODE FOR SLOPE LESS THAN 1
LT1:
	MOV AX,[BP+DELTAX]	;GET DELTAX AND
	SHR AX,1		;DIVIDE IT BY 2
	PUSH AX			;STORE HALFX ON STACK
	XOR BX,BX		;INITIALIZE ERROR TERM TO 0
	PUSH [BP+DELTAX]	;COUNT EQUALS DELTAX AT START, STORE IT
	PUSH [BP+DELTAX]	;SAVE COUNT FOR RETURN
	MOV CX,[BP+FIRST]	;X1 
	MOV DX,[BP+FIRST+2]	;Y1
DOTLOOP1:
	MOV AL,BYTE PTR [BP+FIRST+8] 	; COLOR IN AL
        MOV AH,12                       ;BIOS WRITE DOT FUNCTION
        INT 10H                 ;BIOS VIDEO I/O INTERRUPT
	ADD CX,DI		;INC/DEC X
	ADD BX,[BP+DELTAY]	;ADD DELTAY TO ERROR TERM
	CMP BX,[BP+HALFX]	;IS ERROR TERM > HALF OF DELTAX
	JLE NOCHANGE1		;DO NOT INC/DEC Y
	SUB BX,[BP+DELTAX]	;SUBTRACT DELTAX FROM ERROR TERM
	ADD DX,SI		;INC/DEC Y
NOCHANGE1:
	DEC WORD PTR [BP+COUNT]		;COUNT = COUNT - 1
	JGE DOTLOOP1		;PLOT NEXT DOT IF COUNT > 0
	JMP FINISHED
; SLOPE > 1
GT1:
	MOV AX,[BP+DELTAY]	;GET DELTAY AND
	SHR AX,1		;DIVIDE IT BY 2
	PUSH AX			;STORE IT LOCALLY
	XOR BX,BX		;INITIALIZE ERROR TERM TO 0
	PUSH [BP+DELTAY]	;COUNT OF NUMBER OF DOTS SET TO DELTAY
	PUSH [BP+DELTAY]	;SAVE COUNT FOR RETURN
	MOV CX,[BP+FIRST]	;X1 
	MOV DX,[BP+FIRST+2]	;Y1
DOTLOOP2:
	MOV AL,BYTE PTR [BP+FIRST+8] 	; COLOR IN AL
        MOV AH,12                       ;BIOS WRITE DOT FUNCTION
        INT 10H                 ;BIOS VIDEO I/O INTERRUPT
	ADD DX,SI		;INC/DEC Y
	ADD BX,[BP+DELTAX]	;ADD DELTAX TO ERROR TERM
	CMP BX,[BP+HALFY]	;IS ERROR TERM > HALF OF DELTAY
	JLE NOCHANGE2		;DO NOT INC/DEC X
	SUB BX,[BP+DELTAY]	;SUBTRACT DELTAY FROM ERROR TERM
	ADD CX,DI		;INC/DEC X
NOCHANGE2:
	DEC WORD PTR [BP+COUNT]		;COUNT = COUNT - 1
	JGE DOTLOOP2		;WRITE NEXT DOT IF COUNT > 0
FINISHED:
	MOV AX,[BP+SAVECNT]	;RETURN NUMBER OF DOTS WRITTEN
	ADD SP,10		;CLEAR LOCAL STORAGE
	POP BP			;RESTORE CALLER'S BP
	RET

GRLINE  ENDP
;
IFDEF CI_C86
@CODE	ENDS

ELSE
ENDPS
ENDIF
	END
