;***********************************************************************/
;*	gdosint.asm                                                   */
;***********************************************************************/

         PAGE ,132
         TITLE GDOSINT.ASM LISTING
         .SALL
;
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS          ; DEFINED IN LATTICE/MICROSOFT 2.0 M8086 FILES

@BIGMODEL EQU 0      ; DEFINE FOR IFS BELOW, NOT VALID FOR LAT/MIC, ONLY C86
PSEG                 ; MACRO DEFINED IN LAT/MIC M8086 HEADER

ENDIF
;
;
;****************************************************************************
;
;	THIS IS A GENERAL DOS/BIOS INTERRUPT PROCEDURE. IT IS CALLED
;	FROM C FUNCTIONS AS FOLLOWS:
;
;	ret_code = gdosint(int_no,&inregs,&outregs);
;
;	WHERE:
;	int int_no; /* interrupt number to invoke */
;	struct intregs inregs,outregs; /* interrupt register structs */
;
;
;
	ASSUME DS:NOTHING
	PUBLIC GDOSINT


IF @BIGMODEL+LPROG      ; LARGE CODE MODELS
	GDOSINT	PROC	FAR
	INTERUPT  EQU	6
	INREG   EQU	8
ELSE
	GDOSINT	PROC	NEAR
	INTERUPT  EQU	4
	INREG   EQU	6
ENDIF

IF @BIGMODEL+LDATA      ; LARGE DATA MODELS
	OUTREG  EQU	INREG + 4
ELSE
	OUTREG  EQU	INREG + 2
ENDIF

	LOCSTORE EQU	-2	; OFFSET FROM BP FOR LOCAL STORAGE
	
	JMP START	; START EXECUTION AFTER STORAGE AREA

HOLDSS	DW	0	; SAVE SS REGISTER AND SP REGISTER FOR USE
HOLDSP	DW	0	; WHEN CALLING OTHER PROGRAMS FROM HERE
START:

	PUSH BP
	MOV BP,SP
	PUSH AX		       ; LOCAL STORAGE FOR RETURN CODE LATER	
	PUSH ES		       ; PRESERVE ES AND DS	
	PUSH DS

	CMP WORD PTR [BP+INTERUPT],0  ; LOOK FOR INTERRUPT 0 - WHICH RETURNS 
                               ; CURRENT VALUES OF REGISTERS          
	JNE O_K		       ; CONTINUE IF IT IS NOT A ZERO
			       ; OTHERWISE RETURN REGISTER VALUES
	JMP ZERO_RET	       
O_K:        

IF @BIGMODEL+LDATA      ; LARGE DATA MODELS
	PUSH DS			; PRESERVE DS IN CASE WE NEED IT AS DEFAULT
	LDS SI,DWORD PTR [BP+INREG]
	
ELSE
	MOV SI,WORD PTR [BP+INREG]
ENDIF
			; DO ES, DS AND SI LAST
	MOV DI,[SI+6]
	MOV AH,[SI+8]
	MOV AL,[SI+10]
	MOV BH,[SI+12]
	MOV BL,[SI+14]
	MOV CH,[SI+16]
	MOV CL,[SI+18]
	MOV DH,[SI+20]
	MOV DL,[SI+22]
	PUSH AX   	; SAVE WHILE IN USE
	CMP WORD PTR [SI+2],0 	; CHECK FOR DEFAULT FOR ES (0)
	JE SKIPIT1		; IF DEFAULT, SKIP OVER CODE TO CHANGE IT
	MOV AX,[SI+2]
	MOV ES,AX
SKIPIT1:
	POP AX		; RECOVER AX
	MOV SI,[SI+4]	; INITIALIZE SI

IF @BIGMODEL+LDATA      ; LARGE DATA MODELS
	POP DS
ENDIF

        PUSH AX             ; SET UP FOR INTERRUPT REPLACEMENT
        PUSH BX
        MOV AL,[BP+INTERUPT]         ; PUT INTERRUPT NUMBER IN AL
        CALL NEXTBYTE       ; PUT ADDRESS OF NEXT BYTE ON STACK

NEXTBYTE:
TEMP EQU THIS BYTE
        POP BX              ; THIS ADDRESS IN BX - 1
        ADD BX,INTBYTE-TEMP+1  ; PUT ADDRESS OF INTERRUPT INSTRUCTION IN BX
        MOV CS:[BX],AL      ; CHANGE INSTRUCTION FOR PROPER INTERRUPT
        POP BX              ; RESTORE BX AND AX
        POP AX
        PUSH BP         ; PREVENTS AN INTERMITTENT BIOS BUG FROM CLOBBERING BP
        PUSH DS
	PUSH SI		; PUSH VALUE TO BE PLACED IN SI

IF @BIGMODEL+LDATA      ; LARGE DATA MODELS
	PUSH DS			; PRESERVE DS IN CASE WE NEED IT AS DEFAULT
	LDS SI,DWORD PTR [BP+INREG]
	
ELSE
	MOV SI,WORD PTR [BP+INREG]
ENDIF

	CMP WORD PTR [SI],0	; CHECK FOR DEFAULT (0) FOR DS
	JE SKIPIT2	        ; JUMP IF IT IS DEFAULT
	PUSH [SI]
	POP DS

IF @BIGMODEL+LDATA      	; LARGE DATA MODELS
	POP [BP+INTERUPT]	; DISGARD DS WE SAVED IN CASE DEFAULT WAS
				; CHOSEN - IF WE REACHED HERE WE ARE NOT
				; USING THE DEFAULT DS.
	JMP SKIPIT3             ; JUMP OVER POP INSTRUCTION IF LARGE DATA 
				; MODEL AND OVERIDING DEFAULT DS

ENDIF


SKIPIT2:

IF @BIGMODEL+LDATA      ; LARGE DATA MODELS
	POP DS		; RESTORE DS BECAUSE WE ARE USING DEFAULT
ENDIF

SKIPIT3:
	POP SI
        MOV CS:HOLDSS,SS    ; SAVE SS	
        MOV CS:HOLDSP,SP    ; SAVE SP
        CLC                 ; CLEAR CARRY TO TEST FOR DOS 2.0 ERROR LATER

INTBYTE EQU THIS BYTE
        INT 00H             ; WILL BE REPLACED BY ACTUAL INTERRUPT NUMBER

        CLI
        MOV SS,CS:HOLDSS ; RECOVER SS AND SP REGISTERS TO RESTORE STACK TO
        MOV SP,CS:HOLDSP ; THIS PROGRAM. NEEDED WHEN USING INT 21H TO CALL
			 ; FUNCTION 4BH (EXEC) WHICH CAN RUN ANOTHER PROGRAM
        STI
        POP DS		; RECOVER THE DATA SEGMENT
        POP BP          ; GET BP BACK

        JC  AN_ERROR        ; DOS 2.0 ERROR CHECK
        JMP SHORT ZERO_RET  ; SKIP ERROR PROCESSING IF OK

AN_ERROR:
	MOV WORD PTR [BP+LOCSTORE],AX	;PASS DOS RETURN CODE BACK TO CALLER
        CMP AX,0	; IF FOR SOME REASON DOS RETURNS AN ERROR AND THE
			; ERROR CODE IS 0- FORCE IT TO A 99 TO LET CALLER
			; KNOW THERE WAS AN UNKNOWN ERROR
        JNE END_IT
	MOV WORD PTR [BP+LOCSTORE],99
        JMP SHORT END_IT

ZERO_RET:
       MOV WORD PTR [BP+LOCSTORE],0  ; SEND BACK GOOD RETURN CODE
END_IT:

	PUSH DI
	PUSH ES

IF @BIGMODEL+LDATA      ; LARGE DATA MODELS
	LES DI,DWORD PTR [BP+OUTREG]
ELSE
	PUSH DS		;SET UP ES FOR REP STOSW INSTRUCTION
	POP ES
	MOV DI,WORD PTR [BP+OUTREG]
ENDIF

	PUSH DI			;SAVE POINTER TO STRUCTURE
	PUSH AX
	PUSH CX
	XOR AX,AX		; ZERO IT OUT
	MOV CX,12		; ZERO OUT 12 WORDS OF STRUCTURE
REP	STOSW
	POP CX
	POP AX
	POP DI		; RECOVER POINTER TO STRUCTURE
	MOV ES:[DI],DS
	PUSH ES		; USE DS FOR ADDRESSING DEFAULT
	POP DS
	POP ES		; RECOVER STORED ES
	MOV [DI+2],ES
	MOV [DI+4],SI
	MOV [DI+8],AH
	MOV [DI+10],AL
	MOV [DI+12],BH
	MOV [DI+14],BL
	MOV [DI+16],CH
	MOV [DI+18],CL
	MOV [DI+20],DH
	MOV [DI+22],DL
	POP [DI+6]	;SAVED VALUE OF DI

	POP DS
	POP ES
	POP AX		;RETURN CODE SET IN LOCSTORE
	POP BP

        RET
GDOSINT ENDP
;
;
;***************************************************************************

;
;
;
IFDEF CI_C86

@CODE	ENDS

ELSE

ENDPS

ENDIF
	END
