	PAGE	60,132

	TITLE	WAIT.COM - Pause Execution of DOS Batch Files

;	Version 1.2 (C) 06-Jul-86 by John Stetson

;	This program is designed to allow the user to
;	prematurely terminate a .BAT file at a predetermined
;	point, if desired.  If no action is taken, the
;	program will time-out after about 15 seconds (at 8MHz)
;	and execution of the .BAT file will continue normally.
;	Pressing any key except ESC, CTRL-C, or CTRL-BREAK,
;	will cause the .BAT file to continue execution
;	immediately.  These keys will cause the user to be
;	prompted; the user may either abort or continue.

;	This capability is especially useful in .BAT files
;	which execute the assembler, or a compiler - if there
;	were errors in the assembly or compilation, the user
;	can abort immediately, without attempting to perform
;	a LINK, EXE2BIN, etc.  If the user is not present,
;	however, the .BAT file will still run to completion.

;	Sample ASMCOM.BAT file:

;	masm %1.asm,%1.obj;
;	wait
;	link %1.obj,%1.exe;
;	del %1.obj
;	exe2bin %1.exe %1.com
;	del %1.exe

;	Definitions

EXIT	EQU	20H		;Program Terminate
CTLC	EQU	23H		;Control-C Exit

MSDOS	EQU	21H		;System Functions
OUTCHR	EQU	02H		;Output Character
DCIO	EQU	06H		;Direct Console I/O
OUTSTR	EQU	09H		;Output String
KEYSTAT EQU	0BH		;Keyboard Status

ESC	EQU	1BH		;Escape character

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	Start of program

	ORG	100H

WAIT	EQU	$

;	Primary loop

LOOP1:	MOV	DL,COUNT1	;Get primary count value
	OR	DL,'0'		;Make printable
	MOV	AH,OUTCHR
	INT	MSDOS		;Display count value

	MOV	AH,OUTSTR
	MOV	DX,OFFSET DOTS
	INT	MSDOS		;Display dots

	MOV	COUNT2,16	;Init secondary count

;	Secondary loop

LOOP2:	MOV	CX,255		;Init tertiary count

;	Tertiary loop

LOOP3:	MOV	AH,KEYSTAT
	INT	MSDOS		;Check keyboard

	CMP	AL,0FFH 	;Key pressed?
	JNZ	NEXT		;Jump if not

	MOV	DL,0FFH
	MOV	AH,DCIO
	INT	MSDOS		;Get character

	CMP	AL,ESC		;Was it ESCAPE?
	JNZ	BYE		;Jump if not - exit

	INT	CTLC		;Pretend it was CTRL-C

NEXT:	LOOP	LOOP3		;Decrement tertiary count

	DEC	COUNT2		;Decrement secondary count
	JNZ	LOOP2

	DEC	COUNT1		;Decrement primary count
	JNZ	LOOP1

BYE:	INT	EXIT		;Exit to DOS

;	Data Areas

DOTS	DB	'...$'
COUNT1	DB	3		;Primary count value (3...0)
COUNT2	DW	0		;Secondary count value (16...0)

CODE	ENDS

	END	WAIT
