/***********************************************************************/
/*	rdchatr.c                                                     */
/***********************************************************************/
#include "intregs.h"
rdchatr(charac,forgrnd,bakrnd) /* get the character and attribute at cursor */
int *forgrnd; /* pointer to foreground variable in caller */
int *bakrnd; /* pointer to background variable in caller */
char *charac; /* pointer to character to be returned in caller */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=15;  /* get current mode. sets bh = current display page  */
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=8;
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  *charac=regs.al;
  *bakrnd=  (regs.ah >> 4) & 0x0007;
  if (  (regs.ah >> 7) == 0 ){
     *forgrnd=  regs.ah & 0x000F;
  }else{
     *forgrnd= (regs.ah & 0x000F) + 16;
  }
}
