/***********************************************************************/
/*	curlocat.c                                                    */
/***********************************************************************/

curlocat(row,col) /* locate the cursor at the row & column passed */
int row,col;
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
  int act_page; /* the current active display page */
  int mode; /* the current video mode */
  int num_cols; /* the current setting for column width */

  if ( row < 0 || row > 25 || col < 0 || col > 79) /* invalid parameters */
    return(-1); 
  getscmod(&mode,&num_cols,&act_page); /* get current settings */
  regs.ah=2;
  regs.bh=act_page;
  regs.dh=row;
  regs.dl=col;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  int_no=0x10; /* video I/O BIOS interrupt */
  ret_code = gdosint(int_no,&regs,&regs);
  return(0);
}
