/***********************************************************************/
/*	shrinkm2.c
/***********************************************************************/
 
/* Lattice Ver. 2.0 version of shrinkm */
shrinkm2(size)
unsigned *size;  /* return the size of the current program + data */
{
  extern unsigned _TOP; /* top of stack as offset to ss register */
  extern long int _PSP; /* program segment prefix segment and offset */
  unsigned tot_used;    /* total memory being used by calling program + data */
  struct SREGS regs;    /* segment register structure for segread function */
  unsigned pseg;        /* segment address of program segment prefix */
  unsigned seg_top;     /* segment address of top of program (and stack top) */


  pseg = hiword(_PSP); /* get segment word of _PSP */
  segread(&regs);   /* get segment register values ( SS in particular) */
  seg_top = regs.ss + (_TOP / 16) + 1; /* get segment address of _TOP */ 
  tot_used = (seg_top - pseg); /* memory used in paragraphs */
  return(setmblk(pseg,tot_used,size));   /* set memory blocks to minimum */
}
