10 '   /********************************************************************\
20 '   *                                                                    *
30 '   *                    Chronograph Control Program                     *
40 '   *                                                                    *
50 '   *  Allows setting of all functions for the Hayes chronograph clock.  *
60 '   *                                                                    *
70 '   *   by: Larry D. Wakeford                          Date: 12/28/83    *
80 '   *                                                                    *
90 '   \********************************************************************/
100 '
110 '            Initialize DAY$ array & keyboard address constants
120 '
130 DIM DAY$(6)
140 DAY$(0)="Monday   "
150 DAY$(1)="Tuesday  "
160 DAY$(2)="Wednesday"
170 DAY$(3)="Thursday "
180 DAY$(4)="Friday   "
190 DAY$(5)="Saturday "
200 DAY$(6)="Sunday   "
210 '
220 KBSTAT=&HF5:KBDATA=&HF4
230 '
240 '           Show menu, get action, branch to correct routine.
250 '
260 COLOR 7,1:CLS:GOSUB 510
270 LOCATE 21,1:PRINT SPACE$(80);
275 COLOR 6,0:LOCATE 21,26:PRINT " Select desired function ";:COLOR 7,1
280 OUT KBSTAT,0
290 WAIT KBSTAT,1
300 ACTION=INP(KBDATA):FOR I=1 TO 15:GC$=INKEY$:NEXT
310 IF ACTION=27 THEN COLOR 7,0:CLS:END
320 IF ACTION => 151 THEN ACTION = ACTION-142

                          ELSE ACTION = ACTION-48
330 IF ACTION <1 OR ACTION >16 THEN BEEP:GOTO 270
340 ON ACTION GOSUB 740,820,900,970,1050,1130,1210,1290,1370,1520,

                    1650,1790,1940,2060,2180,2260
350 LOCATE 23,1:PRINT SPACE$(80);:GOTO 270
360 '
370 '           Input/Output routine for Hayes chronograph.
380 '
390 IF OST$="" THEN 470
400 OPEN "COM1:1200,N,8,1" AS #1
410 FOR Z=1 TO 4:NEXT Z
420 PRINT #1,OST$;
430 OST$=""
440 PRINT #1,CHR$(13);:IST$=""
450 IF LOC(1)<CHAR THEN 450
460 IST$=INPUT$(CHAR,#1)
470 CLOSE #1:RETURN
480 '
490 '         Display chronograph menu
500 '
510 SCREEN 1,0:LOCATE 2,22:COLOR 6,0
520 PRINT "faaaaaaaaaaaaaaaaaaaaaaaaaaaaaac";
530 LOCATE 3,22:PRINT "`";:LOCATE 3,53:PRINT "`";
540 LOCATE 4,22
550 PRINT "eaaaaaaaaaaaaaaaaaaaaaaaaaaaaaad";
560 SCREEN 0:LOCATE 3,23:PRINT "   ChronoGraph control menu   ";:COLOR 7,1
570 LOCATE 9,11:PRINT "(F1)  Set Time";:LOCATE 9,44:PRINT "(1)  Read Time";
580 LOCATE 10,11:PRINT "(F2)  Set Date";:LOCATE 10,44:PRINT "(2)  Read Date";
590 LOCATE 11,11:PRINT "(F3)  Set Day of week";:LOCATE 11,44
600 PRINT "(3)  Read Day of week";:LOCATE 12,11:PRINT "(F4)  Set Alarm Time";
610 LOCATE 12,44:PRINT "(4)  Clear Alarm";:LOCATE 13,11
620 PRINT "(F5)  Set Time seperator";:LOCATE 13,44
630 PRINT "(5)  Clear Time seperator";:LOCATE 14,11
640 PRINT "(F6)  Set Date seperator";:LOCATE 14,44:
650 PRINT "(6)  Clear Date seperator";:LOCATE 15,11:PRINT "(F7)  Display Time";
660 LOCATE 15,44:PRINT "(7)  Display Date";:LOCATE 16,11
670 PRINT "(F8)  Line feed option on";:LOCATE 16,44
680 PRINT "(8)  Line feed option off";:LOCATE 18,9
690 PRINT "(Return) aborts a Set function";:LOCATE 18,43
700 PRINT "(Esc) to exit the program";:RETURN
710 '
720 '          Read time routine
730 '
740 CHAR=8:OST$="ATRT":IF NTIME=1 THEN CHAR=6
750 GOSUB 390
760 LOCATE 21,1:PRINT SPACE$(80);
770 LOCATE 21,23:PRINT "The chronograph time is ";IST$;
780 GOTO 2340
790 '
800 '          Read date routine
810 '
820 CHAR=8:OST$="ATRD":IF NDATE=1 THEN CHAR=6
830 GOSUB 390
840 LOCATE 21,1:PRINT SPACE$(80);
850 LOCATE 21,23:PRINT "The chronograph Date is ";IST$
860 GOTO 2340
870 '
880 '          Read day routine
890 '
900 CHAR=1:OST$="ATRW":GOSUB 390
910 LOCATE 21,1:PRINT SPACE$(80);
920 LOCATE 21,22:PRINT "The chronograph weekday is ";DAY$(VAL(IST$))
930 GOTO 2340
940 '
950 '          Clear alarm routine
960 '
970 CHAR=1:OST$="ATAC":GOSUB 390
980 LOCATE 21,1:PRINT SPACE$(80);
990 GOSUB 2400
1000 IF OK=0 THEN LOCATE 21,25:PRINT "Chronograph Alarm cleared";
1010 GOTO 2340
1020 '
1030 '          Clear time seperator
1040 '
1050 CHAR=1:OST$="ATVT":GOSUB 390
1060 LOCATE 21,1:PRINT SPACE$(80);
1070 GOSUB 2400
1080 IF OK=0 THEN LOCATE 21,21:PRINT "The Time seperator has been cleared";
1090 NTIME=1:GOTO 2340
1100 '
1110 '          Clear date seperator
1120 '
1130 CHAR=1:OST$="ATVD":GOSUB 390
1140 LOCATE 21,1:PRINT SPACE$(80);
1150 GOSUB 2400
1160 IF OK=0 THEN LOCATE 21,21:PRINT "The Date seperator has been cleared";
1170 NDATE=1:GOTO 2340
1180 '
1190 '          Display date on chronograph
1200 '
1210 CHAR=1:OST$="ATDD":GOSUB 390
1220 LOCATE 21,1:PRINT SPACE$(80);
1230 GOSUB 2400
1240 IF OK=0 THEN LOCATE 21,23:PRINT "Chronograph set to display Date.";
1250 GOTO 2340
1260 '
1270 '          Turn line feed option off
1280 '
1290 CHAR=1:OST$="ATLC":GOSUB 390
1300 LOCATE 21,1:PRINT SPACE$(80);
1310 GOSUB 2400
1320 IF OK=0 THEN LOCATE 21,24:PRINT "Line feed option turned off.";
1330 GOTO 2340
1340 '
1350 '          Set time routine
1360 '
1370 LOCATE 21,1:PRINT SPACE$(80);:LOCATE 23,1:PRINT SPACE$(80);
1380 LOCATE 21,18
1390 PRINT "Enter Time in ONE of the following formats ";
1400 LOCATE 23,13
1410 PRINT "(24 Hour = HHMM00) or (12 Hour = HHMM00A or HHMM00P): ";
1420 LINE INPUT;"";T$
1430 IF T$="" THEN RETURN
1440 IF LEN(T$)<6 OR LEN(T$)>7 THEN EFLAG=1:GOSUB 2440:GOTO 1370
1442 IF RIGHT$(T$,1)="A" THEN IF VAL(T$)>125900! THEN 

                                 EFLAG=2:GOSUB 2440:GOTO 1370
1444 IF RIGHT$(T$,1)="P" THEN IF VAL(T$)>125900! THEN 

                                 EFLAG=2:GOSUB 2440:GOTO 1370
1446 IF RIGHT$(T$,1)="0" THEN IF VAL(T$)>235900! THEN 

                                 EFLAG=3:GOSUB 2440:GOTO 1370
1450 LOCATE 21,1:PRINT SPACE$(80);:LOCATE 23,1:PRINT SPACE$(80);
1460 CHAR=1:OST$="ATST"+T$:GOSUB 390:GOSUB 2400
1470 IF OK=0 THEN LOCATE 21,27:PRINT "Time setting accepted.";
1480 GOTO 2340
1490 '
1500 '          Set Date routine
1510 '
1520 LOCATE 21,1:PRINT SPACE$(80);
1530 LOCATE 21,15
1540 PRINT "Enter the Date in the following form (YYMMDD): ";
1550 LINE INPUT;"";T$
1560 IF T$="" THEN RETURN
1570 IF LEN(T$)<>6 THEN BEEP:CLS:GOSUB 510:GOTO 1520
1580 LOCATE 21,1:PRINT SPACE$(80);
1590 CHAR=1:OST$="ATSD"+T$:GOSUB 390:GOSUB 2400
1600 IF OK=0 THEN LOCATE 21,27:PRINT "Date setting accepted.";
1610 GOTO 2340
1620 '
1630 '          Set weekday routine
1640 '
1650 LOCATE 21,1:PRINT SPACE$(80);:LOCATE 23,1:PRINT SPACE$(80);
1660 LOCATE 21,17
1670 PRINT "Enter number for the desired day of the week";
1680 LOCATE 23,14
1690 PRINT "(0=Mon, 1=Tue, 2=Wed, 3=Thu, 4=Fri, 5=Sat, 6=Sun): ";
1700 T$=INPUT$(1):IF T$=CHR$(13) THEN RETURN ELSE PRINT T$;
1710 IF T$<"0" OR T$>"6" THEN BEEP:GOTO 1650
1720 LOCATE 21,1:PRINT SPACE$(80);:LOCATE 23,1:PRINT SPACE$(80);
1730 CHAR=1:OST$="ATSW"+T$:GOSUB 390:GOSUB 2400
1740 IF OK=0 THEN LOCATE 21,27:PRINT "Day setting accepted.";
1750 GOTO 2340
1760 '
1770 '          Set alarm time
1780 '
1790 LOCATE 21,1:PRINT SPACE$(80);:LOCATE 23,1:PRINT SPACE$(80);
1800 LOCATE 21,16
1810 PRINT "Enter Alarm time in ONE of the following formats";
1820 LOCATE 23,16
1830 PRINT "(24 Hour = HHMM) or (12 Hour = HHMMA or HHMMP): ";
1840 LINE INPUT;"";T$
1850 IF T$="" THEN RETURN
1860 IF LEN(T$)<4 OR LEN (T$)>5 THEN EFLAG=1:GOSUB 2440:GOTO 1790
1862 IF RIGHT$(T$,1)="A" THEN IF VAL(T$)>1259 THEN EFLAG=2:GOSUB 2440:GOTO 1790
1864 IF RIGHT$(T$,1)="P" THEN IF VAL(T$)>1259 THEN EFLAG=2:GOSUB 2440:GOTO 1790
1866 IF LEN(T$)=4 THEN IF VAL(T$)>2359 THEN EFLAG=3:GOSUB 2440:GOTO 1790
1870 LOCATE 21,1:PRINT SPACE$(80);:LOCATE 23,1:PRINT SPACE$(80);
1880 CHAR=1:OST$="ATAS"+T$:GOSUB 390:GOSUB 2400
1890 IF OK=0 THEN LOCATE 21,27:PRINT "Alarm setting accepted.";
1900 GOTO 2340
1910 '
1920 '          Set time seperator
1930 '
1940 LOCATE 21,1:PRINT SPACE$(80);
1950 LOCATE 21,15:PRINT "Type the character to use for Time seperator: ";
1960 T$=INPUT$(1):IF T$=CHR$(13) THEN RETURN
1970 IF ASC(T$)<32 OR ASC(T$)>126 THEN BEEP:GOTO 1940
1980 PRINT T$;:LOCATE 21,1:PRINT SPACE$(80);
1990 CHAR=1:OST$="ATVT"+T$:GOSUB 390:GOSUB 2400
2000 IF OK=0 THEN LOCATE 21,23:PRINT "Time seperator (";T$;") accepted.";
2010 IF OK=0 THEN NTIME=0
2020 GOTO 2340
2030 '
2040 '          Set Date seperator
2050 '
2060 LOCATE 21,1:PRINT SPACE$(80);
2070 LOCATE 21,15:PRINT "Type the character to use for Date seperator: ";
2080 T$=INPUT$(1):IF T$=CHR$(13) THEN RETURN
2090 IF ASC(T$)<32 OR ASC(T$)>126 THEN BEEP:GOTO 2060
2100 PRINT T$;:LOCATE 21,1:PRINT SPACE$(80);
2110 CHAR=1:OST$="ATVD"+T$:GOSUB 390:GOSUB 2400
2120 IF OK=0 THEN LOCATE 21,23:PRINT "Date seperator (";T$;") accepted.";
2130 IF OK=0 THEN NDATE=0
2140 GOTO 2340
2150 '
2160 '          Display time on chronograph
2170 '
2180 CHAR=1:OST$="ATDT":GOSUB 390
2190 LOCATE 21,1:PRINT SPACE$(80);
2200 GOSUB 2400
2210 IF OK=0 THEN LOCATE 21,23:PRINT "Chronograph set to display Time.";
2220 GOTO 2340
2230 '
2240 '         Turn line feed option on
2250 '
2260 CHAR=1:OST$="ATLS":GOSUB 390
2270 LOCATE 21,1:PRINT SPACE$(80);
2280 GOSUB 2400
2290 IF OK=0 THEN LOCATE 21,24:PRINT "Line feed option turned on.";
2300 GOTO 2340
2310 '
2320 '         Delay routine
2330 '
2340 LOCATE 24,1,0
2350 FOR DELAY=1 TO 4:TEMP$=TIME$:WHILE TEMP$=TIME$:WEND:NEXT
2360 LOCATE ,,1:RETURN
2370 '
2380 '         Chronograph error check routine
2390 '
2400 OK=VAL(IST$)
2410 IF OK=8 THEN LOCATE 21,22:BEEP:PRINT "Syntax ERROR for this function";
2420 IF OK=9 THEN LOCATE 21,18:BEEP:

                   PRINT "Write protect switch up - command ignored.";
2430 RETURN
2440 '
2450 '         Error handler for time and alarm settings
2460 '
2470 BEEP:LOCATE 25,1:PRINT SPACE$(80);:COLOR 6,0
2480 ON EFLAG GOTO 2490,2500,2510
2490 LOCATE 25,20:PRINT " Invalid entry length - Please retry! ";:GOTO 2520
2500 LOCATE 25,17:PRINT " Invalid 12 Hour Time format - Please retry! ";

                 :GOTO 2520
2510 LOCATE 25,17:PRINT " Invalid 24 Hour Time format - Please retry! ";
2520 GOSUB 2340:COLOR 7,1:LOCATE 25,1:PRINT SPACE$(80);:CLS:GOSUB 510:RETURN
 Invalid 24 Hour Time format - Please retry! ";
2520 GOSUB 2340:COLOR 7,1:LOCATE 25,1:PRINT SPACE$(8