	PAGE	,132
M	EQU	BYTE PTR 0[BX]
;	TAB2SPC
;
;	THIS PROGRAM CONVERTS TABS TO SPACES IN A TEXT FILE,
;	MAINTAINING THE FILE APPEARANCE.

;
;	BY P. SWAYNE, HUG  23-APR-85
;
	
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5
MDOS	LABEL	NEAR
	ORG	5CH
FCB	LABEL	BYTE			;DEFAULT FCB LOCATION
	ORG	80H
DTA	LABEL	NEAR
	ORG	100H

;	CONSTANTS

CONIN	EQU	1			;BDOS CONSOLE INPUT
CONOUT	EQU	2			;OUTPUT
PRINT	EQU	9			;PRINT FUNCTION
READ	EQU	10			;READ CONSOLE BUFFER
OPEN	EQU	15			;OPEN FILE
CLOSE	EQU	16			;CLOSE FILE
DELETE	EQU	19			;DELETE FILE
DREAD	EQU	27H			;DISK READ
DWRITE	EQU	21			;DISK WRITE
MAKE	EQU	22			;MAKE FILE
SETDMA	EQU	26			;SET DMA ADDR
FLAGS	EQU	30			;SET FILE ATTRIBUTES
BDOS	EQU	5			;CALL BDOS HERE

;	MAIN PROGRAM

TAB2SPC:MOV	SP,OFFSET (BA.STACK)	;SET NEW STACK
	MOV	BX,WORD PTR MDOS+1	;GET BDOS ADDRESS
	MOV	WORD PTR MEMTOP,BX	;STORE AS MEMORY TOP
	MOV	AL,BYTE PTR DTA
	OR	AL,AL			;ANY FILE ENTERED?
	JNZ	GOTFIL			;YES
	MOV	DX,OFFSET (NOFILE)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "NO FILE"
	INT	20H
GOTFIL:	MOV	SI,OFFSET (FCB)
	MOV	DI,OFFSET (FCB2)	;PREPARE SECOND FCB
	MOV	CX,9			;MOVE 9 CHARACTERS
	CLD
	REP	MOVSB			;MOVE FILE NAME TO FCB2
	MOV	DX,OFFSET (FCB)
	MOV	CL,OPEN
	CALL	MDOS			;TRY TO OPEN SOURCE FILE
	INC	AL
	JNZ	OPENED			;OPENED OK
	MOV	DX,OFFSET (NOOPEN)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "CAN'T OPEN"
	INT	20H
OPENED:	MOV	WORD PTR FCB+14,1	;SET RECORD SIZE TO 1
	MOV	DI,(OFFSET FCB)+32
	XOR	AL,AL
	MOV	CX,6
	CLD
	REP	STOSB			;CLEAR RECORD BYTES
	MOV	DX,OFFSET (FCB2)
	MOV	CL,DELETE
	CALL	MDOS			;DELETE OLD OUTPUT IF THERE
	MOV	DX,OFFSET (FCB2)
	MOV	CL,MAKE
	CALL	MDOS			;OPEN OUTPUT FILE
	OR	AL,AL
	JZ	WORK
	JMP	WRTER			;WRITE ERROR
WORK:	MOV	DX,OFFSET (WORKING)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "WORKING"
MLOOP:	MOV	DX,OFFSET BA.BUFFER
	MOV	CL,SETDMA
	CALL	MDOS			;SET DMA ADDRESS
RLOOP:	MOV	CX,WORD PTR MEMTOP	;GET TOP OF MEMORY
	MOV	AX,OFFSET BA.BUFFER
	SUB	CX,AX			;GET SIZE OF BUFFER
	MOV	DX,OFFSET FCB
	MOV	AH,DREAD
	INT	21H			;READ FROM FILE
	MOV	BYTE PTR EOFFLG,AL	;SAVE RESULT OF READ
	MOV	BX,OFFSET BA.BUFFER
	ADD	BX,CX			;MOVE TO FILE END
	MOV	M,1AH			;MARK IT
	MOV	BX,OFFSET (BA.BUFFER)	;FILE IS HERE
CONLP:	MOV	AL,M			;GET A CHARACTER
	INC	BX
	CMP	AL,1AH			;DONE?
	JZ	DONE			;IF SO, EXIT
	CMP	AL,0DH			;CR?
	JNZ	NOTCR			;IF NOT, KEEP LOOKING
	MOV	BYTE PTR COLNO,0	;CLEAR COLUMN NUMBER
	JMP	SHORT OUTCHR		;OUTPUT CHARACTER
NOTCR:	CMP	AL,0AH			;LF?
	JZ	OUTCHR			;IF SO OUTPUT CHARACTER
	CMP	AL,9			;TAB?
	JNZ	INCCOL			;NO, INCREMENT COLUMN NO.
	MOV	DH,BYTE PTR COLNO	;ELSE, GET COLUNN NUMBER
	MOV	DL,DH
	ADD	DH,8
	AND	DH,0F8H			;MOVE TO NEXT TAB STOP
	MOV	BYTE PTR COLNO,DH
SPCLP:	MOV	AL,' '			;GET A SPACE
	CALL	WRCHR			;WRITE A SPACE
	INC	DL			;COUNT IT
	CMP	DL,DH
	JNZ	SPCLP			;SPACE TO TAB STOP
	JMP	SHORT CNTCHR		;GET NEXT CHARACTER
INCCOL:	INC	BYTE PTR COLNO		;INCREMENT COLUMN NO.
OUTCHR:	CALL	WRCHR			;WRITE CHARACTER TO OUTPUT
CNTCHR:	LOOP	CONLP			;LOOP IF NOT DONE
	CMP	BYTE PTR EOFFLG,0	;DONE WITH FILE?
	JNZ	DONE			;IF SO, DONE
	JMP	MLOOP			;ELSE, LOOP
DONE:	MOV	AL,1AH
	CALL	WRCHR			;WRITE EOF
	CMP	WORD PTR OUTPTR,OFFSET BA.OUTBUF
	JNZ	DONE			;LOOP UNTIL LAST BUFFER WRITTEN
	MOV	DX,OFFSET (FCB)
	MOV	CL,CLOSE
	CALL	MDOS			;CLOSE INPUT FILE
	MOV	DX,OFFSET (FCB2)
	MOV	CL,CLOSE
	CALL	MDOS			;CLOSE OUTPUT FILE
	MOV	DX,OFFSET (DIDIT)
	MOV	CL,PRINT
	CALL	MDOS			;PRINT "DONE"
	INT	20H			;RETURN TO CP/M

WRCHR:	PUSH	BX
	PUSH	CX
	PUSH	DX			;SAVE REGISTERS
	MOV	BX,WORD PTR OUTPTR	;GET OUTPUT POINTER
	MOV	M,AL			;SAVE CHARACTER
	INC	BX			;INCREMENT POINTER
	MOV	WORD PTR OUTPTR,BX	;SAVE POINTER
	CMP	BX,OFFSET BA.OBFEND	;AT END OF BUFFER?
	JNZ	WRCHX			;IF NOT, EXIT
	MOV	WORD PTR OUTPTR,OFFSET BA.OUTBUF	;ELSE, RESET POINTER
	MOV	DX,OFFSET BA.OUTBUF
	MOV	AH,SETDMA
	INT	21H			;SET DMA
	MOV	DX,OFFSET FCB2
	MOV	AH,DWRITE
	INT	21H			;WRITE BUFFER
	OR	AL,AL
	JZ	WRCHX			;GOOD WRITE
WRTER:	MOV	DX,OFFSET WRERR
	MOV	AH,PRINT
	INT	21H			;SAY "WRITE ERROR"
	INT	20H			;EXIT
WRCHX:	POP	DX			;RESTORE REGISTERS
	POP	CX
	POP	BX
	RET

;	MESSAGES

NOFILE	DB	0DH,0AH,'THE CORRECT USE OF THIS PROGRAM IS'
	DB	0DH,0AH,0DH,0AH
	DB	'd>TAB2SPC d:FILENAME.TYP',0DH,0AH,0DH,0AH
	DB	'WHERE d IS A DRIVE NAME (A - F), AND',0DH,0AH
	DB	'FILENAME.TYP IS THE FILE TO BE CONVERTED',0DH,0AH,'$'
NOOPEN	DB	0DH,0AH,"CAN'T OPEN SOURCE FILE",0DH,0AH,'$'
WORKING	DB	0DH,0AH,'WORKING...',0DH,0AH,'$'
WRERR:	DB	0DH,0AH,'WRITE ERROR',0DH,0AH,'$'
DIDIT:	DB	0DH,0AH,'CONVERSION COMPLETE.',0DH,0AH,'$'

;	STORAGE

MEMTOP	DW	OFFSET (0)		;MEMORY TOP
OUTPTR	DW	OFFSET BA.OUTBUF	;OUTPUT POINTER
COLNO	DB	0			;COLUMN NUMBER
EOFFLG	DB	0			;END OF FILE FLAG
FCB2	DB	0,'        SPC',0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0
BA:
BUFF	STRUC
OUTBUF	DB	128 DUP (?)		;OUTPUT BUFFER
OBFEND	DB	256 DUP (?)		;STACK SPACE
STACK	DB	?
BUFFER	DB	?
BUFF	ENDS

CODE	ENDS
	END	TAB2SPC
                                                                                                                      