	TITLE	FILE ATTRIBUTE ALTERATION PROGRAM
	PAGE	,132
;	FILE ATTRIBUTE ALTERATION PROGRAM
;
;	THIS PROGRAM ALTERS THE ATTRIBUTES ON A FILE
;	TO USE IT, ENTER
;
;	ATTRIB <filename> <attributes>
;
;	WHERE <filename> IS A VALID MS-DOS FILE DESCRIPTOR,
;	AND <attributes> IS ONE OR MORE ATTRIBUTES DESIGNATED
;	AS FOLLOWS
;
;	R	READ ONLY
;	H	HIDDEN FILE
;	S	SYSTEM FILE
;	B	MARKED FOR BACKUP
;
;	ATTRIBUTES NOT SPECIFIED ARE REMOVED FROM THE FILE,
;	IF THEY WERE SET PREVIOUSLY

ATTR	SEGMENT
	ASSUME	CS:ATTR,DS:ATTR,ES:ATTR,SS:ATTR

	ORG	5CH
DFCB:					;DEFAULT FCB
	ORG	80H
CMDBUF:					;COMMAND BUFFER
	ORG	100H

START:	MOV	AH,19H
	INT	21H			;GET DEFAULT DISK
	INC	AL			;MAKE IT 1-N
	MOV	BYTE PTR DEFDRV,AL	;SAVE IT
	CLD				;ENSURE FORWARD DIRECTION
	MOV	SI,OFFSET CMDBUF	;POINT TO COMMAND BUFFER
	LODSB				;GET CHARACTER COUNT
	OR	AL,AL			;ANY ENTRY
	JNZ	GOTARG			;YES
EXPL:	MOV	DX,OFFSET EXMSG
	MOV	AH,9
	INT	21H			;ELSE, EXPLAIN PROGRAM
	INT	20H			;AND EXIT

;	GET ATTRIBUTES FROM COMMAND LINE

GOTARG:	CALL	SOS			;SKIP SPACES
FATTR:	LODSB				;GET NEXT CHAR
	CMP	AL,' '			;SPACE
	JZ	FOUND			;FOUND END OF FILE NAME
	CMP	AL,13			;CR ALREADY?
	JNZ	FATTR			;NO
	JMP	SHORT SETATTS		;ELSE, REMOVE ATTRIBUTES ONLY
FOUND:	CALL	SOS			;SKIP SPACES
GETLP:	MOV	DI,OFFSET ATTBL		;POINT TO ATTRIBUTE TABLE
	CALL	MUC			;MAKE UPPER CASE
	MOV	CL,1			;SET FIRST ATTRIBUTE IN CL
TSTATT:	CMP	AL,[DI]			;COMPARE WITH TABLE ENTRY
	JZ	GOTFLG			;GOT A MATCH
	SHL	CL,1			;MOVE BIT IN CL TO NEXT ATT.
	CMP	CL,40H			;ALL LEGAL PLACES USED?
	JZ	BADATT			;YES, BAD ATTRIBUTE
	INC	DI			;MOVE TO NEXT TABLE ENTRY
	JMP	SHORT TSTATT
GOTFLG:	OR	BYTE PTR ATTRS,CL	;ADD BIT TO OTHER ATTRIBUTES
	LODSB				;GET NEXT CHARACTER
	CMP	AL,13			;END OF ENTRY?
	JZ	SETATTS			;YES, GO SET ATTRIBUTES
	JMP	SHORT GETLP		;ELSE, LOOP UNTIL DONE
BADATT:	MOV	DX,OFFSET BADMSG
	MOV	AH,09
	INT	21H			;SAY "BAD ATTRIBUTE"
	JMP	SHORT EXPL		;AND EXPLAIN PROGRAM

;	SET ATTRIBUTES ON FILE(S)

SETATTS:MOV	SI,OFFSET DFCB		;POINT TO ENTRY FCB
	MOV	DI,OFFSET FCB1		;PUT FILE NAME HERE
	MOV	CX,37			;MOVE 37 CHARACTERS
	REP	MOVSB			;MOVE THE ENTRY
	MOV	DX,OFFSET XFCB2
	MOV	AH,1AH
	INT	21H			;SET DTA ADDRESS TO OUR 2ND FCB
	MOV	AH,11H			;SEARCH FOR FIRST DIR. ENTRY
SRCHLP:	MOV	DX,OFFSET XFCB1
	INT	21H			;LOOK FOR USER'S ENTRY
	OR	AL,AL			;GOOD ENTRY?
	JZ	GOTFIL			;YES
	CMP	WORD PTR FDCNT,0	;ANY FILES DONE?
	JNZ	EXIT			;IF SO, NO ERROR
	MOV	DX,OFFSET NFMSG
	MOV	AH,09
	INT	21H			;ELSE, SAY "FILE NOT FOUND"
EXIT:	INT	20H
GOTFIL:	CALL	XNAME			;EXTRACT FILE NAME FROM FCB
	MOV	DX,OFFSET XDRV		;POINT TO EXTRACTED NAME
	MOV	AH,43H
	MOV	AL,01
	MOV	CX,WORD PTR ATTRS
	INT	21H			;SET ATTRIBUTES ON FILE
	JNB	GDFLG			;GO ON IF OPERATION OK
	MOV	DX,OFFSET NCMSG
	MOV	AH,9
	INT	21H			;SAY "CAN'T CHANGE ATTRIBUTES"
	MOV	SI,OFFSET XDRV		;POINT TO EXTRACTED FILE NAME
PNAME:	LODSB				;GET A CHARACTER
	OR	AL,AL			;END?
	JZ	GDFLG			;YES
	MOV	DL,AL			;ELSE, CHAR TO DL
	MOV	AH,2
	INT	21H			;PRINT CHAR
	JMP	SHORT PNAME
GDFLG:	INC	WORD PTR FDCNT		;COUNT THIS FILE
	MOV	AH,12H
	JMP	SHORT SRCHLP		;TRY FOR ANOTHER ONE

;	EXTRACT ASCII FILE NAME FROM SEARCH FCB

XNAME:	MOV	SI,OFFSET FCB2FN	;POINT TO FILE NAME
	MOV	DI,OFFSET XNAM		;PUT IT HERE
	MOV	CX,8			;CHARS IN NAME
MOVNAM:	LODSB				;GET A CHAR
	CMP	AL,' '			;SPACE?
	JZ	GOTNAM			;IF SO, END OF NAME
	STOSB				;ELSE, STORE CHAR
	LOOP	MOVNAM
GOTNAM:	MOV	AL,'.'			;PERIOD AFTER NAME
	STOSB
	MOV	CX,3			;3 CHARS IN EXT.
	MOV	SI,OFFSET FCB2EX	;GET EXT. FROM HERE
MOVEXT:	LODSB
	CMP	AL,' '
	JZ	GOTEXT
	STOSB				;STORE IT
	LOOP	MOVEXT
GOTEXT:	XOR	AL,AL			;TERMINATE NAME
	STOSB
	MOV	SI,OFFSET FCB2		;POINT TO ENTRY DRIVE
	MOV	AL,[SI]
	CMP	AL,0			;ANY DRIVE GIVEN?
	JZ	NODRV			;NO, GET DEFAULT DRIVE
INSDRV:	ADD	AL,'@'			;ADD ASCII BIAS
	MOV	XDRV,AL
	MOV	BYTE PTR XDRV+1,':'	;":" AFTER DRIVE NAME
	JMP	SHORT XNX
NODRV:	MOV	AL,BYTE PTR DEFDRV
	JMP	SHORT INSDRV
XNX:	RET

;	SKIP OVER SPACES

SOS:	LODSB				;GET NEXT CHARACTER
	CMP	AL,' '			;SPACE?
	JZ	SOS			;IF SO, SKIP IT
	RET

;	MAP LETTERS TO UPPER CASE

MUC:	CMP	AL,'a'			;LESS THAN "a"?
	JC	NMAP
	CMP	AL,'z'+1		;MORE THAN "z"?
	JNC	NMAP
	AND	AL,5FH			;ELSE MAP TO UPPER CASE
NMAP:	RET

EXMSG	DB	13,10,10,'To use this program, enter',13,10,10
	DB	'ATTRIB <filename> <attributes>',13,10,10
	DB	'Valid attributes are:',13,10
	DB	'R - Read only',13,10
	DB	'H - Hidden file',13,10
	DB	'S - System file',13,10
	DB	'B - Mark file for Backup',13,10,10
	DB	'The filename can be ambiguous.$'
NFMSG	DB	13,10,'ERROR -- File not found.$'
BADMSG	DB	13,10,'ERROR -- Invalid attribute.$'
NCMSG	DB	13,10,'ERROR -- Can',27H,'t change attributes '
	DB	'on file $'

ATTBL	DB	'RHS',80H,80H,'B'
DEFDRV	DB	0
FDCNT	DW	0
ATTRS	DB	0,0
XFCB1	DB	0FFH,0,0,0,0,0,27H
FCB1	DB	37 DUP (0)
XFCB2	DB	0FFH
	DB	6 DUP (0)
FCB2	DB	0
FCB2FN	DB	8 DUP (0)
FCB2EX	DB	28 DUP (0)
XDRV	DB	0,0
XNAM	DB	11 DUP (0)

ATTR	ENDS
	END	START
                                                                                                               