	PAGE	,132
	TITLE	WORDSTAR PRINT PATCHER
;	WSPATCH -- WORDSTAR PRINT PATCHER
;
;	THIS PROGRAM PATCHES WORDSTAR SO THAT PRINT OUTPUT
;	GOES THROUGH THE DOS, INSTEAD OF GOING
;	DIRECTLY TO THE BIOS.
;
;	BY P. SWAYNE, HUG  20-MAY-85

;	DEFINITIONS

PCHADR	EQU	6CCH			;PATCH AREA
PCHSIZ	EQU	128			;PATCH AREA SIZE
OPENF	EQU	0FH			;OPEN FILE
CLOSEF	EQU	10H			;CLOSE FILE
SETDTA	EQU	1AH			;SET DTA ADDRESS
READF	EQU	27H			;READ FILE (RANDOM BLK.)
WRITEF	EQU	28H			;WRITE FILE (RANDOM BLOCK)

CODE	SEGMENT
	ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG     5CH
FCB	LABEL   BYTE                    ;DEFAULT FCB ADDRESS
	ORG     100H

START:  MOV     DX,OFFSET SIGNON
	MOV     AH,9
	INT     21H                     ;PRINT SIGNON
	CMP     BYTE PTR FCB+1,' '      ;TEST FOR ARGUMENT
	JNZ     GOTARG                  ;GOT ONE
	MOV     DX,OFFSET EXPL
	MOV     AH,9
	INT     21H                     ;ELSE, EXPLAIN PROGRAM
	INT     20H
GOTARG: MOV     DI,OFFSET FCB+32        ;POINT TO RECORD COUNTERS
	XOR     AX,AX
	CLD
	MOV	CX,3
	REP	STOSW			;CLEAR RECORD COUNTERS
	MOV	DX,OFFSET FCB
	MOV	AH,OPENF
	INT	21H			;OPEN FILE
	INC	AL
	JNZ	OPENED			;OPEN OK
FILERR:	MOV	DX,OFFSET NOFILE
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO FILE"
	INT	20H
OPENED:	MOV	WORD PTR FCB+14,1	;SET RECORD SIZE TO 1
	MOV	DX,OFFSET BUFFER
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO BUFFER
	MOV	WORD PTR FCB+33,PCHADR	;START READING FILE HERE
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO READ
	MOV	DX,OFFSET FCB
	MOV	AH,READF
	INT	21H			;READ FROM FILE
	OR	AL,AL
	JNZ	FILERR			;FILE ERROR
	MOV	DI,OFFSET BUFFER
	CMP	WORD PTR [DI],9090H	;CHECK CODE
	JNZ	NOPCH			;NOT THE RIGHT CODE
	CMP	WORD PTR 17[DI],9090H	;CHECK NEXT SECTION
	JZ	PATCH			;THIS IS IT
NOPCH:	MOV	DX,OFFSET NPMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO PATCH DONE"
	INT	20H
PATCH:	MOV	SI,OFFSET PATCH1	;POINT TO FIRST PATCH
	MOV	CX,3
	REP	MOVSB			;MAKE THE PATCH
	MOV	SI,OFFSET PATCH2
	ADD	DI,14			;POINT TO SECOND PATCH
	MOV	CX,8
	REP	MOVSB			;MAKE THE PATCH
	MOV	WORD PTR FCB+33,PCHADR	;RESET RECORD ADDRESS
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO WRITE
	MOV	DX,OFFSET FCB
	MOV	AH,WRITEF
	INT	21H			;WRITE TO FILE
	OR	AL,AL
	JZ	PCHOK			;WRITE OK
WRERR:	MOV	DX,OFFSET BADWR
	MOV	AH,9
	INT	21H			;SAY "NO WRITE"
	INT	20H
PCHOK:	MOV	DX,OFFSET FCB
	MOV	AH,CLOSEF
	INT	21H			;CLOSE FILE
	INC	AL
	JZ	WRERR			;ERROR IN CLOSING
	MOV	DX,OFFSET DONE
	MOV	AH,9
	INT	21H			;ELSE, SAY "DONE"
	INT	20H			;AND EXIT

;	PATCHES TO BE INSERTED INTO WORDSTAR

PATCH1:	NOP
	CLC
	RET
PATCH2:	MOV	DL,AL
	MOV	AH,5
	INT	21H
	CLC
	RET

;	MESSAGES

SIGNON	DB	13,10,'WORDSTAR Print Patching Utility'
	DB	13,10,10,'$'
EXPL	DB	'To use this program, enter',13,10,10
	DB	'  WSPATCH d:WS.COM',13,10,10
	DB	'where d: is a drive designation, and',13,10
	DB	'WS.COM is the file to patch.$'
NOFILE	DB	'ERROR -- No file, or read error.$'
NPMSG	DB	'Proper code not found, no patch done.$'
BADWR	DB	'ERROR -- Disk write problem.$'
DONE	DB	'WORDSTAR successfully patched.$'

BUFFER	LABEL	BYTE			;BUFFER STARTS HERE

CODE	ENDS
	END	START
                                                                                 