;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; DEFFMT - Loader/Format definitions
;
;     DEFFMT defines the format table at the head
;     of the loader. The data is placed here by the
;     FORMAT utility, and used during boot by the
;     loader to determine disk layout and by the
;     BIOS to boot itself and the DOS.
;

FMT_OFFSET	EQU 3		; Offset of table into start of loader

; MicroSoft(MS) defined entries of table

FMT_VER		EQU 0		; Version of table
  FMT_CVER	  EQU 01H	  ; Current version
FMT_SECS	EQU FMT_VER+1	; Sector size of disk(in bytes)
FMT_CLF		EQU FMT_SECS+2	; Cluster factor
FMT_NRS		EQU FMT_CLF+1	; Number of reserved sectors
FMT_FATS	EQU FMT_NRS+2	; Number of FATs
FMT_DIRS	EQU FMT_FATS+1	; Number if directory entries
FMT_NPS		EQU FMT_DIRS+2	; Number of physical sectors

; Zenith Data System(ZDS) defined entries of table

FMT_SHFT	EQU FMT_NPS+2	; Shift count (Log2 SECS)
FMT_SPT		EQU FMT_SHFT+1	; Sectors/track
FMT_DATA	EQU FMT_SPT+1	; Data area sector number
FMT_CLST	EQU FMT_DATA+2	; Shift count (Log2 cluster size)
FMT_DIR		EQU FMT_CLST+1	; Directory area sector number
FMT_FLG		EQU FMT_DIR+2	; Flag byte (DSK_FLAG)
FMT_SEL		EQU FMT_FLG+1	; Select byte (DSK_SEL)
FMT_PORT	EQU FMT_SEL+1	; Port number of controller
FMT_DATE	EQU FMT_PORT+2	; Date of format for disk
FMT_SIZE	EQU FMT_DATE+7	; Size of FMT table

;	FATID values and flags
;
;	NOTE: These are only used for the 5" formats. 8" and
;	winchester formats use other values
;

FMT_DSFLG	EQU	00000001B	; Double sided flag
FMT_48FLG	EQU	00000100B	; 48tpi flag
FMT_EDFLG	EQU	00000010B	; Old format flag
FMT_RES		EQU	11111000B	; Must be on

;	Values for the current formats

FMT_F48S	EQU	FMT_RES+FMT_EDFLG+FMT_48FLG
FMT_F48D	EQU	FMT_RES+FMT_EDFLG+FMT_48FLG+FMT_DSFLG
FMT_F96D	EQU	FMT_RES+FMT_EDFLG+FMT_DSFLG

;	Values for the "extended" formats

FMT_F48SE	EQU	FMT_F48S-FMT_EDFLG
FMT_F48DE	EQU	FMT_F48D-FMT_EDFLG
FMT_F96DE	EQU	FMT_F96D-FMT_EDFLG
