	.xlist
	.sall
;**********************************************************************
;
; STRUCT.ASM
;    Structure macros for MASM.
;    (C) Copyright Gordon Buchanan, 1985
;
;**********************************************************************

?stktop	=	0			;initialize top of stack pointer

; define relational operator values

?t?	equ	1			;true
?e?	equ	2			;equal
?c?	equ	3			;carry
?ns?	equ	4			;not sign
?o?	equ	5			;overflow
?a?	equ	6			;above
?g?	equ	7			;greater
?ge?	equ	8			;greater than or equal
?p?	equ	9			;parity
?cxz?	equ	10			;cx zero


?cxnz?	equ	11			;cx not zero
?np?	equ	12			;not parity
?l?	equ	13			;less
?le?	equ	14			;less than or equal
?be?	equ	15			;below or equal
?no?	equ	16			;no overflow
?s?	equ	17			;sign
?nc?	equ	18			;no carry
?ne?	equ	19			;not equal
?f?	equ	20			;false

?inval?	equ	?f?+1			;invalid condition value

; setup alternate condition names

?nbe?	equ	?a?			;not below or equal
?ae?	equ	?nc?			;above or equal
?nb?	equ	?nc?			;not below
?b?	equ	?c?			;below
?nae?	equ	?c?			;not above or equal
?na?	equ	?be?			;not above
?z?	equ	?e?			;zero
?nle?	equ	?g?			;not less or equal
?nl?	equ	?ge?			;not less
?nge?	equ	?l?			;not greater or equal
?ng?	equ	?le?			;not greater
?nz?	equ	?ne?			;not zero
?po?	equ	?np?			;parity odd
?pe?	equ	?p?			;parity even

?eq?	equ	?e?			;equal
?gt?	equ	?g?			;greater than
?lt?	equ	?l?			;less than

?ncxz?	equ	?cxnz?			;cx not zero



pshstk?	macro	val			;push item on stack
?stktop	=	?stktop+1
	stkset?	%?stktop,val
	endm
 
 
 
stkset?	macro	n,val			;set value of stack item
?stk&n	=	val
	endm
 
 
 
popstk?	macro	lab			;pop item from stack
	if	?stktop eq 0
	merror?	<Invalid structure nesting>
	exitm
	endif
 
	stkrem?	%?stktop,lab
?stktop	=	?stktop-1
	endm
 
 
 
stkrem?	macro	num,lab			;get value of stack item
lab	=	?stk&num
	endm
 
 
 
merror?	macro	msg			;cause error message
??? ERROR ??? msg
	endm
 
 
 
ropnum?	macro	rop,rnum		;return operator number
	ifndef	?&rop&?
	merror?	<Invalid relation: &rop&>
rnum	=	?inval?
	else
rnum	=	?&rop&?
	endif
	endm



lropnum? macro	rop,rnum		;return loop operator number
	ropnum?	<rop>,rnum
	if	rnum gt ?e? and rnum lt ?ne?
rnum	=	?inval?
	merror?	<Invalid loop relation: &rop&>
	endif
	endm
 
 
 
ropni?	macro	rnum			;invert operator
	if	rnum ne ?inval?
rnum	=	?inval?-rnum
	endif
	endm
 
 
 
ctop?	macro	o1,o2,o3,o4,ct		;return operand count
ct	=	0

	irp	on,<<o1>,<o2>,<o3>,<o4>>
	ifb	<on>
	exitm
	endif
ct	=	ct+1
	endm
	endm
 
 
 
jmprel?	macro	rnum,loc		;generate correct jump
	relsel?	%&rnum,j,loc
	endm



looprel? macro	rnum,loc		;generate correct loop instruction
	relsel?	%&rnum,l,loc
	endm



relsel?	macro	n,t,loc			;select correct jump or loop
	rel&t&n&? loc
	endm


 
relj1?	macro	loc			;T condition
	jmp	short loc
	endm
 
relj2?	macro	loc			;E condition
	je	loc
	endm
 
relj3?	macro	loc			;C condition
	jc	loc
	endm
 
relj4?	macro	loc			;NS condition
	jns	loc
	endm
 
relj5?	macro	loc			;O condition
	jo	loc
	endm
 
relj6?	macro	loc			;A condition
	ja	loc
	endm
 
relj7?	macro	loc			;G condition
	jg	loc
	endm

relj8?	macro	loc			;GE condition
	jge	loc
	endm

relj9?	macro	loc			;P condition
	jp	loc
	endm

relj10?	macro	loc			;CXZ condition
	jcxz	loc
	endm

relj11?	macro	loc			;CXNZ condition
	jcxz	$+4
	jmp	short loc
	endm

relj12?	macro	loc			;NP condition
	jnp	loc
	endm

relj13?	macro	loc			;L condition
	jl	loc
	endm

relj14?	macro	loc			;LE
	jle	loc
	endm
 
relj15?	macro	loc			;BE condition
	jbe	loc
	endm

relj16?	macro	loc			;NO condition
	jno	loc
	endm
 
relj17?	macro	loc			;S condition
	js	loc
	endm
 
relj18?	macro	loc			;NC condition
	jnc	loc
	endm
 
relj19?	macro	loc			;NE condition
	jne	loc
	endm
 
relj20?	macro	loc			;F condition
	endm

relj21?	macro	loc			;invalid condition
	endm

rell1?	macro	loc			;loop T
	loop	loc
	endm

rell2?	macro	loc			;loop E
	loope	loc
	endm

rell19?	macro	loc			;loop NE
	loopne	loc
	endm

rell20?	macro	loc			;loop F
	endm

rell21?	macro	loc			;invalid
	endm

 
 
test?	macro	op1,op2			;generate test
	cmp	op1,op2
	endm
 
 
 
repeat	macro				;repeat structure
	pshstk?	$			;save current location
	endm
 
 
 
until	macro	op1,rop,op2,op3		;until structure item
	ctop?	<op1>,<rop>,<op2>,<op3>,?ct	;get count of parameters
	if	?ct ne 1 and ?ct ne 3	;count must be 1 or 3
	merror?	<Missing or extra operand(s): (&op1&),(&rop&),(&op2&),(&op3&)>
	popstk?	?repeat			;pop return address
	exitm
	endif
 
	if	?ct eq 1		;1 parameter is operator
	ropnum?	<op1>,?rnum		;get operator number
	else				;3 parameters
	ropnum?	<rop>,?rnum		;generate operator number
	test?	<op1>,<op2>		;generate test
	endif
 
	ropni?	?rnum			;invert operator
	popstk?	?repeat			;get address of repeat
	jmprel?	?rnum,?repeat		;generate loop instruction
	endm
 
 
 
while	macro	op1,rop,op2,op3		;while structure
	ctop?	<op1>,<rop>,<op2>,<op3>,?ct	;count parameters
	if	?ct ne 1 and ?ct ne 3	;must have 1 or 3 parameters
	merror?	<Missing or extra operand(s): (&op1&),(&rop&),(&op2&),(&op3&)>
	pshstk?	$			;push dummy values for endw
	pshstk?	$
	pshstk?	?t?
	exitm
	endif
 
	pshstk?	$			;save current location
 
	if	?ct eq 1		;1 parameter
	ropnum?	<op1>,?rnum		;generate operator number
	else				;3 parameters
	ropnum?	<rop>,?rnum		;get operator number
	test?	<op1>,<op2>		;generate test
	endif
 
	ropni?	?rnum			;invert operator
	pshstk?	$			;save current location
	pshstk?	?rnum			;save operator
	jmprel?	?rnum,$			;generate dummy jump to endw
	endm
 
 
 
endw	macro				;end of while structure
	popstk?	?rnum			;get previous operator
	popstk?	?while			;get location of while exit
	popstk?	?whilel			;get location of top of while
	jmprel?	?t?,?whilel		;generate looping jump
?pos	=	$			;remember current location
	org	?while			;move back in code
	jmprel?	?rnum,?pos		;fix up jump address
	org	?pos			;move back to current address
	endm
 
 
 
if@	macro	op1,rop,op2,op3		;if structure
	ctop?	<op1>,<rop>,<op2>,<op3>,?ct	;count parameters
	if	?ct ne 1 and ?ct ne 3	;must be 1 or 3
	merror?	<Missing or extra operand(s): (&op1&),(&rop&),(&op2&),(&op3&)>
	pshstk?	$			;push dummy values for endif@
	pshstk?	?t?
	exitm
	endif
 
	if	?ct eq 1		;1 parameter
	ropnum?	<op1>,?rnum		;generate operator number
	else				;3 parameters
	ropnum?	<rop>,?rnum		;generate operator number
	test?	<op1>,<op2>		;generate compare
	endif
 
	ropni?	?rnum			;invert operator
	pshstk?	$			;save current location
	pshstk?	?rnum			;save operator number
	jmprel?	?rnum,$			;generate correct jump to dummy loc
	endm
 
 
 
else@	macro
	popstk?	?rnum			;get prev operator
	popstk?	?if			;get location of if jump
	pshstk?	$			;save current location
	pshstk?	?t?			;save true operator
	jmprel?	?t?,$			;generate jump always to dummy loc
?pos	=	$
	org	?if			;go back and fix up previous jump
	jmprel?	?rnum,?pos
	org	?pos
	endm
 
 
 
endif@	macro
?pos	=	$
	popstk?	?rnum			;get operator
	popstk?	?if			;get jump location
	org	?if			;go back and fix up jump
	jmprel?	?rnum,?pos
	org	?pos
	endm
 
 
 
elseif@	macro	op1,rop,op2,op3
	else@
	if@	<op1>,<rop>,<op2>,<op3>
	endm



for	macro	op1,op2,op3
	ifnb	<op3>			;no operand 3 allowed
	merror?	<Missing or extra operand(s): (&op1&),(&op2&),(&op3&)>
	pshstk?	0			;dummy flag
	pshstk?	$			;dummy loop location
	exitm
	endif

	ifnb	<op1>			;generate MOV if op1 there
	mov	cx,op1
	endif

	ifnb	<op2>			;generate JCXZ if op2 = ?ne?
	ropnum?	<op2>,?rnum
	if	?rnum ne ?ne?		;invalid operator
	merror?	<Invalid FOR relation: &op2&>
	pshstk?	0			;push flag for no JCXZ

	else				;correct ?ne? operator
	pshstk?	$			;save JCXZ loc
	jcxz	$			;generate dummy JCXZ
	pshstk?	1			;push flag for JCXZ
	endif

	else				;no operator
	pshstk?	0			;push flag for no JCXZ
	endif

	pshstk?	$			;save location for loop
	endm



endf	macro	op1,op2			;end for
	ifnb	<op2>			;op2 not allowed
	merror?	<Missing or extra operand(s): (&op1&),(&op2&)>
	popstk?	?pos			;remove operands from stack
	popstk?	?pos
	if	?pos eq 1
	popstk?	?pos
	endif
	exitm
	endif

	ifb	<op1>			;if no op1 then always loop
?rnum	=	?t?
	else
	lropnum? <op1>,?rnum		;get operator number
	endif

	popstk?	?pos			;get location to loop to
	looprel? ?rnum,?pos		;generate LOOP instruction

	popstk?	?pos			;get JCXZ flag
	if	?pos eq 1		;if JCXZ generated
?pos	=	$
	popstk?	?for			;get address of JCXZ
	org	?for			;go back and fix jump location
	jcxz	?pos
	org	?pos
	endif
	endm
	
	.list
