;	ONECOPY UTILITY FOR Z-DOS
;
;	TO USE THIS UTILITY, ENTER
;
;	A:ONECOPY FILENAME.TYP
;
;	BY P. SWAYNE, HUG  27-APR-84

M	EQU	Byte Ptr 0[BX]

OC	SEGMENT
	ASSUME	CS:OC,DS:OC,ES:OC,SS:OC

;	FILE CONTROL DEFINITIONS

	ORG	5CH
FCB	LABEL	NEAR			;FILE CONTROL BLOCK
	ORG	(Offset FCB)+1
FNAME	LABEL	NEAR			;FILE NAME ADDRESS
	ORG	(Offset FCB)+12
BLOCK	LABEL	NEAR			;BLOCK NO. ADDRESS
	ORG	(Offset FCB)+14
RSIZE	LABEL	NEAR			;RECORD SIZE
	ORG	(Offset FCB)+20
FDATE	LABEL	NEAR			;FILE DATE
	ORG	(Offset FCB)+22
FTIME	LABEL	NEAR			;FILE TIME
	ORG	(Offset FCB)+32
RECORD	LABEL	NEAR			;RECORD NO. ADDRESS

	ORG	100H
;
;	TEST FOR COMMAND LINE FILE NAME
;
START:	MOV	AX,CS
	MOV	DS,AX			;ENSURE DS HERE
	CLI
	MOV	SS,AX			;PUT STACK HERE
	MOV	SP,Offset STACK
	STI
	MOV	DX,(Offset MSG1)
	CALL	PRINT			;SIGN ON
	CMP	Byte Ptr FNAME,' '
	JNZ	ONEC
	MOV	DX,(Offset MSG3)
	JMP	ERROR			;NO FILE FOUND

;	FILE NAME PRESENT, SET UP FOR COPY

ONEC:	MOV	DI,Offset FCB		;POINT TO FCB
	MOV	AL,'?'			;GET A "?"
	PUSH	DS
	POP	ES			;ENSURE ES IS HERE
	CLD				;SEARCH FORWARD
	MOV	CX,11			;FOR 11 CHARACTERS
	REPNZ	SCASB			;LOOK FOR "?"
	JNZ	NOWILD			;NOT FOUND
	MOV	DX,Offset MSG9
	JMP	ERROR			;ELSE, ERROR
NOWILD:	XOR	AX,AX
	MOV	Byte Ptr RECSAV,AL	;CLEAR SAVED RECORD
	MOV	Word Ptr BLKSAV,AX	;CLEAR SAVED BLOCK
	MOV	BX,0FFH			;PREPARE TO TEST MEMORY
MEMLP:	DEC	BH
	MOV	AL,M			;GET A BYTE
	INC	M			;TRY TO CHANGE MEMORY
	CMP	AL,M			;TEST
	MOV	M,AL			;REPLACE THE BYTE
	JZ	MEMLP			;NO CHANGE, IT'S NOT RAM
	MOV	Word Ptr TOP,BX		;SET TOP
	SUB	BX,(Offset BUFFER)	;SUBTRACT BUFFER START FROM TOP
	MOV	Word Ptr MEMSIZ,BX	;AND SAVE AS MEMORY SIZE
	MOV	AH,25
	INT	21H			;GET CURRENT DISK
	MOV	Byte Ptr CURDRV,AL	;SAVE IT
	MOV	DX,Offset BUFFER
	CALL	SETDMA			;SET DMA ADDRESS TO BUFFER
	MOV	Byte Ptr FLAG,0		;CLEAR FLAG

;	MAIN COPY LOOP
;	PROMPT FOR INSERTION OF SOURCE, AND OPEN FILE

MAINLP:	MOV	DX,(Offset MSG4)	;INSERT SOURCE DISK
	CALL	LOGIN			;LOG IN DISK
	CALL	OPENFL			;OPEN FILE
	MOV	AX,Word Ptr FDATE	;GET FILE DATE
	MOV	Word Ptr DATSAV,AX	;SAVE IT
	MOV	AX,Word Ptr FTIME	;AND TIME
	MOV	Word Ptr TIMSAV,AX	;SAVE IT
	MOV	CX,Word Ptr MEMSIZ	;GET MEMORY SIZE
	MOV	Word Ptr RECCNT,CX	;SAVE SIZE AS RECORD COUNT

;	READ FROM FILE UNTIL MEMORY FULL OR FILE END

	MOV	DX,Offset FCB
	CALL	READ			;READ IN A RECORD
	OR	AL,AL			;NORMAL READ?
	JZ	WRTLP			;IF SO, WRITE AND LOOP
	DEC	AL			;EOF?
	JZ	MRKEND			;IF SO, MARK END

;	ANYTHING ELSE IS A READ ERROR

READERR:MOV	DX,(Offset MSG7)	;READ ERROR
	JMP	ERROR

;	END FOUND, MARK IT

MRKEND:	AND	Byte Ptr FLAG,0FEH	;MARK EOF
	MOV	Word Ptr RECCNT,CX	;UPDATE RECORD COUNT TO ACTUAL READ
	JMP SHORT INDEST

;	MEMORY FILLED UP, WRITE TO OUTPUT

WRTLP:	OR	Byte Ptr FLAG,1		;FLAG SWAP
INDEST:	MOV	DX,(Offset MSG5)	;INSERT DEST. DISK
	CALL	LOGIN
	TEST	Byte Ptr FLAG,2		;FIRST TIME THROUGH?
	JNZ	OPENWR			;NO
	MOV	DX,Offset FCB
	MOV	Word Ptr BLOCK,0	;ELSE, CLEAR BLOCK
	MOV	Byte Ptr RECORD,0	;AND RECORD NO.
	CALL	DELETE			;DELETE OLD FILE
	MOV	DX,Offset FCB
	CALL	MAKE			;MAKE NEW ONE
	INC	AL
	JNZ	OPENWR
	MOV	DX,(Offset MSG8)	;COULDN'T OPEN OUTPUT
	JMP	ERROR

OPENWR:	OR	Byte Ptr FLAG,2		;MARK FIRST TIME DONE
	CALL	OPENFL			;OPEN DISTINATION FILE

;	WRITE CONTENTS OF BUFFER TO OUTPUT

	MOV	CX,Word Ptr RECCNT	;GET COUNT OF RECORDS TO READ
	MOV	DX,Offset FCB
	CALL	WRITE			;WRITE A RECORD
	OR	AL,AL			;WRITE OK?
	JZ	GDWRIT
	MOV	DX,(Offset MSG8)	;BAD WRITE
	JMP	ERROR

GDWRIT:	MOV	AX,Word Ptr DATSAV
	MOV	Word Ptr FDATE,AX	;FIX FILE DATE
	MOV	AX,Word Ptr TIMSAV
	MOV	Word Ptr FTIME,AX	;AND FILE TIME
	MOV	AL,Byte Ptr RECORD
	MOV	Byte Ptr RECSAV,AL	;SAVE THE CURRENT RECORD
	MOV	AX,Word Ptr BLOCK
	MOV	Word Ptr BLKSAV,AX	;AND THE CURRENT BLOCK
	MOV	DX,Offset FCB
	CALL	CLOSE			;CLOSE OUTPUT FILE
	INC	AL
	JNZ	CHDONE
	MOV	DX,(Offset MSG8)	;CAN'T CLOSE
	JMP SHORT ERROR

CHDONE:	TEST	Byte Ptr FLAG,1		;TEST IF DONE
	JNZ	NXTBLK			;NO, GET ANOTHER RAMFULL
DONE:	MOV	DX,(Offset MSG10)	;ELSE, PROMPT FOR SYSTEM DISK
	CALL	PRINT
	MOV	DX,(Offset MSG2)
	CALL	LOGIN			;LOG IT IN
	INT	20H			;EXIT

;	PROCESS THE NEXT MEMORY BLOCK OF THE FILE

NXTBLK:	JMP	MAINLP

LOGIN:	CALL	PRINT			;SAY "INSERT DISK"
	CALL	CONIN			;WAIT FOR A KEYSTROKE
	CALL	RESET
	MOV	DL,Byte Ptr CURDRV	;GET CURRENT DEFAULT DRIVE
	JMP	SELECT

;	OPEN INPUT FILE

OPENFL:	MOV	DX,Offset FCB
	CALL	OPEN			;OPEN THE FILE WE'RE WORKING ON
	INC	AL
	JZ	OPENFL1
	MOV	AX,Word Ptr BLKSAV
	MOV	Word Ptr BLOCK,AX	;UPDATE CURRENT BLOCK
	MOV	AL,Byte Ptr RECSAV
	MOV	Byte Ptr RECORD,AL	;UPDATE CURRENT RECORD
	MOV	Word Ptr RSIZE,1	;USE A RECORD SIZE OF 1 BYTE
	MOV	DX,Offset FCB
	JMP	SETRAN			;SET RANDOM RECORD
OPENFL1:MOV	DX,(Offset MSG6)

;	PROCESS ERRORS

ERROR:	CALL	PRINT
	MOV	DX,(Offset MSG2)
	CALL	LOGIN
	INT	20H
;
;	Z-DOS SYSTEM ROUTINES
;
PRINT:	MOV	AH,009H
	INT	21H
	RET

RESET:	MOV	AH,00DH
	INT	21H
	RET

CONIN:	MOV	AH,001H
	INT	21H
	CMP	AL,003H
	JNZ	CONIN1
	INT	20H
CONIN1:	RET

SELECT:	MOV	AH,00EH
	INT	21H
	RET

OPEN:	MOV	AH,00FH
	INT	21H
	RET

CLOSE:	MOV	AH,010H
	INT	21H
	RET

DELETE:	MOV	AH,013H
	INT	21H
	RET

READ:	MOV	AH,027H			;USE RANDOM BLOCK READ
	INT	21H
	RET

WRITE:	MOV	AH,028H			;USE RANDOM BLOCK WRITE
	INT	21H
	RET

SETRAN:	MOV	AH,024H
	INT	21H
	RET

MAKE:	MOV	AH,016H
	INT	21H
	RET

SETDMA:	MOV	AH,01AH
	INT	21H
	RET
;
;	MESSAGES
;
MSG1	DB	13,10
	DB	'	     Z-DOS ONECOPY',13,10
	DB	'	      VERSION 1.0',13,10,'$'
MSG2	DB	13,10,10
	DB	'Replace System Disk and hit RETURN.$'
MSG3	DB	13,10,10,'ERROR -- No File Name specified.'
	DB	13,10,10
	DB	'The correct syntax is "ONECOPY FILENAME.TYP".$'
MSG4	DB	13,10,'Insert Source Disk in drive '
	DB	'and press RETURN.$'
MSG5	DB	13,10,'Insert Distination Disk in drive '
	DB	'and press RETURN.$'
MSG6	DB	13,10,'ERROR -- Source file not found.$'
MSG7	DB	13,10,'ERROR -- Can',27H,'t read source file.$'
MSG8	DB	13,10,'ERROR -- Can',27H,'t write destination file.$'
MSG9	DB	13,10,'ERROR -- Wildcards not allowed.$'
MSG10	DB	13,10,'Transfer completed.$'

;	VARIABLES AND BUFFER

RECSAV	DB	0			;CURRENT RECORD SAVED HERE
BLKSAV	DW	0			;CURRENT BLOCK SAVED HERE
FLAG	DB	0			;PROGRESS FLAG
TOP	DW	0			;TOP OF MEMORY SEGMENT
MEMSIZ	DW	0			;MEMORY SEGMENT SIZE
RECCNT	DW	0			;RECORD COUNTER
CURDRV	DB	0			;CURRENT DEFAULT DRIVE
DATSAV	DW	0			;SAVED FILE DATE
TIMSAV	DW	0			;SAVED FILE TIME
STACK	EQU	(Offset CURDRV)+100H
BUFFER	EQU	(Offset STACK)		;BUFFER STARTS HERE
OC	ENDS
	END	START
                                                                          