	TITLE	SCREEN CLOCK CONTROL PROGRAM
	PAGE	,132
;	THIS PROGRAM ALLOWS YOU TO TURN OFF THE SCREEN CLOCK
;	CREATED BY THE SCRNCLK PROGRAM.  TO USE IT, ENTER
;
;	A:CLOCK OFF		TO TURN THE CLOCK OFF
;
;	A:CLOCK			TO TURN IT BACK ON
;
;	BY P. SWAYNE, HUG   15-FEB-84

;	DEFINITIONS

TIMEINT	EQU	81*4			;TIMER INTERRUPT
CMDBUF	EQU	80H			;COMMAND LINE BUFFER
CLKFLG	EQU	103H			;CLOCK ON/OFF FLAG

CLOCK	SEGMENT
	ASSUME	CS:CLOCK,DS:CLOCK,ES:CLOCK,SS:CLOCK
	ORG	100H

START:	PUSH	DS			;SAVE DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET TIMEINT	;POINT TO TIMER INTERRUPT
	LES	DI,DWORD PTR [SI]	;GET VECTOR IN ES:DI
	CMP	WORD PTR ES:-2[DI],'KC'	;IS CLOCK INSTALLED?
	JNZ	EXIT			;IF NOT, EXIT
	POP	DS			;ELSE, RESTORE DS
	MOV	BX,OFFSET CLKFLG	;POINT TO CLOCK FLAG
	MOV	SI,OFFSET CMDBUF	;POINT TO COMMAND LINE
	LODSB				;GET COUNT BYTE
	OR	AL,AL			;ANY ARGUMENT?
	JZ	CLKON			;NO, TURN CLOCK ON
SOS:	LODSB				;GET NEXT BYTE
	CMP	AL,' '			;SPACE?
	JZ	SOS			;IF SO, SKIP IT
	CMP	AL,'O'			;OFF?
	JNZ	CLKON			;NO, TURN CLOCK ON
	MOV	BYTE PTR ES:[BX],0	;KILL CLOCK
	INT	20H			;AND EXIT
CLKON:	MOV	BYTE PTR ES:[BX],1	;ENABLE CLOCK
EXIT:	INT	20H			;AND EXIT
CLOCK	ENDS
	END	START
                                                                       