/*	cminor.h - Enhancements to C syntax	*/

/*	Opening modes for gfopen, gopen, gcreat	*/
#define BIN_MODE 0
#define ASC_MODE 1

/* Use the following when compiler treats char as signed */
#define tochar (c)  ( (c) & 0xff )

/* Use the following when compiter treats char as unsigned */
/* #define tochar (c)  c	*/


/* toascii - Strip parity bit from a char value */
#define toascii (c)  ( (c) & 0x7f )

/* Test a char to see whether the high order bit is zero */
#define isascii (c)  ( ((c) & 0x80) == 0 )

/* Test a char to see if it is printable (ASCII graphic) */
#define isgraphic (c)  ( ((c) >= ' ') && ((c) <= '~') )

/* English for equality comparison operator */
#define is ==

/* English for logical operators */
#define and &&
#define or  ||

/* Portable data types */
typedef int	int16;	/* signed 16 bit integer */
typedef int	INT16;	/* signed 16 bit integer */
typedef long	int32;	/* signed 32 bit integer */
typedef long	INT32;	/* signed 32 bit integer */
typedef unsigned	word16;	/* unsigned 16 bit number */
typedef unsigned	WORD16;	/* unsigned 16 bit number */

/* Maximum, minimum, and absolute value macros */
#define max(a,b)  ( (a) < (b) ? (b) : (a) )
#define min(a,b)  ( (a) < (b) ? (a) : (b) )
#define abs(x)    ( (x) <  0 ?- (x) : (x) )

