;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
;
; Definitions for 6821 Peripheral interface adapter(PIA)
;

;	Register displacements

PIADATA	EQU	0		;PERIPHERAL DATA REGISTER A
PIADDRA	EQU	0		;DATA DIRECTION REGISTER A
PIACTLA	EQU	1		;CONTROL REGISTER A
PIADATB	EQU	2		;PERIPHERAL DATA REGISTER B
PIADDRB	EQU	2		;DATA DIRECTION REGISTER B
PIACTLB	EQU	3		;CONTROL REGISTER B

;	CONTROL WORD FORMAT

PIAC1	EQU	00000011B	;CONTROL OF CA1(CB1) INTERRUPT LINE
PIAC10	EQU	00H		; ACTIVE TRANSITION 1->0
				;  IRQ PIN IS DISABLED
PIAC11	EQU	01H		; ACTIVE TRANSITION 1->0
				;  IRQ PIN IS ENABLED
PIAC12	EQU	02H		; ACTIVE TRANSITION 0->1
				;  IRQ PIN IS DISABLED
PIAC13	EQU	03H		; ACTIVE TRANSITION 0->1
				;  IRQ PIN IS ENABLED

PIADDAC	EQU	00000100B	;DATA DIRECTION ACCESS CONTROL BIT
				; 0=DATA DIRECTION REG, 1=PERIPHERAL DATA REG

PIAC2	EQU	00111000B	;CONTROL OF CA2(CB2)
				; INPUT MODES
PIAC20	EQU	00H		;  ACTIVE TRANSITION 1->0
				;   IRQ PIN IS DISABLED
PIAC21	EQU	08H		;  ACTIVE TRANSITION 1->0
				;   IRQ PIN IS ENABLED
PIAC22	EQU	10H		;  ACTIVE TRANSITION 0->1
				;   IRQ PIN IS DISABLED
PIAC23	EQU	18H		;  ACTIVE TRANSITION 0->1
				;   IRQ PIN IS ENABLED
				; OUTPUT MODES
PIAC24	EQU	20H		;  0 ON R(W) OPERATION, 1 ON ACTIVE CA1(CB1)
PIAC25	EQU	28H		;  0 ON R(W) OPERATION, 1 ON E AFTER DESELECT
PIAC26	EQU	30H		;  RESET
PIAC27	EQU	38H		;  SET

PIAIRQ2	EQU	01000000B	;IRQ FOR CA2(CB2)
PIAIRQ1	EQU	10000000B	;IRQ FOR CA1(CB1)


