;25TH LINE MAGIC WAND DISPLAY FOR FULER FUNCTION
;
;	This program will clear the screen and provide a display
;	on the 25th line which displays a ruler for the
;	Magic Wand text processor.
;
;BY WILLIAM M. ADNEY--2-07-83
;
BOOT	  EQU	  0000H
BDOS	  EQU	  0005H
CONIN	  EQU	  1
CONOUT	  EQU	  2
PLINE	  EQU	  9
CR	  EQU	  0DH
LF	  EQU	  0AH
;
	  ORG	  0100H
MAIN:	  LXI	  D,CLEARIT	  ;CLEAR FUNCTION
	  CALL	  SENDLINE	  ;SENT CLS
	  LXI	  D,LINE1	  
	  CALL	  SENDLINE	  
	  LXI	  D,LINE2
	  CALL	  SENDLINE
	  LXI	  D,LINE3
	  CALL	  SENDLINE
	  LXI	  D,LINE4
	  CALL	  SENDLINE
;
;Remember the cursor position
;
	  LXI	  D,CURPOS  ;REMEMBER CURSOR POSITION
	  CALL	  SENDLINE
;
;Enable the 25th line
;
	  LXI	  D,ENABLE25	      ;25TH LINE ENABLE
	  CALL	  SENDLINE
;
;Position cursor at the beginning of 25th line
;
	  LXI	  D,BEGIN25	      ;25TH LINE BEGINNING
	  CALL	  SENDLINE
;
;Enter Reverse video mode***********COMMENT OUT***********
;
;	  LXI	  D,RVIDEO	      ;REVERSE VIDEO
;	  CALL	  SENDLINE
;
;Print 25th line
;
	  LXI	  D,LINE25	      ;25TH LINE HEADINGS
	  CALL	  SENDLINE
;
;Exit reverse video*************COMMENT OUT************
;
;	  LXI	  D,RVIDEND
;	  CALL	  SENDLINE
;
;Set cursor to previously saved position
;
	  LXI	  D,CURSAVE	      ;cursor to saved position
	  CALL	  SENDLINE
	  RET
;
;************************************
;				    *
;    SUBROUTINES		    *
;				    *
;************************************
;
SENDLINE: MVI	    C,PLINE
	  CALL	    BDOS
	  RET
;
RVIDEO:   DB	1BH,70H,'$'   ;REVERSE VIDEO MODE--ESC p
;
RVIDEND:  DB	1BH,71H,'$'   ;EXIT REVERSE VIDEO MODE--ESC q
;
ENABLE25: DB	1BH,78H,31H,'$'     ;25th line enable--ESC x 1
;
BEGIN25: DB	1BH,59H,38H,20H,'$'	;CURSOR-25th line--ESC Y 8 SP
;
LINE25:   DB '1...+...10....+...20....+...30....+...40....'
	  DB '+...50....+...60....+...70....+...80$'
;
CLEARIT:  DB	1BH,45H,'$'	;CLEAR FUNCTION--ESCAPE E
;
CURPOS:   DB	1BH,6AH,'$'	;Remember cursor position--Escape j
;
CURSAVE:  DB	1BH,6BH,'$'	;Cursor to saved position-ESC k
;
;
LINE1:	DB  'This program sets the 25th line for Magic Wand.',CR,LF,'$'
LINE2:	DB  'A ruler is displayed for convenience.',CR,LF,'$'
LINE3:	DB  ' ',CR,LF,'$'
LINE4:	DB  'To reset the CRT, use the command CRTRESET',CR,LF,'$'
	DS	014H		;RESERVE SPACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER	  EQU	  $		  ;STORAGE AREA STARTS HERE
	  END	  MAIN
PACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER	  E