;	TYPER -- PRINT TEXT TYPED AT KEYBOARD
;
;	THIS PROGRAM ALLOWS THE USER TO ENTER
;	LINES OF TEXT AT THE KEYBOARD AND HAVE
;	THEM SENT TO THE PRINTER.  IT ALLOWS
;	ESCAPE SEQUENCES TO BE TYPED WITHOUT
;	ANY EFFECT ON THE TERMINAL.


;	CP/M ROUTINES, ETC.

LIST	EQU	5		;SEND CHARACTER TO LST DEVICE
PRINT	EQU	9		;PRINT STRING ON CONSOLE
READ	EQU	10		;READ CONSOLE DEVICE
BDOS	EQU	5		;BDOS ADDRESS VECTOR

	ORG	100H

START	LXI	SP,STACK	;SET NEW ONE
	LXI	D,SIGNON	;GET SIGN ON MESSAGE
	MVI	C,PRINT
	CALL	BDOS		;PRINT IT
PROMPT	LXI	D,PRMMSG	;GET PROMPT MESSAGE
	MVI	C,PRINT
	CALL	BDOS		;PRINT IT
	LXI	H,BUFFER
	SHLD	BUFPTR		;SET UP BUFFER POINTER
INLOOP	XRA	A
	STA	INBUFF+2	;CLEAR FIRST CHARACTER
	LXI	D,INBUFF	;POINT TO INPUT BUFFER
	MVI	C,READ
	CALL	BDOS		;READ LINE FROM CONSOLE
	LXI	D,CRLF
	MVI	C,PRINT
	CALL	BDOS		;PRINT CR LF AFTER LINE
	LDA	INBUFF+2	;GET FIRST CHARACTER
	CPI	'.'		;IS HE DONE?
	JZ	FINISH		;IF SO, LEAVE
	LDA	INBUFF+1	;GET COUNT
	MOV	B,A		;B = COUNT
	INR	B		;PRE-INCREMENT IT
	LXI	D,INBUFF+2	;POINT TO TEXT
	LHLD	BUFPTR		;GET BUFFER POINTER
MOVTXT	DCR	B		;DONE MOVING TEXT?
	JZ	MOVDONE		;YES
	LDAX	D		;GET A CHARACTER
	CPI	'^'		;CONTROL CHAR COMING?
	JNZ	NOCON		;NO
	INX	D		;MOVE TO NEXT CHARACTER
	LDAX	D		;GET IT
	CPI	'^'		;LITTERAL "^"?
	JZ	NOCON		;YES
	ANI	5FH		;ELSE, CAPITALIZE
	SUI	40H		;AND MAKE IT A CONTROL CHARACTER
NOCON	MOV	M,A		;PUT IT IN BUFFER
	INX	D
	INX	H		;INCREMENT POINTERS
	JMP	MOVTXT		;LOOP UNTIL FINISHED
MOVDONE	DCX	H		;BACK UP TO LAST CHARACTER
	MOV	A,M		;GET IT
	CPI	'~'		;SUPPRESS CRLF?
	JZ	NOCRLF		;IF SO, JUMP
	CPI	'`'		;CR ONLY?
	JZ	SUPLF		;IF SO, JUMP
	INX	H		;ELSE FIX POINTER
SUPLF	MVI	M,0DH		;TERMINATE LINE
	INX	H		;WITH CR
	CPI	'`'		;SUPPRESS LF?
	JZ	NOCRLF		;IF SO, JUMP
	MVI	M,0AH		;ADD LF
	INX	H		;GET NEXT UNUSED LOCATION
NOCRLF	SHLD	BUFPTR		;UPDATE BUFFER POINTER
	JMP	INLOOP		;GET ANOTHER LINE
FINISH	LHLD	BUFPTR		;GET BUFFER POINTER
	MVI	M,0FFH		;TERMINATE TEXT
	LXI	H,BUFFER	;POINT TO TEXT START
PLOOP	MOV	A,M		;GET CHARCTER
	CPI	0FFH		;END OF TEXT?
	JZ	PROMPT		;IF SO, START OVER
	PUSH	H		;SAVE POINTER
	MOV	E,M		;GET CHARACTER TO PRINT
	MVI	C,LIST
	CALL	BDOS		;PRINT CHARACTER
	POP	H		;RESTORE POINTER
	INX	H		;INCREMENT IT
	JMP	PLOOP		;LOOP UNTIL FINISHED

SIGNON	DB	'TYPEWRITER EMULATOR  by PS:',0DH,0AH,0DH,0AH
	DB	'Enter lines to be printed when prompted.  Enter',0DH,0AH
	DB	'~ at the end of the line to suppress CRLF, and',0DH,0AH
	DB	'` at the end to suppress LF only.  Enter',0DH,0AH
	DB	'. in the first column when done.',0DH,0AH,'$'
PRMMSG	DB	0DH,0AH,'Enter lines (or Control-C to exit):'
	DB	0DH,0AH
CRLF	DB	0DH,0AH,'$'

BUFPTR	DW	0		;BUFFER POINTER
INBUFF	DB	80,0		;MAX CHARACTERS, COUNT
STACK	EQU	$+80+64		;80 CHARACTERS + 64 BYTES STACK
BUFFER	EQU	STACK		;BUFFER STARTS WHERE STACK ENDS

	END	START
S, COUNT
STACK	EQU	$+80+64		;80 CHARACTERS + 64 BYTES STACK
