;;;	z100 - CIOS for MITE utility / Zenith Z100 + SMARTMODEM verison
;
;	L.E. Hughes
;
;	Mycroft Labs, Inc.
;	P.O. Box 6045
;	Tallahassee, FL 32301
;
;	(904) 385-2708

base	equ	0ECH

data	equ	base+0
stat	equ	base+1
mode	equ	base+2
cmd	equ	base+3
 
m8259	equ	0F2H		;master 8259A address
 
zintkd	equ	6
zintsa	equ	5
zintsb	equ	4
zinttim	equ	2
zintei	equ	0
 
cr	equ	0DH		;carriage return
lf	equ	0AH		;line feed
eos	equ	'$'		;end of string
 
sminit	equ	11CH		;location of smart modem init string
predil	equ	167H		;location of smart modem pre-dial str
number	equ	148H		;location of phone number
adtyp	equ	146H		;location of adtyp in main module


	org	180H

;;	jump vector
;
 
	jmp	initm
	jmp	modin
	jmp	modout
	jmp	chkrr
	jmp	chktr
	jmp	chkcd
	jmp	chkpe
	jmp	chkfe
	jmp	chkoe
	jmp	chkri
	jmp	setbr
	jmp	setpar
	jmp	set8db
	jmp	set2sb
	jmp	setorg
	jmp	setoh
	jmp	settxe
	jmp	setbrk
	jmp	dial
	jmp	tenths
	jmp	w1ms
	jmp	exit

;;;	initm - initialize modem
;

initm:	mvi	a,00110111B
	out	cmd
	mvi	a,01111010B	;program mode reg 1 
	out	mode
	mvi	a,01110101B	;program mode reg 2
	out	mode
	mvi	a,00100111B	;program command reg
	out	cmd
	call	initsm		;initialize smart modem
	ret
 
;;;	initsm - initialize smart modem
;
;

initsm:	lxi	d,sminit	;point to init string
	ldax	d		;get character
	cpi	' '
	rz			;exit if first char blank
	call	wasmx		;write string to modem
	ret

 
;;;	exit - exit routine after leaving MITE
;
;

exit:	ret
	
;;;	modin - input character from modem
;
;	exit:	A	character from modem
 
modin:	in	data
	ret

;;;	modout - output character to modem
;
;	entry:	A	character for modem

modout:	out	data
	ret
 
;;;	chkrr - check for receiver ready
;
;	exit:	c-flag	set if character available

chkrr:	in	stat
	ani	02H
	jz	chkrr1
	stc
	ret
chkrr1:	ora	a
	ret
 
;;;	chktr - check for tranmitter ready
;
;	exit:	c-flag	set if transmitter ready

chktr:	in	stat
	ani	01H
	jz	chktr1
	stc
	ret
chktr1:	ora	a
	ret

;;	chkcd - check for carrier detect
;
;	exit:	c-flag	set if carrier present

chkcd:	in	stat
	ani	80H
	jz	chkcd1
	stc
	ret
chkcd1:	ora	a
	ret

;;;	chkpe - check for parity error
;
;	exit:	c-flag set if parity error
 
chkpe:	in	stat
	ani	08H
	jz	chkpe1
	stc
	ret
chkpe1:	ora	a
	ret
 
;;;	chkfe - check for frame error
;
;	exit:	c-flag set if frame error
 
chkfe:	in	stat
	ani	20H
	jz	chkfe1
	stc
	ret
chkfe1:	ora	a
	ret
 
;;;	chkoe - check for overrun error
;
;	exit:	c-flag set if overrun error
 
chkoe:	in	stat
	ani	10H
	jz	chkoe1
	stc
	ret
chkoe1:	ora	a
	ret
 
;;;	chkri - check for ring indicate
;
;	exit:	c-flag	set if incoming call
 
chkri:	stc
	ret
 
;;;	setbr - set baud rate
;
;	entry:	HL	baud rate
;
;	exit:	c-flag	set if error
 
setbr:	lxi	d,110
	mvi	b,3
	call	cmpde
	jz	setbr1
	lxi	d,300
	mvi	b,6
	call	cmpde
	jz	setbr1
	lxi	d,600
	mvi	b,7
	call	cmpde
	jz	setbr1
	lxi	d,1200
	mvi	b,8
	call	cmpde
	jz	setbr1
	lxi	d,2400
	mvi	b,11
	call	cmpde
	jz	setbr1
	lxi	d,4800
	mvi	b,12
	call	cmpde
	jz	setbr1
	lxi	d,9600
	mvi	b,13
	call	cmpde
	jz	setbr1
	stc
	ret
setbr1:	in	mode
	sta	cr1
	in	mode
	lda	cr1
	out	mode
	mov	a,b
	ori	70H
	out	mode
	ret
 
;;;	setpar - set parity
;
;	entry:	A	parity select code:
;				0 = NONE
;				1 = ODD
;				2 = EVEN

setpar:	ora	a		;jump if A .ne. 0
	jnz	setp1
	mvi	b,10H
	jmp	cr1off
setp1:	dcr	a		;jump if A .ne. 1
	jnz	setp2
	mvi	b,10H
	call	cr1on
	mvi	b,20H
	jmp	cr1off
setp2:	mvi	b,10H
	call	cr1on
	mvi	b,20H
	jmp	cr1on

;;;	set8db - set number of data bits
;
;	entry:	A	data bits select code:
;				0 = 7 data bits
;				1 = 8 data bits

set8db:	ora	a		;jump if A .ne. 0
	jnz	set8d1
	mvi	b,08H
	call	cr1on
	mvi	b,04H
	jmp	cr1off
set8d1:	mvi	b,08H
	call	cr1on
	mvi	b,04H
	jmp	cr1on
 
;;;	set2sb - set number of stop bits
;
;	entry:	A	stop bits select code:
;				0 = 1 stop bit
;				1 = 2 stop bits
 
set2sb:	ora	a		;jump if A .ne. 0
	jnz	set2s1
	mvi	b,40H
	call	cr1on
	mvi	b,80H
	jmp	cr1off
set2s1:	mvi	b,40H
	call	cr1on
 	mvi	b,80H
	jmp	cr1on

;;;	setorg - set modem mode (answer or originate)
;
;	entry:	A	mode select code:
;				0 = answer
;				1 = originate

setorg:	ret
 
;;;	setoh - set phone "off hook"
;
;	entry:	A	hook select code:
;				0 = on hook (hung up)
;				1 = off hook
 
setoh:	ora	a
	jnz	setoh1
	mvi	b,02H
	jmp	cr2off
setoh1:	mvi	b,02H
	jmp	cr2on

;;;	settxe - set transmitter enable
;
;	entry:	A	transmitter enable code:
;				0 = disabled
;				1 = enabled
 
settxe:	ret
	
;;;	setbrk - set communications line break
;
;	entry:	A	break enable code:
;				0 = normal
;				1 = break
 
setbrk:	ora	a		;jump if A .ne. 0 (break)
	jnz	setbk1
	mvi	b,08H
	jmp	cr2off
setbk1:	mvi	b,08H
	jmp	cr2on

 
;;	cr1on - turn on bit(s) on modem control reg. one
;
;	entry conditions
;
;		b	ones in positions to turn on
 
cr1on:	push	psw
	in	mode
	ora	b
	sta	cr1
	in	mode
	ori	070H
	sta	cr2
	lda	cr1
	out	mode
	lda	cr2
	out	mode
	pop	psw
	ret
 
;;	cr1off - turn bit(s) off on modem control reg. one
;
;	entry conditions
;
;		b	ones in positions to turn off
 
cr1off:	push	psw
	mov	a,b
	cma
	mov	b,a
	in	mode
	ana	b
	mov	b,a
	in	mode
	ori	070H
	sta	cr2
	mov	a,b
	out	mode
	lda	cr2
	out	mode
	pop	psw
	ret
 
;;	cr2on - turn on bit(s) on modem control reg. two
;
;	entry conditions
;
;		b	ones in positions to turn on
 
cr2on:	push	psw
	in	cmd
	ora	b
	out	cmd
	pop	psw
	ret
 
;;	cr2off - turn bit(s) off on modem control reg. two
;
;	entry conditions
;
;		b	ones in positions to turn off
 
cr2off:	push	psw
	mov	a,b
	cma
	mov	b,a
	in	cmd
	ana	b
	out	cmd
	pop	psw
	ret
 
;;;	cmpde - compare de to hl
;
;	exit:	c-flag	set if de < hl
;		z-flag	set if de = hl

cmpde:	mov	a,h
	cmp	d
	rnz
	mov	a,l
	cmp	e
	ret
 

;;;	dial - dial phone number
;
;	entry:	HL	points to phone number, term by 0 byte

dial:	lda	adtyp		;determine the modem dial type
	cpi	0		;check for hayes
	jz	dialt
	cpi	1		;check for pulse dial
	jz	dialp
	ret			;exit if neither (manual dial)
 
;;;	dialt - dial phone number (hayes method)
;
;	entry:	HL	points to phone number, term by 0 byte

dialt:	push	h
	lxi	d,predil	;point to header string
	call	wasmx		;write to 'modem'
	pop	h
dialt1:	mov	a,m		;fetch next digit
	ora	a		;jump if end of string
	jz	dialt3
	cpi	'^'		;check for control
	jnz	dialt2
	inx	h
	mov	a,m		;get character
	ora	a
	jz	dialt3
	ani	1FH		;make control char
dialt2:	call	wacm		;write to modem
	inx	h
	push	psw
	mvi	b,2
	call	tenths
	pop	psw
	cpi	cr		;check for return
	cz	racmx		;if so, wait for response
	jmp	dialt1
dialt3:	mvi	a,cr		;issue CR
	call	wacm
	ret
 
;;;	dialp - dial phone number pusle method
;
;	entry:	HL	points to phone number, term by 0 byte

dialp:	mov	a,m		;fetch next digit of number
	ora	a		;exit if zero
	rz
	inx	h		;increment pointer
	cpi	'*'		;jump if not asterisk
	jnz	dialp2
	mvi	b,10		;wait 1 second
	call	tenths
	jmp	dialp		;continue
dialp2:	sui	'0'		;convert ASCII to binary
	jc	dialp		;ignore if < '0'
	cpi	10		;ignore if > '9'
	jnc	dialp
	ora	a		;jump if not zero 
	jnz	dialp3
	mvi	a,10		;use 10 clicks for zero
dialp3:	mov	b,a		;b = number of clicks
dialp4:	push	b
	mvi	a,0
	call	setoh
	call	wait50		;wait 50 msec
	mvi	a,1
	call	setoh
	call	wait50		;wait 50 msec
	pop	b
	dcr	b		;decrement click count
	jnz	dialp4		;loop until zero
	mvi	b,7		;interdigit wait (.7 sec)
	call	tenths
	jmp	dialp

 
;;	racmx - read until no more
;

racmx:	push	b		;save bc
racmx0:	lxi	b,500		;.25 seconds w/o character
racmx1:	call	chkrr
	jc	racmx2		;jump if character
	call	w1ms		;wait a millisecond
	dcx	b
	mov	a,b
	ora	c
	jnz	racmx1		;loop if not done
	pop	b
	ret			;exit if done
racmx2:	call	modin		;get character
	jmp	racmx0		;try again

;;	wasmx - write ASCII string to modem with check
;

wasmx:	ldax	d
	inx	d		;update pointer
	ora	a		;check for end
	rz
	cpi	'^'		;check for control code
	jnz	wasmx1
	ldax	d
	inx	d
	ani	1FH		;convert to control
wasmx1:	call	wacm		;write character
	push	psw
	mvi	b,2
	call	tenths
	pop	psw
	cpi	cr		;check for return
	jnz	wasmx		;continue
	call	racmx		;wait for no response
	jmp	wasmx


;;	wasm - write ASCII string to modem
;
 
wasm:	ldax	d
	cpi	'$'
	rz
	call	wacm
	inx	d
	jmp	wasm
 
;;	wacm - write ASCII character to modem
;
 
wacm:	push	psw
wacm1:	call	chktr
	jnc	wacm1
	pop	psw
	jmp	modout
 
;;	racm - read ASCII character from modem
;
 
racm:	call	chkrr
	jnc	racm
	jmp	modin
 
;;	tenths - wait B tenths of a second
;
;	entry:	B	number of tenths of a second to wait

tenths:	call	tenth
	dcr	b
	jnz	tenths
	ret
 
;;	tenth - wait 1 tenth of a second
;
 
tenth:	push	b
	mvi	b,100
tenth1:	call	w1ms
	dcr	b
	jnz	tenth1
	pop	b
	ret

;;	w1ms - wait one millisecond
;
 
w1ms:	push	psw
	push	h
	lxi	h,160
w1ms1:	dcx	h
	mov	a,h
	ora	l
	jnz	w1ms1
	pop	h
	pop	psw
	ret
 
;;;	wait50 - wait 50 milliseconds
;

wait50:	push	b
	mvi	b,50
wt50:	call	w1ms		;wait 1 ms
	dcr	b
	jnz	wt50		;do 50 times
	pop	b
	ret

 
cr1:	ds	1
cr2:	ds	1
 
	end	z100

