	PAGE	,132
	TITLE	AUTOMATIC PATCH INSTALLER
;	PATCHER -- AUTOMATIC PATCH INSTALLER
;
;	THIS PROGRAM PATCHES PROGRAMS BASED ON THE INFORMATION
;	CONTAINED IN A DATA FILE (PATCHER.DAT).  THE PRIMARY
;	PURPOSE IS TO PATCH PROGRAMS FOR USE WITH ZPC, BUT IT
;	COULD BE USED FOR ANY PATCHING JOB.
;
;	BY P. SWAYNE, HUG  26-FEB-86

;	DEFINITIONS

OPENF	EQU	0FH			;OPEN FILE
CLOSEF	EQU	10H			;CLOSE FILE
SETDTA	EQU	1AH			;SET DTA ADDRESS
READF	EQU	27H			;READ FILE (RANDOM BLK.)
WRITEF	EQU	28H			;WRITE FILE (RANDOM BLOCK)
PFN	EQU	29H			;PARSE FILE NAME
RDDEV	EQU	3FH			;READ FROM DEVICE

CODE	SEGMENT
	ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	6
SEGEND	LABEL	WORD			;END OF THIS SEGMENT
	ORG     5CH
FCB	LABEL   BYTE			;DEFAULT FCB ADDRESS
	ORG	80H
DEFDTA	LABEL	BYTE			;TEXT BUFFER
	ORG     100H

;	BEGIN PROGRAM -- READ IN PATCHER.DAT

START:	MOV     DX,OFFSET SIGNON
	MOV     AH,9
	INT     21H			;PRINT SIGNON
	MOV     DI,OFFSET PCHFCB+32	;POINT TO RECORD COUNTERS
	XOR     AX,AX
	CLD
	MOV	CX,3
	REP	STOSW			;CLEAR RECORD COUNTERS
	MOV	DX,OFFSET PCHFCB
	MOV	AH,OPENF
	INT	21H			;OPEN DATA FILE
	INC	AL
	JNZ	OPENED			;OPEN OK
PFILERR:MOV	DX,OFFSET NODAT
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO DATA FILE"
	INT	20H
OPENED:	MOV	WORD PTR PRECSIZ,1	;SET RECORD SIZE TO 1
	MOV	DX,OFFSET BUFFER
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO BUFFER
	MOV	CX,SEGEND		;GET END OF THIS SEGMENT
	SUB	CX,OFFSET BUFFER	;SUBTRACT SPACE USED BY PATCHER
	MOV	DX,OFFSET PCHFCB
	MOV	AH,READF
	INT	21H			;READ FROM FILE
	CMP	AL,1
	JNZ	PFILERR			;FILE ERROR
	MOV	WORD PTR DATSIZ,CX	;SAVE DATA FILE SIZE

;	LIST PROGRAMS IN PATCHER.DAT

PPRG:	MOV	CX,WORD PTR DATSIZ
	CLD
	MOV	DI,OFFSET BUFFER	;PATCHER.DAT IS HERE
	PUSH	DI			;SAVE POINTER
	ADD	DI,CX			;MOVE TO END
	MOV	BYTE PTR [DI],'Z'-'@'	;MARK EOF
	POP	DI
	MOV	BX,1			;INITIALIZE COUNTER
PPRGLP:	MOV	SI,36			;SET 36 ENTRY COUNTER
PPRGLP1:CMP	BL,10			;BELOW 10?
	JNB	MT10			;NO
	CALL	SPACE			;ELSE, SPACE BEFORE NUMBER
MT10:	CALL	DECOUT			;PRINT COUNTER
	CALL	PTEXT			;PRINT NAME OF PROGRAM TO PATCH
	MOV	AX,BX			;GET COUNT
	SHR	AX,1			;TEST FOR EVEN NUMBER
	JC	NOTEVEN			;NOT EVEN
	CALL	CRLF			;ELSE, NEW LINE
	JMP	SHORT EVEN
NOTEVEN:CALL	SPACE			;EXTRA SPACE BETWEEN ENTRIES
EVEN:	MOV	AL,'z'
	REPNZ	SCASB			;LOOK FOR NEXT FILE MARKER
	JNZ	ENDPRG			;NOT FOUND
	MOV	AL,0AH
	REPNZ	SCASB			;PASS LF AFTER "z"
	CMP	BYTE PTR [DI],' '	;CHECK FOR EOF
	JBE	ENDPRG			;EXIT IF END
	INC	BX			;ELSE, COUNT NEW PROGRAM
	DEC	SI			;COUNT ENTRY IN SCREEN
	JNZ	PPRGLP1			;SCREEN NOT DONE
	MOV	DX,OFFSET HITRET
	MOV	AH,9
	INT	21H			;SAY "HIT RETURN"
	MOV	DX,OFFSET DEFDTA	;PUT INPUT TEXT HERE
	PUSH	BX
	PUSH	CX
	MOV	BX,0			;INPUT HANDLE
	MOV	CX,80			;GIVE HIM SOME SLOP
	MOV	AH,RDDEV
	INT	21H			;WAIT FOR CR
	POP	CX
	POP	BX
	CALL	CRLF
	JMP	PPRGLP			;PRINT NEW PROGRAM NAME
ENDPRG:	MOV	BYTE PTR COUNT,BL	;SAVE COUNT OF PROGRAMS
	SHR	BL,1			;TEST FOR EVEN NUMBER
	JNC	INPNUM			;IF EVEN, SKIP CRLF
	CALL	CRLF

;	GET NUMBER OF PROGRAM TO PATCH

INPNUM:	MOV	DX,OFFSET ENTNUM
	MOV	AH,9
	INT	21H			;PROMPT FOR NUMBER OF PGM TO PATCH
	MOV	DX,OFFSET DEFDTA	;PUT INPUT TEXT HERE
	MOV	BX,0			;INPUT HANDLE
	MOV	CX,80			;GIVE HIM SOME SLOP
	MOV	AH,RDDEV
	INT	21H			;INPUT NUMBER
	CMP	AX,2			;CR ONLY
	JNBE	NOTCR
	CALL	CRLF
	JMP	PPRG			;IF SO, RE-DISPLAY
NOTCR:	MOV	CX,AX			;CHAR COUNT TO CX
	MOV	SI,OFFSET DEFDTA	;POINT TO NUMBER
	MOV	BL,0			;CLEAR AN ACCUMULATOR
GETNUM:	LODSB				;GET A CHARACTER
	SUB	AL,'0'			;REMOVE ASCII
	JC	GOTNUM			;BAD CHAR, END OF ENTRY
	CMP	AL,10			;MORE THAN 9?
	JNB	GOTNUM			;IF SO, END OF ENTRY
	SHL	BL,1			;ELSE, MULTIPLY BY 2
	MOV	BH,BL			;SAVE RESULT
	SHL	BL,1			;* 4
	SHL	BL,1			;* 8
	ADD	BL,BH			;N*8+N*2=N*10
	ADD	BL,AL			;ADD IN LATEST DIGIT
	LOOP	GETNUM			;LOOP UNTIL DONE
GOTNUM:	OR	BL,BL			;TEST NUMBER
	JZ	INPNUM			;ZERO IS ILLEGAL
NOTZRO:	CMP	BL,BYTE PTR COUNT
	JA	INPNUM			;MORE THAN COUNT IS ILLEGAL

;	PROMPT USER TO INSERT DISK

	CALL	CRLF			;LINE AFTER NUMBER INPUT
	MOV	CX,DATSIZ		;GET DATA FILE SIZE
	MOV	DI,OFFSET BUFFER	;POINT TO BUFFER
LFPLP:	MOV	AL,0AH			;LINE FEED CODE
	REPNZ	SCASB			;LOOK FOR IT
	DEC	BL			;IS THIS THE PLACE?
	JZ	PROMPT			;YES
	MOV	AL,'z'
	REPNZ	SCASB			;LOOK FOR NEXT PROGRAM
	MOV	AL,0AH
	REPNZ	SCASB			;PASS LF AFTER "z"
	JMP	LFPLP			;NOW, LOOK FOR PROMPT
PROMPT:	CALL	PTEXT			;PRINT PROMPT TEXT
	MOV	DX,OFFSET HITCR
	MOV	AH,9
	INT	21H			;PROMPT FOR "HIT RETURN"
	MOV	DX,OFFSET DEFDTA	;PUT INPUT TEXT HERE
	MOV	BX,0			;INPUT HANDLE
	PUSH	CX
	MOV	CX,80
	MOV	AH,RDDEV
	INT	21H			;WAIT FOR CR
	POP	CX
	CALL	CRLF			;SKIP A LINE
	MOV	DX,OFFSET DEFDTA
	MOV	AH,SETDTA
	INT	21H			;SET DEFAULT DTA

;	ENTER MAIN PATCH LOOP
;	FIRST, OPEN FILE TO PATCH

PCHLP:	MOV	AL,0AH
	REPNZ	SCASB			;MOVE TO FILE NAME
	PUSH	DI			;SAVE POINTER
	MOV	SI,DI			;POINT SI TO FILE NAME
	MOV	DI,OFFSET FCBZ
	PUSH	CX
	MOV	CX,21
	XOR	AL,AL
	REP	STOSB			;FILL END OF FCB
	POP	CX
	MOV	DI,OFFSET FILFCB	;POINT TO FILE FCB
	MOV	AL,0
	MOV	AH,PFN
	INT	21H			;PARSE FILE NAME
	POP	DI			;RESTORE POINTER
	MOV	NAMADR,DI		;SAVE NAME ADDRESS
	MOV	AL,FCB			;GET DRIVE CODE ENTERED
	MOV	BYTE PTR FILFCB,AL	;SAVE IT HERE
	MOV	DX,OFFSET FILFCB
	MOV	AH,OPENF
	INT	21H			;TRY TO OPEN FILE TO PATCH
	INC	AL
	JNZ	OPENOK			;FILE OPENED OK
	MOV	DX,OFFSET NOFILE
	MOV	AH,9
	INT	21H			;SAY "FILE.."
	CALL	PTEXT1			;PRINT FILE NAME
	MOV	DX,OFFSET NTFND
	MOV	AH,9
	INT	21H			;SAY "NOT FOUND"
	INT	20H			;EXIT
OPENOK:	MOV	WORD PTR RECSIZ,1	;SET RECORD SIZE TO 1

;	SMALL PATCH LOOP.  GET PATCHES FROM DATA FILE
;	AND WRITE THEM TO FILE BEING PATCHED.

SPCHLP:	MOV	AL,0AH
	REPNZ	SCASB			;SKIP LF, MOVE TO ADDRESS
	CALL	HEXIN			;READ NUMBER
	CMP	AL,'x'			;END OF PATCHES FOR THIS FILE?
	JZ	CLOSE
	CMP	AL,'z'			;END OF WHOLE THING?
	JZ	CLOSE
	MOV	RNDREC,BX		;SET RANDOM RECORD TO PATCH ADDRESS
	MOV	RNDREC+2,DX
	MOV	SI,OFFSET DEFDTA	;POINT TO DEFAULT DTA
	MOV	DX,0			;CLEAR A COUNTER
IPCHLP:	PUSH	DX
	CALL	HEXIN			;READ BYTE
	POP	DX
	INC	DX			;COUNT IT
	MOV	[SI],BL			;STORE IT
	INC	SI			;INCREMENT POINTER
	CMP	AL,','			;ANOTHER BYTE?
	JZ	IPCHLP			;YES, GET IT
	PUSH	CX			;SAVE MAIN COUNTER
	MOV	CX,DX			;GET COUNT OF BYTES TO PATCH
	MOV	DX,OFFSET FILFCB
	MOV	AH,WRITEF
	INT	21H			;WRITE TO FILE
	POP	CX
	OR	AL,AL
	JZ	PCHOK			;WRITE OK
WRERR:	MOV	DX,OFFSET BADWR
	MOV	AH,9
	INT	21H			;SAY "NO WRITE"
	MOV	DI,NAMADR		;GET FILE NAME ADDRESS
	CALL	PTEXT1			;PRINT FILE NAME
	MOV	DL,'.'
	CALL	SCOUT
	INT	20H
PCHOK:	JMP	SPCHLP			;CONTINUE WITH PATCHES
CLOSE:	PUSH	AX			;SAVE CLOSE CODE
	MOV	DX,OFFSET FILFCB
	MOV	AH,CLOSEF
	INT	21H			;CLOSE FILE
	INC	AL
	JZ	WRERR			;ERROR IN CLOSING
	POP	AX
	CMP	AL,'x'			;ANOTHER FILE TO DO?
	JNZ	PCHDN			;NO
	JMP	PCHLP			;ELSE, GO DO IT
PCHDN:	MOV	DX,OFFSET DONE
	MOV	AH,9
	INT	21H			;ELSE, SAY "DONE"
	INT	20H			;AND EXIT

;	SUBROUTINES

;	PRINT A SPACE

SPACE:	MOV	DL,' '
	CALL	SCOUT			;PRINT SPACE
	RET

;	PRINT CR, LF

CRLF:	MOV	DX,OFFSET CRLFM
	MOV	AH,9
	INT	21H			;PRINT CRLF
	RET

;	PRINT TEXT AT [DI], AND ENOUGH SPACES
;	TO TOTAL 35 CHARACTERS

PTEXT:	PUSH	BX			;SAVE BX
	MOV	BL,34			;SET A COUNTER
PTXLP:	MOV	DL,[DI]			;GET CHARACTER
	INC	DI			;MOVE POINTER
	DEC	CX			;COUNT CHARACTER
	CMP	DL,0DH			;END OF MESSAGE?
	JZ	PTEND			;YES
	CALL	SCOUT			;ELSE, PRINT CHARACTER
	DEC	BL			;AND COUNT IT
	JMP	PTXLP
PTEND:	OR	BL,BL			;ANY SPACES TO DO?
	JS	PTEX			;NO
	CALL	SPACE			;ELSE PRINT ONE
	DEC	BL			;COUNT IT
	JMP	PTEND			;TEST AGAIN
PTEX:	POP	BX
	RET
PTEXT1:	PUSH	BX			;ENTRY TO PRINT W/O SPACES
	MOV	BL,1			;NO SPACES AFTER TEXT
	JMP	PTXLP

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	CALL	DEC0			;PRINT NUMBER
	MOV	DX,OFFSET PERSP
	MOV	AH,9
	INT	21H			;PRINT PERIOD, SPACE
	RET
DEC0:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DEC0			;CALL RECURSIVELY UNTIL DONE
DEC1:	ADD	DL,'0'			;ADD ASCII BIAS
	CALL	SCOUT			;PRINT IT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

;	PRINT CHARACTER IN DL

SCOUT:	MOV	AH,2
	INT	21H			;PRINT CHARACTER
	RET

;	INPUT ASCII HEX NUMBERS. DI POINTS TO STRING.
;	RESULT IN DX,BX.

HEXIN:	XOR	BX,BX			;CLEAR ACCUMULATOR
	XOR	BP,BP			;CLEAR 24 BITS IN ALL
HEXLP:	MOV	AL,[DI]			;GET DIGIT
	INC	DI			;MOVE POINTER
	DEC	CX			;COUNT CHARACTER
	MOV	AH,AL			;SAVE IN AH
	SUB	AL,'0'			;REMOVE ASCII
	JC	HEXEND			;LESS THAN "0"
	ADD	AL,'0'-'G'
	JC	HEXEND			;MORE THAN "F"
	ADD	AL,6			;TEST FOR A-F
	JNS	HEXOK			;DIGIT IS A-F
	ADD	AL,7			;TEST FOR 0-9
	JC	HEXEND			;DIGIT OUT OF RANGE
HEXOK:	ADD	AL,10			;ELSE, ADJUST
	PUSH	AX			;SAVE DIGIT
	MOV	AX,BX
	MUL	WORD PTR SIXTEEN	;MULTIPLY ACCUMULATOR BY 16
	MOV	BX,AX
	ADD	BP,DX			;UPDATE HIGH WORD
	POP	AX
	OR	BL,AL			;ADD IN LATEST DIGIT
	JMP	HEXLP			;GET ANOTHER ONE
HEXEND:	MOV	AL,AH			;PUT LAST CHAR IN AL
	MOV	DX,BP
	RET

;	MESSAGES

SIGNON	DB	13,10,'Automatic Patch Installer, V 1.1'
	DB	13,10,10
	DB	'Patches in the current data file are for'
	DB	' these programs:',13,10,10,'$'
NODAT	DB	7,'ERROR -- PATCHER.DAT not found, or cannot be read'
PERSP	DB	'. $'
FILES	DB	'Here is a list of programs that can be patched.'
	DB	13,10,10,'$'
HITRET	DB	13,10,'Hit RETURN to see more programs...$'
ENTNUM	DB	13,10,'Enter the number of the program you want to patch,'
	DB	13,10,'or hit RETURN to re-display the programs: $'
HITCR	DB	13,10,'Hit RETURN...$'
NOFILE	DB	7,'ERROR -- File $'
NTFND	DB	' not found.$'
BADWR	DB	7,'ERROR -- Problem in writing to $'
DONE	DB	'Your program was successfully patched.'
CRLFM	DB	13,10,'$'

DATSIZ	DW	0			;DATA FILE SIZE
COUNT	DB	0			;COUNT OF PROGRAMS IN DATA FILE
NAMADR	DW	0			;FILE NAME ADDRESS
SIXTEEN	DW	16			;MULTIPLIER FOR HEX INPUT

;	FCB FOR PATCHER DATA FILE

PCHFCB	DB	0,'PATCHER DAT'
	DB	0,0
PRECSIZ	DW	1			;RECORD SIZE (1 BYTE)
	DB	17 DUP (0)
PRNDREC	DW	0,0			;RANDOM RECORD NUMBER

;	FCB FOR FILE TO BE PATCHED

FILFCB	DB	0,'           '
	DB	0,0
RECSIZ	DW	1			;RECORD SIZE (1 BYTE)
FCBZ	DB	17 DUP (0)
RNDREC	DW	0,0			;RANDOM RECORD NUMBER

BUFFER	LABEL	BYTE			;BUFFER STARTS HERE

CODE	ENDS
	END	START
