	PAGE	,132
;	FIXLTS AND FIXSYM -- FIX LOTUS 1-2-3 RELEASE 2 AND
;	SYMPHONY TO WORK UNDER ZPC WITHOUT ZHS.
;
;	TO USE THIS PROGRAM, ENTER
;
;	FIXLTS d:<name>
;
;	WHERE d: IS THE DRIVE CONTAINING THE DRIVER FILE
;	(123.SET OR LOTUS.SET), AND <name> IS AN OPTIONAL
;	NAME IF THE DRIVER IS NOT NAMED 123.SET OR LOTUS.SET.
;
;	BY P. SWAYNE, HUG  13-JUN-86  02-DEC-86

;	DEFINITIONS

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
FIXLTS	EQU	TRUE			;ASSEMBLE AS FIXLTS

OPENF	EQU	0FH			;OPEN FILE
CLOSEF	EQU	10H			;CLOSE FILE
SETDTA	EQU	1AH			;SET DTA ADDRESS
READF	EQU	27H			;READ FILE (RANDOM BLK.)
WRITEF	EQU	28H			;WRITE FILE (RANDOM BLOCK)

CODE	SEGMENT
	ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	6
BUFSIZ	LABEL	WORD
	ORG	50H
CURPOS	LABEL	WORD
	ORG     5CH
FCB	LABEL   BYTE                    ;DEFAULT FCB ADDRESS
	ORG     100H

START:	CMP	FCB+1,' '		;TEST FOR NAME
	JNZ	GOTNAM			;GOT ONE
	MOV	SI,OFFSET LTSNAM	;POINT TO "123.SET"
	MOV	DI,OFFSET FCB+1		;PUT IT HERE
	MOV	CX,11			;11 CHARS
	CLD
	REP	MOVSB			;MOVE IT IN
GOTNAM:	MOV     DI,OFFSET FCB+32        ;POINT TO RECORD COUNTERS
	XOR     AX,AX
	MOV	CX,3
	REP	STOSW			;CLEAR RECORD COUNTERS
	MOV	DX,OFFSET FCB
	MOV	AH,OPENF
	INT	21H			;OPEN FILE
	INC	AL
	JNZ	OPENED			;OPEN OK
FILERR:	MOV	DX,OFFSET FRMSG
	MOV	AH,9
	INT	21H			;SAY "FILE ERROR"
	INT	20H			;AND EXIT
PCHSIZ	DW	0			;STORE PATCH SIZE HERE
OPENED:	MOV	WORD PTR FCB+14,1	;SET RECORD SIZE TO 1
	MOV	DX,OFFSET BUFFER
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO BUFFER
	MOV	CX,BUFSIZ		;GET BUFFER SIZE
	SUB	CX,OFFSET BUFFER	;REMOVE PROGRAM SPACE
	MOV	DX,OFFSET FCB
	MOV	AH,READF
	INT	21H			;READ FROM FILE
	CMP	AL,2
	JNC	FILERR			;FILE ERROR
	MOV	PCHSIZ,CX		;STORE FILE HERE
	MOV	DI,OFFSET BUFFER
	MOV	BP,0			;SET A COUNTER
SCODLP0:MOV	AL,0BAH			;SEARCH FOR THIS
	MOV	BX,3DAH			;AND PORT 3DAH
SCODLP:	REPNZ	SCASB			;SEARCH FOR IT
	JNZ	NXPCH			;NOT FOUND, CHECK NEXT
	CMP	ES:[DI],BX		;IS THIS IT?
	JNZ	SCODLP			;NO, KEEP LOOKING
	INC	BP			;COUNT 1 PATCH FOUND
	ADD	DI,2			;MOVE TO PATCH AREA
	PUSH	CX
	MOV	CX,10			;PATCH 10 BYTES
	MOV	AL,90H			;WITH "NOP"
	REP	STOSB			;MAKE THE PATCH
	POP	CX
	JMP	SCODLP0			;LOOK FOR MORE
NXPCH:	MOV	CX,PCHSIZ		;GET SIZE AGAIN
	MOV	DI,OFFSET BUFFER
	MOV	AL,0BAH			;SEARCH FOR THIS
	MOV	BX,3D9H			;AND PORT 3D9H
SCODLP1:REPNZ	SCASB			;SEARCH FOR IT
	JNZ	NXPCH1			;NOT FOUND, CHECK NEXT
	CMP	ES:[DI],BX		;IS THIS IT?
	JNZ	SCODLP1			;NO, KEEP LOOKING
	INC	BP			;COUNT THE PATCH
	MOV	BYTE PTR 2[DI],90H	;MAKE THE PATCH
	JMP	SCODLP1			;LOOK FOR MORE
NXPCH1:	MOV	CX,PCHSIZ		;GET SIZE AGAIN
	MOV	DI,OFFSET BUFFER
	MOV	BX,3D8H			;FIND PORT 3D8H
SCODLP2:REPNZ	SCASB			;SEARCH FOR IT
	JNZ	NXPCH2			;NOT FOUND
	CMP	ES:[DI],BX		;IS THIS IT?
	JNZ	SCODLP2			;NO, KEEP LOOKING
	INC	BP			;COUNT THE PATCH
	MOV	BYTE PTR 2[DI],90H	;MAKE THE PATCH
	JMP	SCODLP2			;LOOK FOR MORE
NXPCH2:	MOV	CX,PCHSIZ		;GET SIZE AGAIN
	MOV	DI,OFFSET BUFFER
	MOV	AL,0B8H			;SEARCH FOR THIS
	MOV	BX,50H			;AND THIS
	MOV	DX,0E2F7H		;AND THIS
SCODLP3:REPNZ	SCASB			;SEARCH FOR IT
	JNZ	PCHDN			;NOT FOUND, DONE
	CMP	ES:[DI],BX		;IS THIS IT?
	JNZ	SCODLP3			;NO
	CMP	ES:2[DI],DX
	JNZ	SCODLP3
	INC	BP			;COUNT THE PATCH
	DEC	DI			;BACK UP TO PATCH AREA
	MOV	SI,OFFSET FIXCUR	;POINT TO CURSOR FIX
	MOV	CX,FIXSIZ
	REP	MOVSB			;MOVE IN PATCH
PCHDN:	MOV	WORD PTR FCB+33,0	;RESET RECORD ADDRESS
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO WRITE
	MOV	DX,OFFSET FCB
	MOV	AH,WRITEF
	INT	21H			;WRITE TO FILE
	OR	AL,AL
	JZ	PCHOK			;WRITE OK
WRERR:	MOV	DX,OFFSET FWMSG
	MOV	AH,9
	INT	21H			;SAY "FILE ERROR"
	INT	20H			;AND EXIT
PCHOK:	MOV	DX,OFFSET FCB
	MOV	AH,CLOSEF
	INT	21H			;CLOSE FILE
	INC	AL
	JZ	WRERR			;ERROR IN CLOSING
	MOV	DX,OFFSET DONE
	MOV	AH,9
	INT	21H			;ELSE, SAY "DONE"
	MOV	DX,BP			;GET PATCH COUNT
	ADD	DL,'0'			;ADD ASCII
	MOV	AH,2
	INT	21H			;PRINT COUNT
	MOV	DX,OFFSET DONE1
	MOV	AH,9
	INT	21H			;PRINT REST OF MSG.
	INT	20H			;AND EXIT

;	CURSOR FIX PATCH CODE

FIXCUR	PROC	FAR
	MOV	CH,DL			;COPY ROW TO CH
	CMP	DX,-1			;IDLE CURSOR?
	JNZ	NOTIDL			;NO
	MOV	CX,0			;ELSE, POS. IS 0
NOTIDL:	PUSH	DS			;SAVE DS
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	MOV	CURPOS,CX		;SAVE CURSOR POSITION
	POP	DS
	RET
FIXEND:
FIXCUR	ENDP
FIXSIZ	EQU	FIXEND-FIXCUR

;	DATA AREA

FRMSG	DB	13,10,'File read error.  No patch done.',13,10,'$'
FWMSG	DB	13,10,'File write error.  Driver file may be'
	DB	'destroyed.',13,10,'$'
DONE	DB	13,10,'Patching done, $'
DONE1	DB	' patches installed.',13,10,'$'

	IF	FIXLTS
LTSNAM	DB	'123     SET'
	ELSE
LTSNAM	DB	'LOTUS   SET'
	ENDIF

BUFFER	LABEL	BYTE			;BUFFER STARTS HERE

CODE	ENDS
	END	START
