;   This program provides the LISTC type of function.
;
;   Originally called XDIR or XD, it is now set up for
;      a source listing to clean it up.
;
;   By: William M. Adney
;
;   Date: 2-7-83
;
;
BOOT	EQU	0	;Cold boot
BDOS	EQU	5	;Call to CP/M
PCHAR	EQU	2	;Print character on CRT
PSTRING EQU	9	;Print character string on CRT
RETVERS EQU	12	;Return CP/M version number
RETDISK EQU	25	;Return current disk drive
SELDISK EQU	14	;Select disk drive
CR	EQU	0DH	;Carriage return
LF	EQU	0AH	;Line feed
FORMFEED EQU	00CH	;Form feed
GETADDRD EQU	31	;Get address(disk parms)
SFIRST	EQU	17	;Search directory for first match
SNEXT	EQU	18	;Search directory for next match
;
;
	ORG	100H
;
MAIN:	JMP	CLS		;Clear the screen
MAIN1:	DAD	SP
	SHLD	SPSAVE		;and save it
	LXI	SP,L054D
	MVI	C,RETDISK	;Get current disk drive
	CALL	BDOS
	STA	L0501
	STA	L0502
	LXI	H,00080H
	MOV	B,M
	INR	B
DISKCON:INX	H
	DCR	B
	JZ	CPMVER
	MOV	A,M
	CPI	041H
	JC	DISKCON
	CPI	051H
	JNC	DISKCON
	SUI	041H
	STA	L0502
CPMVER: LXI	H,00040H
	SHLD	NOP11
	LXI	H,000F1H
	SHLD	NOP9
	MVI	A,007H
	STA	L0500
	MVI	C,RETVERS	;Return version number
	CALL	BDOS
	XRA	A
	ORA	L
	PUSH	PSW
	MVI	C,SELDISK	;Select disk function
	LDA	L0502
	MOV	E,A
	LDA	L0501
	CMP	E
	CNZ	BDOS		;Call CP/M if not zero to select different disk
	POP	PSW
	JZ	DIRSCH1
	MVI	C,GETADDRD	;Get address(disk parms)
GETPARM:EQU	$-1
	CALL	BDOS
	INX	H
	INX	H
	MOV	A,M
	DCR	A
	DCR	A
	STA	NOP13
	PUSH	H
	LXI	H,DIRRD1
GETP1:	DAD	H
	DCR	A
	JNZ	GETP1
	SHLD	NOP12
	POP	H
	INX	H
	MOV	A,M
	STA	L0500
	INX	H
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	INX	D
	XCHG
	SHLD	NOP10
	XCHG
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	INX	H
	SHLD	NOP11
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	XCHG
	LHLD	NOP12
	DCX	H
	DAD	D
	LDA	NOP13
	MOV	C,A
	MOV	A,H
	RAR
	ANI	07EH
GETP2:	RAR
	DCR	C
	JNZ	GETP2
	CMA
	MOV	C,A
	MVI	B,0FFH
	INX	B
	LHLD	NOP10
	DAD	B
	LDA	NOP13
GETP3:	DCR	A
	JZ	DIRSCH 
	DAD	H
	JMP	GETP3
DIRSCH: SHLD	NOP9
DIRSCH1:LXI	H,0005CH
	MVI	M,000H
	INX	H
	MVI	B,12		;12 is number for ????????.???
SETQUES:MVI	M,03FH		;Set question marks
	INX	H
	DCR	B
	JNZ	SETQUES
	MVI	C,SFIRST	;Search for first directory entry
	JMP	DIRREAD
DIRNEXT:MVI	C,SNEXT 	;Search for next directory entry
DIRREAD:LXI	D,0005CH
	CALL	BDOS
	ORA	A
	JM	SORTIT		 ;Get out if no more directory entries
	LHLD	NOP1
	INX	H
	SHLD	NOP1
	LXI	D,00080H
	ANI	003H
	RRC
	RRC
	RRC
	ADD	E
	MOV	E,A
	LXI	H,0000FH
	DAD	D
	MOV	A,M
	CPI	080H
	JZ	DIRNEXT 	  ;Read next directory entry
	MOV	B,A
	LDA	L0500
	CMA
	MOV	C,A
	CMA
	ADD	B
	ANA	C
	RRC
DIRRD1: RRC
	RRC
	ANI	01FH
	MOV	B,A
	DCX	H
	DCX	H
	DCX	H
	MOV	A,M
	RLC
	RLC
	RLC
	RLC
	ANI	0F0H
	ADD	B
	MOV	M,A
	LHLD	NOP3
	MOV	C,A
	MVI	B,000H
	DAD	B
	SHLD	NOP3
	LHLD	NOP4
	INX	D
	MVI	B,FORMFEED	;Form feed
DIRRD2: LDAX	D
	MOV	M,A
	INX	H
	INX	D
	DCR	B
	JNZ	DIRRD2
	SHLD	NOP4
	LHLD	NOP2
	INX	H
	SHLD	NOP2
	JMP	DIRNEXT 	;Read next directory entry
SORTIT: LHLD	NOP2		;Begin directory sort
	SHLD	L0509
SORT1:	LHLD	L0509
	MOV	A,H
	ORA	A
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	SHLD	L0509
	ORA	H
	JZ	HEADVAL
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	XCHG
	LHLD	NOP2
	DAD	D
	SHLD	L0507
	LXI	H,00001H
	SHLD	L0505
SORT2:	SHLD	L0503
SORT3:	XCHG
	LHLD	L0509
	DAD	D
	DAD	H
	DAD	H
	MOV	D,H
	MOV	E,L
	DAD	H
	DAD	D
	LXI	B,L0541
	DAD	B
	XCHG
	LHLD	L0503
	DAD	H
	DAD	H
	PUSH	D
	MOV	D,H
	MOV	E,L
	DAD	H
	DAD	D
	POP	D
	DAD	B
	MVI	B,00BH
SORT4:	LDAX	D
	CMP	M
	JC	SORT8
	JNZ	SORT5
	INX	D
	INX	H
	DCR	B
	JNZ	SORT4
SORT5:	LHLD	L0505
	INX	H
	SHLD	L0505
	XCHG
	LHLD	L0507
	MOV	A,H
	CMP	D
	JC	SORT1
	JNZ	SORT7
SORT6:	EQU	$-1
	MOV	A,L
	CMP	E  
	JC	SORT1
SORT7:	XCHG
	JMP	SORT2
SORT8:	MVI	A,00BH
	SUB	B
	CMA
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	XCHG
	DAD	B
	MVI	B,FORMFEED		;Form Feed
SORT9:	LDAX	D
	MOV	C,M
	MOV	M,A
	MOV	A,C
SORT10:  STAX	 D
	INX	H
	INX	D
	DCR	B
	JNZ	SORT9
	LHLD	L0509
	MOV	A,H
	CMA
	MOV	D,A
	MOV	A,L
	CMA
	MOV	E,A
	INX	D
	LHLD	L0503
	DAD	D
	SHLD	L0503
SORT11:  EQU	 $-1
	XRA	A
	ORA	H
	JM	SORT5
	ORA	L
	JZ	SORT5
	JMP	SORT3
HEADVAL:LDA	L0502		;Load heading values
	ADI	041H
	STA	FILEH		;File heading
	LHLD	NOP2
	XCHG
	LXI	H,ENTRH 	;Entries heading
	CALL	CALC
HEADV1:  EQU	 $-1
	LHLD	NOP1
	XCHG
	PUSH	D
	LXI	H,ELEFTH	;Entries left heading
	CALL	CALC
	POP	D
	CALL	ENTLEFT
HEADV2: LHLD	NOP11
	DAD	D
	XCHG
	LXI	H,ELEFTH1	;Entries left heading 1
HEADV3:  EQU	 $-1
	CALL	CALC
	LHLD	NOP3
	XCHG
	PUSH	D
	LXI	H,USEDH1	;Used value for space used
	CALL	KADD		;Add K for kilobytes
	POP	D
	CALL	ENTLEFT
	LHLD	NOP9
	DAD	D
	XCHG
	LXI	H,SLEFTH1	;Value and literal for space left
HEADV4: EQU	$-1
	CALL	KADD		;Add K for kilobytes
	LXI	D,0FFFCH
	LXI	B,00003H
	LHLD	NOP2
	DAD	B
	MVI	C,0FFH
HEADV5: INR	C
	DAD	D
	JC	HEADV5
HEADV6: EQU	$-1
	MOV	A,C
	STA	NOP5
HEADV7: EQU	$-2
	MOV	L,A
	MVI	H,000H
	DAD	H
	MOV	D,H
	MOV	E,L
	DAD	H
	DAD	D
	DAD	H
	SHLD	NOP6
	LHLD	NOP4
	MVI	B,050H
	MVI	A,0FFH
PHEAD:	MOV	M,A
	INX	H
	DCR	B
	JNZ	PHEAD
	LXI	D,HEADING	;Load heading for printing
	MVI	C,PSTRING	;Print string on CRT
	CALL	BDOS
	LXI	H,L054D
	SHLD	NOP8
PCOL1:	LXI	H,NOP5
	DCR	M
	JM	ENDMAIN 	;Jump if minus
	LHLD	NOP8
	CALL	PFILENAM
PCOL1A: CPI	0FFH
	MVI	E,07CH		;Column separator
	CNZ	PRINTIT
	MVI	E,020H	
	CALL	PRINTIT
	LHLD	NOP6
	XCHG
	LHLD	NOP8
PCOL2:	EQU	$-1
	DAD	D
	CALL	PFILENAM
	CPI	0FFH
	MVI	E,07CH		;Column separator
	CNZ	PRINTIT
	MVI	E,020H		;Space
	CALL	PRINTIT
	LHLD	NOP6
PCOL2A: XCHG
	LHLD	NOP8
	DAD	D
	DAD	D
	CALL	PFILENAM
	CPI	0FFH
PCOL3:	EQU	$-1
	MVI	E,07CH		;Column separator
	CNZ	PRINTIT
	MVI	E,020H		;Space
	CALL	PRINTIT
PCOL4:	LHLD	NOP6
	XCHG
	LHLD	NOP8
	DAD	D
	DAD	D
	DAD	D
	CALL	PFILENAM
PCOL4A: EQU	$-2
	MVI	E,CR
	CALL	PRINTIT
	MVI	E,LF
	CALL	PRINTIT
	LHLD	NOP8
	LXI	D,0000CH
	DAD	D
	SHLD	NOP8
	MVI	A,0FFH
	CMP	M
	JNZ	PCOL1
ENDMAIN:MVI	C,SELDISK	;Select disk
	LDA	L0501
	MOV	E,A
	LDA	L0502
	CMP	E
	CNZ	BDOS		;Call CP/M if not zero
	LHLD	SPSAVE		;Restore stack pointer
	SPHL
	RET
;
; END OF PROGRAM
;
;
;**************************************************
;	The next 3 subroutines are used to add the
;	values for the space used and left
;	in the heading.
;
;
KADD:	CALL	CALC
	MVI	M,04BH		;K for Kilobytes
	INX	H
	RET
CALC:	MOV	A,D
	ORA	E
	JZ	CALC3
	PUSH	H
	XCHG
	CALL	CNT16
	MOV	C,A
	CALL	CNT16
	MOV	D,L
	MOV	B,A
	MVI	E,000H
	POP	H
	CALL	CALC1
	MOV	D,B
	CALL	CALC1
	MOV	D,C
CALC1:	MOV	A,D
	RRC
	RRC
	RRC
	RRC
	CALL	CALC2
	MOV	A,D
CALC2:	ANI	00FH
	CMP	E
	RZ			;Return if zero status = 1
CALC3:	MVI	E,030H
	ADD	E
	MOV	M,A
	INX	H
	RET
CNT16:	MVI	D,010H		;Set up count of 16
	XRA	A
CNT16A: DAD	H
	ADC	A
	DAA
	JNC	CNT16B
	INX	H
CNT16B: DCR	D
	JNZ	CNT16A
	RET
;
;	These subroutines print the file names, types,
;	and sizes of each file.
;
PFILENAM: MOV	  A,M
	CPI	0FFH
	RZ			;Return if zero status = 1
	MVI	B,008H		;Backspace
	CALL	PRNTFILE
	MVI	E,020H		;Space
PFILETYP:  CALL    PRINTIT
	MVI	B,003H		;End of text
	CALL	PRNTFILE
	MVI	E,020H		;Space
	CALL	PRINTIT
PFILESP:  EQU	  $-2
	MOV	A,M
	CALL	FILESIZE
	MVI	E,04BH		;K for Kilobytes
	CALL	PRINTIT
PFILEND:  MVI	  E,020H	  ;Space
PRINTIT:PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,PCHAR 	;Print character on CRT
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET
;
;
;	This subroutine prints the file name or type
;	with the proper number of spaces
;
PRNTFILE: MOV	  E,M
	INX	H
	CALL	PRINTIT
	DCR	B
	JNZ	PRNTFILE
PRNTFILX:  RET
;
;	This subroutine calculates the display for the
;	size of each file.
;
FILESIZE: MVI	  B,064H
	MVI	D,000H
	CALL	FSIZE2
	MVI	B,LF
	CALL	FSIZE2
FSIZE1:  ADI	 030H
	MOV	E,A
	JMP	PRINTIT
FSIZE2:  MVI	 C,0FFH
FSIZE3:  INR	 C
	SUB	B
	JNC	FSIZE3
	ADD	B
FSIZE4:  PUSH	 PSW
	MOV	A,C
	CMP	D
	JZ	FSIZE5
	DCR	D
	ADI	030H
	JMP	FSIZE6
FSIZE5:  MVI	 A,020H 	 ;Space
FSIZE6: MOV	E,A
	CALL	PRINTIT
	POP	PSW
	RET
;
;	This subroutine is used to display the number
;	of entries left in the heading.
;
ENTLEFT:MOV	A,E
	CMA
	MOV	E,A
	MOV	A,D
	CMA
	MOV	D,A
ENTLEFTX:  INX	   D
	RET
;
;
;	This is the complete layout of the main
;	heading for this program.
;
HEADING:DCR	C
DISKH:	LDAX	B
	MOV	B,H		;D
	MOV	L,C		;i
	MOV	M,E		;s
	MOV	L,E		;k
	LDA	02020H		;:--Colon
FILEH:	EQU	$-2		;File heading
	DB	020H
	DB	020H
	MOV	B,M		;F
	MOV	L,C		;i
FILEH1: MOV	L,H		;l
	MOV	H,L		;e
	MOV	M,E		;s
	LDA	02020H		;:
ENTRH:	EQU	$-2		;Entries heading
	DB	020H
	DB	020H
	DB	020H
	DB	020H
	DB	020H
	MOV	B,L		;E
	MOV	L,M		;n
	MOV	M,H		;t
	MOV	M,D		;r
ENTRH1: MOV	L,C		;i--Entries heading 2
	MOV	H,L		;e
	MOV	M,E		;s
	LDA	02020H		;:
ELEFTH: EQU	$-2		;Entries left heading
	DB	020H
	DB	020H
	DB	028H		;(
ELEFTH1:DB	020H		;Entries left heading 1
	DB	020H
	DB	020H
	DB	020H
	MOV	C,H		;L
	MOV	H,L		;e
	MOV	H,M		;f
	MOV	M,H		;t
SPACH:	DAD	H		;)--Space heading
	DB	020H
	DB	020H
	DB	020H
	MOV	D,E		;S
	MOV	M,B		;p
	MOV	H,C		;a
	MOV	H,E		;c
	MOV	H,L		;e
USEDH:	DB	020H		;Used heading
	MOV	D,L		;U
	MOV	M,E		;s
	MOV	H,L		;e
	MOV	H,H		;d
	LDA	02020H		;:
USEDH1: EQU	$-2		;Used value for space used
	DB	020H
	DB	020H
	DB	020H
SLEFTH: DB	020H		;Value for space left
	DB	028H		;(
SLEFTH1:DB	020H		;Value and literal for space left
	DB	020H
	DB	020H
	DB	020H
	DB	020H
	DB	020H
	MOV	C,H		;L
	MOV	H,L		;e
	MOV	H,M		;f
	MOV	M,H		;t
	DAD	H		;)
	DCR	C
	LDAX	B
	LDAX	B
HEAD13: INR	H
;
;	These are miscellaneous instructions.
;
NOP1:	NOP
	NOP
NOP2:  NOP
       NOP
NOP3:  NOP
       NOP
NOP4:  MOV     C,L
       DCR     B
NOP5:  NOP
NOP6:  NOP
NOP7:  NOP
NOP8:  NOP
       NOP
NOP9:  NOP
       NOP								    
NOP10:	NOP
	NOP
NOP11:	NOP
	NOP
NOP12:	NOP
	NOP
NOP13:	NOP
;
;
L0500:	JMP	00015H
L0501:	EQU	$-2
L0502:	EQU	$-1
L0503:	MOV	A,D
	ANI	038H
L0505:	EQU	$-1
	RRC
L0507:	RRC
	RRC
L0509:	RET
	CALL	HEADV2
SPSAVE: EQU	$-2
	ADD	A
	MOV	C,A
	LXI	H,STACK
	DAD	B
	MOV	C,M
	CALL	00015H
	INX	H
	MOV	C,M
	CALL	00015H
	MVI	C,020H
	CALL	00015H
	JMP	00015H
	CALL	HEADV2
	ANI	006H
	CPI	006H
L052B:	JNZ	SORT10
	MVI	C,053H
	CALL	00015H
	MVI	C,050H
	JMP	00015H
	CALL	0002EH
	LHLD	0000CH
	MOV	A,H
	CALL	SORT11
L0540:	EQU	$-2
L0541:	EQU	$-1
	MOV	A,L
	CALL	SORT11
L0545:	EQU	$-1
	MVI	C,020H		;Space
	CALL	00015H
	CALL	00015H
L054D:	EQU	$-1
	RET
;
;   Subroutine to clear the screen before display
;
CLS:   PUSH    B
       PUSH    D
       PUSH    H
       PUSH    PSW
       MVI     E,1BH	       ;SET REGISTER TO "ESCAPE"
       MVI     C,PCHAR	       ;SET BDOS CRT OUT
       CALL    BDOS	       ;
       MVI     E,'E'	       ;SET REGISTER TO "E"
       MVI     C,PCHAR	       ;SET BDOS CRT OUT
       CALL    BDOS
       POP     PSW
       POP     H
       POP     D
       POP     B
	LXI	H,00000H	;Get monitor stack pointer
       JMP     MAIN1		;Start the program
STACK:
       END
  D
       POP     B
	LXI	H,00000H	;Get monitor stack pointer
       