+ARCHIVE+ abort.c        254  9/28/1984  9:49:32
/*	print a message and abort
*/

#include "stdio.h"

abort(string,arg1)
unsigned char *string,arg1;
{
  int write();

  fprintf(stderr,"\nABORT:- ");
  _fmtout(&write,fileno(stderr),string,&arg1);
  fprintf(stderr,"\n");
  exit(0x7fff);
}
+ARCHIVE+ abstoptr.c     172  9/28/1984  9:49:32
/*	convert an absolute address to a big pointer
*/

unsigned char *abstoptr(address)
unsigned long address;
{

  return (address&0xfL)|((address&0xffff0)<<12L);
}
+ARCHIVE+ alloc.c        251  9/28/1984  9:49:34
/*	allocate memory, zero it, and abort if none
*/

unsigned char *alloc(size)
unsigned size;
{
  unsigned char *cp,*malloc();

  if(cp=malloc(size))setmem(cp,size,0);
  else {
    bdos(9,"ALLOC$");
    _exit(0x8007);
  }
  return cp;
}
+ARCHIVE+ atoi.c         320  9/28/1984  9:49:36
/*	convert ascii to integer (or long)
*/

long atoi(s)
char *s;
{
  long j;
  int sign;

  while(*s==' ' || *s=='\t')++s;	/* skip white space */
  sign=0;
  if(*s=='-')sign=1;
  else if(*s!='+')--s;
  ++s;						/* skip sign data */
  for(j=0;*s>='0' && *s<='9';)j=j*10+(*s++-'0');
  return sign?-j:j;
}
+ARCHIVE+ basicget.c     979  9/28/1984  9:49:36
/*	read line written by basic and split into fields
*/

#include "stdio.h"

basicget(stream,buff,bufflen,fieldptr,fieldcnt)
FILE *stream;			/* where to read it */
unsigned char *buff;		/* where to put it */
int bufflen;			/* max amount to put */
unsigned char *fieldptr[];	/* field pointers */
int fieldcnt;			/* number of fields in line */
{
  unsigned char *cp;
  int j,termchar;
  char *fgets();
  char *index();

  for(j=0;j<fieldcnt;)fieldptr[j++]=0;		/* clear them all */
  if(!fgets(buff,bufflen-2,stream))return -1;	/* seen end of file */
  if(buff[strlen(buff)-1]!='\n')return -2;	/* short record */
  buff[strlen(buff)-1]=0;			/* get rid of \n */
  cp=buff;
  for(j=0;j<fieldcnt;){
    if(*cp=='"'){
      ++cp;
      termchar='"';
    } else termchar=',';
    fieldptr[j++]=cp;
    cp=index(cp,termchar);
    if(!cp)return j;
    if(termchar=='"')*cp++=0;
    *cp++=0;				/* kill the separator */
  }
  return 0;				/* an error */
}
+ARCHIVE+ bdos.asm       375  9/28/1984  9:48:48

	include	model.h

;	call bdos for simple services

	INCLUDE	PROLOGUE.H
	public	bdos
IF	@BIGMODEL
BDOS	PROC	FAR
ELSE
BDOS	PROC	NEAR
ENDIF

	push	bp
	mov	bp,sp
	mov	ah,@AB[bp]
IF	@BIGMODEL
	PUSH	DS
	lds	DX,dword ptr @AB+2[BP]	;**
else
	mov	dx,@AB+2[bp]
ENDIF
	int	21h
IF	@BIGMODEL
	POP	DS
ENDIF
	pop	bp
	ret

BDOS	ENDP
	INCLUDE EPILOGUE.H
	end
+ARCHIVE+ calloc.c       319  9/28/1984  9:49:38
/*	allocate memory and clear it
*/

unsigned char *calloc(nelem,elsize)
unsigned nelem,elsize;
{
  unsigned char *cp,*malloc();
  unsigned long size;

  size=(unsigned long)nelem*(unsigned long)elsize;
  if(size>0xffe8)cp=0;
  else if(cp=malloc((unsigned)size))setmem(cp,(unsigned)size,0);
  return cp;
}
+ARCHIVE+ chdir.c        405  9/28/1984  9:49:40
/*	change directory for dos 2.00
*/

chdir(dir)
char *dir;
{
  struct { int ax,bx,cx,dx,si,di,ds,es; } srv;
  extern int _sysvers;

  if(!_sysvers)return -1;	/* no way under dos 1.1 */
#ifdef _C86_BIG
  srv.ds=((unsigned long)dir)>>16;
#else
  segread(&srv.si);	/* saves additional structure */
#endif
  srv.dx=dir;
  srv.ax=0x3B00;
  if(sysint21(&srv,&srv)&1)return -1;
  return 0;
}
+ARCHIVE+ coreleft.c     468  9/28/1984  9:49:40
/*	return the number of bytes left on the stack
*/

#include "stdio.h"

extern unsigned char *_heaptop;

#ifdef _C86_BIG

extern unsigned long ptrtoabs();

unsigned coreleft(dummy)
unsigned char dummy;
{
  unsigned long temp;

  temp=ptrtoabs(&dummy)-ptrtoabs(_heaptop);
  if(temp>0xffe8L)return 0xffe8;
  return temp;
}

#else

unsigned coreleft(dummy)
unsigned char dummy;
{

  return &dummy-_heaptop;	/* approx core left */
}

#endif
+ARCHIVE+ ctype.c       1446 10/05/1984  8:31:24
/*	ctype.c for C86 v 2.20D
*/
unsigned char _ctypes[256] = {
	0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
	0x80,0x90,0x90,0x80,0x80,0x80,0x80,0x80,
	0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
	0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
	0x30,0x60,0x60,0x60,0x60,0x60,0x60,0x60,
	0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,
	0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,0x4C,
	0x4C,0x4C,0x60,0x60,0x60,0x60,0x60,0x60,
	0x60,0x49,0x49,0x49,0x49,0x49,0x49,0x41,
	0x41,0x41,0x41,0x41,0x41,0x41,0x41,0x41,
	0x41,0x41,0x41,0x41,0x41,0x41,0x41,0x41,
	0x41,0x41,0x41,0x60,0x60,0x60,0x60,0x60,
	0x60,0x4A,0x4A,0x4A,0x4A,0x4A,0x4A,0x42,
	0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,
	0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,
	0x42,0x42,0x42,0x60,0x60,0x60,0x20,0x80,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
} ;

+ARCHIVE+ errno.c         56  9/28/1984  9:49:42
/*	define the error control field
*/

int errno;

+ARCHIVE+ exit.c         198  9/28/1984  9:50:36
/*	do exit processing for a c program
*/

#include "fileio2.h"

exit(val)
int val;
{
  int j;

  for(j=0;j<MAXFILES;++j)if(_opentab[j])close(j);
  _exit(val);			/* thats all folks */
}
+ARCHIVE+ farcall.asm   1408  9/28/1984  9:48:50

	include	model.h

;	execute a far call with registers set up

;	entry	1, offset to call with respect to
;		2, cs to call
;		3, pointer to register values for call
;		4, pointer to area to save returned register values

;	exit 	machine status register value returned as func value

;	structure for register values is
;		struct regval{ unsigned ax,bx,cx,dx,si,di,ds,es;};

	include	prologue.h

if	@BIGMODEL
a1	equ	@ab
a2	equ	@ab+4
a3	equ	@ab+8
else
a1	equ	@ab
a2	equ	@ab+4
a3	equ	@ab+6
endif

	public	farcall

if	@BIGMODEL
farcall	proc	far
else
farcall	proc	near
endif
	push	bp
	mov	bp,sp		;set our arg pointer
	push	ds		;save important register
if	@bigmodel
	lds	bx,dword ptr a2[bp]	;get source data
else
	mov	bx,a2[bp]
endif
	mov	cx,8
mtor01:
	push	word ptr [bx]
	inc	bx
	inc	bx
	loop	mtor01		;push all 8 words
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	call	dword ptr a1[bp]	;go to it
	pushf			;save result flags for return
	push	es
	push	ds
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
if	@bigmodel
	lds	bx,dword ptr a3[bp]
else
	mov	ds,-2[bp];	;get old ds value
	mov	bx,a3[bp]	;where to put it
endif
	mov	cx,8
rtom01:
	pop	word ptr [bx]
	inc	bx
	inc	bx
	loop	rtom01

	pop	ax		;result flags for user
	pop	ds		;restore ds
	pop	bp
	ret			;all done

farcall	endp

	include	epilogue.h
	end
+ARCHIVE+ fgets.c        332  9/28/1984  9:50:36
/*	get an input string from a file
*/

#include "stdio.h"

unsigned char *fgets(line,maxline,buf)
unsigned char *line;
int maxline;
FILE *buf;
{
  int j,cc;

  for(j=0;j<maxline-1;){
    cc=fgetc(buf);
    if(cc==-1)break;
    if((line[j++]=cc)=='\n')break;
  }
  line[j]=0;
  if(j)return line; else return 0;
}
+ARCHIVE+ fprintf.c      254  9/28/1984  9:50:40
/*	print to standard output
*/

#include "stdio.h"

fprintf(buf,control,args)
FILE *buf;
unsigned char *control;		/* the format control string */
unsigned args;
{
  extern int write();

  return _fmtout(&write,fileno(buf),control,&args);
}
+ARCHIVE+ fputs.c        219  9/28/1984  9:50:42
/*	output a string to a stream
*/

#include "stdio.h"

fputs(line,buf)
unsigned char *line;
FILE *buf;
{
  int leng;

  leng=strlen(line);
  if(leng!=write(fileno(buf),line,leng))return -1;
  return 0;
}
+ARCHIVE+ fread.c        474  9/28/1984  9:50:44
/*	read from a file
*/

#include "stdio.h"

fread(where,size,nitems,buf)
unsigned char *where;			/* where to put data */
unsigned size;				/* size of one item in bytes */
unsigned nitems;			/* number of items to read */
FILE *buf;				/* here to get it */
{
  unsigned count,temp;
  
  for(count=0;count<nitems;++count){
    temp=read(fileno(buf),where,size);
    if(!temp)break;
    if(size!=temp){++count;break;}
    where+=size;
  }
  return count;
}
+ARCHIVE+ free.c        3066  9/28/1984  9:49:44
/*	return a free block to the heap
*/

unsigned char *sbrk();

#ifdef _C86_BIG
unsigned char *abstoptr();
unsigned long ptrtoabs();

struct free_list{
  unsigned long fl_addr;	/* address of next entry in free list */
  unsigned long fl_size;	/* size of entry in bytes (plus 4) */
};

struct use_block{
  unsigned ub_addr;		/* address of this block in use */
  unsigned ub_size;		/* size of actual block */
};

#define SFL (sizeof(struct free_list))
#define SUB (sizeof(struct use_block))

extern struct free_list _allocb;/* base block for control purposes */
extern unsigned char *_heaptop;	/* for reset of string break value */

free(fp)
struct use_block *fp;
{
  struct use_block *cp,*cpp,*cppp;
  unsigned long fa,fs;

  fa=ptrtoabs(fp)-SUB;
  fp=abstoptr(fa);			/* make it canonical */
  if((unsigned)fa!=fp->ub_addr){
crash:
    bdos(9,"FREE$");
    _exit(0x8088);
  }
  fs=fp->ub_size;			/* save the size */
  for(cppp=cpp=&_allocb;cp=abstoptr(cpp->fl_addr);cppp=cpp,cpp=cp)
	if(fa<=cpp->fl_addr)break;
  if(fa==cpp->fl_addr)goto crash;
  fp->fl_addr=cpp->fl_addr;		/* put block into free list */
  cpp->fl_addr=fa;
  fp->fl_size=fs;
  if((cpp!=&_allocb)&&(fa==ptrtoabs(cpp)+SUB+cpp->fl_size)){
    cpp->fl_size=cpp->fl_size+SUB+fs;	/* concatinate with prev */
    cpp->fl_addr=fp->fl_addr;
  } else cppp=cpp,cpp=fp;
  if(cp && (ptrtoabs(cp)==ptrtoabs(cpp)+SUB+cpp->fl_size)){
    cpp->fl_size=cpp->fl_size+SUB+cp->fl_size;	/* concatinate with next */
    cpp->fl_addr=cp->fl_addr;
  }
  if(ptrtoabs(_heaptop)==ptrtoabs(cpp)+SUB+cpp->fl_size){
    _heaptop=cpp;	 /* reset _heaptop if possable */
    cppp->fl_addr=0;		
  }
}

#else

struct free_list{
  unsigned char *fl_addr;	/* address of next entry in free list */
  unsigned int fl_size;		/* size of entry in bytes */
};

struct use_block{
  unsigned ub_addr;		/* address of this block in use */
  unsigned ub_size;		/* size of actual block */
};

#define SFL (sizeof(struct free_list))
#define SUB (sizeof(struct use_block))

extern struct free_list _allocb;/* base block for control purposes */
extern unsigned char *_heaptop;	/* for reset of string break value */

free(fp)
struct use_block *fp;
{
  struct use_block *cp,*cpp,*cppp;

  --fp;
  if(fp!=fp->ub_addr){
crash:
    bdos(9,"FREE$");
    _exit(0x8088);
  }
  for(cppp=cpp=&_allocb;cp=cpp->fl_addr;cppp=cpp,cpp=cp)if(fp<=cp)break;
  if(fp==cp)goto crash;
  fp->fl_addr=cpp->fl_addr;		/* put block into free list */
  cpp->fl_addr=fp;
  if((cpp!=&_allocb)&&(fp==((unsigned)cpp)+SUB+cpp->fl_size)){
    cpp->fl_size=cpp->fl_size+SUB+fp->fl_size;	/* concatinate with prev */
    cpp->fl_addr=fp->fl_addr;
  } else cppp=cpp,cpp=fp;
  if(cp && (cp==((unsigned)cpp)+SUB+cpp->fl_size)){
    cpp->fl_size=cpp->fl_size+SUB+cp->fl_size;	/* concatinate with next */
    cpp->fl_addr=cp->fl_addr;
  }
  if(_heaptop==((unsigned)cpp)+SUB+cpp->fl_size){
    _heaptop=(unsigned)cpp;	 /* reset _heaptop if possable */
    cppp->fl_addr=0;		
  }
}

#endif
+ARCHIVE+ freopen.c      283  9/28/1984  9:50:54
/*
	close the file associated with stream and attempt to open
	a new one.
*/
#include <stdio.h>

FILE *freopen(filename,type,stream)
unsigned char *filename,*type;
FILE *stream;
{
FILE *fopen();

  if(fclose(stream)!=0) return NULL;
  return fopen(filename,type);
}

+ARCHIVE+ fscanf.c       202  9/28/1984  9:50:44
/*	read input from a file under format conversion
*/

#include "stdio.h"

fscanf(buf,format,args)
FILE *buf;
unsigned char *format;
unsigned args;
{

  return _fmtin(0,buf,format,&args);
}
+ARCHIVE+ ftell.c        155  9/28/1984  9:50:46
/*	get the current position in a file
*/

#include "stdio.h"

long ftell(buf)
FILE *buf;
{
  extern long fseek();

  return fseek(buf,0L,1);
}
+ARCHIVE+ fwrite.c       423  9/28/1984  9:50:48
/*	write to a file
*/

#include "stdio.h"

fwrite(where,size,nitems,buf)
unsigned char *where;			/* where to get data */
unsigned size;				/* size of one item in bytes */
unsigned nitems;			/* number of items to write */
FILE *buf;				/* where to put it */
{
  unsigned count;

  for(count=0;count<nitems;++count){
    if(size!=write(fileno(buf),where,size))break;
    where+=size;
  }
  return count;
}
+ARCHIVE+ gcdir.c        690  9/28/1984  9:49:46
/*	get current directory for dos 2.00
*/

unsigned char *gcdir(drive)
unsigned char *drive;
{
  struct { int ax,bx,cx,dx,si,di,ds,es; } srv;
  unsigned char *current,*malloc(),temp[67];
  extern int _sysvers;

  if(!_sysvers)return 0;	/* < 2.00 */
#ifdef _C86_BIG
  srv.ds=((unsigned long)temp)>>16;
#else
  segread(&srv.si);
#endif
  srv.si=temp+3;
  if(strlen(drive) && drive[1]==':')srv.dx=(toupper(*drive)-'A')&0x0f;
  else srv.dx=(bdos(0x19)&0xff);
  strcpy(temp," :\\");
  temp[0]=srv.dx+'A';
  srv.ax=0x4700;
  ++srv.dx;
  if(sysint21(&srv,&srv)&1)return 0;
  if(!(current=malloc(strlen(temp)+1)))return 0;
  strcpy(current,temp);
  return current;
}


+ARCHIVE+ gets.c         376  9/28/1984  9:50:48
/*	get an input string from stdin, dropping the newline
*/

#include "stdio.h"

unsigned char *gets(line,maxline)
unsigned char *line;
int maxline;
{
  int j,cc;

  for(j=0;j<maxline-1;){
    cc=fgetc(stdin);
    if((line[j++]=cc)=='\n')break;
    if(cc==-1) {
      if(j==1) return NULL;
      else break;
    }
  }
  if(j)line[j-1]=0;
  return line;
}
+ARCHIVE+ index.c        163  9/28/1984  9:49:46
/*	return cpoiner to first occurrence of character
*/

unsigned char *index(s,c)
unsigned char *s,c;
{
unsigned char *strchr();

  return strchr(s,c);
}
+ARCHIVE+ inportb.asm    432  9/28/1984  9:48:50

	include	model.h

;	read an b bit value from a port

	include	prologue.h

;	input	a port number
;	returns the input byte, zero filled


	public	inportb

if	@bigmodel
inportb	proc	far
else
inportb	proc	near
endif
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,@ab[bp]	;get the port number
	in	al,dx		;get a byte value
	mov	ah,0		;zero the top byte
	pop	bp
	ret
inportb	endp
	include	epilogue.h
	end
+ARCHIVE+ inportw.asm    388  9/28/1984  9:48:52

	include	model.h

;	read an w bit value from a port

	include	prologue.h

;	input	a port number
;	returns the input word


	public	inportw

if	@bigmodel
inportw	proc	far
else
inportw	proc	near
endif
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,@ab[bp]	;get the port number
	in	ax,dx		;get a byte value
	pop	bp
	ret
inportw	endp
	include	epilogue.h
	end
+ARCHIVE+ intrinit.c    2427  9/28/1984  9:49:48
/*	initialise for interrupt processing
	Copyright(C) 1984 Computer Innovations Inc.
*/

#include	"stdio.h"

unsigned char *alloc();

static set_ivec(vecno,offset,segment)
unsigned int vecno,offset,segment;
{
struct { unsigned int ax,bx,cx,dx,si,di,ds,es; } srv;

   srv.ax = 0x2500 | vecno;
   srv.dx = offset;
   srv.ds = segment;
   sysint21(&srv,&srv);
}

/*
	needs function intrserv.asm
*/

struct intrcode{
  unsigned char farcall;	/* contains far call opcode */
  int (*farip)();		/* ip value for far call */
#ifndef _C86_BIG
  unsigned farcs;		/* cs value for far call */
#endif
  unsigned savesp;		/* where we save the sp value */
  unsigned savess;		/* where to save the ss value */
  unsigned stacsize;		/* number of bytes of stack needed */
  unsigned fards;		/* the required ds value */
  int (*farfunc)();		/* function to be executed */
  unsigned int old_ip;		/* ip of current isr */
  unsigned int old_cs;		/* cs of current isr */
};

#define SIZE_IC (sizeof(struct intrcode))

intrinit(func,stack,vecno)
int (*func)();			/* function which will process interrupt */
unsigned stack;			/* # of bytes of stack needed by function */
unsigned vecno;			/* # of vector for interrupt trap */
{
  unsigned char *ustack;
  struct intrcode *icp;
  extern intrserv();			/* our service function */
  struct {int cs,ss,ds,es;} segregs;	/* for getting seg registers */

  segread(&segregs);			/* get cs and ds values */
  icp=alloc(SIZE_IC);			/* this is where interrupt begins */
  icp->farcall=0x9a;			/* direct intersegment call */
  icp->farip=intrserv;			/* addr of interrupt serv routine */
#ifndef _C86_BIG
  icp->farcs=segregs.cs;		/* get cs value */
#endif
  icp->fards=segregs.ds;
  if(stack<0x80)stack=0x80;		/* mdos requires this */
  icp->stacsize=stack;
  icp->farfunc=func;			/* the function we want to execute */

  icp->old_ip = peek(vecno*4,0);	/* save the old ip */
  icp->old_cs = peek(vecno*4+2,0);	/* save the old cs */

#ifdef	_C86_BIG
  set_ivec(vecno,icp);
#else
  set_ivec(vecno,icp,segregs.ds);
#endif
}

/* 
	restore original interrupt 
*/
intrrest(vecno)
unsigned vecno;
{
unsigned int segment,offset;
struct intrcode *icp;

#ifdef	_C86_BIG
   icp = (((unsigned long)peek(vecno*4+2,0))<<16) | peek(vecno*4,0);
#else
   icp = peek(vecno*4,0);
#endif
   set_ivec(vecno,icp->old_ip,icp->old_cs);
   free(icp);
}
+ARCHIVE+ intrserv.asm  1564  9/28/1984  9:48:54

	include	model.h

;	title	'interrupt support package'

;	WARNING	- this code not fully tested but should be close

	include	prologue.h

;	initialisation for this routine provided by intrinit.c


;	when we reach the following entry point
;	we have executed the code created by intrinit
;	and the following conditions are true (we hope)

;	cs is set to our cs value
;	the return address points to a region containing
;		0, place to save sp and ss
;		4, the stack size required
;		6, the data segment value
;		8, the address of the function to execute
;

@code	ends
@datab	segment
	extrn	_heaptop:word
savesize dw	0
@datab	ends
@code	segment

;	entry point for interrupt service routines

ap	equ	8

	public	intrserv

intrserv	proc	far
	push	ds
	push	es
	push	di
	push	bp
	mov	bp,sp		;so we can see stack
	les	di,dword ptr ap[bp]
	mov	es:[di],sp
	mov	es:2[di],ss
	mov	ds,es:6[di]		;set up data segment
if	@bigmodel
	mov	ss,_heaptop+2	;a segment for the stack
else
	mov	ss,es:6[di]		;a segment for the stack
endif
	mov	sp,es:4[di]
	add	sp,savesize
	mov	savesize,sp
	add	sp,_heaptop
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	es
	push	di
	mov	bp,sp
if	@bigmodel
	call	dword ptr es:8[di]
else
	call	word ptr 8[di]
endif
	pop	di
	pop	es
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,es:4[di]		; adjust for subsequent calls
	sub	savesize,sp
	mov	ss,es:2[di]
	mov	sp,es:[di]
	pop	bp
	pop	di
	pop	es
	pop	ds
	add	sp,4
	iret			;all done
intrserv	endp
	include	epilogue.h
	end
+ARCHIVE+ isalnum.c      180  9/28/1984  9:49:50
/*	return true if input character is alphabetic or a digit
*/

isalnum(c)
unsigned char c;
{

  return (('A'<=c && c<='Z') || ('a'<=c && c<='z') || ('0'<=c && c<='9'));
}
+ARCHIVE+ isalpha.c      147  9/28/1984  9:49:50
/*	return true if input character is alphabetic
*/

isalpha(c)
unsigned char c;
{

  return (('A'<=c && c<='Z') || ('a'<=c && c<='z'));
}
+ARCHIVE+ isascii.c      118  9/28/1984  9:49:52
/*	return true if input character is less than 0x80
*/

isascii(c)
unsigned char c;
{

  return (c<0x80);
}
+ARCHIVE+ iscntrl.c      135  9/28/1984  9:49:54
/*	return true if input character is a a control character
*/

iscntrl(c)
unsigned char c;
{

  return (0177==c || c<=037);
}
+ARCHIVE+ isdigit.c      121  9/28/1984  9:49:54
/*	return true if input character is a digit
*/

isdigit(c)
unsigned char c;
{

  return ('0'<=c && c<='9');
}
+ARCHIVE+ isgraph.c      144 10/05/1984  8:38:50
/*	is it a graphic character,  like isprint except false for space
*/
int isgraph(c)
unsigned char c;
{
   return c>040&&c<0176;
}



+ARCHIVE+ islower.c      134  9/28/1984  9:49:56
/*	return true if input character is lower case alphabetic
*/

islower(c)
unsigned char c;
{

  return ('a'<=c && c<='z');
}
+ARCHIVE+ isprint.c      124  9/28/1984  9:49:58
/*	return true if input character is printable
*/

isprint(c)
unsigned char c;
{

  return (040<=c && c<=0176);
}
+ARCHIVE+ ispunct.c      219  9/28/1984  9:49:58
/*	return true if input character is not control or alphanumeric
*/

ispunct(c)
unsigned char c;
{

  return ((040<=c && c<=057)
	|| (072<=c && c<=0100)
	|| (0133<=c && c<=0140)
	|| (0173<=c && c<=0176));
}
+ARCHIVE+ isspace.c      139  9/28/1984  9:50:00
/*	returns true if chararcter is a blank,tab or newline
*/

isspace(cc)
char cc;
{

  return (cc==' ' || cc=='\t' || cc=='\n');
}
+ARCHIVE+ isupper.c      134  9/28/1984  9:50:02
/*	return true if input character is upper case alphabetic
*/

isupper(c)
unsigned char c;
{

  return ('A'<=c && c<='Z');
}
+ARCHIVE+ iswap.c        134  9/28/1984  9:50:02
/*	swap two integers
*/

iswap(a,b)
int *a,*b;		/* address of integers is input */
{
  int j;

  j=*a;
  *a=*b;
  *b=j;
}
+ARCHIVE+ isxdigit.c     142 10/02/1984 13:56:08
/*	is it a hexadecimal character
*/
int isxdigit(c)
int c;
{

   return (c>='0'&&c<='9')||(c>='a'&&c<='f')||(c>='A'&&c<='F');
}



+ARCHIVE+ itoa.c         107  9/28/1984  9:50:04
/*	integer to ascii
*/

itoa(n,cp)
int n;
unsigned char *cp;
{

  return ltos((long)n,cp,-10);
}
+ARCHIVE+ itoh.c         120  9/28/1984  9:50:06
/*	integer to hex conversion
*/

itoh(n,cp)
unsigned n;
unsigned char *cp;
{

  return ltos((long)n,cp,16);
}
+ARCHIVE+ longjmp.asm    794  9/28/1984  9:49:04
;	restore the environment saved by setjmp

	include	model.h
	include	prologue.h

;	entry	1, address of environment
;		2, value to return after restoration

	public	longjmp

if	@bigmodel
longjmp	proc	far
	mov	bp,sp
	mov	ax,6[bp]		;get the return value
	mov	dx,ds			;save ds value
	lds	bx,dword ptr 4[bp]	;get environment address
	mov	sp,[bx]			;get the sp value
	mov	bp,2[bx]
	push	6[bx]			;push the restart address
	push	4[bx]
	mov	ds,dx			;restore ds
	ret
else
longjmp	proc	near
	pop	ax		;dump the return address
	pop	bx		;get address of environment
	pop	ax		;get the return value
	mov	sp,[bx]		;reset the stack pointer
	mov	bp,2[bx]	;and bp
	mov	bx,4[bx]	;get the return address
	jmp	bx		;and away we go.....
endif
longjmp	endp

	include	epilogue.h

	end
+ARCHIVE+ lower.c        193  9/28/1984  9:50:06
/*	convert a string to lower case
*/

unsigned char *lower(cp)
unsigned char *cp;
{
  unsigned char *ct;

  for(ct=cp;*ct;++ct)if(*ct>='A' && *ct<='Z')*ct+=('a'-'A');
  return cp;
}
+ARCHIVE+ ltell.c        161  9/28/1984  9:50:08
/*	return the current file position as a long
*/

long ltell(fd)
unsigned fd;
{
  long lseek();

  return lseek(fd,0L,1);		/* dont need ltell now */
}
+ARCHIVE+ ltoa.c          99  9/28/1984  9:50:08
/*	long to ascii
*/

ltoa(n,cp)
long n;
unsigned char *cp;
{

  return ltos(n,cp,-10);
}
+ARCHIVE+ ltoh.c         124  9/28/1984  9:50:10
/*	long integer to hex conversion
*/

ltoh(n,cp)
unsigned long n;
unsigned char *cp;
{

  return ltos(n,cp,16);
}
+ARCHIVE+ ltos.c         689  9/28/1984  9:50:12
/*	long to string
*/

ltos(val,cp,base)
long val;			/* the number to convert */
unsigned char *cp;		/* the address of the string */
int base;			/* the conversion base */
{
  unsigned char tempc[34],*tcp;
  int n=0;			/* number of characters in result */
  unsigned long uval;		/* unsigned value */
  static unsigned char dig[]={"0123456789ABCDEF"};

  *(tcp=tempc+33)=0;
  if(base<0){			/* needs signed conversion */
    if(val<0)n=1;
    else val=-val;
    do {*--tcp=dig[-(val%base)];} while((val/=-base));
  } else {
    uval=val;
    do {*--tcp=dig[uval%base];} while(uval/=base);
  }
  if(n)*--tcp='-';
  n=tempc+33-tcp;
  movmem(tcp,cp,n+1);
  return n;
}
+ARCHIVE+ makefcb.c     1729  9/28/1984  9:50:12
/*	make a file control block
*/

#include "fileio.h"

extern unsigned char *calloc();

struct cpmfcb *makefcb(filename)
unsigned char *filename;
{
  int u,j;
  struct fcb_str *fcb;
  unsigned char pathname[76],*cp,*pp;

  if(filename[1]==':'){
    u=toupper(*filename);
    if(u<'A' || u>'P')goto err01;
    filename+=2;
  } else u=(bdos(0x19)&0xff)+'A';	/* set default drive */

  strcpy(pathname," :");
  pathname[0]=u;		/* set the drive */
  for(pp=pathname+2;;filename=cp){
    for(cp=filename;*cp && *cp!='\\' && *cp!='/';++cp);
    if(!*cp)break;
    for(j=8,cp=filename;;){
      *pp=toupper(*cp++);
      if(*pp=='\\' || *pp=='/')break;
      if(j)--j,++pp;
    }
    if(pp>pathname+67)goto err01;	/* too far up garden path */
  }
  if(pp>pathname+3)--pp;
  *pp=0;				/* end of path name */

  if(!_sysvers || pp==pathname+2)pathname[0]=0;

  if(!(fcb=calloc(sizeof(struct fcb_str)+strlen(pathname),1)))
		goto err01;/* heap full */
  strcpy(fcb->fcb_path,pathname);

  fcb->fcb_dr=u-('A'-1);		/* set drive number */
  setmem(fcb->fcb_fn,11,' ');			/* space fill fn and ft */
  if(_makefcb(fcb->fcb_fn,8,&filename)||_makefcb(fcb->fcb_ft,3,&filename))
    goto error;
  return fcb;					/* all ok */

error:
  free(fcb);
err01:
  return 0;
}

/*	a service routine for makefcb
*/

_makefcb(outstr,outlen,filename)
unsigned char *outstr,**filename;
int outlen;
{
  unsigned char *cp;
  int u;

  for(cp=*filename;*cp;){		/* do file name */
    u=toupper(*cp++)&0x7f;
    if(u=='.')break;			/* that part done */
    if(u<0x21)return 1;			/* some protection */
    if(outlen){
      --outlen;
      *outstr++=u;
    }
  }
  *filename=cp;
  return 0;
}
+ARCHIVE+ makefnam.c    1199  9/28/1984  9:50:14
/*	split up a file name (subroutine for makefnam)
*/

static _makefn(source,dest)
unsigned char *source;
unsigned char *dest;
{
  int j,k;
  unsigned char *strrchr();

  setmem(dest,82,0);		/* clear result field */
  if(strlen(source)>1 && source[1]==':')for(j=0;j<2;)dest[j++]=*source++;
  j=3;
  while(strrchr(source,'\\')||strrchr(source,'/')){
    for(k=0;(*source!='\\')&&(*source!='/');++source)
		if(j<65 && k++<8)dest[j++]=*source;
    dest[j++] = (*source=='/') ? *source  : '\\';
    ++source;
  }
  for(j=67;*source && *source!='.';++source)if(j<75)dest[j++]=*source;
  for(j=76;*source;++source)if(j<80)dest[j++]=*source;
}

/*	make a file name using a template
*/

unsigned char *makefnam(rawfn,template,result)
unsigned char *rawfn;			/* the original file name */
unsigned char *template;		/* the template data */
unsigned char *result;			/* where to place the result */
{
  unsigned char et[82],er[82];

  _makefn(template,et);
  _makefn(rawfn,er);
  *result=0;			/* assure no data */
  strcat(result,er[0]?er:et);
  strcat(result,er[3]?er+3:et+3);
  strcat(result,er[67]?er+67:et+67);
  strcat(result,er[76]?er+76:et+76);
  return result;
}
+ARCHIVE+ malloc.c      2599  9/28/1984  9:49:42
/*	memory allocator
*/

#ifdef _C86_BIG

unsigned char *sbrk();
unsigned char *abstoptr();
unsigned long ptrtoabs();

struct free_list{
  unsigned long fl_addr;	/* address of next entry in free list */
  unsigned long fl_size;	/* size of entry in bytes (plus 2) */
};

struct use_block{
  unsigned ub_addr;		/* address of this block in use */
  unsigned ub_size;		/* size of actual block */
};

#define SFL (sizeof(struct free_list))
#define SUB (sizeof(struct use_block))

struct free_list _allocb;	/* base block for control purposes */

unsigned char *malloc(rsize)
unsigned rsize;
{
  struct use_block *pp,*cp,*np;
  unsigned size;

  if(rsize>0xffe8)return 0;		/* too large to try for */
  size=(rsize<4)?4:(rsize+1)&0xfffe;	/* force size even for 8086 */
  for(pp=&_allocb;cp=abstoptr(pp->fl_addr);pp=cp){
    if(cp->fl_size>=size){
      if(cp->fl_size>=size+SFL){
	np=abstoptr(pp->fl_addr+size+SUB);
	np->fl_addr=cp->fl_addr;
	np->fl_size=cp->fl_size-size-SUB;
	cp->fl_addr=ptrtoabs(np);
      } else size=cp->fl_size;
      pp->fl_addr=cp->fl_addr;
      break;
    }
  }
  if(cp || (cp=sbrk((size=(size<(SFL-SUB)?(SFL-SUB):size))+SUB))){
    cp->ub_addr=ptrtoabs(cp);
    cp->ub_size=size;
    ++cp;
    if(size>rsize)setmem(((char *)cp)+rsize,size-rsize,0);
  }
  return cp;
}

#else

unsigned char *sbrk();

struct free_list{
  unsigned char *fl_addr;	/* address of next entry in free list */
  unsigned fl_size;		/* size of entry in bytes (plus 2) */
};

struct use_block{
  unsigned ub_addr;		/* address of this block in use */
  unsigned ub_size;		/* size of actual block */
};

#define SFL (sizeof(struct free_list))
#define SUB (sizeof(struct use_block))

struct free_list _allocb;	/* base block for control purposes */

unsigned char *malloc(rsize)
unsigned rsize;
{
  struct use_block *pp,*cp,*np;
  unsigned size;

  if(rsize>0xff00)return 0;		/* too large to try for */
  size=(rsize+1)&0xfffe;			/* force size even for 8086 */
  for(pp=&_allocb;cp=pp->fl_addr;pp=cp){
    if(cp->fl_size>=size){
      if(cp->fl_size>=size+SFL){
	np=pp->fl_addr+size+SUB;
	np->fl_addr=cp->fl_addr;
	np->fl_size=cp->fl_size-size-SUB;
	cp->fl_addr=np;
      } else size=cp->fl_size;
      pp->fl_addr=cp->fl_addr;
      break;
    }
  }
  if(cp || (cp=sbrk(size+SUB))){
    cp->ub_addr=cp;
    cp->ub_size=size;
    ++cp;
    if(size>rsize)setmem(((char *)cp)+rsize,size-rsize,0);
  }
  return cp;
}

#endif
                                                                                      
+ARCHIVE+ movblock.asm  2095  9/28/1984  9:48:54

	include	model.h

;	'move a block of memory'

	include	prologue.h

;	similar to movmem except that
;		1, uses a word move if count, source and dest are all even
;		2, needs segment values for source and dest also
;		3, turns off interrupts for word moves of less than 2 words

;	entry	1, the source address relative to
;		2, the source segment
;		3, the destination address relative to
;		4, the destination segment
;		5, the number of bytes to move (value must not exceed Xffc0)

a1	equ	@ab
a2	equ	@ab+4
a3	equ	@ab+8

	public	movblock

if	@bigmodel
movblock	proc	far
else
movblock	proc	near
endif
	push	bp
	mov	bp,sp
	push	ds
	push	es
	pushf			;and the flags

	mov	si,a1[bp]	;the source address
	mov	bx,si
	mov	cl,4
	shr	bx,cl
	add	bx,a1+2[bp]	;canonical segment for block move

	mov	di,a2[bp]	;the destination address
	mov	dx,di
	mov	cl,4
	shr	dx,cl
	add	dx,a2+2[bp]	;canonical segment for block move

	mov	ax,0fh
	and	si,ax
	and	di,ax		;keep low 4 bits only

	mov	cx,a3[bp]	;the number of bytes to move

	mov	ax,1		;see if we can use word move
	test	ax,cx		;odd number of bytes ?
	jnz	mb01		;yes
	test	ax,si		;odd source address
	jnz	mb01		;yes
	test	ax,di		;odd destination address ?
	jnz	mb01
	xor	ax,ax		;yes we can (flag for later)
mb01:

	cmp	bx,dx		;which way to do the move ?
	jb	mb03
	ja	mb02
	cmp	si,di		;which way to do the move ?
	jb	mb03		;do it in reverse order
mb02:
	cld
	jmp	short mb04		;must be this
mb03:
	add	si,cx		;point to other end of string
	dec	si
	add	di,cx
	dec	di
	std			;backwards in memory
	or	ax,ax		;see if a word move
	jnz	mb04		;nope
	dec	si
	dec	di
mb04:
	mov	ds,bx
	mov	es,dx		;seg regs set up
	or	ax,ax		;check for a word move
	jz	mb05		;do a word move
	rep	movsb		;do the move
	jmp	short mb07
mb05:
	shr	cx,1		;counts words
	cmp	cx,2		;if exactly 2 words
	jnz	mb06
	cli			;turn off interrupts
mb06:
	rep	movsw
mb07:
	popf			;restore flags and interrupts
	pop	es
	pop	ds
	pop	bp
	cld			;more DOS bugs
	ret
movblock	endp

	include	epilogue.h

	end
+ARCHIVE+ movmem.asm    1377  9/28/1984  9:48:56

	include	model.h

;	'move a block of memory'

	include	prologue.h

;	entry	1,the source address
;		2,the destination address
;		3,the number of bytes to move

if	@bigmodel
@ptrlen	equ	4
Else
@ptrlen	equ	2
endif

a1	equ	@ab
a2	equ	a1+@ptrlen
a3	equ	a2+@ptrlen

	public	movmem

if	@bigmodel
movmem	proc	far
else
movmem	proc	near
endif

	push	bp
	mov	bp,sp
if	@bigmodel
	push	ds
	mov	si,word ptr a1[bp]
	mov	ax,word ptr a1+2[bp]
	mov	dx,si			; make it canonical
	shr	dx,1
	shr	dx,1
	shr	dx,1
	shr	dx,1
	add	ax,dx
	and	si,0fh
	mov	ds,ax

	mov	di,word ptr a2[bp]
	mov	bx,word ptr a2+2[bp]
	mov	dx,di
	shr	dx,1
	shr	dx,1
	shr	dx,1
	shr	dx,1
	add	bx,dx
	and	di,0fh
	mov	es,bx

else
	mov	ax,ds		;ensure that extra seg is correct
	mov	es,ax
	mov	si,a1[bp];	;the source address
	mov	di,a2[bp]	;the destination address
endif
	mov	cx,a3[bp]	;the number of bytes to move
if	@bigmodel
	cmp	ax,bx
	jb	movmem01
	ja	movmem00
endif
	cmp	si,di		;which way to do the move ?
	jb	movmem01	;do it in reverse order
movmem00:
	cld
	jmp	short movmem02	;must be this
movmem01:
	add	si,cx		;point to other end of string
	dec	si
	add	di,cx
	dec	di
	std			;backwards in memory
movmem02:
	rep	movsb		;do the move
if	@bigmodel
	pop	ds
endif
	pop	bp
	cld			;more DOS bugs
	ret

movmem	endp

	include	epilogue.h

	end
+ARCHIVE+ open.c         176  9/28/1984  9:50:16
/*	open an existing file
*/

open(filename,mode)
unsigned char *filename;
unsigned mode;
{

  return _open(filename,mode,0);	/* do common open for existing file */
}
+ARCHIVE+ outportb.asm   406  9/28/1984  9:48:56

	include	model.h

;	write an 8 bit value to port

	include	prologue.h

	public	outportb

if	@bigmodel
outportb	proc	far
else
outportb	proc	near
endif
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,@ab[bp]	;get the port number
	mov	ax,@ab+2[bp]	;get the value to output
	mov	ah,0		;zero the top byte
	out	dx,al		;put it out
	pop	bp
	ret
outportb	endp
	include	epilogue.h
	end
+ARCHIVE+ outportw.asm   376  9/28/1984  9:48:58

	include	model.h

;	write an 16 bit value to port

	include	prologue.h

	public	outportw

if	@bigmodel
outportw	proc	far
else
outportw	proc	near
endif
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,@ab[bp]	;get the port number
	mov	ax,@ab+2[bp]	;get the value to output
	out	dx,ax		;put it out
	pop	bp
	ret
outportw	endp
	include	epilogue.h
	end
+ARCHIVE+ peek.asm       490  9/28/1984  9:49:00

	include	model.h

;	peek at a work in memory somewhere

	include	prologue.h

;	entry	1, offset of place to peek
;		2, segment of place to peek

;	exit	ax contains copy of content of memory location

	public	peek

if	@bigmodel
peek	proc	far
else
peek	proc	near
endif
	push	bp
	mov	bp,sp
	push	es		;save the register
	les	si,dword ptr @ab[bp]	;get where
	mov	ax,es:[si]	;get what
	pop	es		;restore es
	pop	bp
	ret			;all done
peek	endp
	include	epilogue.h
	end
+ARCHIVE+ pokeb.asm      544  9/28/1984  9:49:00

	include	model.h

;	poke a byte into memory somewhere

	include	prologue.h

;	entry	1, offset of place to poke
;		2, segment of place to poke
;		3, value to poke (as the low byte of a word)

a1	equ	@ab
a2	equ	a1+4

	public	pokeb

if	@bigmodel
pokeb	proc	far
else
pokeb	proc	near
endif

	push	bp
	mov	bp,sp
	push	es		;save the register
	les	si,dword ptr a1[bp]	;get where
	mov	ax,a2[bp]	;get what
	mov	es:[si],al	;its there
	pop	es		;restore es
	pop	bp
	ret			;all done
pokeb	endp

	include	epilogue.h

	end
+ARCHIVE+ pokew.asm      511  9/28/1984  9:49:02

	include	model.h

;	poke a word into memory somewhere

;	entry	1, offset of place to poke
;		2, segment of place to poke
;		3, value to poke

	include	prologue.h

a1	equ	@ab
a3	equ	@ab+4

	public	pokew

if	@bigmodel
pokew	proc	far
else
pokew	proc	near
endif
	push	bp
	mov	bp,sp
	push	es		;save the register
	les	si,dword ptr a1[bp]	;get where
	mov	ax,a3[bp]	;get what
	mov	es:[si],ax	;its there
	pop	es		;restore es
	pop	bp
	ret			;all done
pokew	endp
	include	epilogue.h
	end
+ARCHIVE+ printf.c       240  9/28/1984  9:50:50
/*	print to standard output
*/

#include "stdio.h"

printf(control,args)
unsigned char *control;		/* the format control string */
unsigned args;
{
  extern int write();

  return _fmtout(&write,fileno(stdout),control,&args);
}
+ARCHIVE+ ptrtoabs.c     168  9/28/1984  9:50:16
/*	convert a pointer to an absolute address
*/

unsigned long ptrtoabs(offset,segment)
unsigned offset;
unsigned segment;
{

  return (segment<<4L)+offset;
}
+ARCHIVE+ puts.c         262  9/28/1984  9:50:52
/*	output a string to stdout adding a newline
*/

#include "stdio.h"

puts(line)
unsigned char *line;
{
  int leng;

  leng=strlen(line);
  if(leng!=write(fileno(stdout),line,leng))return -1;
  if('\n'!=fputc('\n',stdout))return -1;
  return 0;
}
+ARCHIVE+ qsort.c       1351  9/28/1984  9:50:18
/*	Hores quicksort algorithm
*/

#define DEPTH 20		/* should be adequate for most sorts */

static swapbyte(a,b,count)
unsigned char *a,*b;
unsigned count;
{
  int temp;

  while(count--){
    temp=*a;
    *a++=*b;
    *b++=temp;
  }
}

qsort(base,n,width,cmpf)
unsigned char *base;		/* base of data */
unsigned int n;			/* number of items to sort */
unsigned width;			/* width of an element */
int (*cmpf)();			/* key comparison function */
{
  unsigned j,k,pivot,count,low[DEPTH],high[DEPTH];

  if(n<2)return;		/* already sorted */
  count=1;			/* do initialisation */
  low[0]=0;
  high[0]=n-1;
  while(count--){
    pivot=low[count];
    j=pivot+1;
    n=k=high[count];
    while(j<k){
      while(j<k && (*cmpf)(base+j*width,base+pivot*width)<1)++j;
      while(j<=k && (*cmpf)(base+pivot*width,base+k*width)<1)--k;
      if(j<k)swapbyte(base+(j++*width),base+(k--*width),width);
    }
    if((*cmpf)(base+pivot*width,base+k*width)>0)
	swapbyte(base+pivot*width,base+k*width,width);
    if(k>pivot)--k;
    if(k>pivot && n>j && (k-pivot < n-j)){
      swapbyte(&k,&n,2);
      swapbyte(&pivot,&j,2);
    }
    if(k>pivot){
      low[count]=pivot;
      high[count++]=k;
    }
    if(n>j){
      low[count]=j;
      high[count++]=n;
    }
    if(count>=DEPTH)abort("qsort failure");
  }
}
+ARCHIVE+ realloc.c     2062  9/28/1984  9:50:20
/*	reallocate a block of memory
*/

#ifdef _C86_BIG

struct free_list{
  unsigned long fl_addr;	/* address of next entry in free list */
  unsigned long fl_size;	/* size of entry in bytes (plus 4) */
};

struct use_block{
  unsigned ub_addr;		/* address of this block in use */
  unsigned ub_size;		/* size of actual block */
};

unsigned char *abstoptr(),*malloc();

#else

struct free_list{
  unsigned char *fl_addr;	/* address of next entry in free list */
  unsigned int fl_size;		/* size of entry in bytes */
};

struct use_block{
  unsigned ub_addr;		/* address of this block in use */
  unsigned ub_size;		/* size of actual block */
};

unsigned char *malloc();

#endif

#define SFL (sizeof(struct free_list))
#define SUB (sizeof(struct use_block))

extern struct free_list _allocb;/* base block for control purposes */
extern unsigned char *_heaptop;	/* for reset of string break value */

unsigned char *realloc(cp,size)
unsigned char *cp;
unsigned size;
{
  unsigned char *rp;
  unsigned oldsize=0;
#ifdef _C86_BIG
  unsigned long temp=0;
#endif

  size=(size+1)&0xfffe;			/* set size even */
  if(!cp)goto is_new;			/* nothing to free */
  oldsize=(cp-SUB)->ub_size;
#ifdef _C86_BIG
  temp=cp->fl_addr;			/* save 4 bytes of user data */
#endif
  free(cp);				/* free the old block */
  cp-=SUB;				/* point to beginning of block */
#ifdef _C86_BIG
  for(rp=abstoptr(_allocb.fl_addr)
		;rp && rp->fl_size<size;rp=abstoptr(rp->fl_addr));
#else
  for(rp=_allocb.fl_addr;rp && rp->fl_size<size;rp=rp->fl_addr);
#endif
  if(rp && rp!=cp){
#ifdef _C86_BIG
    if(size>sizeof(temp))movmem(cp+SFL,rp+SFL,size-sizeof(temp));
#else
    movmem(cp+SUB,rp+SUB,size);
#endif
    cp=rp;
  }
is_new:
  if(rp=malloc(size)){			/* get the new block */
    if(size<oldsize)oldsize=size;
    if(oldsize && cp+SUB!=rp)movmem(cp+SUB,rp,oldsize);
    if(size>oldsize)setmem(rp+oldsize,size-oldsize,0);
#ifdef _C86_BIG
    rp->fl_addr=temp;			/* restore users data */
#endif
  }
  return rp;
}
+ARCHIVE+ rewind.c       170  9/28/1984  9:50:56

#include <stdio.h>
/*	
	rewind: position to beginning of file.
*/
long rewind(stream)
FILE *stream;
{
extern long fseek();

  return fseek(stream,0L,0);
}

+ARCHIVE+ rindex.c       166  9/28/1984  9:50:20
/*	return a pointer to the last occurrence of char
*/

unsigned char *rindex(s,c)
unsigned char *s,c;
{
  unsigned char *strrchr();
  return strrchr(s,c);
}
+ARCHIVE+ sbrk.c        1280  9/28/1984  9:50:38
/*	sbrk	get some memory from the system
*/

/*	the following two values are defined in $main
*/

extern unsigned char *_heaptop;	/* the end of heap address */
extern unsigned int _STAKMEM;	/* min stack space to leave */

#ifdef _C86_BIG

extern unsigned char *abstoptr();
extern unsigned long ptrtoabs();

unsigned char *sbrk(size)
unsigned size;			/* max allocation just less than 64K */
{
  unsigned long sb;

  if(size>0xfff0)return 0;	/* request too large to fit */
  size=(size+1)&0xfffe;		/* make size even for 8086 cpu */
  sb=ptrtoabs(_heaptop);	/* convert to 20 bit absolute address */
  if(sb+size>=ptrtoabs(&size)-_STAKMEM)return 0;	/* request denied */
  _heaptop=abstoptr(sb+size);	/* save the new _heaptop value */
  return abstoptr(sb);
}

#else

unsigned char *sbrk(size)
unsigned size;			/* max allocation just less than 64K */
{
  unsigned char *res;

  if(size>(-512))return 0;		/* much too big */
  size=(size+1)&0xfffe;			/* make size even for 8086 cpu */
  if(((unsigned char *)&size)-_heaptop<size+_STAKMEM)return 0;	/* too big */
  res=_heaptop;				/* save the result address */
  _heaptop+=size;			/* save the new _heaptop value */
  return res;
}

#endif
                                                        +ARCHIVE+ scanf.c        183  9/28/1984  9:50:52
/*	read input under format control from stdin
*/

#include "stdio.h"

scanf(format,args)
unsigned char *format;
unsigned args;
{

  return _fmtin(0,stdin,format,&args);
}
+ARCHIVE+ segread.asm    840  9/28/1984  9:49:04

	include	model.h

;	'read the segment registers'

	include	prologue.h

;	entry	1, the address of a 4 word structure to hold the seg values
;
;	the format of the region is
;	struct regs {
;		unsigned cs;
;		unsigned ss;
;		unsigned ds;
;		unsigned es;
;	};

	public	segread

if	@bigmodel
segread	proc	far
	push	bp
	mov	bp,sp
	mov	ax,ds			;save the ds value
	lds	si,dword ptr @ab[bp]	;get the address of save area
	mov	dx,@ab-2[bp]		;get callers cs value
	mov	[si],dx			;set the cs value
	mov	2[si],ss
	mov	4[si],ax		;the ds value
	mov	6[si],es
	mov	ds,ax			;restore ds
	pop	bp
	ret
else
segread	proc	near
	mov	si,sp		;get argument
	mov	si,@ab-2[si]	;pointer to data
	mov	[si],cs
	mov	2[si],ss
	mov	4[si],ds
	mov	6[si],es
	ret			;all done you bet
endif
segread	endp

	include	epilogue.h

	end
+ARCHIVE+ setjmp.asm     892  9/28/1984  9:49:16
;	save the environment for later restoration by longjmp

	include	model.h
	include	prologue.h

;	entry	1, address of a buffer to save the environment

;	exit	ax contains zero

	public	setjmp

if	@bigmodel

setjmp	proc	far
	pop	si		;offset
	pop	di		;segment 
	pop	bx		;environment offset 
	pop	es		;environment segment 
	sub	sp,4		;to the right place 
	mov	es:[bx],sp	;save the sp 
	mov	es:2[bx],bp	;and bp 
	mov	es:4[bx],si	;return offset 
	mov	es:6[bx],di	;return segment 
	push	di 
	push	si 
	xor	ax,ax		;return a zero
	ret
else
setjmp	proc	near
	pop	si		;get the return address
	pop	bx		;get the address of save area
	push	bx		;but keep it for later
	mov	[bx],sp		;save sp in block
	mov	2[bx],bp	;and bp
	mov	4[bx],si	;and the return address
	xor	ax,ax		;always returns zero
	jmp	si		;and we are done
endif
setjmp	endp

	include	epilogue.h

	end
+ARCHIVE+ setmem.asm     712  9/28/1984  9:49:06

	include	model.h

;	'set memory to a specified character'

	INCLUDE	PROLOGUE.H

;	entry	1,the address of first character to be set
;		2,the number of bytes to set (unsigned int)
;		3,the desired value

	public	setmem

IF	@BIGMODEL
SETMEM	PROC	FAR
ELSE
SETMEM	PROC	NEAR
ENDIF
	push	bp
	mov	bp,sp
IF	@BIGMODEL
	LES	DI,DWORD PTR @AB[BP]
	MOV	CX,@AB+4[BP]
	MOV	AL,@AB+6[BP]
ELSE
	mov	ax,ds		;ensure that extra seg is correct
	mov	es,ax
	mov	di,@AB[BP]	;the address to set
	mov	cx,@AB+2[bp]	;the number of bytes to set
	mov	al,@AB+4[bp]	;the value to set
ENDIF
	cld			;and clear the direction flag
	rep	stosb		;set the area
	pop	bp
	ret

SETMEM	ENDP
	INCLUDE	EPILOGUE.H
	end

+ARCHIVE+ sprintf.c      931  9/28/1984  9:50:22
/*	format data to a memory string
*/

#include "stdio.h"

#ifdef _C86_BIG

static int j;
static unsigned char **starr[5];

static store(to,from,leng)
unsigned to;
unsigned char *from;
unsigned leng;
{

  movmem(from,*starr[to],leng);
  *starr[to]+=leng;
  **starr[to]=0;		/* terminate for safety */
}

sprintf(string,control,args)
unsigned char *string;
unsigned char *control;
unsigned args;
{
  int r;

  starr[j]=&string;
  if(j>4){
    bdos(9,"SPRINTF$");
    _exit(0xFFF0);
  }
  r=_fmtout(&store,j++,control,&args);
  --j;
  return r;
}

#else


static store(to,from,leng)
unsigned char **to;
unsigned char *from;
unsigned leng;
{

  movmem(from,*to,leng);
  *to+=leng;
  **to=0;		/* terminate for safety */
}

sprintf(string,control,args)
unsigned char *string;
unsigned char *control;
unsigned args;
{

  return _fmtout(&store,&string,control,&args);
}

#endif
+ARCHIVE+ sscanf.c       412  9/28/1984  9:50:24
/*	format a string in memory
*/

union ptr_union{
  char *scp;
  unsigned char *ucp;
  int *sip;
  unsigned *uip;
  long *slp;
  unsigned long *ulp;
  float *sfp;
  double *sdp;
};

sscanf(string,format,arg)
unsigned char *string;		/* source of data */
unsigned char *format;		/* control string */
union ptr_union arg;		/* our conversion args */
{

  return _fmtin(1,string,format,&arg);
}
+ARCHIVE+ strcat.asm    1245  9/28/1984  9:49:08
;	concatinate two strings

	include	model.h
	include	prologue.h

;	enter	1, the destination address
;		2, the source address

;	exit	the address of the destination string

	public	strcat

if	@bigmodel
strcat	proc	far
else
strcat	proc	near
endif
	cld			;set in the direction of up
	push	bp
	mov	bp,sp

if	@bigmodel
	push	ds		;save it
	les	di,dword ptr @ab+4[bp]	;get source address
	lds	si,dword ptr @ab+4[bp]	;for later
else
	mov	di,ds
	mov	es,di
	mov	di,@ab+2[bp]	;get source address
	mov	si,di		;for later
endif
	xor	ax,ax		;get the length of string
	xor	cx,cx		;set the counter
	dec	cx		;to 64k
	repnz	scasb		;till zero
	not	cx		;number of bytes to move
	mov	dx,cx		;save for later

if	@bigmodel
	les	di,dword ptr @ab[bp]	;get destination address
else
	mov	di,@ab[bp]	;get destination address
endif
	xor	cx,cx		;set the counter
	dec	cx		;to 64k
	repnz	scasb		;till zero
	dec	di		;over-write the zero

	mov	cx,dx		;restore count

	test	cl,1		;odd number to move ?
	jz	nope
	lodsb
	stosb			;doit
nope:
	shr	cx,1
	rep	movsw		;move them
	mov	ax,@ab[bp]	;return dest address
if	@bigmodel
	mov	dx,es
	pop	ds		;restore ds
endif
	pop	bp
	ret
strcat	endp

	include	epilogue.h

	end
+ARCHIVE+ strchr.c       218  9/28/1984  9:50:58

#include <stdio.h>

/*
   return a pointer to first occurrence of c in s
   or NULL if not found
*/
unsigned char *strchr(s,c)
unsigned char *s,c;
{

  while(*s)if(*s++==c)return --s;
  return NULL;
}

+ARCHIVE+ strcmp.asm    1127  9/28/1984  9:49:08
;	compare 2 strings

	include	model.h
	include	prologue.h

;	enter	1, string address 1 (a)
;		2, string address 2 (b)

;	exit	-1 if a<b; 0 if a==b; +1 if a>b

	public	strcmp

if	@bigmodel
strcmp	proc	far
else
strcmp	proc	near
endif
	cld			;set in the direction of up
	push	bp
	mov	bp,sp
if	@bigmodel
	les	di,dword ptr @ab+4[bp]	;get source address
else
	mov	di,ds
	mov	es,di
	mov	di,@ab+2[bp]	;get source address
endif
	xor	ax,ax		;get the length of string
	xor	cx,cx		;set the counter
	dec	cx		;to 64k
	repnz	scasb		;till zero
	not	cx		;number of bytes to compare
if	@bigmodel
	push	ds
	les	di,dword ptr @ab+4[bp]
	lds	si,dword ptr @ab[bp]
else
	mov	di,@ab+2[bp]
	mov	si,@ab[bp]
endif
	test	cl,1		;odd number to compare ?
	jz	nope
	cmpsb
	jnz	setax1		;thats it then
nope:
	shr	cx,1
	repe	cmpsw		;do the compare
	jz	alldone		;they are equal
	sub	si,2
	sub	di,2
	cmpsb
	jnz	setax1
	cmpsb
setax:	jz	alldone
setax1:	jg	upone
	dec	ax
	jmp	alldone
upone:	inc	ax
alldone:
if	@bigmodel
	pop	ds		;restore ds
endif
	pop	bp
	ret
strcmp	endp

	include	epilogue.h

	end
+ARCHIVE+ strcpy.asm     989  9/28/1984  9:49:10
;	copy a string

	include	model.h
	include	prologue.h

;	enter	1, the destination address
;		2, the source address

;	exit	the address of the destination string

	public	strcpy

if	@bigmodel
strcpy	proc	far
else
strcpy	proc	near
endif
	cld			;set in the direction of up
	push	bp
	mov	bp,sp
if	@bigmodel
	les	di,dword ptr @ab+4[bp]	;get source address
else
	mov	di,ds
	mov	es,di
	mov	di,@ab+2[bp]	;get source address
endif
	xor	ax,ax		;get the length of string
	xor	cx,cx		;set the counter
	dec	cx		;to 64k
	repnz	scasb		;till zero
	not	cx		;number of bytes to move
if	@bigmodel
	push	ds
	lds	si,dword ptr @ab+4[bp]
	les	di,dword ptr @ab[bp]
else
	mov	si,@ab+2[bp]
	mov	di,@ab[bp]
endif
	test	cl,1		;odd number to move ?
	jz	nope
	lodsb
	stosb			;doit
nope:
	shr	cx,1
	rep	movsw		;move them
	mov	ax,@ab[bp]	;return dest address
if	@bigmodel
	mov	dx,es
	pop	ds		;restore ds
endif
	pop	bp
	ret
strcpy	endp

	include	epilogue.h

	end
+ARCHIVE+ strlen.asm     625  9/28/1984  9:49:12
;	return the length of a string

	include	model.h
	include	prologue.h

;	enter	1, the address of the string

;	exit	the length of the string in reg ax (unsigned integer)

	public	strlen

if	@bigmodel
strlen	proc	far
else
strlen	proc	near
endif
	cld			;set in the direction of up
	push	bp
	mov	bp,sp
if	@bigmodel
	les	di,dword ptr @ab[bp]	;get pointer
else
	mov	di,ds
	mov	es,di
	mov	di,@ab[bp]	;get the address of the string
endif
	xor	ax,ax
	xor	cx,cx		;set the counter
	dec	cx		;to 64k
	repnz	scasb		;till zero
	sub	ax,2
	sub	ax,cx
	pop	bp
	ret
strlen	endp

	include	epilogue.h

	end
+ARCHIVE+ strncat.c      301  9/28/1984  9:50:24
/*	concatinate string t to string s, max n characters
*/

unsigned char *strncat(s,t,n)
unsigned char *s,*t;
unsigned n;
{
  unsigned char *cp;

  for(cp=s;*cp++;);			/* find end of string */
  for(--cp;n-- && (*cp++=*t++););	/* do the concatinate */
  if(n==0xffff)*cp=0;
  return s;
}
+ARCHIVE+ strncmp.c      263  9/28/1984  9:50:26
/*	string compare up to n characters
	(remove the "unsigned" for signed collating set)
*/

strncmp(s,t,n)
unsigned char *s,*t;
unsigned n;
{

  for(;n-- && (*s==*t);t++)if(!*s++)return 0;
  if(n==0xffff)return 0;
  if(*s<*t)return -1;
  return 1;
}
+ARCHIVE+ strncpy.c      241  9/28/1984  9:50:28
/*	copy a string into a buffer n characters in length
*/

unsigned char *strncpy(to,from,n)
unsigned char *to,*from;
unsigned n;
{
  unsigned char *cp;

  for(cp=to;n && (*cp++=*from++);--n);
  while(n--)*cp++=0;
  return to;
}
+ARCHIVE+ strpbrk.c      389  9/28/1984  9:51:00

/*
	returns a pointer to the first occurrence in string s1
	of any character from string s2, or NULL if no character
	from s2 exists in s1
*/

#include <stdio.h>

unsigned char *strpbrk(s1,s2)
unsigned char *s1,*s2;
{
unsigned char *strchr();
unsigned char *cp;
		  

   for(;*s1!=NULL;++s1);{
     if((cp=strchr(s2,*s1))!=NULL)
	return cp;
   }
   return NULL;
}

+ARCHIVE+ strrchr.c      236  9/28/1984  9:51:00

#include <stdio.h>
/*
   return a pointer to last occurrence of c in s
   or NULL if not found
*/
unsigned char *strrchr(s,c)
unsigned char *s,c;
{
  unsigned char *cp;

  for(cp=NULL;*s;++s)if(*s==c)cp=s;
  return cp;
}
+ARCHIVE+ sysint.asm    2330  9/28/1984  9:49:12

	include	model.h

;	execute an interrupt with registers set up

	include	prologue.h

;	entry	1, the interrupt vector ( *4  for absolute address )
;		2, pointer to register values for call
;		3, pointer to area to save returned register values

;	exit 	machine status register value returned as func value

;	structure for register values is
;		struct regval{ unsigned ax,bx,cx,dx,si,di,ds,es;};

if	@BIGMODEL
a1	equ	@ab+4
a2	equ	@ab+6
a3	equ	@ab+10
ELSE
a1	equ	@ab+4
a2	equ	@ab+6
a3	equ	@ab+8
ENDIF

	public	sysint

if	@bigmodel
sysint	proc	far
else
sysint	proc	near
endif

	cld			;for dos 2.0

	push	ds		;save important registers
	push	es
	push	bp
	mov	bp,sp		;set our arg pointer

	mov	bl,a1[bp]	;get interrrupt number
	cmp	bl,025h
	jz	sysinta
	cmp	bl,026h
	jz	sysinta
	push	ax		;dummy on stack for return
sysinta:

	pushf			;push the flags for return
	pop	dx		;make a copy of flags
	push	dx
	push	cs		;and the code segment
	call	dummy		;push the ip
dummy:
	pop	ax		;get ip value
	sub	ax,offset dummy
	add	ax,offset sysint1
	push	ax		;return address
	and	dh,0ch		;clear I and T flag bits
	push	dx
	xor	bx,bx		;clear bx
	mov	es,bx		;and es
	mov	bl,a1[bp]	;get int trap number
	shl	bx,1		;*2
	shl	bx,1		;*2 again (thats 4)
	push	es:word ptr 2[bx]
	push	es:word ptr [bx]		;thats the entry data
IF	@BIGMODEL
	LES	BX,dword ptr A2[BP]
ELSE
	mov	bx,a2[bp]	;get source registers
ENDIF

	mov	cx,8		;move values to registers
mtor01:
IF	@BIGMODEL
	PUSH	WORD PTR ES:[BX]
ELSE
	push	word ptr [bx]
ENDIF
	inc	bx
	inc	bx
	loop	mtor01		;push all 8 words
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	iret			;simulate an interrupt
sysint1:
	mov	bp,sp		;restore bp
	pushf			;save result flags for return

	push	es		;get returned register values
	push	ds
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
IF	@BIGMODEL
	LES	BX,dword ptr A3+2[BP]
ELSE
	mov	bx,a3+2[bp]		;get destination address
ENDIF
	mov	cx,8
rtom01:
IF	@BIGMODEL
	POP	ES:WORD PTR [BX]
ELSE
	pop	ss:word ptr [bx]
ENDIF
	inc	bx
	inc	bx
	loop	rtom01

	pop	ax		;result flags for user
	pop	bp		;dump rubbish from stack
	pop	bp
	pop	es
	pop	ds		;restore segment registers
	ret			;all done
sysint	endp

	include	epilogue.h

	end
+ARCHIVE+ sysint21.asm  1589  9/28/1984  9:49:14

	include	model.h

;	execute an interrupt with registers set up

	include	prologue.h

;	entry	1, pointer to register values for call
;		2, pointer to area to save returned register values

;	exit 	machine status register value returned as func value

;	structure for register values is
;		struct regval{ unsigned ax,bx,cx,dx,si,di,ds,es;};

if	@bigmodel
a2	equ	@ab+4
a3	equ	@ab+8
else
a2	equ	@ab+4
a3	equ	@ab+6
endif

	public	sysint21

if	@bigmodel
sysint21	proc	far
else
sysint21	proc	near
endif
	cld			;set in direction of up for dos 2.00
	push	ds		;save important registers
	push	es
	push	bp
	mov	bp,sp		;set our arg pointer
if	@bigmodel
	les	bx,dword ptr a2[bp]
else
	mov	bx,a2[bp]	;get source registers
endif
	mov	cx,8		;move values to registers
mtor01:
if	@bigmodel
	push	word ptr es:[bx]
else
	push	word ptr [bx]
endif
	inc	bx
	inc	bx
	loop	mtor01		;push all 8 words
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	int	21h		;do the interrupt
sysint1:
	mov	bp,sp		;restore bp
	pushf			;save result flags for return

	push	es		;get returned register values
	push	ds
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
if	@bigmodel
	les	bx,dword ptr a3[bp]
else
	mov	bx,a3[bp]		;get destination address
endif
	mov	cx,8
rtom01:
if	@bigmodel
	pop	es:word ptr [bx]
else
	pop	ss:word ptr [bx]
endif
	inc	bx
	inc	bx
	loop	rtom01

	pop	ax		;result flags for user
	pop	bp
	pop	es
	pop	ds		;restore segment registers
	ret			;all done
sysint21	endp

	include	epilogue.h

	end
+ARCHIVE+ toascii.c       76  9/28/1984  9:50:56

unsigned char toascii(c)
unsigned char c;
{
   return c&0x7f;
}


+ARCHIVE+ tolower.c      133  9/28/1984  9:50:28
/*	convert character to lowercase if upper case */

tolower(c)
char c;
{

  if('A'<=c && c<='Z')c+=('a'-'A');
  return c;
}
+ARCHIVE+ toupper.c      133  9/28/1984  9:50:30
/*	convert character to uppercase if lower case */

toupper(c)
char c;
{

  if('a'<=c && c<='z')c+=('A'-'a');
  return c;
}
+ARCHIVE+ upper.c        193  9/28/1984  9:50:32
/*	convert a string to upper case
*/

unsigned char *upper(cp)
unsigned char *cp;
{
  unsigned char *ct;

  for(ct=cp;*ct;++ct)if(*ct>='a' && *ct<='z')*ct+=('A'-'a');
  return cp;
}
+ARCHIVE+ utoa.c         138  9/28/1984  9:50:32
/*	unsigned integer to ascii
*/

utoa(val,str)
unsigned val;
unsigned char *str;
{

  return ltos((unsigned long)val,str,10);
}
+ARCHIVE+ wqsort.c      1091  9/28/1984  9:50:34
/*	Hores quicksort algorithm
*/

#define DEPTH 20		/* should be adequate for most sorts */

wqsort(n,cmpf,xchgf,base)
unsigned int n;			/* number of items to sort */
int (*cmpf)();			/* key comparison function */
int (*xchgf)();			/* record exchange function */
unsigned char *base;		/* base of data */
{
  unsigned j,k,pivot,count,low[DEPTH],high[DEPTH];

  if(n<2)return;		/* already sorted */
  count=1;			/* do initialisation */
  low[0]=0;
  high[0]=n-1;
  while(count--){
    pivot=low[count];
    j=pivot+1;
    n=k=high[count];
    while(j<k){
      while(j<k && (*cmpf)(j,pivot,&base)<1)++j;
      while(j<=k && (*cmpf)(pivot,k,&base)<1)--k;
      if(j<k)(*xchgf)(j++,k--,&base);
    }
    if((*cmpf)(pivot,k,&base)>0)(*xchgf)(pivot,k,&base);
    if(k>pivot)--k;
    if(k>pivot && n>j && (k-pivot < n-j)){
      iswap(&k,&n);
      iswap(&pivot,&j);
    }
    if(k>pivot){
      low[count]=pivot;
      high[count++]=k;
    }
    if(n>j){
      low[count]=j;
      high[count++]=n;
    }
    if(count>=DEPTH)abort("wqsort failure");
  }
}
+ARCHIVE+ ydefault.c     477  9/28/1984  9:50:40
/*	SET RUN TIME DEFAULT VALUES
*/

#ifdef _C86_BIG
int _MAXFMEM=0x1800;		/* MAXIMUM STACK+HEAP REQUIRED */
unsigned _BUFSIZE=2048;	/* BUFFER SIZE IN BIG MODEL	 */
#else
int _MAXFMEM=0x1000;		/* MAXIMUM STACK+HEAP REQUIRED */
unsigned _BUFSIZE=1024;	/* BUFFER SIZE IN SMALL MODEL */
#endif

int _MINFMEM=0x200;		/* MINIMUM STACK+HEAP REQUIRED */
int _MINRMEM=01;		/* RESERVED AT TOP OF MEM */
int _STAKMEM=512;		/* MIN STACK IN SBRK BEFORE REFUSING ALLOC */



+ARCHIVE+ yexit.asm     1645  9/28/1984  9:49:18

	include	model.h

;	THIS IS THE END OF A 'C' PROGRAM

	INCLUDE	PROLOGUE.H

@DATAC	SEGMENT
	EXTRN	_PSPSEG:DWORD,_SYSVERS:WORD
	PUBLIC	_EXITTBC

	DB	0AH,0DH
_EXITTBC	DB	0,0,0,0
IF	@BIGMODEL
	DB	':0000'
ENDIF
	DB	'$'

@DATAC	ENDS

	public	_exit

IF	@BIGMODEL
_EXIT	PROC	FAR
ELSE
_EXIT	PROC	NEAR
ENDIF
	push	bp
	mov	bp,sp
	mov	ax,@AB[bp]	;get the exit value
	mov	bX,word ptr DGROUP:_exittbc	;get trace back control byte
	or	bl,bl
	jz	tb_none		;traceback is off
	js	tb_go		;do it
	or	ax,ax		;any error returned
	jz	tb_none		;nope
tb_go:
	push	ax		;save the exit value
tb_loop:
IF	@BIGMODEL
	MOV	DX,@AB-4[BP]	;GET THE OFFSET
	LEA	BX,DGROUP:_EXITTBC+5
	CALL	WTOH
ENDIF
	MOV	DX,@AB-2[BP]
	LEA	BX,DGROUP:_EXITTBC
	CALL	WTOH
	LEA	DX,DGROUP:_EXITTBC-2
	mov	ah,9
	int	21h
	OR	BP,BP
	JZ	TB_DONE
	cmp	[bp],bp
	jbe	tb_done
	mov	bp,[bp]		;up the stack
	jmp	SHORT tb_loop
tb_done:
	pop	ax		;restore ax
tb_none:
	mov	bx,DGROUP:_sysvers	;new exit for v2.00
	or	bl,bl
	JZ	TB_OLD		;ITS BELOW 2.0
	mov	ah,4ch		;ver 2 all done
	int	21h

;	TERMINATE PROGRAM FOR VERSIONS BELOW 2.0

TB_OLD:
	lea	si,DGROUP:_pspseg
	jmp	dword ptr [si]
; the above two lines of code should be the following line
;	JMP	dword ptr DGROUP:_PSPSEG	;A FAR JUMP DOES IT

_EXIT	ENDP

;	CONVERT WORD TO HEX

WTOH	PROC	NEAR
	MOV	SI,4		;DIGITS PER WORD
WTOH01:
	mov	al,dl		;get a digit
	mov	cl,4
	shr	dx,cl		;strip the digit
	and	al,0fh		;keep low nibble
	add	al,090h
	daa
	adc	al,040h
	daa
	dec	si		;count the digit
	mov	[bx+si],al	;store the digit
	jnz	WTOH01
	RET
WTOH	ENDP

	INCLUDE	EPILOGUE.H
	end
+ARCHIVE+ zentry.asm     781  9/28/1984  9:48:38
	include	model.h

;	stack check function
;	used for debugging by setting the '-t' switch in cc3

	extrn	_heaptop:word

	include	prologue.h

@code	ends
@datai	segment
fullmess	db	'NO CORE$'
@datai	ends
@code	segment

	public	$entry

if	@bigmodel
	extrn	_exit:far
$entry	proc	far
	mov	ax,_heaptop
	mov	cl,4
	shr	ax,cl
        add     ax,dgroup:_heaptop+2
	mov	dx,sp
	mov	cl,4
	shr	dx,cl
	mov	cx,ss
	add	dx,cx
	sub	dx,8			;result is 80h bytes
	cmp	dx,ax
	jbe	full	
else
	extrn	_exit:near
$entry	proc	near
	mov	ax,sp
	cmp	ax,80h
	jbe	full
	sub	ax,80h
	cmp	ax,_heaptop
	jbe	full
endif

	ret
full:
	mov	ah,9
	mov	dx,offset DGROUP:fullmess
	int	21h
	mov	ax,80f0h
	push	ax
	call	_exit
	jmp	full

$entry	endp
	include	epilogue.h
	end
+ARCHIVE+ zfcall.asm     369  9/28/1984  9:48:38

	include	model.h

;	does calls via pointers for the big model

	include	prologue.h

	public	$fcall

$fcall	proc	far
	pop	ax		;get the return address
	pop	dx
	pop	bx		;get the call address
	pop	cx
	push	dx		;put the return address
	push	ax
	push	cx		;put the call address
	push	bx
	ret			;a very indirect call
$fcall	endp
	include	epilogue.h
	end
+ARCHIVE+ ziswitch.asm   681  9/28/1984  9:48:40

	include	model.h

;	code to process an integer switch statement

	include	prologue.h

;	entry	1, value to compare

	public	$iswitch

if	@bigmodel
$iswitch	proc	far
else
$iswitch	proc	near
endif

	pop	di			; get data offset
if	@bigmodel
	pop	es
else
	mov	ax,cs
	mov	es,ax
endif
	pop	ax			; and value to check
	mov	cx,es:[di]		;number of entries
	mov	bx,cx			;for exit
	sal	bx,1
	add	di,bx		;the last shall be first
	inc	cx		;for the default
	std			;set the direction flag
	repne scasw		;compare it
	add	di,4
	add	di,bx
	push	es
	push	es:[di]
	cld			;more DOS bugs
	mov	ax,ds
	mov	es,ax
	ret

$iswitch	endp

	include	epilogue.h

	end

+ARCHIVE+ zldivmod.asm  1855  9/28/1984  9:48:42

	include	model.h

;	does division of two signed longs

	include	prologue.h

a1	equ	@ab+10
a2	equ	@ab+14

	public	$lsdiv,$ludiv,$lsmod,$lumod

if	@bigmodel
$lsdiv	proc	far
else
$lsdiv	proc	near
endif
	push	ax
	xor	al,al			;signed div
	jmp	short dm01
$lsdiv	endp

if	@bigmodel
$ludiv	proc	far
else
$ludiv	proc	near
endif
	push	ax
	mov	al,1			;unsigned div
	jmp	short dm01
$ludiv	endp

if	@bigmodel
$lsmod	proc	far
else
$lsmod	proc	near
endif
	push	ax
	mov	al,2			;signed mod
	jmp	short dm01
$lsmod	endp

if	@bigmodel
$lumod	proc	far
else
$lumod	proc	near
endif
	push	ax
	mov	al,3

dm01:

	push	bx
	push	cx
	push	dx
	push	si
	push	bp
	mov	bp,sp
	push	di			;save for caller
	cbw				;zero top byte
	xchg	ax,bx			;save flags

	mov	ax,a1[bp]
	mov	dx,a1+2[bp]
	mov	si,a2[bp]
	mov	di,a2+2[bp]

	test	bl,1			;signed ?
	jnz	dm03			;nope
	or	dx,dx
	jns	dm02
	neg	dx
	neg	ax
	sbb	dx,0
	inc	bh
dm02:
	or	di,di
	jns	dm03
	neg	di
	neg	si
	sbb	di,0
	xor	bh,3
dm03:
	push	bx
	mov	cx,32		;loop counter
	xor	bx,bx		;set to zero
	push	bx
dm04:
	xchg	cx,-6[bp]	;get back dividend
	sal	ax,1		;left 1 bit
	rcl	dx,1
	rcl	bx,1
	rcl	cx,1
	cmp	di,cx		;will it go
	ja	dm06		;nope
	jb	dm05		;yes
	cmp	si,bx		;maybe
	ja	dm06
dm05:
	sub	bx,si
	sbb	cx,di
	inc	ax		;bit to result
dm06:
	xchg	cx,-6[bp]	;check loop counter
	loop	dm04
	pop	si		;get remainder
	pop	cx		;get control
	test	cl,2		;if mod, result to ax,dx
	jz	dm07
	xchg	ax,bx
	mov	dx,si
	test	ch,2
	jz	dm07
	xor	ch,1		;invert bit
dm07:
	test	cl,1		;signed ?
	jnz	dm08		;nope
	test	ch,1		;reverse sign ?
	jz	dm08		;nope
	neg	dx
	neg	ax
	sbb	dx,0
dm08:
	mov	a2[bp],ax
	mov	a2+2[bp],dx

	pop	di
	pop	bp
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret	4

$lumod	endp

	include	epilogue.h

	end
+ARCHIVE+ zllshift.asm   703  9/28/1984  9:48:42

	include	model.h

;	long left shift

	include	prologue.h

;	entry	1, shift count
;		2, the value to be shifted

;	exit	shifted value on stack

a1	equ	@ab
a2	equ	@ab+4

	public	$llshift

if	@bigmodel
$llshift	proc	far
else
$llshift	proc	near
endif

	push	bp
	mov	bp,sp
	push	cx
	push	dx
	push	ax
	mov	cx,a1[bp]
	jcxz	lls09			;don't shift anything
	cmp	cx,32			;max number of bits
	jbe	lls01			;valid
	mov	cx,32			;set to maximum
lls01:
	mov	ax,a2[bp]
	mov	dx,a2+2[bp]
lls02:
	shl	ax,1
	rcl	dx,1
	loop	lls02			;do it for all bits
	mov	a2[bp],ax
	mov	a2+2[bp],dx
lls09:
	pop	ax
	pop	dx
	pop	cx
	pop	bp
	ret	4

$llshift	endp

	include	epilogue.h

	end
+ARCHIVE+ zlmul.asm      718  9/28/1984  9:48:44

	include	model.h

;	multiply two longs

	include	prologue.h

;	entry	1,two longs on the stack
;	exit	1,result on stack, other long popped from stack

a1	equ	@ab[bp]
a2	equ	@ab+4[bp]

	public	$lmul

if	@bigmodel
$lmul	proc	far
else
$lmul	proc	near
endif

	push	bp
	mov	bp,sp
	push	ax
	push	dx
	mov	ax,a2+2		;get high
	mul	word ptr a1	;* low
	mov	a2+2,ax		;partial result
	mov	ax,a1+2		;other high
	mul	word ptr a2	;other low
	add	a2+2,ax		;more partial result
	mov	ax,a1		;low
	mul	word ptr a2	;other low
	mov	a2,ax		;result
	add	a2+2,dx		;finish partial result
	pop	dx
	pop	ax
	pop	bp		;get back frame pointer
	ret	4		;dump one long

$lmul	endp

	include	epilogue.h

	end
+ARCHIVE+ zlrsshft.asm   705  9/28/1984  9:48:46

	include	model.h

;	long right signed shift

;	entry	2, value to be shifted
;		1, shift count

;	exit	shifted value in stack, shift count destroyed

	include	prologue.h

	public	$lrsshift

if	@bigmodel
$lrsshift	proc	far
else
$lrsshift	proc	near
endif
	push	bp
	mov	bp,sp
	push	ax
	push	dx
	push	cx
	mov	ax,@ab+4[bp]
	mov	dx,@ab+6[bp]
	mov	cx,@ab[bp]
	jcxz	lrs09			;don't shift anything
	cmp	cx,32			;max number of bits
	jbe	lrs01			;valid
	mov	cx,32			;set to maximum
lrs01:
	sar	dx,1
	rcr	ax,1
	loop	lrs01			;do it for all bits
lrs09:
	mov	@ab+4[bp],ax
	mov	@ab+6[bp],dx
	pop	cx
	pop	dx
	pop	ax
	pop	bp
	ret	4

$lrsshift	endp

	include	epilogue.h

	end
+ARCHIVE+ zlrushft.asm   739  9/28/1984  9:48:46

	include	model.h

;	long right unsigned shift

	include	prologue.h

;	entry	1, number of bits to shift (as a long for now)
;		2, long to shift

;	exit	shifted value on stack

a1	equ	@ab
a2	equ	@ab+4

	public	$lrushift

if	@bigmodel
$lrushift	proc	far
else
$lrushift	proc	near
endif

	push	bp
	mov	bp,sp
	push	cx
	push	dx
	push	ax
	mov	cx,a1[bp]
	jcxz	lru09			;don't shift anything
	cmp	cx,32			;max number of bits
	jbe	lru01			;valid
	mov	cx,32			;set to maximum
lru01:
	mov	ax,a2[bp]
	mov	dx,a2+2[bp]
lru02:
	shr	dx,1
	rcr	ax,1
	loop	lru02			;do it for all bits
	mov	a2[bp],ax
	mov	a2+2[bp],dx
lru09:
	pop	ax
	pop	dx
	pop	cx
	pop	bp
	ret	4

$lrushift	endp

	include	epilogue.h

	end
+ARCHIVE+ zmain.asm     5835  9/28/1984  9:49:16
;	title	'c86 basic support package'

;	this is the starting point for all C programs
;	modified for dos 2.0

	include	model.h

;	following is copy of prologue.h
;	this is included so you can vary the assume statement
;	this will allow the creation of 8080 and modified big model formats

;	define the following to be true for 8080 (.com) file

@COMFILE	EQU	FALSE
IF	@COMFILE
IF	@BIGMODEL
ABORT-THERE IS NO WAY THIS IS REASONABLE
ENDIF
ENDIF

;	DEFINE ARGUMENT BASE RELATIVE FROM BP

IF	@BIGMODEL
@AB	EQU	6
ELSE
@AB	EQU	4
ENDIF

@CODE	SEGMENT BYTE PUBLIC 'CODE'
@CODE	ENDS
@DATAB	SEGMENT PARA PUBLIC 'DATAB'
@DATAB	ENDS
@DATAC	SEGMENT BYTE PUBLIC 'DATAC'
@sb	label	byte
@sw	label	word
@DATAC	ENDS
@DATAI	SEGMENT BYTE PUBLIC 'DATAI'
@ib	label	byte
@iw	label	word
@DATAI	ENDS
@DATAT	SEGMENT BYTE PUBLIC 'DATAT'
@DATAT	ENDS
@DATAU	SEGMENT BYTE PUBLIC 'DATAU'
@ub	label	byte
@uw	label	word
@DATAU	ENDS
@DATAV	SEGMENT BYTE PUBLIC 'DATAV'
@DATAV	ENDS

IF	@COMFILE
DGROUP	GROUP	@CODE,@DATAB,@DATAC,@DATAI,@DATAT,@DATAU,@DATAV
ELSE
DGROUP	GROUP	@DATAB,@DATAC,@DATAI,@DATAT,@DATAU,@DATAV
ENDIF

@CODE	SEGMENT BYTE PUBLIC 'CODE'

IF	@COMFILE
	ASSUME	CS:@DGROUP,DS:DGROUP
	ORG	100H
ELSE
	ASSUME	CS:@CODE,DS:DGROUP
ENDIF


;	END OF PROLOGUE.h

@code	ends

;	add stack and heap segments

@HEAP	SEGMENT WORD PUBLIC 'HEAP'
@HEAPBASE	LABEL	BYTE
@HEAP	ENDS

IFE	@COMFILE
@STACK	SEGMENT	PARA STACK 'STACK'
	DW	128 DUP (?)
@STACK	ENDS
ENDIF

@DATAB	SEGMENT
	DW	0		;DATA SEGMENT CAN NOT START AT ZERO
@DATAB	ENDS

@DATAC	SEGMENT

	public	_systype,_sysvers,_PSPSEG,_heaptop,_SYSENDP

;	the following identifies the base operating system

_systype	dw	1	;o/s type (ms-dos)
_sysvers	dw	0	;o/s version (low byte 0 if < dos 2.00 )
_SYSENDP	DW	0	;LENGTH OF PROG IN PARAGRAPHS
if	@bigmodel
_heaptop 	DW	@UDEND+2,seg @udend	;pointer to base of heap
else
_heaptop 	DW	OFFSET DGROUP:@UDEND+2	;pointer to base of heap
endif

COREMES	DB	0AH,0DH,'NO CORE$'

_PSPSEG	DD	0		;32 BIT POINTER TO THE PROG SEG PREFIX

@DATAC	ENDS
@DATAT	SEGMENT
@UDBEGIN	LABEL	BYTE
@DATAT	ENDS
@DATAV	SEGMENT
@UDEND		LABEL	BYTE
@DATAV	ENDS
@DATAI	SEGMENT
	EXTRN	_MINFMEM:WORD,_MAXFMEM:WORD,_MINRMEM:WORD
@DATAI	ENDS


IF	@BIGMODEL
	EXTRN	_MAIN:FAR,_EXIT:FAR
@code	segment
ELSE
@code	segment
	EXTRN	_MAIN:NEAR,_EXIT:NEAR
ENDIF

$MAIN	PROC	FAR
	JMP	SHORT BEGIN

;	PLACED HERE FOR SHORT JUMP PROBLEMS

NOCORE:
	MOV	DX,OFFSET DGROUP:COREMES
	MOV	AH,9
	INT	21H
	MOV	AX,-1		;SAY BAD ERROR
	PUSH	AX
	CALL	_EXIT		;NEVER RETURNS

	public	$main

;	$main	entry point for c programs

BEGIN:	esc	1ch,bx			;reset the 8087 if any
	cld				;just in case
IFE	@COMFILE
	MOV	AX,DGROUP
	MOV	DS,AX			;SET UP DS REGISTER
ENDIF
	MOV	WORD PTR DGROUP:_PSPSEG+2,ES	;SAVE THE PROG SEG PREFIX
	MOV	AX,ES:2			;GET TOP OF CORE IN PARA UNITS
	CMP	AX,DGROUP:_MINRMEM	;IS RESERVED MEMORY AVAILABLE ?
	JBE	NOCORE			;NOPE
	SUB	AX,DGROUP:_MINRMEM	;SO RESERVE IT

IFE	@BIGMODEL
	MOV	DI,DS			;LIMIT SIZE TO 64 K
	ADD	DI,1000H		;PARAGRAPHS IN 64K
	CMP	DI,AX			;MORE MEMORY THAN WE NEED ?
	JAE	DM01			;NOPE
	MOV	AX,DI			;RESET IT
DM01:
ENDIF

IF	@COMFILE
	MOV	SI,OFFSET @HEAP
	ADD	SI,15
	SHR	SI,1
	SHR	SI,1
	SHR	SI,1
	SHR	SI,1
	MOV	CX,DS
	ADD	SI,CX
ELSE
	MOV	SI,@HEAP		;GET PARA OF HEAP
ENDIF
	CMP	SI,AX			;IS HEAP ABOVE 'TOP OF MEM' ?
	JAE	NOCORE			;YEP
	SUB	AX,SI			;# OF FREE PARAGRAPHS
	CMP	AX,DGROUP:_MINFMEM	;GOT OUR MINIMUM
	JB	NOCORE			;NOPE
	CMP	AX,DGROUP:_MAXFMEM	;GOT TOO MUCH ?
	JBE	DM02			;NOPE
	MOV	AX,DGROUP:_MAXFMEM	;RESET IT
DM02:
	ADD	SI,AX			;GET THE NEW STACK TOP PARAGRAPH
	MOV	DI,DS			;GET THE DATA SEG
	MOV	AX,SI
	SUB	AX,DI			;GET TOT NUMBER OF PARAS
	CMP	AX,1000H		;DOES IT EXCEED 1 SEGMENT
	JBE	DM03			;NOPE
	MOV	AX,1000H		;USE THE WHOLE STACK
	SUB	SI,AX			;AND THIS IS THE SS VALUE WE NEED
	MOV	DI,SI			;IN THE CORRECT PLACE
DM03:
	mov	si,ax			;save stack size
	MOV	CL,4
	SHL	AX,CL			;SCALE THE SP VALUE
	PUSHF				;GET THE FLAGS
	POP	CX			;IN A SAFE PLACE
	CLI				;TURN OFF INTERRUPTS
	MOV	SS,DI			;RESET SS
	MOV	SP,AX			;AND THE STACK POINTER
	XOR	BP,BP			;CLEAR BP
	PUSH	BP
	MOV	BP,SP
	PUSH	CX
	POPF				;RESTORE FLAGS AND INTERRUPTS

;	get the operating system version (for version dependant i/o)

	push	es		;so we don't forget it
	add	di,si		;get end paragraph address
	push	di		;save for later
	mov	ah,30h
	int	21h
	or	al,al
	jnz	isv2		;is a ver 2.00 system
	xor	ah,ah		;reset ah too if below 2.00
	pop	bx		;dump the end of prog paragraph
isv2:
	mov	DGROUP:_sysvers,ax
	jz	notv2

;	set length of program for use of memory after program

	pop	bx
	pop	ax		;get seg of psp
	mov	es,ax		;in es too
	sub	bx,ax		;get length of program
	MOV	_SYSENDP,BX	;SAVE FOR USER	
	push	es
	mov	ah,4ah
	int	21h
	jnc	notv2		; all okay
	MOV	_SYSENDP,BX	; reset the length of program

notv2:
	mov	bx,ds			;save the ds value
	pop	ds			;get the prog seg prefix value
	push	ss
	pop	es			;set dest
	mov	si,80h			;command line offset
	mov	cl,[si]			;get command line count
	add	cl,3
	and	cx,0feh			;force count even
	sub	sp,cx			;get stack pointer value
	mov	di,sp
	rep	movsb			;move the string
	mov	ds,bx			;restore ds
	mov	ax,sp
if	@bigmodel
	push	ss
endif
	push	ax			;set pointer to command line **

;	clear the uninitialized global storage region

	mov	es,bx			;set es to data seg value
	MOV	DI,OFFSET DGROUP:@UDBEGIN
	MOV	CX,OFFSET DGROUP:@UDEND
	SUB	CX,DI			;GET THE NUMBER OF BYTES
	XOR	AX,AX
	REP	STOSB			;CLEAR THE AREA

;	call the routine DGROUP:_main to do other initialisation

	call	_main			;enter c system at 'DGROUP:_main'
	push	ax			;PUT THE EXIT VALUE
	call	_EXIT			;ALL DONE NOW, this never returns

$MAIN	ENDP
	INCLUDE	EPILOGUE.H
	end	$MAIN
